/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar;

import com.badlogic.gdx.utils.BufferUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Audio.HMIMIDIP;
import ru.m210projects.Build.Audio.Sound;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Script.CueScript;
import ru.m210projects.Tekwar.Main;
import ru.m210projects.Tekwar.Player;
import ru.m210projects.Tekwar.Tekprep;
import ru.m210projects.Tekwar.Tektag;
import ru.m210projects.Tekwar.Types.Songtype;
import ru.m210projects.Tekwar.Types.Soundtype;

public class Teksnd {
    public static final int MAXSOUNDS = 256;
    public static final int TOTALSOUNDS = 208;
    public static final int MAXBASESONGLENGTH = 44136;
    public static final int AVAILMODES = 3;
    public static final int SONGSPERLEVEL = 3;
    public static final int NUMLEVELS = 7;
    public static Resource fhsongs = null;
    public static Songtype songptr;
    public static int[] songlist;
    public static int totalsongsperlevel;
    public static Resource fhsounds;
    public static final int AMBUPDATEDIST = 4000;
    public static ByteBuffer[] pSfx;
    public static Soundtype[] dsoundptr;
    public static int[] digilist;
    public static int currTrack;
    public static String[] cdtracks;

    public static void searchCDtracks() {
        for (FileEntry file : BuildGdx.compat.getDirectory(Compat.Path.Game).getFiles().values()) {
            byte[] data;
            if (!file.getExtension().equals("cue") || (data = BuildGdx.compat.getBytes(file)) == null) continue;
            CueScript cdTracks = new CueScript(file.getName(), data);
            cdtracks = cdTracks.getTracks();
            int numtracks = cdtracks.length;
            for (int i = 0; i < cdtracks.length; ++i) {
                if (BuildGdx.cache.contains(cdtracks[i], 0)) continue;
                Teksnd.cdtracks[i] = null;
                --numtracks;
            }
            if (numtracks <= 0) continue;
            Console.Println(numtracks + " cd tracks found...");
            return;
        }
        ArrayList<FileEntry> tracks = new ArrayList<FileEntry>();
        for (FileEntry file : BuildGdx.compat.getDirectory(Compat.Path.Game).getFiles().values()) {
            if (!file.getExtension().equals("ogg")) continue;
            tracks.add(file);
        }
        if (tracks.size() != 0) {
            int numtracks = tracks.size();
            cdtracks = new String[numtracks];
            for (int i = 0; i < numtracks; ++i) {
                Teksnd.cdtracks[i] = ((FileEntry)tracks.get(i)).getPath();
            }
            Console.Println(numtracks + " cd tracks found...");
            return;
        }
        Console.Println("Cd tracks not found.");
    }

    public static void sndInit() {
        if (Main.tekcfg.maxvoices < 4) {
            Main.tekcfg.maxvoices = 4;
        }
        if (BuildGdx.audio.getSound().init(Sound.SystemType.Stereo, Main.tekcfg.maxvoices, Main.tekcfg.resampler_num)) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Sound, Main.tekcfg.soundVolume);
        } else {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Sound) + " initialization failed", Console.OSDTEXT_RED);
        }
        if (!BuildGdx.audio.getMusic().init()) {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Music) + " initialization failed", Console.OSDTEXT_RED);
        }
        if (fhsongs == null) {
            Teksnd.setupmidi();
        }
        if (fhsounds == null) {
            Teksnd.setupdigi();
        }
    }

    public static boolean midRestart() {
        Teksnd.sndStopMusic();
        if (!BuildGdx.audio.getMusic().init()) {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Music) + " initialization failed", Console.OSDTEXT_RED);
            return false;
        }
        return true;
    }

    public static void sndHandlePause(boolean gPaused) {
        if (gPaused) {
            if (Teksnd.songptr.handle != null) {
                Teksnd.songptr.handle.pause();
            }
            BuildGdx.audio.getSound().stopAllSounds();
        } else if (!Main.tekcfg.muteMusic && Teksnd.songptr.handle != null) {
            Teksnd.songptr.handle.resume();
        }
    }

    public static void sndStopMusic() {
        if (Teksnd.songptr.handle != null) {
            Teksnd.songptr.handle.stop();
        }
        Teksnd.songptr.buffer = null;
        currTrack = -1;
    }

    public static void setupmidi() {
        fhsongs = BuildGdx.cache.open("SONGS", 0);
        if (fhsongs == null) {
            Main.game.ThrowError("setupmidi: cant open songs");
        }
        fhsongs.seek(-4096L, Resource.Whence.End);
        for (int i = 0; i < 1024; ++i) {
            Teksnd.songlist[i] = fhsongs.readInt();
        }
        songptr = new Songtype();
        totalsongsperlevel = 9;
    }

    public static void menusong(int insubway) {
        int index = 63;
        if (insubway != 0) {
            index = 66;
        }
        Teksnd.songptr.offset = songlist[(index += 2) * 3] * 4096;
        Teksnd.songptr.length = songlist[index * 3 + 1];
        if (Teksnd.songptr.length >= 44136) {
            Main.game.ThrowError("prepsongs: basesong exceeded max length");
        }
        Teksnd.playsong();
    }

    public static boolean playCDtrack(int nTrack) {
        if (Main.game.isCurrentScreen(Main.gMissionScreen) || Main.tekcfg.musicType == 0 || nTrack < 0) {
            return false;
        }
        nTrack = Gameutils.BClipRange(nTrack, 1, cdtracks.length);
        if (Teksnd.songptr.handle != null && Teksnd.songptr.handle.isPlaying() && currTrack == nTrack) {
            return true;
        }
        if (cdtracks != null && cdtracks[nTrack - 1] != null && (Teksnd.songptr.handle = BuildGdx.audio.newMusic(BuildAudio.MusicType.Digital, cdtracks[nTrack - 1])) != null) {
            Teksnd.sndStopMusic();
            currTrack = nTrack;
            Teksnd.songptr.handle.play(true);
            return true;
        }
        return false;
    }

    public static void startmusic(int level) {
        if (level > 6) {
            return;
        }
        int index = totalsongsperlevel * level;
        Teksnd.songptr.offset = songlist[index * 3] * 4096;
        Teksnd.songptr.length = songlist[index * 3 + 1];
        if (Teksnd.songptr.length >= 44136) {
            Main.game.ThrowError("prepsongs: basesong exceeded max length");
        }
        Teksnd.playsong();
    }

    public static int playsong() {
        if (!Main.tekcfg.muteMusic) {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, Main.tekcfg.musicVolume);
        } else {
            BuildGdx.audio.setVolume(BuildAudio.Driver.Music, 0.0f);
        }
        Teksnd.sndStopMusic();
        if (cdtracks != null && Teksnd.playCDtrack((int)(Math.random() * (double)cdtracks.length))) {
            return 1;
        }
        if (Teksnd.songptr.length == 0) {
            return 0;
        }
        if (Teksnd.songptr.buffer == null) {
            fhsongs.seek(Teksnd.songptr.offset, Resource.Whence.Set);
            byte[] buffer = new byte[Teksnd.songptr.length];
            int rv = fhsongs.read(buffer);
            Teksnd.songptr.buffer = HMIMIDIP.hmpinit(buffer);
            if (Teksnd.songptr.buffer == null || rv != Teksnd.songptr.length) {
                Main.game.ThrowError("playsong: bad read");
            }
        }
        Teksnd.songptr.handle = BuildGdx.audio.newMusic(BuildAudio.MusicType.Midi, Teksnd.songptr.buffer);
        if (Teksnd.songptr.handle != null) {
            Teksnd.songptr.handle.play(true);
            return 1;
        }
        return 0;
    }

    public static void setupdigi() {
        int i;
        fhsounds = BuildGdx.cache.open("sounds", 0);
        if (fhsounds == null) {
            Main.game.ThrowError("setupdigi: cant open sounds");
        }
        fhsounds.seek(-4096L, Resource.Whence.End);
        for (i = 0; i < 1024; ++i) {
            Integer var = fhsounds.readInt();
            if (var == null) {
                Main.game.ThrowError("setupdigi: bad read of digilist");
                return;
            }
            Teksnd.digilist[i] = var;
        }
        for (i = 0; i < 256; ++i) {
            Teksnd.dsoundptr[i] = new Soundtype();
            Teksnd.dsoundptr[i].type = (short)2;
            Teksnd.dsoundptr[i].sndnum = -1;
        }
    }

    public static void updatesounds(int snum) {
        if (Main.tekcfg.noSound || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        BuildGdx.audio.getSound().setListener(Player.gPlayer[snum].posx, Player.gPlayer[snum].posz >> 4, Player.gPlayer[snum].posy, (int)Player.gPlayer[snum].ang);
        for (int i = 0; i < 256; ++i) {
            if (Teksnd.dsoundptr[i].hVoice == null || (Teksnd.dsoundptr[i].type & 0x85) != 0) continue;
            if (Teksnd.dsoundptr[i].hVoice.isLooping()) {
                if (Teksnd.dsoundptr[i].loop > 0.0f) {
                    Teksnd.dsoundptr[i].loop = Teksnd.dsoundptr[i].loop >= BuildGdx.graphics.getDeltaTime() ? (Teksnd.dsoundptr[i].loop -= BuildGdx.graphics.getDeltaTime()) : 0.0f;
                }
                if (Teksnd.dsoundptr[i].loop == 0.0f) {
                    Teksnd.dsoundptr[i].hVoice.setLooping(false, 0, 0);
                    Teksnd.stopsound(i);
                    return;
                }
            }
            int dist = Math.abs(Player.gPlayer[snum].posx - Teksnd.dsoundptr[i].x) + Math.abs(Player.gPlayer[snum].posy - Teksnd.dsoundptr[i].y);
            int vol = 39000 - (dist << 2);
            if (Teksnd.dsoundptr[i].type == 96) {
                vol = dist < 4000 ? 32000 - (dist << 3) : 0;
            } else if (dist < 1500) {
                vol = Short.MAX_VALUE;
            } else if (dist > 8500) {
                vol = 7936;
            }
            vol = Gameutils.BClipRange((int)((float)vol / 32767.0f * 255.0f), 0, 255);
            Teksnd.dsoundptr[i].hVoice.setVolume((float)vol / 255.0f);
        }
    }

    public static int playsound(int sn, int sndx, int sndy, int loop, int type) {
        int i;
        if (!BuildGdx.audio.IsInited(BuildAudio.Driver.Sound) || Main.tekcfg.noSound || sn < 0 || sn >= 208) {
            return -1;
        }
        for (i = 0; i < 256; ++i) {
            if (Teksnd.dsoundptr[i].hVoice == null || Teksnd.dsoundptr[i].hVoice.isActive()) continue;
            Teksnd.stopsound(i);
        }
        if ((type & 0x168) != 0) {
            for (i = 0; i < 256; ++i) {
                if (Teksnd.dsoundptr[i].hVoice == null || Teksnd.dsoundptr[i].hVoice != null && !Teksnd.dsoundptr[i].hVoice.isActive() || Teksnd.dsoundptr[i].sndnum != sn) continue;
                if ((type & 0x100) != 0) {
                    Teksnd.stopsound(i);
                }
                return -1;
            }
        }
        int sound = 0;
        while (Teksnd.dsoundptr[sound].hVoice != null && Teksnd.dsoundptr[sound].hVoice.isActive()) {
            if (++sound != 256) continue;
            return -1;
        }
        Teksnd.dsoundptr[sound].type = (short)type;
        Teksnd.dsoundptr[sound].x = sndx;
        Teksnd.dsoundptr[sound].y = sndy;
        if (pSfx[sn] == null) {
            int srclen = digilist[sn * 3 + 1];
            int srcoffset = digilist[sn * 3] * 4096;
            fhsounds.seek(srcoffset, Resource.Whence.Set);
            ByteBuffer data = BufferUtils.newByteBuffer(srclen);
            data.order(ByteOrder.LITTLE_ENDIAN);
            byte[] buf = new byte[srclen];
            fhsounds.read(buf);
            data.put(buf);
            Teksnd.pSfx[sn] = data;
        }
        pSfx[sn].rewind();
        int vol = Short.MAX_VALUE;
        if ((type & 1) == 0) {
            int dist = Math.abs(Player.gPlayer[Main.screenpeek].posx - sndx) + Math.abs(Player.gPlayer[Main.screenpeek].posy - sndy);
            if ((type & 0x60) != 0 || (type & 0x80) != 0) {
                vol = dist < 4000 ? 32000 - (dist << 3) : 0;
            } else if ((type & 1) == 0) {
                vol = 39000 - (dist << 2);
                if (dist < 1500) {
                    vol = Short.MAX_VALUE;
                } else if (dist > 8500) {
                    vol = sn >= 151 ? 0 : 7936;
                }
            }
        }
        vol = Gameutils.BClipRange((int)((float)vol / 32767.0f * 255.0f), 1, 255);
        Teksnd.dsoundptr[sound].loop = loop;
        if (loop != 0 || (type & 0x60) != 0 || (type & 0x80) != 0) {
            Teksnd.dsoundptr[sound].hVoice = BuildGdx.audio.newSound(pSfx[sn], 11025, 8, Integer.MAX_VALUE);
            if (Teksnd.dsoundptr[sound].hVoice != null) {
                Teksnd.dsoundptr[sound].hVoice.setLooping(true, 0, -1);
            }
        } else {
            Teksnd.dsoundptr[sound].hVoice = BuildGdx.audio.newSound(pSfx[sn], 11025, 8, 80 * (vol + 1));
        }
        if (Teksnd.dsoundptr[sound].hVoice != null) {
            Teksnd.dsoundptr[sound].hVoice.setPosition(sndx, 0.0f, sndy);
            if ((type & 1) != 0) {
                Teksnd.dsoundptr[sound].hVoice.setGlobal(1);
            }
            Teksnd.dsoundptr[sound].hVoice.play((float)vol / 255.0f);
        }
        Teksnd.dsoundptr[sound].sndnum = sn;
        return sound;
    }

    public static void stopallsounds() {
        if (!BuildGdx.audio.IsInited(BuildAudio.Driver.Sound)) {
            return;
        }
        for (int i = 0; i < 256; ++i) {
            Teksnd.stopsound(i);
        }
        BuildGdx.audio.getSound().stopAllSounds();
        Tektag.loopinsound = -1;
        Tektag.baydoorloop = -1;
        Tektag.ambsubloop = -1;
    }

    public static void stopsound(int i) {
        if (Teksnd.dsoundptr[i].hVoice == null || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound) || i < 0 || i >= 208) {
            return;
        }
        if (Teksnd.dsoundptr[i].loop != 0.0f) {
            Teksnd.dsoundptr[i].hVoice.setLooping(false, 0, 0);
            Teksnd.dsoundptr[i].loop = 0.0f;
        }
        Teksnd.dsoundptr[i].hVoice.stop();
        Teksnd.dsoundptr[i].hVoice = null;
        Teksnd.dsoundptr[i].type = (short)2;
        Teksnd.dsoundptr[i].sndnum = -1;
    }

    public static void updatevehiclesnds(int i, int sndx, int sndy) {
        if (i < 0 || i > 208) {
            return;
        }
        Teksnd.dsoundptr[i].x = sndx;
        Teksnd.dsoundptr[i].y = sndy;
        int dist = Math.abs(Player.gPlayer[Main.screenpeek].posx - sndx) + Math.abs(Player.gPlayer[Main.screenpeek].posy - sndy);
        int vol = Short.MAX_VALUE - (dist << 2);
        if (dist < 1000) {
            vol = Short.MAX_VALUE;
        } else if (dist > 9000) {
            vol = 0;
        }
        vol = Gameutils.BClipRange((int)((float)vol / 32767.0f * 255.0f), 0, 255);
        if (Teksnd.dsoundptr[i].hVoice != null) {
            Teksnd.dsoundptr[i].hVoice.setPosition(sndx, 0.0f, sndy);
            Teksnd.dsoundptr[i].hVoice.setVolume((float)vol / 255.0f);
        }
    }

    public static boolean sndRestart(int nvoices, int resampler) {
        int i;
        Teksnd.stopallsounds();
        BuildGdx.audio.getSound().uninit();
        Main.tekcfg.maxvoices = nvoices;
        Tektag.ambsubloop = -1;
        for (i = 0; i < 10; ++i) {
            Tektag.sectorvehicle[i].soundindex = -1;
        }
        for (i = 0; i < Tektag.subwaytrackcnt; ++i) {
            Tekprep.subwaysound[i] = -1;
        }
        for (i = 0; i < Tektag.totalmapsndfx; ++i) {
            Tektag.mapsndfx[i].id = -1;
        }
        Console.Println("Sound restarting...");
        if (!BuildGdx.audio.getSound().init(Sound.SystemType.Stereo, nvoices, resampler)) {
            Console.Println(BuildGdx.audio.getName(BuildAudio.Driver.Sound) + " initialization failed", Console.OSDTEXT_RED);
            return false;
        }
        BuildGdx.audio.setVolume(BuildAudio.Driver.Sound, Main.tekcfg.soundVolume);
        return true;
    }

    static {
        songlist = new int[4096];
        fhsounds = null;
        pSfx = new ByteBuffer[208];
        dsoundptr = new Soundtype[256];
        digilist = new int[1024];
        currTrack = -1;
    }
}

