/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Enemies.Ninja;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Shrap;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Actor {
    public static final Animator DoActorDebris = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Actor.DoActorDebris(spr) != 0;
        }
    };

    public static int DoScaleSprite(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (u.scale_speed != 0) {
            u.scale_value += u.scale_speed * 6;
            int scale_value = u.scale_value >> 8;
            if (u.scale_speed > 0) {
                if (scale_value > u.scale_tgt) {
                    u.scale_speed = 0;
                } else {
                    sp.xrepeat = sp.yrepeat = (short)scale_value;
                }
            } else if (scale_value < u.scale_tgt) {
                u.scale_speed = 0;
            } else {
                sp.xrepeat = sp.yrepeat = (short)scale_value;
            }
        }
        return 0;
    }

    public static int DoActorDie(int SpriteNum, int weapon) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Engine.sprite[SpriteNum];
        Sprites.change_sprite_stat(SpriteNum, 3);
        u.Flags |= Gameutils.SPR_DEAD;
        u.Flags &= ~(Gameutils.SPR_FALLING | Gameutils.SPR_JUMPING);
        u.floor_dist = (short)Gameutils.Z(40);
        sp.extra = (short)(sp.extra | Gameutils.SPRX_BREAKABLE);
        sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_BREAKABLE);
        if (weapon < 0) {
            switch (weapon) {
                case -8: {
                    Sprites.ChangeState(SpriteNum, u.StateEnd);
                    u.RotNum = 0;
                    break;
                }
                case -9: {
                    Sprites.ChangeState(SpriteNum, u.StateEnd);
                    u.RotNum = 0;
                }
            }
            return 0;
        }
        block4 : switch (Gameutils.pUser[weapon].ID) {
            case 1400: {
                Sprites.ChangeState(SpriteNum, u.StateEnd);
                u.RotNum = 0;
                sp.xvel = (short)(sp.xvel << 1);
                u.ActorActionFunc = null;
                Engine.sprite[SpriteNum].ang = Gameutils.NORM_ANGLE(Engine.sprite[SpriteNum].ang + 1024);
                break;
            }
            case 4096: {
                if (u.ID == 4096) {
                    SPRITE wp = Engine.sprite[weapon];
                    if (Gameutils.pUser[weapon].WeaponNum != 0) {
                        Weapon.InitPlasmaFountain(wp, SpriteNum);
                        Weapon.InitPlasmaFountain(wp, SpriteNum);
                        Sound.PlaySound(430, sp, 0);
                        Sprites.ChangeState(SpriteNum, Ninja.s_NinjaDieSliced[0]);
                    } else {
                        if (Gameutils.RANDOM_RANGE(1000) > 500) {
                            Weapon.InitPlasmaFountain(Engine.sprite[weapon], SpriteNum);
                        }
                        Sprites.ChangeState(SpriteNum, u.StateEnd);
                        u.RotNum = 0;
                        u.ActorActionFunc = null;
                        sp.xvel = (short)(200 + Gameutils.RANDOM_RANGE(200));
                        u.jump_speed = (short)(-200 - Gameutils.RANDOM_RANGE(250));
                        Actor.DoActorBeginJump(SpriteNum);
                        Engine.sprite[SpriteNum].ang = Engine.sprite[weapon].ang;
                    }
                } else {
                    if (Gameutils.RANDOM_RANGE(1000) > 500) {
                        sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_YFLIP);
                    }
                    Sprites.ChangeState(SpriteNum, u.StateEnd);
                    sp.xvel = 0;
                    u.jump_speed = 0;
                    Actor.DoActorBeginJump(SpriteNum);
                }
                u.RotNum = 0;
                u.ActorActionFunc = null;
                Engine.sprite[SpriteNum].ang = Engine.sprite[weapon].ang;
                break;
            }
            case 1210: 
            case 1367: 
            case 1580: 
            case 2049: 
            case 3780: 
            case 4277: 
            case 4320: {
                Sprites.ChangeState(SpriteNum, u.StateEnd);
                u.RotNum = 0;
                break;
            }
            case 2146: {
                if (Gameutils.RANDOM_RANGE(1000) > 500) {
                    sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_YFLIP);
                }
                Sprites.ChangeState(SpriteNum, u.StateEnd);
                u.RotNum = 0;
                if (u.ID == 1580 || u.ID == 4320) {
                    sp.xvel = (short)(sp.xvel << 1);
                    u.jump_speed = (short)(-100 - Gameutils.RANDOM_RANGE(250));
                    Actor.DoActorBeginJump(SpriteNum);
                } else {
                    sp.xvel = 0;
                    u.jump_speed = (short)(-10 - Gameutils.RANDOM_RANGE(25));
                    Actor.DoActorBeginJump(SpriteNum);
                }
                u.ActorActionFunc = null;
                sp.ang = Gameutils.NORM_ANGLE(Main.engine.getangle(Engine.sprite[u.tgt_sp].x - sp.x, Engine.sprite[u.tgt_sp].y - sp.y) + 1024);
                break;
            }
            case 2147: {
                if (Gameutils.RANDOM_RANGE(1000) > 500) {
                    sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_YFLIP);
                }
                Sprites.ChangeState(SpriteNum, u.StateEnd);
                u.RotNum = 0;
                if (u.ID == 1580 || u.ID == 4320) {
                    sp.xvel = (short)(75 + Gameutils.RANDOM_RANGE(100));
                    u.jump_speed = (short)(-100 - Gameutils.RANDOM_RANGE(150));
                } else {
                    sp.xvel = (short)(100 + Gameutils.RANDOM_RANGE(200));
                    u.jump_speed = (short)(-100 - Gameutils.RANDOM_RANGE(250));
                }
                Actor.DoActorBeginJump(SpriteNum);
                u.ActorActionFunc = null;
                sp.ang = Gameutils.NORM_ANGLE(Main.engine.getangle(Engine.sprite[u.tgt_sp].x - sp.x, Engine.sprite[u.tgt_sp].y - sp.y) + 1024);
                break;
            }
            default: {
                switch (u.ID) {
                    case 817: 
                    case 820: {
                        Sprites.ChangeState(SpriteNum, u.StateEnd);
                        break block4;
                    }
                }
                if (Gameutils.RANDOM_RANGE(1000) > 700) {
                    Weapon.InitPlasmaFountain(Engine.sprite[weapon], SpriteNum);
                }
                if (Gameutils.RANDOM_RANGE(1000) > 500) {
                    sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_YFLIP);
                }
                Sprites.ChangeState(SpriteNum, u.StateEnd);
                u.RotNum = 0;
                u.ActorActionFunc = null;
                sp.xvel = (short)(300 + Gameutils.RANDOM_RANGE(400));
                u.jump_speed = (short)(-300 - Gameutils.RANDOM_RANGE(350));
                Actor.DoActorBeginJump(SpriteNum);
                Engine.sprite[SpriteNum].ang = Engine.sprite[weapon].ang;
            }
        }
        switch (u.ID) {
            case 1210: 
            case 1400: 
            case 4320: 
            case 5426: {
                sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YFLIP);
            }
        }
        u.ID = 0;
        return 0;
    }

    public static void DoDebrisCurrent(int spnum) {
        int ny;
        int ret = 0;
        SPRITE sp = Engine.sprite[spnum];
        USER u = Gameutils.pUser[spnum];
        Sect_User sectu = Sector.SectUser[sp.sectnum];
        int nx = (int)((long)MyTypes.DIV4(sectu.speed) * (long)Engine.sintable[Gameutils.NORM_ANGLE(sectu.ang + 512)] >> 14);
        ret = Sprites.move_sprite(spnum, nx, ny = (int)((long)MyTypes.DIV4(sectu.speed) * (long)Engine.sintable[sectu.ang] >> 14), 0, u.ceiling_dist, u.floor_dist, 0, 6);
        if (ret != 0) {
            short rang = (short)Gameutils.RANDOM_P2(2048);
            nx = (int)((long)MyTypes.DIV4(sectu.speed) * (long)Engine.sintable[Gameutils.NORM_ANGLE(sectu.ang + rang + 512)] >> 14);
            ny = (int)((long)MyTypes.DIV4(sectu.speed) * (long)Engine.sintable[Gameutils.NORM_ANGLE(sectu.ang + rang)] >> 14);
            Sprites.move_sprite(spnum, nx, ny, 0, u.ceiling_dist, u.floor_dist, 0, 6);
        }
        sp.z = u.loz;
    }

    public static boolean DoActorSectorDamage(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        Sect_User sectu = Sector.SectUser[sp.sectnum];
        SECTOR sectp = Engine.sector[sp.sectnum];
        if (u.Health <= 0) {
            return false;
        }
        if (sectu != null && sectu.damage != 0) {
            if (MyTypes.TEST(sectu.flags, Gameutils.SECTFU_DAMAGE_ABOVE_SECTOR)) {
                u.DamageTics = (short)(u.DamageTics - 3);
                if (u.DamageTics < 0) {
                    u.DamageTics = (short)60;
                    u.Health = (short)(u.Health - sectu.damage);
                    if (u.Health <= 0) {
                        Weapon.UpdateSinglePlayKills(SpriteNum, null);
                        Actor.DoActorDie(SpriteNum, -8);
                        return true;
                    }
                }
            } else if (Gameutils.SPRITEp_BOS(sp) >= sectp.floorz && (u.DamageTics = (short)(u.DamageTics - 3)) < 0) {
                u.DamageTics = (short)60;
                u.Health = (short)(u.Health - sectu.damage);
                if (u.Health <= 0) {
                    Weapon.UpdateSinglePlayKills(SpriteNum, null);
                    Actor.DoActorDie(SpriteNum, -8);
                    return true;
                }
            }
        }
        if (u.lo_sectp != -1 && u.hi_sectp != -1 && Pragmas.klabs(u.loz - u.hiz) < MyTypes.DIV2(Gameutils.SPRITE_SIZE_Z(SpriteNum))) {
            u.Health = 0;
            if (Shrap.SpawnShrap(SpriteNum, -9)) {
                Weapon.UpdateSinglePlayKills(SpriteNum, null);
                Weapon.SetSuicide(SpriteNum);
            }
            return true;
        }
        return false;
    }

    public static boolean move_debris(int SpriteNum, int xchange, int ychange, int zchange) {
        USER u = Gameutils.pUser[SpriteNum];
        u.ret = Sprites.move_sprite(SpriteNum, xchange, ychange, zchange, u.ceiling_dist, u.floor_dist, 0, 6);
        return u.ret == 0;
    }

    public static int DoActorDebris(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        SECTOR sectp = Engine.sector[sp.sectnum];
        sp.cstat = (short)(sp.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        switch (u.ID) {
            case 800: 
            case 4550: {
                Sprites.KillSprite(SpriteNum);
                return 0;
            }
            case 5426: {
                Main.engine.getzsofslope(sp.sectnum, sp.x, sp.y, Rooms.zofslope);
                u.hiz = Rooms.zofslope[0];
                u.loz = Rooms.zofslope[1];
                u.lo_sectp = sp.sectnum;
                u.hi_sectp = sp.sectnum;
                u.lo_sp = -1;
                u.hi_sp = -1;
            }
        }
        if (MyTypes.TEST(sectp.extra, Gameutils.SECTFX_SINK)) {
            if (MyTypes.TEST(sectp.extra, Gameutils.SECTFX_CURRENT)) {
                Actor.DoDebrisCurrent(SpriteNum);
            } else {
                int ny;
                int nx = 6 * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
                if (!Actor.move_debris(SpriteNum, nx, ny = 6 * Engine.sintable[sp.ang] >> 14, 0)) {
                    sp.ang = (short)Gameutils.RANDOM_P2(2048);
                }
            }
            if (Sector.SectUser[sp.sectnum] != null && Sector.SectUser[sp.sectnum].depth > 10) {
                u.WaitTics = (short)(u.WaitTics + 48 & 0x3FF);
                sp.z = u.loz - (Gameutils.Z(2) * Engine.sintable[u.WaitTics] >> 14);
            }
        } else {
            sp.z = u.loz;
        }
        return 0;
    }

    public static int DoFireFly(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int nx = 24 * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
        int ny = 24 * Engine.sintable[sp.ang] >> 14;
        sp.clipdist = 64;
        if (!Sprites.move_actor(SpriteNum, nx, ny, 0)) {
            sp.ang = Gameutils.NORM_ANGLE(sp.ang + 1024);
        }
        u.WaitTics = (short)(u.WaitTics + 12 & 0x7FF);
        sp.z = u.sz + (Gameutils.Z(32) * Engine.sintable[u.WaitTics] >> 14);
        return 0;
    }

    public static int DoGenerateSewerDebris(short SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        u.Tics -= 6;
        if (u.Tics <= 0) {
            u.Tics = u.WaitTics;
            short n = (short)Sprites.SpawnSprite(3, 0, Sprites.Debris[Gameutils.RANDOM_P2(1024) >> 8], sp.sectnum, sp.x, sp.y, sp.z, sp.ang, 200);
            Sprites.SetOwner(SpriteNum, n);
        }
        return 0;
    }

    public static void KeepActorOnFloor(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        SECTOR sectp = Engine.sector[sp.sectnum];
        sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YFLIP);
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            return;
        }
        int depth = u.lo_sectp != -1 && Sector.SectUser[u.lo_sectp] != null ? (int)Sector.SectUser[u.lo_sectp].depth : 0;
        if (MyTypes.TEST(sectp.extra, Gameutils.SECTFX_SINK) && depth > 35 && u.ActorActionSet != null && u.ActorActionSet.Swim != null) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_SWIMMING)) {
                if (u.Rot != u.ActorActionSet.Run && u.Rot != u.ActorActionSet.Swim && u.Rot != u.ActorActionSet.Stand) {
                    u.Flags &= ~Gameutils.SPR_SWIMMING;
                    sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YCENTER);
                    u.oz = sp.z = u.loz;
                    return;
                }
                if (u.Rot == u.ActorActionSet.Run) {
                    Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Swim);
                }
                u.oz = sp.z = u.loz - Gameutils.Z(depth);
            } else if (u.Rot == u.ActorActionSet.Run || u.Rot == u.ActorActionSet.Swim) {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Swim);
                u.oz = sp.z = u.loz - Gameutils.Z(depth);
                u.Flags |= Gameutils.SPR_SWIMMING;
                sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
            } else {
                u.Flags &= ~Gameutils.SPR_SWIMMING;
                sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YCENTER);
                u.oz = sp.z = u.loz;
            }
            return;
        }
        u.Flags &= ~Gameutils.SPR_SWIMMING;
        sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YCENTER);
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_MOVED)) {
            u.oz = sp.z = u.loz;
        } else {
            Rooms.FAFgetzrangepoint(sp.x, sp.y, sp.z, sp.sectnum, Game.tmp_ptr[0], Game.tmp_ptr[1], Game.tmp_ptr[2].set(0), Game.tmp_ptr[3]);
            u.oz = sp.z = Game.tmp_ptr[2].value;
        }
    }

    public static int DoActorBeginSlide(int SpriteNum, int ang, int vel, int dec) {
        USER u = Gameutils.pUser[SpriteNum];
        u.Flags |= Gameutils.SPR_SLIDING;
        u.slide_ang = (short)ang;
        u.slide_vel = vel;
        u.slide_dec = (short)dec;
        return 0;
    }

    public static boolean DoActorSlide(int SpriteNum) {
        int ny;
        USER u = Gameutils.pUser[SpriteNum];
        int nx = u.slide_vel * Engine.sintable[Gameutils.NORM_ANGLE(u.slide_ang + 512)] >> 14;
        if (!Sprites.move_actor(SpriteNum, nx, ny = u.slide_vel * Engine.sintable[u.slide_ang] >> 14, 0)) {
            u.Flags &= ~Gameutils.SPR_SLIDING;
            return false;
        }
        u.slide_vel -= u.slide_dec * 6;
        if (u.slide_vel < 20) {
            u.Flags &= ~Gameutils.SPR_SLIDING;
        }
        return true;
    }

    public static int DoActorBeginJump(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = (short)8;
        if (u.ActorActionSet != null) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_DEAD)) {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.DeathJump);
            } else {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Jump);
            }
        }
        u.StateFallOverride = null;
        return 0;
    }

    public static int DoActorJump(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        int jump_adj = u.jump_grav * 6;
        u.jump_speed = (short)(u.jump_speed + jump_adj);
        if (u.jump_speed > 0) {
            Actor.DoActorBeginFall(SpriteNum);
            return 0;
        }
        sp.z += u.jump_speed * 6;
        if (sp.z < u.hiz + Gameutils.Z(Gameutils.PIC_SIZY(SpriteNum))) {
            sp.z = u.hiz + Gameutils.Z(Gameutils.PIC_SIZY(SpriteNum));
            u.jump_speed = -u.jump_speed;
            Actor.DoActorBeginFall(SpriteNum);
        }
        return 0;
    }

    public static int DoActorBeginFall(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.Flags |= Gameutils.SPR_FALLING;
        u.Flags &= ~Gameutils.SPR_JUMPING;
        u.jump_grav = (short)8;
        if (u.ActorActionSet != null) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_DEAD)) {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.DeathFall);
            } else {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Fall);
            }
            if (u.StateFallOverride != null) {
                Sprites.NewStateGroup(SpriteNum, u.StateFallOverride);
            }
        }
        Actor.DoActorFall(SpriteNum);
        return 0;
    }

    public static int DoActorFall(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        u.jump_speed = (short)(u.jump_speed + u.jump_grav * 6);
        sp.z += u.jump_speed * 6;
        if (sp.z > u.loz) {
            Actor.DoActorStopFall(SpriteNum);
        }
        return 0;
    }

    public static int DoActorStopFall(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        sp.z = u.loz;
        u.Flags &= ~(Gameutils.SPR_FALLING | Gameutils.SPR_JUMPING);
        sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YFLIP);
        if (u.lo_sp != -1 && !MyTypes.TEST(Engine.sprite[u.lo_sp].cstat, Gameutils.CSTAT_SPRITE_FLOOR)) {
            sp.ang = Gameutils.NORM_ANGLE(sp.ang + 1024 + (Gameutils.RANDOM_P2(131072) >> 8));
            u.jump_speed = (short)-350;
            Actor.DoActorBeginJump(SpriteNum);
            return 0;
        }
        if (u.ActorActionSet != null) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_DEAD)) {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Dead);
                Sound.PlaySound(73, sp, 0);
            } else {
                Sound.PlaySound(74, sp, 0);
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
                if (u.track >= 0 && u.jump_speed > 800 && u.ActorActionSet.Sit != null) {
                    u.WaitTics = (short)80;
                    Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Sit);
                }
            }
        }
        return 0;
    }

    public static int DoActorDeathMove(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else {
                Actor.DoActorFall(SpriteNum);
            }
        }
        int nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
        int ny = sp.xvel * Engine.sintable[sp.ang] >> 14;
        sp.clipdist = 48;
        Sprites.move_actor(SpriteNum, nx, ny, 0);
        Weapon.DoFindGroundPoint(SpriteNum);
        return 0;
    }

    public static int DoBeginJump(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = (short)8;
        Actor.DoJump(SpriteNum);
        return 0;
    }

    public static int DoJump(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        int jump_adj = u.jump_grav * 6;
        u.jump_speed = (short)(u.jump_speed + jump_adj);
        if (u.jump_speed > 0) {
            Actor.DoBeginFall(SpriteNum);
            return 0;
        }
        sp.z += u.jump_speed * 6;
        if (sp.z < u.hiz + Gameutils.Z(Gameutils.PIC_SIZY(SpriteNum))) {
            sp.z = u.hiz + Gameutils.Z(Gameutils.PIC_SIZY(SpriteNum));
            u.jump_speed = -u.jump_speed;
            Actor.DoBeginFall(SpriteNum);
        }
        return 0;
    }

    public static int DoBeginFall(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.Flags |= Gameutils.SPR_FALLING;
        u.Flags &= ~Gameutils.SPR_JUMPING;
        u.jump_grav = (short)8;
        Actor.DoFall(SpriteNum);
        return 0;
    }

    public static int DoFall(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        u.jump_speed = (short)(u.jump_speed + u.jump_grav * 6);
        sp.z += u.jump_speed * 6;
        if (sp.z > u.loz - u.floor_dist) {
            sp.z = u.loz - u.floor_dist;
            u.Flags &= ~Gameutils.SPR_FALLING;
        }
        return 0;
    }
}

