/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Ai {
    public static final int SLOW_SPEED = 0;
    public static final int NORM_SPEED = 1;
    public static final int MID_SPEED = 2;
    public static final int FAST_SPEED = 3;
    public static final int MAX_SPEED = 4;
    public static final int MAXATTRIBSNDS = 11;
    public static final Animator InitActorAttack = new Animator(){

        @Override
        public boolean invoke(int spr) {
            Ai.InitActorAttack(spr);
            return false;
        }
    };
    public static final Animator InitActorRunToward = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            Ai.InitActorRunToward(SpriteNum);
            return false;
        }
    };
    public static final Animator InitActorRunAway = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            Ai.InitActorRunAway(SpriteNum);
            return false;
        }
    };
    public static Decision[] GenericFlaming = new Decision[]{new Decision(30, InitActorAttack), new Decision(512, InitActorRunToward), new Decision(1024, InitActorRunAway)};
    public static final Animator InitActorDecide = new Animator(){

        @Override
        public boolean invoke(int spr) {
            Ai.InitActorDecide(spr);
            return false;
        }
    };
    public static final Animator DoActorDecide = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
            Animator actor_action = Ai.DoActorActionDecide(SpriteNum);
            if (actor_action == InitActorAttack && u.WeaponNum == 0) {
                return false;
            }
            if (actor_action == InitActorAttack && u != null && u.ID == 1095 && u.tgt_sp != -1 && Gameutils.pUser[u.tgt_sp] != null && Gameutils.pUser[u.tgt_sp].PlayerP != -1) {
                if (sp.owner == u.tgt_sp) {
                    return false;
                }
                if (!Weapon.PlayerTakeDamage(Game.Player[Gameutils.pUser[u.tgt_sp].PlayerP], SpriteNum)) {
                    return false;
                }
            }
            if (actor_action != InitActorDecide) {
                actor_action.invoke(SpriteNum);
            } else {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Stand);
            }
            return false;
        }
    };
    public static final Animator InitActorAlertNoise = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.ActorActionFunc = DoActorDecide;
            return false;
        }
    };
    public static final Animator InitActorAmbientNoise = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.ActorActionFunc = DoActorDecide;
            return false;
        }
    };
    public static final Animator InitActorAttackNoise = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.ActorActionFunc = DoActorDecide;
            return false;
        }
    };
    public static final Animator InitActorPainNoise = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.ActorActionFunc = DoActorDecide;
            return false;
        }
    };
    public static final Animator InitActorDieNoise = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.ActorActionFunc = DoActorDecide;
            return false;
        }
    };
    public static final Animator InitActorExtra1Noise = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.ActorActionFunc = DoActorDecide;
            return false;
        }
    };
    public static final Animator InitActorExtra2Noise = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.ActorActionFunc = DoActorDecide;
            return false;
        }
    };
    public static final Animator InitActorExtra3Noise = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.ActorActionFunc = DoActorDecide;
            return false;
        }
    };
    public static final Animator InitActorExtra4Noise = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.ActorActionFunc = DoActorDecide;
            return false;
        }
    };
    public static final Animator InitActorExtra5Noise = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.ActorActionFunc = DoActorDecide;
            return false;
        }
    };
    public static final Animator InitActorExtra6Noise = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.ActorActionFunc = DoActorDecide;
            return false;
        }
    };
    public static final Animator InitActorMoveCloser = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.ActorActionFunc = DoActorMoveCloser;
            if (u.Rot != u.ActorActionSet.Run) {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
            }
            u.ActorActionFunc.invoke(SpriteNum);
            return false;
        }
    };
    public static final Animator DoActorMoveCloser = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            int ny;
            USER u = Gameutils.pUser[SpriteNum];
            SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
            int nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
            if (!Sprites.move_actor(SpriteNum, nx, ny = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang)] >> 14, 0)) {
                if (Ai.ActorMoveHitReact(SpriteNum)) {
                    return false;
                }
                Ai.DoActorCantMoveCloser(SpriteNum);
                return false;
            }
            Ai.DoActorNoise(Ai.ChooseAction(u.Personality.Broadcast), SpriteNum);
            if (u.DistCheck > 550) {
                u.DistCheck = 0;
                if (!Ai.CanSeePlayer(SpriteNum)) {
                    Ai.InitActorDecide(SpriteNum);
                    return false;
                }
                sp.ang = Main.engine.getangle(Engine.sprite[u.tgt_sp].x - sp.x, Engine.sprite[u.tgt_sp].y - sp.y);
            }
            if (u.Dist > 1536) {
                Ai.InitActorDecide(SpriteNum);
            }
            return false;
        }
    };
    private static int[] PlayerAbove = new int[]{MyTypes.BIT(5), MyTypes.BIT(6), MyTypes.BIT(2), MyTypes.BIT(7), MyTypes.BIT(14), MyTypes.BIT(12)};
    private static int[] PlayerBelow = new int[]{MyTypes.BIT(3), MyTypes.BIT(6), MyTypes.BIT(7), MyTypes.BIT(14), MyTypes.BIT(12)};
    private static int[] PlayerOnLevel = new int[]{MyTypes.BIT(8), MyTypes.BIT(9), MyTypes.BIT(7), MyTypes.BIT(10), MyTypes.BIT(14), MyTypes.BIT(12)};
    private static int[] RunAwayTracks = new int[]{MyTypes.BIT(10), MyTypes.BIT(5), MyTypes.BIT(7), MyTypes.BIT(6), MyTypes.BIT(2), MyTypes.BIT(3), MyTypes.BIT(8), MyTypes.BIT(9), MyTypes.BIT(14), MyTypes.BIT(12)};
    private static int[] WanderTracks = new int[]{MyTypes.BIT(8), MyTypes.BIT(9), MyTypes.BIT(11), MyTypes.BIT(3), MyTypes.BIT(2), MyTypes.BIT(7), MyTypes.BIT(6), MyTypes.BIT(5), MyTypes.BIT(10), MyTypes.BIT(14)};
    public static final Animator DoActorAttack = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
            Ai.DoActorNoise(Ai.ChooseAction(u.Personality.Broadcast), SpriteNum);
            int dist = Gameutils.DISTANCE(sp.x, sp.y, Engine.sprite[u.tgt_sp].x, Engine.sprite[u.tgt_sp].y);
            USER pu = Gameutils.pUser[Ai.GetPlayerSpriteNum(SpriteNum)];
            if (u.ActorActionSet.CloseAttack[0] != null && dist < Ai.CloseRangeDist(sp, Engine.sprite[u.tgt_sp]) || pu != null && pu.WeaponNum == 0) {
                int rand_num = Ai.ChooseActionNumber(u.ActorActionSet.CloseAttackPercent);
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.CloseAttack[rand_num]);
            } else {
                int rand_num = Ai.ChooseActionNumber(u.ActorActionSet.AttackPercent);
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Attack[rand_num]);
                u.ActorActionFunc = DoActorDecide;
            }
            return false;
        }
    };
    public static final Animator InitActorEvade = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Ai.InitActorEvade(SpriteNum) != 0;
        }
    };
    public static final Animator InitActorWanderAround = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
            u.ActorActionFunc = DoActorDecide;
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
            Ai.DoActorPickClosePlayer(SpriteNum);
            u.track = Ai.FindWanderTrack(u);
            if (u.track >= 0) {
                sp.ang = Main.engine.getangle(Track.Track[u.track].TrackPoint[u.point].x - sp.x, Track.Track[u.track].TrackPoint[u.point].y - sp.y);
                Ai.DoActorSetSpeed(SpriteNum, 1);
            }
            return false;
        }
    };
    public static final Animator InitActorFindPlayer = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
            u.ActorActionFunc = DoActorDecide;
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
            u.track = (short)Ai.FindTrackToPlayer(u);
            if (u.track >= 0) {
                sp.ang = Main.engine.getangle(Track.Track[u.track].TrackPoint[u.point].x - sp.x, Track.Track[u.track].TrackPoint[u.point].y - sp.y);
                Ai.DoActorSetSpeed(SpriteNum, 2);
                u.Flags |= Gameutils.SPR_FIND_PLAYER;
                u.ActorActionFunc = DoActorDecide;
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
            } else {
                InitActorReposition.invoke(SpriteNum);
            }
            return false;
        }
    };
    public static final Animator InitActorDuck = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
            if (u.ActorActionSet.Duck == null) {
                u.ActorActionFunc = DoActorDecide;
                return false;
            }
            u.ActorActionFunc = DoActorDuck;
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Duck);
            int dist = Game.Distance(sp.x, sp.y, Engine.sprite[u.tgt_sp].x, Engine.sprite[u.tgt_sp].y);
            u.WaitTics = dist > 8000 ? (short)190 : (short)60;
            u.ActorActionFunc.invoke(SpriteNum);
            return false;
        }
    };
    public static final Animator DoActorDuck = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.WaitTics = (short)(u.WaitTics - 6);
            if (u.WaitTics < 0) {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Rise);
                u.ActorActionFunc = DoActorDecide;
                u.Flags &= ~Gameutils.SPR_TARGETED;
            }
            return false;
        }
    };
    public static final Animator DoActorMoveJump = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
            int nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
            int ny = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang)] >> 14;
            Sprites.move_actor(SpriteNum, nx, ny, 0);
            if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
                Ai.InitActorDecide(SpriteNum);
            }
            return false;
        }
    };
    public static final int TOWARD = 1;
    public static final int AWAY = -1;
    private static short[][] toward_angle_delta = new short[][]{{-160, -384, 160, 384, -256, 256, -512, 512, -99}, {-384, -160, 384, 160, -256, 256, -512, 512, -99}, {160, 384, -160, -384, 256, -256, 512, -512, -99}, {384, 160, -384, -160, 256, -256, 512, -512, -99}};
    private static short[][] away_angle_delta = new short[][]{{-768, 768, -640, 640, -896, 896, 1024, -99}, {768, -768, 640, -640, -896, 896, 1024, -99}, {896, -896, -768, 768, -640, 640, 1024, -99}, {896, -896, 768, -768, 640, -640, 1024, -99}};
    private static int[] AwayDist = new int[]{17000, 20000, 26000, 26000, 26000, 32000, 32000, 42000};
    private static int[] TowardDist = new int[]{10000, 15000, 20000, 20000, 25000, 30000, 35000, 40000};
    private static int[] PlayerDist = new int[]{2000, 3000, 3000, 5000, 5000, 5000, 9000, 9000};
    public static final Animator InitActorReposition = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
            u.Dist = 0;
            int rnum = Gameutils.RANDOM_P2(2048) >> 8;
            int dist = Game.Distance(sp.x, sp.y, Engine.sprite[u.tgt_sp].x, Engine.sprite[u.tgt_sp].y);
            if (dist < PlayerDist[rnum] || MyTypes.TEST(u.Flags, Gameutils.SPR_RUN_AWAY)) {
                rnum = Gameutils.RANDOM_P2(2048) >> 8;
                short ang = (short)Ai.FindNewAngle(SpriteNum, -1, AwayDist[rnum]);
                if (ang == -1) {
                    u.Vis = (short)8;
                    Ai.InitActorPause(SpriteNum);
                    return false;
                }
                sp.ang = ang;
                Ai.DoActorSetSpeed(SpriteNum, 3);
                u.Flags &= ~Gameutils.SPR_RUN_AWAY;
            } else {
                rnum = Gameutils.RANDOM_P2(2048) >> 8;
                short ang = (short)Ai.FindNewAngle(SpriteNum, 1, TowardDist[rnum]);
                if (ang == -1) {
                    rnum = Gameutils.RANDOM_P2(2048) >> 8;
                    ang = (short)Ai.FindNewAngle(SpriteNum, -1, AwayDist[rnum]);
                    if (ang == -1) {
                        u.Vis = (short)8;
                        Ai.InitActorPause(SpriteNum);
                        return false;
                    }
                } else if (Gameutils.RANDOM_P2(1024) < 512) {
                    Ai.DoActorSetSpeed(SpriteNum, 1);
                } else {
                    Ai.DoActorSetSpeed(SpriteNum, 2);
                }
                sp.ang = ang;
            }
            u.ActorActionFunc = DoActorReposition;
            if (!MyTypes.TEST(u.Flags, Gameutils.SPR_SWIMMING)) {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
            }
            u.ActorActionFunc.invoke(SpriteNum);
            return false;
        }
    };
    public static final Animator DoActorReposition = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            int ny;
            USER u = Gameutils.pUser[SpriteNum];
            SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
            int nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
            if (!Sprites.move_actor(SpriteNum, nx, ny = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang)] >> 14, 0)) {
                if (Ai.ActorMoveHitReact(SpriteNum)) {
                    return false;
                }
                u.Vis = (short)6;
                Ai.InitActorPause(SpriteNum);
                return false;
            }
            if (u.TargetDist < 50) {
                Ai.InitActorDecide(SpriteNum);
            }
            return false;
        }
    };
    public static final Animator DoActorPause = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            USER u = Gameutils.pUser[SpriteNum];
            u.Vis = (short)(u.Vis - 6);
            if (u.Vis < 0) {
                u.ActorActionFunc = DoActorDecide;
                u.Flags &= ~Gameutils.SPR_TARGETED;
            }
            return false;
        }
    };

    public static boolean ActorMoveHitReact(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        switch (MyTypes.DTEST(u.ret, 57344)) {
            case 49152: {
                short HitSprite = Gameutils.NORM_SPRITE(u.ret);
                USER hu = Gameutils.pUser[HitSprite];
                if (hu == null || hu.PlayerP == -1) break;
                Ai.DoActorPickClosePlayer(SpriteNum);
                Animator action = Ai.ChooseAction(u.Personality.TouchTarget);
                if (action == null) break;
                action.invoke(SpriteNum);
                return true;
            }
            case 32768: {
                break;
            }
        }
        return false;
    }

    public static int RandomRange(int range) {
        long value;
        if (range <= 0) {
            return 0;
        }
        long rand_num = Gameutils.RANDOM();
        if (rand_num == 65535L) {
            --rand_num;
        }
        if ((value = (rand_num << 14) / (long)(1073725440 / range)) >= (long)range) {
            value = range - 1;
        }
        return (int)value;
    }

    public static int StdRandomRange(int range) {
        long value;
        if (range <= 0) {
            return 0;
        }
        long rand_num = Gameutils.STD_RANDOM();
        if (rand_num == (long)Game.RAND_MAX) {
            --rand_num;
        }
        if ((value = (rand_num << 14) / (long)((Game.RAND_MAX << 14) / range)) >= (long)range) {
            value = range - 1;
        }
        return (int)value;
    }

    public static boolean ActorFlaming(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        if (u.flame >= 0) {
            SPRITE fp = Engine.sprite[u.flame];
            int size = Gameutils.SPRITEp_SIZE_Z(sp) - MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(sp));
            if (Gameutils.SPRITEp_SIZE_Z(fp) > size) {
                return true;
            }
        }
        return false;
    }

    public static void DoActorSetSpeed(int SpriteNum, int speed) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            return;
        }
        u.speed = (byte)speed;
        sp.xvel = Ai.ActorFlaming(SpriteNum) ? (short)(u.Attrib.Speed[speed] + MyTypes.DIV2(u.Attrib.Speed[speed])) : u.Attrib.Speed[speed];
    }

    public static Animator ChooseAction(Decision[] decision) {
        int random_value = Gameutils.RANDOM_P2(32768) >> 5;
        for (int i = 0; i < 10; ++i) {
            if (random_value > decision[i].range) continue;
            return decision[i].action;
        }
        return null;
    }

    public static int ChooseActionNumber(short[] decision) {
        int random_value = Gameutils.RANDOM_P2(32768) >> 5;
        int i = 0;
        while (random_value > decision[i]) {
            ++i;
        }
        return i;
    }

    public static int DoActorNoise(Animator Action2, int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (Action2 == InitActorAmbientNoise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_ambient, 1);
        } else if (Action2 == InitActorAlertNoise) {
            if (u != null && !u.DidAlert) {
                Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_alert, 1);
            }
        } else if (Action2 == InitActorAttackNoise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_attack, 1);
        } else if (Action2 == InitActorPainNoise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_pain, 1);
        } else if (Action2 == InitActorDieNoise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_die, 0);
        } else if (Action2 == InitActorExtra1Noise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_extra1, 1);
        } else if (Action2 == InitActorExtra2Noise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_extra2, 1);
        } else if (Action2 == InitActorExtra3Noise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_extra3, 1);
        } else if (Action2 == InitActorExtra4Noise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_extra4, 1);
        } else if (Action2 == InitActorExtra5Noise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_extra5, 1);
        } else if (Action2 == InitActorExtra6Noise) {
            Sound.PlaySpriteSound(SpriteNum, Attrib_Snds.attr_extra6, 1);
        }
        return 0;
    }

    public static boolean CanSeePlayer(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        int look_height = Gameutils.SPRITEp_TOS(sp);
        return Rooms.FAFcansee(sp.x, sp.y, look_height, sp.sectnum, Engine.sprite[u.tgt_sp].x, Engine.sprite[u.tgt_sp].y, Gameutils.SPRITEp_UPPER(Engine.sprite[u.tgt_sp]), Engine.sprite[u.tgt_sp].sectnum);
    }

    public static boolean CanHitPlayer(int SpriteNum) {
        int zvect;
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        int zhs = sp.z - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp));
        SPRITE hp = Engine.sprite[u.tgt_sp];
        short ang = Main.engine.getangle(hp.x - sp.x, hp.y - sp.y);
        short xvect = Engine.sintable[Gameutils.NORM_ANGLE(ang + 512)];
        short yvect = Engine.sintable[Gameutils.NORM_ANGLE(ang)];
        int zhh = hp.z - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(hp));
        if (hp.x - sp.x != 0) {
            zvect = xvect * ((zhh - zhs) / (hp.x - sp.x));
        } else if (hp.y - sp.y != 0) {
            zvect = yvect * ((zhh - zhs) / (hp.y - sp.y));
        } else {
            return false;
        }
        Rooms.FAFhitscan(sp.x, sp.y, zhs, sp.sectnum, xvect, yvect, zvect, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
        if (Engine.pHitInfo.hitsect < 0) {
            return false;
        }
        return Engine.pHitInfo.hitsprite == u.tgt_sp;
    }

    public static void DoActorPickClosePlayer(int SpriteNum) {
        int dist;
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        int near_dist = 42000;
        int look_height = Gameutils.SPRITEp_TOS(sp);
        boolean found = false;
        if (u.ID != 1095 || Main.gNet.MultiGameType != WangNetwork.MultiGameTypes.MULTI_GAME_COOPERATIVE) {
            PlayerStr pp;
            short pnum;
            u.tgt_sp = Game.Player[Mmulti.connecthead].PlayerSprite;
            if (MyTypes.TEST(u.Flags2, Gameutils.SPR2_DONT_TARGET_OWNER)) {
                pnum = Mmulti.connecthead;
                while (pnum != -1) {
                    pp = Game.Player[pnum];
                    if (sp.owner != pp.PlayerSprite) {
                        u.tgt_sp = pp.PlayerSprite;
                        break;
                    }
                    pnum = Mmulti.connectpoint2[pnum];
                }
            }
            near_dist = 42000;
            pnum = Mmulti.connecthead;
            while (pnum != -1) {
                pp = Game.Player[pnum];
                if ((!MyTypes.TEST(u.Flags2, Gameutils.SPR2_DONT_TARGET_OWNER) || sp.owner != pp.PlayerSprite && Weapon.PlayerTakeDamage(pp, SpriteNum)) && (dist = Gameutils.DISTANCE(sp.x, sp.y, pp.posx, pp.posy)) < near_dist) {
                    near_dist = dist;
                    u.tgt_sp = pp.PlayerSprite;
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
            near_dist = 42000;
            found = false;
            pnum = Mmulti.connecthead;
            while (pnum != -1) {
                pp = Game.Player[pnum];
                if (!MyTypes.TEST(u.Flags2, Gameutils.SPR2_DONT_TARGET_OWNER) || sp.owner != pp.PlayerSprite && Weapon.PlayerTakeDamage(pp, SpriteNum)) {
                    dist = Gameutils.DISTANCE(sp.x, sp.y, pp.posx, pp.posy);
                    SPRITE psp = pp.getSprite();
                    if (dist < near_dist && Rooms.FAFcansee(sp.x, sp.y, look_height, sp.sectnum, psp.x, psp.y, Gameutils.SPRITEp_UPPER(psp), psp.sectnum)) {
                        near_dist = dist;
                        u.tgt_sp = pp.PlayerSprite;
                        found = true;
                    }
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
        }
        if (!found && MyTypes.TEST(u.Flags2, Gameutils.SPR2_DONT_TARGET_OWNER)) {
            near_dist = 42000;
            int i = Engine.headspritestat[2];
            while (i != -1) {
                int nexti = Engine.nextspritestat[i];
                if (i != SpriteNum && (Gameutils.pUser[i] == null || !MyTypes.TEST(Gameutils.pUser[i].Flags, Gameutils.SPR_SUICIDE | Gameutils.SPR_DEAD)) && (dist = Gameutils.DISTANCE(sp.x, sp.y, Engine.sprite[i].x, Engine.sprite[i].y)) < near_dist && Rooms.FAFcansee(sp.x, sp.y, look_height, sp.sectnum, Engine.sprite[i].x, Engine.sprite[i].y, Gameutils.SPRITEp_UPPER(Engine.sprite[i]), Engine.sprite[i].sectnum)) {
                    near_dist = dist;
                    u.tgt_sp = i;
                }
                i = nexti;
            }
        }
    }

    public static int GetPlayerSpriteNum(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        short pnum = Mmulti.connecthead;
        while (pnum != -1) {
            PlayerStr pp = Game.Player[pnum];
            if (pp.PlayerSprite == u.tgt_sp) {
                return pp.PlayerSprite;
            }
            pnum = Mmulti.connectpoint2[pnum];
        }
        return 0;
    }

    public static int CloseRangeDist(SPRITE sp1, SPRITE sp2) {
        int clip1 = sp1.clipdist;
        int clip2 = sp2.clipdist;
        int DIST_CLOSE_RANGE = 400;
        return (clip1 << 2) + (clip2 << 2) + DIST_CLOSE_RANGE;
    }

    public static boolean DoActorOperate(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (u.ID == 800 || u.ID == 3780 || u.ID == 4550) {
            return false;
        }
        if (u.Rot == u.ActorActionSet.Sit || u.Rot == u.ActorActionSet.Stand) {
            return false;
        }
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics > 0) {
            return false;
        }
        Main.engine.neartag(sp.x, sp.y, sp.z - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp)), sp.sectnum, sp.ang, Engine.neartag, 1024, 3);
        if (Engine.neartag.tagsector >= 0 && Engine.neartag.taghitdist < 1024 && Sector.OperateSector(Engine.neartag.tagsector, false)) {
            u.WaitTics = (short)240;
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Sit);
        }
        if (Engine.neartag.tagwall >= 0 && Engine.neartag.taghitdist < 1024 && Sector.OperateWall(Engine.neartag.tagwall, false)) {
            u.WaitTics = (short)240;
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Stand);
        }
        return true;
    }

    public static Animator DoActorActionDecide(int SpriteNum) {
        int dist;
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        USER pu = null;
        boolean ICanSee = false;
        u.Dist = 0;
        Animator action = InitActorDecide;
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            return action;
        }
        if (Ai.ActorFlaming(SpriteNum)) {
            action = Ai.ChooseAction(GenericFlaming);
            return action;
        }
        ICanSee = Ai.CanSeePlayer(SpriteNum);
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_ACTIVE)) {
            Ai.DoActorOperate(SpriteNum);
            int dist2 = Game.Distance(sp.x, sp.y, Engine.sprite[u.tgt_sp].x, Engine.sprite[u.tgt_sp].y);
            if (dist2 > 30000 && !ICanSee) {
                Sprites.SetEnemyInactive(SpriteNum);
                action = Ai.ChooseAction(u.Personality.LostTarget);
                return action;
            }
            pu = Gameutils.pUser[Ai.GetPlayerSpriteNum(SpriteNum)];
            if (dist2 < Ai.CloseRangeDist(sp, Engine.sprite[u.tgt_sp]) && ICanSee || pu != null && pu.WeaponNum == 0 && u != null && u.ID != 4320 && u.ID != 1580) {
                action = u != null && u.ID == 4277 && MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_TRANSLUCENT) || MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE) ? Ai.ChooseAction(u.Personality.Evasive) : Ai.ChooseAction(u.Personality.CloseRange);
                return action;
            }
            if (Gameutils.FACING(sp, Engine.sprite[u.tgt_sp]) && MyTypes.TEST(u.Flags, Gameutils.SPR_ATTACKED) && ICanSee) {
                if (MyTypes.TEST(u.Flags, Gameutils.SPR_TARGETED)) {
                    u.Flags &= ~Gameutils.SPR_TARGETED;
                    action = u.ActorActionSet.Duck != null && Gameutils.RANDOM_P2(262144) >> 8 < 100 ? InitActorDuck : (u.ID == 4277 && MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_TRANSLUCENT) || MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE) ? Ai.ChooseAction(u.Personality.Evasive) : Ai.ChooseAction(u.Personality.Battle));
                    return action;
                }
                action = u.ID == 4277 && MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_TRANSLUCENT) || MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE) ? Ai.ChooseAction(u.Personality.Evasive) : Ai.ChooseAction(u.Personality.Battle);
                return action;
            }
            if (ICanSee) {
                action = u.ID == 4277 && MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_TRANSLUCENT) || MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE) ? Ai.ChooseAction(u.Personality.Evasive) : Ai.ChooseAction(u.Personality.Offense);
                return action;
            }
            action = Ai.ChooseAction(u.Personality.LostTarget);
            return action;
        }
        if (sp.hitag != 1008) {
            Ai.DoActorPickClosePlayer(SpriteNum);
        }
        if ((dist = Game.Distance(sp.x, sp.y, Engine.sprite[u.tgt_sp].x, Engine.sprite[u.tgt_sp].y)) < 15000 || ICanSee) {
            if (Gameutils.FACING(sp, Engine.sprite[u.tgt_sp]) && dist < 10000 || ICanSee) {
                Ai.DoActorOperate(SpriteNum);
                action = Ai.ChooseAction(u.Personality.Surprised);
                if (!u.DidAlert && ICanSee) {
                    Ai.DoActorNoise(InitActorAlertNoise, SpriteNum);
                    u.DidAlert = true;
                }
                return action;
            }
            Ai.DoActorNoise(Ai.ChooseAction(u.Personality.Broadcast), SpriteNum);
            return action;
        }
        return action;
    }

    public static int InitActorDecide(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.ActorActionFunc = DoActorDecide;
        DoActorDecide.invoke(SpriteNum);
        return 0;
    }

    public static int DoActorCantMoveCloser(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        u.track = (short)Ai.FindTrackToPlayer(u);
        if (u.track >= 0) {
            sp.ang = Main.engine.getangle(Track.Track[u.track].TrackPoint[u.point].x - sp.x, Track.Track[u.track].TrackPoint[u.point].y - sp.y);
            Ai.DoActorSetSpeed(SpriteNum, 2);
            u.Flags |= Gameutils.SPR_FIND_PLAYER;
            u.ActorActionFunc = DoActorDecide;
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        } else {
            InitActorReposition.invoke(SpriteNum);
        }
        return 0;
    }

    public static int FindTrackToPlayer(USER u) {
        int size;
        int[] type;
        SPRITE sp = u.getSprite();
        int zdiff = Gameutils.SPRITEp_UPPER(Engine.sprite[u.tgt_sp]) - (sp.z - Gameutils.SPRITEp_SIZE_Z(sp) + Gameutils.Z(8));
        if (Pragmas.klabs(zdiff) <= Gameutils.Z(20)) {
            type = PlayerOnLevel;
            size = PlayerOnLevel.length;
        } else if (zdiff < 0) {
            type = PlayerAbove;
            size = PlayerAbove.length;
        } else {
            type = PlayerBelow;
            size = PlayerBelow.length;
        }
        for (int i = 0; i < size; ++i) {
            int track = Track.ActorFindTrack(u.SpriteNum, 1, type[i], Game.tmp_ptr[0], Game.tmp_ptr[1]);
            if (track < 0) continue;
            u.point = (short)Game.tmp_ptr[0].value;
            u.track_dir = (short)Game.tmp_ptr[1].value;
            Track.Track[track].flags = (short)(Track.Track[track].flags | Gameutils.TF_TRACK_OCCUPIED);
            return track;
        }
        return -1;
    }

    public static short FindTrackAwayFromPlayer(USER u) {
        for (int i = 0; i < RunAwayTracks.length; ++i) {
            int track = Track.ActorFindTrack(u.SpriteNum, -1, RunAwayTracks[i], Game.tmp_ptr[0], Game.tmp_ptr[1]);
            if (track < 0) continue;
            u.point = (short)Game.tmp_ptr[0].value;
            u.track_dir = (short)Game.tmp_ptr[1].value;
            Track.Track[track].flags = (short)(Track.Track[track].flags | Gameutils.TF_TRACK_OCCUPIED);
            return (short)track;
        }
        return -1;
    }

    public static short FindWanderTrack(USER u) {
        for (int i = 0; i < WanderTracks.length; ++i) {
            int track = Track.ActorFindTrack(u.SpriteNum, -1, WanderTracks[i], Game.tmp_ptr[0], Game.tmp_ptr[1]);
            if (track < 0) continue;
            u.point = (short)Game.tmp_ptr[0].value;
            u.track_dir = (short)Game.tmp_ptr[1].value;
            Track.Track[track].flags = (short)(Track.Track[track].flags | Gameutils.TF_TRACK_OCCUPIED);
            return (short)track;
        }
        return -1;
    }

    public static int InitActorRunAway(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        u.ActorActionFunc = DoActorDecide;
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        u.track = Ai.FindTrackAwayFromPlayer(u);
        if (u.track >= 0) {
            sp.ang = Gameutils.NORM_ANGLE(Main.engine.getangle(Track.Track[u.track].TrackPoint[u.point].x - sp.x, Track.Track[u.track].TrackPoint[u.point].y - sp.y));
            Ai.DoActorSetSpeed(SpriteNum, 3);
            u.Flags |= Gameutils.SPR_RUN_AWAY;
        } else {
            u.Flags |= Gameutils.SPR_RUN_AWAY;
            InitActorReposition.invoke(SpriteNum);
        }
        return 0;
    }

    public static int InitActorRunToward(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.ActorActionFunc = DoActorDecide;
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        InitActorReposition.invoke(SpriteNum);
        Ai.DoActorSetSpeed(SpriteNum, 3);
        return 0;
    }

    public static boolean CHOOSE2(int value) {
        return Gameutils.RANDOM_P2(1024) < value;
    }

    public static int InitActorAttack(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        if (u != null && u.ID == 1095 && u.tgt_sp != -1 && Gameutils.pUser[u.tgt_sp] != null && Gameutils.pUser[u.tgt_sp].PlayerP != -1) {
            if (sp.owner == u.tgt_sp) {
                return 0;
            }
            if (!Weapon.PlayerTakeDamage(Game.Player[Gameutils.pUser[u.tgt_sp].PlayerP], SpriteNum)) {
                return 0;
            }
        }
        if (MyTypes.TEST(Engine.sprite[u.tgt_sp].cstat, Gameutils.CSTAT_SPRITE_TRANSLUCENT)) {
            Ai.InitActorRunAway(SpriteNum);
            return 0;
        }
        if (u.tgt_sp != -1 && Gameutils.pUser[u.tgt_sp] != null && Gameutils.pUser[u.tgt_sp].Health <= 0) {
            Ai.DoActorPickClosePlayer(SpriteNum);
            InitActorReposition.invoke(SpriteNum);
            return 0;
        }
        if (!Ai.CanHitPlayer(SpriteNum)) {
            InitActorReposition.invoke(SpriteNum);
            return 0;
        }
        if (u != null && u.tgt_sp != -1 && Gameutils.pUser[u.tgt_sp] != null && Gameutils.pUser[u.tgt_sp].PlayerP != -1 && MyTypes.TEST(Game.Player[Gameutils.pUser[u.tgt_sp].PlayerP].Flags, Gameutils.PF_DEAD)) {
            Ai.DoActorPickClosePlayer(SpriteNum);
            InitActorReposition.invoke(SpriteNum);
            return 0;
        }
        u.ActorActionFunc = DoActorAttack;
        sp.ang = Gameutils.NORM_ANGLE(Main.engine.getangle(Engine.sprite[u.tgt_sp].x - sp.x, Engine.sprite[u.tgt_sp].y - sp.y));
        if (u != null && u.tgt_sp != -1 && Gameutils.pUser[u.tgt_sp] != null && u.ID == Gameutils.pUser[u.tgt_sp].ID && Gameutils.pUser[u.tgt_sp].PlayerP == -1) {
            Ai.InitActorRunAway(SpriteNum);
            return 0;
        }
        if (u.ActorActionSet.Death2 != null && u.Health < 38 && Ai.CHOOSE2(100)) {
            u.ActorActionFunc = DoActorDecide;
            Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Death2);
            return 0;
        }
        u.ActorActionFunc.invoke(SpriteNum);
        return 0;
    }

    public static int InitActorEvade(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        u.ActorActionFunc = DoActorDecide;
        Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
        u.track = Ai.FindTrackAwayFromPlayer(u);
        if (u.track >= 0) {
            sp.ang = Gameutils.NORM_ANGLE(Main.engine.getangle(Track.Track[u.track].TrackPoint[u.point].x - sp.x, Track.Track[u.track].TrackPoint[u.point].y - sp.y));
            Ai.DoActorSetSpeed(SpriteNum, 3);
            u.Flags &= ~Gameutils.SPR_RUN_AWAY;
        }
        return 0;
    }

    private static int move_scan(int SpriteNum, short ang, int dist, LONGp stopx, LONGp stopy) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        int cliptype = Gameutils.CLIPMASK_ACTOR;
        int x = sp.x;
        int y = sp.y;
        int z = sp.z;
        short sang = sp.ang;
        int loz = u.loz;
        int hiz = u.hiz;
        int lo_sp = u.lo_sp;
        int hi_sp = u.hi_sp;
        short lo_sectp = u.lo_sectp;
        short hi_sectp = u.hi_sectp;
        short ss = sp.sectnum;
        sp.ang = Gameutils.NORM_ANGLE(ang);
        int nx = dist * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
        int ny = dist * Engine.sintable[sp.ang] >> 14;
        int ret = Sprites.move_sprite(SpriteNum, nx, ny, 0, u.ceiling_dist, u.floor_dist, cliptype, 1);
        stopx.value = sp.x;
        stopy.value = sp.y;
        sp.x = x;
        sp.y = y;
        sp.z = z;
        sp.ang = sang;
        u.loz = loz;
        u.hiz = hiz;
        u.lo_sp = lo_sp;
        u.hi_sp = hi_sp;
        u.lo_sectp = lo_sectp;
        u.hi_sectp = hi_sectp;
        Main.engine.changespritesect(SpriteNum, ss);
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private static int FindNewAngle(int SpriteNum, int dir, int DistToMove) {
        u = Gameutils.pUser[SpriteNum];
        sp = Gameutils.pUser[SpriteNum].getSprite();
        adp = null;
        save_ang = -1;
        save_dist = 500;
        if (Ai.ActorFlaming(SpriteNum)) {
            DistToMove = MyTypes.DIV4(DistToMove) + MyTypes.DIV8(DistToMove);
        }
        oang = Gameutils.NORM_ANGLE(Main.engine.getangle(Engine.sprite[u.tgt_sp].x - sp.x, Engine.sprite[u.tgt_sp].y - sp.y));
        switch (dir) {
            case 1: {
                adp = Ai.toward_angle_delta[Gameutils.RANDOM_P2(1024) >> 8];
                break;
            }
            case -1: {
                adp = Ai.CanHitPlayer(SpriteNum) != false ? Ai.toward_angle_delta[Gameutils.RANDOM_P2(1024) >> 8] : Ai.away_angle_delta[Gameutils.RANDOM_P2(1024) >> 8];
            }
        }
        ptr = 0;
        while (adp[ptr] != -99) {
            new_ang = Gameutils.NORM_ANGLE(oang + adp[ptr]);
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_NO_SCAREDZ | Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING | Gameutils.SPR_SWIMMING | Gameutils.SPR_DEAD)) ** GOTO lbl24
            sp.ang = new_ang;
            if (Sprites.DropAhead(SpriteNum, u.lo_step)) {
                sp.ang = oang;
            } else {
                sp.ang = oang;
lbl24:
                // 2 sources

                ret = Ai.move_scan(SpriteNum, new_ang, DistToMove, Game.tmp_ptr[0], Game.tmp_ptr[1]);
                stopx = Game.tmp_ptr[0].value;
                stopy = Game.tmp_ptr[1].value;
                if (ret == 0) {
                    u.TargetDist = (short)Game.Distance(sp.x, sp.y, stopx, stopy);
                    return new_ang;
                }
                dist = Game.Distance(sp.x, sp.y, stopx, stopy);
                if (dist > save_dist) {
                    save_ang = new_ang;
                    save_dist = dist;
                }
            }
            ++ptr;
        }
        if (save_ang != -1) {
            u.TargetDist = (short)save_dist;
            if (u.TargetDist > 4000) {
                u.TargetDist = (short)(u.TargetDist - 3500);
            }
            sp.ang = (short)save_ang;
            return save_ang;
        }
        return -1;
    }

    public static int InitActorPause(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.ActorActionFunc = DoActorPause;
        u.ActorActionFunc.invoke(SpriteNum);
        return 0;
    }

    public static void AiSaveable() {
        Saveable.SaveData(InitActorDecide);
        Saveable.SaveData(DoActorDecide);
        Saveable.SaveData(InitActorAlertNoise);
        Saveable.SaveData(InitActorAmbientNoise);
        Saveable.SaveData(InitActorAttackNoise);
        Saveable.SaveData(InitActorPainNoise);
        Saveable.SaveData(InitActorDieNoise);
        Saveable.SaveData(InitActorExtra1Noise);
        Saveable.SaveData(InitActorExtra2Noise);
        Saveable.SaveData(InitActorExtra3Noise);
        Saveable.SaveData(InitActorExtra4Noise);
        Saveable.SaveData(InitActorExtra5Noise);
        Saveable.SaveData(InitActorExtra6Noise);
        Saveable.SaveData(InitActorMoveCloser);
        Saveable.SaveData(DoActorMoveCloser);
        Saveable.SaveData(InitActorRunAway);
        Saveable.SaveData(InitActorRunToward);
        Saveable.SaveData(InitActorAttack);
        Saveable.SaveData(DoActorAttack);
        Saveable.SaveData(InitActorEvade);
        Saveable.SaveData(InitActorWanderAround);
        Saveable.SaveData(InitActorFindPlayer);
        Saveable.SaveData(InitActorDuck);
        Saveable.SaveData(DoActorDuck);
        Saveable.SaveData(DoActorMoveJump);
        Saveable.SaveData(InitActorReposition);
        Saveable.SaveData(DoActorReposition);
        Saveable.SaveData(DoActorPause);
    }

    public static enum Attrib_Snds {
        attr_ambient,
        attr_alert,
        attr_attack,
        attr_pain,
        attr_die,
        attr_extra1,
        attr_extra2,
        attr_extra3,
        attr_extra4,
        attr_extra5,
        attr_extra6;

    }
}

