/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class GirlNinj {
    private static final Decision[] GirlNinjaBattle = new Decision[]{new Decision(499, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] GirlNinjaOffense = new Decision[]{new Decision(499, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] GirlNinjaBroadcast = new Decision[]{new Decision(6, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] GirlNinjaSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] GirlNinjaEvasive = new Decision[]{new Decision(400, Ai.InitActorDuck), new Decision(1024, null)};
    private static final Decision[] GirlNinjaLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] GirlNinjaCloseRange = new Decision[]{new Decision(900, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality GirlNinjaPersonality = new Personality(GirlNinjaBattle, GirlNinjaOffense, GirlNinjaBroadcast, GirlNinjaSurprised, GirlNinjaEvasive, GirlNinjaLostTarget, GirlNinjaCloseRange, GirlNinjaCloseRange);
    private static final ATTRIBUTE GirlNinjaAttrib = new ATTRIBUTE(new short[]{120, 140, 160, 190}, new short[]{4, 0, 0, -2}, 3, new int[]{577, 577, 2, 575, 576, 0, 0, 0, 0, 0});
    public static final int GIRLNINJA_RATE = 18;
    private static final Animator DoGirlNinjaMove = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return GirlNinj.DoGirlNinjaMove(SpriteNum) != 0;
        }
    };
    private static final State[][] s_GirlNinjaRun = new State[][]{{new State(5162, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5163, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5164, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5165, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove)}, {new State(5166, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5167, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5168, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5169, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove)}, {new State(5170, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5171, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5172, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5173, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove)}, {new State(5174, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5175, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5176, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5177, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove)}, {new State(5178, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5179, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5180, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove), new State(5181, 0x12 | Gameutils.SF_TIC_ADJUST, DoGirlNinjaMove)}};
    public static final int GIRLNINJA_STAND_RATE = 10;
    private static final State[][] s_GirlNinjaStand = new State[][]{{new State(5162, 10, DoGirlNinjaMove).setNext()}, {new State(5166, 10, DoGirlNinjaMove).setNext()}, {new State(5170, 10, DoGirlNinjaMove).setNext()}, {new State(5174, 10, DoGirlNinjaMove).setNext()}, {new State(5178, 10, DoGirlNinjaMove).setNext()}};
    public static final int GIRLNINJA_RISE_RATE = 10;
    private static final Animator NullGirlNinja = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return GirlNinj.NullGirlNinja(SpriteNum) != 0;
        }
    };
    private static final State[][] s_GirlNinjaRise = new State[][]{{new State(5211, 10, NullGirlNinja), new State(5162, 10, NullGirlNinja), new State(0, 0, null)}, {new State(5212, 10, NullGirlNinja), new State(5166, 10, NullGirlNinja), new State(0, 0, null)}, {new State(5213, 10, NullGirlNinja), new State(5170, 10, NullGirlNinja), new State(0, 0, null)}, {new State(5214, 10, NullGirlNinja), new State(5174, 10, NullGirlNinja), new State(0, 0, null)}, {new State(5215, 10, NullGirlNinja), new State(5178, 10, NullGirlNinja), new State(0, 0, null)}};
    public static final int GIRLNINJA_DUCK_RATE = 10;
    public static final int GIRLNINJA_CRAWL_RATE = 14;
    private static final State[][] s_GirlNinjaDuck = new State[][]{{new State(5211, 10, NullGirlNinja), new State(5211, 14, DoGirlNinjaMove).setNext()}, {new State(5212, 10, NullGirlNinja), new State(5212, 14, DoGirlNinjaMove).setNext()}, {new State(5213, 10, NullGirlNinja), new State(5213, 14, DoGirlNinjaMove).setNext()}, {new State(5214, 10, NullGirlNinja), new State(5214, 14, DoGirlNinjaMove).setNext()}, {new State(5215, 10, NullGirlNinja), new State(5215, 14, DoGirlNinjaMove).setNext()}};
    private static final State[][] s_GirlNinjaSit = new State[][]{{new State(5211, 10, DoGirlNinjaMove).setNext()}, {new State(5212, 10, DoGirlNinjaMove).setNext()}, {new State(5213, 10, DoGirlNinjaMove).setNext()}, {new State(5214, 10, DoGirlNinjaMove).setNext()}, {new State(5215, 10, DoGirlNinjaMove).setNext()}};
    public static final int GIRLNINJA_JUMP_RATE = 24;
    private static final State[][] s_GirlNinjaJump = new State[][]{{new State(5226, 24, DoGirlNinjaMove), new State(5227, 24, DoGirlNinjaMove).setNext()}, {new State(5230, 24, DoGirlNinjaMove), new State(5231, 24, DoGirlNinjaMove).setNext()}, {new State(5234, 24, DoGirlNinjaMove), new State(5235, 24, DoGirlNinjaMove).setNext()}, {new State(5238, 24, DoGirlNinjaMove), new State(5239, 24, DoGirlNinjaMove).setNext()}, {new State(5242, 24, DoGirlNinjaMove), new State(5243, 24, DoGirlNinjaMove).setNext()}};
    public static final int GIRLNINJA_FALL_RATE = 16;
    private static final State[][] s_GirlNinjaFall = new State[][]{{new State(5227, 16, DoGirlNinjaMove), new State(5228, 16, DoGirlNinjaMove).setNext()}, {new State(5231, 16, DoGirlNinjaMove), new State(5232, 16, DoGirlNinjaMove).setNext()}, {new State(5235, 16, DoGirlNinjaMove), new State(5236, 16, DoGirlNinjaMove).setNext()}, {new State(5239, 16, DoGirlNinjaMove), new State(5240, 16, DoGirlNinjaMove).setNext()}, {new State(5243, 16, DoGirlNinjaMove), new State(5244, 16, DoGirlNinjaMove).setNext()}};
    public static final int GIRLNINJA_PAIN_RATE = 15;
    private static final Animator DoGirlNinjaPain = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return GirlNinj.DoGirlNinjaPain(SpriteNum) != 0;
        }
    };
    private static final State[][] s_GirlNinjaPain = new State[][]{{new State(5192, 15, DoGirlNinjaPain).setNext()}, {new State(5192, 15, DoGirlNinjaPain).setNext()}, {new State(5192, 15, DoGirlNinjaPain).setNext()}, {new State(5192, 15, DoGirlNinjaPain).setNext()}, {new State(5192, 15, DoGirlNinjaPain).setNext()}};
    public static final int GIRLNINJA_STICKY_RATE = 32;
    private static final Animator InitEnemyMine = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Weapon.InitEnemyMine(SpriteNum) != 0;
        }
    };
    private static final State[][] s_GirlNinjaSticky = new State[][]{{new State(5246, 64, NullGirlNinja), new State(5246, 32, NullGirlNinja), new State(5247, 0 | Gameutils.SF_QUICK_CALL, InitEnemyMine), new State(5247, 64, NullGirlNinja), new State(5248, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5248, 32, DoGirlNinjaMove).setNext()}, {new State(5249, 64, NullGirlNinja), new State(5249, 32, NullGirlNinja), new State(5250, 0 | Gameutils.SF_QUICK_CALL, InitEnemyMine), new State(5250, 64, NullGirlNinja), new State(5251, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5251, 32, DoGirlNinjaMove).setNext()}, {new State(5252, 64, NullGirlNinja), new State(5252, 32, NullGirlNinja), new State(5253, 0 | Gameutils.SF_QUICK_CALL, InitEnemyMine), new State(5253, 64, NullGirlNinja), new State(5254, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5254, 32, DoGirlNinjaMove).setNext()}, {new State(5252, 64, NullGirlNinja), new State(5252, 32, NullGirlNinja), new State(5253, 0 | Gameutils.SF_QUICK_CALL, InitEnemyMine), new State(5253, 64, NullGirlNinja), new State(5254, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5254, 32, DoGirlNinjaMove).setNext()}, {new State(5252, 64, NullGirlNinja), new State(5252, 32, NullGirlNinja), new State(5253, 0 | Gameutils.SF_QUICK_CALL, InitEnemyMine), new State(5253, 64, NullGirlNinja), new State(5254, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5254, 32, DoGirlNinjaMove).setNext()}};
    public static final int GIRLNINJA_CROSSBOW_RATE = 14;
    private static final Animator InitEnemyCrossbow = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Weapon.InitEnemyCrossbow(SpriteNum) != 0;
        }
    };
    private static final State[][] s_GirlNinjaCrossbow = new State[][]{{new State(5182, 28, NullGirlNinja), new State(5183, 0 | Gameutils.SF_QUICK_CALL, InitEnemyCrossbow), new State(5183, 14, NullGirlNinja), new State(5183, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5183, 14, DoGirlNinjaMove).setNext()}, {new State(5184, 28, NullGirlNinja), new State(5185, 0 | Gameutils.SF_QUICK_CALL, InitEnemyCrossbow), new State(5185, 14, NullGirlNinja), new State(5185, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5185, 14, DoGirlNinjaMove).setNext()}, {new State(5186, 28, NullGirlNinja), new State(5187, 0 | Gameutils.SF_QUICK_CALL, InitEnemyCrossbow), new State(5187, 14, NullGirlNinja), new State(5187, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5187, 14, DoGirlNinjaMove).setNext()}, {new State(5188, 28, NullGirlNinja), new State(5189, 0 | Gameutils.SF_QUICK_CALL, InitEnemyCrossbow), new State(5189, 14, NullGirlNinja), new State(5189, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5189, 14, DoGirlNinjaMove).setNext()}, {new State(5190, 28, NullGirlNinja), new State(5191, 0 | Gameutils.SF_QUICK_CALL, InitEnemyCrossbow), new State(5191, 14, NullGirlNinja), new State(5191, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5191, 14, DoGirlNinjaMove).setNext()}};
    public static final int GIRLNINJA_DIE_RATE = 30;
    private static final Animator DoGirlNinjaSpecial = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return GirlNinj.DoGirlNinjaSpecial(SpriteNum) != 0;
        }
    };
    private static final State[] s_GirlNinjaDie = new State[]{new State(5197, 60, NullGirlNinja), new State(5198, 30, NullGirlNinja), new State(5199, 30, NullGirlNinja), new State(5200, 30, NullGirlNinja), new State(5201, 30, NullGirlNinja), new State(5202, 30, NullGirlNinja), new State(5203, 30, NullGirlNinja), new State(5203, Gameutils.SF_QUICK_CALL, DoGirlNinjaSpecial), new State(5204, 30, NullGirlNinja), new State(5205, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(5205, 30, Actor.DoActorDebris).setNext()};
    private static final State[] s_GirlNinjaDead = new State[]{new State(5203, 30, Actor.DoActorDebris), new State(5204, Gameutils.SF_QUICK_CALL, DoGirlNinjaSpecial), new State(5204, 30, Actor.DoActorDebris), new State(5205, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(5205, 30, Actor.DoActorDebris).setNext()};
    private static final Animator DoActorDeathMove = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Actor.DoActorDeathMove(SpriteNum) != 0;
        }
    };
    private static final State[] s_GirlNinjaDeathJump = new State[]{new State(5197, 30, DoActorDeathMove), new State(5198, 30, DoActorDeathMove), new State(5199, 30, DoActorDeathMove).setNext()};
    private static final State[] s_GirlNinjaDeathFall = new State[]{new State(5200, 30, DoActorDeathMove), new State(5201, 30, DoActorDeathMove).setNext()};
    private static final Actor_Action_Set GirlNinjaActionSet = new Actor_Action_Set(GNinjaStateGroup.sg_GirlNinjaStand, GNinjaStateGroup.sg_GirlNinjaRun, GNinjaStateGroup.sg_GirlNinjaJump, GNinjaStateGroup.sg_GirlNinjaFall, null, null, null, GNinjaStateGroup.sg_GirlNinjaRise, GNinjaStateGroup.sg_GirlNinjaSit, null, null, GNinjaStateGroup.sg_GirlNinjaPain, GNinjaStateGroup.sg_GirlNinjaDie, null, GNinjaStateGroup.sg_GirlNinjaDead, GNinjaStateGroup.sg_GirlNinjaDeathJump, GNinjaStateGroup.sg_GirlNinjaDeathFall, new Sprites.StateGroup[]{GNinjaStateGroup.sg_GirlNinjaCrossbow, GNinjaStateGroup.sg_GirlNinjaSticky}, new short[]{800, 1024}, new Sprites.StateGroup[]{GNinjaStateGroup.sg_GirlNinjaCrossbow, GNinjaStateGroup.sg_GirlNinjaSticky}, new short[]{800, 1024}, null, GNinjaStateGroup.sg_GirlNinjaDuck, null);

    public static void InitGNinjaStates() {
        for (GNinjaStateGroup sg : GNinjaStateGroup.values()) {
            for (int rot = 0; rot < sg.group.length; ++rot) {
                State.InitState(sg.group[rot]);
                if (sg != GNinjaStateGroup.sg_GirlNinjaRise) continue;
                sg.group[rot][2].setNextGroup(GNinjaStateGroup.sg_GirlNinjaRun);
            }
        }
    }

    public static int SetupGirlNinja(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 5162, s_GirlNinjaRun[0][0]);
            u.Health = (short)100;
        }
        u.StateEnd = s_GirlNinjaDie[0];
        u.Rot = GNinjaStateGroup.sg_GirlNinjaRun;
        sp.xrepeat = (short)51;
        sp.yrepeat = (short)43;
        u.Attrib = GirlNinjaAttrib;
        u.spal = (byte)26;
        sp.pal = (short)26;
        Coolie.EnemyDefaults(SpriteNum, GirlNinjaActionSet, GirlNinjaPersonality);
        Sprites.ChangeState(SpriteNum, s_GirlNinjaRun[0][0]);
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.Radius = 280;
        u.Flags &= ~Gameutils.SPR_XFLIP_TOGGLE;
        return 0;
    }

    private static int DoGirlNinjaMove(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING) && !MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoActorJump(SpriteNum);
            } else if (MyTypes.TEST(u.Flags, Gameutils.SPR_FALLING)) {
                Actor.DoActorFall(SpriteNum);
            }
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING) && !MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.invoke(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING | Gameutils.SPR_CLIMBING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    private static int NullGirlNinja(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (u.WaitTics > 0) {
            u.WaitTics = (short)(u.WaitTics - 6);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING) && !MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING) && !MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING) && !MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            Actor.KeepActorOnFloor(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    private static int DoGirlNinjaPain(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        GirlNinj.NullGirlNinja(SpriteNum);
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
        return 0;
    }

    private static int DoGirlNinjaSpecial(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (u.spal == 21) {
            sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_TRANSLUCENT);
            sp.hitag = 0;
            sp.shade = (byte)-10;
        }
        return 0;
    }

    public static void GirlNinjSaveable() {
        Saveable.SaveData(InitEnemyMine);
        Saveable.SaveData(InitEnemyCrossbow);
        Saveable.SaveData(DoActorDeathMove);
        Saveable.SaveData(DoGirlNinjaMove);
        Saveable.SaveData(NullGirlNinja);
        Saveable.SaveData(DoGirlNinjaPain);
        Saveable.SaveData(DoGirlNinjaSpecial);
        Saveable.SaveData(GirlNinjaPersonality);
        Saveable.SaveData(GirlNinjaAttrib);
        Saveable.SaveData(s_GirlNinjaRun);
        Saveable.SaveGroup(GNinjaStateGroup.sg_GirlNinjaRun);
        Saveable.SaveData(s_GirlNinjaStand);
        Saveable.SaveGroup(GNinjaStateGroup.sg_GirlNinjaStand);
        Saveable.SaveData(s_GirlNinjaRise);
        Saveable.SaveGroup(GNinjaStateGroup.sg_GirlNinjaRise);
        Saveable.SaveData(s_GirlNinjaDuck);
        Saveable.SaveGroup(GNinjaStateGroup.sg_GirlNinjaDuck);
        Saveable.SaveData(s_GirlNinjaSit);
        Saveable.SaveGroup(GNinjaStateGroup.sg_GirlNinjaSit);
        Saveable.SaveData(s_GirlNinjaJump);
        Saveable.SaveGroup(GNinjaStateGroup.sg_GirlNinjaJump);
        Saveable.SaveData(s_GirlNinjaFall);
        Saveable.SaveGroup(GNinjaStateGroup.sg_GirlNinjaFall);
        Saveable.SaveData(s_GirlNinjaPain);
        Saveable.SaveGroup(GNinjaStateGroup.sg_GirlNinjaPain);
        Saveable.SaveData(s_GirlNinjaSticky);
        Saveable.SaveGroup(GNinjaStateGroup.sg_GirlNinjaSticky);
        Saveable.SaveData(s_GirlNinjaCrossbow);
        Saveable.SaveGroup(GNinjaStateGroup.sg_GirlNinjaCrossbow);
        Saveable.SaveData(s_GirlNinjaDie);
        Saveable.SaveData(s_GirlNinjaDead);
        Saveable.SaveData(s_GirlNinjaDeathJump);
        Saveable.SaveData(s_GirlNinjaDeathFall);
        Saveable.SaveData(GirlNinjaActionSet);
    }

    static /* synthetic */ State[][] access$000() {
        return s_GirlNinjaStand;
    }

    static /* synthetic */ State[][] access$100() {
        return s_GirlNinjaRun;
    }

    static /* synthetic */ State[][] access$200() {
        return s_GirlNinjaJump;
    }

    static /* synthetic */ State[][] access$300() {
        return s_GirlNinjaFall;
    }

    static /* synthetic */ State[][] access$400() {
        return s_GirlNinjaRise;
    }

    static /* synthetic */ State[][] access$500() {
        return s_GirlNinjaSit;
    }

    static /* synthetic */ State[][] access$600() {
        return s_GirlNinjaPain;
    }

    static /* synthetic */ State[] access$700() {
        return s_GirlNinjaDie;
    }

    static /* synthetic */ State[] access$800() {
        return s_GirlNinjaDead;
    }

    static /* synthetic */ State[] access$900() {
        return s_GirlNinjaDeathJump;
    }

    static /* synthetic */ State[] access$1000() {
        return s_GirlNinjaDeathFall;
    }

    static /* synthetic */ State[][] access$1100() {
        return s_GirlNinjaCrossbow;
    }

    static /* synthetic */ State[][] access$1200() {
        return s_GirlNinjaSticky;
    }

    static /* synthetic */ State[][] access$1300() {
        return s_GirlNinjaDuck;
    }

    public static enum GNinjaStateGroup implements Sprites.StateGroup
    {
        sg_GirlNinjaStand(GirlNinj.access$000()[0], GirlNinj.access$000()[1], GirlNinj.access$000()[2], GirlNinj.access$000()[3], GirlNinj.access$000()[4]),
        sg_GirlNinjaRun(GirlNinj.access$100()[0], GirlNinj.access$100()[1], GirlNinj.access$100()[2], GirlNinj.access$100()[3], GirlNinj.access$100()[4]),
        sg_GirlNinjaJump(GirlNinj.access$200()[0], GirlNinj.access$200()[1], GirlNinj.access$200()[2], GirlNinj.access$200()[3], GirlNinj.access$200()[4]),
        sg_GirlNinjaFall(GirlNinj.access$300()[0], GirlNinj.access$300()[1], GirlNinj.access$300()[2], GirlNinj.access$300()[3], GirlNinj.access$300()[4]),
        sg_GirlNinjaRise(GirlNinj.access$400()[0], GirlNinj.access$400()[1], GirlNinj.access$400()[2], GirlNinj.access$400()[3], GirlNinj.access$400()[4]),
        sg_GirlNinjaSit(GirlNinj.access$500()[0], GirlNinj.access$500()[1], GirlNinj.access$500()[2], GirlNinj.access$500()[3], GirlNinj.access$500()[4]),
        sg_GirlNinjaPain(GirlNinj.access$600()[0], GirlNinj.access$600()[1], GirlNinj.access$600()[2], GirlNinj.access$600()[3], GirlNinj.access$600()[4]),
        sg_GirlNinjaDie(new State[][]{GirlNinj.access$700()}),
        sg_GirlNinjaDead(new State[][]{GirlNinj.access$800()}),
        sg_GirlNinjaDeathJump(new State[][]{GirlNinj.access$900()}),
        sg_GirlNinjaDeathFall(new State[][]{GirlNinj.access$1000()}),
        sg_GirlNinjaCrossbow(GirlNinj.access$1100()[0], GirlNinj.access$1100()[1], GirlNinj.access$1100()[2], GirlNinj.access$1100()[3], GirlNinj.access$1100()[4]),
        sg_GirlNinjaSticky(GirlNinj.access$1200()[0], GirlNinj.access$1200()[1], GirlNinj.access$1200()[2], GirlNinj.access$1200()[3], GirlNinj.access$1200()[4]),
        sg_GirlNinjaDuck(GirlNinj.access$1300()[0], GirlNinj.access$1300()[1], GirlNinj.access$1300()[2], GirlNinj.access$1300()[3], GirlNinj.access$1300()[4]);

        private final State[][] group;
        private int index = -1;

        private GNinjaStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

