/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Hornet;
import ru.m210projects.Wang.Enemies.Ninja;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Enemies.Ripper;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Weapon;

public class Ripper2 {
    public static final Animator InitRipper2Charge = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Ripper2.InitRipper2Charge(spr) != 0;
        }
    };
    public static final Animator InitRipper2Hang = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Ripper2.InitRipper2Hang(spr) != 0;
        }
    };
    private static final Decision[] Ripper2Battle = new Decision[]{new Decision(879, InitRipper2Charge), new Decision(883, Ai.InitActorAttackNoise), new Decision(900, InitRipper2Hang), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] Ripper2Offense = new Decision[]{new Decision(789, Ai.InitActorMoveCloser), new Decision(790, Ai.InitActorAttackNoise), new Decision(800, InitRipper2Hang), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] Ripper2Broadcast = new Decision[]{new Decision(3, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] Ripper2Surprised = new Decision[]{new Decision(40, InitRipper2Hang), new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] Ripper2Evasive = new Decision[]{new Decision(10, Ai.InitActorMoveCloser), new Decision(1024, InitRipper2Charge)};
    private static final Decision[] Ripper2LostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] Ripper2CloseRange = new Decision[]{new Decision(1024, Ai.InitActorAttack)};
    private static final Personality Ripper2Personality = new Personality(Ripper2Battle, Ripper2Offense, Ripper2Broadcast, Ripper2Surprised, Ripper2Evasive, Ripper2LostTarget, Ripper2CloseRange, Ripper2CloseRange);
    private static final ATTRIBUTE Ripper2Attrib = new ATTRIBUTE(new short[]{100, 120, 300, 380}, new short[]{5, 0, -2, -4}, 3, new int[]{313, 314, 315, 316, 317, 318, 0, 0, 0, 0});
    private static final int RIPPER2_RUN_RATE = 16;
    public static final Animator DoRipper2Move = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Ripper2.DoRipper2Move(spr) != 0;
        }
    };
    public static final Animator NullRipper2 = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Ripper2.NullRipper2(spr) != 0;
        }
    };
    public static final Animator DoRipper2MoveJump = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Ripper2.DoRipper2MoveJump(spr) != 0;
        }
    };
    private static final State[][] s_Ripper2Run = new State[][]{{new State(4320, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4321, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4322, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4323, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4324, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4325, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4326, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4327, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4328, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4329, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4330, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4331, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4332, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4333, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4334, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4335, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4336, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4337, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4338, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4339, 0x10 | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}};
    private static final int RIPPER2_STAND_RATE = 12;
    private static final State[][] s_Ripper2Stand = new State[][]{{new State(4377, 12, DoRipper2Move).setNext()}, {new State(4381, 12, DoRipper2Move).setNext()}, {new State(4385, 12, DoRipper2Move).setNext()}, {new State(4389, 12, DoRipper2Move).setNext()}, {new State(4393, 12, DoRipper2Move).setNext()}};
    private static final int RIPPER2_RUNFAST_RATE = 14;
    private static final State[][] s_Ripper2RunFast = new State[][]{{new State(4340, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4341, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4342, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4343, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4344, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4345, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4346, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4347, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4348, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4349, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4350, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4351, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4352, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4353, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4354, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4355, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}, {new State(4356, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4357, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4358, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move), new State(4359, 0xE | Gameutils.SF_TIC_ADJUST, DoRipper2Move)}};
    private static final int RIPPER2_JUMP_RATE = 25;
    private static final State[][] s_Ripper2Jump = new State[][]{{new State(4374, 25, NullRipper2), new State(4375, 25, DoRipper2MoveJump).setNext()}, {new State(4378, 25, NullRipper2), new State(4379, 25, DoRipper2MoveJump).setNext()}, {new State(4382, 25, NullRipper2), new State(4383, 25, DoRipper2MoveJump).setNext()}, {new State(4386, 25, NullRipper2), new State(4387, 25, DoRipper2MoveJump).setNext()}, {new State(4390, 25, NullRipper2), new State(4391, 25, DoRipper2MoveJump).setNext()}};
    private static final int RIPPER2_DIE_RATE = 18;
    private static final State[] s_Ripper2Die = new State[]{new State(4414, 18, NullRipper2), new State(4415, 18, NullRipper2), new State(4416, 18, NullRipper2), new State(4417, 18, NullRipper2), new State(4418, 18, NullRipper2), new State(4419, 18, NullRipper2), new State(4420, 18, NullRipper2), new State(4421, 18, Actor.DoActorDebris).setNext()};
    public static final Animator InitRipperSlash = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Weapon.InitRipperSlash(spr) != 0;
        }
    };
    private static final int RIPPER2_SWIPE_RATE = 14;
    private static final State[][] s_Ripper2Swipe = new State[][]{{new State(4394, 14, NullRipper2), new State(4395, 14, NullRipper2), new State(4395, 0 | Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4396, 14, NullRipper2), new State(4397, 14, NullRipper2), new State(4397, 0 | Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4397, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4397, 14, DoRipper2Move).setNext()}, {new State(4398, 14, NullRipper2), new State(4399, 14, NullRipper2), new State(4399, 0 | Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4400, 14, NullRipper2), new State(4401, 14, NullRipper2), new State(4401, 0 | Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4401, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4401, 14, DoRipper2Move).setNext()}, {new State(4402, 14, NullRipper2), new State(4403, 14, NullRipper2), new State(4403, 0 | Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4404, 14, NullRipper2), new State(4405, 14, NullRipper2), new State(4405, 0 | Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4405, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4405, 14, DoRipper2Move).setNext()}, {new State(4406, 14, NullRipper2), new State(4407, 14, NullRipper2), new State(4407, 0 | Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4408, 14, NullRipper2), new State(4409, 14, NullRipper2), new State(4409, 0 | Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4409, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4409, 14, DoRipper2Move).setNext()}, {new State(4410, 14, NullRipper2), new State(4411, 14, NullRipper2), new State(4411, 0 | Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4412, 14, NullRipper2), new State(4413, 14, NullRipper2), new State(4413, 0 | Gameutils.SF_QUICK_CALL, InitRipperSlash), new State(4413, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4413, 14, DoRipper2Move).setNext()}};
    private static final int RIPPER2_MEKONG_RATE = 18;
    public static final Animator ChestRipper2 = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Ripper2.ChestRipper2(spr) != 0;
        }
    };
    private static final State[][] s_Ripper2Kong = new State[][]{{new State(4360, 18, NullRipper2), new State(4360, Gameutils.SF_QUICK_CALL, ChestRipper2), new State(4361, 18, NullRipper2), new State(4362, 18, NullRipper2), new State(4363, 18, NullRipper2), new State(4363, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4360, 18, DoRipper2Move).setNext()}, {new State(4363, 18, NullRipper2), new State(4360, Gameutils.SF_QUICK_CALL, ChestRipper2), new State(4364, 18, NullRipper2), new State(4365, 18, NullRipper2), new State(4366, 18, NullRipper2), new State(4366, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4363, 18, DoRipper2Move).setNext()}, {new State(4366, 18, NullRipper2), new State(4360, Gameutils.SF_QUICK_CALL, ChestRipper2), new State(4367, 18, NullRipper2), new State(4368, 18, NullRipper2), new State(4369, 18, NullRipper2), new State(4369, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4366, 18, DoRipper2Move).setNext()}, {new State(4369, 18, NullRipper2), new State(4360, Gameutils.SF_QUICK_CALL, ChestRipper2), new State(4370, 18, NullRipper2), new State(4371, 18, NullRipper2), new State(4372, 18, NullRipper2), new State(4372, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4369, 18, DoRipper2Move).setNext()}, {new State(4372, 18, NullRipper2), new State(4360, Gameutils.SF_QUICK_CALL, ChestRipper2), new State(4373, 18, NullRipper2), new State(4374, 18, NullRipper2), new State(4375, 18, NullRipper2), new State(4375, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(4372, 18, DoRipper2Move).setNext()}};
    private static final int RIPPER2_HEART_RATE = 20;
    public static final Animator DoRipper2StandHeart = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Ripper2.DoRipper2StandHeart(spr) != 0;
        }
    };
    private static final State[][] s_Ripper2Heart = new State[][]{{new State(4422, 20, DoRipper2StandHeart), new State(4423, 20, DoRipper2StandHeart)}, {new State(4422, 20, DoRipper2StandHeart), new State(4423, 20, DoRipper2StandHeart)}, {new State(4422, 20, DoRipper2StandHeart), new State(4423, 20, DoRipper2StandHeart)}, {new State(4422, 20, DoRipper2StandHeart), new State(4423, 20, DoRipper2StandHeart)}, {new State(4422, 20, DoRipper2StandHeart), new State(4423, 20, DoRipper2StandHeart)}};
    private static final int RIPPER2_HANG_RATE = 14;
    public static final Animator DoRipper2Hang = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Ripper2.DoRipper2Hang(spr) != 0;
        }
    };
    private static final State[][] s_Ripper2Hang = new State[][]{{new State(4369, 14, DoRipper2Hang).setNext()}, {new State(4370, 14, DoRipper2Hang).setNext()}, {new State(4371, 14, DoRipper2Hang).setNext()}, {new State(4372, 14, DoRipper2Hang).setNext()}, {new State(4373, 14, DoRipper2Hang).setNext()}};
    private static final int RIPPER2_PAIN_RATE = 38;
    public static final Animator DoRipper2Pain = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Ripper2.DoRipper2Pain(spr) != 0;
        }
    };
    private static final State[][] s_Ripper2Pain = new State[][]{{new State(4414, 38, DoRipper2Pain).setNext()}, {new State(4414, 38, DoRipper2Pain).setNext()}, {new State(4414, 38, DoRipper2Pain).setNext()}, {new State(4414, 38, DoRipper2Pain).setNext()}, {new State(4414, 38, DoRipper2Pain).setNext()}};
    private static final int RIPPER2_FALL_RATE = 25;
    private static final State[][] s_Ripper2Fall = new State[][]{{new State(4376, 25, DoRipper2MoveJump).setNext()}, {new State(4380, 25, DoRipper2MoveJump).setNext()}, {new State(4384, 25, DoRipper2MoveJump).setNext()}, {new State(4388, 25, DoRipper2MoveJump).setNext()}, {new State(4392, 25, DoRipper2MoveJump).setNext()}};
    private static final int RIPPER2_JUMP_ATTACK_RATE = 35;
    public static final Animator DoRipper2BeginJumpAttack = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Ripper2.DoRipper2BeginJumpAttack(spr) != 0;
        }
    };
    private static final State[][] s_Ripper2JumpAttack = new State[][]{{new State(4374, 35, NullRipper2), new State(4374, 0 | Gameutils.SF_QUICK_CALL, DoRipper2BeginJumpAttack), new State(4376, 35, DoRipper2MoveJump), new State(4375, 35, DoRipper2MoveJump).setNext()}, {new State(4378, 35, NullRipper2), new State(4378, 0 | Gameutils.SF_QUICK_CALL, DoRipper2BeginJumpAttack), new State(4380, 35, DoRipper2MoveJump), new State(4379, 35, DoRipper2MoveJump).setNext()}, {new State(4382, 35, NullRipper2), new State(4382, 0 | Gameutils.SF_QUICK_CALL, DoRipper2BeginJumpAttack), new State(4384, 35, DoRipper2MoveJump), new State(4379, 35, DoRipper2MoveJump).setNext()}, {new State(4386, 35, NullRipper2), new State(4386, 0 | Gameutils.SF_QUICK_CALL, DoRipper2BeginJumpAttack), new State(4388, 35, DoRipper2MoveJump), new State(4379, 35, DoRipper2MoveJump).setNext()}, {new State(4390, 35, NullRipper2), new State(4390, 0 | Gameutils.SF_QUICK_CALL, DoRipper2BeginJumpAttack), new State(4392, 35, DoRipper2MoveJump), new State(4379, 35, DoRipper2MoveJump).setNext()}};
    public static final Animator DoRipper2HangJF = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Ripper2.DoRipper2HangJF(spr) != 0;
        }
    };
    private static final int RIPPER2_HANG_JUMP_RATE = 20;
    private static final State[][] s_Ripper2HangJump = new State[][]{{new State(4374, 20, NullRipper2), new State(4375, 20, DoRipper2HangJF).setNext()}, {new State(4378, 20, NullRipper2), new State(4379, 20, DoRipper2HangJF).setNext()}, {new State(4382, 20, NullRipper2), new State(4383, 20, DoRipper2HangJF).setNext()}, {new State(4386, 20, NullRipper2), new State(4387, 20, DoRipper2HangJF).setNext()}, {new State(4390, 20, NullRipper2), new State(4391, 20, DoRipper2HangJF).setNext()}};
    private static final State[][] s_Ripper2HangFall = new State[][]{{new State(4376, 25, DoRipper2HangJF).setNext()}, {new State(4380, 25, DoRipper2HangJF).setNext()}, {new State(4384, 25, DoRipper2HangJF).setNext()}, {new State(4388, 25, DoRipper2HangJF).setNext()}, {new State(4392, 25, DoRipper2HangJF).setNext()}};
    private static final State[] s_Ripper2DeathJump = new State[]{new State(4414, 18, Ninja.DoActorDeathMove).setNext()};
    private static final State[] s_Ripper2DeathFall = new State[]{new State(4415, 18, Ninja.DoActorDeathMove).setNext()};
    private static final int RIPPER2_DEAD_RATE = 8;
    private static final State[] s_Ripper2Dead = new State[]{new State(4414, 18, NullRipper2), new State(4415, 18, NullRipper2), new State(4416, 18, NullRipper2), new State(4417, 18, NullRipper2), new State(4418, 18, NullRipper2), new State(4419, 18, NullRipper2), new State(4420, 18, NullRipper2), new State(4421, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(4421, 8, Actor.DoActorDebris).setNext()};
    private static final Actor_Action_Set Ripper2ActionSet = new Actor_Action_Set(Ripper2StateGroup.sg_Ripper2Stand, Ripper2StateGroup.sg_Ripper2Run, Ripper2StateGroup.sg_Ripper2Jump, Ripper2StateGroup.sg_Ripper2Fall, null, null, null, null, null, null, null, Ripper2StateGroup.sg_Ripper2Pain, Ripper2StateGroup.sg_Ripper2Die, null, Ripper2StateGroup.sg_Ripper2Dead, Ripper2StateGroup.sg_Ripper2DeathJump, Ripper2StateGroup.sg_Ripper2DeathFall, new Sprites.StateGroup[]{Ripper2StateGroup.sg_Ripper2Swipe}, new short[]{1024}, new Sprites.StateGroup[]{Ripper2StateGroup.sg_Ripper2JumpAttack, Ripper2StateGroup.sg_Ripper2Kong}, new short[]{500, 1024}, new Sprites.StateGroup[]{Ripper2StateGroup.sg_Ripper2Heart, Ripper2StateGroup.sg_Ripper2Hang}, null, null);
    private static final Actor_Action_Set Ripper2BrownActionSet = new Actor_Action_Set(Ripper2StateGroup.sg_Ripper2Stand, Ripper2StateGroup.sg_Ripper2Run, Ripper2StateGroup.sg_Ripper2Jump, Ripper2StateGroup.sg_Ripper2Fall, null, null, null, null, null, null, null, Ripper2StateGroup.sg_Ripper2Pain, Ripper2StateGroup.sg_Ripper2Die, null, Ripper2StateGroup.sg_Ripper2Dead, Ripper2StateGroup.sg_Ripper2DeathJump, Ripper2StateGroup.sg_Ripper2DeathFall, new Sprites.StateGroup[]{Ripper2StateGroup.sg_Ripper2Swipe}, new short[]{1024}, new Sprites.StateGroup[]{Ripper2StateGroup.sg_Ripper2JumpAttack, Ripper2StateGroup.sg_Ripper2Kong}, new short[]{400, 1024}, new Sprites.StateGroup[]{Ripper2StateGroup.sg_Ripper2Heart, Ripper2StateGroup.sg_Ripper2Hang}, null, null);
    private static VOC3D riphearthandle = null;

    public static void InitRipper2States() {
        for (Ripper2StateGroup sg : Ripper2StateGroup.values()) {
            for (int rot = 0; rot < sg.group.length; ++rot) {
                State.InitState(sg.group[rot]);
            }
        }
    }

    public static void SetupRipper2(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 4320, s_Ripper2Run[0][0]);
            u.Health = (short)200;
        }
        Sprites.ChangeState(SpriteNum, s_Ripper2Run[0][0]);
        u.Attrib = Ripper2Attrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_Ripper2Die[0];
        u.Rot = Ripper2StateGroup.sg_Ripper2Run;
        sp.clipdist = 128;
        sp.yrepeat = (short)55;
        sp.xrepeat = (short)55;
        if (sp.pal == 7) {
            Coolie.EnemyDefaults(SpriteNum, Ripper2BrownActionSet, Ripper2Personality);
            sp.xrepeat = (short)(sp.xrepeat + 40);
            sp.yrepeat = (short)(sp.yrepeat + 40);
            if (!MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
                u.Health = (short)500;
            }
            sp.clipdist += 32;
        } else {
            Coolie.EnemyDefaults(SpriteNum, Ripper2ActionSet, Ripper2Personality);
        }
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
    }

    public static int InitRipper2Hang(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int hitsect = -2;
        boolean Found = false;
        for (int dang = 0; dang < 2048; dang = (int)((short)(dang + 128))) {
            short tang = Gameutils.NORM_ANGLE(sp.ang + dang);
            Rooms.FAFhitscan(sp.x, sp.y, sp.z - Gameutils.SPRITEp_SIZE_Z(sp), sp.sectnum, Engine.sintable[Gameutils.NORM_ANGLE(tang + 512)], Engine.sintable[tang], 0, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
            hitsect = Engine.pHitInfo.hitsect;
            short hitwall = Engine.pHitInfo.hitwall;
            int hitx = Engine.pHitInfo.hitx;
            int hity = Engine.pHitInfo.hity;
            if (hitsect < 0) continue;
            int dist = Game.Distance(sp.x, sp.y, hitx, hity);
            if (hitwall < 0 || dist < 2000 || dist > 7000) continue;
            Found = true;
            sp.ang = tang;
            break;
        }
        if (!Found) {
            Ai.InitActorDecide(SpriteNum);
            return 0;
        }
        Sprites.NewStateGroup(SpriteNum, Ripper2StateGroup.sg_Ripper2HangJump);
        u.StateFallOverride = Ripper2StateGroup.sg_Ripper2HangFall;
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ripper.PickJumpMaxSpeed(SpriteNum, -(Gameutils.RANDOM_RANGE(400) + 100));
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = (short)8;
        Actor.DoJump(SpriteNum);
        return 0;
    }

    public static int DoRipper2Hang(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics > 0) {
            return 0;
        }
        Sprites.NewStateGroup(SpriteNum, Ripper2StateGroup.sg_Ripper2JumpAttack);
        u.Tics += u.State.Tics;
        return 0;
    }

    public static int DoRipper2MoveHang(int SpriteNum) {
        int ny;
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
        if (!Sprites.move_actor(SpriteNum, nx, ny = sp.xvel * Engine.sintable[sp.ang] >> 14, 0)) {
            switch (MyTypes.DTEST(u.ret, 57344)) {
                case 32768: {
                    if (Pragmas.klabs(sp.z - Engine.sprite[u.tgt_sp].z) > 64000) break;
                    short hitwall = Gameutils.NORM_WALL(u.ret);
                    Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Special[1]);
                    u.WaitTics = Gameutils.RANDOM_P2(262144) >> 8 > 500 ? (short)((Gameutils.RANDOM_P2(512) >> 8) * 120) : (short)0;
                    short w = hitwall;
                    short nw = Engine.wall[w].point2;
                    sp.ang = Gameutils.NORM_ANGLE(Main.engine.getangle(Engine.wall[nw].x - Engine.wall[w].x, Engine.wall[nw].y - Engine.wall[w].y) - 512);
                    return 0;
                }
            }
        }
        return 0;
    }

    public static int DoRipper2HangJF(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoJump(SpriteNum);
            } else {
                Actor.DoFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (Ripper2.DoRipper2QuickJump(SpriteNum) != 0) {
                return 0;
            }
            Ai.InitActorDecide(SpriteNum);
        }
        Ripper2.DoRipper2MoveHang(SpriteNum);
        return 0;
    }

    private static final int RANDOM_NEG(int x) {
        return Gameutils.RANDOM_P2(x << 1) - x;
    }

    public static int DoRipper2BeginJumpAttack(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE psp = Engine.sprite[Gameutils.pUser[SpriteNum].tgt_sp];
        short tang = Main.engine.getangle(psp.x - sp.x, psp.y - sp.y);
        sp.ang = Sprites.move_sprite(SpriteNum, Engine.sintable[Gameutils.NORM_ANGLE(tang + 512)] >> 7, Engine.sintable[tang] >> 7, 0, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_ACTOR, 6) != 0 ? Gameutils.NORM_ANGLE(sp.ang + 1024 + (Ripper2.RANDOM_NEG(16384) >> 6)) : Gameutils.NORM_ANGLE(tang);
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ripper.PickJumpMaxSpeed(SpriteNum, -(Gameutils.RANDOM_RANGE(400) + 100));
        u.Flags |= Gameutils.SPR_JUMPING;
        u.Flags &= ~Gameutils.SPR_FALLING;
        u.jump_grav = (short)8;
        Sprites.DoActorZrange(SpriteNum);
        Actor.DoJump(SpriteNum);
        return 0;
    }

    public static int DoRipper2MoveJump(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoJump(SpriteNum);
            } else {
                Actor.DoFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (Ripper2.DoRipper2QuickJump(SpriteNum) != 0) {
                return 0;
            }
            Ai.InitActorDecide(SpriteNum);
        }
        Ripper2.DoRipper2MoveHang(SpriteNum);
        return 0;
    }

    public static int DoRipper2QuickJump(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (u.lo_sp != -1) {
            SPRITE tsp = Engine.sprite[u.lo_sp];
            if (MyTypes.TEST(tsp.extra, Gameutils.SPRX_PLAYER_OR_ENEMY)) {
                Sprites.NewStateGroup(SpriteNum, Ripper2StateGroup.sg_Ripper2JumpAttack);
                u.Tics = 30;
                return 1;
            }
        }
        return 0;
    }

    public static int NullRipper2(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    public static int DoRipper2Pain(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        Ripper2.NullRipper2(SpriteNum);
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
        return 0;
    }

    public static int DoRipper2RipHeart(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE tsp = Engine.sprite[u.tgt_sp];
        Sprites.NewStateGroup(SpriteNum, Ripper2StateGroup.sg_Ripper2Heart);
        u.WaitTics = (short)720;
        tsp.ang = Main.engine.getangle(sp.x - tsp.x, sp.y - tsp.y);
        return 0;
    }

    private static int DoRipper2StandHeart(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        Ripper2.NullRipper2(SpriteNum);
        if (riphearthandle != null && !riphearthandle.isActive()) {
            riphearthandle = Sound.PlaySound(318, sp, 0);
        }
        if ((u.WaitTics = (short)(u.WaitTics - 6)) <= 0) {
            Sprites.NewStateGroup(SpriteNum, Ripper2StateGroup.sg_Ripper2Run);
        }
        return 0;
    }

    public static void Ripper2Hatch(int Weapon2) {
        SPRITE wp = Engine.sprite[Weapon2];
        short rip_ang = (short)Gameutils.RANDOM_P2(2048);
        short newsp = Rooms.COVERinsertsprite(wp.sectnum, 0);
        SPRITE np = Engine.sprite[newsp];
        np.reset();
        np.sectnum = wp.sectnum;
        np.statnum = 0;
        np.x = wp.x;
        np.y = wp.y;
        np.z = wp.z;
        np.owner = (short)-1;
        np.yrepeat = (short)64;
        np.xrepeat = (short)64;
        np.ang = rip_ang;
        np.pal = 0;
        np.shade = (byte)-10;
        Ripper2.SetupRipper2(newsp);
        USER nu = Gameutils.pUser[newsp];
        nu.Flags |= Gameutils.SPR_ACTIVE;
        Sprites.NewStateGroup(newsp, nu.ActorActionSet.Jump);
        nu.ActorActionFunc = Ai.DoActorMoveJump;
        Ai.DoActorSetSpeed(newsp, 3);
        Ripper.PickJumpMaxSpeed(newsp, -600);
        nu.Flags |= Gameutils.SPR_JUMPING;
        nu.Flags &= ~Gameutils.SPR_FALLING;
        nu.jump_grav = (short)8;
        Sprites.DoActorZrange(newsp);
        Actor.DoJump(newsp);
    }

    public static int DoRipper2Move(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (sp.hitag == 1008 && sp.lotag == 1) {
            Hornet.DoCheckSwarm(SpriteNum);
        }
        if (u.scale_speed != 0) {
            Actor.DoScaleSprite(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING)) {
                Actor.DoJump(SpriteNum);
            } else {
                Actor.DoFall(SpriteNum);
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            if (Ripper2.DoRipper2QuickJump(SpriteNum) != 0) {
                return 0;
            }
            Actor.KeepActorOnFloor(SpriteNum);
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.invoke(SpriteNum);
        }
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    public static int InitRipper2Charge(int SpriteNum) {
        Ai.DoActorSetSpeed(SpriteNum, 3);
        Ai.InitActorMoveCloser.invoke(SpriteNum);
        Sprites.NewStateGroup(SpriteNum, Ripper2StateGroup.sg_Ripper2RunFast);
        return 0;
    }

    public static int ChestRipper2(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        Sound.PlaySound(431, sp, 1);
        return 0;
    }

    public static void Ripper2Saveable() {
        Saveable.SaveData(InitRipperSlash);
        Saveable.SaveData(InitRipper2Hang);
        Saveable.SaveData(DoRipper2Hang);
        Saveable.SaveData(DoRipper2HangJF);
        Saveable.SaveData(DoRipper2BeginJumpAttack);
        Saveable.SaveData(DoRipper2MoveJump);
        Saveable.SaveData(NullRipper2);
        Saveable.SaveData(DoRipper2Pain);
        Saveable.SaveData(DoRipper2StandHeart);
        Saveable.SaveData(DoRipper2Move);
        Saveable.SaveData(InitRipper2Charge);
        Saveable.SaveData(ChestRipper2);
        Saveable.SaveData(Ripper2Personality);
        Saveable.SaveData(Ripper2Attrib);
        Saveable.SaveData(s_Ripper2Run);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2Run);
        Saveable.SaveData(s_Ripper2RunFast);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2RunFast);
        Saveable.SaveData(s_Ripper2Stand);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2Stand);
        Saveable.SaveData(s_Ripper2Swipe);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2Swipe);
        Saveable.SaveData(s_Ripper2Kong);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2Kong);
        Saveable.SaveData(s_Ripper2Heart);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2Heart);
        Saveable.SaveData(s_Ripper2Hang);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2Hang);
        Saveable.SaveData(s_Ripper2Pain);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2Pain);
        Saveable.SaveData(s_Ripper2Jump);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2Jump);
        Saveable.SaveData(s_Ripper2Fall);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2Fall);
        Saveable.SaveData(s_Ripper2JumpAttack);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2JumpAttack);
        Saveable.SaveData(s_Ripper2HangJump);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2HangJump);
        Saveable.SaveData(s_Ripper2HangFall);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2HangFall);
        Saveable.SaveData(s_Ripper2Die);
        Saveable.SaveData(s_Ripper2Dead);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2Die);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2Dead);
        Saveable.SaveData(s_Ripper2DeathJump);
        Saveable.SaveData(s_Ripper2DeathFall);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2DeathJump);
        Saveable.SaveGroup(Ripper2StateGroup.sg_Ripper2DeathFall);
        Saveable.SaveData(Ripper2ActionSet);
        Saveable.SaveData(Ripper2BrownActionSet);
    }

    static /* synthetic */ State[][] access$000() {
        return s_Ripper2Stand;
    }

    static /* synthetic */ State[][] access$100() {
        return s_Ripper2Run;
    }

    static /* synthetic */ State[][] access$200() {
        return s_Ripper2RunFast;
    }

    static /* synthetic */ State[][] access$300() {
        return s_Ripper2Jump;
    }

    static /* synthetic */ State[][] access$400() {
        return s_Ripper2Swipe;
    }

    static /* synthetic */ State[][] access$500() {
        return s_Ripper2Kong;
    }

    static /* synthetic */ State[][] access$600() {
        return s_Ripper2Heart;
    }

    static /* synthetic */ State[][] access$700() {
        return s_Ripper2Pain;
    }

    static /* synthetic */ State[][] access$800() {
        return s_Ripper2Fall;
    }

    static /* synthetic */ State[][] access$900() {
        return s_Ripper2JumpAttack;
    }

    static /* synthetic */ State[][] access$1000() {
        return s_Ripper2HangJump;
    }

    static /* synthetic */ State[][] access$1100() {
        return s_Ripper2HangFall;
    }

    static /* synthetic */ State[][] access$1200() {
        return s_Ripper2Hang;
    }

    static /* synthetic */ State[] access$1300() {
        return s_Ripper2Die;
    }

    static /* synthetic */ State[] access$1400() {
        return s_Ripper2Dead;
    }

    static /* synthetic */ State[] access$1500() {
        return s_Ripper2DeathJump;
    }

    static /* synthetic */ State[] access$1600() {
        return s_Ripper2DeathFall;
    }

    public static enum Ripper2StateGroup implements Sprites.StateGroup
    {
        sg_Ripper2Stand(Ripper2.access$000()[0], Ripper2.access$000()[1], Ripper2.access$000()[2], Ripper2.access$000()[3], Ripper2.access$000()[4]),
        sg_Ripper2Run(Ripper2.access$100()[0], Ripper2.access$100()[1], Ripper2.access$100()[2], Ripper2.access$100()[3], Ripper2.access$100()[4]),
        sg_Ripper2RunFast(Ripper2.access$200()[0], Ripper2.access$200()[1], Ripper2.access$200()[2], Ripper2.access$200()[3], Ripper2.access$200()[4]),
        sg_Ripper2Jump(Ripper2.access$300()[0], Ripper2.access$300()[1], Ripper2.access$300()[2], Ripper2.access$300()[3], Ripper2.access$300()[4]),
        sg_Ripper2Swipe(Ripper2.access$400()[0], Ripper2.access$400()[1], Ripper2.access$400()[2], Ripper2.access$400()[3], Ripper2.access$400()[4]),
        sg_Ripper2Kong(Ripper2.access$500()[0], Ripper2.access$500()[1], Ripper2.access$500()[2], Ripper2.access$500()[3], Ripper2.access$500()[4]),
        sg_Ripper2Heart(Ripper2.access$600()[0], Ripper2.access$600()[1], Ripper2.access$600()[2], Ripper2.access$600()[3], Ripper2.access$600()[4]),
        sg_Ripper2Pain(Ripper2.access$700()[0], Ripper2.access$700()[1], Ripper2.access$700()[2], Ripper2.access$700()[3], Ripper2.access$700()[4]),
        sg_Ripper2Fall(Ripper2.access$800()[0], Ripper2.access$800()[1], Ripper2.access$800()[2], Ripper2.access$800()[3], Ripper2.access$800()[4]),
        sg_Ripper2JumpAttack(Ripper2.access$900()[0], Ripper2.access$900()[1], Ripper2.access$900()[2], Ripper2.access$900()[3], Ripper2.access$900()[4]),
        sg_Ripper2HangJump(Ripper2.access$1000()[0], Ripper2.access$1000()[1], Ripper2.access$1000()[2], Ripper2.access$1000()[3], Ripper2.access$1000()[4]),
        sg_Ripper2HangFall(Ripper2.access$1100()[0], Ripper2.access$1100()[1], Ripper2.access$1100()[2], Ripper2.access$1100()[3], Ripper2.access$1100()[4]),
        sg_Ripper2Hang(Ripper2.access$1200()[0], Ripper2.access$1200()[1], Ripper2.access$1200()[2], Ripper2.access$1200()[3], Ripper2.access$1200()[4]),
        sg_Ripper2Die(new State[][]{Ripper2.access$1300()}),
        sg_Ripper2Dead(new State[][]{Ripper2.access$1400()}),
        sg_Ripper2DeathJump(new State[][]{Ripper2.access$1500()}),
        sg_Ripper2DeathFall(new State[][]{Ripper2.access$1600()});

        private final State[][] group;
        private int index = -1;

        private Ripper2StateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

