/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Ninja;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Enemies.Sumo;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Weapon;

public class Zilla {
    private static final Decision[] ZillaBattle = new Decision[]{new Decision(100, Ai.InitActorRunAway), new Decision(690, Ai.InitActorMoveCloser), new Decision(692, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] ZillaOffense = new Decision[]{new Decision(100, Ai.InitActorRunAway), new Decision(690, Ai.InitActorMoveCloser), new Decision(692, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] ZillaBroadcast = new Decision[]{new Decision(2, Ai.InitActorAlertNoise), new Decision(4, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] ZillaSurprised = new Decision[]{new Decision(700, Ai.InitActorMoveCloser), new Decision(703, Ai.InitActorAlertNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] ZillaEvasive = new Decision[]{new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] ZillaLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] ZillaCloseRange = new Decision[]{new Decision(1024, Ai.InitActorAttack)};
    private static final Personality ZillaPersonality = new Personality(ZillaBattle, ZillaOffense, ZillaBroadcast, ZillaSurprised, ZillaEvasive, ZillaLostTarget, ZillaCloseRange, ZillaCloseRange);
    private static final ATTRIBUTE ZillaAttrib = new ATTRIBUTE(new short[]{100, 100, 100, 100}, new short[]{3, 0, 0, 0}, 3, new int[]{590, 590, 592, 591, 592, 0, 0, 0, 0, 0});
    public static final int ZILLA_RATE = 48;
    private static final Animator DoZillaMove = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Zilla.DoZillaMove(SpriteNum) != 0;
        }
    };
    private static final Animator DoZillaStomp = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Zilla.DoZillaStomp(SpriteNum) != 0;
        }
    };
    private static final State[][] s_ZillaRun = new State[][]{{new State(5426, 48, DoZillaMove), new State(5427, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5427, 48, DoZillaMove), new State(5428, 48, DoZillaMove), new State(5429, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5429, 48, DoZillaMove)}, {new State(5422, 48, DoZillaMove), new State(5423, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5423, 48, DoZillaMove), new State(5424, 48, DoZillaMove), new State(5425, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5425, 48, DoZillaMove)}, {new State(5418, 48, DoZillaMove), new State(5419, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5419, 48, DoZillaMove), new State(5420, 48, DoZillaMove), new State(5421, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5421, 48, DoZillaMove)}, {new State(5414, 48, DoZillaMove), new State(5415, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5415, 48, DoZillaMove), new State(5416, 48, DoZillaMove), new State(5417, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5417, 48, DoZillaMove)}, {new State(5410, 48, DoZillaMove), new State(5411, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5411, 48, DoZillaMove), new State(5412, 48, DoZillaMove), new State(5413, Gameutils.SF_QUICK_CALL, DoZillaStomp), new State(5413, 48, DoZillaMove)}};
    private static final State[][] s_ZillaStand = new State[][]{{new State(5426, 48, DoZillaMove).setNext()}, {new State(5422, 48, DoZillaMove).setNext()}, {new State(5418, 48, DoZillaMove).setNext()}, {new State(5414, 48, DoZillaMove).setNext()}, {new State(5410, 48, DoZillaMove).setNext()}};
    public static final int ZILLA_PAIN_RATE = 30;
    private static final Animator NullZilla = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Zilla.NullZilla(SpriteNum) != 0;
        }
    };
    private static final State[][] s_ZillaPain = new State[][]{{new State(5524, 30, NullZilla), new State(5524, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5523, 30, NullZilla), new State(5523, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5522, 30, NullZilla), new State(5522, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5521, 30, NullZilla), new State(5521, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5520, 30, NullZilla), new State(5520, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}};
    public static final int ZILLA_RAIL_RATE = 12;
    private static final Animator InitZillaRail = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Weapon.InitZillaRail(SpriteNum) != 0;
        }
    };
    private static final State[][] s_ZillaRail = new State[][]{{new State(5466, 12, NullZilla), new State(5467, 12, NullZilla), new State(5468, 12, NullZilla), new State(5469, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5466, 12, NullZilla), new State(5467, 12, NullZilla), new State(5468, 12, NullZilla), new State(5469, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5466, 12, NullZilla), new State(5467, 12, NullZilla), new State(5468, 12, NullZilla), new State(5469, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5469, 12, NullZilla), new State(5469, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5462, 12, NullZilla), new State(5463, 12, NullZilla), new State(5464, 12, NullZilla), new State(5465, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5462, 12, NullZilla), new State(5463, 12, NullZilla), new State(5464, 12, NullZilla), new State(5465, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5462, 12, NullZilla), new State(5463, 12, NullZilla), new State(5464, 12, NullZilla), new State(5465, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5465, 12, NullZilla), new State(5465, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5458, 12, NullZilla), new State(5459, 12, NullZilla), new State(5460, 12, NullZilla), new State(5461, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5458, 12, NullZilla), new State(5459, 12, NullZilla), new State(5460, 12, NullZilla), new State(5461, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5458, 12, NullZilla), new State(5459, 12, NullZilla), new State(5460, 12, NullZilla), new State(5461, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5461, 12, NullZilla), new State(5461, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5454, 12, NullZilla), new State(5455, 12, NullZilla), new State(5456, 12, NullZilla), new State(5457, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5454, 12, NullZilla), new State(5455, 12, NullZilla), new State(5456, 12, NullZilla), new State(5457, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5454, 12, NullZilla), new State(5455, 12, NullZilla), new State(5456, 12, NullZilla), new State(5457, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5457, 12, NullZilla), new State(5457, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}, {new State(5450, 12, NullZilla), new State(5451, 12, NullZilla), new State(5452, 12, NullZilla), new State(5453, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5450, 12, NullZilla), new State(5451, 12, NullZilla), new State(5452, 12, NullZilla), new State(5453, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5450, 12, NullZilla), new State(5451, 12, NullZilla), new State(5452, 12, NullZilla), new State(5453, Gameutils.SF_QUICK_CALL, InitZillaRail), new State(5453, 12, NullZilla), new State(5453, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide)}};
    public static final int ZILLA_ROCKET_RATE = 12;
    private static final Animator InitZillaRocket = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Weapon.InitZillaRocket(SpriteNum) != 0;
        }
    };
    private static final State[][] s_ZillaRocket = new State[][]{{new State(5446, 12, NullZilla), new State(5447, 12, NullZilla), new State(5448, 48, NullZilla), new State(5448, Gameutils.SF_QUICK_CALL, InitZillaRocket), new State(5448, 48, NullZilla), new State(5449, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5449, 120, NullZilla)}, {new State(5442, 12, NullZilla), new State(5443, 12, NullZilla), new State(5444, 48, NullZilla), new State(5444, Gameutils.SF_QUICK_CALL, InitZillaRocket), new State(5444, 48, NullZilla), new State(5445, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5445, 120, NullZilla)}, {new State(5438, 12, NullZilla), new State(5439, 12, NullZilla), new State(5440, 48, NullZilla), new State(5440, Gameutils.SF_QUICK_CALL, InitZillaRocket), new State(5440, 48, NullZilla), new State(5441, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5441, 120, NullZilla)}, {new State(5434, 12, NullZilla), new State(5435, 12, NullZilla), new State(5436, 48, NullZilla), new State(5436, Gameutils.SF_QUICK_CALL, InitZillaRocket), new State(5436, 48, NullZilla), new State(5437, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5437, 120, NullZilla)}, {new State(5430, 12, NullZilla), new State(5431, 12, NullZilla), new State(5432, 48, NullZilla), new State(5432, Gameutils.SF_QUICK_CALL, InitZillaRocket), new State(5432, 48, NullZilla), new State(5433, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(5433, 120, NullZilla)}};
    public static final int ZILLA_UZI_RATE = 8;
    private static final State[][] s_ZillaUzi = new State[][]{{new State(5506, 8, NullZilla), new State(5506, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 8, NullZilla), new State(5506, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5506, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide).setNext()}, {new State(5502, 8, NullZilla), new State(5502, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 8, NullZilla), new State(5502, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5502, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide).setNext()}, {new State(5498, 8, NullZilla), new State(5498, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 8, NullZilla), new State(5498, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5498, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide).setNext()}, {new State(5494, 8, NullZilla), new State(5494, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 8, NullZilla), new State(5494, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5494, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide).setNext()}, {new State(5490, 8, NullZilla), new State(5490, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 8, NullZilla), new State(5490, 0 | Gameutils.SF_QUICK_CALL, Ninja.InitEnemyUzi), new State(5490, 0 | Gameutils.SF_QUICK_CALL, Ai.InitActorDecide).setNext()}};
    public static final int ZILLA_DIE_RATE = 30;
    private static final Animator DoZillaDeathMelt = new Animator(){

        @Override
        public boolean invoke(int SpriteNum) {
            return Zilla.DoZillaDeathMelt(SpriteNum) != 0;
        }
    };
    private static final State[] s_ZillaDie = new State[]{new State(5510, 450, DoZillaDeathMelt), new State(5511, 30, NullZilla), new State(5512, 30, NullZilla), new State(5513, 30, NullZilla), new State(5514, 30, NullZilla), new State(5515, 30, NullZilla), new State(5516, 30, NullZilla), new State(5517, 90, NullZilla), new State(5518, 30, Actor.DoActorDebris).setNext()};
    private static final State[] s_ZillaDead = new State[]{new State(5518, 30, Actor.DoActorDebris).setNext()};
    private static final Actor_Action_Set ZillaActionSet = new Actor_Action_Set(ZillaStateGroup.sg_ZillaStand, ZillaStateGroup.sg_ZillaRun, null, null, null, null, null, null, null, null, null, ZillaStateGroup.sg_ZillaPain, ZillaStateGroup.sg_ZillaDie, null, ZillaStateGroup.sg_ZillaDead, null, null, new Sprites.StateGroup[]{ZillaStateGroup.sg_ZillaUzi, ZillaStateGroup.sg_ZillaRail}, new short[]{950, 1024}, new Sprites.StateGroup[]{ZillaStateGroup.sg_ZillaUzi, ZillaStateGroup.sg_ZillaRocket, ZillaStateGroup.sg_ZillaRail}, new short[]{400, 950, 1024}, null, null, null);
    private static VOC3D handle;
    private static boolean alreadydid;

    public static void InitZillaStates() {
        for (ZillaStateGroup sg : ZillaStateGroup.values()) {
            for (int rot = 0; rot < sg.group.length; ++rot) {
                State.InitState(sg.group[rot]);
                if (sg != ZillaStateGroup.sg_ZillaRocket) continue;
                sg.group[rot][6].setNext(sg.group[rot][5]);
            }
        }
    }

    public static int SetupZilla(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 5426, s_ZillaRun[0][0]);
            u.Health = (short)6000;
        }
        if (Game.Skill == 0) {
            u.Health = (short)2000;
        }
        if (Game.Skill == 1) {
            u.Health = (short)4000;
        }
        Sprites.ChangeState(SpriteNum, s_ZillaRun[0][0]);
        u.Attrib = ZillaAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_ZillaDie[0];
        u.Rot = ZillaStateGroup.sg_ZillaRun;
        Coolie.EnemyDefaults(SpriteNum, ZillaActionSet, ZillaPersonality);
        sp.clipdist = 128;
        sp.xrepeat = (short)97;
        sp.yrepeat = (short)79;
        return 0;
    }

    private static int NullZilla(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        Main.engine.getzsofslope(sp.sectnum, sp.x, sp.y, Rooms.zofslope);
        u.loz = Rooms.zofslope[1];
        u.hiz = Rooms.zofslope[0];
        u.lo_sectp = sp.sectnum;
        u.hi_sectp = sp.sectnum;
        u.lo_sp = -1;
        u.hi_sp = -1;
        sp.z = u.loz;
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    private static int DoZillaMove(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (handle != null && !handle.isActive()) {
            int choose = Gameutils.STD_RANDOM_RANGE(1000);
            if (choose > 990) {
                handle = Sound.PlaySound(584, sp, 0);
            } else if (choose > 985) {
                handle = Sound.PlaySound(584, sp, 0);
            } else if (choose > 980) {
                handle = Sound.PlaySound(584, sp, 0);
            } else if (choose > 975) {
                handle = Sound.PlaySound(584, sp, 0);
            }
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.invoke(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        if (Actor.DoActorSectorDamage(SpriteNum)) {
            return 0;
        }
        return 0;
    }

    private static int DoZillaStomp(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        Sound.PlaySound(615, sp, 1);
        return 0;
    }

    private static int DoZillaDeathMelt(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (Gameutils.RANDOM_RANGE(1000) > 800) {
            Weapon.SpawnGrenadeExp(SpriteNum);
        }
        u.ID = (short)5426;
        u.Flags &= ~(Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING | Gameutils.SPR_MOVED);
        if (!Main.gs.muteMusic && !alreadydid) {
            Sound.CDAudio_Play(Sound.RedBookSong[Game.Level], true);
            alreadydid = true;
        }
        Main.engine.getzsofslope(sp.sectnum, sp.x, sp.y, Rooms.zofslope);
        u.loz = Rooms.zofslope[1];
        u.hiz = Rooms.zofslope[0];
        u.lo_sectp = sp.sectnum;
        u.hi_sectp = sp.sectnum;
        u.lo_sp = -1;
        u.hi_sp = -1;
        sp.z = u.loz;
        Sumo.BossSpriteNum[2] = -2;
        return 0;
    }

    public static void ZillaSaveable() {
        Saveable.SaveData(InitZillaRail);
        Saveable.SaveData(InitZillaRocket);
        Saveable.SaveData(NullZilla);
        Saveable.SaveData(DoZillaMove);
        Saveable.SaveData(DoZillaStomp);
        Saveable.SaveData(DoZillaDeathMelt);
        Saveable.SaveData(ZillaPersonality);
        Saveable.SaveData(ZillaAttrib);
        Saveable.SaveData(s_ZillaRun);
        Saveable.SaveGroup(ZillaStateGroup.sg_ZillaRun);
        Saveable.SaveData(s_ZillaStand);
        Saveable.SaveGroup(ZillaStateGroup.sg_ZillaStand);
        Saveable.SaveData(s_ZillaPain);
        Saveable.SaveGroup(ZillaStateGroup.sg_ZillaPain);
        Saveable.SaveData(s_ZillaRail);
        Saveable.SaveGroup(ZillaStateGroup.sg_ZillaRail);
        Saveable.SaveData(s_ZillaRocket);
        Saveable.SaveGroup(ZillaStateGroup.sg_ZillaRocket);
        Saveable.SaveData(s_ZillaUzi);
        Saveable.SaveGroup(ZillaStateGroup.sg_ZillaUzi);
        Saveable.SaveData(s_ZillaDie);
        Saveable.SaveGroup(ZillaStateGroup.sg_ZillaDie);
        Saveable.SaveData(s_ZillaDead);
        Saveable.SaveGroup(ZillaStateGroup.sg_ZillaDead);
        Saveable.SaveData(ZillaActionSet);
    }

    static /* synthetic */ State[][] access$400() {
        return s_ZillaStand;
    }

    static /* synthetic */ State[][] access$500() {
        return s_ZillaRun;
    }

    static /* synthetic */ State[][] access$600() {
        return s_ZillaPain;
    }

    static /* synthetic */ State[] access$700() {
        return s_ZillaDie;
    }

    static /* synthetic */ State[] access$800() {
        return s_ZillaDead;
    }

    static /* synthetic */ State[][] access$900() {
        return s_ZillaRail;
    }

    static /* synthetic */ State[][] access$1000() {
        return s_ZillaUzi;
    }

    static /* synthetic */ State[][] access$1100() {
        return s_ZillaRocket;
    }

    static {
        alreadydid = false;
    }

    public static enum ZillaStateGroup implements Sprites.StateGroup
    {
        sg_ZillaStand(Zilla.access$400()[0], Zilla.access$400()[1], Zilla.access$400()[2], Zilla.access$400()[3], Zilla.access$400()[4]),
        sg_ZillaRun(Zilla.access$500()[0], Zilla.access$500()[1], Zilla.access$500()[2], Zilla.access$500()[3], Zilla.access$500()[4]),
        sg_ZillaPain(Zilla.access$600()[0], Zilla.access$600()[1], Zilla.access$600()[2], Zilla.access$600()[3], Zilla.access$600()[4]),
        sg_ZillaDie(new State[][]{Zilla.access$700()}),
        sg_ZillaDead(new State[][]{Zilla.access$800()}),
        sg_ZillaRail(Zilla.access$900()[0], Zilla.access$900()[1], Zilla.access$900()[2], Zilla.access$900()[3], Zilla.access$900()[4]),
        sg_ZillaUzi(Zilla.access$1000()[0], Zilla.access$1000()[1], Zilla.access$1000()[2], Zilla.access$1000()[3], Zilla.access$1000()[4]),
        sg_ZillaRocket(Zilla.access$1100()[0], Zilla.access$1100()[1], Zilla.access$1100()[2], Zilla.access$1100()[3], Zilla.access$1100()[4]);

        private final State[][] group;
        private int index = -1;

        private ZillaStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

