/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Break;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Palette;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.VOC3D;
import ru.m210projects.Wang.Weapon;

public class JWeapon {
    public static final int CHEMTICS = Gameutils.SEC(40);
    public static final int GOREDrip = 1562;
    public static final int BLOODSPRAY_RATE = 20;
    private static final Animator BloodSprayFall = new Animator(){

        @Override
        public boolean invoke(int spr) {
            JWeapon.BloodSprayFall(spr);
            return false;
        }
    };
    public static final State[] s_BloodSpray = new State[]{new State(1562, 20, BloodSprayFall), new State(1563, 20, BloodSprayFall), new State(1564, 20, BloodSprayFall), new State(1565, 20, BloodSprayFall), new State(1565, 100, Weapon.DoSuicide)};
    public static final int EXP_RATE = 2;
    public static final State[] s_PhosphorExp = new State[]{new State(3100, 2, null), new State(3101, 2, null), new State(3102, 2, null), new State(3103, 2, null), new State(3104, 2, null), new State(3105, 2, null), new State(3106, 2, null), new State(3107, 2, null), new State(3108, 2, null), new State(3109, 2, null), new State(3110, 2, null), new State(3111, 2, null), new State(3112, 2, null), new State(3113, 2, null), new State(3114, 2, null), new State(3115, 2, null), new State(3116, 2, null), new State(3117, 2, null), new State(3118, 2, null), new State(3119, 2, null), new State(3120, 100, Weapon.DoSuicide)};
    public static final int MUSHROOM_RATE = 25;
    public static final State[] s_NukeMushroom = new State[]{new State(3280, 25, null), new State(3281, 25, null), new State(3282, 25, null), new State(3283, 25, null), new State(3284, 25, null), new State(3285, 25, null), new State(3286, 25, null), new State(3287, 25, null), new State(3288, 25, null), new State(3289, 25, null), new State(3290, 25, null), new State(3291, 25, null), new State(3292, 25, null), new State(3293, 25, null), new State(3294, 25, null), new State(3295, 25, null), new State(3296, 25, null), new State(3297, 25, null), new State(3298, 25, null), new State(3299, 100, Weapon.DoSuicide)};
    public static final Animator DoRadiationCloud = new Animator(){

        @Override
        public boolean invoke(int spr) {
            JWeapon.DoRadiationCloud(spr);
            return false;
        }
    };
    public static final int RADIATION_RATE = 16;
    public static final State[] s_RadiationCloud = new State[]{new State(3258, 16, DoRadiationCloud), new State(3259, 16, DoRadiationCloud), new State(3260, 16, DoRadiationCloud), new State(3261, 16, DoRadiationCloud), new State(3262, 16, DoRadiationCloud), new State(3263, 16, DoRadiationCloud), new State(3264, 16, DoRadiationCloud), new State(3265, 16, DoRadiationCloud), new State(3266, 16, DoRadiationCloud), new State(3267, 16, DoRadiationCloud), new State(3268, 16, DoRadiationCloud), new State(3269, 16, DoRadiationCloud), new State(3270, 16, DoRadiationCloud), new State(3271, 16, DoRadiationCloud), new State(3272, 16, DoRadiationCloud), new State(3273, 16, DoRadiationCloud), new State(3274, 16, DoRadiationCloud), new State(3275, 16, DoRadiationCloud), new State(3276, 16, DoRadiationCloud), new State(3277, 100, Weapon.DoSuicide)};
    public static final int CHEMBOMB_FRAMES = 1;
    public static final int CHEMBOMB_R0 = 3038;
    public static final int CHEMBOMB_R1 = 3039;
    public static final int CHEMBOMB_R2 = 3040;
    public static final int CHEMBOMB_R3 = 3041;
    public static final int CHEMBOMB_R4 = 3042;
    public static final int CHEMBOMB = 3038;
    public static final int CHEMBOMB_RATE = 8;
    public static final Animator DoChemBomb = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return JWeapon.DoChemBomb(spr);
        }
    };
    public static final State[] s_ChemBomb = new State[]{new State(3038, 8, DoChemBomb), new State(3039, 8, DoChemBomb), new State(3040, 8, DoChemBomb), new State(3041, 8, DoChemBomb), new State(3042, 8, DoChemBomb)};
    public static final int CALTROPS_FRAMES = 1;
    public static final int CALTROPS_R0 = 2217;
    public static final int CALTROPS_RATE = 8;
    public static final Animator DoCaltrops = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return JWeapon.DoCaltrops(spr);
        }
    };
    public static final Animator DoCaltropsStick = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return JWeapon.DoCaltropsStick(spr) != 0;
        }
    };
    public static final State[] s_Caltrops = new State[]{new State(2217, 8, DoCaltrops), new State(2218, 8, DoCaltrops), new State(2219, 8, DoCaltrops)};
    public static final State[] s_CaltropsStick = new State[]{new State(2219, 8, DoCaltropsStick).setNext()};
    public static final Animator DoFlag = new Animator(){

        @Override
        public boolean invoke(int spr) {
            JWeapon.DoFlag(spr);
            return false;
        }
    };
    public static final Animator DoCarryFlag = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return JWeapon.DoCarryFlag(spr);
        }
    };
    public static final Animator DoCarryFlagNoDet = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return JWeapon.DoCarryFlagNoDet(spr);
        }
    };
    public static final int FLAG = 2520;
    public static final int FLAG_RATE = 16;
    public static final State[] s_CarryFlag = new State[]{new State(2520, 16, DoCarryFlag), new State(2521, 16, DoCarryFlag), new State(2522, 16, DoCarryFlag)};
    public static final State[] s_CarryFlagNoDet = new State[]{new State(2520, 16, DoCarryFlagNoDet), new State(2521, 16, DoCarryFlagNoDet), new State(2522, 16, DoCarryFlagNoDet)};
    public static final State[] s_Flag = new State[]{new State(2520, 16, DoFlag), new State(2521, 16, DoFlag), new State(2522, 16, DoFlag)};
    public static final int PHOSPHORUS_RATE = 8;
    public static final Animator DoPhosphorus = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return JWeapon.DoPhosphorus(spr);
        }
    };
    public static final State[] s_Phosphorus = new State[]{new State(1397, 8, DoPhosphorus), new State(1398, 8, DoPhosphorus)};
    public static final Animator DoBloodSpray = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return JWeapon.DoBloodSpray(spr);
        }
    };
    public static final int CHUNK1 = 1685;
    public static final State[] s_BloodSprayChunk = new State[]{new State(1685, 8, DoBloodSpray), new State(1686, 8, DoBloodSpray), new State(1687, 8, DoBloodSpray), new State(1688, 8, DoBloodSpray), new State(1689, 8, DoBloodSpray), new State(1690, 8, DoBloodSpray)};
    public static final Animator DoWallBloodDrip = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return JWeapon.DoWallBloodDrip(spr) != 0;
        }
    };
    public static final int DRIP = 1566;
    public static final State[] s_BloodSprayDrip = new State[]{new State(1566, 8, DoWallBloodDrip), new State(1567, 8, DoWallBloodDrip), new State(1568, 8, DoWallBloodDrip)};
    public static final int FLAG_DETONATE_STATE = 99;
    public static final int UZI_SHELL = 2152;
    public static final int SHOT_SHELL = 2180;

    public static void InitJWeaponStates() {
        State.InitState(s_BloodSpray);
        State.InitState(s_PhosphorExp);
        State.InitState(s_NukeMushroom);
        State.InitState(s_RadiationCloud);
        State.InitState(s_ChemBomb);
        State.InitState(s_Caltrops);
        State.InitState(s_CaltropsStick);
        State.InitState(s_CarryFlag);
        State.InitState(s_CarryFlagNoDet);
        State.InitState(s_Flag);
        State.InitState(s_Phosphorus);
        State.InitState(s_BloodSprayChunk);
        State.InitState(s_BloodSprayDrip);
    }

    public static int DoWallBloodDrip(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (u.sz != u.sy) {
            if (sp.z > u.sy && sp.z < u.sz) {
                sp.zvel = (short)(sp.zvel + 300);
                sp.z += sp.zvel;
            } else {
                sp.zvel = (short)(300 + Gameutils.RANDOM_RANGE(2300) >> 1);
                sp.z += sp.zvel;
            }
        } else {
            sp.zvel = (short)(300 + Gameutils.RANDOM_RANGE(2300) >> 1);
            sp.z += sp.zvel;
        }
        if (sp.z >= u.loz) {
            sp.z = u.loz;
            JWeapon.SpawnFloorSplash(SpriteNum);
            Sprites.KillSprite(SpriteNum);
            return 0;
        }
        return 0;
    }

    public static void SpawnMidSplash(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int newsp = Sprites.SpawnSprite(4, 1562, Weapon.s_GoreSplash[0], sp.sectnum, sp.x, sp.y, Gameutils.SPRITEp_MID(sp), sp.ang, 0);
        SPRITE np = Engine.sprite[newsp];
        USER nu = Gameutils.pUser[newsp];
        np.shade = (byte)-12;
        np.xrepeat = (short)(70 - Gameutils.RANDOM_RANGE(20));
        np.yrepeat = (short)(70 - Gameutils.RANDOM_RANGE(20));
        nu.ox = u.ox;
        nu.oy = u.oy;
        nu.oz = u.oz;
        np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        np.cstat = (short)(np.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        if (Gameutils.RANDOM_P2(1024) < 512) {
            np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_XFLIP);
        }
        nu.xchange = 0;
        nu.ychange = 0;
        nu.zchange = 0;
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            nu.Flags |= Gameutils.SPR_UNDERWATER;
        }
    }

    public static void SpawnFloorSplash(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int newsp = Sprites.SpawnSprite(4, 1562, Weapon.s_GoreFloorSplash[0], sp.sectnum, sp.x, sp.y, sp.z, sp.ang, 0);
        SPRITE np = Engine.sprite[newsp];
        USER nu = Gameutils.pUser[newsp];
        np.shade = (byte)-12;
        np.xrepeat = (short)(70 - Gameutils.RANDOM_RANGE(20));
        np.yrepeat = (short)(70 - Gameutils.RANDOM_RANGE(20));
        nu.ox = u.ox;
        nu.oy = u.oy;
        nu.oz = u.oz;
        np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        np.cstat = (short)(np.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        if (Gameutils.RANDOM_P2(1024) < 512) {
            np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_XFLIP);
        }
        nu.xchange = 0;
        nu.ychange = 0;
        nu.zchange = 0;
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            nu.Flags |= Gameutils.SPR_UNDERWATER;
        }
    }

    public static boolean DoBloodSpray(int Weapon2) {
        SPRITE sp = Engine.sprite[Weapon2];
        USER u = Gameutils.pUser[Weapon2];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            Weapon.ScaleSpriteVector(Weapon2, 50000);
            u.Counter = (short)(u.Counter + 20);
            u.zchange += u.Counter;
        } else {
            u.Counter = (short)(u.Counter + 20);
            u.zchange += u.Counter;
        }
        if (sp.xvel <= 2) {
            sp.z += u.zchange >> 1;
            Main.engine.getzsofslope(sp.sectnum, sp.x, sp.y, Rooms.zofslope);
            int fz = Rooms.zofslope[1];
            if (sp.z >= fz) {
                sp.z = fz;
                JWeapon.SpawnFloorSplash(Weapon2);
                Sprites.KillSprite((short)Weapon2);
                return true;
            }
        } else {
            u.ret = Sprites.move_missile(Weapon2, u.xchange, u.ychange, u.zchange, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_MISSILE, 6);
        }
        Weapon.MissileHitDiveArea(Weapon2);
        if (u.ret != 0) {
            switch (MyTypes.DTEST(u.ret, 57344)) {
                case 8192: {
                    Sprites.KillSprite(Weapon2);
                    return true;
                }
                case 49152: {
                    int hitsprite = -2;
                    hitsprite = Gameutils.NORM_SPRITE(u.ret);
                    SPRITE hsp = Engine.sprite[hitsprite];
                    if (MyTypes.TEST(hsp.cstat, Gameutils.CSTAT_SPRITE_WALL)) {
                        short wall_ang = Gameutils.NORM_ANGLE(hsp.ang);
                        JWeapon.SpawnMidSplash(Weapon2);
                        Weapon.QueueWallBlood(Weapon2, hsp.ang);
                        Weapon.WallBounce(Weapon2, wall_ang);
                        Weapon.ScaleSpriteVector(Weapon2, 32000);
                        break;
                    }
                    u.ychange = 0;
                    u.xchange = 0;
                    JWeapon.SpawnMidSplash(Weapon2);
                    Weapon.QueueWallBlood(Weapon2, hsp.ang);
                    Sprites.KillSprite((short)Weapon2);
                    return true;
                }
                case 32768: {
                    short hitwall = Gameutils.NORM_WALL(u.ret);
                    WALL wph = Engine.wall[hitwall];
                    if (wph.lotag == 307) {
                        Break.HitBreakWall(hitwall, sp.x, sp.y, sp.z, sp.ang, u.ID);
                        u.ret = 0;
                        break;
                    }
                    short nw = Engine.wall[hitwall].point2;
                    short wall_ang = Gameutils.NORM_ANGLE(Main.engine.getangle(Engine.wall[nw].x - wph.x, Engine.wall[nw].y - wph.y) + 512);
                    JWeapon.SpawnMidSplash(Weapon2);
                    short wb = (short)Weapon.QueueWallBlood(Weapon2, Gameutils.NORM_ANGLE(wall_ang + 1024));
                    if (wb < 0) {
                        Sprites.KillSprite(Weapon2);
                        return false;
                    }
                    if (Rooms.FAF_Sector(Engine.sprite[wb].sectnum) || Gameutils.FAF_ConnectArea(Engine.sprite[wb].sectnum)) {
                        Sprites.KillSprite(Weapon2);
                        return false;
                    }
                    u.ychange = 0;
                    u.xchange = 0;
                    sp.xvel = sp.yvel = (short)0;
                    sp.xrepeat = sp.yrepeat = (short)(70 - Gameutils.RANDOM_RANGE(25));
                    sp.x = Engine.sprite[wb].x;
                    sp.y = Engine.sprite[wb].y;
                    if (Engine.sprite[wb].yvel >= 0) {
                        short wallnum = Engine.sprite[wb].yvel;
                        if (Engine.wall[wallnum].nextsector >= 0) {
                            Main.engine.getzsofslope(Engine.wall[wallnum].nextsector, sp.x, sp.y, Rooms.zofslope);
                            u.sy = Rooms.zofslope[0];
                            u.sz = Rooms.zofslope[1];
                        } else {
                            u.sy = u.sz;
                        }
                    }
                    sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_INVISIBLE);
                    Sprites.ChangeState(Weapon2, s_BloodSprayDrip[0]);
                    break;
                }
                case 16384: {
                    if (sp.z > MyTypes.DIV2(u.hiz + u.loz)) {
                        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        if (u.lo_sectp != -1 && Sector.SectUser[sp.sectnum] != null && Sector.SectUser[sp.sectnum].depth != 0) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        u.ychange = 0;
                        u.xchange = 0;
                        JWeapon.SpawnFloorSplash(Weapon2);
                        Sprites.KillSprite((short)Weapon2);
                        return true;
                    }
                    u.zchange = -u.zchange;
                    Weapon.ScaleSpriteVector(Weapon2, 32000);
                }
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE | Gameutils.SPR_UNDERWATER)) {
            int newsp = Sprites.SpawnSprite(4, 1562, s_BloodSpray[0], sp.sectnum, sp.x, sp.y, sp.z, sp.ang, 100);
            SPRITE np = Engine.sprite[newsp];
            USER nu = Gameutils.pUser[newsp];
            Sprites.SetOwner(Weapon2, newsp);
            np.shade = (byte)-12;
            np.xrepeat = (short)(40 - Gameutils.RANDOM_RANGE(30));
            np.yrepeat = (short)(40 - Gameutils.RANDOM_RANGE(30));
            nu.ox = u.ox;
            nu.oy = u.oy;
            nu.oz = u.oz;
            np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
            np.cstat = (short)(np.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
            if (Gameutils.RANDOM_P2(1024) < 512) {
                np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_XFLIP);
            }
            if (Gameutils.RANDOM_P2(1024) < 512) {
                np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_YFLIP);
            }
            nu.xchange = u.xchange;
            nu.ychange = u.ychange;
            nu.zchange = u.zchange;
            Weapon.ScaleSpriteVector(newsp, 20000);
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                nu.Flags |= Gameutils.SPR_UNDERWATER;
            }
        }
        return false;
    }

    public static boolean DoPhosphorus(int Weapon2) {
        SPRITE sp = Engine.sprite[Weapon2];
        USER u = Gameutils.pUser[Weapon2];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            Weapon.ScaleSpriteVector(Weapon2, 50000);
            u.Counter = (short)(u.Counter + 40);
            u.zchange += u.Counter;
        } else {
            u.Counter = (short)(u.Counter + 40);
            u.zchange += u.Counter;
        }
        u.ret = Sprites.move_missile(Weapon2, u.xchange, u.ychange, u.zchange, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_MISSILE, 12);
        Weapon.MissileHitDiveArea(Weapon2);
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER) && Gameutils.RANDOM_P2(16384) >> 4 < 256) {
            Weapon.SpawnBubble(Weapon2);
        }
        if (u.ret != 0) {
            switch (MyTypes.DTEST(u.ret, 57344)) {
                case 8192: {
                    Sprites.KillSprite(Weapon2);
                    return true;
                }
                case 49152: {
                    int hitsprite = -2;
                    hitsprite = Gameutils.NORM_SPRITE(u.ret);
                    SPRITE hsp = Engine.sprite[hitsprite];
                    USER hu = Gameutils.pUser[hitsprite];
                    if (MyTypes.TEST(hsp.cstat, Gameutils.CSTAT_SPRITE_WALL)) {
                        short wall_ang = Gameutils.NORM_ANGLE(hsp.ang);
                        Weapon.WallBounce(Weapon2, wall_ang);
                        Weapon.ScaleSpriteVector(Weapon2, 32000);
                        break;
                    }
                    if (MyTypes.TEST(hsp.extra, Gameutils.SPRX_BURNABLE)) {
                        if (hu == null) {
                            hu = Sprites.SpawnUser(hitsprite, hsp.picnum, null);
                        }
                        Weapon.SpawnFireballExp(Weapon2);
                        if (hu != null) {
                            Weapon.SpawnFireballFlames(Weapon2, hitsprite);
                        }
                        Weapon.DoFlamesDamageTest(Weapon2);
                    }
                    u.ychange = 0;
                    u.xchange = 0;
                    Sprites.KillSprite((short)Weapon2);
                    return true;
                }
                case 32768: {
                    short hitwall = Gameutils.NORM_WALL(u.ret);
                    WALL wph = Engine.wall[hitwall];
                    if (wph.lotag == 307) {
                        Break.HitBreakWall(hitwall, sp.x, sp.y, sp.z, sp.ang, u.ID);
                        u.ret = 0;
                        break;
                    }
                    short nw = Engine.wall[hitwall].point2;
                    short wall_ang = Gameutils.NORM_ANGLE(Main.engine.getangle(Engine.wall[nw].x - wph.x, Engine.wall[nw].y - wph.y) + 512);
                    Weapon.WallBounce(Weapon2, wall_ang);
                    Weapon.ScaleSpriteVector(Weapon2, 32000);
                    break;
                }
                case 16384: {
                    short hitwall;
                    if (Weapon.SlopeBounce(Weapon2, Game.tmp_ptr[0])) {
                        short s = hitwall = Game.tmp_ptr[0].value != 0 ? (short)1 : 0;
                        if (hitwall != 0) {
                            Weapon.ScaleSpriteVector(Weapon2, 28000);
                            u.ret = 0;
                            u.Counter = 0;
                            break;
                        }
                        if (sp.z > MyTypes.DIV2(u.hiz + u.loz)) {
                            if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                                u.Flags |= Gameutils.SPR_BOUNCE;
                                Weapon.ScaleSpriteVector(Weapon2, 32000);
                                u.zchange /= 6;
                                u.ret = 0;
                                u.Counter = 0;
                                break;
                            }
                            u.ychange = 0;
                            u.xchange = 0;
                            Weapon.SpawnFireballExp(Weapon2);
                            Sprites.KillSprite((short)Weapon2);
                            return true;
                        }
                        Weapon.ScaleSpriteVector(Weapon2, 32000);
                        break;
                    }
                    if (sp.z > MyTypes.DIV2(u.hiz + u.loz)) {
                        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        if (u.lo_sectp != -1 && Sector.SectUser[sp.sectnum] != null && Sector.SectUser[sp.sectnum].depth != 0) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                            u.ret = 0;
                            u.Counter = 0;
                            u.zchange = -u.zchange;
                            Weapon.ScaleSpriteVector(Weapon2, 32000);
                            u.zchange /= 6;
                            break;
                        }
                        u.ychange = 0;
                        u.xchange = 0;
                        Weapon.SpawnFireballExp(Weapon2);
                        Sprites.KillSprite((short)Weapon2);
                        return true;
                    }
                    u.zchange = -u.zchange;
                    Weapon.ScaleSpriteVector(Weapon2, 32000);
                }
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE | Gameutils.SPR_UNDERWATER) && !MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE)) {
            int newsp = Sprites.SpawnSprite(6, 1748, s_PhosphorExp[0], sp.sectnum, sp.x, sp.y, sp.z, sp.ang, 100);
            SPRITE np = Engine.sprite[newsp];
            USER nu = Gameutils.pUser[newsp];
            np.hitag = (short)9999;
            Sprites.SetOwner(Weapon2, newsp);
            np.shade = (byte)-40;
            np.xrepeat = (short)(12 + Gameutils.RANDOM_RANGE(10));
            np.yrepeat = (short)(12 + Gameutils.RANDOM_RANGE(10));
            nu.ox = u.ox;
            nu.oy = u.oy;
            nu.oz = u.oz;
            np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
            np.cstat = (short)(np.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
            if (Gameutils.RANDOM_P2(1024) < 512) {
                np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_XFLIP);
            }
            if (Gameutils.RANDOM_P2(1024) < 512) {
                np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_YFLIP);
            }
            nu.xchange = u.xchange;
            nu.ychange = u.ychange;
            nu.zchange = u.zchange;
            np.pal = (short)19;
            nu.spal = (byte)19;
            Weapon.ScaleSpriteVector(newsp, 20000);
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                nu.Flags |= Gameutils.SPR_UNDERWATER;
            }
        }
        return false;
    }

    public static boolean DoChemBomb(int Weapon2) {
        SPRITE sp = Engine.sprite[Weapon2];
        USER u = Gameutils.pUser[Weapon2];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            Weapon.ScaleSpriteVector(Weapon2, 50000);
            u.Counter = (short)(u.Counter + 20);
            u.zchange += u.Counter;
        } else {
            u.Counter = (short)(u.Counter + 20);
            u.zchange += u.Counter;
        }
        u.ret = Sprites.move_missile(Weapon2, u.xchange, u.ychange, u.zchange, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_MISSILE, 6);
        Weapon.MissileHitDiveArea(Weapon2);
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER) && Gameutils.RANDOM_P2(16384) >> 4 < 256) {
            Weapon.SpawnBubble(Weapon2);
        }
        if (u.ret != 0) {
            switch (MyTypes.DTEST(u.ret, 57344)) {
                case 8192: {
                    Sprites.KillSprite(Weapon2);
                    return true;
                }
                case 49152: {
                    int hitsprite = -2;
                    if (!MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                        Sound.PlaySound(277, sp, 8);
                    }
                    hitsprite = Gameutils.NORM_SPRITE(u.ret);
                    SPRITE hsp = Engine.sprite[hitsprite];
                    if (MyTypes.TEST(hsp.cstat, Gameutils.CSTAT_SPRITE_WALL)) {
                        short wall_ang = Gameutils.NORM_ANGLE(hsp.ang);
                        Weapon.WallBounce(Weapon2, wall_ang);
                        Weapon.ScaleSpriteVector(Weapon2, 32000);
                        break;
                    }
                    if (u.WaitTics == CHEMTICS && !MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                        Sound.PlaySound(283, sp, 12);
                        VOC3D voc = Sound.PlaySound(276, sp, 12);
                        Sound.Set3DSoundOwner(Weapon2, voc);
                    }
                    u.ychange = 0;
                    u.xchange = 0;
                    u.WaitTics = (short)(u.WaitTics - 12);
                    if (u.WaitTics <= 0) {
                        Sprites.KillSprite((short)Weapon2);
                    }
                    return true;
                }
                case 32768: {
                    short hitwall = Gameutils.NORM_WALL(u.ret);
                    WALL wph = Engine.wall[hitwall];
                    if (wph.lotag == 307) {
                        Break.HitBreakWall(hitwall, sp.x, sp.y, sp.z, sp.ang, u.ID);
                        u.ret = 0;
                        break;
                    }
                    if (!MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                        Sound.PlaySound(277, sp, 8);
                    }
                    short nw = Engine.wall[hitwall].point2;
                    short wall_ang = Gameutils.NORM_ANGLE(Main.engine.getangle(Engine.wall[nw].x - wph.x, Engine.wall[nw].y - wph.y) + 512);
                    Weapon.WallBounce(Weapon2, wall_ang);
                    Weapon.ScaleSpriteVector(Weapon2, 32000);
                    break;
                }
                case 16384: {
                    short hitwall;
                    if (Weapon.SlopeBounce(Weapon2, Game.tmp_ptr[0])) {
                        short s = hitwall = Game.tmp_ptr[0].value != 0 ? (short)1 : 0;
                        if (hitwall != 0) {
                            Weapon.ScaleSpriteVector(Weapon2, 28000);
                            u.ret = 0;
                            u.Counter = 0;
                            break;
                        }
                        if (sp.z > MyTypes.DIV2(u.hiz + u.loz)) {
                            if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                                if (!MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                                    Sound.PlaySound(277, sp, 8);
                                }
                                u.Flags |= Gameutils.SPR_BOUNCE;
                                Weapon.ScaleSpriteVector(Weapon2, 32000);
                                u.zchange /= 6;
                                u.ret = 0;
                                u.Counter = 0;
                                break;
                            }
                            if (u.WaitTics == CHEMTICS && !MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                                Sound.PlaySound(283, sp, 12);
                                VOC3D voc = Sound.PlaySound(276, sp, 12);
                                Sound.Set3DSoundOwner(Weapon2, voc);
                            }
                            JWeapon.SpawnRadiationCloud(Weapon2);
                            u.ychange = 0;
                            u.xchange = 0;
                            u.WaitTics = (short)(u.WaitTics - 12);
                            if (u.WaitTics <= 0) {
                                Sprites.KillSprite((short)Weapon2);
                            }
                            return true;
                        }
                        Weapon.ScaleSpriteVector(Weapon2, 32000);
                        break;
                    }
                    if (sp.z > MyTypes.DIV2(u.hiz + u.loz)) {
                        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        if (u.lo_sectp != -1 && Sector.SectUser[sp.sectnum] != null && Sector.SectUser[sp.sectnum].depth != 0) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                            if (!MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                                Sound.PlaySound(277, sp, 8);
                            }
                            u.Flags |= Gameutils.SPR_BOUNCE;
                            u.ret = 0;
                            u.Counter = 0;
                            u.zchange = -u.zchange;
                            Weapon.ScaleSpriteVector(Weapon2, 32000);
                            u.zchange /= 6;
                            break;
                        }
                        if (u.WaitTics == CHEMTICS && !MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE)) {
                            Sound.PlaySound(283, sp, 12);
                            VOC3D voc = Sound.PlaySound(276, sp, 12);
                            Sound.Set3DSoundOwner(Weapon2, voc);
                        }
                        JWeapon.SpawnRadiationCloud(Weapon2);
                        u.ychange = 0;
                        u.xchange = 0;
                        u.WaitTics = (short)(u.WaitTics - 12);
                        if (u.WaitTics <= 0) {
                            Sprites.KillSprite((short)Weapon2);
                        }
                        return true;
                    }
                    u.zchange = -u.zchange;
                    Weapon.ScaleSpriteVector(Weapon2, 32000);
                }
            }
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE | Gameutils.SPR_UNDERWATER) && !MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_INVISIBLE)) {
            int newsp = Sprites.SpawnSprite(4, 1748, Weapon.s_Puff[0], sp.sectnum, sp.x, sp.y, sp.z, sp.ang, 100);
            SPRITE np = Engine.sprite[newsp];
            USER nu = Gameutils.pUser[newsp];
            Sprites.SetOwner(Weapon2, newsp);
            np.shade = (byte)-40;
            np.xrepeat = (short)40;
            np.yrepeat = (short)40;
            nu.ox = u.ox;
            nu.oy = u.oy;
            nu.oz = u.oz;
            np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
            np.cstat = (short)(np.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
            nu.xchange = u.xchange;
            nu.ychange = u.ychange;
            nu.zchange = u.zchange;
            np.pal = (short)22;
            nu.spal = (byte)22;
            Weapon.ScaleSpriteVector(newsp, 20000);
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                nu.Flags |= Gameutils.SPR_UNDERWATER;
            }
        }
        return false;
    }

    public static int DoCaltropsStick(int Weapon2) {
        USER u = Gameutils.pUser[Weapon2];
        short s = u.Counter = u.Counter == 0 ? (short)1 : 0;
        if (u.Counter != 0) {
            Weapon.DoFlamesDamageTest(Weapon2);
        }
        return 0;
    }

    public static boolean DoCaltrops(int Weapon2) {
        SPRITE sp = Engine.sprite[Weapon2];
        USER u = Gameutils.pUser[Weapon2];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            Weapon.ScaleSpriteVector(Weapon2, 50000);
            u.Counter = (short)(u.Counter + 20);
            u.zchange += u.Counter;
        } else {
            u.Counter = (short)(u.Counter + 70);
            u.zchange += u.Counter;
        }
        u.ret = Sprites.move_missile(Weapon2, u.xchange, u.ychange, u.zchange, u.ceiling_dist, u.floor_dist, Gameutils.CLIPMASK_MISSILE, 6);
        Weapon.MissileHitDiveArea(Weapon2);
        if (u.ret != 0) {
            switch (MyTypes.DTEST(u.ret, 57344)) {
                case 8192: {
                    Sprites.KillSprite(Weapon2);
                    return true;
                }
                case 49152: {
                    int hitsprite = -2;
                    Sound.PlaySound(288, sp, 8);
                    hitsprite = Gameutils.NORM_SPRITE(u.ret);
                    SPRITE hsp = Engine.sprite[hitsprite];
                    if (MyTypes.TEST(hsp.cstat, Gameutils.CSTAT_SPRITE_WALL)) {
                        short wall_ang = Gameutils.NORM_ANGLE(hsp.ang);
                        Weapon.WallBounce(Weapon2, wall_ang);
                        Weapon.ScaleSpriteVector(Weapon2, 10000);
                        break;
                    }
                    u.ychange = 0;
                    u.xchange = 0;
                    break;
                }
                case 32768: {
                    short hitwall = Gameutils.NORM_WALL(u.ret);
                    WALL wph = Engine.wall[hitwall];
                    if (wph.lotag == 307) {
                        Break.HitBreakWall(hitwall, sp.x, sp.y, sp.z, sp.ang, u.ID);
                        u.ret = 0;
                        break;
                    }
                    Sound.PlaySound(288, sp, 8);
                    short nw = Engine.wall[hitwall].point2;
                    short wall_ang = Gameutils.NORM_ANGLE(Main.engine.getangle(Engine.wall[nw].x - wph.x, Engine.wall[nw].y - wph.y) + 512);
                    Weapon.WallBounce(Weapon2, wall_ang);
                    Weapon.ScaleSpriteVector(Weapon2, 1000);
                    break;
                }
                case 16384: {
                    if (Weapon.SlopeBounce(Weapon2, Game.tmp_ptr[0])) {
                        boolean hitwall;
                        boolean bl = hitwall = Game.tmp_ptr[0].value != 0;
                        if (hitwall) {
                            Weapon.ScaleSpriteVector(Weapon2, 1000);
                            u.ret = 0;
                            u.Counter = 0;
                            break;
                        }
                        if (sp.z > MyTypes.DIV2(u.hiz + u.loz)) {
                            if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                                Sound.PlaySound(288, sp, 8);
                                u.Flags |= Gameutils.SPR_BOUNCE;
                                Weapon.ScaleSpriteVector(Weapon2, 1000);
                                u.ret = 0;
                                u.Counter = 0;
                                break;
                            }
                            u.ychange = 0;
                            u.xchange = 0;
                            sp.extra = (short)(sp.extra | Gameutils.SPRX_BREAKABLE);
                            sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_BREAKABLE);
                            Sprites.ChangeState(Weapon2, s_CaltropsStick[0]);
                            return true;
                        }
                        Weapon.ScaleSpriteVector(Weapon2, 1000);
                        break;
                    }
                    if (sp.z > MyTypes.DIV2(u.hiz + u.loz)) {
                        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        if (u.lo_sectp != -1 && Sector.SectUser[sp.sectnum] != null && Sector.SectUser[sp.sectnum].depth != 0) {
                            u.Flags |= Gameutils.SPR_BOUNCE;
                        }
                        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_BOUNCE)) {
                            Sound.PlaySound(288, sp, 8);
                            u.Flags |= Gameutils.SPR_BOUNCE;
                            u.ret = 0;
                            u.Counter = 0;
                            u.zchange = -u.zchange;
                            Weapon.ScaleSpriteVector(Weapon2, 1000);
                            break;
                        }
                        u.ychange = 0;
                        u.xchange = 0;
                        sp.extra = (short)(sp.extra | Gameutils.SPRX_BREAKABLE);
                        sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_BREAKABLE);
                        Sprites.ChangeState(Weapon2, s_CaltropsStick[0]);
                        return true;
                    }
                    u.zchange = -u.zchange;
                    Weapon.ScaleSpriteVector(Weapon2, 1000);
                }
            }
        }
        return false;
    }

    public static int SpawnRadiationCloud(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        if (Sprites.MoveSkip4 == 0) {
            return 0;
        }
        if (u.ID == 3280 || u.ID == 3121) {
            short s = u.Counter2;
            u.Counter2 = (short)(s + 1);
            if (s > 16) {
                u.Counter2 = 0;
            }
            if (u.Counter2 != 0) {
                return 0;
            }
        } else {
            short s = u.Counter2;
            u.Counter2 = (short)(s + 1);
            if (s > 2) {
                u.Counter2 = 0;
            }
            if (u.Counter2 != 0) {
                return 0;
            }
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_UNDERWATER)) {
            return -1;
        }
        int newsp = Sprites.SpawnSprite(4, 3258, s_RadiationCloud[0], sp.sectnum, sp.x, sp.y, sp.z - Gameutils.RANDOM_P2(Gameutils.Z(8)), sp.ang, 0);
        SPRITE np = Engine.sprite[newsp];
        USER nu = Gameutils.pUser[newsp];
        Sprites.SetOwner(sp.owner, newsp);
        nu.WaitTics = (short)120;
        np.shade = (byte)-40;
        np.xrepeat = (short)32;
        np.yrepeat = (short)32;
        np.clipdist = sp.clipdist;
        np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        np.cstat = (short)(np.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        np.pal = (short)22;
        nu.spal = (byte)22;
        np.hitag = (short)Gameutils.SECTFU_DONT_COPY_PALETTE;
        if (Gameutils.RANDOM_P2(1024) < 512) {
            np.cstat = (short)(np.cstat | Gameutils.CSTAT_SPRITE_XFLIP);
        }
        np.ang = (short)Gameutils.RANDOM_P2(2048);
        np.xvel = (short)Gameutils.RANDOM_P2(32);
        nu.Counter = 0;
        nu.Counter2 = 0;
        if (u.ID == 3280 || u.ID == 3121) {
            nu.Radius = 2000;
            nu.xchange = Gameutils.MOVEx(np.xvel >> 2, np.ang);
            nu.ychange = Gameutils.MOVEy(np.xvel >> 2, np.ang);
            np.zvel = (short)(Gameutils.Z(1) + Gameutils.RANDOM_P2(Gameutils.Z(2)));
        } else {
            nu.xchange = Gameutils.MOVEx(np.xvel, np.ang);
            nu.ychange = Gameutils.MOVEy(np.xvel, np.ang);
            np.zvel = (short)(Gameutils.Z(4) + Gameutils.RANDOM_P2(Gameutils.Z(4)));
            nu.Radius = 4000;
        }
        return 0;
    }

    public static void DoRadiationCloud(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        sp.z -= sp.zvel;
        sp.x += u.xchange;
        sp.y += u.ychange;
        if (u.ID != 0) {
            Weapon.DoFlamesDamageTest(SpriteNum);
        }
    }

    public static void PlayerInitChemBomb(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        Sound.PlaySound(278, pp, 12);
        int nx = pp.posx;
        int ny = pp.posy;
        int nz = pp.posz + pp.bob_z + Gameutils.Z(8);
        int w = Sprites.SpawnSprite(4, 3038, s_ChemBomb[0], pp.cursectnum, nx, ny, nz, pp.getAnglei(), 420);
        SPRITE wp = Engine.sprite[w];
        USER wu = Gameutils.pUser[w];
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_CRAWLING)) {
            wp.xvel = (short)(wp.xvel - MyTypes.DIV4(wp.xvel));
        }
        wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        Sprites.SetOwner(pp.PlayerSprite, w);
        wp.yrepeat = (short)32;
        wp.xrepeat = (short)32;
        wp.shade = (byte)-15;
        wu.WeaponNum = u.WeaponNum;
        wu.Radius = 200;
        wu.ceiling_dist = (short)Gameutils.Z(3);
        wu.floor_dist = (short)Gameutils.Z(3);
        wu.Counter = 0;
        wp.cstat = (short)(wp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        wp.cstat = (short)(wp.cstat | Gameutils.CSTAT_SPRITE_BLOCK);
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING) || Gameutils.SpriteInUnderwaterArea(wp)) {
            wu.Flags |= Gameutils.SPR_UNDERWATER;
        }
        wp.zvel = (short)((100 - pp.getHorizi()) * 128);
        SPRITE psp = pp.getSprite();
        short oclipdist = (short)psp.clipdist;
        psp.clipdist = 0;
        wp.clipdist = 0;
        Weapon.MissileSetPos(w, DoChemBomb, 1000);
        psp.clipdist = oclipdist;
        wp.clipdist = 20;
        wu.xchange = Gameutils.MOVEx(wp.xvel, wp.ang);
        wu.ychange = Gameutils.MOVEy(wp.xvel, wp.ang);
        wu.zchange = wp.zvel >> 1;
        wu.xchange += pp.xvect >> 14;
        wu.ychange += pp.yvect >> 14;
        wu.WaitTics = (short)CHEMTICS;
    }

    public static int InitSpriteChemBomb(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Engine.sprite[SpriteNum];
        Sound.PlaySound(278, sp, 12);
        int nx = sp.x;
        int ny = sp.y;
        int nz = sp.z;
        int w = Sprites.SpawnSprite(4, 3038, s_ChemBomb[0], sp.sectnum, nx, ny, nz, sp.ang, 420);
        SPRITE wp = Engine.sprite[w];
        USER wu = Gameutils.pUser[w];
        wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        Sprites.SetOwner(SpriteNum, w);
        wp.yrepeat = (short)32;
        wp.xrepeat = (short)32;
        wp.shade = (byte)-15;
        wu.WeaponNum = u.WeaponNum;
        wu.Radius = 200;
        wu.ceiling_dist = (short)Gameutils.Z(3);
        wu.floor_dist = (short)Gameutils.Z(3);
        wu.Counter = 0;
        wp.cstat = (short)(wp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        wp.cstat = (short)(wp.cstat | Gameutils.CSTAT_SPRITE_BLOCK);
        wp.zvel = (short)((-100 - Gameutils.RANDOM_RANGE(100)) * 128);
        wp.clipdist = 20;
        wu.xchange = Gameutils.MOVEx(wp.xvel, wp.ang);
        wu.ychange = Gameutils.MOVEy(wp.xvel, wp.ang);
        wu.zchange = wp.zvel >> 1;
        wu.WaitTics = (short)CHEMTICS;
        return 0;
    }

    public static int InitChemBomb(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int nx = sp.x;
        int ny = sp.y;
        int nz = sp.z;
        int w = Sprites.SpawnSprite(4, 3280, s_ChemBomb[0], sp.sectnum, nx, ny, nz, sp.ang, 420);
        SPRITE wp = Engine.sprite[w];
        USER wu = Gameutils.pUser[w];
        wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        Sprites.SetOwner(sp.owner, w);
        wp.yrepeat = (short)32;
        wp.xrepeat = (short)32;
        wp.shade = (byte)-15;
        wu.Radius = 200;
        wu.ceiling_dist = (short)Gameutils.Z(3);
        wu.floor_dist = (short)Gameutils.Z(3);
        wu.Counter = 0;
        wp.cstat = (short)(wp.cstat | (Gameutils.CSTAT_SPRITE_YCENTER | Gameutils.CSTAT_SPRITE_INVISIBLE));
        wp.cstat = (short)(wp.cstat & ~Gameutils.CSTAT_SPRITE_BLOCK);
        if (Gameutils.SpriteInUnderwaterArea(wp)) {
            wu.Flags |= Gameutils.SPR_UNDERWATER;
        }
        wp.zvel = (short)((-100 - Gameutils.RANDOM_RANGE(100)) * 128);
        wp.clipdist = 0;
        if (u.ID == 3280 || u.ID == 3121 || u.ID == 1210) {
            wu.xchange = 0;
            wu.ychange = 0;
            wu.zchange = 0;
            wp.zvel = 0;
            wp.yvel = 0;
            wp.xvel = 0;
            wu.WaitTics = (short)4800;
        } else {
            wu.xchange = Gameutils.MOVEx(wp.xvel, wp.ang);
            wu.ychange = Gameutils.MOVEy(wp.xvel, wp.ang);
            wu.zchange = wp.zvel >> 1;
            wu.WaitTics = (short)360;
        }
        return 0;
    }

    public static int PlayerInitFlashBomb(PlayerStr pp) {
        SPRITE sp = pp.getSprite();
        Sound.PlaySound(283, pp, 12);
        Palette.SetFadeAmt(pp, -30, 1);
        block0: for (int stat = 0; stat < Weapon.StatDamageList.length; stat = (int)((short)(stat + 1))) {
            short i = Engine.headspritestat[Weapon.StatDamageList[stat]];
            while (i != -1) {
                short nexti = Engine.nextspritestat[i];
                SPRITE hp = Engine.sprite[i];
                USER hu = Gameutils.pUser[i];
                if (i == pp.PlayerSprite) continue block0;
                int dist = Gameutils.DISTANCE(hp.x, hp.y, sp.x, sp.y);
                if (dist <= 16384 && MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_BLOCK) && Rooms.FAFcansee(hp.x, hp.y, hp.z, hp.sectnum, sp.x, sp.y, sp.z - Gameutils.SPRITEp_SIZE_Z(sp), sp.sectnum)) {
                    short damage = (short)Weapon.GetDamage(i, pp.PlayerSprite, 31);
                    if (hu.sop_parent != -1) continue block0;
                    if (hu.PlayerP != -1) {
                        if (damage < -70) {
                            int choosesnd = 0;
                            choosesnd = Gameutils.RANDOM_RANGE(5);
                            Sound.PlayerSound(Sound.PlayerLowHealthPainVocs[choosesnd], 13, pp);
                        }
                        Palette.SetFadeAmt(Game.Player[hu.PlayerP], damage, 1);
                    } else {
                        Weapon.ActorPain(i);
                        JWeapon.SpawnFlashBombOnActor(i);
                    }
                }
                i = nexti;
            }
        }
        return 0;
    }

    public static int InitFlashBomb(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        PlayerStr pp = Game.Player[Game.screenpeek];
        Sound.PlaySound(283, sp, 12);
        block0: for (int stat = 0; stat < Weapon.StatDamageList.length; stat = (int)((short)(stat + 1))) {
            short i = Engine.headspritestat[Weapon.StatDamageList[stat]];
            while (i != -1) {
                short nexti = Engine.nextspritestat[i];
                SPRITE hp = Engine.sprite[i];
                USER hu = Gameutils.pUser[i];
                int dist = Gameutils.DISTANCE(hp.x, hp.y, sp.x, sp.y);
                if (dist <= 16384 && MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_BLOCK) && Rooms.FAFcansee(hp.x, hp.y, hp.z, hp.sectnum, sp.x, sp.y, sp.z - Gameutils.SPRITEp_SIZE_Z(sp), sp.sectnum)) {
                    short damage = (short)Weapon.GetDamage(i, SpriteNum, 31);
                    if (hu.sop_parent != -1) continue block0;
                    if (hu.PlayerP != -1) {
                        if (damage < -70) {
                            int choosesnd = 0;
                            choosesnd = Gameutils.RANDOM_RANGE(5);
                            Sound.PlayerSound(Sound.PlayerLowHealthPainVocs[choosesnd], 13, pp);
                        }
                        Palette.SetFadeAmt(Game.Player[hu.PlayerP], damage, 1);
                    } else if (i != SpriteNum) {
                        Weapon.ActorPain(i);
                        JWeapon.SpawnFlashBombOnActor(i);
                    }
                }
                i = nexti;
            }
        }
        return 0;
    }

    public static int SpawnFlashBombOnActor(short enemy) {
        SPRITE ep = Engine.sprite[enemy];
        USER eu = Gameutils.pUser[enemy];
        if (MyTypes.TEST(ep.extra, Gameutils.SPRX_BURNABLE)) {
            return eu.flame;
        }
        if (enemy >= 0 && eu.flame >= 0) {
            int sizez = Gameutils.SPRITEp_SIZE_Z(ep) + MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(ep));
            SPRITE np = Engine.sprite[eu.flame];
            USER nu = Gameutils.pUser[eu.flame];
            nu.Counter = nu.Counter >= Gameutils.SPRITEp_SIZE_Z_2_YREPEAT(np, sizez) ? (short)(Gameutils.SPRITEp_SIZE_Z_2_YREPEAT(np, sizez) * 2) : (short)(nu.Counter + Gameutils.SPRITEp_SIZE_Z_2_YREPEAT(np, 2048) * 2);
            if (nu.Counter >= 230) {
                nu.Counter = (short)230;
            }
            if (nu.WaitTics < 240) {
                nu.WaitTics = (short)240;
            }
            return eu.flame;
        }
        int newsp = Sprites.SpawnSprite(4, 3212, Weapon.s_FireballFlames[0], ep.sectnum, ep.x, ep.y, ep.z, ep.ang, 0);
        SPRITE np = Engine.sprite[newsp];
        USER nu = Gameutils.pUser[newsp];
        if (enemy >= 0) {
            eu.flame = (short)newsp;
        }
        np.xrepeat = (short)16;
        np.yrepeat = (short)16;
        nu.Counter = enemy >= 0 ? (short)(Gameutils.SPRITEp_SIZE_Z_2_YREPEAT(np, Gameutils.SPRITEp_SIZE_Z(ep) >> 1) * 4) : (short)0;
        np.shade = (byte)-40;
        np.cstat = (short)(np.cstat | (Gameutils.CSTAT_SPRITE_YCENTER | Gameutils.CSTAT_SPRITE_INVISIBLE));
        np.cstat = (short)(np.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        nu.Radius = 200;
        if (enemy >= 0) {
            Sprites.SetAttach(enemy, newsp);
        }
        return newsp;
    }

    public static int PlayerInitCaltrops(PlayerStr pp) {
        USER u = Gameutils.pUser[pp.PlayerSprite];
        Sound.PlaySound(278, pp, 12);
        int nx = pp.posx;
        int ny = pp.posy;
        int nz = pp.posz + pp.bob_z + Gameutils.Z(8);
        int w = Sprites.SpawnSprite(3, 2218, s_Caltrops[0], pp.cursectnum, nx, ny, nz, pp.getAnglei(), (420 + Gameutils.RANDOM_RANGE(420)) / 2);
        SPRITE wp = Engine.sprite[w];
        USER wu = Gameutils.pUser[w];
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_CRAWLING)) {
            wp.xvel = (short)(wp.xvel - MyTypes.DIV4(wp.xvel));
        }
        wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        Sprites.SetOwner(pp.PlayerSprite, w);
        wp.yrepeat = (short)64;
        wp.xrepeat = (short)64;
        wp.shade = (byte)-15;
        wu.WeaponNum = u.WeaponNum;
        wu.Radius = 200;
        wu.ceiling_dist = (short)Gameutils.Z(3);
        wu.floor_dist = (short)Gameutils.Z(3);
        wu.Counter = 0;
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_DIVING) || Gameutils.SpriteInUnderwaterArea(wp)) {
            wu.Flags |= Gameutils.SPR_UNDERWATER;
        }
        wp.zvel = (short)((100 - pp.getHorizi()) * 128);
        SPRITE psp = pp.getSprite();
        short oclipdist = (short)psp.clipdist;
        psp.clipdist = 0;
        wp.clipdist = 0;
        Weapon.MissileSetPos(w, DoCaltrops, 1000);
        psp.clipdist = oclipdist;
        wp.clipdist = 20;
        wu.xchange = Gameutils.MOVEx(wp.xvel, wp.ang);
        wu.ychange = Gameutils.MOVEy(wp.xvel, wp.ang);
        wu.zchange = wp.zvel >> 1;
        wu.xchange += pp.xvect >> 14;
        wu.ychange += pp.yvect >> 14;
        Break.SetupSpriteForBreak(wp);
        return 0;
    }

    public static int InitCaltrops(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        Sound.PlaySound(278, sp, 12);
        int nx = sp.x;
        int ny = sp.y;
        int nz = sp.z;
        int w = Sprites.SpawnSprite(3, 2218, s_Caltrops[0], sp.sectnum, nx, ny, nz, sp.ang, 210);
        SPRITE wp = Engine.sprite[w];
        USER wu = Gameutils.pUser[w];
        wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        Sprites.SetOwner(SpriteNum, w);
        wp.yrepeat = (short)64;
        wp.xrepeat = (short)64;
        wp.shade = (byte)-15;
        wp.clipdist = sp.clipdist;
        wu.WeaponNum = u.WeaponNum;
        wu.Radius = 200;
        wu.ceiling_dist = (short)Gameutils.Z(3);
        wu.floor_dist = (short)Gameutils.Z(3);
        wu.Counter = 0;
        wp.zvel = (short)((-100 - Gameutils.RANDOM_RANGE(100)) * 128);
        wu.xchange = Gameutils.MOVEx(wp.xvel, wp.ang);
        wu.ychange = Gameutils.MOVEy(wp.xvel, wp.ang);
        wu.zchange = wp.zvel >> 1;
        Break.SetupSpriteForBreak(wp);
        return 0;
    }

    public static int InitPhosphorus(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        Sound.PlaySound(187, sp, 1);
        int nx = sp.x;
        int ny = sp.y;
        int nz = sp.z;
        short daang = Gameutils.NORM_ANGLE(Gameutils.RANDOM_RANGE(2048));
        int w = Sprites.SpawnSprite(6, 2010, s_Phosphorus[0], sp.sectnum, nx, ny, nz, daang, 140);
        SPRITE wp = Engine.sprite[w];
        USER wu = Gameutils.pUser[w];
        wp.hitag = (short)9999;
        wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        wp.cstat = (short)(wp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        wp.shade = (byte)-128;
        wp.yrepeat = (short)64;
        wp.xrepeat = (short)64;
        wp.shade = (byte)-15;
        wp.clipdist = sp.clipdist > 0 ? sp.clipdist - 1 : sp.clipdist;
        wu.WeaponNum = u.WeaponNum;
        wu.Radius = 600;
        wu.ceiling_dist = (short)Gameutils.Z(3);
        wu.floor_dist = (short)Gameutils.Z(3);
        wu.Counter = 0;
        wp.zvel = (short)((-100 - Gameutils.RANDOM_RANGE(100)) * 128);
        wu.xchange = Gameutils.MOVEx(wp.xvel, wp.ang);
        wu.ychange = Gameutils.MOVEy(wp.xvel, wp.ang);
        wu.zchange = wp.zvel >> 1;
        return 0;
    }

    public static int InitBloodSpray(int SpriteNum, boolean dogib, int velocity) {
        SPRITE sp = Engine.sprite[SpriteNum];
        USER u = Gameutils.pUser[SpriteNum];
        int cnt = dogib ? Gameutils.RANDOM_RANGE(3) + 1 : 1;
        int rnd = Gameutils.RANDOM_RANGE(1000);
        if (rnd > 650) {
            Sound.PlaySound(395, sp, 0);
        } else if (rnd > 350) {
            Sound.PlaySound(396, sp, 0);
        } else {
            Sound.PlaySound(411, sp, 0);
        }
        short ang = sp.ang;
        int vel = velocity;
        for (int i = 0; i < cnt; ++i) {
            if (velocity == -1) {
                vel = 105 + Gameutils.RANDOM_RANGE(320);
            } else if (velocity == -2) {
                vel = 105 + Gameutils.RANDOM_RANGE(100);
            }
            ang = dogib ? Gameutils.NORM_ANGLE(ang + 512 + Gameutils.RANDOM_RANGE(200)) : Gameutils.NORM_ANGLE(ang + 1024 + 256 - Gameutils.RANDOM_RANGE(256));
            int nx = sp.x;
            int ny = sp.y;
            int nz = Gameutils.SPRITEp_TOS(sp) - 20;
            int w = Sprites.SpawnSprite(4, 1562, s_BloodSprayChunk[0], sp.sectnum, nx, ny, nz, ang, vel * 2);
            SPRITE wp = Engine.sprite[w];
            USER wu = Gameutils.pUser[w];
            wu.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
            wp.cstat = dogib ? (short)(wp.cstat | Gameutils.CSTAT_SPRITE_YCENTER) : (short)(wp.cstat | (Gameutils.CSTAT_SPRITE_YCENTER | Gameutils.CSTAT_SPRITE_INVISIBLE));
            wp.shade = (byte)-12;
            Sprites.SetOwner(SpriteNum, w);
            wp.yrepeat = (short)(64 - Gameutils.RANDOM_RANGE(35));
            wp.xrepeat = (short)(64 - Gameutils.RANDOM_RANGE(35));
            wp.shade = (byte)-15;
            wp.clipdist = sp.clipdist;
            wu.WeaponNum = u.WeaponNum;
            wu.Radius = 600;
            wu.ceiling_dist = (short)Gameutils.Z(3);
            wu.floor_dist = (short)Gameutils.Z(3);
            wu.Counter = 0;
            wp.zvel = (short)((-10 - Gameutils.RANDOM_RANGE(50)) * 128);
            wu.xchange = Gameutils.MOVEx(wp.xvel, wp.ang);
            wu.ychange = Gameutils.MOVEy(wp.xvel, wp.ang);
            wu.zchange = wp.zvel >> 1;
            if (Weapon.GlobalSkipZrange) continue;
            Sprites.DoActorZrange(w);
        }
        return 0;
    }

    public static void BloodSprayFall(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        sp.z += 1500;
    }

    public static void DoFlagScore(short pal) {
        short SpriteNum = 0;
        short NextSprite = 0;
        SpriteNum = Engine.headspritestat[0];
        while (SpriteNum != -1) {
            NextSprite = Engine.nextspritestat[SpriteNum];
            SPRITE sp = Engine.sprite[SpriteNum];
            if (sp.picnum >= 1900 && sp.picnum <= 1999) {
                if (sp.pal == pal) {
                    sp.picnum = (short)(sp.picnum + 1);
                }
                if (sp.picnum > 1999) {
                    sp.picnum = (short)1900;
                }
            }
            SpriteNum = NextSprite;
        }
    }

    public static int DoFlagRangeTest(int Weapon2, int range) {
        SPRITE wp = Engine.sprite[Weapon2];
        for (int stat = 0; stat < Weapon.StatDamageList.length; stat = (int)((short)(stat + 1))) {
            short i = Engine.headspritestat[Weapon.StatDamageList[stat]];
            while (i != -1) {
                short nexti = Engine.nextspritestat[i];
                SPRITE sp = Engine.sprite[i];
                long dist = Gameutils.DISTANCE(sp.x, sp.y, wp.x, wp.y);
                if (dist <= (long)range && sp != wp && MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_BLOCK) && MyTypes.TEST(sp.extra, Gameutils.SPRX_PLAYER_OR_ENEMY) && Rooms.FAFcansee(sp.x, sp.y, sp.z, sp.sectnum, wp.x, wp.y, wp.z, wp.sectnum) && (dist = (long)Gameutils.FindDistance3D(wp.x - sp.x, wp.y - sp.y, wp.z - sp.z >> 4)) <= (long)range) {
                    return i;
                }
                i = nexti;
            }
        }
        return -1;
    }

    public static boolean DoCarryFlag(int Weapon2) {
        SPRITE ap;
        SPRITE sp = Engine.sprite[Weapon2];
        USER u = Gameutils.pUser[Weapon2];
        SPRITE fp = Engine.sprite[u.FlagOwner];
        if (u.Attach >= 0) {
            ap = Engine.sprite[u.Attach];
            Main.engine.setspritez((short)Weapon2, ap.x, ap.y, Gameutils.SPRITEp_MID(ap));
            sp.ang = Gameutils.NORM_ANGLE(ap.ang + 1536);
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_ACTIVE)) {
            u.WaitTics = (short)(u.WaitTics - 12);
            if (u.WaitTics > 0) {
                return false;
            }
            u.WaitTics = (short)Gameutils.SEC(30);
            u.Counter2 = 0;
            u.Flags |= Gameutils.SPR_ACTIVE;
        }
        u.Counter = (short)(u.Counter + 1);
        if (u.Counter > 1) {
            u.Counter = 0;
        }
        if (u.Counter == 0) {
            if (u.Counter2 < 99) {
                ap = Engine.sprite[u.Attach];
                USER au = Gameutils.pUser[u.Attach];
                if (au == null || au.Health <= 0) {
                    u.Counter2 = (short)99;
                    u.WaitTics = (short)(Gameutils.SEC(1) / 2);
                }
                if (Engine.sector[ap.sectnum].hitag == 9000 && Engine.sector[ap.sectnum].lotag == ap.pal && ap.pal != sp.pal) {
                    if (u.FlagOwner >= 0 && fp.lotag != 0) {
                        Sector.DoMatchEverything(null, fp.lotag, 1);
                    }
                    if (!Gameutils.TEST_BOOL1(fp)) {
                        Sound.PlaySound(55, ap, 0);
                        JWeapon.DoFlagScore(ap.pal);
                        if (Gameutils.SP_TAG5(fp) > 0) {
                            fp.detail = (short)(fp.detail + 1);
                            if (fp.detail >= Gameutils.SP_TAG5(fp)) {
                                fp.detail = 0;
                                Sector.DoMatchEverything(null, Gameutils.SP_TAG6(fp), 1);
                            }
                        }
                    }
                    Weapon.SetSuicide(Weapon2);
                }
            } else {
                u.Counter2 = (short)99;
                u.WaitTics = (short)(Gameutils.SEC(1) / 2);
            }
        }
        u.WaitTics = (short)(u.WaitTics - 12);
        switch (u.Counter2) {
            case 0: {
                if (u.WaitTics >= Gameutils.SEC(30)) break;
                Sound.PlaySound(26, sp, 8);
                u.Counter2 = (short)(u.Counter2 + 1);
                break;
            }
            case 1: {
                if (u.WaitTics >= Gameutils.SEC(20)) break;
                Sound.PlaySound(26, sp, 8);
                u.Counter2 = (short)(u.Counter2 + 1);
                break;
            }
            case 2: {
                if (u.WaitTics >= Gameutils.SEC(10)) break;
                Sound.PlaySound(26, sp, 8);
                u.Counter2 = (short)(u.Counter2 + 1);
                break;
            }
            case 3: {
                if (u.WaitTics >= Gameutils.SEC(5)) break;
                Sound.PlaySound(26, sp, 8);
                u.Counter2 = (short)(u.Counter2 + 1);
                break;
            }
            case 4: {
                if (u.WaitTics >= Gameutils.SEC(4)) break;
                Sound.PlaySound(26, sp, 8);
                u.Counter2 = (short)(u.Counter2 + 1);
                break;
            }
            case 5: {
                if (u.WaitTics >= Gameutils.SEC(3)) break;
                Sound.PlaySound(26, sp, 8);
                u.Counter2 = (short)(u.Counter2 + 1);
                break;
            }
            case 6: {
                if (u.WaitTics >= Gameutils.SEC(2)) break;
                Sound.PlaySound(26, sp, 8);
                u.Counter2 = (short)99;
                break;
            }
            case 99: {
                Sound.PlaySound(26, sp, 8);
                u.Counter2 = (short)(u.Counter2 + 1);
                break;
            }
            case 100: {
                Weapon.SpawnGrenadeExp(Weapon2);
                Weapon.SetSuicide(Weapon2);
                return false;
            }
        }
        return false;
    }

    public static boolean DoCarryFlagNoDet(int Weapon2) {
        SPRITE sp = Engine.sprite[Weapon2];
        USER u = Gameutils.pUser[Weapon2];
        SPRITE fp = Engine.sprite[u.FlagOwner];
        USER fu = Gameutils.pUser[u.FlagOwner];
        if (fu == null && u.FlagOwner >= 0) {
            fu.WaitTics = (short)3600;
        }
        SPRITE ap = null;
        USER au = null;
        if (u.Attach >= 0) {
            ap = Engine.sprite[u.Attach];
            au = Gameutils.pUser[u.Attach];
            Main.engine.setspritez((short)Weapon2, ap.x, ap.y, Gameutils.SPRITEp_MID(ap));
            sp.ang = Gameutils.NORM_ANGLE(ap.ang + 1536);
            sp.z = ap.z - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(ap));
        }
        if (au == null || au.Health <= 0) {
            if (fu == null && u.FlagOwner >= 0) {
                fu.WaitTics = 0;
            }
            Weapon.SetSuicide(Weapon2);
            return false;
        }
        if (Engine.sector[ap.sectnum].hitag == 9000 && Engine.sector[ap.sectnum].lotag == ap.pal && ap.pal != sp.pal) {
            if (fu == null && u.FlagOwner >= 0) {
                if (fp.lotag != 0) {
                    Sector.DoMatchEverything(null, fp.lotag, 1);
                }
                fu.WaitTics = 0;
            }
            if (!Gameutils.TEST_BOOL1(fp)) {
                Sound.PlaySound(55, ap, 0);
                JWeapon.DoFlagScore(ap.pal);
                if (Gameutils.SP_TAG5(fp) > 0) {
                    fp.detail = (short)(fp.detail + 1);
                    if (fp.detail >= Gameutils.SP_TAG5(fp)) {
                        fp.detail = 0;
                        Sector.DoMatchEverything(null, Gameutils.SP_TAG6(fp), 1);
                    }
                }
            }
            Weapon.SetSuicide(Weapon2);
        }
        return false;
    }

    public static void SetCarryFlag(int Weapon2) {
        SPRITE sp = Engine.sprite[Weapon2];
        USER u = Gameutils.pUser[Weapon2];
        u.Flags |= Gameutils.SPR_BOUNCE;
        sp.cstat = (short)(sp.cstat | (Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        u.Counter = 0;
        Sprites.change_sprite_stat(Weapon2, 10);
        if (sp.hitag == 1) {
            Sprites.ChangeState(Weapon2, s_CarryFlagNoDet[0]);
        } else {
            Sprites.ChangeState(Weapon2, s_CarryFlag[0]);
        }
    }

    public static void DoFlag(int Weapon2) {
        SPRITE sp = Engine.sprite[Weapon2];
        USER u = Gameutils.pUser[Weapon2];
        int hitsprite = -1;
        hitsprite = JWeapon.DoFlagRangeTest(Weapon2, 1000);
        if (hitsprite != -1) {
            SPRITE hsp = Engine.sprite[hitsprite];
            JWeapon.SetCarryFlag(Weapon2);
            if (MyTypes.TEST(hsp.extra, Gameutils.SPRX_PLAYER_OR_ENEMY)) {
                sp.cstat = (short)(sp.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                Sprites.SetAttach(hitsprite, Weapon2);
                u.sz = hsp.z - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(hsp));
            }
        }
    }

    public static void InitShell(int SpriteNum, int ShellNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Engine.sprite[SpriteNum];
        int id = 0;
        short velocity = 0;
        State p = null;
        int nx = sp.x;
        int ny = sp.y;
        int nz = MyTypes.DIV2(Gameutils.SPRITEp_TOS(sp) + Gameutils.SPRITEp_BOS(sp));
        switch (ShellNum) {
            case -3: 
            case -2: {
                id = 2152;
                p = Weapon.s_UziShellShrap[0];
                velocity = (short)(1500 + Gameutils.RANDOM_RANGE(1000));
                break;
            }
            case -4: {
                id = 2180;
                p = Weapon.s_ShotgunShellShrap[0];
                velocity = (short)(2000 + Gameutils.RANDOM_RANGE(1000));
            }
        }
        int w = Sprites.SpawnSprite(6, id, p, sp.sectnum, nx, ny, nz, sp.ang, 64);
        SPRITE wp = Engine.sprite[w];
        USER wu = Gameutils.pUser[w];
        wp.zvel = -velocity;
        if (u.PlayerP != -1) {
            wp.z += (100 - Game.Player[u.PlayerP].getHorizi()) * 42;
        }
        switch (wu.ID) {
            case 2152: {
                wp.z -= Gameutils.Z(13);
                if (ShellNum == -3) {
                    wp.ang = sp.ang;
                    Weapon.HelpMissileLateral(w, 2500);
                    wp.ang = Gameutils.NORM_ANGLE(wp.ang - 512);
                    Weapon.HelpMissileLateral(w, 1000);
                    wp.ang = Gameutils.NORM_ANGLE(wp.ang + 712);
                } else {
                    wp.ang = sp.ang;
                    Weapon.HelpMissileLateral(w, 2500);
                    wp.ang = Gameutils.NORM_ANGLE(wp.ang + 512);
                    Weapon.HelpMissileLateral(w, 1500);
                    wp.ang = Gameutils.NORM_ANGLE(wp.ang - 128);
                }
                wp.ang = (short)(wp.ang + ((Gameutils.RANDOM_P2(4096) >> 5) - MyTypes.DIV2(128)));
                wp.ang = Gameutils.NORM_ANGLE(wp.ang);
                wu.ShellNum = Weapon.ShellCount;
                wp.xrepeat = (short)13;
                wp.yrepeat = (short)13;
                break;
            }
            case 2180: {
                wp.z -= Gameutils.Z(13);
                wp.ang = sp.ang;
                Weapon.HelpMissileLateral(w, 2500);
                wp.ang = Gameutils.NORM_ANGLE(wp.ang + 512);
                Weapon.HelpMissileLateral(w, 1300);
                wp.ang = Gameutils.NORM_ANGLE(wp.ang - 128 - 64);
                wp.ang = (short)(wp.ang + ((Gameutils.RANDOM_P2(4096) >> 5) - MyTypes.DIV2(128)));
                wp.ang = Gameutils.NORM_ANGLE(wp.ang);
                wu.ShellNum = Weapon.ShellCount;
                wp.xrepeat = (short)18;
                wp.yrepeat = (short)18;
            }
        }
        Sprites.SetOwner(SpriteNum, w);
        wp.shade = (byte)-15;
        wu.ceiling_dist = (short)Gameutils.Z(1);
        wu.floor_dist = (short)Gameutils.Z(1);
        wu.Counter = 0;
        wp.cstat = (short)(wp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
        wp.cstat = (short)(wp.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
        wu.Flags &= ~(Gameutils.SPR_BOUNCE | Gameutils.SPR_UNDERWATER);
        wu.xchange = Gameutils.MOVEx(wp.xvel, wp.ang);
        wu.ychange = Gameutils.MOVEy(wp.xvel, wp.ang);
        wu.zchange = wp.zvel;
        wu.jump_speed = (short)200;
        wu.jump_speed = (short)(wu.jump_speed + Gameutils.RANDOM_RANGE(400));
        wu.jump_speed = -wu.jump_speed;
        Actor.DoBeginJump(w);
        wu.jump_grav = (short)8;
    }

    public static void JWeaponSaveable() {
        Saveable.SaveData(BloodSprayFall);
        Saveable.SaveData(DoRadiationCloud);
        Saveable.SaveData(DoChemBomb);
        Saveable.SaveData(DoCaltrops);
        Saveable.SaveData(DoCaltropsStick);
        Saveable.SaveData(DoFlag);
        Saveable.SaveData(DoCarryFlag);
        Saveable.SaveData(DoCarryFlagNoDet);
        Saveable.SaveData(DoPhosphorus);
        Saveable.SaveData(DoBloodSpray);
        Saveable.SaveData(DoWallBloodDrip);
        Saveable.SaveData(s_BloodSpray);
        Saveable.SaveData(s_PhosphorExp);
        Saveable.SaveData(s_NukeMushroom);
        Saveable.SaveData(s_RadiationCloud);
        Saveable.SaveData(s_ChemBomb);
        Saveable.SaveData(s_Caltrops);
        Saveable.SaveData(s_CaltropsStick);
        Saveable.SaveData(s_CarryFlag);
        Saveable.SaveData(s_CarryFlagNoDet);
        Saveable.SaveData(s_Flag);
        Saveable.SaveData(s_Phosphorus);
        Saveable.SaveData(s_BloodSprayChunk);
        Saveable.SaveData(s_BloodSprayDrip);
    }
}

