/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Type.MyTypes;

public class Light {
    public static final int LIGHT_CONSTANT = 0;
    public static final int LIGHT_FLICKER = 1;
    public static final int LIGHT_FADE = 2;
    public static final int LIGHT_FLICKER_ON = 3;
    public static final int LIGHT_FADE_TO_ON_OFF = 4;

    public static final int LIGHT_Match(SPRITE sp) {
        return Gameutils.SP_TAG2(sp);
    }

    public static final int LIGHT_Type(SPRITE sp) {
        return Gameutils.SP_TAG3(sp);
    }

    public static final int LIGHT_MaxTics(SPRITE sp) {
        return Gameutils.SP_TAG4(sp);
    }

    public static final int LIGHT_MaxBright(SPRITE sp) {
        return Gameutils.SP_TAG5(sp);
    }

    public static final int LIGHT_MaxDark(SPRITE sp) {
        return Gameutils.SP_TAG6(sp);
    }

    public static final int LIGHT_ShadeInc(SPRITE sp) {
        return Gameutils.SP_TAG7(sp);
    }

    public static final boolean LIGHT_Dir(SPRITE sp) {
        return MyTypes.TEST(sp.extra, Gameutils.SPRX_BOOL10);
    }

    public static final int LIGHT_DirChange(SPRITE sp) {
        sp.extra = (short)(sp.extra ^ Gameutils.SPRX_BOOL10);
        return sp.extra;
    }

    public static final int LIGHT_Shade(SPRITE sp) {
        return sp.shade;
    }

    public static final int LIGHT_FloorShade(SPRITE sp) {
        return sp.xoffset;
    }

    public static final int LIGHT_CeilingShade(SPRITE sp) {
        return sp.yoffset;
    }

    public static final int LIGHT_Tics(SPRITE sp) {
        return sp.z;
    }

    public static final int LIGHT_DiffuseNum(SPRITE sp) {
        return Gameutils.SP_TAG3(sp);
    }

    public static final int LIGHT_DiffuseMult(SPRITE sp) {
        return Gameutils.SP_TAG4(sp);
    }

    public static void SectorLightShade(int spnum, int intensity) {
        SPRITE sp = Engine.sprite[spnum];
        if (Gameutils.TEST_BOOL8(sp)) {
            intensity = (short)(-intensity);
        }
        if (!Gameutils.TEST_BOOL2(sp)) {
            if (!Gameutils.TEST_BOOL6(sp)) {
                Engine.sector[sp.sectnum].floorpal = sp.pal;
            }
            Engine.sector[sp.sectnum].floorshade = (byte)(Light.LIGHT_FloorShade(sp) + intensity);
        }
        if (!Gameutils.TEST_BOOL3(sp)) {
            if (!Gameutils.TEST_BOOL6(sp)) {
                Engine.sector[sp.sectnum].ceilingpal = sp.pal;
            }
            Engine.sector[sp.sectnum].ceilingshade = (byte)(Light.LIGHT_CeilingShade(sp) + intensity);
        }
        if (!Gameutils.TEST_BOOL4(sp)) {
            byte[] wall_shade = Gameutils.pUser[spnum].WallShade;
            short startwall = Engine.sector[sp.sectnum].wallptr;
            short endwall = (short)(startwall + Engine.sector[sp.sectnum].wallnum - 1);
            int wallcount = 0;
            for (short w = startwall; w <= endwall; w = (short)(w + 1)) {
                short base_shade = wall_shade[wallcount];
                Engine.wall[w].shade = (byte)(base_shade + intensity);
                if (!Gameutils.TEST_BOOL6(sp)) {
                    Engine.wall[w].pal = sp.pal;
                }
                wallcount = (short)(wallcount + 1);
                if (!MyTypes.TEST(sp.extra, Gameutils.SPRX_BOOL5) || Engine.wall[w].nextwall < 0) continue;
                base_shade = wall_shade[wallcount];
                Engine.wall[Engine.wall[w].nextwall].shade = (byte)(base_shade + intensity);
                if (!Gameutils.TEST_BOOL6(sp)) {
                    Engine.wall[Engine.wall[w].nextwall].pal = sp.pal;
                }
                wallcount = (short)(wallcount + 1);
            }
        }
    }

    public static void DiffuseLighting(SPRITE sp) {
        short i = Engine.headspritestat[84];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE dsp = Engine.sprite[i];
            if (Light.LIGHT_Match(dsp) == Light.LIGHT_Match(sp)) {
                short shade = (short)(sp.shade + (Light.LIGHT_DiffuseNum(dsp) + 1) * Light.LIGHT_DiffuseMult(dsp));
                if (shade > Light.LIGHT_MaxDark(sp)) {
                    shade = (short)Light.LIGHT_MaxDark(sp);
                }
                if (!Gameutils.TEST_BOOL6(dsp)) {
                    dsp.pal = sp.pal;
                }
                Light.SectorLightShade(i, shade);
            }
            i = nexti;
        }
    }

    public static void DoLightingMatch(int match, int state) {
        short i = Engine.headspritestat[83];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (Light.LIGHT_Match(sp) == match) {
                switch (Light.LIGHT_Type(sp)) {
                    case 0: {
                        Gameutils.SET_BOOL9(sp);
                        if (state == -1) {
                            int n = state = !Gameutils.TEST_BOOL1(sp) ? 1 : 0;
                        }
                        if (state == 1) {
                            Gameutils.SET_BOOL1(sp);
                            sp.shade = (byte)(-Light.LIGHT_MaxBright(sp));
                            sp.pal = Gameutils.pUser[i].spal;
                            Light.SectorLightShade(i, sp.shade);
                            Light.DiffuseLighting(sp);
                            break;
                        }
                        Gameutils.RESET_BOOL1(sp);
                        sp.shade = (byte)Light.LIGHT_MaxDark(sp);
                        sp.pal = 0;
                        Light.SectorLightShade(i, sp.shade);
                        Light.DiffuseLighting(sp);
                        break;
                    }
                    case 1: 
                    case 2: {
                        Gameutils.SET_BOOL9(sp);
                        if (state == -1) {
                            int n = state = !Gameutils.TEST_BOOL1(sp) ? 1 : 0;
                        }
                        if (state == 1) {
                            Gameutils.SET_BOOL1(sp);
                            break;
                        }
                        Gameutils.RESET_BOOL1(sp);
                        sp.shade = (byte)Light.LIGHT_MaxDark(sp);
                        Light.SectorLightShade(i, sp.shade);
                        Light.DiffuseLighting(sp);
                        break;
                    }
                    case 4: {
                        Gameutils.SET_BOOL9(sp);
                        if (state == 1) {
                            if (Light.LIGHT_Dir(sp)) {
                                Light.LIGHT_DirChange(sp);
                            }
                        } else if (state == 0 && !Light.LIGHT_Dir(sp)) {
                            Light.LIGHT_DirChange(sp);
                        }
                        Gameutils.SET_BOOL1(sp);
                        break;
                    }
                    case 3: {
                        Gameutils.SET_BOOL9(sp);
                        if (state == -1) {
                            int n = state = !Gameutils.TEST_BOOL1(sp) ? 1 : 0;
                        }
                        if (state == 1) {
                            Gameutils.SET_BOOL1(sp);
                            break;
                        }
                        short spal = sp.pal;
                        Gameutils.RESET_BOOL1(sp);
                        sp.pal = 0;
                        sp.shade = (byte)Light.LIGHT_MaxDark(sp);
                        Light.SectorLightShade(i, sp.shade);
                        Light.DiffuseLighting(sp);
                        sp.pal = spal;
                    }
                }
            }
            i = nexti;
        }
    }

    public static void InitLighting() {
        short i = Engine.headspritestat[83];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (!Gameutils.TEST_BOOL9(sp)) {
                Light.DoLightingMatch(Light.LIGHT_Match(sp), Gameutils.TEST_BOOL1(sp) ? 1 : 0);
            }
            i = nexti;
        }
    }

    public static void DoLighting() {
        short i = Engine.headspritestat[83];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (Gameutils.TEST_BOOL1(sp)) {
                switch (Light.LIGHT_Type(sp)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        short spal;
                        sp.z += 3;
                        while (Light.LIGHT_Tics(sp) >= Light.LIGHT_MaxTics(sp)) {
                            sp.z -= Light.LIGHT_MaxTics(sp);
                            if (Gameutils.RANDOM_P2(32768) >> 8 > 64) {
                                sp.shade = (byte)(-Light.LIGHT_MaxBright(sp) + Gameutils.RANDOM_RANGE(Light.LIGHT_MaxBright(sp) + Light.LIGHT_MaxDark(sp)));
                                Light.SectorLightShade(i, sp.shade);
                                Light.DiffuseLighting(sp);
                                continue;
                            }
                            spal = sp.pal;
                            sp.pal = 0;
                            sp.shade = (byte)Light.LIGHT_MaxDark(sp);
                            Light.SectorLightShade(i, sp.shade);
                            Light.DiffuseLighting(sp);
                            sp.pal = spal;
                        }
                        break;
                    }
                    case 2: {
                        sp.z += 3;
                        while (Light.LIGHT_Tics(sp) >= Light.LIGHT_MaxTics(sp)) {
                            sp.z -= Light.LIGHT_MaxTics(sp);
                            if (Light.LIGHT_Dir(sp)) {
                                sp.shade = (byte)(sp.shade + Light.LIGHT_ShadeInc(sp));
                                if (sp.shade >= Light.LIGHT_MaxDark(sp)) {
                                    Light.LIGHT_DirChange(sp);
                                }
                            } else {
                                sp.shade = (byte)(sp.shade - Light.LIGHT_ShadeInc(sp));
                                if (sp.shade <= -Light.LIGHT_MaxBright(sp)) {
                                    Light.LIGHT_DirChange(sp);
                                }
                            }
                            Light.SectorLightShade(i, sp.shade);
                            Light.DiffuseLighting(sp);
                        }
                        break;
                    }
                    case 4: {
                        sp.z += 3;
                        while (Light.LIGHT_Tics(sp) >= Light.LIGHT_MaxTics(sp)) {
                            sp.z -= Light.LIGHT_MaxTics(sp);
                            if (Light.LIGHT_Dir(sp)) {
                                sp.shade = (byte)(sp.shade + Light.LIGHT_ShadeInc(sp));
                                if (sp.shade >= Light.LIGHT_MaxDark(sp)) {
                                    sp.pal = 0;
                                    Light.LIGHT_DirChange(sp);
                                    Gameutils.RESET_BOOL1(sp);
                                }
                            } else {
                                sp.shade = (byte)(sp.shade - Light.LIGHT_ShadeInc(sp));
                                sp.pal = Gameutils.pUser[i].spal;
                                if (sp.shade <= -Light.LIGHT_MaxBright(sp)) {
                                    Light.LIGHT_DirChange(sp);
                                    Gameutils.RESET_BOOL1(sp);
                                }
                            }
                            Light.SectorLightShade(i, sp.shade);
                            Light.DiffuseLighting(sp);
                        }
                        break;
                    }
                    case 3: {
                        short spal;
                        sp.z += 3;
                        while (Light.LIGHT_Tics(sp) >= Light.LIGHT_MaxTics(sp)) {
                            sp.z -= Light.LIGHT_MaxTics(sp);
                            if (Gameutils.RANDOM_P2(32768) >> 8 > 64) {
                                sp.shade = (byte)(-Light.LIGHT_MaxBright(sp) + Gameutils.RANDOM_RANGE(Light.LIGHT_MaxBright(sp) + Light.LIGHT_MaxDark(sp)));
                                Light.SectorLightShade(i, sp.shade);
                                Light.DiffuseLighting(sp);
                            } else {
                                spal = sp.pal;
                                sp.pal = 0;
                                sp.shade = (byte)Light.LIGHT_MaxDark(sp);
                                Light.SectorLightShade(i, sp.shade);
                                Light.DiffuseLighting(sp);
                                sp.pal = spal;
                            }
                            if (Gameutils.RANDOM_P2(32768) >> 8 >= 8) continue;
                            sp.shade = (byte)(-Light.LIGHT_MaxBright(sp));
                            Light.SectorLightShade(i, sp.shade);
                            Light.DiffuseLighting(sp);
                            Gameutils.RESET_BOOL1(sp);
                        }
                        break;
                    }
                }
            }
            i = nexti;
        }
    }
}

