/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Menus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Wang.Factory.WangMenuHandler;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.MenuDifficulty;
import ru.m210projects.Wang.Menus.WangTitle;
import ru.m210projects.Wang.Type.GameInfo;

public class MenuNewAddon
extends BuildMenu {
    private static final int nMaxEpisodes = 2;
    private GameInfo game;
    private MenuList mSlot;
    private final List<char[]> mEpisodelist;
    private final List<char[]> mEpisodeDescr;
    private int[] episodeNum;

    public MenuNewAddon(final Main app) {
        final WangMenuHandler menu = app.menu;
        this.addItem(new WangTitle("USER EPISODE"), false);
        this.mEpisodelist = new ArrayList<char[]>();
        this.mEpisodeDescr = new ArrayList<char[]>();
        this.episodeNum = new int[2];
        MenuProc newEpProc = new MenuProc(){

            @Override
            public void run(MenuHandler handler, MenuItem pItem) {
                MenuList button = (MenuList)pItem;
                MenuDifficulty next = (MenuDifficulty)menu.mMenus[4];
                next.setEpisode(MenuNewAddon.this.game, MenuNewAddon.this.episodeNum[button.l_nFocus]);
                menu.mOpen(next, -1);
            }
        };
        this.mSlot = new MenuList(this.mEpisodelist, app.getFont(2), 35, 45, 320, 0, null, newEpProc, 2){

            @Override
            public int mFontOffset() {
                return this.font.getHeight() + 17;
            }

            @Override
            public void draw(MenuHandler handler) {
                super.draw(handler);
                if (this.text.size() > 0) {
                    int py = this.y;
                    for (int i = this.l_nMin; i >= 0 && i < this.l_nMin + this.nListItems && i < this.len; ++i) {
                        app.getFont(1).drawText(this.x, py + 17, (char[])MenuNewAddon.this.mEpisodeDescr.get(i), 0, 4, BuildFont.TextAlign.Left, 2, false);
                        py += this.mFontOffset();
                    }
                }
            }
        };
        this.addItem(this.mSlot, true);
    }

    public boolean setEpisode(GameInfo game) {
        this.game = game;
        this.mEpisodelist.clear();
        this.mEpisodeDescr.clear();
        Arrays.fill(this.episodeNum, -1);
        for (int i = 0; i < game.episode.length; ++i) {
            if (game.episode[i] == null || game.episode[i].Title.isEmpty() || game.episode[i].nMaps == 0) continue;
            this.episodeNum[this.mEpisodelist.size()] = i;
            this.mEpisodelist.add(game.episode[i].Title.toCharArray());
            this.mEpisodeDescr.add(game.episode[i].Description.toCharArray());
        }
        this.mSlot.len = this.mEpisodelist.size();
        this.mSlot.l_nMin = 0;
        this.mSlot.l_nFocus = 0;
        return this.mEpisodelist.size() == 1;
    }
}

