/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Menus;

import java.util.HashMap;
import java.util.List;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.CRC32;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuFileBrowser;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Menus.MenuDifficulty;
import ru.m210projects.Wang.Menus.MenuNewAddon;
import ru.m210projects.Wang.Menus.Network.MenuNetwork;
import ru.m210projects.Wang.Menus.WangTitle;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Type.CustomScript;
import ru.m210projects.Wang.Type.EpisodeInfo;
import ru.m210projects.Wang.Type.GameInfo;
import ru.m210projects.Wang.Type.LevelInfo;

public class MenuUserContent
extends BuildMenu {
    public boolean showmain;
    private Main app;
    private MenuFileBrowser list;
    private HashMap<Long, EpisodeInfo> officialAddons = new HashMap<Long, EpisodeInfo>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(1488316004L, Game.pWantonEp);
            this.put(1830650101L, Game.pTwinDragonEp);
        }
    };
    private HashMap<String, LevelInfo> originalMaps = new HashMap<String, LevelInfo>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("$bullet.map", Game.pSharewareEp.gMapInfo[1]);
            this.put("$dozer.map", Game.pSharewareEp.gMapInfo[2]);
            this.put("$shrine.map", Game.pSharewareEp.gMapInfo[3]);
            this.put("$woods.map", Game.pSharewareEp.gMapInfo[4]);
            this.put("$whirl.map", Game.pOriginalEp.gMapInfo[0]);
            this.put("$tank.map", Game.pOriginalEp.gMapInfo[1]);
            this.put("$boat.map", Game.pOriginalEp.gMapInfo[2]);
            this.put("$garden.map", Game.pOriginalEp.gMapInfo[3]);
            this.put("$outpost.map", Game.pOriginalEp.gMapInfo[4]);
            this.put("$hidtemp.map", Game.pOriginalEp.gMapInfo[5]);
            this.put("$plax1.map", Game.pOriginalEp.gMapInfo[6]);
            this.put("$bath.map", Game.pOriginalEp.gMapInfo[7]);
            this.put("$airport.map", Game.pOriginalEp.gMapInfo[8]);
            this.put("$refiner.map", Game.pOriginalEp.gMapInfo[9]);
            this.put("$newmine.map", Game.pOriginalEp.gMapInfo[10]);
            this.put("$subbase.map", Game.pOriginalEp.gMapInfo[11]);
            this.put("$rock.map", Game.pOriginalEp.gMapInfo[12]);
            this.put("$yamato.map", Game.pOriginalEp.gMapInfo[13]);
            this.put("$seabase.map", Game.pOriginalEp.gMapInfo[14]);
            this.put("$volcano.map", Game.pOriginalEp.gMapInfo[15]);
            this.put("$shore.map", Game.pOriginalEp.gMapInfo[16]);
            this.put("$auto.map", Game.pOriginalEp.gMapInfo[17]);
        }
    };

    public MenuUserContent(final Main app) {
        this.app = app;
        this.addItem(new WangTitle("User content"), false);
        int width = 240;
        this.list = new MenuFileBrowser(app, app.getFont(0), app.getFont(1), app.getFont(0), 40, 40, width, 1, 14, 2324){

            @Override
            protected void drawHeader(int x1, int x2, int y) {
                app.getFont(1).drawText(x1, y, this.dirs, 65536, -32, this.topPal, BuildFont.TextAlign.Left, 2, this.fontShadow);
                app.getFont(1).drawText(x2, y, this.ffs, 65536, -32, this.topPal, BuildFont.TextAlign.Left, 2, this.fontShadow);
            }

            @Override
            public void init() {
                this.registerExtension("map", 0, 0);
                this.registerExtension("grp", 19, 1);
                this.registerExtension("zip", 19, 1);
                this.registerClass(GameInfo.class, 19, 2);
            }

            @Override
            public void handleDirectory(DirectoryEntry dir) {
                if (app.menu.gShowMenu) {
                    Sound.PlaySound(1, null, 8);
                }
                MenuUserContent.this.buildAddon(this, dir);
            }

            @Override
            public void handleFile(FileEntry fil) {
                GameInfo addon = Game.episodes.get(fil.getParent().getAbsolutePath());
                if (addon != null) {
                    if (!fil.getExtension().equals("map")) {
                        return;
                    }
                    LevelInfo map = (LevelInfo)MenuUserContent.this.originalMaps.get(fil.getName());
                    if (map != null) {
                        return;
                    }
                }
                if (fil.getExtension().equals("map")) {
                    this.addFile(fil, fil.getName());
                } else if (fil.getExtension().equals("grp") || fil.getExtension().equals("zip")) {
                    MenuUserContent.this.buildPackage(this, fil);
                }
            }

            @Override
            public void invoke(Object obj) {
                if (obj == null) {
                    return;
                }
                if (obj instanceof FileEntry) {
                    FileEntry fil = (FileEntry)obj;
                    if (fil.getExtension().equals("map")) {
                        MenuUserContent.this.launchMap(fil);
                    } else if (fil.getExtension().equals("grp") || fil.getExtension().equals("zip")) {
                        MenuUserContent.this.launchEpisode(Game.episodes.get(this.getFileName()));
                    }
                } else if (obj instanceof GameInfo) {
                    MenuUserContent.this.launchEpisode((GameInfo)obj);
                }
            }
        };
        this.list.topPal = 20;
        this.list.pathPal = 20;
        this.list.listPal = 4;
        this.addItem(this.list, true);
    }

    private void launchMap(FileEntry file) {
        if (file == null) {
            return;
        }
        if (this.mFromNetworkMenu()) {
            MenuNetwork network = (MenuNetwork)this.app.menu.mMenus[11];
            network.setMap(file);
            this.app.menu.mMenuBack();
            return;
        }
        MenuDifficulty next = (MenuDifficulty)this.app.menu.mMenus[4];
        next.setMap(file);
        this.app.menu.mOpen(next, -1);
    }

    private void launchEpisode(GameInfo game) {
        if (game == null) {
            return;
        }
        if (this.mFromNetworkMenu()) {
            MenuNetwork network = (MenuNetwork)this.app.menu.mMenus[11];
            network.setEpisode(game);
            this.app.menu.mMenuBack();
            return;
        }
        MenuNewAddon next = (MenuNewAddon)this.app.menu.mMenus[14];
        next.setEpisode(game);
        this.app.menu.mOpen(next, -1);
    }

    public void setShowMain(boolean show) {
        this.showmain = show;
        if (this.list.getDirectory() == BuildGdx.compat.getDirectory(Compat.Path.Game)) {
            this.list.refreshList();
        }
    }

    private CustomScript checkScript(DirectoryEntry dir, Group res, String script) {
        GroupResource gres;
        FileEntry fil;
        if (dir != null && (fil = dir.checkFile(script)) != null) {
            return new CustomScript(BuildGdx.compat.getBytes(fil));
        }
        if (res != null && (gres = res.open(script)) != null) {
            CustomScript scr = new CustomScript(gres.getBytes());
            gres.close();
            return scr;
        }
        return null;
    }

    private EpisodeInfo checkOfficialAddon(Group res) {
        if (res == null || !FileUtils.getFullName(res.name).equals("wt.grp") && !FileUtils.getFullName(res.name).equals("td.grp") && !FileUtils.getFullName(res.name).equals("wantdest.grp") && !FileUtils.getFullName(res.name).equals("twindrag.grp")) {
            return null;
        }
        EpisodeInfo inf = null;
        GroupResource gres = res.open("zfcin.anm");
        if (gres != null) {
            inf = this.officialAddons.get(CRC32.getChecksum(gres));
            gres.close();
        }
        return inf;
    }

    public GameInfo getAddon(String path, DirectoryEntry fromDir) {
        if ((path = FileUtils.getCorrectPath(path)) == null && fromDir != null) {
            path = fromDir.getRelativePath();
        }
        Group fromGroup = null;
        GameInfo addon = Game.episodes.get(path);
        if (addon == null) {
            EpisodeInfo inf = null;
            if (fromDir != null) {
                FileEntry fil = fromDir.checkFile("zfcin.anm");
                if (fil != null && (inf = this.officialAddons.get(CRC32.getChecksum(fil))) != null) {
                    addon = new GameInfo(inf.Title, fromDir, null, inf);
                    Game.episodes.put(path, addon);
                    Console.Print("Found official addon: " + inf.Title);
                    return addon;
                }
            } else {
                fromGroup = BuildGdx.cache.isGroup(path);
                inf = this.checkOfficialAddon(fromGroup);
                if (inf != null) {
                    addon = new GameInfo(inf.Title, fromGroup, null, inf);
                    Game.episodes.put(path, addon);
                    Console.Print("Found official addon: " + inf.Title);
                    return addon;
                }
            }
            if (fromDir == null && fromGroup == null) {
                return null;
            }
            CustomScript scr = null;
            List<Resource> list = fromDir != null ? fromDir.getList() : fromGroup.getList();
            for (Resource res : list) {
                if (!res.getFullName().endsWith("custom.txt")) continue;
                scr = this.checkScript(fromDir, fromGroup, res.getFullName());
            }
            EpisodeInfo[] NoNameEp = null;
            if (fromDir != null || scr == null) {
                boolean hasFirstEpisode = false;
                boolean hasSecondEpisode = false;
                if (fromDir != null) {
                    hasFirstEpisode = fromDir.checkFile("$bullet.map") != null;
                    hasSecondEpisode = fromDir.checkFile("$whirl.map") != null;
                } else {
                    hasFirstEpisode = fromGroup.contains("$bullet.map");
                    hasSecondEpisode = fromGroup.contains("$whirl.map");
                }
                if (hasFirstEpisode || hasSecondEpisode) {
                    int i;
                    NoNameEp = new EpisodeInfo[hasSecondEpisode ? 2 : 1];
                    int n = i = hasFirstEpisode ? 0 : 4;
                    while (i < 29 && (i <= 3 || hasSecondEpisode)) {
                        LevelInfo map;
                        int epnum;
                        int n2 = epnum = i < 4 ? 0 : 1;
                        if (NoNameEp[epnum] == null) {
                            NoNameEp[epnum] = new EpisodeInfo();
                            NoNameEp[epnum].Title = "Episode " + epnum;
                            NoNameEp[epnum].Description = "No description";
                        }
                        EpisodeInfo ep = NoNameEp[epnum];
                        LevelInfo levelInfo = map = epnum == 0 ? Game.pSharewareEp.gMapInfo[i] : Game.pOriginalEp.gMapInfo[i - 4];
                        if (map != null) {
                            String mapname = map.LevelName;
                            if (fromDir != null && fromDir.checkFile(mapname) != null || fromGroup != null && fromGroup.contains(mapname)) {
                                ep.gMapInfo[epnum == 0 ? i : i - 4] = new LevelInfo(map.LevelName, map.SongName, "Map" + (i + 1), map.BestTime, map.ParTime);
                                ++ep.nMaps;
                            }
                        }
                        ++i;
                    }
                }
            }
            if (scr != null || NoNameEp != null) {
                if (fromDir != null) {
                    if (NoNameEp == null) {
                        return null;
                    }
                    addon = new GameInfo(fromDir.getName(), fromDir, new EpisodeInfo[0]);
                } else {
                    addon = new GameInfo(FileUtils.getFullName(fromGroup.name), fromGroup, new EpisodeInfo[0]);
                }
                if (scr != null) {
                    scr.apply(addon);
                } else if (NoNameEp != null) {
                    addon.episode = NoNameEp;
                }
                Game.episodes.put(path, addon);
                Console.Println("Found addon: " + addon.Title + " ( " + (fromDir != null ? fromDir.getRelativePath() : fromGroup.name) + " )");
            }
        }
        if (fromGroup != null) {
            fromGroup.dispose();
        }
        return addon;
    }

    private void buildPackage(MenuFileBrowser blist, FileEntry file) {
        if (!this.showmain && file.getParent() == BuildGdx.compat.getDirectory(Compat.Path.Game) && file.getName().equals(Main.game.mainGrp)) {
            return;
        }
        String path = file.getPath();
        GameInfo addon = this.getAddon(path, null);
        if (addon != null) {
            blist.addFile(file, path);
        }
    }

    private void buildAddon(MenuFileBrowser blist, DirectoryEntry dir) {
        if (dir == BuildGdx.compat.getDirectory(Compat.Path.Game)) {
            return;
        }
        GameInfo addon = this.getAddon(null, dir);
        if (addon != null) {
            blist.addFile(addon, "Addon:" + addon.Title);
        }
    }

    public boolean mFromNetworkMenu() {
        return this.app.menu.getLastMenu() == this.app.menu.mMenus[11];
    }
}

