/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.RotatorStr;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Vator;

public class Rotator {
    public static final Animator DoRotator = new Animator(){

        @Override
        public boolean invoke(int spr) {
            return Rotator.DoRotator(spr) != 0;
        }
    };

    public static void ReverseRotator(short SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        RotatorStr r = u.rotator;
        if (u.Tics != 0) {
            u.Tics = 0;
            Rotator.SetRotatorActive(SpriteNum);
            return;
        }
        if (r.tgt == 0) {
            r.tgt = r.open_dest;
        } else if (r.tgt == r.open_dest) {
            r.tgt = 0;
        }
        r.vel = -r.vel;
    }

    public static boolean RotatorSwitch(short match, short setting) {
        boolean found = false;
        short i = Engine.headspritestat[0];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE sp = Engine.sprite[i];
            if (sp.lotag == 206 && sp.hitag == match) {
                found = true;
                Sector.AnimateSwitch(sp, setting);
            }
            i = nexti;
        }
        return found;
    }

    public static void SetRotatorActive(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        RotatorStr r = u.rotator;
        Sector.DoSoundSpotMatch(Gameutils.SP_TAG2(sp), 1, Sound.SoundType.SOUND_OBJECT_TYPE);
        u.Flags |= Gameutils.SPR_ACTIVE;
        u.Tics = 0;
        if (r.tgt == 0) {
            Vator.VatorSwitch(Gameutils.SP_TAG2(sp), 0);
        } else {
            Vator.VatorSwitch(Gameutils.SP_TAG2(sp), 1);
        }
    }

    public static void SetRotatorInactive(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        Sector.DoSoundSpotMatch(Gameutils.SP_TAG2(sp), 2, Sound.SoundType.SOUND_OBJECT_TYPE);
        u.Flags &= ~Gameutils.SPR_ACTIVE;
    }

    public static short DoRotatorOperate(PlayerStr pp, short sectnum) {
        short match = Engine.sector[sectnum].hitag;
        if (match > 0) {
            if (Rotator.TestRotatorMatchActive(match)) {
                return -1;
            }
            return Rotator.DoRotatorMatch(pp, match, true);
        }
        return -1;
    }

    public static short DoRotatorMatch(PlayerStr pp, int match, boolean manual) {
        short first_vator = -1;
        short i = Engine.headspritestat[71];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE fsp = Engine.sprite[i];
            if (Gameutils.SP_TAG1(fsp) == 143 && Gameutils.SP_TAG2(fsp) == match) {
                USER fu = Gameutils.pUser[i];
                if (Gameutils.TEST_BOOL4(fsp) && (Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_COMMBAT || Main.gNet.MultiGameType == WangNetwork.MultiGameTypes.MULTI_GAME_AI_BOTS)) {
                    if (pp != null && Gameutils.TEST_BOOL11(fsp)) {
                        Text.PutStringInfo(pp, "This only opens in single play.");
                    }
                } else if (Gameutils.SP_TAG3(fsp) != 1 || !manual) {
                    if (first_vator == -1) {
                        first_vator = i;
                    }
                    short sectnum = fsp.sectnum;
                    if (pp != null && Sector.SectUser[sectnum] != null && Sector.SectUser[sectnum].stag == 29 && Sector.SectUser[sectnum].number != 0) {
                        short key_num = Sector.SectUser[sectnum].number;
                        Text.PutStringInfo(pp, Text.KeyDoorMessage[key_num - 1]);
                        return -1;
                    }
                    if (MyTypes.TEST(fu.Flags, Gameutils.SPR_ACTIVE)) {
                        Rotator.ReverseRotator(i);
                    } else {
                        Rotator.SetRotatorActive(i);
                    }
                }
            }
            i = nexti;
        }
        return first_vator;
    }

    public static boolean TestRotatorMatchActive(int match) {
        short i = Engine.headspritestat[71];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            SPRITE fsp = Engine.sprite[i];
            if (Gameutils.SP_TAG1(fsp) == 143 && Gameutils.SP_TAG2(fsp) == match) {
                USER fu = Gameutils.pUser[i];
                if (!Gameutils.TEST_BOOL6(fsp) && (MyTypes.TEST(fu.Flags, Gameutils.SPR_ACTIVE) || fu.Tics != 0)) {
                    return true;
                }
            }
            i = nexti;
        }
        return false;
    }

    private static int DoRotatorMove(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        SPRITE pivot = null;
        boolean kill = false;
        RotatorStr r = u.rotator;
        if (r.pos < r.tgt) {
            r.pos += r.speed;
            r.speed += r.vel;
            if (r.pos > r.tgt) {
                r.pos = r.tgt;
            }
        }
        if (r.pos > r.tgt) {
            r.pos -= r.speed;
            r.speed += r.vel;
            if (r.pos < r.tgt) {
                r.pos = r.tgt;
            }
        }
        if (r.pos == r.tgt) {
            if (r.pos == r.open_dest) {
                r.tgt = 0;
                r.vel = -r.vel;
                Rotator.SetRotatorInactive(SpriteNum);
                if (Gameutils.SP_TAG6(sp) != 0) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
                if (u.WaitTics != 0) {
                    u.Tics = u.WaitTics;
                }
            } else if (r.pos == 0) {
                int match = Gameutils.SP_TAG2(sp);
                r.tgt = r.open_dest;
                r.speed = r.orig_speed;
                r.vel = Pragmas.klabs(r.vel);
                Rotator.SetRotatorInactive(SpriteNum);
                if (!Rotator.TestRotatorMatchActive(match)) {
                    // empty if block
                }
                if (Gameutils.SP_TAG6(sp) != 0 && Gameutils.TEST_BOOL5(sp)) {
                    Sector.DoMatchEverything(null, Gameutils.SP_TAG6(sp), -1);
                }
            }
            if (Gameutils.TEST_BOOL2(sp)) {
                kill = true;
            }
        }
        int closest = 99999;
        short i = Engine.headspritestat[72];
        while (i != -1) {
            int dist;
            short nexti = Engine.nextspritestat[i];
            if (Engine.sprite[i].lotag == sp.lotag && (dist = Game.Distance(sp.x, sp.y, Engine.sprite[i].x, Engine.sprite[i].y)) < closest) {
                closest = dist;
                pivot = Engine.sprite[i];
            }
            i = nexti;
        }
        if (pivot == null) {
            return 0;
        }
        short startwall = Engine.sector[sp.sectnum].wallptr;
        short endwall = (short)(startwall + Engine.sector[sp.sectnum].wallnum - 1);
        int ndx = 0;
        for (short w = startwall; w <= endwall; w = (short)(w + 1)) {
            Engine.Point p = Main.engine.rotatepoint(pivot.x, pivot.y, r.orig[ndx].x, r.orig[ndx].y, (short)r.pos);
            Main.engine.dragpoint(w, p.getX(), p.getY());
            ndx = (short)(ndx + 1);
        }
        if (kill) {
            Rotator.SetRotatorInactive(SpriteNum);
            Sprites.KillSprite(SpriteNum);
            return 0;
        }
        return 0;
    }

    public static int DoRotator(int SpriteNum) {
        Rotator.DoRotatorMove(SpriteNum);
        return 0;
    }
}

