/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Screens;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pattern.ScreenAdapters.MenuAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Wang.Factory.WangMenuHandler;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Text;

public class MenuScreen
extends MenuAdapter {
    private WangMenuHandler menu;

    public MenuScreen(Main game) {
        super(game, game.menu.mMenus[0]);
        this.menu = game.menu;
    }

    @Override
    public void show() {
        this.engine.setbrightness(Main.gs.brightness, Engine.palette, GLRenderer.GLInvalidateFlag.All);
        if (!this.menu.gShowMenu) {
            this.menu.mOpen(this.menu.mMenus[0], -1);
        }
        Sound.CDAudio_Play(2, true);
        Sound.COVER_SetReverb(0);
    }

    @Override
    public void process(float delta) {
        if (Mmulti.numplayers > 1 || Main.gNet.FakeMultiplayer) {
            Text.DrawFragBar();
        }
        if (!this.game.gPaused) {
            this.game.pNet.GetPackets();
        }
    }

    @Override
    public void draw(float delta) {
        this.engine.clearview(117);
        MenuScreen.DrawBackground(this.engine);
    }

    public static void DrawBackground(Engine engine) {
        int scale = Pragmas.divscale(Engine.ydim, 240L, 16);
        int width = Pragmas.mulscale(engine.getTile(9220).getWidth(), scale, 16);
        if (width != 0) {
            int framesnum = Engine.xdim / width;
            int fy = Pragmas.scale(20L, Engine.ydim, 240L);
            int statusx1 = Gameutils.coordsConvertXScaled(160 - engine.getTile(2324).getWidth() / 2, Gameutils.ConvertType.Normal);
            int statusx2 = Gameutils.coordsConvertXScaled(160 + engine.getTile(2324).getWidth() / 2, Gameutils.ConvertType.Normal);
            int x = 0;
            for (int i = 0; i <= framesnum; ++i) {
                if (x - width <= statusx1 || x + width >= statusx2) {
                    engine.rotatesprite(x << 16, fy << 16, scale, 0, 9220, 0, 0, 280, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                }
                x += width;
            }
        }
        engine.rotatesprite(Engine.xdim << 15, Engine.ydim << 15, scale, 0, 2324, 0, 0, 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }
}

