/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Ninja;
import ru.m210projects.Wang.Enemies.Ripper;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Game;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Morth;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Rooms;
import ru.m210projects.Wang.Sector;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Type.Anim;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.LONGp;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Sect_User;
import ru.m210projects.Wang.Type.Sector_Object;
import ru.m210projects.Wang.Type.TRACK;
import ru.m210projects.Wang.Type.TRACK_POINT;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Type.Vector2i;
import ru.m210projects.Wang.Type.Vector3i;
import ru.m210projects.Wang.Weapon;

public class Track {
    public static int GlobSpeedSO;
    public static final int ACTOR_STD_JUMP = -384;
    public static final int MAX_TRACKS = 100;
    public static TRACK[] Track;
    public static final int TOWARD_PLAYER = 1;
    public static final int AWAY_FROM_PLAYER = -1;
    public static short[] end_point;
    private static final short[] StatList;
    public static final int TRACK_POINT_SIZE = 200;
    private static int[] z;

    public static boolean TrackTowardPlayer(int sp, TRACK t, int start_point) {
        int start_dist;
        TRACK_POINT end_point = start_point == 0 ? t.TrackPoint[t.NumPoints - 1] : t.TrackPoint[0];
        int end_dist = Game.Distance(end_point.x, end_point.y, Engine.sprite[sp].x, Engine.sprite[sp].y);
        return end_dist < (start_dist = Game.Distance(t.TrackPoint[start_point].x, t.TrackPoint[start_point].y, Engine.sprite[sp].x, Engine.sprite[sp].y));
    }

    public static boolean TrackStartCloserThanEnd(int SpriteNum, TRACK t, int start_point) {
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        TRACK_POINT end_point = start_point == 0 ? t.TrackPoint[t.NumPoints - 1] : t.TrackPoint[0];
        long end_dist = Game.Distance(end_point.x, end_point.y, sp.x, sp.y);
        long start_dist = Game.Distance(t.TrackPoint[start_point].x, t.TrackPoint[start_point].y, sp.x, sp.y);
        return start_dist < end_dist;
    }

    public static int ActorFindTrack(short SpriteNum, int player_dir, int track_type, LONGp track_point_num, LONGp track_dir) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        int near_dist = 999999;
        short track_sect = 0;
        TRACK t = null;
        int near_track = -1;
        TRACK_POINT near_tp = null;
        for (int ti = 0; ti < 100; ++ti) {
            t = Track[ti];
            short tp = 0;
            if (!MyTypes.TEST(t.ttflags, track_type) || MyTypes.TEST(t.flags, Gameutils.TF_TRACK_OCCUPIED)) continue;
            switch (track_type) {
                case 256: {
                    if (u.ActorActionSet.Duck == null) {
                        return -1;
                    }
                    ru.m210projects.Wang.Track.end_point[1] = 0;
                    break;
                }
                case 32: {
                    if (u.ActorActionSet.Climb == null) {
                        return -1;
                    }
                    ru.m210projects.Wang.Track.end_point[1] = 0;
                    break;
                }
                case 4: 
                case 8: {
                    if (u.ActorActionSet.Jump == null) {
                        return -1;
                    }
                    ru.m210projects.Wang.Track.end_point[1] = 0;
                    break;
                }
                case 128: {
                    if (u.ActorActionSet.Crawl != null && u.ActorActionSet.Jump != null) break;
                    return -1;
                }
                default: {
                    ru.m210projects.Wang.Track.end_point[1] = (short)(t.NumPoints - 1);
                }
            }
            int zdiff = Gameutils.Z(16);
            for (int i = 0; i < 2; i = (int)((short)(i + 1))) {
                tp = end_point[i];
                int dist = Game.Distance(t.TrackPoint[tp].x, t.TrackPoint[tp].y, sp.x, sp.y);
                if (dist >= 15000 || dist >= near_dist || Pragmas.klabs(sp.z - t.TrackPoint[tp].z) > zdiff || (player_dir != 1 ? player_dir == -1 && ru.m210projects.Wang.Track.TrackTowardPlayer(u.tgt_sp, t, tp) : !ru.m210projects.Wang.Track.TrackTowardPlayer(u.tgt_sp, t, tp))) continue;
                if (!ru.m210projects.Wang.Track.TrackStartCloserThanEnd(SpriteNum, t, tp)) continue;
                near_dist = dist;
                near_track = ti;
                near_tp = t.TrackPoint[tp];
                track_point_num.value = end_point[i];
                track_dir.value = i != 0 ? -1 : 1;
            }
        }
        if (near_dist < 15000) {
            if ((track_sect = Rooms.COVERupdatesector(near_tp.x, near_tp.y, track_sect)) == -1) {
                return -1;
            }
            if (Rooms.FAFcansee(sp.x, sp.y, sp.z - Gameutils.Z(16), sp.sectnum, near_tp.x, near_tp.y, Engine.sector[track_sect].floorz - Gameutils.Z(32), track_sect)) {
                return near_track;
            }
            return -1;
        }
        return -1;
    }

    public static void NextTrackPoint(Sector_Object sop) {
        sop.point = (short)(sop.point + sop.dir);
        if (sop.point > ru.m210projects.Wang.Track.Track[sop.track].NumPoints - 1) {
            sop.point = 0;
        }
        if (sop.point < 0) {
            sop.point = (short)(ru.m210projects.Wang.Track.Track[sop.track].NumPoints - 1);
        }
    }

    public static void NextActorTrackPoint(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        u.point = (short)(u.point + u.track_dir);
        if (u.point > ru.m210projects.Wang.Track.Track[u.track].NumPoints - 1) {
            u.point = 0;
        }
        if (u.point < 0) {
            u.point = (short)(ru.m210projects.Wang.Track.Track[u.track].NumPoints - 1);
        }
    }

    public static void TrackAddPoint(TRACK t, TRACK_POINT[] tp, int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        if (tp[t.NumPoints] == null) {
            tp[t.NumPoints] = new TRACK_POINT();
        }
        TRACK_POINT tpoint = tp[t.NumPoints];
        tpoint.x = sp.x;
        tpoint.y = sp.y;
        tpoint.z = sp.z;
        tpoint.ang = sp.ang;
        tpoint.tag_low = sp.lotag;
        tpoint.tag_high = sp.hitag;
        t.NumPoints = (short)(t.NumPoints + 1);
        Sprites.KillSprite(SpriteNum);
    }

    public static int TrackClonePoint(int SpriteNum) {
        SPRITE sp = Engine.sprite[SpriteNum];
        short newsp = Rooms.COVERinsertsprite(sp.sectnum, sp.statnum);
        SPRITE np = Engine.sprite[newsp];
        np.extra = 0;
        np.cstat = 0;
        np.x = sp.x;
        np.y = sp.y;
        np.z = sp.z;
        np.ang = sp.ang;
        np.lotag = sp.lotag;
        np.hitag = sp.hitag;
        return newsp;
    }

    public static void QuickJumpSetup(int stat, int lotag, int type) {
        short SpriteNum = 0;
        SpriteNum = Engine.headspritestat[stat];
        while (SpriteNum != -1) {
            int ndx;
            short NextSprite = Engine.nextspritestat[SpriteNum];
            for (ndx = 0; ndx < 100 && ru.m210projects.Wang.Track.Track[ndx].NumPoints != 0; ndx = (int)((short)(ndx + 1))) {
            }
            ru.m210projects.Wang.Track.Track[ndx].TrackPoint = new TRACK_POINT[4];
            TRACK_POINT[] tp = ru.m210projects.Wang.Track.Track[ndx].TrackPoint;
            TRACK t = Track[ndx];
            t.ttflags |= MyTypes.BIT(type);
            t.flags = 0;
            int end_sprite = ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            int start_sprite = ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            SPRITE nsp = Engine.sprite[start_sprite];
            nsp.lotag = (short)700;
            nsp.hitag = 0;
            ru.m210projects.Wang.Track.TrackAddPoint(t, tp, start_sprite);
            nsp = Engine.sprite[SpriteNum];
            nsp.x += 64 * Engine.sintable[Gameutils.NORM_ANGLE(nsp.ang + 512)] >> 14;
            nsp.y += 64 * Engine.sintable[nsp.ang] >> 14;
            nsp.lotag = (short)lotag;
            ru.m210projects.Wang.Track.TrackAddPoint(t, tp, SpriteNum);
            nsp = Engine.sprite[end_sprite];
            nsp.x += 2048 * Engine.sintable[Gameutils.NORM_ANGLE(nsp.ang + 512)] >> 14;
            nsp.y += 2048 * Engine.sintable[nsp.ang] >> 14;
            nsp.lotag = (short)701;
            nsp.hitag = 0;
            ru.m210projects.Wang.Track.TrackAddPoint(t, tp, end_sprite);
            SpriteNum = NextSprite;
        }
    }

    public static void QuickScanSetup(int stat, int lotag, int type) {
        short SpriteNum = 0;
        SpriteNum = Engine.headspritestat[stat];
        while (SpriteNum != -1) {
            int ndx;
            short NextSprite = Engine.nextspritestat[SpriteNum];
            for (ndx = 0; ndx < 100 && ru.m210projects.Wang.Track.Track[ndx].NumPoints != 0; ndx = (int)((short)(ndx + 1))) {
            }
            ru.m210projects.Wang.Track.Track[ndx].TrackPoint = new TRACK_POINT[4];
            TRACK_POINT[] tp = ru.m210projects.Wang.Track.Track[ndx].TrackPoint;
            TRACK t = Track[ndx];
            t.ttflags |= MyTypes.BIT(type);
            t.flags = 0;
            short end_sprite = (short)ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            short start_sprite = (short)ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            SPRITE nsp = Engine.sprite[start_sprite];
            nsp.lotag = (short)700;
            nsp.hitag = 0;
            nsp.x += 64 * Engine.sintable[Gameutils.NORM_ANGLE(nsp.ang + 1024 + 512)] >> 14;
            nsp.y += 64 * Engine.sintable[Gameutils.NORM_ANGLE(nsp.ang + 1024)] >> 14;
            ru.m210projects.Wang.Track.TrackAddPoint(t, tp, start_sprite);
            nsp = Engine.sprite[SpriteNum];
            nsp.lotag = (short)lotag;
            ru.m210projects.Wang.Track.TrackAddPoint(t, tp, SpriteNum);
            nsp = Engine.sprite[end_sprite];
            nsp.x += 64 * Engine.sintable[Gameutils.NORM_ANGLE(nsp.ang + 512)] >> 14;
            nsp.y += 64 * Engine.sintable[nsp.ang] >> 14;
            nsp.lotag = (short)701;
            nsp.hitag = 0;
            ru.m210projects.Wang.Track.TrackAddPoint(t, tp, end_sprite);
            SpriteNum = NextSprite;
        }
    }

    public static void QuickExitSetup(int stat, int type) {
        short SpriteNum = 0;
        SpriteNum = Engine.headspritestat[stat];
        while (SpriteNum != -1) {
            int ndx;
            short NextSprite = Engine.nextspritestat[SpriteNum];
            for (ndx = 0; ndx < 100 && ru.m210projects.Wang.Track.Track[ndx].NumPoints != 0; ndx = (int)((short)(ndx + 1))) {
            }
            ru.m210projects.Wang.Track.Track[ndx].TrackPoint = new TRACK_POINT[4];
            TRACK_POINT[] tp = ru.m210projects.Wang.Track.Track[ndx].TrackPoint;
            TRACK t = Track[ndx];
            t.ttflags |= MyTypes.BIT(type);
            t.flags = 0;
            short end_sprite = (short)ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            short start_sprite = (short)ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            SPRITE nsp = Engine.sprite[start_sprite];
            nsp.lotag = (short)700;
            nsp.hitag = 0;
            ru.m210projects.Wang.Track.TrackAddPoint(t, tp, start_sprite);
            Sprites.KillSprite(SpriteNum);
            nsp = Engine.sprite[end_sprite];
            nsp.x += 1024 * Engine.sintable[Gameutils.NORM_ANGLE(nsp.ang + 512)] >> 14;
            nsp.y += 1024 * Engine.sintable[nsp.ang] >> 14;
            nsp.lotag = (short)701;
            nsp.hitag = 0;
            ru.m210projects.Wang.Track.TrackAddPoint(t, tp, end_sprite);
            SpriteNum = NextSprite;
        }
    }

    public static void QuickLadderSetup(int stat, int lotag, int type) {
        short SpriteNum = 0;
        SpriteNum = Engine.headspritestat[stat];
        while (SpriteNum != -1) {
            int ndx;
            short NextSprite = Engine.nextspritestat[SpriteNum];
            for (ndx = 0; ndx < 100 && ru.m210projects.Wang.Track.Track[ndx].NumPoints != 0; ndx = (int)((short)(ndx + 1))) {
            }
            ru.m210projects.Wang.Track.Track[ndx].TrackPoint = new TRACK_POINT[4];
            TRACK_POINT[] tp = ru.m210projects.Wang.Track.Track[ndx].TrackPoint;
            TRACK t = Track[ndx];
            t.ttflags |= MyTypes.BIT(type);
            t.flags = 0;
            short end_sprite = (short)ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            short start_sprite = (short)ru.m210projects.Wang.Track.TrackClonePoint(SpriteNum);
            SPRITE nsp = Engine.sprite[start_sprite];
            nsp.lotag = (short)700;
            nsp.hitag = 0;
            nsp.x += Gameutils.MOVEx(256, nsp.ang + 1024);
            nsp.y += Gameutils.MOVEy(256, nsp.ang + 1024);
            ru.m210projects.Wang.Track.TrackAddPoint(t, tp, start_sprite);
            nsp = Engine.sprite[SpriteNum];
            nsp.lotag = (short)lotag;
            ru.m210projects.Wang.Track.TrackAddPoint(t, tp, SpriteNum);
            nsp = Engine.sprite[end_sprite];
            nsp.x += Gameutils.MOVEx(512, nsp.ang);
            nsp.y += Gameutils.MOVEy(512, nsp.ang);
            nsp.lotag = (short)701;
            nsp.hitag = 0;
            ru.m210projects.Wang.Track.TrackAddPoint(t, tp, end_sprite);
            SpriteNum = NextSprite;
        }
    }

    public static void TrackSetup() {
        int SpriteNum = 0;
        for (int ndx = 0; ndx < 100; ndx = (int)((short)(ndx + 1))) {
            int NextSprite;
            if (Engine.headspritestat[200 + ndx] == -1) {
                if (Track[ndx] == null) {
                    ru.m210projects.Wang.Track.Track[ndx] = new TRACK();
                } else {
                    Track[ndx].reset();
                }
                ru.m210projects.Wang.Track.Track[ndx].TrackPoint = new TRACK_POINT[1];
                continue;
            }
            if (Track[ndx] == null) {
                ru.m210projects.Wang.Track.Track[ndx] = new TRACK();
            } else {
                Track[ndx].reset();
            }
            ru.m210projects.Wang.Track.Track[ndx].TrackPoint = new TRACK_POINT[500];
            TRACK_POINT[] tp = ru.m210projects.Wang.Track.Track[ndx].TrackPoint;
            TRACK t = Track[ndx];
            SpriteNum = Engine.headspritestat[200 + ndx];
            while (SpriteNum != -1) {
                NextSprite = Engine.nextspritestat[SpriteNum];
                if (Gameutils.LOW_TAG_SPRITE(SpriteNum) == 700) {
                    ru.m210projects.Wang.Track.TrackAddPoint(t, tp, SpriteNum);
                    break;
                }
                SpriteNum = NextSprite;
            }
            if (t.NumPoints <= 0) continue;
            if (tp[0].tag_low == 700 && tp[0].tag_high != 0) {
                t.ttflags |= MyTypes.BIT(tp[0].tag_high);
            }
            while (Engine.headspritestat[200 + ndx] != -1) {
                int next_sprite = -1;
                int low_dist = 999999;
                SpriteNum = Engine.headspritestat[200 + ndx];
                while (SpriteNum != -1) {
                    NextSprite = Engine.nextspritestat[SpriteNum];
                    int dist = Game.Distance(tp[t.NumPoints - 1].x, tp[t.NumPoints - 1].y, Engine.sprite[SpriteNum].x, Engine.sprite[SpriteNum].y);
                    if (dist < low_dist) {
                        next_sprite = SpriteNum;
                        low_dist = dist;
                    }
                    SpriteNum = NextSprite;
                }
                if (next_sprite == -1) continue;
                ru.m210projects.Wang.Track.TrackAddPoint(t, tp, next_sprite);
            }
            int size = ru.m210projects.Wang.Track.Track[ndx].NumPoints + 1;
            TRACK_POINT[] newp = new TRACK_POINT[size];
            for (int i = 0; i < ru.m210projects.Wang.Track.Track[ndx].NumPoints; ++i) {
                newp[i] = ru.m210projects.Wang.Track.Track[ndx].TrackPoint[i];
            }
            ru.m210projects.Wang.Track.Track[ndx].TrackPoint = newp;
        }
        ru.m210projects.Wang.Track.QuickJumpSetup(501, 801, 2);
        ru.m210projects.Wang.Track.QuickJumpSetup(502, 802, 3);
        ru.m210projects.Wang.Track.QuickJumpSetup(503, 803, 13);
        ru.m210projects.Wang.Track.QuickScanSetup(504, 804, 12);
        ru.m210projects.Wang.Track.QuickLadderSetup(506, 792, 5);
        ru.m210projects.Wang.Track.QuickExitSetup(505, 10);
        ru.m210projects.Wang.Track.QuickJumpSetup(507, 807, 14);
        ru.m210projects.Wang.Track.QuickJumpSetup(508, 808, 8);
        ru.m210projects.Wang.Track.QuickJumpSetup(509, 809, 9);
    }

    public static int FindBoundSprite(int tag) {
        short sn = Engine.headspritestat[500];
        while (sn != -1) {
            short next_sn = Engine.nextspritestat[sn];
            if (Engine.sprite[sn].hitag == tag) {
                return sn;
            }
            sn = next_sn;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean SectorObjectSetupBounds(int sopi) {
        FoundOutsideLoop = false;
        sop = Sprites.SectorObject[sopi];
        u = Gameutils.pUser[sop.sp_child];
        BoundSpritei = ru.m210projects.Wang.Track.FindBoundSprite(500 + sopi * 5);
        if (BoundSpritei == -1) {
            return false;
        }
        BoundSprite = Engine.sprite[BoundSpritei];
        xlow = BoundSprite.x;
        ylow = BoundSprite.y;
        Sprites.KillSprite(BoundSpritei);
        BoundSpritei = ru.m210projects.Wang.Track.FindBoundSprite(501 + sopi * 5);
        BoundSprite = Engine.sprite[BoundSpritei];
        xhigh = BoundSprite.x;
        yhigh = BoundSprite.y;
        Sprites.KillSprite(BoundSpritei);
        u.Radius = MyTypes.DIV4(xhigh - xlow + (yhigh - ylow));
        u.Radius -= MyTypes.DIV4(u.Radius);
        BoundSpritei = ru.m210projects.Wang.Track.FindBoundSprite(27);
        if (BoundSpritei != -1) {
            BoundSprite = Engine.sprite[BoundSpritei];
            sop.xmid = BoundSprite.x;
            sop.ymid = BoundSprite.y;
            sop.zmid = BoundSprite.z;
            Sprites.KillSprite(BoundSpritei);
        }
        for (k = 0; k < Engine.numsectors; ++k) {
            startwall = Engine.sector[k].wallptr;
            endwall = startwall + Engine.sector[k].wallnum - 1;
            SectorInBounds = true;
            for (j = (int)startwall; j <= endwall; ++j) {
                if (Engine.wall[j].x > xlow && Engine.wall[j].x < xhigh && Engine.wall[j].y > ylow && Engine.wall[j].y < yhigh) continue;
                SectorInBounds = false;
                break;
            }
            if (!SectorInBounds) continue;
            sop.sector[sop.num_sectors] = (short)k;
            Engine.sector[k].extra = (short)(Engine.sector[k].extra | Gameutils.SECTFX_SECTOR_OBJECT);
            sop.zorig_floor[sop.num_sectors] = Engine.sector[k].floorz;
            sop.zorig_ceiling[sop.num_sectors] = Engine.sector[k].ceilingz;
            if (MyTypes.TEST(Engine.sector[k].extra, Gameutils.SECTFX_SINK)) {
                v0 = sop.num_sectors;
                sop.zorig_floor[v0] = sop.zorig_floor[v0] + Gameutils.Z(Sector.SectUser[k].depth);
            }
            if (Engine.sector[k].floorz > sop.floor_loz) {
                sop.floor_loz = Engine.sector[k].floorz;
            }
            if (Engine.sector[k].floorz < sop.floor_hiz) {
                sop.floor_hiz = Engine.sector[k].floorz;
            }
            sop.num_sectors = (short)(sop.num_sectors + 1);
        }
        FoundOutsideLoop = false;
        j = 0;
        while (sop.sector[j] != -1) {
            sectp = Engine.sector[sop.sector[j]];
            startwall = sectp.wallptr;
            endwall = (short)(startwall + sectp.wallnum - 1);
            for (k = (int)startwall; k <= endwall; ++k) {
                if (Engine.wall[k].lotag == 550) {
                    sop.morph_wall_point = (short)k;
                }
                if (Engine.wall[k].extra != 0 && MyTypes.TEST(Engine.wall[k].extra, Gameutils.WALLFX_LOOP_OUTER)) {
                    FoundOutsideLoop = true;
                }
                Engine.wall[k].extra = (short)(Engine.wall[k].extra | (Gameutils.WALLFX_SECTOR_OBJECT | Gameutils.WALLFX_DONT_STICK));
                if (Engine.wall[k].nextwall < 0) continue;
                Engine.wall[Engine.wall[k].nextwall].extra = (short)(Engine.wall[Engine.wall[k].nextwall].extra | (Gameutils.WALLFX_SECTOR_OBJECT | Gameutils.WALLFX_DONT_STICK));
            }
            ++j;
        }
        if (!FoundOutsideLoop) {
            Main.game.GameCrash("Forgot to tag outer loop for Sector Object #" + sopi);
            return false;
        }
        for (i = 0; i < ru.m210projects.Wang.Track.StatList.length; ++i) {
            sp_num = Engine.headspritestat[ru.m210projects.Wang.Track.StatList[i]];
            while (sp_num != -1) {
                block28: {
                    next_sp_num = Engine.nextspritestat[sp_num];
                    sp = Engine.sprite[sp_num];
                    if (sp.x <= xlow || sp.x >= xhigh || sp.y <= ylow || sp.y >= yhigh || sp.statnum == 81 && !Gameutils.TEST_BOOL2(sp)) break block28;
                    u = Gameutils.pUser[sp_num] == null ? Sprites.SpawnUser(sp_num, 0, null) : Gameutils.pUser[sp_num];
                    u.RotNum = 0;
                    u.ox = sp.x;
                    u.oy = sp.y;
                    u.oz = sp.z;
                    block0 : switch (sp.statnum) {
                        case 78: {
                            ** GOTO lbl99
                        }
                        case 0: {
                            switch (sp.hitag) {
                                case 78: {
                                    sop.clipdist = 0;
                                    sop.clipbox_dist[sop.clipbox_num] = sp.lotag;
                                    sop.clipbox_xoff[sop.clipbox_num] = (short)(sop.xmid - sp.x);
                                    sop.clipbox_yoff[sop.clipbox_num] = (short)(sop.ymid - sp.y);
                                    sop.clipbox_vdist[sop.clipbox_num] = (short)Main.engine.ksqrt(Gameutils.SQ(sop.xmid - sp.x) + Gameutils.SQ(sop.ymid - sp.y));
                                    ang2 = Main.engine.getangle(sp.x - sop.xmid, sp.y - sop.ymid);
                                    sop.clipbox_ang[sop.clipbox_num] = Player.GetDeltaAngle(sop.ang, ang2);
                                    sop.clipbox_num = (short)(sop.clipbox_num + 1);
                                    Sprites.KillSprite(sp_num);
                                    break block0;
                                }
                                case 62: {
                                    sp.owner = (short)-1;
                                    Sprites.change_sprite_stat(sp_num, 55);
                                    sp.cstat = (short)(sp.cstat & ~(Gameutils.CSTAT_SPRITE_BLOCK | Gameutils.CSTAT_SPRITE_BLOCK_HITSCAN));
                                    break;
                                }
                            }
                        }
lbl99:
                        // 4 sources

                        default: {
                            u.sx = sop.xmid - sp.x;
                            u.sy = sop.ymid - sp.y;
                            u.sz = Engine.sector[sop.mid_sector].floorz - sp.z;
                            u.Flags |= Gameutils.SPR_SO_ATTACHED;
                            u.sang = sp.ang;
                            u.spal = (byte)sp.pal;
                            for (sn = 0; sn < sop.sp_num.length && sop.sp_num[sn] != -1; sn = (int)((short)(sn + 1))) {
                            }
                            sop.sp_num[sn] = sp_num;
                            if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ)) break;
                            for (j = 0; j < sop.num_sectors; ++j) {
                                if (sop.sector[j] != sp.sectnum) continue;
                                u.Flags |= Gameutils.SPR_ON_SO_SECTOR;
                                u.sz = Engine.sector[sp.sectnum].floorz - sp.z;
                                break block0;
                            }
                        }
                    }
                }
                sp_num = next_sp_num;
            }
        }
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ)) {
            zmid = -9999999;
            i = 0;
            while (sop.sp_num[i] != -1) {
                sp = Engine.sprite[sop.sp_num[i]];
                u = Gameutils.pUser[sop.sp_num[i]];
                if (sp.z > zmid) {
                    zmid = sp.z;
                }
                ++i;
            }
            sop.zmid = zmid;
            i = 0;
            while (sop.sp_num[i] != -1) {
                sp = Engine.sprite[sop.sp_num[i]];
                u = Gameutils.pUser[sop.sp_num[i]];
                u.sz = sop.zmid - sp.z;
                ++i;
            }
        }
        return true;
    }

    public static boolean SetupSectorObject(int sectnum, int tag) {
        short object_num = (short)((tag -= 500) / 5);
        Sector_Object sop = Sprites.SectorObject[object_num];
        if (sop.num_sectors == -1) {
            Arrays.fill(sop.sector, (short)-1);
            sop.crush_z = 0;
            sop.drive_angspeed = 0;
            sop.drive_angslide = 0;
            sop.drive_slide = 0;
            sop.drive_speed = 0;
            sop.num_sectors = 0;
            sop.update = 15000;
            sop.flags = 0;
            sop.clipbox_num = 0;
            sop.bob_amt = 0;
            sop.vel_rate = (short)6;
            sop.z_rate = 256;
            sop.z_tgt = 0;
            sop.zdelta = 0;
            sop.wait_tics = 0;
            sop.spin_speed = 0;
            sop.spin_ang = 0;
            sop.ang_orig = 0;
            sop.clipdist = (short)1024;
            sop.target_dist = 0;
            sop.turn_speed = (short)4;
            sop.floor_loz = -9999999;
            sop.floor_hiz = 9999999;
            sop.player_yoff = 0;
            sop.player_xoff = 0;
            sop.ang_moving = 0;
            sop.ang = 0;
            sop.ang_tgt = 0;
            sop.op_main_sector = (short)-1;
            sop.ram_damage = 0;
            sop.max_damage = (short)-9999;
            sop.scale_type = 0;
            sop.scale_dist = 0;
            sop.scale_speed = (short)20;
            sop.scale_dist_min = (short)-1024;
            sop.scale_dist_max = (short)1024;
            sop.scale_rand_freq = (short)8;
            sop.scale_x_mult = (short)256;
            sop.scale_y_mult = (short)256;
            sop.morph_ang = (short)Gameutils.RANDOM_P2(2048);
            sop.morph_z_speed = (short)20;
            sop.morph_speed = (short)32;
            sop.morph_dist_max = (short)1024;
            sop.morph_rand_freq = (short)64;
            sop.morph_dist = 0;
            sop.morph_xoff = 0;
            sop.morph_yoff = 0;
            sop.PreMoveAnimator = null;
            sop.PostMoveAnimator = null;
            sop.Animator = null;
        }
        switch (tag % 5) {
            case 1: {
                sop.mid_sector = (short)sectnum;
                Vector3i p = Sector.SectorMidPoint(sectnum);
                sop.xmid = p.x;
                sop.ymid = p.y;
                sop.zmid = p.z;
                sop.dir = 1;
                sop.track = (short)Gameutils.HIGH_TAG(sectnum);
                short new1 = (short)Sprites.SpawnSprite(61, 0, null, sectnum, sop.xmid, sop.ymid, sop.zmid, 0, 0);
                sop.sp_child = new1;
                USER u = Gameutils.pUser[new1];
                u.sop_parent = object_num;
                u.Flags2 |= Gameutils.SPR2_SPRITE_FAKE_BLOCK;
                short SpriteNum = Engine.headspritesect[sectnum];
                while (SpriteNum != -1) {
                    short NextSprite = Engine.nextspritesect[SpriteNum];
                    SPRITE sp = Engine.sprite[SpriteNum];
                    if (sp.statnum == 500) {
                        switch (sp.hitag) {
                            case 102: {
                                if (Gameutils.SP_TAG5(sp) != 0) {
                                    sop.scale_x_mult = (short)Gameutils.SP_TAG5(sp);
                                }
                                if (Gameutils.SP_TAG6(sp) != 0) {
                                    sop.scale_y_mult = (short)Gameutils.SP_TAG6(sp);
                                }
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 101: {
                                int j;
                                Arrays.fill(sop.scale_point_dist, (short)0);
                                sop.scale_point_base_speed = (short)Gameutils.SP_TAG2(sp);
                                for (j = 0; j < sop.scale_point_speed.length; j = (int)((short)(j + 1))) {
                                    sop.scale_point_speed[j] = (short)Gameutils.SP_TAG2(sp);
                                }
                                sop.scale_point_rand_freq = Gameutils.SP_TAG4(sp) != 0 ? (short)Gameutils.SP_TAG4(sp) : (short)64;
                                sop.scale_point_dist_min = (short)(-Gameutils.SP_TAG5(sp));
                                sop.scale_point_dist_max = (short)Gameutils.SP_TAG6(sp);
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 100: {
                                sop.flags |= Gameutils.SOBJ_DYNAMIC;
                                sop.scale_speed = (short)Gameutils.SP_TAG2(sp);
                                sop.scale_dist_min = (short)(-Gameutils.SP_TAG5(sp));
                                sop.scale_dist_max = (short)Gameutils.SP_TAG6(sp);
                                sop.scale_type = (short)Gameutils.SP_TAG4(sp);
                                sop.scale_active_type = (short)Gameutils.SP_TAG7(sp);
                                sop.scale_rand_freq = Gameutils.SP_TAG8(sp) != 0 ? (short)Gameutils.SP_TAG8(sp) : (short)8;
                                if (Gameutils.SP_TAG3(sp) == 0) {
                                    sop.scale_dist = sop.scale_dist_min;
                                } else if (Gameutils.SP_TAG3(sp) == 1) {
                                    sop.scale_dist = sop.scale_dist_max;
                                }
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 69: {
                                if (sp.clipdist != 3) break;
                                Sprites.change_sprite_stat(SpriteNum, 41);
                                u = Sprites.SpawnUser(SpriteNum, 0, null);
                                u.ActorActionFunc = null;
                                break;
                            }
                            case 81: {
                                sop.Animator = Sector_Object.SOAnimator.DoAutoTurretObject;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 73: {
                                sop.vel = 120;
                                sop.flags |= Gameutils.SOBJ_DYNAMIC;
                                sop.scale_type = (short)4;
                                sop.spin_speed = (short)16;
                                sop.last_ang = sop.ang;
                                sop.Animator = Sector_Object.SOAnimator.DoTornadoObject;
                                sop.PreMoveAnimator = Sector_Object.SOAnimator.ScaleSectorObject;
                                sop.PostMoveAnimator = Sector_Object.SOAnimator.MorphTornado;
                                sop.clipdist = (short)2500;
                                sop.morph_speed = (short)16;
                                sop.morph_z_speed = (short)6;
                                sop.morph_dist_max = (short)1024;
                                sop.morph_rand_freq = (short)8;
                                sop.scale_dist_min = (short)-768;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 74: {
                                sop.flags |= Gameutils.SOBJ_DYNAMIC;
                                sop.scale_type = 0;
                                sop.morph_speed = (short)120;
                                sop.morph_z_speed = (short)7;
                                sop.PostMoveAnimator = Sector_Object.SOAnimator.MorphFloor;
                                sop.morph_dist_max = (short)4000;
                                sop.morph_rand_freq = (short)8;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 75: {
                                int j;
                                sop.flags |= Gameutils.SOBJ_DYNAMIC;
                                sop.scale_type = (short)5;
                                sop.PreMoveAnimator = Sector_Object.SOAnimator.ScaleSectorObject;
                                Arrays.fill(sop.scale_point_dist, (short)0);
                                sop.scale_point_base_speed = (short)Sector.SCALE_POINT_SPEED;
                                for (j = 0; j < sop.scale_point_speed.length; j = (int)((short)(j + 1))) {
                                    sop.scale_point_speed[j] = (short)Sector.SCALE_POINT_SPEED;
                                }
                                sop.scale_point_dist_min = (short)-256;
                                sop.scale_point_dist_max = (short)256;
                                sop.scale_point_rand_freq = (short)32;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 76: {
                                u.MaxHealth = (short)Gameutils.SP_TAG2(sp);
                                sop.max_damage = Gameutils.SP_TAG5(sp) != 0 ? (short)Gameutils.SP_TAG5(sp) : u.MaxHealth;
                                switch (sp.clipdist) {
                                    case 0: {
                                        break;
                                    }
                                    case 1: {
                                        sop.flags |= Gameutils.SOBJ_DIE_HARD;
                                    }
                                }
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 147: {
                                sop.drive_angspeed = Gameutils.SP_TAG2(sp);
                                sop.drive_angspeed <<= 5;
                                sop.drive_angslide = Gameutils.SP_TAG3(sp);
                                if (sop.drive_angslide <= 0 || sop.drive_angslide == 32) {
                                    sop.drive_angslide = 1;
                                }
                                sop.drive_speed = Gameutils.SP_TAG6(sp);
                                sop.drive_speed <<= 5;
                                sop.drive_slide = Gameutils.SP_TAG7(sp);
                                if (sop.drive_slide <= 0) {
                                    sop.drive_slide = 1;
                                }
                                if (Gameutils.TEST_BOOL1(sp)) {
                                    sop.flags |= Gameutils.SOBJ_NO_QUAKE;
                                }
                                if (Gameutils.TEST_BOOL3(sp)) {
                                    sop.flags |= Gameutils.SOBJ_REMOTE_ONLY;
                                }
                                if (!Gameutils.TEST_BOOL4(sp)) break;
                                sop.crush_z = sp.z;
                                sop.flags |= Gameutils.SOBJ_RECT_CLIP;
                                break;
                            }
                            case 77: {
                                sop.ram_damage = sp.lotag;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 39: {
                                sop.clipdist = sp.lotag;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 31: {
                                sop.flags |= Gameutils.SOBJ_SPRITE_OBJ;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 45: {
                                sop.flags |= Gameutils.SOBJ_DONT_ROTATE;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 68: {
                                sop.limit_ang_center = sp.ang;
                                sop.limit_ang_delta = sp.lotag;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 70: {
                                sop.match_event = sp.lotag;
                                sop.match_event_sprite = SpriteNum;
                                break;
                            }
                            case 49: {
                                sop.vel_tgt = sop.vel = sp.lotag * 256;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 50: {
                                if (sop.spin_speed != 0) break;
                                sop.spin_speed = sp.lotag;
                                sop.last_ang = sop.ang;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 16: {
                                sop.last_ang = sop.ang_orig = (sop.ang = (sop.ang_moving = sp.ang));
                                sop.spin_ang = 0;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 51: {
                                sop.spin_speed = sp.lotag;
                                sop.last_ang = sop.ang;
                                if (sop.spin_speed >= 0) {
                                    sop.spin_speed = -sop.spin_speed;
                                }
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 52: {
                                sop.bob_amt = Gameutils.Z(sp.lotag);
                                sop.bob_sine_ndx = 0;
                                sop.bob_speed = (short)4;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 55: {
                                sop.turn_speed = sp.lotag;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 64: {
                                sop.flags |= Gameutils.SOBJ_SYNC1;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 65: {
                                sop.flags |= Gameutils.SOBJ_SYNC2;
                                Sprites.KillSprite(SpriteNum);
                                break;
                            }
                            case 80: {
                                sop.flags |= Gameutils.SOBJ_KILLABLE;
                                Sprites.KillSprite(SpriteNum);
                            }
                        }
                    }
                    SpriteNum = NextSprite;
                }
                if (sop.vel == -1) {
                    sop.vel_tgt = 2048;
                    sop.vel = 2048;
                }
                if (!ru.m210projects.Wang.Track.SectorObjectSetupBounds(object_num)) {
                    return false;
                }
                if (sop.track >= 90) {
                    switch (sop.track) {
                        case 96: 
                        case 97: 
                        case 98: {
                            sop.vel = 0;
                            sop.flags |= Gameutils.SOBJ_OPERATIONAL;
                            break;
                        }
                        case 99: {
                            sop.vel = 0;
                            sop.bob_amt = Gameutils.Z(2);
                            sop.bob_speed = (short)4;
                            sop.flags |= Gameutils.SOBJ_OPERATIONAL;
                            break;
                        }
                        default: {
                            sop.flags |= Gameutils.SOBJ_OPERATIONAL;
                        }
                    }
                }
                Engine.sector[sectnum].lotag = 0;
                Engine.sector[sectnum].hitag = 0;
                if (sop.max_damage > 0) break;
                ru.m210projects.Wang.Track.VehicleSetSmoke(sop, Weapon.SpawnVehicleSmoke);
            }
        }
        return true;
    }

    public static void PostSetupSectorObject() {
        for (int s = 0; s < 25; ++s) {
            Sector_Object sop = Sprites.SectorObject[s];
            if (sop.xmid == Integer.MAX_VALUE) continue;
            Player.FindMainSector(s);
        }
    }

    public static int PlayerOnObject(int sectnum_match) {
        for (int i = 0; i < 25; i = (int)((short)(i + 1))) {
            Sector_Object sop = Sprites.SectorObject[i];
            if (sop.track < 90) continue;
            for (short j = 0; j < sop.num_sectors; j = (short)(j + 1)) {
                if (sop.sector[j] != sectnum_match || !MyTypes.TEST(Engine.sector[sectnum_match].extra, Gameutils.SECTFX_OPERATIONAL)) continue;
                return i;
            }
        }
        return -1;
    }

    public static void PlaceSectorObjectsOnTracks() {
        for (int i = 0; i < 25; i = (int)((short)(i + 1))) {
            int low_dist = 999999;
            Sector_Object sop = Sprites.SectorObject[i];
            TRACK_POINT[] tpoint = null;
            if (sop.xmid == Integer.MAX_VALUE) continue;
            sop.num_walls = 0;
            short j = 0;
            while (sop.sector[j] != -1) {
                short startwall = Engine.sector[sop.sector[j]].wallptr;
                short endwall = (short)(startwall + Engine.sector[sop.sector[j]].wallnum - 1);
                for (short k = startwall; k <= endwall; k = (short)(k + 1)) {
                    sop.xorig[sop.num_walls] = (short)(sop.xmid - Engine.wall[k].x);
                    sop.yorig[sop.num_walls] = (short)(sop.ymid - Engine.wall[k].y);
                    sop.num_walls = (short)(sop.num_walls + 1);
                }
                j = (short)(j + 1);
            }
            if (sop.track <= -1 || sop.track >= 90) continue;
            boolean found = false;
            for (j = 0; j < ru.m210projects.Wang.Track.Track[sop.track].NumPoints; j = (short)(j + 1)) {
                tpoint = ru.m210projects.Wang.Track.Track[sop.track].TrackPoint;
                int dist = Game.Distance(tpoint[j].x, tpoint[j].y, sop.xmid, sop.ymid);
                if (dist >= low_dist) continue;
                low_dist = dist;
                sop.point = j;
                found = true;
            }
            if (!found) {
                sop.track = (short)-1;
                continue;
            }
            ru.m210projects.Wang.Track.NextTrackPoint(sop);
            sop.ang_moving = sop.ang_tgt = (sop.ang = Main.engine.getangle(tpoint[sop.point].x - sop.xmid, tpoint[sop.point].y - sop.ymid));
        }
    }

    public static void PlaceActorsOnTracks() {
        TRACK_POINT[] tpoint = null;
        short i = Engine.headspritestat[2];
        while (i != -1) {
            short nexti = Engine.nextspritestat[i];
            int low_dist = 999999;
            SPRITE sp = Gameutils.pUser[i].getSprite();
            USER u = Gameutils.pUser[i];
            short tag = (short)Gameutils.LOW_TAG_SPRITE(i);
            if (tag >= 30000 && tag <= 30099) {
                u.track = (short)(tag - 30000);
                u.track_dir = MyTypes.BETWEEN(sp.ang, 513, 1535) ? (short)-1 : (short)1;
                u.vel_tgt = u.track_vel = sp.xvel * 256;
                u.vel_rate = (short)6;
                for (short j = 0; j < ru.m210projects.Wang.Track.Track[u.track].NumPoints; j = (short)(j + 1)) {
                    tpoint = ru.m210projects.Wang.Track.Track[u.track].TrackPoint;
                    int dist = Game.Distance(tpoint[j].x, tpoint[j].y, sp.x, sp.y);
                    if (dist >= low_dist) continue;
                    low_dist = dist;
                    u.point = j;
                }
                ru.m210projects.Wang.Track.NextActorTrackPoint(i);
                sp.ang = Main.engine.getangle(tpoint[u.point].x - sp.x, tpoint[u.point].y - sp.y);
            }
            i = nexti;
        }
    }

    public static void MovePlayer(PlayerStr pp, int sopi, int nx, int ny) {
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING | Gameutils.PF_FLYING)) {
            return;
        }
        Sector_Object sop = Sprites.SectorObject[sopi];
        pp.sop_riding = sopi;
        if (!MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED) && !MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_RIDING)) {
            pp.Flags |= Gameutils.PF_PLAYER_RIDING;
            pp.RevolveAng = pp.getAnglei();
            pp.RevolveX = pp.posx;
            pp.RevolveY = pp.posy;
            pp.RevolveDeltaAng = 0;
        }
        pp.posx += nx;
        pp.posy += ny;
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_DONT_ROTATE)) {
            Player.UpdatePlayerSprite(pp);
            return;
        }
        if (MyTypes.TEST(pp.Flags, Gameutils.PF_PLAYER_MOVED)) {
            pp.RevolveAng = pp.getAnglei();
            pp.RevolveX = pp.posx;
            pp.RevolveY = pp.posy;
            pp.RevolveDeltaAng = 0;
        } else {
            pp.RevolveX += nx;
            pp.RevolveY += ny;
            pp.RevolveAng = Gameutils.NORM_ANGLE(pp.getAnglei() - pp.RevolveDeltaAng);
        }
        pp.RevolveDeltaAng = Gameutils.NORM_ANGLE(pp.RevolveDeltaAng + GlobSpeedSO);
        Engine.Point p = Main.engine.rotatepoint(sop.xmid, sop.ymid, pp.RevolveX, pp.RevolveY, pp.RevolveDeltaAng);
        pp.posx = p.getX();
        pp.posy = p.getY();
        pp.pang = Gameutils.NORM_ANGLE(pp.RevolveAng + pp.RevolveDeltaAng);
        Player.UpdatePlayerSprite(pp);
    }

    public static void MovePoints(int sopi, short delta_ang, int nx, int ny, int skip) {
        PlayerStr pp;
        short pnum;
        Engine.Point p;
        boolean PlayerMove = true;
        Sector_Object sop = Sprites.SectorObject[sopi];
        if (sop.xmid >= Integer.MAX_VALUE) {
            PlayerMove = false;
        }
        sop.xmid += nx;
        sop.ymid += ny;
        if (sop.xmid >= Integer.MAX_VALUE) {
            PlayerMove = false;
        }
        Engine.sprite[sop.sp_child].x = sop.xmid;
        Engine.sprite[sop.sp_child].y = sop.ymid;
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_ZMID_FLOOR)) {
            sop.zmid = Engine.sector[sop.mid_sector].floorz;
        }
        int j = 0;
        while (sop.sector[j] != -1) {
            SECTOR sectp = Engine.sector[sop.sector[j]];
            if (!MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ | Gameutils.SOBJ_DONT_ROTATE)) {
                short startwall = sectp.wallptr;
                short endwall = (short)(startwall + sectp.wallnum - 1);
                for (short k = startwall; k <= endwall; k = (short)(k + 1)) {
                    WALL wp = Engine.wall[k];
                    if (MyTypes.TEST(wp.extra, Gameutils.WALLFX_LOOP_DONT_SPIN | Gameutils.WALLFX_DONT_MOVE)) continue;
                    if (wp.extra != 0 && MyTypes.TEST(wp.extra, Gameutils.WALLFX_LOOP_OUTER)) {
                        Main.engine.dragpoint(skip, k, wp.x += nx, wp.y += ny);
                    } else {
                        Main.engine.getInterpolation(skip).setwallinterpolate(k, wp);
                        wp.x += nx;
                        wp.y += ny;
                    }
                    short rot_ang = delta_ang;
                    if (MyTypes.TEST(wp.extra, Gameutils.WALLFX_LOOP_REVERSE_SPIN)) {
                        rot_ang = -delta_ang;
                    }
                    if (MyTypes.TEST(wp.extra, Gameutils.WALLFX_LOOP_SPIN_2X)) {
                        rot_ang = Gameutils.NORM_ANGLE(rot_ang * 2);
                    }
                    if (MyTypes.TEST(wp.extra, Gameutils.WALLFX_LOOP_SPIN_4X)) {
                        rot_ang = Gameutils.NORM_ANGLE(rot_ang * 4);
                    }
                    p = Main.engine.rotatepoint(sop.xmid, sop.ymid, wp.x, wp.y, rot_ang);
                    int rx = p.getX();
                    int ry = p.getY();
                    if (wp.extra != 0 && MyTypes.TEST(wp.extra, Gameutils.WALLFX_LOOP_OUTER)) {
                        Main.engine.dragpoint(skip, k, rx, ry);
                        continue;
                    }
                    Main.engine.getInterpolation(skip).setwallinterpolate(k, wp);
                    wp.x = rx;
                    wp.y = ry;
                }
            }
            pnum = Mmulti.connecthead;
            while (pnum != -1) {
                pp = Game.Player[pnum];
                if (pp.sop == -1 && pp.lo_sectp != -1 && !MyTypes.TEST(Engine.sector[pp.lo_sectp].extra, Gameutils.SECTFX_NO_RIDE) && pp.lo_sectp == sop.sector[j] && PlayerMove) {
                    ru.m210projects.Wang.Track.MovePlayer(pp, sopi, nx, ny);
                }
                pnum = Mmulti.connectpoint2[pnum];
            }
            ++j;
        }
        int i = 0;
        while (sop.sp_num[i] != -1) {
            block28: {
                SPRITE sp;
                block30: {
                    block29: {
                        sp = Engine.sprite[sop.sp_num[i]];
                        USER u = Gameutils.pUser[sop.sp_num[i]];
                        Main.engine.getInterpolation(skip).setsprinterpolate(sop.sp_num[i], sp);
                        if (u == null || u.PlayerP != -1 || !MyTypes.TEST(u.Flags, Gameutils.SPR_SO_ATTACHED)) break block28;
                        pnum = Mmulti.connecthead;
                        while (pnum != -1) {
                            pp = Game.Player[pnum];
                            if (pp.lo_sp != -1 && pp.lo_sp == sop.sp_num[i] && PlayerMove) {
                                ru.m210projects.Wang.Track.MovePlayer(pp, sopi, nx, ny);
                            }
                            pnum = Mmulti.connectpoint2[pnum];
                        }
                        sp.x = sop.xmid - u.sx;
                        sp.y = sop.ymid - u.sy;
                        sp.z = MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ) ? sop.zmid - u.sz : (MyTypes.TEST(u.Flags, Gameutils.SPR_ON_SO_SECTOR) ? Engine.sector[sp.sectnum].floorz - u.sz : Engine.sector[sop.mid_sector].floorz - u.sz);
                        sp.ang = u.sang;
                        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_ON_SO_SECTOR)) break block29;
                        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_DONT_ROTATE) || MyTypes.TEST(Engine.wall[Engine.sector[sp.sectnum].wallptr].extra, Gameutils.WALLFX_LOOP_DONT_SPIN)) break block28;
                        if (MyTypes.TEST(Engine.wall[Engine.sector[sp.sectnum].wallptr].extra, Gameutils.WALLFX_LOOP_REVERSE_SPIN)) {
                            p = Main.engine.rotatepoint(sop.xmid, sop.ymid, sp.x, sp.y, -delta_ang);
                            sp.x = p.getX();
                            sp.y = p.getY();
                            sp.ang = Gameutils.NORM_ANGLE(sp.ang - delta_ang);
                        } else {
                            p = Main.engine.rotatepoint(sop.xmid, sop.ymid, sp.x, sp.y, delta_ang);
                            sp.x = p.getX();
                            sp.y = p.getY();
                            sp.ang = Gameutils.NORM_ANGLE(sp.ang + delta_ang);
                        }
                        break block30;
                    }
                    if (!MyTypes.TEST(sop.flags, Gameutils.SOBJ_DONT_ROTATE)) {
                        p = Main.engine.rotatepoint(sop.xmid, sop.ymid, sp.x, sp.y, delta_ang);
                        sp.x = p.getX();
                        sp.y = p.getY();
                        sp.ang = Gameutils.NORM_ANGLE(sp.ang + delta_ang);
                    }
                    if ((long)sop.xmid < Integer.MAX_VALUE) {
                        Main.engine.setspritez(sop.sp_num[i], sp.x, sp.y, sp.z);
                    }
                }
                if (MyTypes.TEST(sp.extra, Gameutils.SPRX_BLADE)) {
                    Weapon.DoBladeDamage(sop.sp_num[i]);
                }
            }
            i = (short)(i + 1);
        }
        pnum = Mmulti.connecthead;
        while (pnum != -1) {
            pp = Game.Player[pnum];
            if (pp.sop_riding != -1) {
                pp.cursectnum = Rooms.COVERupdatesector(pp.posx, pp.posy, pp.cursectnum);
                if (MyTypes.TEST(pp.Flags, Gameutils.PF_CRAWLING)) {
                    Player.DoPlayerZrange(pp);
                    pp.posz = pp.loz - Player.PLAYER_CRAWL_HEIGHT;
                    pp.getSprite().z = pp.loz;
                } else {
                    Player.DoPlayerZrange(pp);
                    if (!MyTypes.TEST(pp.Flags, Gameutils.PF_JUMPING | Gameutils.PF_FALLING | Gameutils.PF_FLYING)) {
                        pp.posz = pp.loz - Player.PLAYER_HEIGHT;
                        pp.getSprite().z = pp.loz;
                    }
                }
            } else {
                pp.Flags &= ~Gameutils.PF_PLAYER_RIDING;
            }
            pnum = Mmulti.connectpoint2[pnum];
        }
    }

    public static void RefreshPoints(int sopi, int nx, int ny, boolean dynamic, int skip) {
        short wallcount = 0;
        Sector_Object sop = Sprites.SectorObject[sopi];
        if (dynamic && sop.PreMoveAnimator != null) {
            sop.PreMoveAnimator.invoke(sopi);
        }
        int j = 0;
        while (sop.sector[j] != -1) {
            SECTOR sectp = Engine.sector[sop.sector[j]];
            if (!MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ)) {
                short startwall = sectp.wallptr;
                short endwall = (short)(startwall + sectp.wallnum - 1);
                for (short k = startwall; k <= endwall; k = (short)(k + 1)) {
                    WALL wp = Engine.wall[k];
                    if (wp.extra == 0 || !MyTypes.TEST(wp.extra, Gameutils.WALLFX_DONT_MOVE)) {
                        int y;
                        int x;
                        int dx = x = sop.xmid - sop.xorig[wallcount];
                        int dy = y = sop.ymid - sop.yorig[wallcount];
                        if (dynamic && sop.scale_type != 0 && !MyTypes.TEST(wp.extra, Gameutils.WALLFX_DONT_SCALE)) {
                            short ang = Gameutils.NORM_ANGLE(Main.engine.getangle(x - sop.xmid, y - sop.ymid));
                            if (sop.scale_type == 5) {
                                Vector2i d = Morth.ScaleRandomPoint(sop, wallcount, ang, x, y);
                                dx = d.x;
                                dy = d.y;
                            } else {
                                int xmul = sop.scale_dist * sop.scale_x_mult >> 8;
                                int ymul = sop.scale_dist * sop.scale_y_mult >> 8;
                                dx = x + (xmul * Engine.sintable[Gameutils.NORM_ANGLE(ang + 512)] >> 14);
                                dy = y + (ymul * Engine.sintable[ang] >> 14);
                            }
                        }
                        if (wp.extra != 0 && MyTypes.TEST(wp.extra, Gameutils.WALLFX_LOOP_OUTER)) {
                            Main.engine.dragpoint(skip, k, dx, dy);
                        } else {
                            Main.engine.getInterpolation(skip).setwallinterpolate(k, wp);
                            wp.x = dx;
                            wp.y = dy;
                        }
                    }
                    wallcount = (short)(wallcount + 1);
                }
            }
            j = (short)(j + 1);
        }
        short delta_ang_from_orig = sop.spin_speed != 0 ? Gameutils.NORM_ANGLE(sop.last_ang + sop.spin_ang - sop.ang_orig) : Gameutils.NORM_ANGLE(sop.ang + sop.spin_ang - sop.ang_orig);
        ru.m210projects.Wang.Track.MovePoints(sopi, delta_ang_from_orig, nx, ny, skip);
        if (dynamic && sop.PostMoveAnimator != null) {
            sop.PostMoveAnimator.invoke(sopi);
        }
    }

    public static void KillSectorObjectSprites(Sector_Object sop) {
        int i = 0;
        while (sop.sp_num[i] != -1) {
            SPRITE sp = Engine.sprite[sop.sp_num[i]];
            USER u = Gameutils.pUser[sop.sp_num[i]];
            u.Flags &= ~Gameutils.SPR_SO_ATTACHED;
            if (sp.picnum != 2307 || sp.hitag != 69) {
                Sprites.KillSprite(sop.sp_num[i]);
            }
            ++i;
        }
        sop.sp_num[0] = -1;
    }

    public static void UpdateSectorObjectSprites(Sector_Object sop) {
        int i = 0;
        while (sop.sp_num[i] != -1) {
            SPRITE sp = Engine.sprite[sop.sp_num[i]];
            Main.engine.setspritez(sop.sp_num[i], sp.x, sp.y, sp.z);
            ++i;
        }
    }

    public static int DetectSectorObject(SECTOR sectph) {
        for (int s = 0; s < 25; ++s) {
            Sector_Object sop = Sprites.SectorObject[s];
            if (sop.xmid == Integer.MAX_VALUE || sop.xmid == Integer.MAX_VALUE) continue;
            int j = 0;
            while (sop.sector[j] != -1) {
                SECTOR sectp = Engine.sector[sop.sector[j]];
                if (sectph == sectp) {
                    return s;
                }
                j = (short)(j + 1);
            }
        }
        return -1;
    }

    public static Sector_Object DetectSectorObjectByWall(WALL wph) {
        for (int s = 0; s < 25; ++s) {
            Sector_Object sop = Sprites.SectorObject[s];
            if (sop.xmid == Integer.MAX_VALUE || sop.xmid == Integer.MAX_VALUE) continue;
            int j = 0;
            while (sop.sector[j] != -1) {
                SECTOR sectp = Engine.sector[sop.sector[j]];
                short startwall = sectp.wallptr;
                short endwall = (short)(startwall + sectp.wallnum - 1);
                for (short k = startwall; k <= endwall; k = (short)(k + 1)) {
                    WALL wp = Engine.wall[k];
                    if (MyTypes.TEST(wp.extra, Gameutils.WALLFX_LOOP_OUTER) && wph == Engine.wall[wp.nextwall]) {
                        return sop;
                    }
                    if (wph != wp) continue;
                    return sop;
                }
                j = (short)(j + 1);
            }
        }
        return null;
    }

    public static void CollapseSectorObject(Sector_Object sop, int nx, int ny) {
        int j = 0;
        while (sop.sector[j] != -1) {
            SECTOR sectp = Engine.sector[sop.sector[j]];
            if (!MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ)) {
                short startwall = sectp.wallptr;
                short endwall = (short)(startwall + sectp.wallnum - 1);
                for (short k = startwall; k <= endwall; k = (short)(k + 1)) {
                    WALL wp = Engine.wall[k];
                    if (MyTypes.TEST(wp.extra, Gameutils.WALLFX_DONT_MOVE)) continue;
                    if (wp.extra != 0 && MyTypes.TEST(wp.extra, Gameutils.WALLFX_LOOP_OUTER)) {
                        Main.engine.dragpoint(k, nx, ny);
                        continue;
                    }
                    wp.x = nx;
                    wp.y = ny;
                }
            }
            j = (short)(j + 1);
        }
    }

    public static void MoveZ(Sector_Object sop) {
        SECTOR sectp;
        short i;
        if (sop.bob_amt != 0) {
            sop.bob_sine_ndx = (short)(Game.totalsynctics << sop.bob_speed & 0x7FF);
            sop.bob_diff = sop.bob_amt * Engine.sintable[sop.bob_sine_ndx] >> 14;
            i = 0;
            while (sop.sector[i] != -1) {
                sectp = Engine.sector[sop.sector[i]];
                if (Sector.SectUser[sop.sector[i]] == null || !MyTypes.TEST(Sector.SectUser[sop.sector[i]].flags, Gameutils.SECTFU_SO_DONT_BOB)) {
                    sectp.floorz = sop.zorig_floor[i] + sop.bob_diff;
                }
                i = (short)(i + 1);
            }
        }
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_MOVE_VERTICAL) && (i = (short)Sector.AnimGetGoal(sop, Anim.AnimType.SectorObjectZ)) < 0) {
            sop.flags &= ~Gameutils.SOBJ_MOVE_VERTICAL;
        }
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_ZDIFF_MODE)) {
            return;
        }
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_ZDOWN)) {
            i = 0;
            while (sop.sector[i] != -1) {
                sectp = Engine.sector[sop.sector[i]];
                Sector.AnimSet(sop.sector[i], sop.zorig_floor[i] + sop.z_tgt, sop.z_rate, Anim.AnimType.FloorZ);
                i = (short)(i + 1);
            }
            sop.flags &= ~Gameutils.SOBJ_ZDOWN;
        } else if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_ZUP)) {
            i = 0;
            while (sop.sector[i] != -1) {
                sectp = Engine.sector[sop.sector[i]];
                Sector.AnimSet(sop.sector[i], sop.zorig_floor[i] + sop.z_tgt, sop.z_rate, Anim.AnimType.FloorZ);
                i = (short)(i + 1);
            }
            sop.flags &= ~Gameutils.SOBJ_ZUP;
        }
    }

    public static void CallbackSOsink(Anim ap, Sector_Object data) {
        short ndx;
        short dest_sector = -1;
        int src_sector = -1;
        Sector_Object sop = data;
        int i = 0;
        while (sop.sector[i] != -1) {
            if (Sector.SectUser[sop.sector[i]] != null && MyTypes.TEST(Sector.SectUser[sop.sector[i]].flags, Gameutils.SECTFU_SO_SINK_DEST)) {
                src_sector = sop.sector[i];
                break;
            }
            i = (short)(i + 1);
        }
        i = 0;
        while (sop.sector[i] != -1) {
            if (ap.ptr == Engine.sector[sop.sector[i]] && ap.index == sop.sector[i] && ap.type == Anim.AnimType.FloorZ) {
                dest_sector = sop.sector[i];
                break;
            }
            i = (short)(i + 1);
        }
        Engine.sector[dest_sector].floorpicnum = Engine.sector[src_sector].floorpicnum;
        Engine.sector[dest_sector].floorshade = Engine.sector[src_sector].floorshade;
        Engine.sector[dest_sector].floorstat = (short)(Engine.sector[dest_sector].floorstat & ~Gameutils.FLOOR_STAT_RELATIVE);
        short tgt_depth = Sprites.GetSectUser((int)src_sector).depth;
        for (short sectnum = 0; sectnum < Engine.numsectors; sectnum = (short)(sectnum + 1)) {
            if (sectnum != dest_sector) continue;
            ndx = (short)Sector.AnimSet(sectnum, tgt_depth << 16, ap.vel << 8 >> 8, Anim.AnimType.SectUserDepth);
            Sector.AnimSetVelAdj(ndx, ap.vel_adj);
            break;
        }
        i = Engine.headspritesect[dest_sector];
        while (i != -1) {
            int nexti = Engine.nextspritesect[i];
            SPRITE sp = Engine.sprite[i];
            USER u = Gameutils.pUser[i];
            if (u != null && u.PlayerP == -1 && MyTypes.TEST(u.Flags, Gameutils.SPR_SO_ATTACHED)) {
                ndx = (short)Sector.AnimSet(i, -u.sz - Gameutils.SPRITEp_SIZE_Z(sp) - Gameutils.Z(100), ap.vel >> 8, Anim.AnimType.UserZ);
                Sector.AnimSetVelAdj(ndx, ap.vel_adj);
            }
            i = nexti;
        }
        short startwall = Engine.sector[dest_sector].wallptr;
        short endwall = (short)(startwall + Engine.sector[dest_sector].wallnum - 1);
        for (short j = startwall; j <= endwall; j = (short)(j + 1)) {
            Engine.wall[j].cstat = (short)(Engine.wall[j].cstat & ~Gameutils.CSTAT_WALL_BLOCK);
        }
    }

    public static void MoveSectorObjects(int sopi, int locktics, int skip) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        if (sop.track >= 90) {
            if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_UPDATE_ONCE)) {
                sop.flags &= ~Gameutils.SOBJ_UPDATE_ONCE;
                ru.m210projects.Wang.Track.RefreshPoints(sopi, 0, 0, false, skip);
            }
            return;
        }
        int nx = 0;
        int ny = 0;
        if (sop.wait_tics != 0) {
            sop.wait_tics = (short)(sop.wait_tics - locktics);
            if (sop.wait_tics <= 0) {
                sop.wait_tics = 0;
            }
            return;
        }
        short delta_ang = 0;
        if (sop.track > -1) {
            ru.m210projects.Wang.Track.DoTrack(sopi, locktics, Game.tmp_ptr[0].set(0), Game.tmp_ptr[1].set(0));
            nx = Game.tmp_ptr[0].value;
            ny = Game.tmp_ptr[1].value;
        }
        delta_ang = Player.GetDeltaAngle(sop.ang_tgt, sop.ang);
        sop.ang = Gameutils.NORM_ANGLE(sop.ang + (delta_ang >> sop.turn_speed));
        delta_ang = (short)(delta_ang >> sop.turn_speed);
        ru.m210projects.Wang.Track.MoveZ(sop);
        short speed = (short)(sop.spin_speed * locktics);
        sop.spin_ang = Gameutils.NORM_ANGLE(sop.spin_ang + speed);
        if (sop.spin_speed != 0) {
            GlobSpeedSO = speed;
        } else {
            GlobSpeedSO = speed;
            GlobSpeedSO += delta_ang;
        }
        if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_DYNAMIC)) {
            ru.m210projects.Wang.Track.RefreshPoints(sopi, nx, ny, true, skip);
        } else if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_UPDATE | Gameutils.SOBJ_UPDATE_ONCE) || sop.vel != 0 || sop.ang != sop.ang_tgt || GlobSpeedSO != 0) {
            sop.flags &= ~Gameutils.SOBJ_UPDATE_ONCE;
            ru.m210projects.Wang.Track.RefreshPoints(sopi, nx, ny, false, skip);
        }
    }

    public static void DoTrack(int sopi, int locktics, LONGp nx, LONGp ny) {
        int dist;
        Sector_Object sop = Sprites.SectorObject[sopi];
        TRACK_POINT tpoint = ru.m210projects.Wang.Track.Track[sop.track].TrackPoint[sop.point];
        if (sop.vel != 0) {
            sop.ang_moving = sop.ang_tgt = Main.engine.getangle(tpoint.x - sop.xmid, tpoint.y - sop.ymid);
        }
        if (sop.target_dist < 100) {
            switch (tpoint.tag_low) {
                case 728: {
                    Sector.DoMatchEverything(null, tpoint.tag_high, -1);
                    break;
                }
                case 729: {
                    Sector.DoMatchEverything(null, tpoint.tag_high, -1);
                    tpoint.tag_low = 0;
                    tpoint.tag_high = 0;
                    break;
                }
                case 715: {
                    if (sop.spin_speed != 0) break;
                    sop.spin_speed = tpoint.tag_high;
                    sop.last_ang = sop.ang;
                    break;
                }
                case 720: {
                    if (sop.spin_speed == 0 || sop.spin_speed < 0) break;
                    sop.spin_speed = -sop.spin_speed;
                    break;
                }
                case 716: {
                    if (sop.spin_speed == 0) break;
                    sop.spin_speed = 0;
                    break;
                }
                case 717: {
                    sop.flags |= Gameutils.SOBJ_ZMID_FLOOR;
                    sop.bob_amt = Gameutils.Z(tpoint.tag_high);
                    sop.bob_sine_ndx = 0;
                    sop.bob_speed = (short)4;
                    break;
                }
                case 719: {
                    sop.bob_speed = 0;
                    sop.bob_sine_ndx = 0;
                    sop.bob_amt = 0;
                    break;
                }
                case 718: {
                    sop.bob_speed = tpoint.tag_high;
                    break;
                }
                case 704: {
                    sop.dir = (short)(sop.dir * -1);
                    break;
                }
                case 703: {
                    sop.vel = 0;
                    sop.wait_tics = (short)(tpoint.tag_high * 128);
                    break;
                }
                case 702: {
                    sop.vel_tgt = sop.vel = tpoint.tag_high * 256;
                    break;
                }
                case 707: {
                    sop.vel_rate = tpoint.tag_high;
                    break;
                }
                case 705: {
                    sop.flags &= ~(Gameutils.SOBJ_SLOW_DOWN | Gameutils.SOBJ_SPEED_UP);
                    if (sop.dir < 0) {
                        sop.vel_tgt -= tpoint.tag_high * 256;
                        sop.flags |= Gameutils.SOBJ_SLOW_DOWN;
                        break;
                    }
                    sop.vel_tgt += tpoint.tag_high * 256;
                    sop.flags |= Gameutils.SOBJ_SPEED_UP;
                    break;
                }
                case 706: {
                    sop.flags &= ~(Gameutils.SOBJ_SLOW_DOWN | Gameutils.SOBJ_SPEED_UP);
                    if (sop.dir > 0) {
                        sop.vel_tgt -= tpoint.tag_high * 256;
                        sop.flags |= Gameutils.SOBJ_SLOW_DOWN;
                        break;
                    }
                    sop.vel_tgt += tpoint.tag_high * 256;
                    sop.flags |= Gameutils.SOBJ_SPEED_UP;
                    break;
                }
                case 723: {
                    int dest_sector = -1;
                    int i = 0;
                    while (sop.sector[i] != -1) {
                        if (Sector.SectUser[sop.sector[i]] != null && MyTypes.TEST(Sector.SectUser[sop.sector[i]].flags, Gameutils.SECTFU_SO_SINK_DEST)) {
                            dest_sector = sop.sector[i];
                            break;
                        }
                        i = (short)(i + 1);
                    }
                    sop.bob_speed = 0;
                    sop.bob_sine_ndx = 0;
                    sop.bob_amt = 0;
                    i = 0;
                    while (sop.sector[i] != -1) {
                        if (Sector.SectUser[sop.sector[i]] == null || !MyTypes.TEST(Sector.SectUser[sop.sector[i]].flags, Gameutils.SECTFU_SO_DONT_SINK)) {
                            short ndx = (short)Sector.AnimSet(sop.sector[i], Engine.sector[dest_sector].floorz, tpoint.tag_high, Anim.AnimType.FloorZ);
                            Sector.AnimSetCallback(ndx, Anim.AnimCallback.SOsink, sopi);
                            Sector.AnimSetVelAdj(ndx, 6);
                        }
                        i = (short)(i + 1);
                    }
                    break;
                }
                case 724: {
                    int i = 0;
                    while (sop.sector[i] != -1) {
                        SECTOR sectp = Engine.sector[sop.sector[i]];
                        Sect_User sectu = Sector.SectUser[sop.sector[i]];
                        if (sectu != null && sectu.stag == 37) {
                            Sector.AnimSet(sop.sector[i], sectp.floorz + Gameutils.Z(sectu.height), 128, Anim.AnimType.FloorZ);
                            sectp.floorshade = (byte)(sectp.floorshade + sectu.height / 6);
                            sectp.extra = (short)(sectp.extra & ~Gameutils.SECTFX_NO_RIDE);
                        }
                        i = (short)(i + 1);
                    }
                    break;
                }
                case 725: {
                    sop.flags |= Gameutils.SOBJ_MOVE_VERTICAL;
                    int zr = tpoint.tag_high > 0 ? (int)tpoint.tag_high : 256;
                    ru.m210projects.Wang.Track.NextTrackPoint(sop);
                    tpoint = ru.m210projects.Wang.Track.Track[sop.track].TrackPoint[sop.point];
                    Sector.AnimSet(sopi, tpoint.z, zr, Anim.AnimType.SectorObjectZ);
                    sop.dir = (short)(sop.dir * -1);
                    ru.m210projects.Wang.Track.NextTrackPoint(sop);
                    tpoint = ru.m210projects.Wang.Track.Track[sop.track].TrackPoint[sop.point];
                    sop.dir = (short)(sop.dir * -1);
                    break;
                }
                case 726: {
                    if (tpoint.tag_high == -1) break;
                    sop.flags |= Gameutils.SOBJ_WAIT_FOR_EVENT;
                    sop.save_vel = (short)sop.vel;
                    sop.save_spin_speed = sop.spin_speed;
                    sop.spin_speed = 0;
                    sop.vel = 0;
                    if (tpoint.tag_high != 0) {
                        sop.match_event = tpoint.tag_high;
                    }
                    tpoint.tag_high = (short)-1;
                    break;
                }
                case 712: {
                    sop.flags |= Gameutils.SOBJ_ZDIFF_MODE;
                    sop.zdelta = Gameutils.Z(tpoint.tag_high);
                    break;
                }
                case 711: {
                    sop.z_rate = Gameutils.Z(tpoint.tag_high);
                    break;
                }
                case 709: {
                    sop.flags &= ~(Gameutils.SOBJ_ZDOWN | Gameutils.SOBJ_ZUP);
                    if (sop.dir < 0) {
                        sop.z_tgt += Gameutils.Z(tpoint.tag_high);
                        sop.flags |= Gameutils.SOBJ_ZDOWN;
                        break;
                    }
                    sop.z_tgt -= Gameutils.Z(tpoint.tag_high);
                    sop.flags |= Gameutils.SOBJ_ZUP;
                    break;
                }
                case 710: {
                    sop.flags &= ~(Gameutils.SOBJ_ZDOWN | Gameutils.SOBJ_ZUP);
                    if (sop.dir > 0) {
                        sop.z_tgt += Gameutils.Z(tpoint.tag_high);
                        sop.flags |= Gameutils.SOBJ_ZDOWN;
                        break;
                    }
                    sop.z_tgt -= Gameutils.Z(tpoint.tag_high);
                    sop.flags |= Gameutils.SOBJ_ZUP;
                }
            }
            ru.m210projects.Wang.Track.NextTrackPoint(sop);
            tpoint = ru.m210projects.Wang.Track.Track[sop.track].TrackPoint[sop.point];
            sop.target_dist = Game.Distance(sop.xmid, sop.ymid, tpoint.x, tpoint.y);
            sop.ang_moving = sop.ang_tgt = Main.engine.getangle(tpoint.x - sop.xmid, tpoint.y - sop.ymid);
            if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_ZDIFF_MODE)) {
                int dx = tpoint.x;
                int dy = tpoint.y;
                int dz = tpoint.z - sop.zdelta;
                dist = Gameutils.DIST(dx, dy, sop.xmid, sop.ymid);
                sop.z_rate = sop.vel * (sop.zmid - dz) / dist;
                sop.z_rate = Gameutils.PIXZ(Pragmas.klabs(sop.z_rate));
                if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPRITE_OBJ)) {
                    Sector.AnimSet(sopi, dz, sop.z_rate, Anim.AnimType.SectorObjectZ);
                } else {
                    int i = 0;
                    while (sop.sector[i] != -1) {
                        Sector.AnimSet(sop.sector[i], dz - (Engine.sector[sop.mid_sector].floorz - Engine.sector[sop.sector[i]].floorz), sop.z_rate, Anim.AnimType.FloorZ);
                        i = (short)(i + 1);
                    }
                }
            }
        } else if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_SPEED_UP)) {
            if ((sop.vel += locktics << sop.vel_rate) >= sop.vel_tgt) {
                sop.vel = sop.vel_tgt;
                sop.flags &= ~Gameutils.SOBJ_SPEED_UP;
            }
        } else if (MyTypes.TEST(sop.flags, Gameutils.SOBJ_SLOW_DOWN) && (sop.vel -= locktics << sop.vel_rate) <= sop.vel_tgt) {
            sop.vel = sop.vel_tgt;
            sop.flags &= ~Gameutils.SOBJ_SLOW_DOWN;
        }
        if (sop.vel != 0 && !MyTypes.TEST(sop.flags, Gameutils.SOBJ_MOVE_VERTICAL)) {
            nx.value = MyTypes.DIV256(sop.vel) * locktics * Engine.sintable[Gameutils.NORM_ANGLE(sop.ang_moving + 512)] >> 14;
            ny.value = MyTypes.DIV256(sop.vel) * locktics * Engine.sintable[sop.ang_moving] >> 14;
            dist = Game.Distance(sop.xmid, sop.ymid, sop.xmid + nx.value, sop.ymid + ny.value);
            sop.target_dist -= dist;
        }
    }

    public static void OperateSectorObject(int sopi, float newang, int newx, int newy, int skip) {
        if (WangNetwork.Prediction) {
            return;
        }
        Sector_Object sop = Sprites.SectorObject[sopi];
        if (sop.track < 90) {
            return;
        }
        if (sop.bob_amt != 0) {
            sop.bob_sine_ndx = (short)(Game.totalsynctics << sop.bob_speed & 0x7FF);
            sop.bob_diff = sop.bob_amt * Engine.sintable[sop.bob_sine_ndx] >> 14;
            int i = 0;
            while (sop.sector[i] != -1) {
                SECTOR sectp = Engine.sector[sop.sector[i]];
                if (Sector.SectUser[sop.sector[i]] == null || !MyTypes.TEST(Sector.SectUser[sop.sector[i]].flags, Gameutils.SECTFU_SO_DONT_BOB)) {
                    sectp.floorz = sop.zorig_floor[i] + sop.bob_diff;
                }
                ++i;
            }
        }
        GlobSpeedSO = 0;
        sop.ang_moving = (short)newang;
        sop.spin_ang = 0;
        sop.ang = (short)newang;
        ru.m210projects.Wang.Track.RefreshPoints(sopi, newx - sop.xmid, newy - sop.ymid, false, skip);
    }

    public static void PlaceSectorObject(int sopi, int newang, int newx, int newy) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        ru.m210projects.Wang.Track.RefreshPoints(sopi, newx - sop.xmid, newy - sop.ymid, false, 1);
    }

    public static void VehicleSetSmoke(Sector_Object sop, Animator animator) {
        int j = 0;
        while (sop.sector[j] != -1) {
            short SpriteNum = Engine.headspritesect[sop.sector[j]];
            while (SpriteNum != -1) {
                short NextSprite = Engine.nextspritesect[SpriteNum];
                SPRITE sp = Engine.sprite[SpriteNum];
                USER u = Gameutils.pUser[SpriteNum];
                switch (sp.hitag) {
                    case 69: {
                        if (sp.clipdist != 3) break;
                        if (animator != null) {
                            if (sp.statnum == 41) break;
                            Sprites.change_sprite_stat(SpriteNum, 41);
                            Sector.DoSoundSpotMatch(sp.lotag, 1, Sound.SoundType.SOUND_OBJECT_TYPE);
                            Sector.DoSpawnSpotsForDamage(sp.lotag);
                        } else {
                            Sprites.change_sprite_stat(SpriteNum, 67);
                            Sector.DoSoundSpotStopSound(sp.lotag);
                        }
                        u.ActorActionFunc = animator;
                    }
                }
                SpriteNum = NextSprite;
            }
            ++j;
        }
    }

    public static void KillSectorObject(int sopi) {
        int newx = Integer.MAX_VALUE;
        int newy = Integer.MAX_VALUE;
        short newang = 0;
        Sector_Object sop = Sprites.SectorObject[sopi];
        if (sop.track < 90) {
            return;
        }
        sop.ang_tgt = sop.ang_moving = newang;
        sop.spin_ang = 0;
        sop.ang = sop.ang_tgt;
        ru.m210projects.Wang.Track.RefreshPoints(sopi, newx - sop.xmid, newy - sop.ymid, false, 1);
    }

    public static void TornadoSpin(Sector_Object sop) {
        int locktics = 3;
        short delta_ang = Player.GetDeltaAngle(sop.ang_tgt, sop.ang);
        sop.ang = Gameutils.NORM_ANGLE(sop.ang + (delta_ang >> sop.turn_speed));
        delta_ang = (short)(delta_ang >> sop.turn_speed);
        ru.m210projects.Wang.Track.MoveZ(sop);
        short speed = (short)(sop.spin_speed * locktics);
        sop.spin_ang = Gameutils.NORM_ANGLE(sop.spin_ang + speed);
        if (sop.spin_speed != 0) {
            GlobSpeedSO = speed;
        } else {
            GlobSpeedSO = speed;
            GlobSpeedSO += delta_ang;
        }
    }

    public static void DoTornadoObject(int sopi) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        int xvect = sop.vel * Engine.sintable[Gameutils.NORM_ANGLE(sop.ang_moving + 512)];
        int yvect = sop.vel * Engine.sintable[Gameutils.NORM_ANGLE(sop.ang_moving)];
        short cursect = sop.op_main_sector;
        int floor_dist = MyTypes.DIV4(Pragmas.klabs(Engine.sector[cursect].ceilingz - Engine.sector[cursect].floorz));
        int x = sop.xmid;
        int y = sop.ymid;
        int z = floor_dist;
        ru.m210projects.Wang.Track.PlaceSectorObject(sopi, sop.ang_moving, Integer.MAX_VALUE, Integer.MAX_VALUE);
        int ret = Main.engine.clipmove(x, y, z, cursect, xvect, yvect, sop.clipdist, Gameutils.Z(0), floor_dist, Gameutils.CLIPMASK_ACTOR);
        x = Engine.clipmove_x;
        y = Engine.clipmove_y;
        z = Engine.clipmove_z;
        cursect = Engine.clipmove_sectnum;
        if (ret != 0) {
            sop.ang_moving = Gameutils.NORM_ANGLE(sop.ang_moving + 1024 + Gameutils.RANDOM_P2(512) - 256);
        }
        ru.m210projects.Wang.Track.TornadoSpin(sop);
        ru.m210projects.Wang.Track.RefreshPoints(sopi, x - sop.xmid, y - sop.ymid, true, 1);
    }

    public static void DoAutoTurretObject(int sopi) {
        Sector_Object sop = Sprites.SectorObject[sopi];
        short SpriteNum = (short)sop.sp_child;
        USER u = Gameutils.pUser[SpriteNum];
        if (sop.max_damage != -9999 && sop.max_damage <= 0) {
            return;
        }
        u.WaitTics = (short)(u.WaitTics - 3);
        if (u.tgt_sp == -1 || u.WaitTics < 0) {
            u.WaitTics = (short)480;
            Ai.DoActorPickClosePlayer(SpriteNum);
        }
        if (!Sprites.MoveSkip2) {
            short diff;
            SPRITE shootp;
            int i = 0;
            while (sop.sp_num[i] != -1) {
                if (Engine.sprite[sop.sp_num[i]].statnum == 55) {
                    shootp = Engine.sprite[sop.sp_num[i]];
                    if (!Rooms.FAFcansee(shootp.x, shootp.y, shootp.z - Gameutils.Z(4), shootp.sectnum, Engine.sprite[u.tgt_sp].x, Engine.sprite[u.tgt_sp].y, Gameutils.SPRITEp_UPPER(Engine.sprite[u.tgt_sp]), Engine.sprite[u.tgt_sp].sectnum)) {
                        return;
                    }
                }
                i = (short)(i + 1);
            }
            if (u.Counter > 0) {
                u.Counter = (short)(u.Counter - 6);
                if (u.Counter <= 0) {
                    u.Counter = 0;
                }
            }
            if (u.Counter == 0) {
                shootp = null;
                i = 0;
                while (sop.sp_num[i] != -1) {
                    if (Engine.sprite[sop.sp_num[i]].statnum == 55) {
                        shootp = Engine.sprite[sop.sp_num[i]];
                        u.Counter = Gameutils.SP_TAG5(shootp) != 0 ? (short)Gameutils.SP_TAG5(shootp) : (short)12;
                        Weapon.InitTurretMgun(sop);
                    }
                    i = (short)(i + 1);
                }
            }
            sop.ang_tgt = Main.engine.getangle(Engine.sprite[u.tgt_sp].x - sop.xmid, Engine.sprite[u.tgt_sp].y - sop.ymid);
            short delta_ang = Player.GetDeltaAngle(sop.ang_tgt, sop.ang);
            sop.ang = Gameutils.NORM_ANGLE(sop.ang + (delta_ang >> 3));
            if (sop.limit_ang_center >= 0 && Pragmas.klabs(diff = Player.GetDeltaAngle(sop.ang, sop.limit_ang_center)) >= sop.limit_ang_delta) {
                sop.ang = diff < 0 ? (short)(sop.limit_ang_center - sop.limit_ang_delta) : (short)(sop.limit_ang_center + sop.limit_ang_delta);
            }
            ru.m210projects.Wang.Track.OperateSectorObject(sopi, sop.ang, sop.xmid, sop.ymid, 2);
        }
    }

    public static void DoActorHitTrackEndPoint(USER u) {
        SPRITE sp = u.getSprite();
        ru.m210projects.Wang.Track.Track[u.track].flags = (short)(ru.m210projects.Wang.Track.Track[u.track].flags & ~Gameutils.TF_TRACK_OCCUPIED);
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_RUN_AWAY)) {
            u.track = Ai.FindTrackAwayFromPlayer(u);
            if (u.track >= 0) {
                sp.ang = Gameutils.NORM_ANGLE(Main.engine.getangle(ru.m210projects.Wang.Track.Track[u.track].TrackPoint[u.point].x - sp.x, ru.m210projects.Wang.Track.Track[u.track].TrackPoint[u.point].y - sp.y));
            } else {
                u.Flags &= ~Gameutils.SPR_RUN_AWAY;
                Ai.DoActorSetSpeed(u.SpriteNum, 1);
                u.track = (short)-1;
            }
        } else if (MyTypes.TEST(u.Flags, Gameutils.SPR_FIND_PLAYER)) {
            u.track = (short)Ai.FindTrackToPlayer(u);
            if (u.track >= 0) {
                sp.ang = Gameutils.NORM_ANGLE(Main.engine.getangle(ru.m210projects.Wang.Track.Track[u.track].TrackPoint[u.point].x - sp.x, ru.m210projects.Wang.Track.Track[u.track].TrackPoint[u.point].y - sp.y));
            } else {
                u.Flags &= ~Gameutils.SPR_FIND_PLAYER;
                Ai.DoActorSetSpeed(u.SpriteNum, 1);
                u.track = (short)-1;
            }
        } else {
            u.track = (short)-1;
        }
    }

    public static void ActorLeaveTrack(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (u.track == -1) {
            return;
        }
        u.Flags &= ~(Gameutils.SPR_FIND_PLAYER | Gameutils.SPR_RUN_AWAY | Gameutils.SPR_CLIMBING);
        ru.m210projects.Wang.Track.Track[u.track].flags = (short)(ru.m210projects.Wang.Track.Track[u.track].flags & ~Gameutils.TF_TRACK_OCCUPIED);
        u.track = (short)-1;
    }

    public static boolean ActorTrackDecide(TRACK_POINT tpoint, int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = u.getSprite();
        switch (tpoint.tag_low) {
            case 700: {
                if (ru.m210projects.Wang.Track.Track[u.track].ttflags == 0 || u.track_dir != -1) break;
                ru.m210projects.Wang.Track.DoActorHitTrackEndPoint(u);
                return false;
            }
            case 701: {
                if (ru.m210projects.Wang.Track.Track[u.track].ttflags == 0 || u.track_dir != 1) break;
                ru.m210projects.Wang.Track.DoActorHitTrackEndPoint(u);
                return false;
            }
            case 799: {
                u.Flags |= Gameutils.SPR_WAIT_FOR_PLAYER;
                u.Dist = tpoint.tag_high;
                break;
            }
            case 800: {
                u.Flags |= Gameutils.SPR_WAIT_FOR_TRIGGER;
                u.Dist = tpoint.tag_high;
                break;
            }
            case 755: {
                u.vel_rate = tpoint.tag_high;
                break;
            }
            case 753: {
                u.Flags &= ~(Gameutils.SPR_SLOW_DOWN | Gameutils.SPR_SPEED_UP);
                if (u.track_dir < 0) {
                    u.vel_tgt -= tpoint.tag_high * 256;
                    u.Flags |= Gameutils.SPR_SLOW_DOWN;
                    break;
                }
                u.vel_tgt += tpoint.tag_high * 256;
                u.Flags |= Gameutils.SPR_SPEED_UP;
                break;
            }
            case 754: {
                u.Flags &= ~(Gameutils.SPR_SLOW_DOWN | Gameutils.SPR_SPEED_UP);
                if (u.track_dir > 0) {
                    u.vel_tgt -= tpoint.tag_high * 256;
                    u.Flags |= Gameutils.SPR_SLOW_DOWN;
                    break;
                }
                u.vel_tgt += tpoint.tag_high * 256;
                u.Flags |= Gameutils.SPR_SPEED_UP;
                break;
            }
            case 752: {
                u.track_dir = (short)(u.track_dir * -1);
                break;
            }
            case 770: {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Stand);
                break;
            }
            case 771: {
                if (u.ActorActionSet.Jump == null) break;
                sp.ang = tpoint.ang;
                u.jump_speed = tpoint.tag_high == 0 ? (short)-384 : (short)(-tpoint.tag_high);
                Actor.DoActorBeginJump(SpriteNum);
                u.ActorActionFunc = Ai.DoActorMoveJump;
                break;
            }
            case 801: 
            case 803: {
                if (u.ActorActionSet.Jump == null) break;
                sp.ang = tpoint.ang;
                ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                if (tpoint.tag_high != 0) {
                    u.jump_speed = -tpoint.tag_high;
                } else {
                    sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_BLOCK);
                    Rooms.FAFhitscan(sp.x, sp.y, sp.z - Gameutils.Z(24), sp.sectnum, Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)], Engine.sintable[sp.ang], 0, Engine.pHitInfo, Gameutils.CLIPMASK_MISSILE);
                    short hitwall = Engine.pHitInfo.hitwall;
                    short hitsprite = Engine.pHitInfo.hitsprite;
                    sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_BLOCK);
                    if (hitsprite >= 0) {
                        return false;
                    }
                    if (hitwall < 0 || Engine.wall[hitwall].nextsector < 0) {
                        return false;
                    }
                    int zdiff = Pragmas.klabs(sp.z - Engine.sector[Engine.wall[hitwall].nextsector].floorz) >> 8;
                    u.jump_speed = (short)Ripper.PickJumpSpeed(SpriteNum, zdiff);
                }
                Actor.DoActorBeginJump(SpriteNum);
                u.ActorActionFunc = Ai.DoActorMoveJump;
                return false;
            }
            case 802: {
                if (u.ActorActionSet.Jump == null) break;
                sp.ang = tpoint.ang;
                ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                u.jump_speed = tpoint.tag_high != 0 ? (short)(-tpoint.tag_high) : (short)-350;
                Actor.DoActorBeginJump(SpriteNum);
                u.ActorActionFunc = Ai.DoActorMoveJump;
                return false;
            }
            case 804: {
                if (u.ActorActionSet.Jump == null) break;
                ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                return false;
            }
            case 808: {
                if (u.Rot == u.ActorActionSet.Duck) break;
                sp.ang = tpoint.ang;
                ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                u.WaitTics = tpoint.tag_high == 0 ? (short)480 : (short)(tpoint.tag_high * 128);
                Ai.InitActorDuck.invoke(SpriteNum);
                u.ActorActionFunc = Ai.DoActorDuck;
                return false;
            }
            case 791: 
            case 807: {
                short nearsector = -1;
                short nearwall = -1;
                int nearsprite = -1;
                int nearhitdist = -1;
                if (u.Rot == u.ActorActionSet.Sit || u.Rot == u.ActorActionSet.Stand) {
                    return false;
                }
                sp.ang = tpoint.ang;
                ru.m210projects.Wang.Track.z[0] = sp.z - Gameutils.SPRITEp_SIZE_Z(sp) + Gameutils.Z(5);
                ru.m210projects.Wang.Track.z[1] = sp.z - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp));
                for (int i = 0; i < z.length; ++i) {
                    Main.engine.neartag(sp.x, sp.y, z[i], sp.sectnum, sp.ang, Engine.neartag, 1024, 3);
                    nearsector = Engine.neartag.tagsector;
                    nearwall = Engine.neartag.tagwall;
                    nearsprite = Engine.neartag.tagsprite;
                    nearhitdist = Engine.neartag.taghitdist;
                    if (nearsprite < 0 || nearhitdist >= 1024 || !Sector.OperateSprite(nearsprite, false)) continue;
                    u.WaitTics = tpoint.tag_high == 0 ? (short)240 : (short)(tpoint.tag_high * 128);
                    Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Stand);
                }
                if (nearsector >= 0 && nearhitdist < 1024 && Sector.OperateSector(nearsector, false)) {
                    u.WaitTics = tpoint.tag_high == 0 ? (short)240 : (short)(tpoint.tag_high * 128);
                    Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Sit);
                }
                if (nearwall < 0 || nearhitdist >= 1024 || !Sector.OperateWall(nearwall, false)) break;
                u.WaitTics = tpoint.tag_high == 0 ? (short)240 : (short)(tpoint.tag_high * 128);
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Stand);
                break;
            }
            case 797: {
                if (u.ActorActionSet.Jump == null || u.track_dir != 1) break;
                u.jump_speed = tpoint.tag_high == 0 ? (short)-384 : (short)(-tpoint.tag_high);
                Actor.DoActorBeginJump(SpriteNum);
                break;
            }
            case 798: {
                if (u.ActorActionSet.Jump == null || u.track_dir != -1) break;
                u.jump_speed = tpoint.tag_high == 0 ? (short)-384 : (short)(-tpoint.tag_high);
                Actor.DoActorBeginJump(SpriteNum);
                break;
            }
            case 772: {
                if (u.Rot != u.ActorActionSet.Crawl) {
                    Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Crawl);
                    break;
                }
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Rise);
                break;
            }
            case 773: {
                if (u.Rot != u.ActorActionSet.Swim) {
                    Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Swim);
                    break;
                }
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Rise);
                break;
            }
            case 774: {
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Fly);
                break;
            }
            case 776: {
                if (u.ActorActionSet.Sit == null) break;
                u.WaitTics = tpoint.tag_high == 0 ? (short)360 : (short)(tpoint.tag_high * 128);
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Sit);
                break;
            }
            case 777: {
                if (u.ActorActionSet.Death2 == null) break;
                u.WaitTics = (short)480;
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Death1);
                break;
            }
            case 778: {
                if (u.ActorActionSet.Death2 == null) break;
                u.WaitTics = (short)480;
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Death2);
                break;
            }
            case 779: {
                if (u.ActorActionSet.DeathJump == null) break;
                u.Flags |= Gameutils.SPR_DEAD;
                sp.xvel = (short)(sp.xvel << 1);
                u.jump_speed = (short)-495;
                Actor.DoActorBeginJump(SpriteNum);
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.DeathJump);
                break;
            }
            case 780: {
                if (u.ActorActionSet.CloseAttack[0] == null) break;
                u.WaitTics = tpoint.tag_high == 0 ? (short)240 : (short)(tpoint.tag_high * 128);
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.CloseAttack[0]);
                break;
            }
            case 781: {
                if (u.ActorActionSet.CloseAttack[1] == null) break;
                u.WaitTics = tpoint.tag_high == 0 ? (short)480 : (short)(tpoint.tag_high * 128);
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.CloseAttack[1]);
                break;
            }
            case 782: 
            case 783: 
            case 784: 
            case 785: 
            case 786: 
            case 787: {
                Sprites.StateGroup ap = u.ActorActionSet.Attack[tpoint.tag_low - 782];
                if (ap == null) break;
                u.WaitTics = tpoint.tag_high == 0 ? (short)480 : (short)(tpoint.tag_high * 128);
                Sprites.NewStateGroup(SpriteNum, ap);
                break;
            }
            case 759: {
                if (MyTypes.TEST(u.Flags, Gameutils.SPR_ZDIFF_MODE)) {
                    u.Flags &= ~Gameutils.SPR_ZDIFF_MODE;
                    sp.z = Engine.sector[sp.sectnum].floorz;
                    sp.zvel = 0;
                    break;
                }
                u.Flags |= Gameutils.SPR_ZDIFF_MODE;
                break;
            }
            case 792: {
                if (u.ActorActionSet.Jump == null) break;
                int lspi = Player.FindNearSprite(sp, 53);
                if (lspi == -1) {
                    ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                    return false;
                }
                SPRITE lsp = Engine.sprite[lspi];
                int nx = Gameutils.MOVEx(100, lsp.ang);
                int ny = Gameutils.MOVEy(100, lsp.ang);
                sp.x = lsp.x + nx;
                sp.y = lsp.y + ny;
                sp.ang = Gameutils.NORM_ANGLE(lsp.ang + 1024);
                Main.engine.neartag(sp.x, sp.y, Gameutils.SPRITEp_TOS(sp) - MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp)), sp.sectnum, sp.ang, Engine.neartag, 600, 3);
                short hitwall = Engine.neartag.tagwall;
                if (hitwall < 0) {
                    ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                    return false;
                }
                u.sz = Engine.sector[Engine.wall[hitwall].nextsector].floorz;
                Sprites.DoActorZrange(SpriteNum);
                sp.cstat = (short)(sp.cstat | Gameutils.CSTAT_SPRITE_YCENTER);
                int bos_z = Gameutils.SPRITEp_BOS(sp);
                if (bos_z > u.loz) {
                    u.sy = bos_z - sp.z;
                    sp.z -= u.sy;
                }
                u.Flags |= Gameutils.SPR_CLIMBING;
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Climb);
                sp.zvel = (short)(-Gameutils.Z(1));
                break;
            }
            case 793: {
                u.jump_speed = -tpoint.tag_high;
            }
        }
        return true;
    }

    public static boolean ActorFollowTrack(int SpriteNum, int locktics) {
        int dist;
        USER u = Gameutils.pUser[SpriteNum];
        SPRITE sp = Gameutils.pUser[SpriteNum].getSprite();
        int nx = 0;
        int ny = 0;
        int nz = 0;
        if (u.track == -1) {
            return true;
        }
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_WAIT_FOR_PLAYER | Gameutils.SPR_WAIT_FOR_TRIGGER)) {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_WAIT_FOR_PLAYER)) {
                short pnum = Mmulti.connecthead;
                while (pnum != -1) {
                    PlayerStr pp = Game.Player[pnum];
                    if (Game.Distance(sp.x, sp.y, pp.posx, pp.posy) < u.Dist) {
                        u.tgt_sp = pp.PlayerSprite;
                        u.Flags &= ~Gameutils.SPR_WAIT_FOR_PLAYER;
                        return true;
                    }
                    pnum = Mmulti.connectpoint2[pnum];
                }
            }
            u.Tics = 0;
            return true;
        }
        if (u.WaitTics != 0) {
            u.WaitTics = (short)(u.WaitTics - locktics);
            if (u.WaitTics <= 0) {
                u.Flags &= ~Gameutils.SPR_DONT_UPDATE_ANG;
                Sprites.NewStateGroup(SpriteNum, u.ActorActionSet.Run);
                u.WaitTics = 0;
            }
            return true;
        }
        TRACK_POINT tpoint = ru.m210projects.Wang.Track.Track[u.track].TrackPoint[u.point];
        if (tpoint == null) {
            return false;
        }
        if (!MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING | Gameutils.SPR_DONT_UPDATE_ANG)) {
            sp.ang = Main.engine.getangle(tpoint.x - sp.x, tpoint.y - sp.y);
        }
        if ((dist = Game.Distance(sp.x, sp.y, tpoint.x, tpoint.y)) < 200) {
            if (!ru.m210projects.Wang.Track.ActorTrackDecide(tpoint, SpriteNum)) {
                return true;
            }
            ru.m210projects.Wang.Track.NextActorTrackPoint(SpriteNum);
            tpoint = ru.m210projects.Wang.Track.Track[u.track].TrackPoint[u.point];
            if (!MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING | Gameutils.SPR_DONT_UPDATE_ANG)) {
                sp.ang = Main.engine.getangle(tpoint.x - sp.x, tpoint.y - sp.y);
            }
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_ZDIFF_MODE)) {
                int dx = tpoint.x;
                int dy = tpoint.y;
                int dz = tpoint.z;
                dist = Gameutils.DIST(dx, dy, sp.x, sp.y);
                sp.zvel = (short)(-(sp.xvel * (sp.z - dz) / dist));
            }
        } else {
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_SPEED_UP)) {
                if ((u.track_vel += locktics << u.vel_rate) >= u.vel_tgt) {
                    u.track_vel = u.vel_tgt;
                    u.Flags &= ~Gameutils.SPR_SPEED_UP;
                }
                sp.xvel = (short)MyTypes.DIV256(u.track_vel);
            } else if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLOW_DOWN)) {
                if ((u.track_vel -= locktics << u.vel_rate) <= u.vel_tgt) {
                    u.track_vel = u.vel_tgt;
                    u.Flags &= ~Gameutils.SOBJ_SLOW_DOWN;
                }
                sp.xvel = (short)MyTypes.DIV256(u.track_vel);
            }
            nx = 0;
            ny = 0;
            if (MyTypes.TEST(u.Flags, Gameutils.SPR_CLIMBING)) {
                if (Gameutils.SPRITEp_TOS(sp) + MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(sp)) < u.sz) {
                    u.Flags &= ~Gameutils.SPR_CLIMBING;
                    sp.zvel = 0;
                    sp.ang = Main.engine.getangle(tpoint.x - sp.x, tpoint.y - sp.y);
                    ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
                    sp.cstat = (short)(sp.cstat & ~Gameutils.CSTAT_SPRITE_YCENTER);
                    sp.z += u.sy;
                    Ai.DoActorSetSpeed(SpriteNum, 0);
                    u.ActorActionFunc = Ninja.NinjaJumpActionFunc;
                    u.jump_speed = (short)-650;
                    Actor.DoActorBeginJump(SpriteNum);
                    return true;
                }
            } else {
                nx = sp.xvel * Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] >> 14;
                ny = sp.xvel * Engine.sintable[sp.ang] >> 14;
            }
            nz = 0;
            if (sp.zvel != 0) {
                nz = sp.zvel * locktics;
            }
        }
        u.ret = Sprites.move_sprite(SpriteNum, nx, ny, nz, u.ceiling_dist, u.floor_dist, 0, locktics);
        if (u.ret != 0 && !MyTypes.TEST(u.Flags, Gameutils.SPR_JUMPING | Gameutils.SPR_FALLING)) {
            ru.m210projects.Wang.Track.ActorLeaveTrack(SpriteNum);
        }
        return true;
    }

    static {
        Track = new TRACK[100];
        end_point = new short[]{0, 0};
        StatList = new short[]{0, 1, 10, 57, 67, 65, 78, 39, 46, 68, 81, 56};
        z = new int[2];
    }
}

