/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Types;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;
import ru.m210projects.Witchaven.Menu.WHMenuUserContent;
import ru.m210projects.Witchaven.Types.ANIMATION;
import ru.m210projects.Witchaven.Types.EpisodeInfo;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.Types.SWINGDOOR;
import ru.m210projects.Witchaven.Whldsv;

public class SafeLoader {
    public String boardfilename;
    public int gAnimationCount = 0;
    public ANIMATION[] gAnimationData = new ANIMATION[512];
    public PLAYER[] plr = new PLAYER[16];
    public short[] pskyoff = new short[256];
    public short pskybits;
    public int parallaxyscale;
    public short connecthead;
    public short[] connectpoint2 = new short[16];
    public int randomseed;
    public boolean gUserMap;
    public int mapon;
    public int skill;
    public int thunderflash;
    public int thundertime;
    public int kills;
    public int killcnt;
    public int treasurescnt;
    public int treasuresfound;
    public int hours;
    public int minutes;
    public int seconds;
    public int victor = 0;
    public int autohoriz = 0;
    public int visibility;
    public byte automapping;
    public byte[] show2dsector = new byte[Engine.MAXSECTORS + 7 >> 3];
    public byte[] show2dwall = new byte[1024];
    public byte[] show2dsprite = new byte[Engine.MAXSPRITES + 7 >> 3];
    public short numsectors;
    public short numwalls;
    public short[] headspritesect;
    public short[] headspritestat;
    public short[] prevspritesect;
    public short[] prevspritestat;
    public short[] nextspritesect;
    public short[] nextspritestat;
    public SECTOR[] sector = new SECTOR[Engine.MAXSECTORS];
    public WALL[] wall = new WALL[Engine.MAXWALLS];
    public SPRITE[] sprite = new SPRITE[Engine.MAXSPRITES];
    public short[] skypanlist = new short[64];
    public short skypancnt;
    public short[] lavadrylandsector = new short[32];
    public short lavadrylandcnt;
    public short[] bobbingsectorlist = new short[16];
    public short bobbingsectorcnt;
    public short[] revolveclip = new short[16];
    public short[] revolvesector = new short[4];
    public short[] revolveang = new short[4];
    public short revolvecnt;
    public int[][] revolvex = new int[4][32];
    public int[][] revolvey = new int[4][32];
    public int[] revolvepivotx = new int[4];
    public int[] revolvepivoty = new int[4];
    public short[] warpsectorlist = new short[64];
    public short warpsectorcnt;
    public short[] xpanningsectorlist = new short[16];
    public short xpanningsectorcnt;
    public short[] ypanningwalllist = new short[128];
    public short ypanningwallcnt;
    public short[] floorpanninglist = new short[64];
    public short floorpanningcnt;
    public SWINGDOOR[] swingdoor = new SWINGDOOR[32];
    public short swingcnt;
    public short[] dragsectorlist = new short[16];
    public short[] dragxdir = new short[16];
    public short[] dragydir = new short[16];
    public short dragsectorcnt;
    public int[] dragx1 = new int[16];
    public int[] dragy1 = new int[16];
    public int[] dragx2 = new int[16];
    public int[] dragy2 = new int[16];
    public int[] dragfloorz = new int[16];
    public short[] ironbarsector = new short[16];
    public short ironbarscnt;
    public int[] ironbarsgoal1 = new int[16];
    public int[] ironbarsgoal2 = new int[16];
    public short[] ironbarsdone = new short[16];
    public short[] ironbarsanim = new short[16];
    public int[] ironbarsgoal = new int[16];
    public int floormirrorcnt;
    public short[] floormirrorsector = new short[64];
    public short[] arrowsprite = new short[100];
    public short[] throwpikesprite = new short[100];
    public byte[] ceilingshadearray = new byte[Engine.MAXSECTORS];
    public byte[] floorshadearray = new byte[Engine.MAXSECTORS];
    public byte[] wallshadearray = new byte[Engine.MAXWALLS];
    public int dropshieldcnt;
    public boolean droptheshield;
    public int warp_on;
    public EpisodeInfo addon;
    public boolean packedAddon;
    private String message;

    public SafeLoader() {
        int i;
        for (i = 0; i < 16; ++i) {
            this.plr[i] = new PLAYER();
        }
        this.headspritesect = new short[Engine.MAXSECTORS + 1];
        this.headspritestat = new short[1025];
        this.prevspritesect = new short[Engine.MAXSPRITES];
        this.prevspritestat = new short[Engine.MAXSPRITES];
        this.nextspritesect = new short[Engine.MAXSPRITES];
        this.nextspritestat = new short[Engine.MAXSPRITES];
        for (i = 0; i < 512; ++i) {
            this.gAnimationData[i] = new ANIMATION();
        }
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            this.sprite[i] = new SPRITE();
        }
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            this.sector[i] = new SECTOR();
        }
        for (i = 0; i < Engine.MAXWALLS; ++i) {
            this.wall[i] = new WALL();
        }
        for (i = 0; i < 32; ++i) {
            this.swingdoor[i] = new SWINGDOOR();
        }
    }

    public boolean load(Resource bb) {
        try {
            bb.seek(Whldsv.SAVEHEADER - 8, Resource.Whence.Set);
            this.addon = null;
            this.message = null;
            this.mapon = bb.readInt();
            this.skill = bb.readInt();
            bb.seek(Whldsv.SAVEHEADER, Resource.Whence.Set);
            this.LoadGDXBlock(bb);
            this.StuffLoad(bb);
            this.MapLoad(bb);
            this.SectorLoad(bb);
            this.AnimationLoad(bb);
            if (bb.position() == bb.size()) {
                if (this.warp_on == 2) {
                    this.addon = this.packedAddon ? WHMenuUserContent.getEpisode(BuildGdx.compat.checkFile(this.boardfilename)) : WHMenuUserContent.getEpisode(BuildGdx.compat.checkDirectory(this.boardfilename));
                    if (this.addon == null) {
                        this.message = "Can't find user episode file: " + this.boardfilename;
                        this.warp_on = 1;
                        this.mapon = 0;
                    }
                }
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void SectorLoad(Resource bb) {
        int i;
        for (i = 0; i < 64; ++i) {
            this.skypanlist[i] = bb.readShort();
        }
        this.skypancnt = bb.readShort();
        for (i = 0; i < 32; ++i) {
            this.lavadrylandsector[i] = bb.readShort();
        }
        this.lavadrylandcnt = bb.readShort();
        for (i = 0; i < 16; ++i) {
            this.dragsectorlist[i] = bb.readShort();
            this.dragxdir[i] = bb.readShort();
            this.dragydir[i] = bb.readShort();
            this.dragx1[i] = bb.readInt();
            this.dragy1[i] = bb.readInt();
            this.dragx2[i] = bb.readInt();
            this.dragy2[i] = bb.readInt();
            this.dragfloorz[i] = bb.readInt();
        }
        this.dragsectorcnt = bb.readShort();
        for (i = 0; i < 16; ++i) {
            this.bobbingsectorlist[i] = bb.readShort();
        }
        this.bobbingsectorcnt = bb.readShort();
        for (i = 0; i < 16; ++i) {
            this.warpsectorlist[i] = bb.readShort();
        }
        this.warpsectorcnt = bb.readShort();
        for (i = 0; i < 16; ++i) {
            this.xpanningsectorlist[i] = bb.readShort();
        }
        this.xpanningsectorcnt = bb.readShort();
        for (i = 0; i < 128; ++i) {
            this.ypanningwalllist[i] = bb.readShort();
        }
        this.ypanningwallcnt = bb.readShort();
        for (i = 0; i < 64; ++i) {
            this.floorpanninglist[i] = bb.readShort();
        }
        this.floorpanningcnt = bb.readShort();
        this.swingcnt = bb.readShort();
        for (i = 0; i < 32; ++i) {
            this.swingdoor[i].set(bb);
        }
        this.revolvecnt = bb.readShort();
        for (i = 0; i < 4; ++i) {
            this.revolvesector[i] = bb.readShort();
            this.revolveang[i] = bb.readShort();
            for (int j = 0; j < 32; ++j) {
                this.revolvex[i][j] = bb.readInt();
                this.revolvey[i][j] = bb.readInt();
            }
            this.revolvepivotx[i] = bb.readInt();
            this.revolvepivoty[i] = bb.readInt();
        }
        for (i = 0; i < 16; ++i) {
            this.revolveclip[i] = bb.readShort();
        }
        this.ironbarscnt = bb.readShort();
        for (i = 0; i < 16; ++i) {
            this.ironbarsector[i] = bb.readShort();
            this.ironbarsgoal[i] = bb.readInt();
            this.ironbarsgoal1[i] = bb.readInt();
            this.ironbarsgoal2[i] = bb.readInt();
            this.ironbarsdone[i] = bb.readShort();
            this.ironbarsanim[i] = bb.readShort();
        }
    }

    public void AnimationLoad(Resource bb) {
        for (int i = 0; i < 512; ++i) {
            short index = bb.readShort();
            byte type = bb.readByte();
            this.gAnimationData[i].id = index;
            this.gAnimationData[i].type = type;
            this.gAnimationData[i].ptr = null;
            this.gAnimationData[i].goal = bb.readInt();
            this.gAnimationData[i].vel = bb.readInt();
            this.gAnimationData[i].acc = bb.readInt();
        }
        this.gAnimationCount = bb.readInt();
    }

    public void StuffLoad(Resource bb) {
        int i;
        this.kills = bb.readInt();
        this.killcnt = bb.readInt();
        this.treasurescnt = bb.readInt();
        this.treasuresfound = bb.readInt();
        this.hours = bb.readInt();
        this.minutes = bb.readInt();
        this.seconds = bb.readInt();
        this.visibility = bb.readInt();
        this.thunderflash = bb.readInt();
        this.thundertime = bb.readInt();
        this.randomseed = bb.readInt();
        bb.read(this.show2dsector);
        bb.read(this.show2dwall);
        bb.read(this.show2dsprite);
        this.automapping = bb.readByte();
        this.pskybits = bb.readShort();
        this.parallaxyscale = bb.readInt();
        for (i = 0; i < 256; ++i) {
            this.pskyoff[i] = bb.readShort();
        }
        this.connecthead = bb.readShort();
        for (i = 0; i < 16; ++i) {
            this.connectpoint2[i] = bb.readShort();
        }
        for (i = 0; i < 16; ++i) {
            this.plr[i].set(bb);
        }
        this.dropshieldcnt = bb.readInt();
        this.droptheshield = bb.readByte() == 1;
        this.floormirrorcnt = bb.readInt();
        for (i = 0; i < 64; ++i) {
            this.floormirrorsector[i] = bb.readShort();
        }
        for (i = 0; i < 100; ++i) {
            this.arrowsprite[i] = bb.readShort();
        }
        for (i = 0; i < 100; ++i) {
            this.throwpikesprite[i] = bb.readShort();
        }
        for (i = 0; i < Engine.MAXSECTORS; ++i) {
            this.ceilingshadearray[i] = bb.readByte();
            this.floorshadearray[i] = bb.readByte();
        }
        for (i = 0; i < Engine.MAXWALLS; ++i) {
            this.wallshadearray[i] = bb.readByte();
        }
    }

    public void MapLoad(Resource bb) {
        int i;
        this.numwalls = bb.readShort();
        for (int w = 0; w < this.numwalls; ++w) {
            this.wall[w].buildWall(bb);
        }
        this.numsectors = bb.readShort();
        for (int s = 0; s < this.numsectors; ++s) {
            this.sector[s].buildSector(bb);
        }
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            this.sprite[i].buildSprite(bb);
        }
        for (i = 0; i <= Engine.MAXSECTORS; ++i) {
            this.headspritesect[i] = bb.readShort();
        }
        for (i = 0; i <= 1024; ++i) {
            this.headspritestat[i] = bb.readShort();
        }
        for (i = 0; i < Engine.MAXSPRITES; ++i) {
            this.prevspritesect[i] = bb.readShort();
            this.prevspritestat[i] = bb.readShort();
            this.nextspritesect[i] = bb.readShort();
            this.nextspritestat[i] = bb.readShort();
        }
    }

    public void LoadGDXBlock(Resource bb) {
        int pos = bb.position();
        bb.seek(pos + 16000, Resource.Whence.Set);
        this.warp_on = bb.readByte().byteValue();
        if (this.warp_on == 2) {
            this.packedAddon = bb.readBoolean();
        }
        this.boardfilename = null;
        String name = bb.readString(144).trim();
        if (!name.isEmpty()) {
            this.boardfilename = name;
        }
        bb.seek(pos + 16272, Resource.Whence.Set);
    }

    public EpisodeInfo LoadGDXHeader(Resource bb) {
        this.warp_on = 0;
        this.packedAddon = false;
        this.addon = null;
        this.boardfilename = null;
        try {
            bb.seek(Whldsv.SAVEHEADER - 8, Resource.Whence.Set);
            this.addon = null;
            this.message = null;
            this.mapon = bb.readInt();
            this.skill = bb.readInt();
            bb.seek(Whldsv.SAVEHEADER, Resource.Whence.Set);
            this.LoadGDXBlock(bb);
            if (this.warp_on == 2) {
                this.addon = this.packedAddon ? WHMenuUserContent.getEpisode(BuildGdx.compat.checkFile(this.boardfilename)) : WHMenuUserContent.getEpisode(BuildGdx.compat.checkDirectory(this.boardfilename));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.addon;
    }

    public String getMessage() {
        return this.message;
    }
}

