/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.backends.lwjgl3.RawMouseLwjgl3Input;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.controllers.JControllerManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.m210projects.Build.Architecture.common.ResolutionUtils;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.settings.ApplicationContext;

public class LwjglApplicationContext
extends ApplicationContext {
    private final Application application;

    public LwjglApplicationContext(Application application) {
        this.application = application;
    }

    @Override
    public void setControllerListener(GameProcessor processor) {
        Controllers.preferredManager = JControllerManager.class.getName();
        Controllers.addListener(processor);
    }

    @Override
    public void setScreenMode(int width, int height, boolean fullscreen) {
        if (fullscreen) {
            Graphics.DisplayMode mode;
            String configResolution = ResolutionUtils.getDisplayModeAsString(width, height);
            Map<String, List<Graphics.DisplayMode>> resolutions = this.getResolutions();
            Optional<Graphics.DisplayMode> displayMode = ((List)resolutions.getOrDefault(configResolution, new ArrayList())).stream().max(Comparator.comparingInt(a -> a.refreshRate));
            this.fullscreen = displayMode.isPresent();
            if (this.fullscreen && Gdx.graphics.setFullscreenMode(mode = displayMode.get())) {
                super.setScreenMode(mode.width, mode.height, true);
                return;
            }
        }
        Gdx.graphics.setWindowedMode(width, height);
        super.setScreenMode(width, height, false);
    }

    @Override
    public Map<String, List<Graphics.DisplayMode>> getResolutions() {
        return ResolutionUtils.getDisplayModes(Gdx.graphics.getDisplayModes());
    }

    @Override
    public boolean onRawInputChanged(boolean rawInput) {
        Input input = this.application.getInput();
        if (input instanceof RawMouseLwjgl3Input) {
            return ((RawMouseLwjgl3Input)input).setRawInput(rawInput);
        }
        return false;
    }

    @Override
    public boolean isRawInputSupported() {
        Input input = this.application.getInput();
        if (input instanceof RawMouseLwjgl3Input) {
            return ((RawMouseLwjgl3Input)input).isRawInputSupported();
        }
        return false;
    }
}

