/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.awt;

import java.awt.Image;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import ru.m210projects.Build.Architecture.DialogUtil;
import ru.m210projects.Build.Architecture.MessageType;

public class AWTDialog
implements DialogUtil.DialogBox {
    private final List<Image> icons = new ArrayList<Image>();

    public AWTDialog(String[] iconPaths) {
        if (iconPaths != null) {
            for (String icon : iconPaths) {
                this.icons.add(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(icon)));
            }
        }
    }

    public void setIconImages(List<Image> icons) {
        this.icons.addAll(icons);
    }

    @Override
    public DialogUtil.DialogResult showMessage(String header, String message, MessageType type) {
        int messageType = 1;
        int optionType = -1;
        switch (type) {
            case Question: {
                messageType = 3;
                optionType = 0;
                break;
            }
            case Error: {
                messageType = 0;
                break;
            }
            case Crash: {
                messageType = 0;
                optionType = 0;
            }
        }
        JOptionPane panel = new JOptionPane();
        panel.setMessageType(messageType);
        if (type == MessageType.Crash) {
            panel.setMessage(message + "\r\nYou might leave comment what's happen.");
            panel.setWantsInput(true);
        } else {
            panel.setMessage(message);
        }
        panel.setOptionType(optionType);
        JDialog dialog = panel.createDialog(header);
        if (!this.icons.isEmpty()) {
            dialog.setIconImages(this.icons);
        }
        panel.setBackground(dialog.getBackground());
        dialog.setAlwaysOnTop(true);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
        String comment = "";
        boolean approved = false;
        if (Objects.equals(0, panel.getValue())) {
            Object inputValue = panel.getInputValue();
            if (inputValue instanceof String) {
                comment = (String)inputValue;
            }
            approved = true;
        }
        return new DialogUtil.DialogResult(comment, approved);
    }
}

