/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.awt;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.awt.AWTApplication;
import com.badlogic.gdx.backends.awt.AWTWindow;
import com.badlogic.gdx.backends.lwjgl3.AWTApplicationConfiguration;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.GL31;
import com.badlogic.gdx.graphics.GL32;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class AWTGraphics
implements Graphics {
    private final ComponentAdapter resizeCallback = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent evt) {
            if (AWTGraphics.this.fullscreen || !AWTGraphics.this.raster.isResizable()) {
                return;
            }
            Dimension size = AWTGraphics.this.raster.getSize();
            if (AWTApplication.hdpiMode == HdpiMode.Pixels) {
                size.setSize(size.getWidth() / (double)AWTGraphics.this.window.scaleFactor, size.getHeight() / (double)AWTGraphics.this.window.scaleFactor);
            }
            AWTGraphics.this.updateFramebufferInfo(size.width, size.height);
        }
    };
    protected AWTWindow window;
    Raster raster;
    private volatile int backBufferWidth;
    private volatile int backBufferHeight;
    private volatile int logicalWidth;
    private volatile int logicalHeight;
    private long lastFrameTime = -1L;
    private float deltaTime;
    private boolean resetDeltaTime = false;
    private long frameId;
    private long frameCounterStart = 0L;
    private int frames;
    private int fps;
    private int windowPosXBeforeFullscreen;
    private int windowPosYBeforeFullscreen;
    private int windowWidthBeforeFullscreen;
    private int windowHeightBeforeFullscreen;
    private Graphics.BufferFormat bufferFormat;
    private volatile boolean isContinuous = true;
    private Graphics.DisplayMode displayModeBeforeFullscreen;
    private boolean fullscreen;

    public AWTGraphics(AWTWindow window) {
        this.window = window;
        com.badlogic.gdx.graphics.Color color = window.getConfig().getInitialBackgroundColor();
        this.raster = new Raster(new Color(color.r, color.g, color.b, color.a));
        AWTApplicationConfiguration config = window.getConfig();
        if (config.isWindowResizable()) {
            this.raster.addComponentListener(this.resizeCallback);
        }
        window.getWindowHandle().add(this.raster);
        this.updateFramebufferInfo(config.getWidth(), config.getHeight());
    }

    void updateFramebufferInfo(int width, int height) {
        AWTApplicationConfiguration config = this.window.getConfig();
        this.backBufferWidth = width;
        this.backBufferHeight = height;
        if (this.fullscreen) {
            this.logicalWidth = this.backBufferWidth;
            this.logicalHeight = this.backBufferHeight;
        } else {
            this.logicalWidth = (int)((float)this.backBufferWidth * this.window.scaleFactor);
            this.logicalHeight = (int)((float)this.backBufferHeight * this.window.scaleFactor);
        }
        this.bufferFormat = new Graphics.BufferFormat(config.getR(), config.getG(), config.getB(), config.getA(), config.getDepth(), config.getStencil(), config.getSamples(), false);
        this.raster.update(this.logicalWidth, this.logicalHeight);
        this.window.getWindowHandle().pack();
        this.window.getWindowHandle().requestFocus();
        this.window.getWindowHandle().toFront();
    }

    public void repaint() {
        this.raster.repaint();
    }

    public void update() {
        long time = System.nanoTime();
        if (this.lastFrameTime == -1L) {
            this.lastFrameTime = time;
        }
        if (this.resetDeltaTime) {
            this.resetDeltaTime = false;
            this.deltaTime = 0.0f;
        } else {
            this.deltaTime = (float)(time - this.lastFrameTime) / 1.0E9f;
        }
        this.lastFrameTime = time;
        if (time - this.frameCounterStart >= 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameCounterStart = time;
        }
        ++this.frames;
        ++this.frameId;
    }

    @Override
    public int getWidth() {
        return this.backBufferWidth;
    }

    @Override
    public int getHeight() {
        return this.backBufferHeight;
    }

    @Override
    public int getBackBufferWidth() {
        return this.backBufferWidth;
    }

    @Override
    public int getBackBufferHeight() {
        return this.backBufferHeight;
    }

    @Override
    public float getBackBufferScale() {
        return this.window.scaleFactor;
    }

    @Override
    public int getSafeInsetLeft() {
        return 0;
    }

    @Override
    public int getSafeInsetTop() {
        return 0;
    }

    @Override
    public int getSafeInsetBottom() {
        return 0;
    }

    @Override
    public int getSafeInsetRight() {
        return 0;
    }

    public int getLogicalWidth() {
        return this.logicalWidth;
    }

    public int getLogicalHeight() {
        return this.logicalHeight;
    }

    @Override
    public long getFrameId() {
        return this.frameId;
    }

    @Override
    public float getDeltaTime() {
        return this.deltaTime;
    }

    @Override
    @Deprecated
    public float getRawDeltaTime() {
        return 0.0f;
    }

    @Override
    public int getFramesPerSecond() {
        return this.fps;
    }

    @Override
    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.LWJGL3;
    }

    @Override
    public float getPpiX() {
        return this.getPpcX() * 2.54f;
    }

    @Override
    public float getPpiY() {
        return this.getPpcY() * 2.54f;
    }

    @Override
    public float getPpcX() {
        float pixelPerMm = (float)Toolkit.getDefaultToolkit().getScreenResolution() / 2.54f;
        Graphics.DisplayMode mode = this.getDisplayMode();
        int sizeX = (int)((float)mode.width / pixelPerMm * 10.0f);
        return (float)mode.width / (float)sizeX * 10.0f;
    }

    @Override
    public float getPpcY() {
        float pixelPerMm = (float)Toolkit.getDefaultToolkit().getScreenResolution() / 2.54f;
        Graphics.DisplayMode mode = this.getDisplayMode();
        int sizeY = (int)((float)mode.height / pixelPerMm * 10.0f);
        return (float)mode.height / (float)sizeY * 10.0f;
    }

    @Override
    public boolean supportsDisplayModeChange() {
        AWTMonitor monitor = (AWTMonitor)this.getMonitor();
        return monitor.getMonitorHandle().isDisplayChangeSupported();
    }

    @Override
    public Graphics.Monitor getPrimaryMonitor() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        Rectangle bounds = gc.getBounds();
        return new AWTMonitor(gd, bounds.x, bounds.y, gd.getIDstring());
    }

    @Override
    public Graphics.Monitor getMonitor() {
        Graphics.Monitor[] monitors = this.getMonitors();
        Graphics.Monitor result = monitors[0];
        JFrame windowHandle = this.window.getWindowHandle();
        int windowX = windowHandle.getX();
        int windowY = windowHandle.getY();
        int windowWidth = windowHandle.getWidth();
        int windowHeight = windowHandle.getHeight();
        int bestOverlap = 0;
        for (Graphics.Monitor monitor : monitors) {
            Graphics.DisplayMode mode = this.getDisplayMode(monitor);
            int overlap = Math.max(0, Math.min(windowX + windowWidth, monitor.virtualX + mode.width) - Math.max(windowX, monitor.virtualX)) * Math.max(0, Math.min(windowY + windowHeight, monitor.virtualY + mode.height) - Math.max(windowY, monitor.virtualY));
            if (bestOverlap >= overlap) continue;
            bestOverlap = overlap;
            result = monitor;
        }
        return result;
    }

    @Override
    public Graphics.Monitor[] getMonitors() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Graphics.Monitor[] monitors = new Graphics.Monitor[gs.length];
        for (int i = 0; i < monitors.length; ++i) {
            GraphicsDevice gd = gs[i];
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle bounds = gc.getBounds();
            monitors[i] = new AWTMonitor(gd, bounds.x, bounds.y, gd.getIDstring());
        }
        return monitors;
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes() {
        return this.getDisplayModes(this.getMonitor());
    }

    @Override
    public Graphics.DisplayMode[] getDisplayModes(Graphics.Monitor monitor) {
        DisplayMode[] videoModes = ((AWTMonitor)monitor).getMonitorHandle().getDisplayModes();
        LinkedHashSet<AWTDisplayMode> modes = new LinkedHashSet<AWTDisplayMode>();
        for (DisplayMode videoMode : videoModes) {
            modes.add(new AWTDisplayMode((AWTMonitor)monitor, videoMode.getWidth(), videoMode.getHeight(), videoMode.getRefreshRate(), videoMode.getBitDepth()));
        }
        Graphics.DisplayMode[] result = new Graphics.DisplayMode[modes.size()];
        modes.toArray(result);
        Arrays.sort(result, Comparator.comparingInt(mode -> mode.width).thenComparingInt(mode -> mode.height).thenComparingInt(mode -> mode.refreshRate));
        return result;
    }

    @Override
    public Graphics.DisplayMode getDisplayMode() {
        return this.getDisplayMode(this.getMonitor());
    }

    @Override
    public Graphics.DisplayMode getDisplayMode(Graphics.Monitor monitor) {
        DisplayMode mode = ((AWTMonitor)monitor).getMonitorHandle().getDisplayMode();
        return new AWTDisplayMode((AWTMonitor)monitor, mode.getWidth(), mode.getHeight(), mode.getRefreshRate(), mode.getBitDepth());
    }

    @Override
    public boolean setFullscreenMode(Graphics.DisplayMode displayMode) {
        GraphicsDevice device;
        this.window.getInput().resetPollingStates();
        AWTDisplayMode newMode = (AWTDisplayMode)displayMode;
        if (!this.isFullscreen()) {
            this.storeCurrentWindowPositionAndDisplayMode();
        }
        if (!(device = newMode.getMonitor().getMonitorHandle()).isFullScreenSupported()) {
            return false;
        }
        this.raster.setResizable(false);
        this.window.getWindowHandle().dispose();
        this.window.getWindowHandle().setUndecorated(true);
        this.window.getWindowHandle().setVisible(true);
        device.setFullScreenWindow(this.window.getWindowHandle());
        if (device.isDisplayChangeSupported()) {
            this.fullscreen = true;
            device.setDisplayMode(new DisplayMode(newMode.width, newMode.height, newMode.bitsPerPixel, newMode.refreshRate));
            this.updateFramebufferInfo(newMode.width, newMode.height);
            this.setVSync(this.window.getConfig().isVSyncEnabled());
        }
        this.raster.setResizable(true);
        return this.fullscreen;
    }

    private void storeCurrentWindowPositionAndDisplayMode() {
        this.windowPosXBeforeFullscreen = this.window.getPositionX();
        this.windowPosYBeforeFullscreen = this.window.getPositionY();
        this.windowWidthBeforeFullscreen = this.logicalWidth;
        this.windowHeightBeforeFullscreen = this.logicalHeight;
        this.displayModeBeforeFullscreen = this.getDisplayMode();
    }

    @Override
    public boolean setWindowedMode(int width, int height) {
        this.raster.setResizable(false);
        this.window.getInput().resetPollingStates();
        GraphicsDevice device = ((AWTMonitor)this.getMonitor()).getMonitorHandle();
        if (!this.isFullscreen()) {
            this.window.getWindowHandle().setLocationRelativeTo(null);
        } else {
            this.setUndecorated(!this.window.getConfig().isWindowDecorated());
            if (device.isFullScreenSupported()) {
                device.setFullScreenWindow(null);
            }
            if (this.displayModeBeforeFullscreen == null) {
                this.storeCurrentWindowPositionAndDisplayMode();
            }
            int x = this.windowPosXBeforeFullscreen;
            int y = this.windowPosYBeforeFullscreen;
            if (width != this.windowWidthBeforeFullscreen || height != this.windowHeightBeforeFullscreen) {
                GraphicsConfiguration gc = device.getDefaultConfiguration();
                Rectangle bounds = gc.getBounds();
                x = Math.max(0, bounds.x + (bounds.width - width) / 2);
                y = Math.max(0, bounds.y + (bounds.height - height) / 2);
            }
            this.window.setPosition(x, y);
        }
        this.fullscreen = false;
        this.updateFramebufferInfo(width, height);
        this.raster.setResizable(true);
        return true;
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.window.getWindowHandle().setTitle(title);
    }

    @Override
    public void setUndecorated(boolean undecorated) {
        this.window.getConfig().setDecorated(!undecorated);
        JFrame windowHandle = this.window.getWindowHandle();
        if (windowHandle.isUndecorated() == undecorated) {
            return;
        }
        windowHandle.dispose();
        windowHandle.setUndecorated(undecorated);
        windowHandle.setVisible(true);
    }

    @Override
    public void setResizable(boolean resizable) {
        this.window.getConfig().setResizable(resizable);
        this.window.getWindowHandle().setResizable(resizable);
    }

    @Override
    public void setVSync(boolean vsync) {
        this.window.getConfig().useVsync(vsync);
    }

    @Override
    public void setForegroundFPS(int fps) {
        this.window.getConfig().setForegroundFPS(fps);
    }

    @Override
    public Graphics.BufferFormat getBufferFormat() {
        return this.bufferFormat;
    }

    @Override
    public boolean isContinuousRendering() {
        return this.isContinuous;
    }

    @Override
    public void setContinuousRendering(boolean isContinuous) {
        this.isContinuous = isContinuous;
    }

    @Override
    public void requestRendering() {
        this.window.requestRendering();
    }

    @Override
    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void dispose() {
        this.raster.removeComponentListener(this.resizeCallback);
        this.window.getWindowHandle().setVisible(false);
        this.window.getWindowHandle().dispose();
    }

    @Override
    public Cursor newCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
        return null;
    }

    @Override
    public void setCursor(Cursor cursor) {
    }

    @Override
    public void setSystemCursor(Cursor.SystemCursor systemCursor) {
    }

    @Override
    public float getDensity() {
        float ppiX = this.getPpiX();
        return ppiX > 0.0f && ppiX <= Float.MAX_VALUE ? ppiX / 160.0f : 1.0f;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return false;
    }

    @Override
    public boolean isGL30Available() {
        return false;
    }

    @Override
    public boolean isGL31Available() {
        return false;
    }

    @Override
    public boolean isGL32Available() {
        return false;
    }

    @Override
    public GL20 getGL20() {
        return null;
    }

    @Override
    public void setGL20(GL20 gl20) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GL30 getGL30() {
        return null;
    }

    @Override
    public void setGL30(GL30 gl30) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GL31 getGL31() {
        return null;
    }

    @Override
    public void setGL31(GL31 gl31) {
    }

    @Override
    public GL32 getGL32() {
        return null;
    }

    @Override
    public void setGL32(GL32 gl32) {
    }

    @Override
    public GLVersion getGLVersion() {
        return null;
    }

    public byte[] getFrameBuffer() {
        return this.raster.getFrameBuffer();
    }

    public void changePalette(byte[] palette) {
        this.raster.changePalette(palette);
    }

    class Raster
    extends JPanel {
        private final Color background;
        private BufferedImage display;
        private byte[] data;
        private IndexColorModel paletteModel;
        private int width;
        private int height;
        private boolean resizable = true;

        public Raster(Color background) {
            this.background = background;
            this.paletteModel = new IndexColorModel(8, 256, new byte[768], 0, false);
            this.display = new BufferedImage(1, 1, 13, this.paletteModel);
            this.data = ((DataBufferByte)this.display.getRaster().getDataBuffer()).getData();
            this.setFocusable(false);
        }

        @Override
        public void update(java.awt.Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(java.awt.Graphics g) {
            g.drawImage(this.display, 0, 0, null);
        }

        public byte[] getFrameBuffer() {
            return this.data;
        }

        public void changePalette(byte[] palette) {
            this.paletteModel = new IndexColorModel(8, 256, palette, 0, false);
            this.display = new BufferedImage(this.paletteModel, this.display.getRaster(), false, null);
        }

        public void update(int width, int height) {
            if (this.width == width && this.height == height) {
                return;
            }
            this.width = width;
            this.height = height;
            Dimension size = new Dimension(width, height);
            this.setSize(size);
            this.setPreferredSize(size);
            this.setBackground(this.background);
            this.display = new BufferedImage(AWTGraphics.this.backBufferWidth, AWTGraphics.this.backBufferHeight, 13, this.paletteModel);
            this.data = ((DataBufferByte)this.display.getRaster().getDataBuffer()).getData();
            this.validate();
            if (AWTGraphics.this.window.isListenerInitialized()) {
                Gdx.app.postRunnable(() -> {
                    AWTGraphics.this.window.makeCurrent();
                    AWTGraphics.this.window.getListener().resize(AWTGraphics.this.backBufferWidth, AWTGraphics.this.backBufferHeight);
                    AWTGraphics.this.window.getListener().render();
                });
            }
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public void setResizable(boolean resizable) {
            this.resizable = resizable;
        }
    }

    private static class AWTMonitor
    extends Graphics.Monitor {
        private final GraphicsDevice monitorHandle;

        AWTMonitor(GraphicsDevice monitorHandle, int virtualX, int virtualY, String name) {
            super(virtualX, virtualY, name);
            this.monitorHandle = monitorHandle;
        }

        public GraphicsDevice getMonitorHandle() {
            return this.monitorHandle;
        }
    }

    private static class AWTDisplayMode
    extends Graphics.DisplayMode {
        final AWTMonitor monitorHandle;

        public AWTDisplayMode(AWTMonitor monitorHandle, int width, int height, int refreshRate, int bitsPerPixel) {
            super(width, height, refreshRate, bitsPerPixel);
            this.monitorHandle = monitorHandle;
        }

        public AWTMonitor getMonitor() {
            return this.monitorHandle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AWTDisplayMode)) {
                return false;
            }
            AWTDisplayMode that = (AWTDisplayMode)o;
            return Objects.equals(this.monitorHandle, that.monitorHandle) && this.width == that.width && this.height == that.height && this.refreshRate == that.refreshRate && this.bitsPerPixel == that.bitsPerPixel;
        }

        public int hashCode() {
            return Objects.hash(this.monitorHandle, this.width, this.height, this.refreshRate, this.bitsPerPixel);
        }
    }
}

