/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.awt;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.awt.AWTApplication;
import com.badlogic.gdx.backends.awt.AWTGraphics;
import com.badlogic.gdx.backends.awt.AWTMouse;
import com.badlogic.gdx.backends.awt.AWTWindow;
import com.badlogic.gdx.backends.awt.Mouse;
import com.badlogic.gdx.backends.awt.WinMouse;
import com.badlogic.gdx.backends.lwjgl3.RawInputEventQueue;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.input.NativeInputConfiguration;
import com.badlogic.gdx.utils.IntSet;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import javax.swing.JFrame;
import org.lwjgl.system.Platform;
import ru.m210projects.Build.exceptions.InitializationException;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class AWTInput
implements Input {
    public static final int MAX_KEYCODE = 255;
    protected final boolean[] pressedKeys;
    protected final boolean[] justPressedKeys;
    final RawInputEventQueue eventQueue;
    final boolean[] justPressedButtons = new boolean[5];
    private final IntSet keysToCatch = new IntSet();
    private final Mouse mouse;
    protected int pressedKeyCount;
    protected boolean keyJustPressed;
    AWTWindow window;
    int mouseX;
    int mouseY;
    int logicalMouseX;
    int logicalMouseY;
    int virtualX;
    int virtualY;
    int mousePressed;
    int deltaX;
    int deltaY;
    boolean justTouched;
    boolean caught = false;
    boolean lastCaught = false;
    char lastCharacter;
    int buttonCount;
    IntSet pressedButtons = new IntSet();
    KeyListener keyCallback = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
            AWTInput.this.lastCharacter = e.getKeyChar();
            AWTInput.this.window.getGraphics().requestRendering();
            AWTInput.this.eventQueue.keyTyped(AWTInput.this.lastCharacter, System.nanoTime());
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int key = AWTInput.this.translateKeyCode(e);
            if (AWTInput.this.pressedKeys[key]) {
                return;
            }
            AWTInput.this.eventQueue.keyDown(key, System.nanoTime());
            ++AWTInput.this.pressedKeyCount;
            AWTInput.this.keyJustPressed = true;
            AWTInput.this.pressedKeys[key] = true;
            AWTInput.this.justPressedKeys[key] = true;
            AWTInput.this.window.getGraphics().requestRendering();
            AWTInput.this.lastCharacter = '\u0000';
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int key = AWTInput.this.translateKeyCode(e);
            --AWTInput.this.pressedKeyCount;
            AWTInput.this.pressedKeys[key] = false;
            AWTInput.this.window.getGraphics().requestRendering();
            AWTInput.this.eventQueue.keyUp(key, System.nanoTime());
        }
    };
    MouseMotionListener cursorPosCallback = new MouseMotionListener(){

        @Override
        public void mouseDragged(MouseEvent e) {
            AWTInput.this.updateCursorPosition(e.getX(), e.getY());
            AWTInput.this.eventQueue.touchDragged(AWTInput.this.deltaX, AWTInput.this.deltaY, 0, System.nanoTime());
            this.setCursorToCenter(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            AWTInput.this.updateCursorPosition(e.getX(), e.getY());
            AWTInput.this.eventQueue.mouseMoved(AWTInput.this.deltaX, AWTInput.this.deltaY, System.nanoTime());
            this.setCursorToCenter(e);
        }

        private void setCursorToCenter(MouseEvent e) {
            JFrame windowHandle;
            if (AWTInput.this.caught && AWTInput.this.window.focused && ((Component)(windowHandle = AWTInput.this.window.getWindowHandle())).isShowing()) {
                int centerX = AWTInput.this.window.getGraphics().getWidth() / 2;
                int centerY = AWTInput.this.window.getGraphics().getHeight() / 2;
                if (e.getX() != centerX || e.getY() != centerY) {
                    AWTInput.this.setCursorPosition(centerX, centerY);
                }
            }
        }
    };
    MouseAdapter mouseButtonCallback = new MouseAdapter(){

        private int toGdxButton(int button) {
            if (button == 1) {
                return 0;
            }
            if (button == 2) {
                return 2;
            }
            if (button == 3) {
                return 1;
            }
            if (button == 4) {
                return 3;
            }
            if (button == 5) {
                return 4;
            }
            return -1;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            AWTInput.this.window.getGraphics().requestRendering();
            AWTInput.this.eventQueue.scrolled(0.0f, e.getWheelRotation(), System.nanoTime());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int button = e.getButton();
            int gdxButton = this.toGdxButton(button);
            if (button != -1 && gdxButton == -1) {
                return;
            }
            long time = System.nanoTime();
            ++AWTInput.this.mousePressed;
            AWTInput.this.justTouched = true;
            AWTInput.this.justPressedButtons[gdxButton] = true;
            AWTInput.this.pressedButtons.add(gdxButton);
            AWTInput.this.window.getGraphics().requestRendering();
            AWTInput.this.eventQueue.touchDown(AWTInput.this.getX(), AWTInput.this.getY(), 0, gdxButton, time);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int button = e.getButton();
            int gdxButton = this.toGdxButton(button);
            if (button != -1 && gdxButton == -1) {
                return;
            }
            long time = System.nanoTime();
            AWTInput.this.mousePressed = Math.max(0, AWTInput.this.mousePressed - 1);
            AWTInput.this.pressedButtons.remove(gdxButton);
            AWTInput.this.window.getGraphics().requestRendering();
            AWTInput.this.eventQueue.touchUp(AWTInput.this.getX(), AWTInput.this.getY(), 0, gdxButton, time);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AWTInput.this.updateCursorPosition(e.getX(), e.getY());
            AWTInput.this.window.activated = true;
            if (AWTInput.this.window.focused) {
                AWTInput.this.mouse.setCursorVisible(false);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AWTInput.this.window.activated = false;
        }
    };
    private InputProcessor inputProcessor;

    public AWTInput(AWTWindow window) {
        this.window = window;
        this.pressedKeys = new boolean[256];
        this.justPressedKeys = new boolean[256];
        this.eventQueue = new RawInputEventQueue();
        this.buttonCount = MouseInfo.getNumberOfButtons();
        this.mouse = this.createMouse(window);
        this.resetPollingStates();
        window.getWindowHandle().setFocusTraversalKeysEnabled(false);
        window.getWindowHandle().addKeyListener(this.keyCallback);
        window.getGraphics().raster.addMouseListener(this.mouseButtonCallback);
        window.getGraphics().raster.addMouseMotionListener(this.cursorPosCallback);
        window.getGraphics().raster.addMouseWheelListener(this.mouseButtonCallback);
    }

    private Mouse createMouse(AWTWindow window) {
        try {
            if (Platform.get() == Platform.WINDOWS) {
                return new WinMouse(window);
            }
        }
        catch (InitializationException e) {
            Console.out.println("Error to initialize windows mouse", OsdColor.RED);
        }
        return new AWTMouse(window);
    }

    private void updateCursorPosition(int x, int y) {
        if (this.checkCaught(x, y)) {
            x = this.mouseX;
            y = this.mouseY;
        }
        this.deltaX = x - this.logicalMouseX;
        this.deltaY = y - this.logicalMouseY;
        this.mouseX = this.logicalMouseX = x;
        this.mouseY = this.logicalMouseY = y;
        if (AWTApplication.hdpiMode == HdpiMode.Pixels) {
            float xScale = (float)this.window.getGraphics().getBackBufferWidth() / (float)this.window.getGraphics().getLogicalWidth();
            float yScale = (float)this.window.getGraphics().getBackBufferHeight() / (float)this.window.getGraphics().getLogicalHeight();
            this.deltaX = (int)((float)this.deltaX * xScale);
            this.deltaY = (int)((float)this.deltaY * yScale);
            this.mouseX = (int)((float)this.mouseX * xScale);
            this.mouseY = (int)((float)this.mouseY * yScale);
        }
        if (this.caught) {
            this.virtualX += this.deltaX;
            this.virtualY += this.deltaY;
        }
        this.window.getGraphics().requestRendering();
    }

    public void pollEvents() {
    }

    private boolean checkCaught(int x, int y) {
        Rectangle frame;
        if (this.caught && this.window.focused && !(frame = this.window.getGraphics().raster.getBounds()).contains(x, y)) {
            this.setCursorCatched(true);
            return true;
        }
        return false;
    }

    public void resetPollingStates() {
        this.justTouched = false;
        this.keyJustPressed = false;
        Arrays.fill(this.justPressedKeys, false);
        Arrays.fill(this.justPressedButtons, false);
        this.eventQueue.drain(null);
    }

    public void update() {
        this.eventQueue.drain(this.inputProcessor);
    }

    public void prepareNext() {
        if (this.justTouched) {
            this.justTouched = false;
            Arrays.fill(this.justPressedButtons, false);
        }
        if (this.keyJustPressed) {
            this.keyJustPressed = false;
            Arrays.fill(this.justPressedKeys, false);
        }
        this.deltaX = 0;
        this.deltaY = 0;
    }

    @Override
    public int getMaxPointers() {
        return 1;
    }

    @Override
    public int getX() {
        if (this.caught) {
            return this.virtualX;
        }
        return this.mouseX;
    }

    @Override
    public int getX(int pointer) {
        return pointer == 0 ? this.getX() : 0;
    }

    @Override
    public int getDeltaX() {
        return this.deltaX;
    }

    @Override
    public int getDeltaX(int pointer) {
        return pointer == 0 ? this.getDeltaX() : 0;
    }

    @Override
    public int getY() {
        if (this.caught) {
            return this.virtualY;
        }
        return this.mouseY;
    }

    @Override
    public int getY(int pointer) {
        return pointer == 0 ? this.getY() : 0;
    }

    @Override
    public int getDeltaY() {
        return this.deltaY;
    }

    @Override
    public int getDeltaY(int pointer) {
        return pointer == 0 ? this.getDeltaY() : 0;
    }

    @Override
    public boolean isTouched() {
        return this.mousePressed > 0;
    }

    @Override
    public boolean justTouched() {
        return this.justTouched;
    }

    @Override
    public boolean isTouched(int pointer) {
        return pointer == 0 && this.isTouched();
    }

    @Override
    public float getPressure() {
        return this.getPressure(0);
    }

    @Override
    public float getPressure(int pointer) {
        return this.isTouched(pointer) ? 1.0f : 0.0f;
    }

    @Override
    public boolean isButtonPressed(int button) {
        return this.pressedButtons.contains(button);
    }

    @Override
    public boolean isButtonJustPressed(int button) {
        if (button < 0 || button >= this.justPressedButtons.length) {
            return false;
        }
        return this.justPressedButtons[button];
    }

    @Override
    public boolean isKeyPressed(int key) {
        if (key == -1) {
            return this.pressedKeyCount > 0;
        }
        if (key < 0 || key > 255) {
            return false;
        }
        return this.pressedKeys[key];
    }

    @Override
    public boolean isKeyJustPressed(int key) {
        if (key == -1) {
            return this.keyJustPressed;
        }
        if (key < 0 || key > 255) {
            return false;
        }
        return this.justPressedKeys[key];
    }

    @Override
    public void setCatchKey(int keycode, boolean catchKey) {
        if (!catchKey) {
            this.keysToCatch.remove(keycode);
        } else {
            this.keysToCatch.add(keycode);
        }
    }

    @Override
    public boolean isCatchKey(int keycode) {
        return this.keysToCatch.contains(keycode);
    }

    @Override
    public void getTextInput(Input.TextInputListener listener, String title, String text, String hint) {
        listener.canceled();
    }

    @Override
    public void getTextInput(Input.TextInputListener listener, String title, String text, String hint, Input.OnscreenKeyboardType type) {
    }

    @Override
    public long getCurrentEventTime() {
        return this.eventQueue.getCurrentEventTime();
    }

    @Override
    public InputProcessor getInputProcessor() {
        return this.inputProcessor;
    }

    @Override
    public void setInputProcessor(InputProcessor processor) {
        this.inputProcessor = processor;
    }

    @Override
    public boolean isCursorCatched() {
        return this.caught;
    }

    @Override
    public void setCursorCatched(boolean caught) {
        this.lastCaught = this.caught;
        this.caught = caught;
        if (caught) {
            this.mouse.setCursorVisible(false);
            if (!this.lastCaught) {
                this.virtualX = this.mouseX;
                this.virtualY = this.mouseY;
            }
            this.setCursorPosition(this.window.getGraphics().getWidth() / 2, this.window.getGraphics().getHeight() / 2);
            this.mouse.clipCursor(this.window.getGraphics().raster);
        } else {
            this.mouse.setCursorVisible(!this.window.activated || !this.window.focused);
            this.mouse.clipCursor(null);
        }
    }

    @Override
    public void setCursorPosition(int x, int y) {
        AWTGraphics.Raster windowHandle = this.window.getGraphics().raster;
        if (!windowHandle.isShowing()) {
            return;
        }
        Point windowLocation = windowHandle.getLocationOnScreen();
        if (AWTApplication.hdpiMode == HdpiMode.Pixels) {
            float xScale = (float)this.window.getGraphics().getLogicalWidth() / (float)this.window.getGraphics().getBackBufferWidth();
            float yScale = (float)this.window.getGraphics().getLogicalHeight() / (float)this.window.getGraphics().getBackBufferHeight();
            x = (int)((float)x * xScale);
            y = (int)((float)y * yScale);
        }
        this.logicalMouseX = x;
        this.logicalMouseY = y;
        this.updateCursorPosition(x, y);
        this.mouse.setCursorPosition(x += windowLocation.x, y += windowLocation.y);
    }

    protected int translateKeyCode(KeyEvent ke) {
        switch (ke.getKeyCode()) {
            case 106: {
                return 17;
            }
            case 110: {
                return 158;
            }
            case 19: {
                return 121;
            }
            case 20: {
                return 115;
            }
            case 145: {
                return 116;
            }
            case 8: {
                return 67;
            }
            case 37: {
                return 21;
            }
            case 39: {
                return 22;
            }
            case 38: {
                return 19;
            }
            case 40: {
                return 20;
            }
            case 222: {
                return 75;
            }
            case 91: {
                return 71;
            }
            case 93: {
                return 72;
            }
            case 192: {
                return 68;
            }
            case 144: {
                return 78;
            }
            case 61: {
                return 70;
            }
            case 48: {
                return 7;
            }
            case 49: {
                return 8;
            }
            case 50: {
                return 9;
            }
            case 51: {
                return 10;
            }
            case 52: {
                return 11;
            }
            case 53: {
                return 12;
            }
            case 54: {
                return 13;
            }
            case 55: {
                return 14;
            }
            case 56: {
                return 15;
            }
            case 57: {
                return 16;
            }
            case 65: {
                return 29;
            }
            case 66: {
                return 30;
            }
            case 67: {
                return 31;
            }
            case 68: {
                return 32;
            }
            case 69: {
                return 33;
            }
            case 70: {
                return 34;
            }
            case 71: {
                return 35;
            }
            case 72: {
                return 36;
            }
            case 73: {
                return 37;
            }
            case 74: {
                return 38;
            }
            case 75: {
                return 39;
            }
            case 76: {
                return 40;
            }
            case 77: {
                return 41;
            }
            case 78: {
                return 42;
            }
            case 79: {
                return 43;
            }
            case 80: {
                return 44;
            }
            case 81: {
                return 45;
            }
            case 82: {
                return 46;
            }
            case 83: {
                return 47;
            }
            case 84: {
                return 48;
            }
            case 85: {
                return 49;
            }
            case 86: {
                return 50;
            }
            case 87: {
                return 51;
            }
            case 88: {
                return 52;
            }
            case 89: {
                return 53;
            }
            case 90: {
                return 54;
            }
            case 18: {
                ke.consume();
                if (ke.getKeyLocation() == 2) {
                    return 57;
                }
                return 58;
            }
            case 92: {
                return 73;
            }
            case 44: {
                return 55;
            }
            case 127: {
                return 112;
            }
            case 10: {
                return 66;
            }
            case 36: {
                return 3;
            }
            case 35: {
                return 123;
            }
            case 34: {
                return 93;
            }
            case 33: {
                return 92;
            }
            case 155: {
                return 124;
            }
            case 45: 
            case 109: {
                return 69;
            }
            case 46: {
                return 56;
            }
            case 107: 
            case 521: {
                return 81;
            }
            case 59: {
                return 74;
            }
            case 16: {
                if (ke.getKeyLocation() == 2) {
                    return 59;
                }
                return 60;
            }
            case 47: 
            case 111: {
                return 76;
            }
            case 32: {
                return 62;
            }
            case 9: {
                return 61;
            }
            case 17: {
                if (ke.getKeyLocation() == 2) {
                    return 129;
                }
                return 130;
            }
            case 27: {
                return 111;
            }
            case 112: {
                return 131;
            }
            case 113: {
                return 132;
            }
            case 114: {
                return 133;
            }
            case 115: {
                return 134;
            }
            case 116: {
                return 135;
            }
            case 117: {
                return 136;
            }
            case 118: {
                return 137;
            }
            case 119: {
                return 138;
            }
            case 120: {
                return 139;
            }
            case 121: {
                return 140;
            }
            case 122: {
                return 141;
            }
            case 123: {
                return 142;
            }
            case 513: {
                return 243;
            }
            case 96: {
                return 144;
            }
            case 97: {
                return 145;
            }
            case 98: {
                return 146;
            }
            case 99: {
                return 147;
            }
            case 100: {
                return 148;
            }
            case 101: {
                return 149;
            }
            case 102: {
                return 150;
            }
            case 103: {
                return 151;
            }
            case 104: {
                return 152;
            }
            case 105: {
                return 153;
            }
        }
        return 0;
    }

    @Override
    public float getAccelerometerX() {
        return 0.0f;
    }

    @Override
    public float getAccelerometerY() {
        return 0.0f;
    }

    @Override
    public float getAccelerometerZ() {
        return 0.0f;
    }

    @Override
    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        return peripheral == Input.Peripheral.HardwareKeyboard;
    }

    @Override
    public int getRotation() {
        return 0;
    }

    @Override
    public Input.Orientation getNativeOrientation() {
        return Input.Orientation.Landscape;
    }

    @Override
    public void setOnscreenKeyboardVisible(boolean visible) {
    }

    @Override
    public void setOnscreenKeyboardVisible(boolean visible, Input.OnscreenKeyboardType type) {
    }

    @Override
    public void openTextInputField(NativeInputConfiguration configuration) {
    }

    @Override
    public void closeTextInputField(boolean sendReturn) {
    }

    @Override
    public void setKeyboardHeightObserver(Input.KeyboardHeightObserver observer) {
    }

    @Override
    public void vibrate(int milliseconds) {
    }

    @Override
    public void vibrate(int milliseconds, boolean fallback) {
    }

    @Override
    public void vibrate(int milliseconds, int amplitude, boolean fallback) {
    }

    @Override
    public void vibrate(Input.VibrationType vibrationType) {
    }

    @Override
    public float getAzimuth() {
        return 0.0f;
    }

    @Override
    public float getPitch() {
        return 0.0f;
    }

    @Override
    public float getRoll() {
        return 0.0f;
    }

    @Override
    public void getRotationMatrix(float[] matrix) {
    }

    @Override
    public float getGyroscopeX() {
        return 0.0f;
    }

    @Override
    public float getGyroscopeY() {
        return 0.0f;
    }

    @Override
    public float getGyroscopeZ() {
        return 0.0f;
    }

    public void dispose() {
        this.caught = false;
        this.mouse.dispose();
        this.window.getWindowHandle().removeKeyListener(this.keyCallback);
        this.window.getWindowHandle().removeMouseListener(this.mouseButtonCallback);
        this.window.getWindowHandle().removeMouseMotionListener(this.cursorPosCallback);
        this.window.getWindowHandle().removeMouseWheelListener(this.mouseButtonCallback);
    }
}

