/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.awt;

import com.badlogic.gdx.backends.awt.AWTGraphics;
import com.badlogic.gdx.backends.awt.AWTWindow;
import com.badlogic.gdx.backends.awt.Mouse;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;

public class AWTMouse
implements Mouse,
MouseListener {
    AWTWindow window;
    Robot robot;
    private final CatchRunnable catchRunnable;
    private Cursor transparentCursor;

    public AWTMouse(AWTWindow window) {
        try {
            this.robot = new Robot(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
        }
        catch (AWTException e) {
            throw new RuntimeException(e);
        }
        this.window = window;
        this.catchRunnable = new CatchRunnable();
        Thread catchThread = new Thread(this.catchRunnable);
        catchThread.setName("Catch Cursor Thread");
        catchThread.setDaemon(true);
        catchThread.start();
        window.getWindowHandle().addMouseListener(this);
    }

    @Override
    public void setCursorPosition(int x, int y) {
        if (EventQueue.isDispatchThread()) {
            this.robot.mouseMove(x, y);
        } else {
            try {
                EventQueue.invokeAndWait(() -> this.robot.mouseMove(x, y));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setCursorVisible(boolean visible) {
        this.window.getWindowHandle().setCursor(!visible ? this.getTransparentCursor() : null);
    }

    private Cursor getTransparentCursor() {
        if (this.transparentCursor == null) {
            BufferedImage cursorImage = new BufferedImage(1, 1, 2);
            cursorImage.setRGB(0, 0, 0);
            this.transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(0, 0), "none");
        }
        return this.transparentCursor;
    }

    @Override
    public void clipCursor(Component c) {
    }

    @Override
    public void dispose() {
        this.window.getWindowHandle().removeMouseListener(this);
        this.catchRunnable.dispose();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.catchRunnable.pause();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.window.getInput().caught) {
            this.catchRunnable.resume();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private class CatchRunnable
    implements Runnable {
        int lastX = 0;
        int lastY = 0;
        private boolean running = true;
        private boolean paused = true;

        private CatchRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                if (this.paused) {
                    try {
                        CatchRunnable catchRunnable = this;
                        synchronized (catchRunnable) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
                if (!AWTMouse.this.window.focused) {
                    this.pause();
                    continue;
                }
                Point pointLocation = MouseInfo.getPointerInfo().getLocation();
                if (this.lastX == pointLocation.x || this.lastY == pointLocation.y) continue;
                this.lastX = pointLocation.x;
                this.lastY = pointLocation.y;
                AWTGraphics.Raster windowHandle = AWTMouse.this.window.getGraphics().raster;
                if (!windowHandle.isShowing()) continue;
                Point windowLocation = windowHandle.getLocationOnScreen();
                pointLocation.translate(-windowLocation.x, -windowLocation.y);
                AWTMouse.this.window.getInput().cursorPosCallback.mouseMoved(new MouseEvent(windowHandle, 503, System.currentTimeMillis(), 0, pointLocation.x, pointLocation.y, 0, false));
            }
        }

        public void dispose() {
            this.running = false;
            this.resume();
        }

        public void pause() {
            this.paused = true;
        }

        public synchronized void resume() {
            this.paused = false;
            this.notify();
        }
    }
}

