/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.awt;

import com.badlogic.gdx.backends.awt.AWTWindow;
import com.badlogic.gdx.backends.awt.Mouse;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import org.lwjgl.system.windows.RECT;
import org.lwjgl.system.windows.User32;
import ru.m210projects.Build.exceptions.InitializationException;

public class WinMouse
implements Mouse {
    private final RECT clipRect;
    private final AWTWindow window;
    private Cursor transparentCursor;
    private Robot robot;

    public WinMouse(AWTWindow window) throws InitializationException {
        try {
            this.clipRect = RECT.create();
            User32.ClipCursor(null);
            try {
                this.robot = new Robot(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
            }
            catch (AWTException e) {
                User32.SetCursorPos(window.getPositionX(), window.getPositionY());
            }
        }
        catch (Throwable e) {
            throw new InitializationException(e.getMessage());
        }
        this.window = window;
    }

    @Override
    public void clipCursor(Component component) {
        if (component != null) {
            Point loc = component.getLocationOnScreen();
            Rectangle rectangle = component.getBounds();
            User32.ClipCursor(this.clipRect.set(loc.x + rectangle.x, loc.y + rectangle.y, loc.x + rectangle.width - 1, loc.y + rectangle.height - 1));
        } else {
            User32.ClipCursor(null);
        }
    }

    @Override
    public void setCursorPosition(int x, int y) {
        if (this.robot == null) {
            User32.SetCursorPos(x, y);
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.robot.mouseMove(x, y);
        } else {
            try {
                EventQueue.invokeAndWait(() -> this.robot.mouseMove(x, y));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setCursorVisible(boolean visible) {
        this.window.getWindowHandle().setCursor(!visible ? this.getTransparentCursor() : null);
    }

    @Override
    public void dispose() {
        this.clipRect.free();
        User32.ClipCursor(null);
    }

    private Cursor getTransparentCursor() {
        if (this.transparentCursor == null) {
            BufferedImage cursorImage = new BufferedImage(1, 1, 2);
            cursorImage.setRGB(0, 0, 0);
            this.transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(0, 0), "none");
        }
        return this.transparentCursor;
    }
}

