/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.backends.lwjgl3.audio.ALSource;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALAudio;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntMap;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.SOFTEventProc;
import org.lwjgl.openal.SOFTEvents;
import ru.m210projects.Build.Architecture.common.audio.LoopInfo;
import ru.m210projects.Build.Architecture.common.audio.SoundManager;
import ru.m210projects.Build.exceptions.InitializationException;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class ALSoundManager
extends SoundManager {
    private final IntMap<Integer> soundIdToSourceIndex;
    private final OpenALAudio audio;

    public ALSoundManager(OpenALAudio audio, int sourceCount) {
        this.audio = audio;
        this.init(sourceCount);
        this.soundIdToSourceIndex = new IntMap();
        for (SoundManager.ManageableSource allSource : this.allSources) {
            ALSource alSource = (ALSource)allSource;
            this.soundIdToSourceIndex.put(alSource.soundId, alSource.sourceIndex);
        }
        if (AL.getCapabilities().AL_SOFT_events) {
            SOFTEvents.alEventControlSOFT(new int[]{6565}, true);
            SOFTEvents.alEventCallbackSOFT(new SOFTEventProc(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void invoke(int eventType, int soundId, int param, int length, long message, long userParam) {
                    if (eventType == 6565) {
                        switch (AL10.alGetSourcei(soundId, 4112)) {
                            case 4114: {
                                break;
                            }
                            case 4116: {
                                ALSource source = (ALSource)ALSoundManager.this.allSources[(Integer)ALSoundManager.this.soundIdToSourceIndex.get(soundId)];
                                LoopInfo loopInfo = source.loopInfo;
                                if (loopInfo.looped && AL10.alGetSourcef(source.soundId, 4106) > 0.0f) {
                                    int bufferID = AL10.alSourceUnqueueBuffers(source.soundId);
                                    AL10.alBufferData(bufferID, loopInfo.format, loopInfo.getData(), loopInfo.sampleRate);
                                    AL10.alSourceQueueBuffers(source.soundId, bufferID);
                                    AL10.alSourcei(source.soundId, 4103, 1);
                                    AL10.alSourcePlay(source.soundId);
                                    break;
                                }
                                Array array = ALSoundManager.this.sourcesToFree;
                                synchronized (array) {
                                    ALSoundManager.this.sourcesToFree.add(source.sourceIndex);
                                    break;
                                }
                            }
                        }
                    }
                }
            }, null);
        }
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    public ALSource getSource(int sourceIndex) {
        return (ALSource)this.allSources[sourceIndex];
    }

    @Override
    protected SoundManager.ManageableSource generateSource(int sourceIndex) {
        try {
            return new ALSource(this.audio, sourceIndex);
        }
        catch (InitializationException e) {
            Console.out.println(e.toString(), OsdColor.RED);
            return null;
        }
    }
}

