/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.audio.AudioDevice;
import com.badlogic.gdx.audio.AudioRecorder;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.lwjgl3.audio.ALAudioContext;
import com.badlogic.gdx.backends.lwjgl3.audio.ALEchoEffect;
import com.badlogic.gdx.backends.lwjgl3.audio.ALMusic;
import com.badlogic.gdx.backends.lwjgl3.audio.ALOgg;
import com.badlogic.gdx.backends.lwjgl3.audio.ALReverbEffect;
import com.badlogic.gdx.backends.lwjgl3.audio.ALSoundManager;
import com.badlogic.gdx.backends.lwjgl3.audio.ALSource;
import com.badlogic.gdx.backends.lwjgl3.audio.Lwjgl3Audio;
import com.badlogic.gdx.backends.lwjgl3.audio.OggDecoder;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.LwjglMidiMusicSource;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.openal.SOFTSourceResampler;
import ru.m210projects.Build.Architecture.common.audio.AudioChannel;
import ru.m210projects.Build.Architecture.common.audio.AudioDriver;
import ru.m210projects.Build.Architecture.common.audio.AudioResampler;
import ru.m210projects.Build.Architecture.common.audio.BuildAudio;
import ru.m210projects.Build.Architecture.common.audio.SoundData;
import ru.m210projects.Build.Architecture.common.audio.WAVDecoder;
import ru.m210projects.Build.exceptions.InitializationException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.settings.GameConfig;

public class OpenALAudio
implements BuildAudio,
Lwjgl3Audio {
    private final ObjectMap<String, Class<? extends Music>> extensionToMusicClass = new ObjectMap();
    final GameConfig config;
    protected long alDevice;
    protected long alContext;
    private String name = "OpenAL Sound";
    protected AudioResampler alAudioResampler = AudioResampler.DUMMY_RESAMPLER;
    private boolean opened = false;
    private final Map<String, SoundData.Decoder> decoders = new HashMap<String, SoundData.Decoder>();
    protected List<AudioResampler> alAudioResaplerList;
    protected ALEchoEffect alEchoEffect;
    protected ALReverbEffect alReverbEffect;
    protected ALSoundManager soundManager;
    private final FloatBuffer orientation = BufferUtils.createFloatBuffer(6);
    Array<ALMusic> music = new Array(false, 1, ALMusic.class);
    ScheduledExecutorService audioExecutor;

    public OpenALAudio(GameConfig config) {
        this.config = config;
        this.registerMusic("ogg", ALOgg.Music.class);
        this.registerMusic("mid", LwjglMidiMusicSource.class);
        this.registerDecoder("wav", new WAVDecoder());
        this.registerDecoder("ogg", new OggDecoder());
    }

    @Override
    public List<AudioResampler> getResamplerList() {
        return this.alAudioResaplerList;
    }

    public void registerMusic(String extension, Class<? extends Music> musicClass) {
        if (extension == null) {
            throw new IllegalArgumentException("extension cannot be null.");
        }
        if (musicClass == null) {
            throw new IllegalArgumentException("musicClass cannot be null.");
        }
        this.extensionToMusicClass.put(extension, musicClass);
    }

    @Override
    public void dispose() {
        if (this.opened) {
            this.audioExecutor.shutdown();
            this.music.clear();
            this.soundManager.dispose();
            if (this.alEchoEffect != null) {
                this.alEchoEffect.dispose();
            }
            if (this.alReverbEffect != null) {
                this.alReverbEffect.dispose();
            }
            ALC10.alcDestroyContext(this.alContext);
            ALC10.alcCloseDevice(this.alDevice);
            this.opened = false;
        }
    }

    @Override
    public BuildAudio open() throws InitializationException {
        this.alDevice = ALC10.alcOpenDevice((ByteBuffer)null);
        if (this.alDevice == 0L) {
            throw new InitializationException("Open device failed!");
        }
        ALCCapabilities deviceCapabilities = ALC.createCapabilities(this.alDevice);
        this.alContext = ALC10.alcCreateContext(this.alDevice, (IntBuffer)null);
        if (this.alContext == 0L) {
            ALC10.alcCloseDevice(this.alDevice);
            throw new InitializationException("Create device context failed!");
        }
        if (!ALC10.alcMakeContextCurrent(this.alContext)) {
            ALC10.alcDestroyContext(this.alContext);
            ALC10.alcCloseDevice(this.alDevice);
            throw new InitializationException("Making to current device context failed!");
        }
        AL.createCapabilities(deviceCapabilities);
        AL10.alGetError();
        AL10.alDistanceModel(0);
        this.orientation.clear();
        this.orientation.put(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        ((Buffer)this.orientation).flip();
        AL10.alListenerfv(4111, this.orientation);
        FloatBuffer velocity = BufferUtils.createFloatBuffer(3).put(new float[]{0.0f, 0.0f, 0.0f});
        ((Buffer)velocity).flip();
        AL10.alListenerfv(4102, velocity);
        FloatBuffer position = BufferUtils.createFloatBuffer(3).put(new float[]{0.0f, 0.0f, 0.0f});
        ((Buffer)position).flip();
        AL10.alListenerfv(4100, position);
        String version = AL10.alGetString(45058);
        this.name = ALC10.alcGetString(this.alDevice, 4101) + " " + version;
        this.alAudioResaplerList = new ArrayList<AudioResampler>();
        try {
            boolean alEfxSupport;
            ALCapabilities caps = AL.getCapabilities();
            int sourceCount = this.config.getMaxvoices();
            if (caps.AL_SOFT_source_resampler) {
                int alNumResamplers = AL10.alGetInteger(4624);
                for (int i = 0; i < alNumResamplers; ++i) {
                    String name = SOFTSourceResampler.alGetStringiSOFT(4627, i);
                    if (AL10.alGetError() != 0) break;
                    if (name == null) continue;
                    final int index = i;
                    AudioResampler resampler = new AudioResampler(this, name){
                        final /* synthetic */ OpenALAudio this$0;
                        {
                            this.this$0 = this$0;
                            super(name);
                        }

                        @Override
                        public void setToSource(int sourceId) {
                            AL10.alSourcei(sourceId, 4626, index);
                        }
                    };
                    this.alAudioResaplerList.add(resampler);
                }
            }
            if (alEfxSupport = caps.ALC_EXT_EFX) {
                this.alEchoEffect = new ALEchoEffect();
                this.alReverbEffect = new ALReverbEffect();
            }
            this.soundManager = new ALSoundManager(this, sourceCount);
            Console.out.println(this.name + " initialized", OsdColor.GREEN);
            Console.out.println("\twith max voices: " + sourceCount, OsdColor.GREEN);
            Console.out.println("\tOpenAL version: " + version, OsdColor.GREEN);
            this.config.setAudioContext(new ALAudioContext(this));
            if (caps.AL_SOFT_source_resampler) {
                Console.out.println("AL_SOFT_Source_Resampler enabled.", OsdColor.GREEN);
                this.config.setResampler(this.config.getResampler());
            }
            if (alEfxSupport) {
                Console.out.println("ALC_EXT_EFX enabled.");
            } else {
                Console.out.println("ALC_EXT_EFX not support!");
            }
            this.audioExecutor = Executors.newSingleThreadScheduledExecutor(runnable -> {
                Thread thread = new Thread(runnable);
                thread.setName("OpenAL Update Thread");
                thread.setDaemon(true);
                return thread;
            });
            this.audioExecutor.scheduleAtFixedRate(this::update, 0L, 100L, TimeUnit.MILLISECONDS);
            this.opened = true;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return this;
    }

    public Array<ALMusic> getMusicSources() {
        return this.music;
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public AudioDriver getAudioDriver() {
        return AudioDriver.OPENAL_AUDIO;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEFXSupport() {
        return this.alEchoEffect != null && this.alEchoEffect.isEFXSupport() || this.alReverbEffect != null && this.alReverbEffect.isEFXSupport();
    }

    @Override
    public void stopAllSounds() {
        if (this.opened) {
            this.soundManager.stopAllSounds();
        }
    }

    @Override
    public float getReverb() {
        return this.alReverbEffect.getDelay();
    }

    @Override
    public void setReverb(boolean enable, float delay) {
        this.alReverbEffect.setReverb(enable, delay);
        for (int i = 0; i < this.soundManager.getSize(); ++i) {
            ALSource source = this.soundManager.getSource(i);
            if (source.isMusicSource()) continue;
            this.alReverbEffect.setToSource(source.soundId);
        }
    }

    @Override
    public float getEcho() {
        return this.alEchoEffect.getDelay();
    }

    @Override
    public void setEcho(boolean enable, float delay) {
        this.alEchoEffect.setReverb(enable, delay);
        for (int i = 0; i < this.soundManager.getSize(); ++i) {
            ALSource source = this.soundManager.getSource(i);
            if (source.isMusicSource()) continue;
            this.alEchoEffect.setToSource(source.soundId);
        }
    }

    @Override
    public void update() {
        this.soundManager.update();
        for (int i = 0; i < this.music.size; ++i) {
            ((ALMusic[])this.music.items)[i].update();
        }
    }

    protected int getALFormat(int channels, int bits) {
        boolean stereo = channels > 1;
        switch (bits) {
            case 16: {
                if (stereo) {
                    return 4355;
                }
                return 4353;
            }
            case 8: {
                if (stereo) {
                    return 4354;
                }
                return 4352;
            }
        }
        return -1;
    }

    @Override
    @Nullable
    public Sound newSound(ByteBuffer buffer, int rate, int bits, AudioChannel channel, int priority) {
        int sourceIndex = this.soundManager.obtainSource(priority);
        if (sourceIndex == -1) {
            return null;
        }
        ALSource alSource = this.soundManager.getSource(sourceIndex);
        int sourceId = alSource.soundId;
        this.alAudioResampler.setToSource(sourceId);
        if (this.alEchoEffect != null) {
            this.alEchoEffect.setToSource(sourceId);
        }
        if (this.alReverbEffect != null) {
            this.alReverbEffect.setToSource(sourceId);
        }
        alSource.setVolume(0.0f);
        int format = this.getALFormat(channel.getChannels(), bits);
        if (format == -1) {
            Console.out.println("OpenAL Error wrong bits: " + bits, OsdColor.RED);
            alSource.stop();
            return null;
        }
        int bufferID = alSource.buffedId;
        AL10.alBufferData(bufferID, format, buffer, rate);
        AL10.alSourcei(sourceId, 4105, bufferID);
        alSource.loopInfo.init(buffer, format, rate);
        alSource.checkErrors("newSound");
        return alSource;
    }

    @Override
    public Sound newSound(ByteBuffer buffer, int rate, int bits, int priority) {
        return this.newSound(buffer, rate, bits, AudioChannel.MONO, priority);
    }

    @Override
    public Music newMusic(Entry file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        if (!file.exists()) {
            return null;
        }
        Class<? extends Music> musicClass = this.extensionToMusicClass.get(file.getExtension().toLowerCase());
        if (musicClass == null) {
            Console.out.println("Unknown file extension for music: " + file, OsdColor.RED);
            return null;
        }
        if (musicClass.equals(LwjglMidiMusicSource.class)) {
            return this.config.getMidiDevice().newMusic(file);
        }
        try {
            return musicClass.getConstructor(OpenALAudio.class, Entry.class).newInstance(this, file);
        }
        catch (Exception ex) {
            Console.out.println("Error creating music " + musicClass.getName() + " for file: " + file, OsdColor.RED);
            return null;
        }
    }

    @Override
    public boolean canPlay(int priority) {
        int index = this.soundManager.element();
        if (index != -1) {
            ALSource source = this.soundManager.getSource(index);
            return source.getPriority() == -1 || source.getPriority() < priority;
        }
        return false;
    }

    @Override
    public void setListener(int x, int y, int z, int ang) {
        AL10.alListener3f(4100, x, y, z);
        double angle = (double)(ang * 2) * Math.PI / 2048.0;
        this.orientation.put(0, (float)Math.cos(angle));
        this.orientation.put(1, 0.0f);
        this.orientation.put(2, (float)Math.sin(angle));
        this.orientation.rewind();
        AL10.alListenerfv(4111, this.orientation);
    }

    @Override
    public void registerDecoder(String extension, SoundData.Decoder decoder) {
        this.decoders.put(extension.toUpperCase(), decoder);
    }

    @Override
    public @NotNull SoundData.Decoder getSoundDecoder(String extension) {
        SoundData.Decoder decoder = this.decoders.getOrDefault(extension.toUpperCase(), SoundData.DUMMY_DECODER);
        if (decoder == null) {
            OpenALAudio.$$$reportNull$$$0(0);
        }
        return decoder;
    }

    @Override
    public Sound newSound(FileHandle fileHandle) {
        return null;
    }

    @Override
    public Music newMusic(FileHandle file) {
        return null;
    }

    @Override
    public AudioDevice newAudioDevice(int samplingRate, boolean isMono) {
        return null;
    }

    @Override
    public AudioRecorder newAudioRecorder(int samplingRate, boolean isMono) {
        return null;
    }

    @Override
    public boolean switchOutputDevice(String deviceIdentifier) {
        return false;
    }

    @Override
    public String[] getAvailableOutputDevices() {
        return new String[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/badlogic/gdx/backends/lwjgl3/audio/OpenALAudio", "getSoundDecoder"));
    }
}

