/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio.midi;

import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.lwjgl3.audio.midi.LwjglMidiSequencer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import ru.m210projects.Build.Architecture.common.audio.RangedMusic;
import ru.m210projects.Build.filehandle.Entry;

public class LwjglMidiMusicSource
implements RangedMusic {
    private final LwjglMidiSequencer sequencer;
    protected Sequence data;
    private boolean looping;
    private long position;
    private Music.OnCompletionListener listener = null;
    private float volume = 1.0f;
    private long loopStart;
    private long loopEnd;

    public LwjglMidiMusicSource(LwjglMidiSequencer sequencer, Entry entry) throws InvalidMidiDataException, IOException {
        this.sequencer = sequencer;
        this.data = MidiSystem.getSequence(new ByteArrayInputStream(entry.getBytes()));
        this.position = 0L;
        this.loopStart = -1L;
        this.loopEnd = -1L;
    }

    @Override
    public void play() {
        this.setLooping(this.looping);
        if (this.loopStart != -1L && this.loopEnd != -1L) {
            this.sequencer.play(this, this.position, this.loopStart, this.loopEnd);
        } else {
            this.sequencer.play(this, this.position);
        }
    }

    @Override
    public void pause() {
        this.position = this.sequencer.getPosition();
        this.sequencer.stop();
    }

    @Override
    public void stop() {
        this.position = 0L;
        this.sequencer.stop();
        if (this.listener != null) {
            this.listener.onCompletion(this);
        }
    }

    @Override
    public boolean isPlaying() {
        return this.sequencer.isPlaying(this);
    }

    @Override
    public void setLooping(boolean looping) {
        this.looping = looping;
        this.sequencer.setLooping(looping);
    }

    @Override
    public void setLoopRange(long start, long end) {
        this.loopStart = start;
        this.loopEnd = end;
    }

    @Override
    public boolean isLooping() {
        return this.looping;
    }

    @Override
    public void setVolume(float volume) {
        this.volume = volume;
        this.sequencer.notifyVolumeChanged();
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void setPan(float pan, float volume) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPosition(float position) {
        this.position = (long)position;
    }

    @Override
    public float getPosition() {
        return this.position;
    }

    @Override
    public void dispose() {
        this.stop();
        this.data = null;
        this.listener = null;
    }

    @Override
    public void setOnCompletionListener(Music.OnCompletionListener listener) {
        this.listener = listener;
    }
}

