/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers;

import com.badlogic.gdx.controllers.ControllerMapping;
import com.badlogic.gdx.controllers.ControllerPowerLevel;
import com.badlogic.gdx.controllers.JController;
import com.badlogic.gdx.utils.Array;
import de.ralleytn.wrapper.microsoft.xinput.XInput;
import de.ralleytn.wrapper.microsoft.xinput.XInputBatteryInformation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class JXController
extends JController {
    public static final XInput XINPUT = XInput.create();
    public int playerIndex;
    private final Event tmpEvent = new Event();
    private Map<Component.Identifier, JXComponent> componentMap;
    private ControllerMapping mapping;

    public JXController(Controller controller) {
        super(controller);
        this.playerIndex = this.getUserIndex(controller);
    }

    private int getUserIndex(Controller controller) {
        try {
            Method method = controller.getClass().getDeclaredMethod("getUserIndex", new Class[0]);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)controller, new Object[0]);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    @Override
    protected void createComponents(Controller controller) {
        Component[] components = controller.getComponents();
        this.buttons = new Array();
        this.axes = new Array();
        this.povs = new Array();
        this.componentMap = new HashMap<Component.Identifier, JXComponent>();
        int buttonCount = 0;
        int povCount = 0;
        int axisCount = 0;
        int axisLeftX = -1;
        int axisLeftY = -1;
        int axisRightX = -1;
        int axisRightY = -1;
        int buttonA = -1;
        int buttonB = -1;
        int buttonX = -1;
        int buttonY = -1;
        int buttonBack = -1;
        int buttonStart = -1;
        int buttonL1 = -1;
        int buttonL2 = -1;
        int buttonR1 = -1;
        int buttonR2 = -1;
        int buttonLeftStick = -1;
        int buttonRightStick = -1;
        int buttonDpadUp = -1;
        int buttonDpadDown = -1;
        int buttonDpadLeft = -1;
        int buttonDpadRight = -1;
        for (Component component : components) {
            Component.Identifier componentIdentifier = component.getIdentifier();
            JXComponent c = null;
            if (componentIdentifier instanceof Component.Identifier.Button) {
                c = new JXButtonComponent(component);
                this.buttons.add((JController.ButtonComponent)((Object)c));
                ++buttonCount;
            } else if (componentIdentifier == Component.Identifier.Axis.POV) {
                c = new JXPovComponent(component);
                this.povs.add((JController.PovComponent)((Object)c));
                ++povCount;
            } else if (component.isAnalog()) {
                if (componentIdentifier == Component.Identifier.Axis.Z || componentIdentifier == Component.Identifier.Axis.RZ) {
                    c = new JXTriggerComponent(component, true);
                    this.buttons.add((JController.ButtonComponent)((Object)c));
                } else {
                    c = new JXAxisComponent(component, componentIdentifier == Component.Identifier.Axis.Y || componentIdentifier == Component.Identifier.Axis.RY);
                    this.axes.add((JController.AxisComponent)((Object)c));
                }
                ++axisCount;
            }
            if (c == null) continue;
            if (componentIdentifier == Component.Identifier.Axis.X) {
                axisLeftX = this.axes.size - 1;
            } else if (componentIdentifier == Component.Identifier.Axis.Y) {
                axisLeftY = this.axes.size - 1;
            } else if (componentIdentifier == Component.Identifier.Axis.RX) {
                axisRightX = this.axes.size - 1;
            } else if (componentIdentifier == Component.Identifier.Axis.RY) {
                axisRightY = this.axes.size - 1;
            } else if (component.getName().equalsIgnoreCase(Component.Identifier.Button.A.getName())) {
                buttonA = this.buttons.size - 1;
            } else if (component.getName().equalsIgnoreCase(Component.Identifier.Button.B.getName())) {
                buttonB = this.buttons.size - 1;
            } else if (component.getName().equalsIgnoreCase(Component.Identifier.Button.X.getName())) {
                buttonX = this.buttons.size - 1;
            } else if (component.getName().equalsIgnoreCase(Component.Identifier.Button.Y.getName())) {
                buttonY = this.buttons.size - 1;
            } else if (component.getName().equalsIgnoreCase(Component.Identifier.Button.BACK.getName())) {
                buttonBack = this.buttons.size - 1;
            } else if (component.getName().equalsIgnoreCase(Component.Identifier.Button.START.getName())) {
                buttonStart = this.buttons.size - 1;
            } else if (component.getName().equalsIgnoreCase("lthumb")) {
                buttonLeftStick = this.buttons.size - 1;
            } else if (component.getName().equalsIgnoreCase("rthumb")) {
                buttonRightStick = this.buttons.size - 1;
            } else if (componentIdentifier == Component.Identifier.Axis.Z) {
                buttonL1 = this.buttons.size - 1;
            } else if (componentIdentifier == Component.Identifier.Axis.RZ) {
                buttonR1 = this.buttons.size - 1;
            } else if (component.getName().equalsIgnoreCase("lb")) {
                buttonL2 = this.buttons.size - 1;
            } else if (component.getName().equalsIgnoreCase("rb")) {
                buttonR2 = this.buttons.size - 1;
            }
            this.componentMap.put(component.getIdentifier(), c);
        }
        if (this.povs.size != 0) {
            buttonDpadUp = this.buttons.size;
            buttonDpadLeft = this.buttons.size + 1;
            buttonDpadDown = this.buttons.size + 2;
            buttonDpadRight = this.buttons.size + 3;
        }
        this.mapping = new ControllerMapping(axisLeftX, axisLeftY, axisRightX, axisRightY, buttonA, buttonB, buttonX, buttonY, buttonBack, buttonStart, buttonL1, buttonL2, buttonR1, buttonR2, buttonLeftStick, buttonRightStick, buttonDpadUp, buttonDpadDown, buttonDpadLeft, buttonDpadRight);
        Console.out.println("Found xinput controller: \"" + this.getName() + "\" [buttons: " + buttonCount + " axises: " + axisCount + " povs: " + povCount + "]", OsdColor.YELLOW);
    }

    @Override
    public boolean update() {
        if (!this.controller.poll()) {
            return false;
        }
        EventQueue queue = this.controller.getEventQueue();
        while (queue.getNextEvent(this.tmpEvent)) {
            Component.Identifier componentIdentifier = this.tmpEvent.getComponent().getIdentifier();
            JXComponent component = this.componentMap.get(componentIdentifier);
            component.setEvent(this.tmpEvent);
        }
        this.updateButtonsState();
        this.updateAxisState();
        this.updatePovState();
        return true;
    }

    @Override
    public ControllerMapping getMapping() {
        return this.mapping;
    }

    @Override
    public boolean canVibrate() {
        return this.controller.getRumblers().length != 0;
    }

    @Override
    public void startVibration(int duration, float strength) {
        if (this.canVibrate()) {
            this.controller.getRumblers()[0].rumble(strength);
        }
    }

    @Override
    public boolean isVibrating() {
        return false;
    }

    @Override
    public void cancelVibration() {
    }

    @Override
    public boolean supportsPlayerIndex() {
        return true;
    }

    @Override
    public int getPlayerIndex() {
        return this.playerIndex;
    }

    @Override
    public void setPlayerIndex(int index) {
        this.playerIndex = index;
    }

    @Override
    public ControllerPowerLevel getPowerLevel() {
        XInputBatteryInformation information;
        int out;
        if (XINPUT != null && this.playerIndex != -1 && (out = XINPUT.XInputGetBatteryInformation(this.playerIndex, 0, information = new XInputBatteryInformation())) == 0) {
            if (information.batteryType == XInputBatteryInformation.BatteryType.WIRED) {
                return ControllerPowerLevel.POWER_WIRED;
            }
            switch (information.batteryLevel) {
                case EMPTY: {
                    return ControllerPowerLevel.POWER_EMPTY;
                }
                case LOW: {
                    return ControllerPowerLevel.POWER_LOW;
                }
                case MEDIUM: {
                    return ControllerPowerLevel.POWER_MEDIUM;
                }
                case FULL: {
                    return ControllerPowerLevel.POWER_FULL;
                }
            }
        }
        return ControllerPowerLevel.POWER_UNKNOWN;
    }

    protected static class JXButtonComponent
    extends JController.ButtonComponent
    implements JXComponent {
        private final Event event = new Event();

        public JXButtonComponent(Component component) {
            super(component);
        }

        @Override
        public void setEvent(Event event) {
            this.event.set(event);
        }

        @Override
        public float getValue() {
            return this.event.getValue();
        }
    }

    protected static class JXPovComponent
    extends JController.PovComponent
    implements JXComponent {
        private final Event event = new Event();

        public JXPovComponent(Component component) {
            super(component);
        }

        @Override
        public void setEvent(Event event) {
            this.event.set(event);
        }

        @Override
        public float getValue() {
            return this.event.getValue();
        }
    }

    protected static class JXTriggerComponent
    extends JController.TriggerComponent
    implements JXComponent {
        private final Event event = new Event();

        public JXTriggerComponent(Component component, boolean direction) {
            super(component, direction);
        }

        @Override
        public void setEvent(Event event) {
            this.event.set(event);
        }

        @Override
        public float getValue() {
            return this.event.getValue();
        }
    }

    protected static class JXAxisComponent
    extends JController.AxisComponent
    implements JXComponent {
        private final Event event = new Event();
        private final boolean invert;

        public JXAxisComponent(Component component, boolean invert) {
            super(component);
            this.invert = invert;
        }

        @Override
        public void setEvent(Event event) {
            this.event.set(event);
        }

        @Override
        public float getValue() {
            return this.invert ? -this.event.getValue() : this.event.getValue();
        }
    }

    private static interface JXComponent
    extends JController.JComponent {
        public void setEvent(Event var1);
    }
}

