/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.plugins.jinput.xinput;

import de.ralleytn.wrapper.microsoft.xinput.XInputGamepad;
import net.java.games.input.Component;

final class XIPollData {
    private final XInputGamepad gamepad;
    private float x;
    private float y;
    private float a;
    private float b;
    private float lb;
    private float rb;
    private float lthumb;
    private float rthumb;
    private float start;
    private float back;
    private float lt;
    private float rt;
    private float lx;
    private float ly;
    private float rx;
    private float ry;
    private float pov;

    protected XIPollData(XInputGamepad gamepad) {
        this.gamepad = gamepad;
        this.fetchData();
    }

    private final void fetchData() {
        this.fetchButtonData();
        this.fetchTriggerData();
        this.fetchThumbStickData();
        this.fetchPOVData();
    }

    private final void fetchPOVData() {
        short buttons = this.gamepad.wButtons;
        if (this.isDown(buttons, 1) && this.isDown(buttons, 4)) {
            this.pov = 0.125f;
        } else if (this.isDown(buttons, 1) && this.isDown(buttons, 8)) {
            this.pov = 0.375f;
        } else if (this.isDown(buttons, 2) && this.isDown(buttons, 4)) {
            this.pov = 0.875f;
        } else if (this.isDown(buttons, 2) && this.isDown(buttons, 8)) {
            this.pov = 0.625f;
        } else if (this.isDown(buttons, 1)) {
            this.pov = 0.25f;
        } else if (this.isDown(buttons, 4)) {
            this.pov = 1.0f;
        } else if (this.isDown(buttons, 8)) {
            this.pov = 0.5f;
        } else if (this.isDown(buttons, 2)) {
            this.pov = 0.75f;
        }
    }

    private final void fetchTriggerData() {
        this.lt = this.calcTriggerData(this.gamepad.bLeftTrigger);
        this.rt = this.calcTriggerData(this.gamepad.bRightTrigger);
    }

    private final float calcTriggerData(byte value) {
        float factor = 0.003921569f * (float)Byte.toUnsignedInt(value);
        return Math.min(1.0f, factor);
    }

    private final void fetchThumbStickData() {
        this.lx = this.calcThumbStickData(this.gamepad.sThumbLX);
        this.ly = this.calcThumbStickData(this.gamepad.sThumbLY);
        this.rx = this.calcThumbStickData(this.gamepad.sThumbRX);
        this.ry = this.calcThumbStickData(this.gamepad.sThumbRY);
    }

    private final float calcThumbStickData(short value) {
        float factor = 3.051851E-5f * (float)Math.abs(value);
        factor = Math.min(1.0f, factor);
        return value < 0 ? -factor : factor;
    }

    private final void fetchButtonData() {
        short buttons = this.gamepad.wButtons;
        this.x = this.calcButtonData(buttons, 16384);
        this.y = this.calcButtonData(buttons, 32768);
        this.a = this.calcButtonData(buttons, 4096);
        this.b = this.calcButtonData(buttons, 8192);
        this.lb = this.calcButtonData(buttons, 256);
        this.rb = this.calcButtonData(buttons, 512);
        this.lthumb = this.calcButtonData(buttons, 64);
        this.rthumb = this.calcButtonData(buttons, 128);
        this.start = this.calcButtonData(buttons, 16);
        this.back = this.calcButtonData(buttons, 32);
    }

    private final float calcButtonData(short buttons, int button) {
        return (buttons & button) != 0 ? 1.0f : 0.0f;
    }

    private final boolean isDown(short buttons, int button) {
        return this.calcButtonData(buttons, button) == 1.0f;
    }

    protected final float getDataByComponent(Component component) {
        String name = component.getName();
        if ("x".equals(name)) {
            return this.x;
        }
        if ("y".equals(name)) {
            return this.y;
        }
        if ("a".equals(name)) {
            return this.a;
        }
        if ("b".equals(name)) {
            return this.b;
        }
        if ("lb".equals(name)) {
            return this.lb;
        }
        if ("rb".equals(name)) {
            return this.rb;
        }
        if ("lthumb".equals(name)) {
            return this.lthumb;
        }
        if ("rthumb".equals(name)) {
            return this.rthumb;
        }
        if ("back".equals(name)) {
            return this.back;
        }
        if ("start".equals(name)) {
            return this.start;
        }
        if ("lt".equals(name)) {
            return this.lt;
        }
        if ("rt".equals(name)) {
            return this.rt;
        }
        if ("lx".equals(name)) {
            return this.lx;
        }
        if ("ly".equals(name)) {
            return this.ly;
        }
        if ("rx".equals(name)) {
            return this.rx;
        }
        if ("ry".equals(name)) {
            return this.ry;
        }
        if ("pov".equals(name)) {
            return this.pov;
        }
        return 0.0f;
    }
}

