/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.wrapper.microsoft.xinput;

import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;

public class XInputVibration
extends Struct<XInputVibration>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LEFT_MOTOR_SPEED;
    public static final int RIGHT_MOTOR_SPEED;
    public int wLeftMotorSpeed;
    public int wRightMotorSpeed;

    protected XInputVibration(long address, ByteBuffer container) {
        super(address, container);
        if (container != null) {
            this.wLeftMotorSpeed = container.getShort();
            this.wRightMotorSpeed = container.getShort();
        }
    }

    public XInputVibration() {
        this(MemoryUtil.nmemAllocChecked(SIZEOF), ByteBuffer.allocate(SIZEOF));
    }

    @Override
    @NotNull
    protected XInputVibration create(long address, ByteBuffer container) {
        return new XInputVibration(address, container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    static {
        Struct.Layout layout = XInputVibration.__struct(XInputVibration.__member(2), XInputVibration.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LEFT_MOTOR_SPEED = layout.offsetof(0);
        RIGHT_MOTOR_SPEED = layout.offsetof(1);
    }
}

