/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

final class DataQueue<T> {
    private final T[] elements;
    private int position;
    private int limit;

    public DataQueue(int size, Class<T> element_type) {
        this.elements = (Object[])Array.newInstance(element_type, size);
        for (int i = 0; i < this.elements.length; ++i) {
            try {
                this.elements[i] = element_type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                continue;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        this.clear();
    }

    public void clear() {
        this.position = 0;
        this.limit = this.elements.length;
    }

    public int position() {
        return this.position;
    }

    public int limit() {
        return this.limit;
    }

    public T get(int index) {
        assert (index < this.limit);
        return this.elements[index];
    }

    public T get() {
        if (!this.hasRemaining()) {
            return null;
        }
        return this.get(this.position++);
    }

    public void compact() {
        int index = 0;
        while (this.hasRemaining()) {
            this.swap(this.position, index);
            ++this.position;
            ++index;
        }
        this.position = index;
        this.limit = this.elements.length;
    }

    private void swap(int index1, int index2) {
        T temp = this.elements[index1];
        this.elements[index1] = this.elements[index2];
        this.elements[index2] = temp;
    }

    public void flip() {
        this.limit = this.position;
        this.position = 0;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public int remaining() {
        return this.limit - this.position;
    }

    public void position(int position) {
        this.position = position;
    }

    public T[] getElements() {
        return this.elements;
    }
}

