/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.util.plugins.Plugins;

class DefaultControllerEnvironment
extends ControllerEnvironment {
    static String libPath;
    private static Logger log;
    private ArrayList<Controller> controllers;
    private Collection<String> loadedPluginNames = new ArrayList<String>();

    static void loadLibrary(String lib_name) {
        String lib_path = System.getProperty("net.java.games.input.librarypath");
        if (lib_path != null) {
            System.load(lib_path + File.separator + System.mapLibraryName(lib_name));
        } else {
            System.loadLibrary(lib_name);
        }
    }

    @Override
    public Controller[] getControllers() {
        if (this.controllers == null) {
            this.controllers = new ArrayList();
            this.scanControllers();
            String pluginClasses = System.getProperty("jinput.plugins", "") + " " + System.getProperty("net.java.games.input.plugins", "");
            if (!System.getProperty("jinput.useDefaultPlugin", "true").toLowerCase().trim().equals("false") && !System.getProperty("net.java.games.input.useDefaultPlugin", "true").toLowerCase().trim().equals("false")) {
                String osName;
                switch (osName = System.getProperty("os.name", "").trim()) {
                    case "Linux": {
                        pluginClasses = pluginClasses + " net.java.games.input.LinuxEnvironmentPlugin";
                        break;
                    }
                    case "Mac OS X": {
                        pluginClasses = pluginClasses + " net.java.games.input.OSXEnvironmentPlugin";
                        break;
                    }
                    case "Windows 98": 
                    case "Windows 2000": {
                        pluginClasses = pluginClasses + " net.java.games.input.DirectInputEnvironmentPlugin";
                        break;
                    }
                    case "Windows XP": 
                    case "Windows Vista": 
                    case "Windows 7": 
                    case "Windows 8": 
                    case "Windows 8.1": 
                    case "Windows 10": 
                    case "Windows 11": {
                        pluginClasses = pluginClasses + " net.java.games.input.DirectAndRawInputEnvironmentPlugin";
                        break;
                    }
                    default: {
                        if (osName.startsWith("Windows")) {
                            log.warning("Found unknown Windows version: " + osName);
                            log.warning("Attempting to use default windows plug-in.");
                            pluginClasses = pluginClasses + " net.java.games.input.DirectAndRawInputEnvironmentPlugin";
                            break;
                        }
                        log.warning("Trying to use default plugin, OS name " + osName + " not recognised");
                    }
                }
            }
            StringTokenizer pluginClassTok = new StringTokenizer(pluginClasses, " \t\n\r\f,;:");
            while (pluginClassTok.hasMoreTokens()) {
                String className = pluginClassTok.nextToken();
                try {
                    if (this.loadedPluginNames.contains(className)) continue;
                    log.fine("Loading: " + className);
                    Class<?> ceClass = Class.forName(className);
                    ControllerEnvironment ce = (ControllerEnvironment)ceClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (ce.isSupported()) {
                        this.addControllers(ce.getControllers());
                        this.loadedPluginNames.add(ce.getClass().getName());
                        continue;
                    }
                    DefaultControllerEnvironment.log(ceClass.getName() + " is not supported");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        Controller[] ret = new Controller[this.controllers.size()];
        Iterator<Controller> it = this.controllers.iterator();
        int i = 0;
        while (it.hasNext()) {
            ret[i] = it.next();
            ++i;
        }
        return ret;
    }

    private Void scanControllers() {
        String pluginPathName = System.getProperty("jinput.controllerPluginPath");
        if (pluginPathName == null) {
            pluginPathName = "controller";
        }
        this.scanControllersAt(System.getProperty("java.home") + File.separator + "lib" + File.separator + pluginPathName);
        this.scanControllersAt(System.getProperty("user.dir") + File.separator + pluginPathName);
        return null;
    }

    private void scanControllersAt(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        try {
            Plugins plugins = new Plugins(file);
            Class[] envClasses = plugins.getExtends(ControllerEnvironment.class);
            for (int i = 0; i < envClasses.length; ++i) {
                try {
                    ControllerEnvironment.log("ControllerEnvironment " + envClasses[i].getName() + " loaded by " + envClasses[i].getClassLoader());
                    ControllerEnvironment ce = (ControllerEnvironment)envClasses[i].getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (ce.isSupported()) {
                        this.addControllers(ce.getControllers());
                        this.loadedPluginNames.add(ce.getClass().getName());
                        continue;
                    }
                    DefaultControllerEnvironment.log(envClasses[i].getName() + " is not supported");
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addControllers(Controller[] c) {
        for (int i = 0; i < c.length; ++i) {
            this.controllers.add(c[i]);
        }
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    static {
        log = Logger.getLogger(DefaultControllerEnvironment.class.getName());
    }
}

