/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.AI.DudeExtra;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.net.Mmulti;

public class AIBAT {
    public static AISTATE batSleep;
    public static AISTATE batIdle;
    public static AISTATE batSearch;
    public static AISTATE batChase;
    public static AISTATE batTurn;
    public static AISTATE batUp;
    public static AISTATE batDown;
    public static AISTATE batRecoil;
    public static AISTATE batGoto;
    public static AISTATE batBite;
    public static AISTATE batThinkMove;
    public static AISTATE batThinkIdle;
    public static AISTATE batDodgeUp;
    public static AISTATE batDodgeDown;

    public static void Init() {
        batSleep = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.myThinkTarget(sprite, xsprite);
            }
        };
        batIdle = new AISTATE(AISTATEFUNC.Type.idle, 6, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.myThinkTarget(sprite, xsprite);
            }
        };
        batChase = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, true, true, batIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.thinkChase(sprite, xsprite);
            }
        };
        batThinkMove = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.thinkMove(sprite, xsprite);
            }
        };
        batGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 6, null, 600, false, true, true, batIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.thinkGoto(sprite, xsprite);
            }
        };
        batBite = new AISTATE(AISTATEFUNC.Type.attack, 7, i -> AIBAT.BiteCallback(i), 60, false, false, false, batThinkMove);
        batRecoil = new AISTATE(AISTATEFUNC.Type.recoil, 5, null, 0, false, false, false, batChase);
        batSearch = new AISTATE(AISTATEFUNC.Type.search, 6, null, 120, false, true, true, batIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.thinkSearch(sprite, xsprite);
            }
        };
        batUp = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, true, true, batChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.myMoveUp(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.thinkChase(sprite, xsprite);
            }
        };
        batDown = new AISTATE(AISTATEFUNC.Type.other, 6, null, 60, false, true, true, batChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.myMoveDown(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.thinkChase(sprite, xsprite);
            }
        };
        batTurn = new AISTATE(AISTATEFUNC.Type.other, 6, null, 60, false, true, false, batChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }
        };
        batThinkIdle = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.thinkIdle(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.myMoveForward(sprite, xsprite);
            }
        };
        batDodgeUp = new AISTATE(AISTATEFUNC.Type.other, 6, null, 120, false, true, false, batChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.myDodgeUp(sprite, xsprite);
            }
        };
        batDodgeDown = new AISTATE(AISTATEFUNC.Type.other, 6, null, 120, false, true, false, batChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIBAT.myDodgeDown(sprite, xsprite);
            }
        };
    }

    private static void BiteCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        if (!Main.boardService.isValidSprite(pXSprite.getTarget())) {
            throw new AssertException("isValidSprite(pXSprite.getTarget())");
        }
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        int dx = Trig.Cos(pSprite.getAng()) >> 16;
        int dy = Trig.Sin(pSprite.getAng()) >> 16;
        int eyeAboveZ = DudeInfo.dudeInfo[pSprite.getLotag() - 200].eyeHeight * pSprite.getYrepeat() << 2;
        int z1 = 0;
        if (pXSprite.getTarget() != -1 && Actor.IsDudeSprite(pTarget)) {
            z1 = DudeInfo.dudeInfo[pTarget.getLotag() - 200].eyeHeight * pTarget.getYrepeat() << 2;
        }
        int dz = z1 - eyeAboveZ;
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 6);
    }

    private static void thinkIdle(BloodSprite pSprite, XSPRITE pXSprite) {
        if (pSprite.getZ() - pXSprite.getTargetZ() >= 4096) {
            Ai.aiSetTarget(pXSprite, pSprite.getX(), pSprite.getY(), Main.boardService.getSector(pSprite.getSectnum()).getCeilingz());
        } else {
            pXSprite.getDudeExtra().setActive(false);
            pSprite.setHitag(0);
            Ai.aiNewState(pSprite, pXSprite, batSleep);
        }
    }

    private static void myThinkTarget(BloodSprite pSprite, XSPRITE pXSprite) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        DudeExtra dudeExtra = pXSprite.getDudeExtra();
        if (dudeExtra.isActive()) {
            if (dudeExtra.getThinkTime() >= 10) {
                dudeExtra.setThinkTime(0);
                pXSprite.setGoalAng(pXSprite.getGoalAng() + 256);
                Vector3 kSprite = pSprite.getKSprite();
                Ai.aiSetTarget(pXSprite, (int)kSprite.x, (int)kSprite.y, (int)kSprite.z);
                Ai.aiNewState(pSprite, pXSprite, batTurn);
                return;
            }
            dudeExtra.setThinkTime(dudeExtra.getThinkTime() + 1);
        }
        if (!Gameutils.Chance(pDudeInfo.alertChance / 2)) {
            return;
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (pPlayer.pXsprite.getHealth() != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int dy;
                int x = pPlayer.pSprite.getX();
                int y = pPlayer.pSprite.getY();
                int z = pPlayer.pSprite.getZ();
                short nSector = pPlayer.pSprite.getSectnum();
                int dx = x - pSprite.getX();
                int dist = EngineUtils.qdist(dx, dy = y - pSprite.getY());
                if (dist <= pDudeInfo.seeDist || dist <= pDudeInfo.hearDist) {
                    int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
                    if (Main.engine.cansee(x, y, z, nSector, pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                        int nAngle = EngineUtils.getAngle(dx, dy);
                        int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
                        if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                            Ai.aiSetTarget(pXSprite, pPlayer.nSprite);
                            Ai.aiActivateDude(pSprite, pXSprite);
                            return;
                        }
                        if (dist < pDudeInfo.hearDist) {
                            Ai.aiSetTarget(pXSprite, x, y, z);
                            Ai.aiActivateDude(pSprite, pXSprite);
                            return;
                        }
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    private static void myMoveForward(BloodSprite pSprite, XSPRITE pXSprite) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        if (pXSprite.getTarget() == -1) {
            pSprite.setAng((short)(pSprite.getAng() + 256 & 0x7FF));
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (Gameutils.Random(64) >= 32 || EngineUtils.qdist(dx, dy) > 512) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            int fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            vel = pXSprite.getTarget() == -1 ? (vel += (long)fvel) : (vel += (long)(fvel >> 1));
            pSprite.setVelocityX(Pragmas.dmulscale(vel, cos, svel, sin, 30));
            pSprite.setVelocityY(Pragmas.dmulscale(vel, sin, -svel, cos, 30));
        }
    }

    private static void myMoveUp(BloodSprite pSprite, XSPRITE pXSprite) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            pSprite.setAng((short)(pSprite.getAng() + 512 & 0x7FF));
            return;
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (!Gameutils.Chance(8192) || EngineUtils.qdist(dx, dy) > 512) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            long fvel = (long)Globals.kFrameTicks * (long)pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            pSprite.setVelocity(Pragmas.dmulscale(vel += fvel >> 1, cos, svel, sin, 30), Pragmas.dmulscale(vel, sin, -svel, cos, 30), -185685L);
        }
    }

    private static void myMoveDown(BloodSprite pSprite, XSPRITE pXSprite) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            pXSprite.setGoalAng((short)(pSprite.getAng() + 512 & 0x7FF));
            return;
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (!Gameutils.Chance(768) || EngineUtils.qdist(dx, dy) > 512) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            long fvel = (long)Globals.kFrameTicks * (long)pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            pSprite.setVelocity(Pragmas.dmulscale(vel += fvel >> 1, cos, svel, sin, 30), Pragmas.dmulscale(vel, sin, -svel, cos, 30), 279620L);
        }
    }

    public static void myDodgeUp(BloodSprite pSprite, XSPRITE pXSprite) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        long sin = Trig.Sin(pSprite.getAng());
        long cos = Trig.Cos(pSprite.getAng());
        long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
        long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
        svel = pXSprite.getDodgeDir() > 0 ? (svel += (long)pDudeInfo.sideSpeed) : (svel -= (long)pDudeInfo.sideSpeed);
        pSprite.setVelocity(Pragmas.dmulscale(vel, cos, svel, sin, 30), Pragmas.dmulscale(vel, sin, -svel, cos, 30), -338602L);
    }

    public static void myDodgeDown(BloodSprite pSprite, XSPRITE pXSprite) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (pXSprite.getDodgeDir() == 0) {
            return;
        }
        long sin = Trig.Sin(pSprite.getAng());
        long cos = Trig.Cos(pSprite.getAng());
        long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
        long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
        svel = pXSprite.getDodgeDir() > 0 ? (svel += (long)pDudeInfo.sideSpeed) : (svel -= (long)pDudeInfo.sideSpeed);
        pSprite.setVelocity(Pragmas.dmulscale(vel, cos, svel, sin, 30), Pragmas.dmulscale(vel, sin, -svel, cos, 30), 279620L);
    }

    private static void thinkSearch(BloodSprite pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.getGoalAng());
        AIBAT.myThinkTarget(pSprite, pXSprite);
    }

    private static void thinkGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, batSearch);
        }
        AIBAT.myThinkTarget(pSprite, pXSprite);
    }

    private static void thinkChase(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.getTarget() == -1) {
            Ai.aiNewState(pSprite, pXSprite, batGoto);
            return;
        }
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        if (!Main.boardService.isValidSprite(pXSprite.getTarget())) {
            throw new AssertException("isValidSprite(pXSprite.getTarget())");
        }
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            Ai.aiNewState(pSprite, pXSprite, batSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, batSearch);
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            Gameutils.GetSpriteExtents(pSprite);
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                    int floorz = Main.engine.getflorzofslope(pSprite.getSectnum(), pSprite.getX(), pSprite.getY());
                    if (Pragmas.klabs(losAngle) < 85) {
                        int targetZ = pDudeInfo.eyeHeight * pTarget.getYrepeat() << 2;
                        if (targetZ - eyeAboveZ < 8192 && dist < 512) {
                            Ai.aiNewState(pSprite, pXSprite, batBite);
                            return;
                        }
                        if ((targetZ - eyeAboveZ > 20480 || floorz - Gameutils.extents_zBot > 20480) && dist < 5120 && dist > 2048) {
                            Ai.aiNewState(pSprite, pXSprite, batDown);
                            return;
                        }
                        if (targetZ - eyeAboveZ < 12288 || floorz - Gameutils.extents_zBot < 12288) {
                            Ai.aiNewState(pSprite, pXSprite, batUp);
                            return;
                        }
                    }
                    return;
                }
            } else {
                Ai.aiNewState(pSprite, pXSprite, batUp);
                return;
            }
        }
        Ai.aiNewState(pSprite, pXSprite, batThinkIdle);
        pXSprite.setTarget(-1);
    }

    private static void thinkMove(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.getTarget() == -1) {
            Ai.aiNewState(pSprite, pXSprite, batSearch);
            return;
        }
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        if (!Main.boardService.isValidSprite(pXSprite.getTarget())) {
            throw new AssertException("isValidSprite(pXSprite.getTarget())");
        }
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            Ai.aiNewState(pSprite, pXSprite, batSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, batSearch);
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            int dz = (pDudeInfo.eyeHeight * pTarget.getYrepeat() << 2) - eyeAboveZ;
            Gameutils.GetSpriteExtents(pSprite);
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                if (Pragmas.klabs(losAngle) < 85) {
                    if (dist < 5120 && dist > 2048) {
                        if (dz < 8192) {
                            Ai.aiNewState(pSprite, pXSprite, batDodgeUp);
                            return;
                        }
                        if (dz > 24576) {
                            Ai.aiNewState(pSprite, pXSprite, batDodgeDown);
                            return;
                        }
                    }
                    if (dist < 6144 && dist > 3072) {
                        if (dz < 12288) {
                            Ai.aiNewState(pSprite, pXSprite, batDodgeUp);
                            return;
                        }
                        if (dz > 20480) {
                            Ai.aiNewState(pSprite, pXSprite, batDodgeDown);
                            return;
                        }
                    }
                    if ((dist < 512 || dist > 5120) && dz < 8192) {
                        Ai.aiNewState(pSprite, pXSprite, batDodgeUp);
                        return;
                    }
                }
                if (dz <= 16384) {
                    Ai.aiNewState(pSprite, pXSprite, batDodgeUp);
                } else {
                    Ai.aiNewState(pSprite, pXSprite, batDodgeDown);
                }
                return;
            }
        }
        Ai.aiNewState(pSprite, pXSprite, batGoto);
        pXSprite.setTarget(-1);
    }
}

