/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.AI.DudeExtra;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.WeaponAim;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.net.Mmulti;

public class AIGARG {
    private static final WeaponAim gGargData = new WeaponAim(65536, 65536, 256, 85, 0x1AAAAA);
    public static AISTATE gargoyleIdle;
    public static AISTATE gargoyleSearch;
    public static AISTATE gargoyleChase;
    public static AISTATE gargoyleRecoil;
    public static AISTATE gargoyleGoto;
    public static AISTATE gargoyleFThrow;
    public static AISTATE gargoyleFSlash;
    public static AISTATE gargoyleSThrow;
    public static AISTATE gargoyleTurn;
    public static AISTATE gargoyleUp;
    public static AISTATE gargoyleDown;
    public static AISTATE statueIdle;
    public static AISTATE statueFTransform;
    public static AISTATE statueFChase;
    public static AISTATE statueSTransform;
    public static AISTATE statueSChase;
    public static AISTATE statueFTransformNew;
    public static AISTATE statueSTransformNew;

    public static void Init() {
        statueIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, false, null);
        gargoyleIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGARG.myThinkTarget(sprite, xsprite);
            }
        };
        statueFTransform = new AISTATE(AISTATEFUNC.Type.other, -1, null, 0, true, false, false, gargoyleIdle){

            @Override
            public void enter(BloodSprite sprite, XSPRITE xsprite) {
                Actor.actHealDude(xsprite, DudeInfo.dudeInfo[6].startHealth, DudeInfo.dudeInfo[6].startHealth);
                sprite.setLotag(206);
            }
        };
        statueFTransformNew = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, true, false, true, statueFTransform){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiPlaySound(sprite, 313, 1, -1);
            }
        };
        statueFChase = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, false, false, statueFTransform);
        statueSTransform = new AISTATE(AISTATEFUNC.Type.other, -1, null, 0, true, false, false, gargoyleIdle){

            @Override
            public void enter(BloodSprite sprite, XSPRITE xsprite) {
                Actor.actHealDude(xsprite, DudeInfo.dudeInfo[7].startHealth, DudeInfo.dudeInfo[7].startHealth);
                sprite.setLotag(207);
            }
        };
        statueSTransformNew = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, true, false, true, statueSTransform){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiPlaySound(sprite, 313, 1, -1);
            }
        };
        statueSChase = new AISTATE(AISTATEFUNC.Type.other, 6, null, 0, false, false, false, statueSTransform);
        gargoyleGoto = new AISTATE(AISTATEFUNC.Type.tgoto, 0, null, 600, false, true, true, gargoyleIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIGARG.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGARG.thinkGoto(sprite, xsprite);
            }
        };
        gargoyleSearch = new AISTATE(AISTATEFUNC.Type.search, 0, null, 120, false, true, true, gargoyleIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIGARG.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGARG.thinkSearch(sprite, xsprite);
            }
        };
        gargoyleChase = new AISTATE(AISTATEFUNC.Type.other, 0, null, 0, false, true, true, gargoyleIdle){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIGARG.myMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGARG.thinkChase(sprite, xsprite);
            }
        };
        gargoyleRecoil = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, gargoyleChase);
        gargoyleFSlash = new AISTATE(AISTATEFUNC.Type.other, 6, nXSprite -> AIGARG.SlashCallback(nXSprite), 120, false, false, false, gargoyleChase);
        gargoyleFThrow = new AISTATE(AISTATEFUNC.Type.other, 6, nXSprite -> AIGARG.FThrowCallback(nXSprite), 120, false, false, false, gargoyleChase);
        gargoyleSThrow = new AISTATE(AISTATEFUNC.Type.other, 7, nXSprite -> AIGARG.SThrowCallback(nXSprite), 60, false, true, false, gargoyleChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIGARG.myMoveAttack(sprite, xsprite);
            }
        };
        gargoyleDown = new AISTATE(AISTATEFUNC.Type.other, 0, null, 120, false, true, true, gargoyleChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIGARG.myMoveDown(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGARG.thinkChase(sprite, xsprite);
            }
        };
        gargoyleUp = new AISTATE(AISTATEFUNC.Type.other, 0, null, 120, false, true, true, gargoyleChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIGARG.myMoveUp(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGARG.thinkChase(sprite, xsprite);
            }
        };
        gargoyleTurn = new AISTATE(AISTATEFUNC.Type.other, 0, null, 120, false, true, false, gargoyleChase){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveTurn(sprite, xsprite);
            }
        };
    }

    private static void FThrowCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        Actor.actFireThing(pXSprite.getReference(), 0, 0, pXSprite.getDudeExtra().getDudeSlope() - 7500, 421, 978670);
    }

    private static void SThrowCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        BloodSprite pTarget = pXSprite.getTarget() != -1 ? Main.boardService.getSprite(pXSprite.getTarget()) : null;
        Gameutils.bRandom();
        Ai.UpdateEnemyAim(pSprite, nXIndex, gGargData);
        if (Gameutils.IsPlayerSprite(pTarget) || !DemoUtils.IsOriginalDemo()) {
            Actor.actFireMissile(pSprite, -120, 0, (int)Ai.EnemyAim.x, (int)Ai.EnemyAim.y, (int)Ai.EnemyAim.z, 311);
            Actor.actFireMissile(pSprite, 120, 0, (int)Ai.EnemyAim.x, (int)Ai.EnemyAim.y, (int)Ai.EnemyAim.z, 311);
        }
    }

    private static void SlashCallback(int nXIndex) {
        int dz;
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        int dx = Trig.Cos(pSprite.getAng()) >> 16;
        int dy = Trig.Sin(pSprite.getAng()) >> 16;
        if (DemoUtils.IsOriginalDemo()) {
            BloodSprite pTarget;
            int nZOffset1 = DudeInfo.dudeInfo[pSprite.getLotag() - 200].eyeHeight * pSprite.getYrepeat() << 2;
            int nZOffset2 = 0;
            if (pXSprite.getTarget() != -1 && Actor.IsDudeSprite(pTarget = Main.boardService.getSprite(pXSprite.getTarget()))) {
                nZOffset2 = DudeInfo.dudeInfo[pTarget.getLotag() - 200].eyeHeight * pTarget.getYrepeat() << 2;
            }
            dz = nZOffset1 - nZOffset2;
        } else {
            dz = DudeInfo.dudeInfo[pSprite.getLotag() - 200].eyeHeight * pSprite.getYrepeat() << 2;
            if (pXSprite.getTarget() != -1) {
                BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
                dz = pTarget.getZ() - pSprite.getZ();
            }
        }
        int vx = dx;
        int vy = dy;
        int vz = dz;
        Actor.actFireVector(pSprite, 0, 0, vx, vy, vz, 13);
        vy = dy - Gameutils.Random(50);
        vx = dx + Gameutils.Random(50);
        Actor.actFireVector(pSprite, 0, 0, vx, vy, vz, 13);
        vy = dy + Gameutils.Random(50);
        vx = dx - Gameutils.Random(50);
        Actor.actFireVector(pSprite, 0, 0, vx, vy, vz, 13);
    }

    private static void myMoveAttack(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            pXSprite.setGoalAng((short)(pSprite.getAng() + 512 & 0x7FF));
            return;
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (!Gameutils.Chance(768) || EngineUtils.qdist(dx, dy) > 1024) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            int fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            pSprite.setVelocityX(Pragmas.dmulscale(fvel >> 1, cos, svel >> 1, sin, 30));
            pSprite.setVelocityY(Pragmas.dmulscale(fvel >> 1, sin, -(svel >> 1), cos, 30));
            if (pSprite.getLotag() == 206) {
                pSprite.setVelocityZ(279620L);
            } else if (pSprite.getLotag() == 207) {
                pSprite.setVelocityZ(218453L);
            }
        }
    }

    private static void myMoveDown(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            pXSprite.setGoalAng((short)(pSprite.getAng() + 512 & 0x7FF));
            return;
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (!Gameutils.Chance(768) || EngineUtils.qdist(dx, dy) > 1024) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            long fvel = (long)Globals.kFrameTicks * (long)pDudeInfo.frontSpeed;
            int vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            vel = (int)((long)vel + (fvel >> 1));
            pSprite.setVelocity(Pragmas.dmulscale(vel, cos, svel, sin, 30), Pragmas.dmulscale(vel, sin, -svel, cos, 30), vel);
        }
    }

    private static void myMoveUp(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            pSprite.setAng((short)(pSprite.getAng() + 512 & 0x7FF));
            return;
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (!Gameutils.Chance(8192) || EngineUtils.qdist(dx, dy) > 1024) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            long fvel = (long)Globals.kFrameTicks * (long)pDudeInfo.frontSpeed;
            int vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            vel = (int)((long)vel + (fvel >> 1));
            pSprite.setVelocity(Pragmas.dmulscale(vel, cos, svel, sin, 30), Pragmas.dmulscale(vel, sin, -svel, cos, 30), -vel);
        }
    }

    private static void myMoveForward(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        if (pXSprite.getTarget() == -1) {
            pSprite.setAng((short)(pSprite.getAng() + 256 & 0x7FF));
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (Gameutils.Random(64) >= 32 || EngineUtils.qdist(dx, dy) > 1024) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            int fvel = Globals.kFrameTicks * pDudeInfo.frontSpeed;
            long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            vel = pXSprite.getTarget() == -1 ? (vel += (long)fvel) : (vel += (long)(fvel >> 1));
            pSprite.setVelocityX(Pragmas.dmulscale(vel, cos, svel, sin, 30));
            pSprite.setVelocityY(Pragmas.dmulscale(vel, sin, -svel, cos, 30));
        }
    }

    private static void myThinkTarget(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        DudeExtra dudeExtra = pXSprite.getDudeExtra();
        if (dudeExtra.isActive()) {
            if (dudeExtra.getThinkTime() >= 10) {
                pXSprite.setGoalAng(pXSprite.getGoalAng() + 256);
                Vector3 kSprite = pSprite.getKSprite();
                Ai.aiSetTarget(pXSprite, (int)kSprite.x, (int)kSprite.y, (int)kSprite.z);
                Ai.aiNewState(pSprite, pXSprite, gargoyleTurn);
                return;
            }
            dudeExtra.setThinkTime(dudeExtra.getThinkTime() + 1);
        }
        if (!Gameutils.Chance(pDudeInfo.alertChance / 2)) {
            return;
        }
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (pPlayer.pXsprite.getHealth() != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int dy;
                int x = pPlayer.pSprite.getX();
                int y = pPlayer.pSprite.getY();
                int z = pPlayer.pSprite.getZ();
                short nSector = pPlayer.pSprite.getSectnum();
                int dx = x - pSprite.getX();
                int dist = EngineUtils.qdist(dx, dy = y - pSprite.getY());
                if (dist <= pDudeInfo.seeDist || dist <= pDudeInfo.hearDist) {
                    int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
                    if (Main.engine.cansee(x, y, z, nSector, pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                        int nAngle = EngineUtils.getAngle(dx, dy);
                        int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
                        if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                            dudeExtra.setThinkTime(0);
                            Ai.aiSetTarget(pXSprite, pPlayer.nSprite);
                            Ai.aiActivateDude(pSprite, pXSprite);
                            return;
                        }
                        if (dist < pDudeInfo.hearDist) {
                            dudeExtra.setThinkTime(0);
                            Ai.aiSetTarget(pXSprite, x, y, z);
                            Ai.aiActivateDude(pSprite, pXSprite);
                            return;
                        }
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    private static void thinkSearch(BloodSprite pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.getGoalAng());
        Ai.aiThinkTarget2(pSprite, pXSprite);
    }

    private static void thinkGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, gargoyleSearch);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void thinkChase(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.getTarget() == -1) {
            Ai.aiNewState(pSprite, pXSprite, gargoyleGoto);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            Ai.aiNewState(pSprite, pXSprite, gargoyleSearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, gargoyleSearch);
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            Gameutils.GetSpriteExtents(pSprite);
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                if (dist >= pDudeInfo.seeDist || Pragmas.klabs(losAngle) > pDudeInfo.periphery) return;
                Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                int floorz = Main.engine.getflorzofslope(pSprite.getSectnum(), pSprite.getX(), pSprite.getY());
                switch (pSprite.getLotag()) {
                    case 206: {
                        if (dist < 6144 && dist > 3072 && Pragmas.klabs(losAngle) < 85) {
                            int nInfo = Gameutils.HitScan(pSprite, pSprite.getZ(), dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                            if (nInfo == 0 || nInfo == 4) {
                                return;
                            }
                            if (nInfo == 3 && (nInfo != 3 || pSprite.getLotag() == Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() || Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() == 207)) return;
                            SOUND.sfxStart3DSound(pSprite, 1408, 0, 0);
                            Ai.aiNewState(pSprite, pXSprite, gargoyleFThrow);
                            return;
                        }
                        if (dist < 1024) {
                            if (Pragmas.klabs(losAngle) >= 85) return;
                            int nInfo = Gameutils.HitScan(pSprite, pSprite.getZ(), dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                            if (nInfo == 0 || nInfo == 4) {
                                return;
                            }
                            if (nInfo == 3 && (nInfo != 3 || pSprite.getLotag() == Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() || Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() == 207)) return;
                            SOUND.sfxStart3DSound(pSprite, 1406, 0, 0);
                            Ai.aiNewState(pSprite, pXSprite, gargoyleFSlash);
                            return;
                        }
                        int targetZ = pDudeInfo.eyeHeight * pTarget.getYrepeat() << 2;
                        if (targetZ - eyeAboveZ <= 8192 && floorz - Gameutils.extents_zBot <= 8192 || dist >= 5120 || dist <= 2560) {
                            if (targetZ - eyeAboveZ >= 8192 && floorz - Gameutils.extents_zBot >= 8192 || Pragmas.klabs(losAngle) >= 85) return;
                            Ai.aiPlaySound(pSprite, 1400, 1, -1);
                            return;
                        }
                        Ai.aiPlaySound(pSprite, 1400, 1, -1);
                        Ai.aiNewState(pSprite, pXSprite, gargoyleDown);
                        return;
                    }
                    case 207: {
                        if (dist < 6144 && dist > 3072 && Pragmas.klabs(losAngle) < 85) {
                            int nInfo = Gameutils.HitScan(pSprite, pSprite.getZ(), dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                            if (nInfo == 0 || nInfo == 4) {
                                return;
                            }
                            if (nInfo == 3 && (nInfo != 3 || pSprite.getLotag() == Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() || Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() == 206)) return;
                            SOUND.sfxStart3DSound(pSprite, 1457, 0, 0);
                            Ai.aiNewState(pSprite, pXSprite, gargoyleSThrow);
                            return;
                        }
                        if (dist < 1024) {
                            if (Pragmas.klabs(losAngle) >= 85) return;
                            int nInfo = Gameutils.HitScan(pSprite, pSprite.getZ(), dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                            if (nInfo == 0 || nInfo == 4) {
                                return;
                            }
                            if (nInfo == 3 && (nInfo != 3 || pSprite.getLotag() == Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() || Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag() == 206)) return;
                            SOUND.sfxStart3DSound(pSprite, 1406, 0, 0);
                            Ai.aiNewState(pSprite, pXSprite, gargoyleFSlash);
                            return;
                        }
                        int targetZ = pDudeInfo.eyeHeight * pTarget.getYrepeat() << 2;
                        if (targetZ - eyeAboveZ <= 8192 && floorz - Gameutils.extents_zBot <= 8192 || dist >= 5120 || dist <= 2048) {
                            if (targetZ - eyeAboveZ >= 8192 && floorz - Gameutils.extents_zBot >= 8192 || Pragmas.klabs(losAngle) >= 85) return;
                            Ai.aiPlaySound(pSprite, 1450, 1, -1);
                            return;
                        }
                        Ai.aiPlaySound(pSprite, 1450, 1, -1);
                        Ai.aiNewState(pSprite, pXSprite, gargoyleDown);
                    }
                }
                return;
            } else {
                Ai.aiNewState(pSprite, pXSprite, gargoyleUp);
            }
            return;
        } else {
            Ai.aiNewState(pSprite, pXSprite, gargoyleGoto);
            pXSprite.setTarget(-1);
        }
    }
}

