/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.AI.DudeExtra;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;

public class AIGILLBEAST {
    public static AISTATE[] gillBeastIdle = new AISTATE[2];
    public static AISTATE[] gillBeastChase = new AISTATE[2];
    public static AISTATE[] gillBeastSearch = new AISTATE[2];
    public static AISTATE[] gillBeastGoto = new AISTATE[2];
    public static AISTATE[] gillBeastDodge = new AISTATE[2];
    public static AISTATE[] gillBeastHack = new AISTATE[2];
    public static AISTATE[] gillBeastRecoil = new AISTATE[2];
    public static AISTATE gillBeastAttack;

    public static void Init() {
        AIGILLBEAST.gillBeastIdle[0] = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastChase[0] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 0, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkLandChase(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastDodge[0] = new AISTATE(AISTATEFUNC.Type.other, 9, null, 90, false, true, false, gillBeastChase[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastGoto[0] = new AISTATE(AISTATEFUNC.Type.tgoto, 9, null, 600, false, true, true, gillBeastIdle[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkLandGoto(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastHack[0] = new AISTATE(AISTATEFUNC.Type.other, 6, nXSprite -> AIGILLBEAST.HackCallback(nXSprite), 120, false, false, false, gillBeastChase[0]);
        AIGILLBEAST.gillBeastSearch[0] = new AISTATE(AISTATEFUNC.Type.search, 9, null, 120, false, true, true, gillBeastIdle[0]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkSearch(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastRecoil[0] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, gillBeastDodge[0]);
        AIGILLBEAST.gillBeastIdle[1] = new AISTATE(AISTATEFUNC.Type.idle, 10, null, 0, false, false, true, null){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiThinkTarget(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastChase[1] = new AISTATE(AISTATEFUNC.Type.other, 10, null, 600, false, true, true, null){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIGILLBEAST.aiMoveChase(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkWaterChase(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastDodge[1] = new AISTATE(AISTATEFUNC.Type.other, 10, null, 90, false, true, false, gillBeastChase[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveDodge(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastGoto[1] = new AISTATE(AISTATEFUNC.Type.tgoto, 10, null, 600, false, true, true, gillBeastIdle[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkWaterGoto(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastSearch[1] = new AISTATE(AISTATEFUNC.Type.search, 10, null, 120, false, true, true, gillBeastIdle[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                Ai.aiMoveForward(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkSearch(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastHack[1] = new AISTATE(AISTATEFUNC.Type.other, 7, nXSprite -> AIGILLBEAST.HackCallback(nXSprite), 0, false, false, true, gillBeastChase[1]){

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkWaterChase(sprite, xsprite);
            }
        };
        AIGILLBEAST.gillBeastRecoil[1] = new AISTATE(AISTATEFUNC.Type.other, 5, null, 0, false, false, false, gillBeastDodge[1]);
        gillBeastAttack = new AISTATE(AISTATEFUNC.Type.other, 10, null, 0, false, true, true, gillBeastChase[1]){

            @Override
            public void move(BloodSprite sprite, XSPRITE xsprite) {
                AIGILLBEAST.myMoveTarget(sprite, xsprite);
            }

            @Override
            public void think(BloodSprite sprite, XSPRITE xsprite) {
                AIGILLBEAST.thinkWaterChase(sprite, xsprite);
            }
        };
    }

    private static void myMoveTarget(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            pSprite.setAng((short)(pSprite.getAng() + 512 & 0x7FF));
            return;
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (!Gameutils.Chance(8192) || EngineUtils.qdist(dx, dy) > 1024) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            long vel = (long)Globals.kFrameTicks * (long)(pDudeInfo.frontSpeed - Pragmas.divscale(Globals.kFrameTicks - Globals.pGameInfo.nDifficulty, 120L, 27) / 120);
            vel = (vel >> 1) + (long)Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            int z1 = 0;
            if (pXSprite.getTarget() != -1) {
                BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
                z1 = pTarget.getZ();
                if (Actor.IsDudeSprite(pTarget)) {
                    z1 += DudeInfo.dudeInfo[pTarget.getLotag() - 200].eyeHeight;
                }
            }
            int z2 = pSprite.getZ() + pDudeInfo.eyeHeight;
            pSprite.setVelocity(Pragmas.dmulscale(vel, cos, svel, sin, 30), Pragmas.dmulscale(vel, sin, -svel, cos, 30), 8L * (long)(z1 - z2));
        }
    }

    private static void aiMoveChase(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        if (pXSprite.getTarget() == -1) {
            pSprite.setAng((short)(pSprite.getAng() + 256 & 0x7FF));
        }
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        if (Gameutils.Random(64) >= 32 || EngineUtils.qdist(dx, dy) > 1024) {
            int sin = Trig.Sin(pSprite.getAng());
            int cos = Trig.Cos(pSprite.getAng());
            long fvel = (long)Globals.kFrameTicks * (long)(pDudeInfo.frontSpeed - Pragmas.divscale(Globals.kFrameTicks - Globals.pGameInfo.nDifficulty, 120L, 27) / 120);
            long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
            long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
            vel = pXSprite.getTarget() == -1 ? (vel += fvel) : (vel += fvel >> 2);
            pSprite.setVelocityX(Pragmas.dmulscale(vel, cos, svel, sin, 30));
            pSprite.setVelocityY(Pragmas.dmulscale(vel, sin, -svel, cos, 30));
        }
    }

    private static void thinkLandGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            XSECTOR pXSector;
            XSECTOR xSECTOR = pXSector = Main.boardService.getSector(pSprite.getSectnum()).getExtra() >= 0 ? DB.xsector[Main.boardService.getSector(pSprite.getSectnum()).getExtra()] : null;
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[0]);
            }
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void thinkLandChase(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        XSECTOR pXSector;
        XSECTOR xSECTOR = pXSector = Main.boardService.getSector(pSprite.getSectnum()).getExtra() >= 0 ? DB.xsector[Main.boardService.getSector(pSprite.getSectnum()).getExtra()] : null;
        if (pXSprite.getTarget() == -1) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[0]);
            }
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[0]);
            }
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
            if (pXSector != null && pXSector.Underwater) {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
            } else {
                Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[0]);
            }
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                    int dz = pTarget.getZ() - pSprite.getZ();
                    int tan = Pragmas.divscale(dz, dist, 10);
                    DudeExtra pDudeExtra = pXSprite.getDudeExtra();
                    pDudeExtra.setDudeSlope(tan);
                    if (dist < 921 && Pragmas.klabs(losAngle) < 28) {
                        int nInfo = Gameutils.HitScan(pSprite, pSprite.getZ(), dx, dy, 0, Engine.pHitInfo, 0x1000040, 0);
                        if (nInfo == 3 && pSprite.getLotag() == Main.boardService.getSprite(Engine.pHitInfo.hitsprite).getLotag()) {
                            if (pXSector != null && pXSector.Underwater) {
                                Ai.aiNewState(pSprite, pXSprite, gillBeastDodge[1]);
                            } else {
                                Ai.aiNewState(pSprite, pXSprite, gillBeastDodge[0]);
                            }
                            return;
                        }
                        if (pXSector != null && pXSector.Underwater) {
                            Ai.aiNewState(pSprite, pXSprite, gillBeastHack[1]);
                        } else {
                            Ai.aiNewState(pSprite, pXSprite, gillBeastHack[0]);
                        }
                    }
                }
                return;
            }
        }
        if (pXSector != null && pXSector.Underwater) {
            Ai.aiNewState(pSprite, pXSprite, gillBeastGoto[1]);
        } else {
            Ai.aiNewState(pSprite, pXSprite, gillBeastGoto[0]);
        }
        SOUND.sfxStart3DSound(pSprite, 1701, -1, 0);
        pXSprite.setTarget(-1);
    }

    private static void thinkWaterChase(BloodSprite pSprite, XSPRITE pXSprite) {
        PLAYER pPlayer;
        if (pXSprite.getTarget() == -1) {
            Ai.aiNewState(pSprite, pXSprite, gillBeastGoto[1]);
            return;
        }
        if (!Actor.IsDudeSprite(pSprite) || !Main.boardService.isValidSprite(pXSprite.getTarget())) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - pSprite.getX();
        int dy = pTarget.getY() - pSprite.getY();
        Ai.aiChooseDirection(pSprite, pXSprite, EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0) {
            Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
            return;
        }
        int dist = EngineUtils.qdist(dx, dy);
        if (dist <= pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = pDudeInfo.eyeHeight;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), pSprite.getX(), pSprite.getY(), -eyeAboveZ, pSprite.getSectnum())) {
                if (dist < pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                    Ai.aiSetTarget(pXSprite, pXSprite.getTarget());
                    if (dist < 1024 && Pragmas.klabs(losAngle) < 85) {
                        Ai.aiNewState(pSprite, pXSprite, gillBeastHack[1]);
                        return;
                    }
                    Ai.aiPlaySound(pSprite, 1700, 1, -1);
                    Ai.aiNewState(pSprite, pXSprite, gillBeastAttack);
                }
            } else {
                Ai.aiNewState(pSprite, pXSprite, gillBeastAttack);
            }
            return;
        }
        Ai.aiNewState(pSprite, pXSprite, gillBeastGoto[1]);
        pXSprite.setTarget(-1);
    }

    private static void thinkWaterGoto(BloodSprite pSprite, XSPRITE pXSprite) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dx = pXSprite.getTargetX() - pSprite.getX();
        int dy = pXSprite.getTargetY() - pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = EngineUtils.qdist(dx, dy);
        Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
        if (dist < Gameutils.M2X(1.0) && Pragmas.klabs(pSprite.getAng() - nAngle) < pDudeInfo.periphery) {
            Ai.aiNewState(pSprite, pXSprite, gillBeastSearch[1]);
        }
        Ai.aiThinkTarget(pSprite, pXSprite);
    }

    private static void HackCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        int nSprite = pXSprite.getReference();
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        int dx = Trig.Cos(pSprite.getAng()) >> 16;
        int dy = Trig.Sin(pSprite.getAng()) >> 16;
        int dz = pSprite.getZ();
        if (pXSprite.getTarget() != -1) {
            BloodSprite pTarget = Main.boardService.getSprite(pXSprite.getTarget());
            dz -= pTarget.getZ();
        }
        Actor.actFireVector(pSprite, 0, 0, dx += Gameutils.BiRandom2(2000), dy += Gameutils.BiRandom2(2000), dz, 8);
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 8);
        Actor.actFireVector(pSprite, 0, 0, dx, dy, dz, 8);
    }

    private static void thinkSearch(BloodSprite pSprite, XSPRITE pXSprite) {
        Ai.aiChooseDirection(pSprite, pXSprite, pXSprite.getGoalAng());
        Ai.aiThinkTarget(pSprite, pXSprite);
    }
}

