/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import com.badlogic.gdx.math.Vector3;
import ru.m210projects.Blood.AI.AIBAT;
import ru.m210projects.Blood.AI.AIBEAST;
import ru.m210projects.Blood.AI.AIBONEEL;
import ru.m210projects.Blood.AI.AIBURN;
import ru.m210projects.Blood.AI.AICALEB;
import ru.m210projects.Blood.AI.AICERBERUS;
import ru.m210projects.Blood.AI.AICULTIST;
import ru.m210projects.Blood.AI.AIGARG;
import ru.m210projects.Blood.AI.AIGHOST;
import ru.m210projects.Blood.AI.AIGILLBEAST;
import ru.m210projects.Blood.AI.AIHAND;
import ru.m210projects.Blood.AI.AIHOUND;
import ru.m210projects.Blood.AI.AIINNOCENT;
import ru.m210projects.Blood.AI.AIPOD;
import ru.m210projects.Blood.AI.AIRAT;
import ru.m210projects.Blood.AI.AISPID;
import ru.m210projects.Blood.AI.AISTATE;
import ru.m210projects.Blood.AI.AISTATEFUNC;
import ru.m210projects.Blood.AI.AITCHERNOBOG;
import ru.m210projects.Blood.AI.AIUNICULT;
import ru.m210projects.Blood.AI.AIZOMBA;
import ru.m210projects.Blood.AI.AIZOMBF;
import ru.m210projects.Blood.AI.DudeExtra;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.WeaponAim;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Serializable;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.net.Mmulti;

public class Ai {
    public static final int LAND = 0;
    public static final int WATER = 1;
    public static final int DUCK = 2;
    public static final int kAIThinkMask = 3;
    public static AISTATE genIdle;
    public static AISTATE genRecoil;
    public static Vector3 EnemyAim;

    public static void aiNewState(BloodSprite pSprite, XSPRITE pXSprite, AISTATE pState) {
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        pXSprite.setStateTimer(pState.ticks);
        pXSprite.setAIState(pState);
        int seqStartId = pDudeInfo.seqStartID;
        if (pState.seqId >= 0) {
            switch (pSprite.getLotag()) {
                case 254: 
                case 255: {
                    seqStartId = pXSprite.getData2();
                }
            }
            if (!Main.game.getCache().contains(seqStartId + pState.seqId, "SEQ")) {
                return;
            }
            SeqHandling.seqSpawn(seqStartId + pState.seqId, 3, pSprite.getExtra(), pState.callback);
        }
        if (pState.enter) {
            pState.enter(pSprite, pXSprite);
        }
    }

    public static boolean dudeIsImmune(Sprite pSprite, int dmgType) {
        if (dmgType < 0 || dmgType > 6) {
            return true;
        }
        if (DudeInfo.dudeInfo[pSprite.getLotag() - 200].startDamage[dmgType] == 0) {
            return true;
        }
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        return pXSprite != null && pXSprite.getLocked() == 1;
    }

    protected static boolean CanMove(Sprite pSprite, int nTarget, int ang, int dist) {
        BloodSprite pLower;
        BloodSprite pUpper;
        int dx = Pragmas.mulscale(dist, Trig.Cos(ang), 30);
        int dy = Pragmas.mulscale(dist, Trig.Sin(ang), 30);
        int x = pSprite.getX();
        int y = pSprite.getY();
        int z = pSprite.getZ();
        Gameutils.HitScan(pSprite, z, Trig.Cos(ang) >> 16, Trig.Sin(ang) >> 16, 0, Engine.pHitInfo, 65537, dist);
        int hitDist = EngineUtils.qdist(x - Engine.pHitInfo.hitx, y - Engine.pHitInfo.hity);
        if (hitDist - (pSprite.getClipdist() << 2) < dist) {
            return Engine.pHitInfo.hitsprite != -1 && Engine.pHitInfo.hitsprite == nTarget;
        }
        if (!Gameutils.FindSector(x += dx, y += dy, z, pSprite.getSectnum())) {
            return false;
        }
        long floorZ = Main.engine.getflorzofslope(Gameutils.foundSector, x, y);
        short nXSector = Main.boardService.getSector(Gameutils.foundSector).getExtra();
        boolean Water = false;
        boolean Underwater = false;
        boolean Depth = false;
        boolean Crusher = false;
        XSECTOR pXSector = null;
        if (nXSector > 0) {
            pXSector = DB.xsector[nXSector];
            if (pXSector.Underwater) {
                Underwater = true;
            }
            if (pXSector.Depth != 0) {
                Depth = true;
            }
            if (Main.boardService.getSector(Gameutils.foundSector).getLotag() == 618 || pXSector.damageType != 0) {
                switch (pSprite.getLotag()) {
                    case 227: 
                    case 228: {
                        if (Ai.dudeIsImmune(pSprite, pXSector.damageType) && !DemoUtils.IsOriginalDemo()) break;
                        Crusher = true;
                        break;
                    }
                    default: {
                        Crusher = true;
                    }
                }
            }
        }
        int nUpper = Warp.gUpperLink[Gameutils.foundSector];
        int nLower = Warp.gLowerLink[Gameutils.foundSector];
        if (nUpper >= 0 && ((pUpper = Main.boardService.getSprite(nUpper)).getLotag() == 9 || pUpper.getLotag() == 13)) {
            Depth = true;
            Water = true;
        }
        if (nLower >= 0 && ((pLower = Main.boardService.getSprite(nLower)).getLotag() == 10 || pLower.getLotag() == 14)) {
            Depth = true;
        }
        Gameutils.GetSpriteExtents(pSprite);
        switch (pSprite.getLotag()) {
            case 204: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 220: 
            case 227: 
            case 245: {
                if (Crusher) {
                    return false;
                }
                if (Depth || Underwater) {
                    return false;
                }
                return floorZ - (long)Gameutils.extents_zBot <= (long)Gameutils.M2Z(1.0);
            }
            case 218: {
                if (Water || !Underwater) {
                    return false;
                }
                if (Underwater) {
                    return true;
                }
                return true;
            }
            case 206: 
            case 207: 
            case 219: {
                if (pSprite.getClipdist() > hitDist) {
                    return false;
                }
                return !Depth;
            }
            case 254: 
            case 255: {
                return (!Crusher || Ai.dudeIsImmune(pSprite, pXSector.damageType)) && (!Water && !Underwater || AIUNICULT.canSwim(pSprite));
            }
        }
        if (Crusher) {
            return false;
        }
        return pXSector != null && pXSector.Depth != 0 || pXSector != null && pXSector.Underwater || floorZ - (long)Gameutils.extents_zBot <= (long)Gameutils.M2Z(1.0);
    }

    protected static void aiChooseDirection(BloodSprite pSprite, XSPRITE pXSprite, int ang) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        int dang = (1024 + ang - pSprite.getAng() & 0x7FF) - 1024;
        int sin = Trig.Sin(pSprite.getAng());
        int cos = Trig.Cos(pSprite.getAng());
        long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
        int avoidDist = (int)((15L * vel >> 12) - (15L * vel >> 43) >> 1);
        int turnTo = 341;
        if (dang < 0) {
            turnTo = -turnTo;
        }
        if (Ai.CanMove(pSprite, pXSprite.getTarget(), pSprite.getAng() + dang, avoidDist)) {
            pXSprite.setGoalAng(pSprite.getAng() + dang & 0x7FF);
        } else if (Ai.CanMove(pSprite, pXSprite.getTarget(), pSprite.getAng() + dang / 2, avoidDist)) {
            pXSprite.setGoalAng(pSprite.getAng() + dang / 2 & 0x7FF);
        } else if (Ai.CanMove(pSprite, pXSprite.getTarget(), pSprite.getAng() - dang / 2, avoidDist)) {
            pXSprite.setGoalAng(pSprite.getAng() - dang / 2 & 0x7FF);
        } else if (Ai.CanMove(pSprite, pXSprite.getTarget(), pSprite.getAng() + turnTo, avoidDist)) {
            pXSprite.setGoalAng(pSprite.getAng() + turnTo & 0x7FF);
        } else if (Ai.CanMove(pSprite, pXSprite.getTarget(), pSprite.getAng(), avoidDist)) {
            pXSprite.setGoalAng(pSprite.getAng());
        } else if (Ai.CanMove(pSprite, pXSprite.getTarget(), pSprite.getAng() - turnTo, avoidDist)) {
            pXSprite.setGoalAng(pSprite.getAng() - turnTo & 0x7FF);
        } else {
            pXSprite.setGoalAng(pSprite.getAng() + 341 & 0x7FF);
        }
        pXSprite.setDodgeDir(Gameutils.Chance(16384) ? 1 : -1);
        if (!Ai.CanMove(pSprite, pXSprite.getTarget(), pSprite.getAng() + 512 * pXSprite.getDodgeDir(), 512)) {
            pXSprite.setDodgeDir(-pXSprite.getDodgeDir());
            if (!Ai.CanMove(pSprite, pXSprite.getTarget(), pSprite.getAng() + 512 * pXSprite.getDodgeDir(), 512)) {
                pXSprite.setDodgeDir(0);
            }
        }
    }

    protected static void aiMoveForward(BloodSprite pSprite, XSPRITE pXSprite) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (Pragmas.klabs(dang) > 341) {
            return;
        }
        int sin = Trig.Sin(pSprite.getAng());
        int cos = Trig.Cos(pSprite.getAng());
        int frontSpeed = pDudeInfo.frontSpeed;
        if (pSprite.getLotag() == 239 && DemoUtils.IsOriginalDemo()) {
            frontSpeed = 0;
        }
        pSprite.addVelocity(Pragmas.mulscale(cos, frontSpeed, 30), Pragmas.mulscale(sin, frontSpeed, 30), 0L);
    }

    protected static void aiMoveTurn(Sprite pSprite, XSPRITE pXSprite) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
    }

    protected static void aiMoveDodge(BloodSprite pSprite, XSPRITE pXSprite) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int dang = (1024 + pXSprite.getGoalAng() - pSprite.getAng() & 0x7FF) - 1024;
        int maxTurn = pDudeInfo.angSpeed * Globals.kFrameTicks >> 4;
        pSprite.setAng((short)(pSprite.getAng() + Gameutils.ClipRange(dang, -maxTurn, maxTurn) & 0x7FF));
        if (pXSprite.getDodgeDir() == 0) {
            return;
        }
        long sin = Trig.Sin(pSprite.getAng());
        long cos = Trig.Cos(pSprite.getAng());
        long vel = Pragmas.dmulscale(pSprite.getVelocityX(), cos, pSprite.getVelocityY(), sin, 30);
        long svel = Pragmas.dmulscale(pSprite.getVelocityX(), sin, -pSprite.getVelocityY(), cos, 30);
        svel = pXSprite.getDodgeDir() > 0 ? (svel += (long)pDudeInfo.sideSpeed) : (svel -= (long)pDudeInfo.sideSpeed);
        pSprite.setVelocityX(Pragmas.dmulscale(vel, cos, svel, sin, 30));
        pSprite.setVelocityY(Pragmas.dmulscale(vel, sin, -svel, cos, 30));
    }

    public static void aiActivateDude(BloodSprite pSprite, XSPRITE pXPad) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        XSPRITE pXSprite = pSprite.getXSprite();
        if (pXSprite.getState() == 0) {
            int nAngle = EngineUtils.getAngle(pXSprite.getTargetX() - pSprite.getX(), pXSprite.getTargetY() - pSprite.getY());
            Ai.aiChooseDirection(pSprite, pXSprite, nAngle);
            pXSprite.setState(1);
        }
        DudeExtra pDudeExtra = pXSprite.getDudeExtra();
        switch (pSprite.getLotag()) {
            case 210: {
                pDudeExtra.setActive(true);
                pDudeExtra.setThinkTime(0);
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIGHOST.ghostSearch);
                    break;
                }
                Ai.aiPlaySound(pSprite, 1600, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AIGHOST.ghostChase);
                break;
            }
            case 201: 
            case 202: 
            case 247: 
            case 248: 
            case 249: {
                pDudeExtra.setActive(true);
                if (pXSprite.getTarget() == -1) {
                    if (pXSprite.getPalette() != 0 && pXSprite.getPalette() <= 2) {
                        Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistSearch[0]);
                    if (!Gameutils.Chance(16384)) break;
                    if (pSprite.getLotag() == 201) {
                        Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 4008, 1, -1);
                        break;
                    }
                    Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 1008, 1, -1);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    if (pSprite.getLotag() == 201) {
                        Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 4003, 1, -1);
                    } else {
                        Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 1003, 1, -1);
                    }
                }
                if (pXSprite.getPalette() != 0 && pXSprite.getPalette() <= 2) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistChase[1]);
                    break;
                }
                if (pSprite.getLotag() == 201) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistTurn);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistChase[0]);
                break;
            }
            case 254: {
                pDudeExtra.setActive(true);
                if (pXSprite.getTarget() == -1) {
                    if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                        Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeSearch[0]);
                    if (!Gameutils.Chance(16384)) break;
                    AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 0);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 0);
                }
                if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeChase[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeChase[0]);
                break;
            }
            case 230: {
                pSprite.setLotag(201);
                pDudeExtra.setActive(true);
                if (pXSprite.getTarget() == -1) {
                    if (pXSprite.getPalette() != 0 && pXSprite.getPalette() <= 2) {
                        Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistSearch[0]);
                    if (!Gameutils.Chance(16384)) break;
                    Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 4008, 1, -1);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 4008, 1, -1);
                }
                if (pXSprite.getPalette() == 1 || pXSprite.getPalette() == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistChase[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistChase[2]);
                break;
            }
            case 246: {
                pSprite.setLotag(202);
                pDudeExtra.setActive(true);
                if (pXSprite.getTarget() == -1) {
                    if (pXSprite.getPalette() != 0 && pXSprite.getPalette() <= 2) {
                        Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistSearch[0]);
                    if (!Gameutils.Chance(16384)) break;
                    Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 1008, 1, -1);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    Ai.aiPlaySound(pSprite, Gameutils.Random(5) + 1003, 1, -1);
                }
                if (pXSprite.getPalette() == 1 || pXSprite.getPalette() == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistChase[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistChase[2]);
                break;
            }
            case 240: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnSearch[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnChase[1]);
                break;
            }
            case 255: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnSearch[6]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnChase[6]);
                break;
            }
            case 219: {
                pDudeExtra.setActive(true);
                pDudeExtra.setThinkTime(0);
                if (pSprite.getHitag() == 0) {
                    pSprite.setHitag(9);
                }
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBAT.batSearch);
                    break;
                }
                if (Gameutils.Chance(20480)) {
                    Ai.aiPlaySound(pSprite, 2000, 1, -1);
                }
                Ai.aiNewState(pSprite, pXSprite, AIBAT.batChase);
                break;
            }
            case 218: {
                pDudeExtra.setActive(true);
                pDudeExtra.setThinkTime(0);
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBONEEL.boneelSearch);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    Ai.aiPlaySound(pSprite, 1501, 1, -1);
                } else {
                    Ai.aiPlaySound(pSprite, 1500, 1, -1);
                }
                Ai.aiNewState(pSprite, pXSprite, AIBONEEL.boneelChase);
                break;
            }
            case 217: {
                XSECTOR pXSector;
                pDudeExtra.setActive(true);
                pDudeExtra.setThinkTime(0);
                XSECTOR xSECTOR = pXSector = Main.boardService.getSector(pSprite.getSectnum()).getExtra() >= 0 ? DB.xsector[Main.boardService.getSector(pSprite.getSectnum()).getExtra()] : null;
                if (pXSprite.getTarget() == -1) {
                    if (pXSector != null && pXSector.Underwater) {
                        Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastSearch[0]);
                    break;
                }
                if (Gameutils.Chance(8192)) {
                    Ai.aiPlaySound(pSprite, 1701, 1, -1);
                } else {
                    Ai.aiPlaySound(pSprite, 1700, 1, -1);
                }
                if (pXSector != null && pXSector.Underwater) {
                    Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastChase[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastChase[0]);
                break;
            }
            case 203: {
                pDudeExtra.setThinkTime(1);
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieASearch);
                    break;
                }
                if (!Gameutils.Chance(20480)) {
                    Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieAChase);
                    break;
                }
                Ai.aiPlaySound(pSprite, Gameutils.Random(3) + 1103, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieAChase);
                break;
            }
            case 205: {
                pDudeExtra.setThinkTime(1);
                if (pXSprite.getAIState() != AIZOMBA.zombieEIdle) break;
                Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieEUp);
                break;
            }
            case 244: {
                pDudeExtra.setThinkTime(1);
                if (pXSprite.getAIState() != AIZOMBA.zombieSLIdle) break;
                Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieSLUP);
                break;
            }
            case 204: {
                pDudeExtra.setThinkTime(1);
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIZOMBF.zombieFSearch);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    Ai.aiPlaySound(pSprite, 1201, 1, -1);
                } else {
                    Ai.aiPlaySound(pSprite, 1200, 1, -1);
                }
                Ai.aiNewState(pSprite, pXSprite, AIZOMBF.zombieFChase);
                break;
            }
            case 241: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnSearch[2]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnChase[2]);
                break;
            }
            case 252: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnSearch[4]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnChase[4]);
                break;
            }
            case 242: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnSearch[3]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnChase[0]);
                break;
            }
            case 206: 
            case 207: {
                pDudeExtra.setActive(true);
                pDudeExtra.setThinkTime(0);
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIGARG.gargoyleSearch);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIGARG.gargoyleChase);
                if (pSprite.getLotag() == 206) {
                    if (Gameutils.Chance(16384)) {
                        Ai.aiPlaySound(pSprite, 1401, 1, -1);
                        break;
                    }
                    Ai.aiPlaySound(pSprite, 1400, 1, -1);
                    break;
                }
                if (Gameutils.Chance(16384)) {
                    Ai.aiPlaySound(pSprite, 1451, 1, -1);
                    break;
                }
                Ai.aiPlaySound(pSprite, 1450, 1, -1);
                break;
            }
            case 208: 
            case 209: {
                if (DemoUtils.IsOriginalDemo() || pXSprite.getData1() != 1) {
                    if (Gameutils.Chance(16384)) {
                        Ai.aiPlaySound(pSprite, 1401, 1, -1);
                    } else {
                        Ai.aiPlaySound(pSprite, 1400, 1, -1);
                    }
                    if (pSprite.getLotag() == 208) {
                        Ai.aiNewState(pSprite, pXSprite, AIGARG.statueFChase);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AIGARG.statueSChase);
                    break;
                }
                if (pSprite.getLotag() == 208) {
                    Ai.aiNewState(pSprite, pXSprite, AIGARG.statueFTransformNew);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIGARG.statueSTransformNew);
                break;
            }
            case 227: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusSearch[0]);
                    break;
                }
                Ai.aiPlaySound(pSprite, 2300, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusChase[0]);
                break;
            }
            case 228: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusSearch[1]);
                    break;
                }
                Ai.aiPlaySound(pSprite, 2300, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusChase[1]);
                break;
            }
            case 211: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIHOUND.houndSearch);
                    break;
                }
                Ai.aiPlaySound(pSprite, 1300, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AIHOUND.houndChase);
                break;
            }
            case 212: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIHAND.handSearch);
                    break;
                }
                Ai.aiPlaySound(pSprite, 1900, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AIHAND.handChase);
                break;
            }
            case 220: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIRAT.ratSearch);
                    break;
                }
                Ai.aiPlaySound(pSprite, 2100, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AIRAT.ratChase);
                break;
            }
            case 245: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIINNOCENT.innocentSearch);
                    break;
                }
                if (pXSprite.getHealth() > 0) {
                    Ai.aiPlaySound(pSprite, Gameutils.BiRandom(6) + 7000, 1, -1);
                }
                Ai.aiNewState(pSprite, pXSprite, AIINNOCENT.innocentChase);
                break;
            }
            case 229: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AITCHERNOBOG.tchernobogSearch);
                    break;
                }
                Ai.aiPlaySound(pSprite, Gameutils.Random(7) + 2350, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AITCHERNOBOG.tchernobogChase);
                break;
            }
            case 213: 
            case 214: 
            case 215: 
            case 216: {
                if (pSprite.getLotag() == 216) {
                    pDudeExtra.setActive(true);
                }
                pSprite.setCstat(pSprite.getCstat() & 0xFFFFFFF7);
                pSprite.setHitag(pSprite.getHitag() | 2);
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AISPID.spidSearch);
                    break;
                }
                if (pSprite.getLotag() != 216) {
                    Ai.aiPlaySound(pSprite, 1800, 1, -1);
                } else {
                    Ai.aiPlaySound(pSprite, Gameutils.Random(1) + 1853, 1, -1);
                }
                Ai.aiNewState(pSprite, pXSprite, AISPID.spidChase);
                break;
            }
            case 250: {
                pDudeExtra.setThinkTime(1);
                if (pXSprite.getTarget() == -1) {
                    if (pXSprite.getPalette() == 1 || pXSprite.getPalette() == 2) {
                        Ai.aiNewState(pSprite, pXSprite, AICALEB.calebSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AICALEB.calebSearch[0]);
                    break;
                }
                if (pXSprite.getPalette() == 1 || pXSprite.getPalette() == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AICALEB.calebChase[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICALEB.calebChase[0]);
                break;
            }
            case 251: {
                if (pXSprite.getTarget() == -1) {
                    if (pXSprite.getPalette() == 1 || pXSprite.getPalette() == 2) {
                        Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastSearch[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastSearch[0]);
                    break;
                }
                Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 9009, 1, -1);
                if (pXSprite.getPalette() == 1 || pXSprite.getPalette() == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastChase[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastChase[0]);
                break;
            }
            case 221: 
            case 223: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIPOD.podSearch);
                    break;
                }
                if (pSprite.getLotag() == 223) {
                    Ai.aiPlaySound(pSprite, 2453, 1, -1);
                } else {
                    Ai.aiPlaySound(pSprite, 2473, 1, -1);
                }
                Ai.aiNewState(pSprite, pXSprite, AIPOD.podChase);
                break;
            }
            case 222: 
            case 224: {
                if (pXSprite.getTarget() == -1) {
                    Ai.aiNewState(pSprite, pXSprite, AIPOD.tentacleSearch);
                    break;
                }
                Ai.aiPlaySound(pSprite, 2503, 1, -1);
                Ai.aiNewState(pSprite, pXSprite, AIPOD.tentacleChase);
            }
        }
    }

    public static void aiSetTarget(XSPRITE pXSprite, int x, int y, int z) {
        pXSprite.setTarget(-1);
        pXSprite.setTargetX(x);
        pXSprite.setTargetY(y);
        pXSprite.setTargetZ(z);
    }

    public static void aiSetTarget(XSPRITE pXSprite, int nTarget) {
        if (!Main.boardService.isValidSprite(nTarget)) {
            throw new AssertException("isValidSprite(nTarget)");
        }
        BloodSprite pTarget = Main.boardService.getSprite(nTarget);
        if (pTarget.getLotag() < 200 || pTarget.getLotag() >= 256) {
            return;
        }
        if (nTarget == Main.boardService.getSprite(pXSprite.getReference()).getOwner()) {
            return;
        }
        DudeInfo pTargetInfo = DudeInfo.dudeInfo[pTarget.getLotag() - 200];
        pXSprite.setTarget(nTarget);
        pXSprite.setTargetX(pTarget.getX());
        pXSprite.setTargetY(pTarget.getY());
        pXSprite.setTargetZ(pTarget.getZ() - (pTargetInfo.eyeHeight * pTarget.getYrepeat() << 2));
    }

    public static int aiDamageSprite(BloodSprite pSprite, XSPRITE pXSprite, int nSource, int nDamageType, int nDamage) {
        if (!Main.boardService.isValidSprite(nSource)) {
            throw new AssertException("isValidSprite(nSource)");
        }
        if (pXSprite.getHealth() == 0) {
            return 0;
        }
        pXSprite.setHealth(Gameutils.ClipLow(pXSprite.getHealth() - nDamage, 0));
        DudeExtra xDude = pXSprite.getDudeExtra();
        xDude.setCumulDamage(xDude.getCumulDamage() + nDamage);
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        if (nSource >= 0) {
            if (nSource == pXSprite.getReference()) {
                return 0;
            }
            if (pXSprite.getTarget() == -1) {
                Ai.aiSetTarget(pXSprite, nSource);
                Ai.aiActivateDude(pSprite, pXSprite);
            } else if (nSource != pXSprite.getTarget()) {
                int nThresh = nDamage;
                nThresh = Main.boardService.getSprite(nSource).getLotag() == pSprite.getLotag() ? (nThresh *= pDudeInfo.changeTargetKin) : (nThresh *= pDudeInfo.changeTarget);
                if (Gameutils.Chance(nThresh / 2)) {
                    Ai.aiSetTarget(pXSprite, nSource);
                    Ai.aiActivateDude(pSprite, pXSprite);
                }
            }
            if (nDamageType == 6) {
                xDude.setTeslaHit(true);
            } else if (!DemoUtils.IsOriginalDemo()) {
                xDude.setTeslaHit(false);
            }
            switch (pSprite.getLotag()) {
                case 206: {
                    Ai.aiNewState(pSprite, pXSprite, AIGARG.gargoyleChase);
                    break;
                }
                case 240: {
                    if (Gameutils.Chance(8192) && Globals.gFrameClock > xDude.getClock()) {
                        Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 1031, 2, -1);
                        xDude.setClock(Globals.gFrameClock + 360);
                    }
                    boolean tommyChance = Gameutils.Chance(768);
                    if (pXSprite.getPalette() != 1 && pXSprite.getPalette() != 2) break;
                    if (tommyChance) {
                        pSprite.setLotag(201);
                    } else {
                        pSprite.setLotag(202);
                    }
                    pXSprite.setBurnTime(0);
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistGoto[1]);
                    break;
                }
                case 255: {
                    if (Gameutils.Chance(8192) && Globals.gFrameClock > xDude.getClock()) {
                        AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 3);
                        xDude.setClock(Globals.gFrameClock + 360);
                    }
                    if (pXSprite.getBurnTime() <= 0) {
                        pXSprite.setBurnTime(2400);
                    }
                    if (!AIUNICULT.spriteIsUnderwater(pSprite, false)) break;
                    pSprite.setLotag(254);
                    pXSprite.setBurnTime(0);
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeGoto[1]);
                    break;
                }
                case 245: {
                    if (nDamageType != 1 || pXSprite.getHealth() > pDudeInfo.fleeHealth) break;
                    Ai.aiPlaySound(pSprite, 361, 0, -1);
                    pSprite.setLotag(239);
                    xDude.setClock(Globals.gFrameClock + 360);
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[1]);
                    Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[39].startHealth, DudeInfo.dudeInfo[39].startHealth);
                    if (!DemoUtils.IsOriginalDemo() && pXSprite.getBurnTime() == 0) {
                        pXSprite.setBurnTime(1200);
                    }
                    EVENT.checkEventList(pXSprite.getReference(), 3, 0);
                    break;
                }
                case 249: {
                    if (pXSprite.getHealth() > pDudeInfo.fleeHealth) break;
                    Ai.aiPlaySound(pSprite, 9008, 0, -1);
                    pSprite.setLotag(251);
                    Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastTransforming);
                    Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[51].startHealth, DudeInfo.dudeInfo[51].startHealth);
                    break;
                }
                case 250: {
                    if (nDamageType != 1 || pXSprite.getHealth() > pDudeInfo.fleeHealth) break;
                    Ai.aiPlaySound(pSprite, 361, 0, -1);
                    if (!DemoUtils.IsOriginalDemo()) {
                        if (pXSprite.getBurnTime() == 0) {
                            pXSprite.setBurnTime(1200);
                        }
                        pSprite.setLotag(252);
                        Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[4]);
                        Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[51].startHealth, DudeInfo.dudeInfo[51].startHealth);
                    } else {
                        pSprite.setLotag(239);
                        Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[1]);
                        Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[39].startHealth, DudeInfo.dudeInfo[39].startHealth);
                    }
                    xDude.setClock(Globals.gFrameClock + 360);
                    EVENT.checkEventList(pXSprite.getReference(), 3, 0);
                    break;
                }
                case 254: {
                    int chance3;
                    if (nDamageType == 1) {
                        if (pXSprite.getHealth() > pDudeInfo.fleeHealth) break;
                        if (EVENT.getNextIncarnation(pXSprite) == null) {
                            AIUNICULT.removeDudeStuff(pSprite);
                            if (pXSprite.getData1() >= 459 && pXSprite.getData1() < 467) {
                                AIUNICULT.doExplosion(pSprite, pXSprite.getData1() - 459);
                            }
                            if (AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                                pXSprite.setHealth(0);
                                break;
                            }
                            if (!Main.game.getCache().contains(pXSprite.getData2() + 15, "SEQ") && !Main.game.getCache().contains(pXSprite.getData2() + 16, "SEQ") || !Main.game.getCache().contains(pXSprite.getData2() + 3, "SEQ")) break;
                            Ai.aiPlaySound(pSprite, 361, 0, -1);
                            AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 3);
                            pSprite.setLotag(255);
                            if (pXSprite.getData2() == 11520) {
                                pSprite.setPal(12);
                            }
                            Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[1]);
                            Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[55].startHealth, DudeInfo.dudeInfo[55].startHealth);
                            xDude.setClock(Globals.gFrameClock + 360);
                            EVENT.checkEventList(pXSprite.getReference(), 3, 0);
                            break;
                        }
                        Actor.actKillSprite(nSource, pSprite, nDamageType, nDamage);
                        break;
                    }
                    if (AIUNICULT.inDodge(pXSprite.getAIState()) || !Gameutils.Chance(chance3 = AIUNICULT.getDodgeChance(pSprite)) && !AIUNICULT.inIdle(pXSprite.getAIState())) break;
                    if (!AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                        if (!AIUNICULT.canDuck(pSprite) || !AIUNICULT.checkUniCultistSeq(pSprite, 14)) {
                            Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeDodgeDmg[0]);
                        } else {
                            Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeDodgeDmg[2]);
                        }
                        if (!Gameutils.Chance(512)) break;
                        AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 1);
                        break;
                    }
                    if (!AIUNICULT.checkUniCultistSeq(pSprite, 13)) break;
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeDodgeDmg[1]);
                    break;
                }
                case 201: 
                case 202: 
                case 247: 
                case 248: {
                    if (nDamageType == 1) {
                        if (pXSprite.getHealth() > pDudeInfo.fleeHealth) break;
                        if (!DemoUtils.IsOriginalDemo()) {
                            if (pXSprite.getPalette() != 0) {
                                pXSprite.setHealth(0);
                                break;
                            }
                            if (pXSprite.getBurnTime() == 0) {
                                pXSprite.setBurnTime(1200);
                            }
                        }
                        Ai.aiPlaySound(pSprite, 361, 0, -1);
                        Ai.aiPlaySound(pSprite, 1031 + Gameutils.Random(2), 2, -1);
                        pSprite.setLotag(240);
                        Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[1]);
                        Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[40].startHealth, DudeInfo.dudeInfo[40].startHealth);
                        xDude.setClock(Globals.gFrameClock + 360);
                        EVENT.checkEventList(pXSprite.getReference(), 3, 0);
                        break;
                    }
                    if (pXSprite.getPalette() == 0) {
                        if (!AICULTIST.checkDudeSeq(pSprite, 14)) {
                            Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistDodge[0]);
                            break;
                        }
                        Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistDodge[2]);
                        break;
                    }
                    if (!AICULTIST.checkDudeSeq(pSprite, 13) || pXSprite.getPalette() != 1 && pXSprite.getPalette() != 2) break;
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistDodge[1]);
                    break;
                }
                case 203: 
                case 205: {
                    if (nDamageType != 1 || pXSprite.getHealth() > pDudeInfo.fleeHealth) break;
                    Ai.aiPlaySound(pSprite, 361, 0, -1);
                    Ai.aiPlaySound(pSprite, 1106, 2, -1);
                    pSprite.setLotag(241);
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[2]);
                    if (!DemoUtils.IsOriginalDemo() && pXSprite.getBurnTime() == 0) {
                        pXSprite.setBurnTime(1200);
                    }
                    Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[41].startHealth, DudeInfo.dudeInfo[41].startHealth);
                    EVENT.checkEventList(pXSprite.getReference(), 3, 0);
                    break;
                }
                case 204: {
                    if (nDamageType != 1 || pXSprite.getHealth() > pDudeInfo.fleeHealth) break;
                    Ai.aiPlaySound(pSprite, 361, 0, -1);
                    Ai.aiPlaySound(pSprite, 1202, 2, -1);
                    pSprite.setLotag(242);
                    Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[3]);
                    if (!DemoUtils.IsOriginalDemo() && pXSprite.getBurnTime() == 0) {
                        pXSprite.setBurnTime(1200);
                    }
                    Actor.actHealDude(pXSprite, DudeInfo.dudeInfo[42].startHealth, DudeInfo.dudeInfo[42].startHealth);
                    EVENT.checkEventList(pXSprite.getReference(), 3, 0);
                }
            }
        }
        return nDamage;
    }

    protected static void RecoilDude(BloodSprite pSprite) {
        boolean chance = Gameutils.Chance(16384);
        if (pSprite.getStatnum() != 6 || !Actor.IsDudeSprite(pSprite)) {
            return;
        }
        XSPRITE pXSprite = pSprite.getXSprite();
        DudeExtra dudeExtra = pXSprite.getDudeExtra();
        switch (pSprite.getLotag()) {
            case 254: {
                int mass = Actor.getDudeMassBySpriteSize(pSprite);
                int chance4 = AIUNICULT.getRecoilChance(pSprite);
                boolean chance3 = Gameutils.Chance(chance4);
                if (dudeExtra.isTeslaHit() && (AIUNICULT.inIdle(pXSprite.getAIState()) || mass < 155 || mass >= 155 && chance3) && !AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                    AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 1);
                    if (Main.game.getCache().contains(pXSprite.getData2() + 4, "SEQ")) {
                        AIUNICULT.GDXGenDudeRTesla.next = Gameutils.Chance(chance4 * 2) ? AIUNICULT.GDXGenDudeDodge[0] : AIUNICULT.GDXGenDudeDodgeDmg[0];
                        Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRTesla);
                        break;
                    }
                    if (AIUNICULT.canDuck(pSprite) && (Gameutils.Chance(chance4) || Globals.pGameInfo.nDifficulty == 0)) {
                        Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRecoil[2]);
                        break;
                    }
                    if (AIUNICULT.canSwim(pSprite) && AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                        Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRecoil[1]);
                        break;
                    }
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRecoil[0]);
                    break;
                }
                if (AIUNICULT.inDodge(pXSprite.getAIState())) {
                    AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 1);
                    break;
                }
                if (!chance3 && !AIUNICULT.inIdle(pXSprite.getAIState()) && !Gameutils.Chance(AIUNICULT.getRecoilChance(pSprite)) && (AIUNICULT.dudeIsMelee(pXSprite) || mass >= 155)) break;
                AIUNICULT.sfxPlayGDXGenDudeSound(pSprite, 1);
                if (AIUNICULT.canDuck(pSprite) && (Gameutils.Chance(chance4) || Globals.pGameInfo.nDifficulty == 0)) {
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRecoil[2]);
                    break;
                }
                if (AIUNICULT.canSwim(pSprite) && AIUNICULT.spriteIsUnderwater(pSprite, false)) {
                    Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRecoil[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIUNICULT.GDXGenDudeRecoil[0]);
                break;
            }
            case 201: 
            case 202: 
            case 247: 
            case 248: 
            case 249: {
                if (pSprite.getLotag() == 201) {
                    Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 4013, 2, -1);
                } else {
                    Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 1013, 2, -1);
                }
                if (pXSprite.getPalette() == 0 && dudeExtra.isTeslaHit()) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistRTesla);
                    dudeExtra.setTeslaHit(false);
                    return;
                }
                if (pXSprite.getPalette() == 1 || pXSprite.getPalette() == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistRecoil[1]);
                    break;
                }
                if (!chance || Globals.pGameInfo.nDifficulty == 0) {
                    Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistRecoil[2]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICULTIST.cultistRecoil[0]);
                break;
            }
            case 240: {
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[1]);
                break;
            }
            case 255: {
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[6]);
                break;
            }
            case 252: {
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[4]);
                break;
            }
            case 204: {
                Ai.aiPlaySound(pSprite, 1202, 2, -1);
                if (dudeExtra.isTeslaHit()) {
                    Ai.aiNewState(pSprite, pXSprite, AIZOMBF.zombieFRTesla);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIZOMBF.zombieFRecoil);
                break;
            }
            case 203: 
            case 205: {
                Ai.aiPlaySound(pSprite, 1106, 2, -1);
                if (dudeExtra.isTeslaHit() && pXSprite.getData3() > DudeInfo.dudeInfo[3].startHealth / 3) {
                    Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieARTesla);
                    break;
                }
                if (pXSprite.getData3() <= DudeInfo.dudeInfo[3].startHealth / 3) {
                    Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieARecoil);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIZOMBA.zombieAFall);
                break;
            }
            case 241: {
                Ai.aiPlaySound(pSprite, 1106, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[2]);
                break;
            }
            case 242: {
                Ai.aiPlaySound(pSprite, 1202, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIBURN.burnGoto[3]);
                break;
            }
            case 206: 
            case 207: {
                Ai.aiPlaySound(pSprite, 1402, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIGARG.gargoyleRecoil);
                break;
            }
            case 227: {
                Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 2302, 2, -1);
                if (dudeExtra.isTeslaHit() && pXSprite.getData3() > DudeInfo.dudeInfo[3].startHealth / 3) {
                    Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusRTesla);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusRecoil[0]);
                break;
            }
            case 228: {
                Ai.aiPlaySound(pSprite, Gameutils.Random(2) + 2302, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AICERBERUS.cerberusRecoil[1]);
                break;
            }
            case 211: {
                Ai.aiPlaySound(pSprite, 1302, 2, -1);
                if (dudeExtra.isTeslaHit()) {
                    Ai.aiNewState(pSprite, pXSprite, AIHOUND.houndRTesla);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIHOUND.houndRecoil);
                break;
            }
            case 229: {
                Ai.aiPlaySound(pSprite, Gameutils.Random(6) + 2370, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AITCHERNOBOG.tchernobogRecoil);
                break;
            }
            case 212: {
                Ai.aiPlaySound(pSprite, 1902, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIHAND.handRecoil);
                break;
            }
            case 220: {
                Ai.aiPlaySound(pSprite, 2102, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIRAT.ratRecoil);
                break;
            }
            case 219: {
                Ai.aiPlaySound(pSprite, 2002, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIBAT.batRecoil);
                break;
            }
            case 218: {
                Ai.aiPlaySound(pSprite, 1502, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AIBONEEL.boneelRecoil);
                break;
            }
            case 217: {
                XSECTOR pXSector = Main.boardService.getSector(pSprite.getSectnum()).getExtra() >= 0 ? DB.xsector[Main.boardService.getSector(pSprite.getSectnum()).getExtra()] : null;
                Ai.aiPlaySound(pSprite, 1702, 2, -1);
                if (pXSector != null && pXSector.Underwater) {
                    Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastRecoil[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIGILLBEAST.gillBeastRecoil[0]);
                break;
            }
            case 210: {
                Ai.aiPlaySound(pSprite, 1602, 2, -1);
                if (dudeExtra.isTeslaHit()) {
                    Ai.aiNewState(pSprite, pXSprite, AIGHOST.ghostRTesla);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIGHOST.ghostRecoil);
                break;
            }
            case 213: 
            case 214: 
            case 215: {
                Ai.aiPlaySound(pSprite, Gameutils.Random(1) + 1802, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AISPID.spidDodge);
                break;
            }
            case 216: {
                Ai.aiPlaySound(pSprite, Gameutils.Random(1) + 1851, 2, -1);
                Ai.aiNewState(pSprite, pXSprite, AISPID.spidDodge);
                break;
            }
            case 245: {
                Ai.aiPlaySound(pSprite, Gameutils.BiRandom(2) + 7007, 2, -1);
                if (dudeExtra.isTeslaHit()) {
                    Ai.aiNewState(pSprite, pXSprite, AIINNOCENT.innocentTesla);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIINNOCENT.innocentRecoil);
                break;
            }
            case 250: {
                if (dudeExtra.isTeslaHit()) {
                    Ai.aiNewState(pSprite, pXSprite, AICALEB.calebRTesla);
                    dudeExtra.setTeslaHit(false);
                    return;
                }
                if (pXSprite.getPalette() == 1 || pXSprite.getPalette() == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AICALEB.calebRecoil[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AICALEB.calebRecoil[0]);
                break;
            }
            case 251: {
                Ai.aiPlaySound(pSprite, Gameutils.BiRandom(2) + 9004, 2, -1);
                if (pXSprite.getPalette() != 1 && pXSprite.getPalette() != 2 && dudeExtra.isTeslaHit()) {
                    Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastRTesla);
                    dudeExtra.setTeslaHit(false);
                    return;
                }
                if (pXSprite.getPalette() == 1 || pXSprite.getPalette() == 2) {
                    Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastRecoil[1]);
                    break;
                }
                Ai.aiNewState(pSprite, pXSprite, AIBEAST.beastRecoil[0]);
                break;
            }
            case 221: 
            case 223: {
                Ai.aiNewState(pSprite, pXSprite, AIPOD.podRecoil);
                break;
            }
            case 222: 
            case 224: {
                Ai.aiNewState(pSprite, pXSprite, AIPOD.tentacleRecoil);
                break;
            }
            default: {
                Ai.aiNewState(pSprite, pXSprite, genRecoil);
            }
            case 208: 
            case 209: 
        }
        dudeExtra.setTeslaHit(false);
    }

    protected static void aiPlaySound(BloodSprite pSprite, int nSound, int soundonce, int nChannel) {
        if (soundonce != 0) {
            DudeExtra dudeExtra = pSprite.getXSprite().getDudeExtra();
            if (soundonce > dudeExtra.getSoundOnce() || Globals.gFrameClock >= dudeExtra.getClock()) {
                SOUND.sfxKill3DSound(pSprite, -1, -1);
                SOUND.sfxStart3DSound(pSprite, nSound, nChannel, 0);
                dudeExtra.setSoundOnce(soundonce);
                dudeExtra.setClock(Globals.gFrameClock + 120);
            }
        } else {
            SOUND.sfxStart3DSound(pSprite, nSound, nChannel, 2);
        }
    }

    protected static void aiThinkTarget(BloodSprite pSprite, XSPRITE pXPad) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        if (!Gameutils.Chance(pDudeInfo.alertChance / 2)) {
            return;
        }
        XSPRITE pXSprite = pSprite.getXSprite();
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (pSprite.getOwner() != pPlayer.nSprite && pPlayer.pXsprite.getHealth() != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int dy;
                int x = pPlayer.pSprite.getX();
                int y = pPlayer.pSprite.getY();
                int z = pPlayer.pSprite.getZ();
                short nSector = pPlayer.pSprite.getSectnum();
                int dx = x - pSprite.getX();
                long dist = EngineUtils.qdist(dx, dy = y - pSprite.getY());
                if (dist <= (long)pDudeInfo.seeDist || dist <= (long)pDudeInfo.hearDist) {
                    int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
                    if (Main.engine.cansee(x, y, z, nSector, pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                        int nAngle = EngineUtils.getAngle(dx, dy);
                        int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
                        if (dist < (long)pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                            Ai.aiSetTarget(pXSprite, pPlayer.nSprite);
                            Ai.aiActivateDude(pSprite, pXSprite);
                            return;
                        }
                        if (dist < (long)pDudeInfo.hearDist) {
                            Ai.aiSetTarget(pXSprite, x, y, z);
                            Ai.aiActivateDude(pSprite, pXSprite);
                            return;
                        }
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    protected static void aiThinkTarget2(BloodSprite pSprite, XSPRITE pXPad) {
        if (pSprite.getLotag() < 200 || pSprite.getLotag() >= 256) {
            throw new AssertException("pSprite.type >= kDudeBase && pSprite.type < kDudeMax");
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        if (!Gameutils.Chance(pDudeInfo.alertChance / 2)) {
            return;
        }
        XSPRITE pXSprite = pSprite.getXSprite();
        short i = Mmulti.connecthead;
        while (i >= 0) {
            PLAYER pPlayer = Globals.gPlayer[i];
            if (pSprite.getOwner() != pPlayer.nSprite && pPlayer.pXsprite.getHealth() != 0 && PLAYER.powerupCheck(pPlayer, 13) <= 0) {
                int dy;
                int x = pPlayer.pSprite.getX();
                int y = pPlayer.pSprite.getY();
                int z = pPlayer.pSprite.getZ();
                short nSector = pPlayer.pSprite.getSectnum();
                int dx = x - pSprite.getX();
                long dist = EngineUtils.qdist(dx, dy = y - pSprite.getY());
                if (dist <= (long)pDudeInfo.seeDist || dist <= (long)pDudeInfo.hearDist) {
                    int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
                    if (Main.engine.cansee(x, y, z, nSector, pSprite.getX(), pSprite.getY(), pSprite.getZ() - eyeAboveZ, pSprite.getSectnum())) {
                        int nAngle = EngineUtils.getAngle(dx, dy);
                        int losAngle = (1024 + nAngle - pSprite.getAng() & 0x7FF) - 1024;
                        if (dist < (long)pDudeInfo.seeDist && Pragmas.klabs(losAngle) <= pDudeInfo.periphery) {
                            Ai.aiSetTarget(pXSprite, pPlayer.nSprite);
                            Ai.aiActivateDude(pSprite, pXSprite);
                            return;
                        }
                        if (dist < (long)pDudeInfo.hearDist) {
                            Ai.aiSetTarget(pXSprite, x, y, z);
                            Ai.aiActivateDude(pSprite, pXSprite);
                            return;
                        }
                    }
                }
            }
            i = Mmulti.connectpoint2[i];
        }
        if (pXSprite.getState() != 0) {
            for (ListNode<Sprite> node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
                int dy;
                int dx;
                long dist;
                Sprite pTarget = node.get();
                if (pTarget.getLotag() != 245 || (dist = (long)EngineUtils.qdist(dx = pTarget.getX() - pSprite.getX(), dy = pTarget.getY() - pSprite.getY())) > (long)DudeInfo.dudeInfo[45].seeDist && dist > (long)DudeInfo.dudeInfo[45].hearDist) continue;
                Ai.aiSetTarget(pXSprite, pTarget.getXvel());
                Ai.aiActivateDude(pSprite, pXSprite);
                return;
            }
        }
    }

    protected static int aiTickHandler(Sprite pSprite, XSPRITE pXSprite) {
        int ticks = pXSprite.getAIState().ticks;
        if (DemoUtils.IsOriginalDemo()) {
            if (pSprite.getLotag() == 218 && pXSprite.getAIState() == AIBONEEL.boneelRecoil) {
                ticks = 0;
            }
            if (pSprite.getLotag() == 251 && pXSprite.getAIState() == AIBEAST.beastHack[1]) {
                ticks = 0;
            }
        }
        return ticks;
    }

    public static void aiProcessDudes() {
        ListNode<Serializable<Sprite>> node;
        for (node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
            int nSprite = node.getIndex();
            BloodSprite pSprite = (BloodSprite)node.get();
            if ((pSprite.getHitag() & 0x20) != 0 || !Actor.IsDudeSprite(pSprite)) continue;
            short nXSprite = pSprite.getExtra();
            XSPRITE pXSprite = Main.boardService.getXSprite(nXSprite);
            DudeExtra xDude = pXSprite.getDudeExtra();
            DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
            if (Gameutils.IsPlayerSprite(pSprite) || pXSprite.getHealth() == 0) continue;
            pXSprite.setStateTimer(Gameutils.ClipLow(pXSprite.getStateTimer() - Globals.kFrameTicks, 0));
            if (pXSprite.getAIState() != null && pXSprite.getAIState().move) {
                pXSprite.getAIState().move(pSprite, pXSprite);
            }
            if (pXSprite.getAIState() != null && pXSprite.getAIState().think && (Globals.gFrame & 3) == (nSprite & 3)) {
                pXSprite.getAIState().think(pSprite, pXSprite);
            }
            if (pXSprite.getAIState() != null && pXSprite.getStateTimer() == 0 && pXSprite.getAIState().next != null) {
                if (pXSprite.getAIState() != null && Ai.aiTickHandler(pSprite, pXSprite) > 0) {
                    Ai.aiNewState(pSprite, pXSprite, pXSprite.getAIState().next);
                } else if (SeqHandling.seqFrame(3, nXSprite) < 0) {
                    Ai.aiNewState(pSprite, pXSprite, pXSprite.getAIState().next);
                }
            }
            if (pXSprite.getHealth() == 0 || xDude.getCumulDamage() < pDudeInfo.hinderDamage << 4) continue;
            pXSprite.setData3(xDude.getCumulDamage());
            Ai.RecoilDude(pSprite);
        }
        for (node = Main.boardService.getXSpriteNode(); node != null; node = node.getNext()) {
            ((XSPRITE)node.get()).getDudeExtra().setCumulDamage(0);
        }
    }

    public static void aiInit(boolean isOriginal) {
        ListNode<Serializable<XSPRITE>> node;
        genIdle = new AISTATE(AISTATEFUNC.Type.idle, 0, null, 0, false, false, false, null);
        genRecoil = new AISTATE(AISTATEFUNC.Type.recoil, 5, null, 20, false, false, false, genIdle);
        for (node = Main.boardService.getXSpriteNode(); node != null; node = node.getNext()) {
            node.get().getDudeExtra().clear();
        }
        for (node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
            BloodSprite pDude = (BloodSprite)node.get();
            Ai.aiInit(pDude, isOriginal);
        }
    }

    public static void aiInit(BloodSprite pDude, boolean isOriginal) {
        XSPRITE pXDude = Main.boardService.getXSprite(pDude.getExtra());
        DudeExtra dudeExtra = pXDude.getDudeExtra();
        switch (pDude.getLotag()) {
            case 254: {
                dudeExtra.setActive(false);
                Ai.aiNewState(pDude, pXDude, AIUNICULT.GDXGenDudeIdle[0]);
                break;
            }
            case 201: 
            case 202: 
            case 247: 
            case 248: 
            case 249: {
                dudeExtra.setActive(false);
                Ai.aiNewState(pDude, pXDude, AICULTIST.cultistIdle[0]);
                break;
            }
            case 230: {
                dudeExtra.setActive(false);
                Ai.aiNewState(pDude, pXDude, AICULTIST.cultistSProne);
                break;
            }
            case 246: {
                dudeExtra.setActive(false);
                Ai.aiNewState(pDude, pXDude, AICULTIST.cultistTProne);
                break;
            }
            case 204: {
                dudeExtra.setThinkTime(0);
                Ai.aiNewState(pDude, pXDude, AIZOMBF.zombieFIdle);
                break;
            }
            case 203: {
                dudeExtra.setThinkTime(0);
                Ai.aiNewState(pDude, pXDude, AIZOMBA.zombieAIdle);
                break;
            }
            case 244: {
                dudeExtra.setThinkTime(0);
                Ai.aiNewState(pDude, pXDude, AIZOMBA.zombieSLIdle);
                break;
            }
            case 205: {
                dudeExtra.setThinkTime(0);
                Ai.aiNewState(pDude, pXDude, AIZOMBA.zombieEIdle);
                break;
            }
            case 206: 
            case 207: {
                dudeExtra.setActive(false);
                dudeExtra.setThinkTime(0);
                Ai.aiNewState(pDude, pXDude, AIGARG.gargoyleIdle);
                break;
            }
            case 208: 
            case 209: {
                Ai.aiNewState(pDude, pXDude, AIGARG.statueIdle);
                break;
            }
            case 227: {
                dudeExtra.setThinkTime(0);
                Ai.aiNewState(pDude, pXDude, AICERBERUS.cerberusIdle[0]);
                break;
            }
            case 228: {
                dudeExtra.setThinkTime(0);
                Ai.aiNewState(pDude, pXDude, AICERBERUS.cerberusIdle[1]);
                break;
            }
            case 211: {
                Ai.aiNewState(pDude, pXDude, AIHOUND.houndIdle);
                break;
            }
            case 212: {
                Ai.aiNewState(pDude, pXDude, AIHAND.handIdle);
                break;
            }
            case 210: {
                dudeExtra.setThinkTime(0);
                dudeExtra.setActive(false);
                Ai.aiNewState(pDude, pXDude, AIGHOST.ghostIdle);
                break;
            }
            case 245: {
                Ai.aiNewState(pDude, pXDude, AIINNOCENT.innocentIdle);
                break;
            }
            case 220: {
                Ai.aiNewState(pDude, pXDude, AIRAT.ratIdle);
                break;
            }
            case 218: {
                dudeExtra.setThinkTime(0);
                dudeExtra.setActive(false);
                Ai.aiNewState(pDude, pXDude, AIBONEEL.boneelIdle);
                break;
            }
            case 217: {
                Sector pSector = Main.boardService.getSector(pDude.getSectnum());
                if (isOriginal) {
                    Ai.aiNewState(pDude, pXDude, AIGILLBEAST.gillBeastIdle[0]);
                    break;
                }
                if (pSector.getExtra() >= 0 && DB.xsector[pSector.getExtra()].Underwater) {
                    Ai.aiNewState(pDude, pXDude, AIGILLBEAST.gillBeastIdle[1]);
                    break;
                }
                Ai.aiNewState(pDude, pXDude, AIGILLBEAST.gillBeastIdle[0]);
                break;
            }
            case 219: {
                dudeExtra.setThinkTime(0);
                dudeExtra.setActive(false);
                Ai.aiNewState(pDude, pXDude, AIBAT.batSleep);
                break;
            }
            case 213: 
            case 214: 
            case 215: 
            case 216: {
                dudeExtra.setThinkTime(0);
                dudeExtra.setActive(false);
                Ai.aiNewState(pDude, pXDude, AISPID.spidIdle);
                break;
            }
            case 229: {
                dudeExtra.setThinkTime(0);
                Ai.aiNewState(pDude, pXDude, AITCHERNOBOG.tchernobogIdle);
                break;
            }
            case 250: {
                Ai.aiNewState(pDude, pXDude, AICALEB.calebIdle[0]);
                break;
            }
            case 251: {
                Ai.aiNewState(pDude, pXDude, AIBEAST.beastIdle[0]);
                break;
            }
            case 221: 
            case 223: {
                Ai.aiNewState(pDude, pXDude, AIPOD.podIdle);
                break;
            }
            case 222: 
            case 224: {
                Ai.aiNewState(pDude, pXDude, AIPOD.tentacleIdle);
                break;
            }
            case 239: 
            case 240: {
                Ai.aiNewState(pDude, pXDude, AIBURN.burnGoto[1]);
                pXDude.setBurnTime(1200);
                break;
            }
            case 255: {
                Ai.aiNewState(pDude, pXDude, AIBURN.burnGoto[6]);
                pXDude.setBurnTime(1200);
                break;
            }
            case 241: {
                Ai.aiNewState(pDude, pXDude, AIBURN.burnGoto[2]);
                pXDude.setBurnTime(1200);
                break;
            }
            case 242: {
                Ai.aiNewState(pDude, pXDude, AIBURN.burnGoto[3]);
                pXDude.setBurnTime(1200);
                break;
            }
            case 252: {
                Ai.aiNewState(pDude, pXDude, AIBURN.burnGoto[4]);
                pXDude.setBurnTime(1200);
                break;
            }
            case 253: {
                Ai.aiNewState(pDude, pXDude, AIBURN.burnGoto[5]);
                pXDude.setBurnTime(1200);
                break;
            }
            default: {
                Ai.aiNewState(pDude, pXDude, genIdle);
            }
        }
        Ai.aiSetTarget(pXDude, 0, 0, 0);
        pXDude.setStateTimer(0);
        switch (pDude.getLotag()) {
            case 205: 
            case 244: {
                pDude.setHitag(7);
                break;
            }
            case 213: 
            case 214: 
            case 215: 
            case 216: {
                if (pDude.getLotag() == 216 && isOriginal) {
                    pDude.setHitag(15);
                    break;
                }
                if ((pDude.getCstat() & 8) != 0) {
                    pDude.setHitag(9);
                    break;
                }
                pDude.setHitag(15);
                break;
            }
            case 206: 
            case 207: 
            case 210: 
            case 218: 
            case 219: {
                pDude.setHitag(9);
                break;
            }
            case 217: {
                XSECTOR pXSector;
                XSECTOR xSECTOR = pXSector = Main.boardService.getSector(pDude.getSectnum()).getExtra() > 0 ? DB.xsector[Main.boardService.getSector(pDude.getSectnum()).getExtra()] : null;
                if (pXSector != null && pXSector.Underwater) {
                    pDude.setHitag(9);
                    break;
                }
                pDude.setHitag(15);
                break;
            }
            case 225: {
                break;
            }
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 226: {
                if ((pDude.getCstat() & 8) != 0) {
                    pDude.setHitag(8);
                    break;
                }
            }
            default: {
                pDude.setHitag(15);
            }
        }
    }

    public static void UpdateEnemyAim(Sprite pSprite, int nXSprite, WeaponAim pAimData) {
        if (!Actor.IsDudeSprite(pSprite)) {
            return;
        }
        DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
        int eyeAboveZ = pDudeInfo.eyeHeight * pSprite.getYrepeat() << 2;
        int x = pSprite.getX();
        int y = pSprite.getY();
        DudeExtra pXDude = Main.boardService.getXSprite(nXSprite).getDudeExtra();
        Ai.EnemyAim.x = Trig.Cos(pSprite.getAng()) >> 16;
        Ai.EnemyAim.y = Trig.Sin(pSprite.getAng()) >> 16;
        Ai.EnemyAim.z = pXDude.getDudeSlope();
        int closest = Integer.MAX_VALUE;
        for (ListNode<Sprite> node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
            int ang;
            int dy;
            int dx;
            int dist2;
            int nDude = node.getIndex();
            BloodSprite pDude = (BloodSprite)node.get();
            if (pDude == pSprite || (pDude.getHitag() & 8) == 0) continue;
            int tx = pDude.getX();
            int ty = pDude.getY();
            int tz = pDude.getZ();
            int dist = EngineUtils.qdist(tx - x, ty - y);
            if (dist == 0 || dist > 10240) continue;
            if (pAimData.kSeeker != 0) {
                int k = (dist << 12) / pAimData.kSeeker;
                tx += (int)((long)k * pDude.getVelocityX() >> 12);
                ty += (int)((long)k * pDude.getVelocityY() >> 12);
                tz += (int)((long)k * pDude.getVelocityZ() >> 8);
            }
            int z1 = Pragmas.mulscale(dist, pXDude.getDudeSlope(), 10) + eyeAboveZ;
            int z2 = Pragmas.mulscale(9460L, dist, 10);
            Gameutils.GetSpriteExtents(pDude);
            if (z1 - z2 > Gameutils.extents_zBot || z1 + z2 < Gameutils.extents_zTop || (dist2 = EngineUtils.sqrt(((dx = Pragmas.mulscale(dist, Trig.Cos(pSprite.getAng()), 30) + x) - tx >> 4) * (dx - tx >> 4) + ((dy = Pragmas.mulscale(dist, Trig.Sin(pSprite.getAng()), 30) + y) - ty >> 4) * (dy - ty >> 4) + (z1 - tz >> 8) * (z1 - tz >> 8))) >= closest || Pragmas.klabs(((ang = EngineUtils.getAngle(tx - x, ty - y)) - pSprite.getAng() + 1024 & 0x7FF) - 1024) > pAimData.kDudeAngle) continue;
            int dz = pDude.getZ() - pSprite.getZ();
            if (Main.engine.cansee(x, y, eyeAboveZ, pSprite.getSectnum(), tx, ty, tz, pDude.getSectnum())) {
                closest = dist2;
                Ai.EnemyAim.x = Trig.Cos(ang) >> 16;
                Ai.EnemyAim.y = Trig.Sin(ang) >> 16;
                if (dz < -819 && dz > -2867 || dz < -2867 && dz > -12288) {
                    Ai.EnemyAim.z = Pragmas.divscale(dz, dist, 10) + 9460;
                    continue;
                }
                if (dz < -12288) {
                    Ai.EnemyAim.z = Pragmas.divscale(dz, dist, 10) - 7500;
                    continue;
                }
            }
            Ai.EnemyAim.z = Pragmas.divscale(dz, dist, 10);
        }
    }

    static {
        EnemyAim = new Vector3();
        AIZOMBA.Init();
        AIRAT.Init();
        AIINNOCENT.Init();
        AIHAND.Init();
        AICULTIST.Init();
        AIZOMBF.Init();
        AIGILLBEAST.Init();
        AIBURN.Init();
        AIGARG.Init();
        AIBAT.Init();
        AISPID.Init();
        AIHOUND.Init();
        AIGHOST.Init();
        AIBONEEL.Init();
        AITCHERNOBOG.Init();
        AIPOD.Init();
        AIBEAST.Init();
        AICALEB.Init();
        AICERBERUS.Init();
        AIUNICULT.Init();
    }
}

