/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.AI;

import ru.m210projects.Blood.AI.GeneticDude;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Gib;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;

public class AxeZombie
extends GeneticDude {
    private static final int kAxeZombieMeleeDist = Gameutils.M2X(2.0);
    private final Runnable think = () -> this.aiThinkTarget();
    private final Runnable move = () -> this.aiMoveForward();
    private final GeneticDude.AiState zombieAIdle = new GeneticDude.AiState(0, null, 0, () -> this.pXSprite.setTarget(-1), null, this.think, null);
    private final GeneticDude.AiState zombieEIdle = new GeneticDude.AiState(12, null, 0, null, null, this.think, null);
    private final Runnable entryEZombie = () -> {
        this.pSprite.setHitag(this.pSprite.getHitag() | 1);
        this.pSprite.setLotag(203);
    };
    private final GeneticDude.AiState zombieAPonder = new GeneticDude.AiState(0, null, 0, null, () -> this.aiMoveTurn(), () -> this.thinkPonder(), null);
    private final GeneticDude.AiState zombieSLIdle = new GeneticDude.AiState(10, null, 0, null, null, this.think, null);
    private final GeneticDude.AiState zombieARecoil = new GeneticDude.AiState(5, null, 0, null, null, null, this.zombieAPonder);
    private final GeneticDude.AiState zombieARTesla = new GeneticDude.AiState(4, null, 0, null, null, null, this.zombieAPonder);
    private final GeneticDude.AiState zombieAUp = new GeneticDude.AiState(11, null, 0, null, null, null, this.zombieAPonder);
    private final GeneticDude.AiState zombieAFall = new GeneticDude.AiState(1, null, 360, null, null, null, this.zombieAUp);
    private final GeneticDude.AiState zombieAHack = new GeneticDude.AiState(6, nXSprite -> this.HackCallback(), 80, null, null, null, this.zombieAPonder);
    private final GeneticDude.AiState zombieAChase = new GeneticDude.AiState(8, null, 0, null, this.move, () -> this.thinkChase(), null);
    private final GeneticDude.AiState zombieAGoto = new GeneticDude.AiState(8, null, 1800, null, this.move, () -> this.thinkGoto(), this.zombieAIdle);
    private final GeneticDude.AiState zombieASearch = new GeneticDude.AiState(8, null, 1800, null, this.move, () -> this.thinkSearch(), this.zombieAIdle);
    private final GeneticDude.AiState zombieEUp2 = new GeneticDude.AiState(0, null, 1, this.entryEZombie, null, null, this.zombieASearch);
    private final GeneticDude.AiState zombieEUp = new GeneticDude.AiState(9, null, 180, () -> {
        SOUND.sfxStart3DSound(this.pSprite, 1100, -1, 0);
        this.pSprite.setAng(EngineUtils.getAngle(this.pXSprite.getTargetX() - this.pSprite.getX(), this.pXSprite.getTargetY() - this.pSprite.getY()));
    }, null, null, this.zombieEUp2);
    private final GeneticDude.AiState zombieSLUP = new GeneticDude.AiState(11, null, 0, this.entryEZombie, null, null, this.zombieAPonder);

    public AxeZombie(BloodSprite pSprite) {
        super(pSprite);
        System.err.println("Zombie " + pSprite.getXvel());
        pSprite.setHitag(7);
        switch (pSprite.getLotag()) {
            case 244: {
                this.aiNewState(this.zombieSLIdle);
                break;
            }
            case 205: {
                this.aiNewState(this.zombieEIdle);
                break;
            }
            case 203: {
                this.aiNewState(this.zombieAIdle);
                pSprite.setHitag(pSprite.getHitag() | 8);
                break;
            }
            case 241: {
                pSprite.setHitag(pSprite.getHitag() | 8);
                this.pXSprite.setBurnTime(1200);
            }
        }
        this.setTarget(0, 0, 0);
        this.pXSprite.setStateTimer(0);
    }

    @Override
    public void activate() {
        if (this.pXSprite.getState() == 0) {
            this.aiChooseDirection(EngineUtils.getAngle(this.pXSprite.getTargetX() - this.pSprite.getX(), this.pXSprite.getTargetY() - this.pSprite.getY()));
            this.pXSprite.setState(1);
        }
        switch (this.pSprite.getLotag()) {
            case 244: {
                if (this.aiState != this.zombieSLIdle) break;
                this.aiNewState(this.zombieSLUP);
                break;
            }
            case 205: {
                if (this.aiState != this.zombieEIdle) break;
                this.aiNewState(this.zombieEUp);
                break;
            }
            case 203: {
                if (this.pXSprite.getTarget() == -1) {
                    this.aiNewState(this.zombieASearch);
                    break;
                }
                if (!Gameutils.Chance(20480)) {
                    this.aiNewState(this.zombieAChase);
                    break;
                }
                this.aiPlaySound(Gameutils.Random(3) + 1103, 1, -1);
                this.aiNewState(this.zombieAChase);
                break;
            }
        }
    }

    @Override
    public int damage(int nSource, int nDamageType, int nDamage) {
        if (this.pXSprite.getHealth() == 0) {
            return 0;
        }
        this.pXSprite.setHealth(Gameutils.ClipLow(this.pXSprite.getHealth() - nDamage, 0));
        this.cumulDamage += nDamage;
        if (nSource >= 0) {
            if (nSource == this.pXSprite.getReference()) {
                return 0;
            }
            if (this.pXSprite.getTarget() == -1) {
                this.setTarget(nSource);
                this.activate();
            } else if (nSource != this.pXSprite.getTarget()) {
                int nThresh = nDamage;
                nThresh = Main.boardService.getSprite(nSource).getLotag() == this.pSprite.getLotag() ? (nThresh *= this.pDudeInfo.changeTargetKin) : (nThresh *= this.pDudeInfo.changeTarget);
                if (Gameutils.Chance(nThresh / 2)) {
                    this.setTarget(nSource);
                    this.activate();
                }
            }
            if (nDamageType == 6) {
                this.aiTeslaHit = 1;
            } else if (!DemoUtils.IsOriginalDemo()) {
                this.aiTeslaHit = 0;
            }
            switch (this.pSprite.getLotag()) {
                case 203: 
                case 205: {
                    if (nDamageType != 1 || this.pXSprite.getHealth() > this.pDudeInfo.fleeHealth) break;
                    this.aiPlaySound(361, 0, -1);
                    this.aiPlaySound(1106, 2, -1);
                    this.pSprite.setLotag(241);
                    if (!DemoUtils.IsOriginalDemo() && this.pXSprite.getBurnTime() == 0) {
                        this.pXSprite.setBurnTime(1200);
                    }
                    this.heal(DudeInfo.dudeInfo[41].startHealth, DudeInfo.dudeInfo[41].startHealth);
                    EVENT.checkEventList(this.pXSprite.getReference(), 3, 0);
                }
            }
        }
        return nDamage;
    }

    @Override
    public void kill(int nSource, int nDamageType, int nDamage) {
        this.pSprite.setHitag(this.pSprite.getHitag() | 7);
        if (this.pXSprite.getKey() > 0) {
            Actor.DropPickupObject(this.pSprite, 100 + this.pXSprite.getKey() - 1);
        }
        if (this.pXSprite.getDropMsg() != 0) {
            Actor.DropPickupObject(this.pSprite, this.pXSprite.getDropMsg());
            if (!DemoUtils.IsOriginalDemo()) {
                this.pXSprite.setDropMsg(0);
            }
        }
        int deathType = 1;
        switch (nDamageType) {
            case 1: {
                deathType = 3;
                SOUND.sfxStart3DSound(this.pSprite, 351, -1, 0);
                break;
            }
            case 3: {
                deathType = 2;
                break;
            }
            case 5: {
                switch (this.pSprite.getLotag()) {
                    case 203: 
                    case 205: {
                        deathType = 14;
                    }
                }
            }
        }
        short nXSprite = this.pSprite.getExtra();
        if (!Main.game.getCache().contains(this.pDudeInfo.seqStartID + deathType, "SEQ")) {
            LEVELS.levelAddKills(this.pSprite);
            SeqHandling.seqKill(3, nXSprite);
            Actor.actPostSprite(this.pSprite.getXvel(), 1024);
            return;
        }
        switch (this.pSprite.getLotag()) {
            case 203: {
                SOUND.sfxStart3DSound(this.pSprite, Gameutils.Random(2) + 1107, -1, 0);
                if (deathType == 2) {
                    SeqHandling.seqSpawn(this.pDudeInfo.seqStartID + 2, 3, nXSprite, SeqHandling.callbacks[10]);
                    Gameutils.GetSpriteExtents(this.pSprite);
                    Gib.startPos.set(this.pSprite.getX(), this.pSprite.getY(), Gameutils.extents_zTop);
                    Gib.startVel.set(this.pSprite.getVelocityX() >> 1, this.pSprite.getVelocityY() >> 1, -838860.0f);
                    Gib.actGenerateGibs(this.pSprite, 27, Gib.startPos, Gib.startVel);
                    break;
                }
                if (deathType != 1 || !Gameutils.Chance(8192)) {
                    if (deathType == 14) {
                        SeqHandling.seqSpawn(this.pDudeInfo.seqStartID + 14, 3, nXSprite, null);
                        break;
                    }
                    if (deathType == 3) {
                        SeqHandling.seqSpawn(this.pDudeInfo.seqStartID + 13, 3, nXSprite, SeqHandling.callbacks[11]);
                        break;
                    }
                    SeqHandling.seqSpawn(deathType + this.pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[10]);
                    break;
                }
                SeqHandling.seqSpawn(this.pDudeInfo.seqStartID + 7, 3, nXSprite, SeqHandling.callbacks[10]);
                EVENT.evPostCallback(this.pSprite.getXvel(), 3, 0L, 5);
                this.pXSprite.setData1(35);
                this.pXSprite.setData2(5);
                Gameutils.GetSpriteExtents(this.pSprite);
                Gib.startPos.set(this.pSprite.getX(), this.pSprite.getY(), Gameutils.extents_zTop);
                Gib.startVel.set(this.pSprite.getVelocityX() >> 1, this.pSprite.getVelocityY() >> 1, -1118481.0f);
                Gib.actGenerateGibs(this.pSprite, 27, Gib.startPos, Gib.startVel);
                SOUND.sfxStart3DSound(this.pSprite, 362, -1, 0);
                break;
            }
            case 241: {
                if (Gameutils.Chance(16384) && deathType == 3) {
                    SOUND.sfxStart3DSound(this.pSprite, 1109, -1, 0);
                } else {
                    SOUND.sfxStart3DSound(this.pSprite, Gameutils.Random(2) + 1107, -1, 0);
                }
                nDamageType = 3;
                if (Gameutils.Chance(16384)) {
                    SeqHandling.seqSpawn(13 + this.pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[10]);
                    Gameutils.GetSpriteExtents(this.pSprite);
                    Gib.startPos.set(this.pSprite.getX(), this.pSprite.getY(), Gameutils.extents_zTop);
                    Gib.startVel.set(this.pSprite.getVelocityX() >> 1, this.pSprite.getVelocityY() >> 1, -838860.0f);
                    Gib.actGenerateGibs(this.pSprite, 27, Gib.startPos, Gib.startVel);
                    break;
                }
                SeqHandling.seqSpawn(13 + this.pDudeInfo.seqStartID, 3, nXSprite, SeqHandling.callbacks[11]);
                break;
            }
            default: {
                SeqHandling.seqSpawn(deathType + this.pDudeInfo.seqStartID, 3, nXSprite, null);
            }
        }
        if (nDamageType == 3) {
            for (int i = 0; i < 3; ++i) {
                int nGibType = this.pDudeInfo.nGibType[i];
                if (nGibType <= -1) continue;
                Gib.actGenerateGibs(this.pSprite, nGibType, null, null);
            }
            for (int j = 0; j < 4; ++j) {
                Actor.actSpawnBlood(this.pSprite);
            }
        }
        LEVELS.levelAddKills(this.pSprite);
        Actor.actCheckRespawn(this.pSprite);
        if (!DemoUtils.IsOriginalDemo() && Main.boardService.getXSprite(nXSprite).isProximity()) {
            Main.boardService.getXSprite(nXSprite).setProximity(false);
        }
        this.pSprite.setLotag(426);
        Actor.actPostSprite(this.pSprite.getXvel(), 4);
    }

    @Override
    public void warp(int type) {
        switch (type) {
            case 9: 
            case 13: {
                if (this.pSprite.getLotag() != 203) break;
                this.pXSprite.setBurnTime(0);
                EVENT.evPostCallback(this.pSprite.getXvel(), 3, 0L, 11);
                SOUND.sfxStart3DSound(this.pSprite, 720, -1, 0);
                this.aiNewState(this.zombieAGoto);
            }
        }
    }

    @Override
    protected void recoil(boolean chance) {
        switch (this.pSprite.getLotag()) {
            case 203: 
            case 205: {
                this.aiPlaySound(1106, 2, -1);
                if (this.aiTeslaHit != 0 && this.pXSprite.getData3() > this.pDudeInfo.startHealth / 3) {
                    this.aiNewState(this.zombieARTesla);
                    break;
                }
                if (this.pXSprite.getData3() <= this.pDudeInfo.startHealth / 3) {
                    this.aiNewState(this.zombieARecoil);
                    break;
                }
                this.aiNewState(this.zombieAFall);
                break;
            }
            case 241: {
                this.aiPlaySound(1106, 2, -1);
            }
        }
        this.aiTeslaHit = 0;
    }

    @Override
    public void touch() {
    }

    private void thinkPonder() {
        PLAYER pPlayer;
        if (this.pXSprite.getTarget() == -1) {
            this.aiNewState(this.zombieASearch);
            return;
        }
        if (!Main.boardService.isValidSprite(this.pXSprite.getTarget())) {
            throw new AssertException("isValidSprite(pXSprite.getTarget())");
        }
        BloodSprite pTarget = Main.boardService.getSprite(this.pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - this.pSprite.getX();
        int dy = pTarget.getY() - this.pSprite.getY();
        this.aiChooseDirection(EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            this.aiNewState(this.zombieASearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && (PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0 || PLAYER.powerupCheck(pPlayer, 31) > 0)) {
            this.aiNewState(this.zombieAGoto);
            return;
        }
        long dist = EngineUtils.qdist(dx, dy);
        if (dist <= (long)this.pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - this.pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = this.pDudeInfo.eyeHeight * this.pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), this.pSprite.getX(), this.pSprite.getY(), this.pSprite.getZ() - eyeAboveZ, this.pSprite.getSectnum()) && Pragmas.klabs(losAngle) <= this.pDudeInfo.periphery) {
                this.setTarget(this.pXSprite.getTarget());
                if (dist < (long)kAxeZombieMeleeDist) {
                    if (Pragmas.klabs(losAngle) < 85) {
                        this.aiNewState(this.zombieAHack);
                    }
                    return;
                }
            }
        }
        this.aiNewState(this.zombieAChase);
    }

    private void HackCallback() {
        BloodSprite pTarget;
        int nAngle = EngineUtils.getAngle(this.pXSprite.getTargetX() - this.pSprite.getX(), this.pXSprite.getTargetY() - this.pSprite.getY());
        int nZOffset1 = this.pDudeInfo.eyeHeight * this.pSprite.getYrepeat() << 2;
        int nZOffset2 = 0;
        if (this.pXSprite.getTarget() != -1 && Actor.IsDudeSprite(pTarget = Main.boardService.getSprite(this.pXSprite.getTarget()))) {
            nZOffset2 = DudeInfo.dudeInfo[pTarget.getLotag() - 200].eyeHeight * pTarget.getYrepeat() << 2;
        }
        int dx = Trig.Cos(nAngle) >> 16;
        int dy = Trig.Sin(nAngle) >> 16;
        int dz = nZOffset1 - nZOffset2;
        SOUND.sfxStart3DSound(this.pSprite, 1101, 1, 0);
        Actor.actFireVector(this.pSprite, 0, 0, dx, dy, dz, 10);
    }

    private void thinkSearch() {
        this.aiChooseDirection(this.pXSprite.getGoalAng());
        if (this.aiThinkTarget()) {
            return;
        }
        if (this.pXSprite.getState() == 0) {
            return;
        }
        for (ListNode<Sprite> node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
            int dy;
            int dx;
            long dist;
            int nSprite = node.getIndex();
            BloodSprite pTarget = Main.boardService.getSprite(nSprite);
            if (pTarget.getLotag() != 245 || (dist = (long)EngineUtils.qdist(dx = pTarget.getX() - this.pSprite.getX(), dy = pTarget.getY() - this.pSprite.getY())) > (long)DudeInfo.dudeInfo[45].seeDist && dist > (long)DudeInfo.dudeInfo[45].hearDist) continue;
            this.setTarget(pTarget.getXvel());
            this.activate();
            return;
        }
    }

    private void thinkGoto() {
        int dx = this.pXSprite.getTargetX() - this.pSprite.getX();
        int dy = this.pXSprite.getTargetY() - this.pSprite.getY();
        int nAngle = EngineUtils.getAngle(dx, dy);
        long dist = EngineUtils.qdist(dx, dy);
        this.aiChooseDirection(nAngle);
        if (dist < (long)Gameutils.M2X(1.8) && Pragmas.klabs(this.pSprite.getAng() - nAngle) < this.pDudeInfo.periphery) {
            this.aiNewState(this.zombieASearch);
        }
        this.aiThinkTarget();
    }

    private void thinkChase() {
        PLAYER pPlayer;
        if (this.pXSprite.getTarget() == -1) {
            this.aiNewState(this.zombieASearch);
            return;
        }
        if (!Main.boardService.isValidSprite(this.pXSprite.getTarget())) {
            throw new AssertException("isValidSprite(pXSprite.getTarget())");
        }
        BloodSprite pTarget = Main.boardService.getSprite(this.pXSprite.getTarget());
        XSPRITE pXTarget = Main.boardService.getXSprite(pTarget.getExtra());
        int dx = pTarget.getX() - this.pSprite.getX();
        int dy = pTarget.getY() - this.pSprite.getY();
        this.aiChooseDirection(EngineUtils.getAngle(dx, dy));
        if (pXTarget == null || pXTarget.getHealth() == 0) {
            this.aiNewState(this.zombieASearch);
            return;
        }
        if (Gameutils.IsPlayerSprite(pTarget) && (PLAYER.powerupCheck(pPlayer = Globals.gPlayer[pTarget.getLotag() - 231], 13) > 0 || PLAYER.powerupCheck(pPlayer, 31) > 0)) {
            this.aiNewState(this.zombieAGoto);
            return;
        }
        long dist = EngineUtils.qdist(dx, dy);
        if (dist <= (long)this.pDudeInfo.seeDist) {
            int nAngle = EngineUtils.getAngle(dx, dy);
            int losAngle = (1024 + nAngle - this.pSprite.getAng() & 0x7FF) - 1024;
            int eyeAboveZ = this.pDudeInfo.eyeHeight * this.pSprite.getYrepeat() << 2;
            if (Main.engine.cansee(pTarget.getX(), pTarget.getY(), pTarget.getZ(), pTarget.getSectnum(), this.pSprite.getX(), this.pSprite.getY(), this.pSprite.getZ() - eyeAboveZ, this.pSprite.getSectnum()) && Pragmas.klabs(losAngle) <= this.pDudeInfo.periphery) {
                this.setTarget(this.pXSprite.getTarget());
                if (dist < (long)kAxeZombieMeleeDist && Pragmas.klabs(losAngle) < 85) {
                    this.aiNewState(this.zombieAHack);
                }
                return;
            }
        }
        this.aiNewState(this.zombieAGoto);
        this.pXSprite.setTarget(-1);
    }
}

