/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.stream.IntStream;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.keymap.ControllerButton;
import ru.m210projects.Build.settings.ConfigContext;
import ru.m210projects.Build.settings.GameConfig;
import ru.m210projects.Build.settings.GameKeys;
import ru.m210projects.Build.settings.InputContext;
import ru.m210projects.Build.settings.Properties;

public class Config
extends GameConfig {
    public static int[] defclassickeys = new int[]{19, 20, 21, 22, 67, 57, 55, 56, 29, 54, 59, 62, 129, 75, 74, 92, 93, 61, 70, 69, 48, 49, 111, 68, 0, 115, 52, 3, 123, 149, 124, 112, 8, 9, 10, 11, 12, 13, 14, 15, 16, 7, 66, 71, 72, 34, 39, 137, 37, 0, 73, 51, 30, 31, 38, 41, 44, 46, 131, 132, 133, 134, 135, 136, 138, 139, 140, 141, 142};
    public static int[] defkeys = new int[]{51, 47, 21, 22, 67, 57, 29, 32, 62, 129, 59, 33, 0, 75, 74, 92, 93, 61, 70, 69, 48, 49, 111, 68, 0, 115, 52, 3, 123, 149, 124, 112, 8, 9, 10, 11, 12, 13, 14, 15, 16, 7, 66, 71, 72, 34, 39, 137, 37, 45, 73, 0, 30, 31, 38, 41, 44, 46, 131, 132, 133, 134, 135, 136, 0, 139, 140, 141, 142};
    public String[] macros = new String[]{"I love the smell of napalm", "Is that gasoline I smell?", "Ta da!", "Who wants some, huh? Who's next?", "I have something for you.", "You just gonna stand there...", "That'll teach ya!", "Ohh, that wasn't a bit nice.", "Amateurs!", "Fool! You are already dead."};
    public boolean gAutoAim = true;
    public boolean gCrosshair = true;
    public boolean gBobWidth = true;
    public boolean gBobHeight = true;
    public boolean gSlopeTilt = true;
    public boolean gAutoRun = true;
    public boolean gShowWeapon = true;
    public boolean gParentalLock = false;
    public boolean MessageState = true;
    public boolean useautosecretcount = false;
    public boolean showCutscenes = true;
    public boolean gVanilla = true;
    public int gViewSize = 3;
    public int gTurnSpeed = 92;
    public int gDetail = 4;
    public int gInterpolation = 1;
    public String AdultPassword = "";
    public int MessageFont = 3;
    public int showQuotes = 4;
    public int quoteTime = 5;
    public int gOverlayMap = 0;
    public int gDemoSeq = 1;
    public int gStatSize = 65536;
    public int gCrossSize = 65536;
    public int gHudSize = 65536;
    public int gShowStat = 1;
    public int showMapInfo = 1;
    public int weaponIndex = -1;

    public Config(Path path) {
        super(path);
        this.setpName("Caleb");
    }

    public GameKey[] getKeyMap() {
        return new GameKey[]{GameKeys.Move_Forward, GameKeys.Move_Backward, GameKeys.Turn_Left, GameKeys.Turn_Right, GameKeys.Turn_Around, GameKeys.Strafe, GameKeys.Strafe_Left, GameKeys.Strafe_Right, GameKeys.Jump, GameKeys.Crouch, BloodKeys.Crouch_toggle, GameKeys.Run, BloodKeys.AutoRun, GameKeys.Open, GameKeys.Weapon_Fire, BloodKeys.Weapon_Special_Fire, BloodKeys.Aim_Up, BloodKeys.Aim_Down, BloodKeys.Aim_Center, GameKeys.Look_Up, GameKeys.Look_Down, BloodKeys.Tilt_Left, BloodKeys.Tilt_Right, BloodKeys.Weapon_1, BloodKeys.Weapon_2, BloodKeys.Weapon_3, BloodKeys.Weapon_4, BloodKeys.Weapon_5, BloodKeys.Weapon_6, BloodKeys.Weapon_7, BloodKeys.Weapon_8, BloodKeys.Weapon_9, BloodKeys.Weapon_10, BloodKeys.Inventory_Use, BloodKeys.Inventory_Left, BloodKeys.Inventory_Right, GameKeys.Map_Toggle, BloodKeys.Map_Follow_Mode, GameKeys.Shrink_Screen, GameKeys.Enlarge_Screen, GameKeys.Send_Message, BloodKeys.See_Coop_View, BloodKeys.See_Chase_View, GameKeys.Mouse_Aiming, BloodKeys.Toggle_Crosshair, BloodKeys.Last_Used_Weapon, GameKeys.Next_Weapon, GameKeys.Previous_Weapon, BloodKeys.Holster_Weapon, BloodKeys.Show_Opponents_Weapon, BloodKeys.BeastVision, BloodKeys.CrystalBall, BloodKeys.JumpBoots, BloodKeys.MedKit, BloodKeys.ProximityBombs, BloodKeys.RemoteBombs, GameKeys.Menu_Toggle, GameKeys.Show_Console, BloodKeys.Show_HelpScreen, BloodKeys.Show_SaveMenu, BloodKeys.Show_LoadMenu, BloodKeys.Show_SoundSetup, BloodKeys.Show_Options, BloodKeys.Quicksave, BloodKeys.Toggle_messages, BloodKeys.Quickload, BloodKeys.Quit, BloodKeys.Gamma, BloodKeys.Make_Screenshot};
    }

    @Override
    protected InputContext createDefaultInputContext() {
        return new InputContext(this.getKeyMap(), defkeys, defclassickeys){

            @Override
            protected void clearInput() {
                super.clearInput();
                Config.this.weaponIndex = IntStream.range(0, this.keymap.length).filter(i -> this.keymap[i].equals(BloodKeys.Weapon_1)).findFirst().orElse(-1);
            }

            @Override
            public void resetInput(boolean classicKeys) {
                super.resetInput(classicKeys);
                this.primarykeys[2][BloodKeys.Weapon_Special_Fire.getNum()] = 227;
                this.bindKey((GameKey)BloodKeys.Crouch_toggle, ControllerButton.BUTTON_B);
                this.bindKey((GameKey)BloodKeys.Inventory_Use, ControllerButton.BUTTON_X);
                this.bindKey((GameKey)BloodKeys.Inventory_Left, ControllerButton.DPAD_LEFT);
                this.bindKey((GameKey)BloodKeys.Inventory_Right, ControllerButton.DPAD_RIGHT);
            }
        };
    }

    @Override
    protected ConfigContext createDefaultGameContext() {
        return new ConfigContext(){

            @Override
            public void load(Properties prop) {
                if (prop.setContext("Options")) {
                    Config.this.gTurnSpeed = prop.getIntValue("KeyboardTurnSpeed", Config.this.gTurnSpeed);
                    Config.this.gViewSize = prop.getIntValue("ViewSize", Config.this.gViewSize);
                    Config.this.gCrosshair = prop.getBooleanValue("Crosshair", Config.this.gCrosshair);
                    Config.this.MessageState = prop.getBooleanValue("MessageState", Config.this.MessageState);
                    Config.this.gDetail = prop.getIntValue("Detail", Config.this.gDetail);
                    Config.this.gAutoRun = prop.getBooleanValue("AutoRun", Config.this.gAutoRun);
                    Config.this.gInterpolation = prop.getIntValue("Interpolation", Config.this.gInterpolation);
                    Config.this.gBobWidth = prop.getBooleanValue("ViewHBobbing", Config.this.gBobWidth);
                    Config.this.gBobHeight = prop.getBooleanValue("ViewVBobbing", Config.this.gBobHeight);
                    Config.this.gOverlayMap = prop.getIntValue("OverlayMap", Config.this.gOverlayMap);
                    Config.this.gVanilla = prop.getBooleanValue("VanillaMode", Config.this.gVanilla);
                    Config.this.gShowWeapon = prop.getBooleanValue("ShowOpponentsWeapon", Config.this.gShowWeapon);
                    Config.this.gAutoAim = prop.getBooleanValue("AutoAim", Config.this.gAutoAim);
                    Config.this.gSlopeTilt = prop.getBooleanValue("SlopeTilting", Config.this.gSlopeTilt);
                    Config.this.MessageState = prop.getBooleanValue("MessageState", Config.this.MessageState);
                    Config.this.showQuotes = prop.getIntValue("MessageCount", Config.this.showQuotes);
                    Config.this.quoteTime = prop.getIntValue("MessageTime", Config.this.quoteTime);
                    Config.this.MessageFont = Gameutils.BClipRange(prop.getIntValue("MessageFont", Config.this.MessageFont), 0, 4);
                    Config.this.gParentalLock = prop.getBooleanValue("AdultContent", Config.this.gParentalLock);
                    Config.this.AdultPassword = prop.getStringValue("AdultPassword", "").replaceAll("\"", "");
                    Config.this.gStatSize = Math.max(prop.getIntValue("StatSize", Config.this.gStatSize), 16384);
                    Config.this.gCrossSize = Math.max(prop.getIntValue("CrossSize", Config.this.gCrossSize), 16384);
                    Config.this.gHudSize = Math.max(prop.getIntValue("HudSize", Config.this.gHudSize), 16384);
                    Config.this.gShowStat = prop.getIntValue("ShowStat", Config.this.gShowStat);
                    Config.this.showCutscenes = prop.getBooleanValue("showCutscenes", Config.this.showCutscenes);
                    Config.this.showMapInfo = prop.getIntValue("showMapInfo", Config.this.showMapInfo);
                    Config.this.useautosecretcount = prop.getBooleanValue("UseAutoSecretCount", Config.this.useautosecretcount);
                    Config.this.gDemoSeq = prop.getIntValue("DemoSequence", Config.this.gDemoSeq);
                }
            }

            @Override
            public void save(OutputStream os) throws IOException {
                this.putString(os, "[Options]\r\n");
                this.putInteger(os, "KeyboardTurnSpeed", Config.this.gTurnSpeed);
                this.putInteger(os, "ViewSize", Config.this.gViewSize);
                this.putBoolean(os, "Crosshair", Config.this.gCrosshair);
                this.putBoolean(os, "MessageState", Config.this.MessageState);
                this.putInteger(os, "Detail", Config.this.gDetail);
                this.putBoolean(os, "ShowOpponentsWeapon", Config.this.gShowWeapon);
                this.putBoolean(os, "AutoRun", Config.this.gAutoRun);
                this.putInteger(os, "Interpolation", Config.this.gInterpolation);
                this.putBoolean(os, "ViewHBobbing", Config.this.gBobWidth);
                this.putBoolean(os, "ViewVBobbing", Config.this.gBobHeight);
                this.putInteger(os, "OverlayMap", Config.this.gOverlayMap);
                this.putBoolean(os, "VanillaMode", Config.this.gVanilla);
                this.putBoolean(os, "SlopeTilting", Config.this.gSlopeTilt);
                this.putBoolean(os, "AutoAim", Config.this.gAutoAim);
                this.putBoolean(os, "MessageState", Config.this.MessageState);
                this.putInteger(os, "MessageCount", Config.this.showQuotes);
                this.putInteger(os, "MessageTime", Config.this.quoteTime);
                this.putInteger(os, "MessageFont", Config.this.MessageFont);
                this.putBoolean(os, "AdultContent", Config.this.gParentalLock);
                this.putString(os, "AdultPassword = \"\"\r\n");
                this.putInteger(os, "StatSize", Config.this.gStatSize);
                this.putInteger(os, "CrossSize", Config.this.gCrossSize);
                this.putInteger(os, "HudSize", Config.this.gHudSize);
                this.putInteger(os, "ShowStat", Config.this.gShowStat);
                this.putBoolean(os, "showCutscenes", Config.this.showCutscenes);
                this.putInteger(os, "showMapInfo", Config.this.showMapInfo);
                this.putBoolean(os, "UseAutoSecretCount", Config.this.useautosecretcount);
                this.putInteger(os, "DemoSequence", Config.this.gDemoSeq);
            }
        };
    }

    public static enum BloodKeys implements GameKey
    {
        Crouch_toggle,
        AutoRun,
        Weapon_Special_Fire,
        Aim_Up,
        Aim_Down,
        Aim_Center,
        Tilt_Left,
        Tilt_Right,
        Weapon_1,
        Weapon_2,
        Weapon_3,
        Weapon_4,
        Weapon_5,
        Weapon_6,
        Weapon_7,
        Weapon_8,
        Weapon_9,
        Weapon_10,
        Inventory_Use,
        Inventory_Left,
        Inventory_Right,
        Map_Follow_Mode,
        See_Coop_View,
        See_Chase_View,
        Toggle_Crosshair,
        Last_Used_Weapon,
        Holster_Weapon,
        Show_Opponents_Weapon,
        BeastVision,
        CrystalBall,
        JumpBoots,
        MedKit,
        ProximityBombs,
        RemoteBombs,
        Show_HelpScreen,
        Show_SaveMenu,
        Show_LoadMenu,
        Show_SoundSetup,
        Show_Options,
        Quicksave,
        Toggle_messages,
        Quickload,
        Quit,
        Gamma,
        Make_Screenshot;


        @Override
        public int getNum() {
            return GameKeys.values().length + this.ordinal();
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

