/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.Cache;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.rff.RffFile;

public class BloodCache
extends Cache {
    public BloodCache(Directory gameDirectory) {
        super(gameDirectory);
    }

    @Override
    public boolean addGroup(Entry groupEntry, CacheResourceMap.CachePriority priority) {
        Group group = this.newGroup(groupEntry);
        boolean result = this.addGroup(group, priority);
        if (!result && groupEntry.getName().equalsIgnoreCase("blood.rff")) {
            try {
                result = this.addGroup(new RffFile(groupEntry.getName(), groupEntry::getInputStream), priority);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return result;
    }

    public Entry getEntry(int fileid, String type) {
        for (int i = CacheResourceMap.CachePriority.HIGHEST.getLevel(); i >= CacheResourceMap.CachePriority.NORMAL.getLevel(); --i) {
            for (ListNode node = this.cacheResourceMap.getFirst(i); node != null; node = node.getNext()) {
                Entry entry;
                Group group = (Group)node.get();
                if (!(group instanceof RffFile) || !(entry = ((RffFile)group).getEntry(fileid, type)).exists()) continue;
                return entry;
            }
        }
        return Directory.DUMMY_ENTRY;
    }

    public boolean contains(int fileid, String type) {
        return this.getEntry(fileid, type).exists();
    }

    public boolean contains(String name, boolean searchFirst) {
        return this.getEntry(name, searchFirst).exists();
    }
}

