/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import ru.m210projects.Blood.Factory.BLSliderDrawable;
import ru.m210projects.Blood.Factory.BloodEngine;
import ru.m210projects.Blood.Factory.BloodMenuHandler;
import ru.m210projects.Blood.Factory.BloodNetwork;
import ru.m210projects.Blood.Factory.BloodOsdFunc;
import ru.m210projects.Blood.Factory.BloodPolygdx;
import ru.m210projects.Blood.Factory.BloodPolymost;
import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Factory.BloodSoftware;
import ru.m210projects.Blood.Fonts.BloodFont;
import ru.m210projects.Blood.Fonts.QFNFont;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.filehandlers.scripts.BloodDef;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.font.Font;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.OsdFunc;

public class BloodFactory
extends BuildFactory {
    private final Main app;

    public BloodFactory(Main app) {
        super("BLOOD.RFF", "SOUNDS.RFF");
        this.app = app;
        OsdColor.DEFAULT.setPal(0);
    }

    @Override
    public void drawInitScreen() {
        BloodRenderer renderer = Main.game.getRenderer();
        renderer.rotatesprite(0, 0, 65536, 0, 2046, -128, 0, 26);
    }

    @Override
    public Engine engine() throws Exception {
        VERSION.versionInit();
        Main.engine = new BloodEngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new BloodSoftware(this.app.pCfg);
        }
        if (type == Renderer.RenderType.PolyGDX) {
            return new BloodPolygdx(this.app.pCfg);
        }
        return new BloodPolymost(this.app.pCfg);
    }

    @Override
    public DefScript getBaseDef(Engine engine) {
        return new BloodDef(engine);
    }

    @Override
    public OsdFunc getOsdFunc() {
        return new BloodOsdFunc();
    }

    @Override
    public MenuHandler menus() {
        this.app.menu = new BloodMenuHandler(this.app);
        return this.app.menu;
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(6){

            @Override
            protected Font init(int i) {
                if (i == 0) {
                    return VERSION.hasQFN ? new QFNFont(4096, 0) : new BloodFont(4096, 0);
                }
                if (i == 1) {
                    return VERSION.hasQFN ? new QFNFont(4192, 1) : new BloodFont(4192, 1);
                }
                if (i == 2) {
                    return VERSION.hasQFN ? new QFNFont(4288, 2) : new BloodFont(4288, 1);
                }
                if (i == 3) {
                    return VERSION.hasQFN ? new QFNFont(4384, 3) : new BloodFont(4384, 1);
                }
                if (i == 4) {
                    return VERSION.hasQFN ? new QFNFont(4480, 4) : new BloodFont(4480, 1);
                }
                if (i == 5) {
                    Font console = VERSION.hasQFN ? new QFNFont(4384, 3) : new BloodFont(4384, 1);
                    console.setVerticalScaled(false);
                    return console;
                }
                return EngineUtils.getLargeFont();
            }
        };
    }

    @Override
    public BuildNet net() {
        return new BloodNetwork(this.app);
    }

    @Override
    public SliderDrawable slider() {
        return new BLSliderDrawable();
    }
}

