/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import ru.m210projects.Blood.Factory.BloodEngine;
import ru.m210projects.Blood.Factory.BloodFastColorLookup;
import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.LOADITEM;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Types.Color;
import ru.m210projects.Build.Render.listeners.PaletteListener;
import ru.m210projects.Build.Script.TextureHDInfo;
import ru.m210projects.Build.Types.FastColorLookup;
import ru.m210projects.Build.Types.Palette;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class BloodPaletteManager
implements PaletteManager {
    protected static final Color DEFAULT_COLOR = new Color(0, 0, 0, 0);
    public byte[][] palTable = new byte[5][];
    public int curPaletteIndex;
    public int gGammaLevels;
    public byte[][] gammaTable;
    private boolean gFogMode;
    protected PaletteListener listener = PaletteListener.DUMMY_PALETTE_CHANGE_LISTENER;
    private final Palette currentPalette;
    private final FastColorLookup fastColorLookup;
    private final byte[] basePalette;
    private final byte[][] palookup;
    private final byte[] transluc;
    private final int shadesCount;
    private final Color[] palookupfog;
    private final Engine engine;

    public BloodPaletteManager(BloodEngine engine, boolean gFogMode) throws Exception {
        this.gFogMode = gFogMode;
        this.curPaletteIndex = 0;
        this.basePalette = new byte[768];
        this.palookup = new byte[256][];
        this.engine = engine;
        this.gammaTable = new byte[16][256];
        this.palookupfog = new Color[256];
        this.currentPalette = new Palette();
        this.currentPalette.update(this.basePalette);
        this.fastColorLookup = new BloodFastColorLookup(this, 1, 1, 1);
        Console.out.println("Loading palettes");
        for (LOADITEM loaditem : Globals.PAL) {
            Entry entry = Main.game.getCache().getEntry(loaditem.name + "." + "PAL", true);
            if (!entry.exists()) {
                Console.out.println(loaditem.name + ".PAL not found", OsdColor.RED);
                continue;
            }
            this.palTable[loaditem.index] = entry.getBytes();
        }
        System.arraycopy(this.palTable[0], 0, this.basePalette, 0, 768);
        this.shadesCount = 64;
        this.loadPLUs(gFogMode);
        Console.out.println("Loading translucency table");
        Entry entry = Main.game.getCache().getEntry("trans.tlu", true);
        if (!entry.exists()) {
            throw new Exception("TRANS.TLU not found");
        }
        this.transluc = entry.getBytes();
        Console.out.println("Loading gamma correction table");
        Entry gamma = Main.game.getCache().getEntry("gamma.dat", true);
        if (!gamma.exists()) {
            throw new Exception("Gamma table not found");
        }
        byte[] buf = gamma.getBytes();
        this.gGammaLevels = buf.length / 256;
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(buf, i * 256, this.gammaTable[i], 0, 256);
        }
    }

    public int getGammaLevels() {
        return this.gGammaLevels;
    }

    public boolean isFogMode() {
        return this.gFogMode;
    }

    public void loadPLUs(boolean gFogMode) {
        this.gFogMode = gFogMode;
        if (gFogMode) {
            Entry entry = Main.game.getCache().getEntry("FOG.FLU", true);
            if (!entry.exists()) {
                Console.out.println("FOG.FLU not found", OsdColor.RED);
                return;
            }
            byte[] buf = entry.getBytes();
            for (int i = 0; i < 15; ++i) {
                System.arraycopy(buf, 768 * i, this.palookup[Globals.PLU[i].index], 0, 768);
            }
            Engine.parallaxvisibility = 3072;
        } else {
            for (int i = 0; i < 15; ++i) {
                Entry entry = Main.game.getCache().getEntry(Globals.PLU[i].name + "." + "PLU", true);
                if (!entry.exists()) {
                    Console.out.println(Globals.PLU[i].name + ".PLU not found", OsdColor.RED);
                    return;
                }
                byte[] buf = entry.getBytes();
                if (buf.length / 256 != 64) {
                    Console.out.println("Incorrect PLU size", OsdColor.RED);
                    return;
                }
                this.palookup[Globals.PLU[i].index] = buf;
                int colnum = 0;
                int colindex = this.palookup[Globals.PLU[i].index][colnum + 16128] & 0xFF;
                this.palookupfog[Globals.PLU[i].index] = new Color(this.basePalette[colindex], this.basePalette[colindex + 1], this.basePalette[colindex + 2], 0);
            }
        }
    }

    public void invalidate() {
        this.curPaletteIndex = -1;
    }

    public void setPalette(int nPalette) {
        if (this.curPaletteIndex == nPalette) {
            return;
        }
        this.curPaletteIndex = nPalette;
        this.engine.setbrightness(this.getPaletteGamma(), this.palTable[this.curPaletteIndex]);
        if (Main.game.currentDef != null) {
            TextureHDInfo hdInfo = Main.game.currentDef.texInfo;
            if (nPalette == 1) {
                hdInfo.setPaletteTint(255, 100, 160, 255, 0);
            } else if (nPalette == 2) {
                hdInfo.setPaletteTint(255, 255, 120, 120, 0);
            } else if (nPalette == 3) {
                hdInfo.setPaletteTint(255, 180, 200, 50, 0);
            } else {
                hdInfo.setPaletteTint(255, 255, 255, 255, 0);
            }
        }
    }

    @Override
    public Color getFogColor(int pal) {
        if (this.palookupfog[pal] == null) {
            return DEFAULT_COLOR;
        }
        return this.palookupfog[pal];
    }

    @Override
    public boolean isValidPalette(int paletteIndex) {
        if (paletteIndex < 0 || paletteIndex >= this.palookup.length) {
            return false;
        }
        return this.palookup[paletteIndex] != null;
    }

    @Override
    public boolean changePalette(byte[] palette) {
        BloodRenderer renderer = Main.game.getRenderer();
        if (!this.currentPalette.update(palette)) {
            return false;
        }
        this.fastColorLookup.invalidate();
        renderer.changepalette(palette);
        return true;
    }

    @Override
    public byte[] makePalookup(int palnum, byte[] remapbuf, int r, int g, int b, int dastat) {
        if (!this.isValidPalette(palnum)) {
            this.palookup[palnum] = new byte[this.shadesCount << 8];
        }
        if (dastat == 0 || (r | g | b | 0x3F) != 63) {
            return this.palookup[palnum];
        }
        if (dastat == 2) {
            int len = Math.min(this.palookup[palnum].length, remapbuf.length);
            System.arraycopy(remapbuf, 0, this.palookup[palnum], 0, len);
        } else {
            if ((r | g | b) == 0) {
                for (int i = 0; i < 256; ++i) {
                    for (int j = 0; j < this.shadesCount; ++j) {
                        this.palookup[palnum][i + j * 256] = this.palookup[0][(remapbuf[i] & 0xFF) + j * 256];
                    }
                }
            } else {
                byte[] palette = this.currentPalette.getBytes();
                for (int i = 0; i < this.shadesCount; ++i) {
                    int palscale = Pragmas.divscale(i, this.shadesCount, 16);
                    for (int j = 0; j < 256; ++j) {
                        int rptr = palette[3 * (remapbuf[j] & 0xFF)] & 0xFF;
                        int gptr = palette[3 * (remapbuf[j] & 0xFF) + 1] & 0xFF;
                        int bptr = palette[3 * (remapbuf[j] & 0xFF) + 2] & 0xFF;
                        this.palookup[palnum][j + i * 256] = this.fastColorLookup.getClosestColorIndex(palette, rptr + Pragmas.mulscale(r - rptr, palscale, 16), gptr + Pragmas.mulscale(g - gptr, palscale, 16), bptr + Pragmas.mulscale(b - bptr, palscale, 16));
                    }
                }
            }
            this.palookupfog[palnum] = new Color(r, g, b, 0);
        }
        this.listener.onPalookupChanged(palnum);
        return this.palookup[palnum];
    }

    @Override
    public int getPaletteGamma() {
        return this.engine.getConfig().getPaletteGamma();
    }

    @Override
    public byte[] getBasePalette() {
        return this.basePalette;
    }

    @Override
    public Palette getCurrentPalette() {
        return this.currentPalette;
    }

    @Override
    public FastColorLookup getFastColorLookup() {
        return this.fastColorLookup;
    }

    @Override
    public int getColorIndex(int pal, int colorIndex) {
        if (colorIndex >= this.palookup[pal].length) {
            return 0;
        }
        return this.palookup[pal][colorIndex] & 0xFF;
    }

    @Override
    public int getColorIndex(int pal, int color, int shade) {
        if (!this.isValidPalette(pal)) {
            pal = 0;
        }
        if (color >= this.palookup[pal].length) {
            return 0;
        }
        shade = Math.min(Math.max(shade, 0), this.shadesCount - 1);
        return this.palookup[pal][color + (shade << 8)] & 0xFF;
    }

    @Override
    public byte[][] getPalookupBuffer() {
        return this.palookup;
    }

    @Override
    public byte[] getTranslucBuffer() {
        return this.transluc;
    }

    @Override
    public int getShadeCount() {
        return this.shadesCount;
    }

    @Override
    public byte[][] getBritableBuffer() {
        return this.gammaTable;
    }

    @Override
    public void setListener(PaletteListener listener) {
        this.listener = listener;
    }

    @Override
    public void setbrightness(int nGamma, byte[] dapal) {
        int curbrightness = Gameutils.BClipRange(nGamma, 0, this.gGammaLevels);
        byte[] temppal = new byte[768];
        if (curbrightness != 0) {
            for (int i = 0; i < dapal.length; ++i) {
                temppal[i] = this.gammaTable[nGamma][dapal[i] & 0xFF];
            }
        } else {
            System.arraycopy(dapal, 0, temppal, 0, dapal.length);
        }
        int r = this.gammaTable[curbrightness][1] >> 2;
        int g = this.gammaTable[curbrightness][1] >> 2;
        int b = this.gammaTable[curbrightness][1] >> 2;
        this.setFogColor(0, new Color(r, g, b, 0));
        this.changePalette(temppal);
    }

    protected void setFogColor(int palnum, Color fogColor) {
        if (!fogColor.equals(this.palookupfog[palnum])) {
            this.palookupfog[palnum] = fogColor;
        }
    }
}

