/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import com.badlogic.gdx.graphics.Pixmap;
import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Main;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.TexFilter;
import ru.m210projects.Build.Render.TextureHandle.Hicreplctyp;
import ru.m210projects.Build.Render.TextureHandle.IndexedTileData;
import ru.m210projects.Build.Render.TextureHandle.PixmapTileData;
import ru.m210projects.Build.Render.TextureHandle.RGBTileData;
import ru.m210projects.Build.Render.TextureHandle.TextureManager;
import ru.m210projects.Build.Render.TextureHandle.TileData;
import ru.m210projects.Build.Types.Palette;
import ru.m210projects.Build.Types.PaletteManager;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class BloodTextureManager
extends TextureManager {
    public BloodTextureManager(Engine engine) {
        super(engine, TextureManager.ExpandTexture.Both);
    }

    @Override
    protected TileData loadPic(TileData.PixelFormat fmt, Hicreplctyp hicr, ArtEntry artEntry, int dapalnum, boolean clamping, boolean alpha, int skybox, TexFilter textureFilter) {
        block4: {
            Entry entry;
            if (hicr != null && (entry = this.checkResource(hicr, artEntry.getNum(), skybox)) != null && entry.exists()) {
                try {
                    byte[] data = entry.getBytes();
                    return new PixmapTileData(new Pixmap(data, 0, data.length), clamping, this.expand.get());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (skybox == 0) break block4;
                    return null;
                }
            }
        }
        if (fmt == TileData.PixelFormat.Pal8) {
            return new IndexedTileData(artEntry, clamping, alpha, this.expand.get());
        }
        return new RGBTileData(this.engine.getPaletteManager(), artEntry, dapalnum, clamping, alpha, this.expand.get(), textureFilter != TexFilter.NONE){

            @Override
            protected int getColor(PaletteManager paletteManager, int dacol, int dapal, boolean alphaMode) {
                BloodRenderer renderer = Main.game.getRenderer();
                byte[][] palookup = paletteManager.getPalookupBuffer();
                Palette curpalette = paletteManager.getCurrentPalette();
                if (alphaMode && (dacol &= 0xFF) == 255) {
                    return curpalette.getRGBA(0, (byte)0);
                }
                if (dacol >= palookup[dapal].length) {
                    return 0;
                }
                if (dapal == 1) {
                    int shade = Math.min(Math.max(renderer.getCurrentShade(), 0), paletteManager.getShadeCount() - 1);
                    dacol = palookup[dapal][dacol + (shade << 8)] & 0xFF;
                } else {
                    dacol = palookup[dapal][dacol] & 0xFF;
                }
                return curpalette.getRGBA(dacol, (byte)-1);
            }
        };
    }
}

