/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector2;
import java.io.InputStream;
import java.util.Arrays;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.Hitscan;
import ru.m210projects.Build.Types.Point;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class Gameutils {
    private static final short[] handled = new short[Engine.MAXSECTORS + 7 >> 3];
    private static final char[] buf = new char[80];
    public static int extents_zTop;
    public static int extents_zBot;
    public static Vector2 normal;
    public static int foundSector;
    public static int clipm_px;
    public static int clipm_py;
    public static int clipm_pz;
    public static int clipm_pnsectnum;
    public static boolean clipmove_error;
    public static int gz_ceilZ;
    public static int gz_ceilHit;
    public static int gz_floorZ;
    public static int gz_floorHit;
    public static int bseed;
    public static int vseed;
    private static final Point TMP_POINT;

    public static int M2Z(double n) {
        return (int)(n * 8192.0);
    }

    public static int M2X(double n) {
        return (int)(n * 512.0);
    }

    public static void GetSpriteExtents(Sprite pSprite) {
        extents_zTop = extents_zBot = pSprite.getZ();
        short nTile = pSprite.getPicnum();
        if (nTile == -1 || (pSprite.getCstat() & 0x30) == 32) {
            return;
        }
        ArtEntry pic = Main.engine.getTile(nTile);
        extents_zTop -= (pic.getOffsetY() + pic.getHeight() / 2) * (pSprite.getYrepeat() << 2);
        extents_zBot += (pic.getHeight() - (pic.getHeight() / 2 + pic.getOffsetY())) * (pSprite.getYrepeat() << 2);
    }

    public static Point RotatePoint(int x, int y, int daang, int xpivot, int ypivot) {
        TMP_POINT.set(Pragmas.dmulscaler(x -= xpivot, Trig.Cos(daang), -(y -= ypivot), Trig.Sin(daang), 30) + xpivot, Pragmas.dmulscaler(y, Trig.Cos(daang), x, Trig.Sin(daang), 30) + ypivot, 0);
        return TMP_POINT;
    }

    public static boolean IsPlayerSprite(Sprite pSprite) {
        return pSprite != null && pSprite.getLotag() >= 231 && pSprite.getLotag() <= 238;
    }

    public static int ClipRange(int value, int min, int max) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static int ClipLow(int value, int min) {
        if (value < min) {
            value = min;
        }
        return value;
    }

    public static int ClipHigh(int value, int max) {
        if (value > max) {
            value = max;
        }
        return value;
    }

    public static float ClipLow(float value, int min) {
        if (value < (float)min) {
            value = min;
        }
        return value;
    }

    public static float ClipHigh(float value, int max) {
        if (value > (float)max) {
            value = max;
        }
        return value;
    }

    public static int GetWallAngle(int nWall) {
        int dx = Main.boardService.getWall(Main.boardService.getWall(nWall).getPoint2()).getX() - Main.boardService.getWall(nWall).getX();
        int dy = Main.boardService.getWall(Main.boardService.getWall(nWall).getPoint2()).getY() - Main.boardService.getWall(nWall).getY();
        return EngineUtils.getAngle(dx, dy);
    }

    public static void GetWallNormal(int nWall) {
        int ny;
        if (!Main.boardService.isValidWall(nWall)) {
            throw new AssertException("boardService.isValidWall(nWall)");
        }
        int nx = -(Main.boardService.getWall(Main.boardService.getWall(nWall).getPoint2()).getY() - Main.boardService.getWall(nWall).getY()) >> 4;
        int length = EngineUtils.sqrt(nx * nx + (ny = Main.boardService.getWall(Main.boardService.getWall(nWall).getPoint2()).getX() - Main.boardService.getWall(nWall).getX() >> 4) * ny);
        if (length <= 0) {
            length = 1;
        }
        normal.set(Pragmas.divscale(nx, length, 16), Pragmas.divscale(ny, length, 16));
    }

    private static boolean checkDistance(int nPoint2, int x, int y, int distance) {
        int x1 = Main.boardService.getWall(nPoint2).getX();
        int y1 = Main.boardService.getWall(nPoint2).getY();
        nPoint2 = Main.boardService.getWall(nPoint2).getPoint2();
        int x2 = Main.boardService.getWall(nPoint2).getX();
        int y2 = Main.boardService.getWall(nPoint2).getY();
        int dist2 = (distance *= 16) * distance;
        int dwx = x2 - x1;
        int dwy = y2 - y1;
        int dsx1 = x - x1;
        int dsx2 = x - x2;
        int dsy1 = y - y1;
        int dsy2 = y - y2;
        if (x1 >= x2) {
            if (x <= x2 - distance || x >= x1 + distance) {
                return false;
            }
            if (x1 == x2) {
                if (y1 >= y2) {
                    if (y <= y2 - distance || y >= y1 + distance) {
                        return false;
                    }
                    if (y < y2) {
                        return dsy2 * dsy2 + dsx2 * dsx2 < dist2;
                    }
                    if (y > y1) {
                        return dsy1 * dsy1 + dsx1 * dsx1 < dist2;
                    }
                } else {
                    if (y <= y1 - distance || y >= y2 + distance) {
                        return false;
                    }
                    if (y < y1) {
                        return dsy1 * dsy1 + dsx1 * dsx1 < dist2;
                    }
                    if (y > y2) {
                        return dsy2 * dsy2 + dsx2 * dsx2 < dist2;
                    }
                }
                return true;
            }
        } else if (x <= x1 - distance || x >= x2 + distance) {
            return false;
        }
        if (y2 <= y1) {
            if (y <= y2 - distance || y >= y1 + distance) {
                return false;
            }
            if (y1 == y2) {
                if (x1 >= x2) {
                    if (x <= x2 - distance || x >= x1 + distance) {
                        return false;
                    }
                    if (x < x2) {
                        return dsy2 * dsy2 + dsx2 * dsx2 < dist2;
                    }
                    if (x > x1) {
                        return dsy2 * dsy2 + dsx1 * dsx1 < dist2;
                    }
                } else {
                    if (x <= x1 - distance || x >= x2 + distance) {
                        return false;
                    }
                    if (x < x1) {
                        return dsy2 * dsy2 + dsx1 * dsx1 < dist2;
                    }
                    if (x > x2) {
                        return dsy2 * dsy2 + dsx2 * dsx2 < dist2;
                    }
                }
            }
        } else if (y <= y1 - distance || y >= y2 + distance) {
            return false;
        }
        if (dsy2 * dwy + dwx * dsx2 >= 0) {
            return dsy2 * dsy2 + dsx2 * dsx2 < dist2;
        }
        if (dsy1 * dwy + dwx * dsx1 <= 0) {
            return dsy1 * dsy1 + dsx1 * dsx1 < dist2;
        }
        return (dwy * dsx1 - dsy1 * dwx) * (dwy * dsx1 - dsy1 * dwx) < dist2 * (dwx * dwx + dwy * dwy);
    }

    public static void NearSectors(int nSector, int x, int y, int distance, int[] pSectors, byte[] pSprites, int[] pWalls) {
        if (pSectors == null) {
            throw new AssertException("pSectors != null");
        }
        int sectorcount = 1;
        int nextsectnum = 1;
        pSectors[0] = nSector;
        Arrays.fill(handled, (short)0);
        int n = nSector >> 3;
        handled[n] = (short)(handled[n] | 1 << (nSector & 7));
        int secIndex = 0;
        int xwallcount = 0;
        if (pSprites != null) {
            Arrays.fill(pSprites, (byte)0);
            int n2 = nSector >> 3;
            pSprites[n2] = (byte)(pSprites[n2] | 1 << (nSector & 7));
        }
        while (secIndex < sectorcount) {
            int cursect = pSectors[secIndex];
            if (Main.boardService.getSector(cursect) == null) {
                ++secIndex;
                continue;
            }
            int startwall = Main.boardService.getSector(cursect).getWallptr();
            int endwall = startwall + Main.boardService.getSector(cursect).getWallnum();
            if (startwall < 0 || endwall < 0) {
                ++secIndex;
                continue;
            }
            Wall pWall = Main.boardService.getWall(startwall);
            while (startwall < endwall) {
                if (pWall == null) {
                    ++startwall;
                    continue;
                }
                short nextsector = pWall.getNextsector();
                if (nextsector >= 0 && (handled[nextsector >> 3] & 1 << (nextsector & 7)) == 0) {
                    int n3 = nextsector >> 3;
                    handled[n3] = (short)(handled[n3] | 1 << (nextsector & 7));
                    short nPoint2 = Main.boardService.getWall(startwall).getPoint2();
                    if (Gameutils.checkDistance(nPoint2, x, y, distance)) {
                        short nXWall;
                        if (pSprites != null) {
                            int n4 = nextsector >> 3;
                            pSprites[n4] = (byte)(pSprites[n4] | 1 << (nextsector & 7));
                        }
                        pSectors[sectorcount++] = nextsector;
                        ++nextsectnum;
                        if (pWalls != null && (nXWall = pWall.getExtra()) > 0) {
                            XWALL pXWall = DB.xwall[nXWall];
                            if (pXWall.triggerVector && pXWall.state == 0 && !pXWall.isTriggered) {
                                pWalls[xwallcount++] = startwall;
                            }
                        }
                    }
                }
                pWall = Main.boardService.getWall(++startwall);
            }
            ++secIndex;
        }
        pSectors[nextsectnum] = -1;
        if (pWalls != null) {
            pWalls[xwallcount] = -1;
        }
    }

    public static int HitScan(Sprite pSprite, int z, int dx, int dy, int dz, Hitscan hitInfo, int clipmask, int dist) {
        if (pSprite == null) {
            return -1;
        }
        hitInfo.hitsect = -1;
        hitInfo.hitwall = -1;
        hitInfo.hitsprite = -1;
        int x = pSprite.getX();
        int y = pSprite.getY();
        short nSector = pSprite.getSectnum();
        short oldcstat = pSprite.getCstat();
        pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFF);
        if (dist != 0) {
            Engine.hitscangoalx = x + Pragmas.mulscale((long)dist << 4, Trig.Cos(pSprite.getAng()), 30);
            Engine.hitscangoaly = y + Pragmas.mulscale((long)dist << 4, Trig.Sin(pSprite.getAng()), 30);
        } else {
            Engine.hitscangoaly = 0x1FFFFFFF;
            Engine.hitscangoalx = 0x1FFFFFFF;
        }
        Main.engine.hitscan(x, y, z, nSector, dx, dy, dz << 4, hitInfo, clipmask);
        Engine.hitscangoaly = 0x1FFFFFFF;
        Engine.hitscangoalx = 0x1FFFFFFF;
        pSprite.setCstat(oldcstat);
        if (hitInfo.hitsprite != -1) {
            return 3;
        }
        if (hitInfo.hitwall != -1) {
            short nNextSector = Main.boardService.getWall(hitInfo.hitwall).getNextsector();
            if (nNextSector == -1) {
                return 0;
            }
            Main.engine.getzsofslope(nNextSector, hitInfo.hitx, hitInfo.hity, Globals.floorz, Globals.ceilz);
            if (hitInfo.hitz <= Globals.ceilz.get() || hitInfo.hitz >= Globals.floorz.get()) {
                return 0;
            }
            return 4;
        }
        if (hitInfo.hitsect != -1) {
            return hitInfo.hitz > z ? 2 : 1;
        }
        return -1;
    }

    public static int VectorScan(Sprite pActor, int xoffset, int zoffset, int dx, int dy, int dz, int dist, int flags) {
        Sector hitsect = null;
        Sector nextsect = null;
        if (pActor == null) {
            throw new AssertException("pSprite != null");
        }
        Engine.pHitInfo.hitsect = -1;
        Engine.pHitInfo.hitwall = -1;
        Engine.pHitInfo.hitsprite = -1;
        int x = pActor.getX() + Pragmas.mulscale(xoffset, Trig.Cos(pActor.getAng() + 512), 30);
        int y = pActor.getY() + Pragmas.mulscale(xoffset, Trig.Sin(pActor.getAng() + 512), 30);
        int z = pActor.getZ() + zoffset;
        short oldcstat = pActor.getCstat();
        pActor.setCstat(pActor.getCstat() & 0xFFFFFEFF);
        if (dist != 0) {
            Engine.hitscangoalx = x + Pragmas.mulscale((long)dist << 4, Trig.Cos(pActor.getAng()), 30);
            Engine.hitscangoaly = y + Pragmas.mulscale((long)dist << 4, Trig.Sin(pActor.getAng()), 30);
        } else {
            Engine.hitscangoaly = 0x1FFFFFFF;
            Engine.hitscangoalx = 0x1FFFFFFF;
        }
        Main.engine.hitscan(x, y, z, pActor.getSectnum(), dx, dy, dz << 4, Engine.pHitInfo, 0x1000040);
        pActor.setCstat(oldcstat);
        int hitcount = 256;
        while (hitcount != -1) {
            int hy;
            int hx;
            --hitcount;
            if (Engine.pHitInfo.hitsprite != -1 && !Main.boardService.isValidSprite(Engine.pHitInfo.hitsprite) || Engine.pHitInfo.hitwall >= Main.boardService.getWallCount() || Engine.pHitInfo.hitsect >= Main.boardService.getSectorCount()) {
                return -1;
            }
            if (dist != 0 && EngineUtils.qdist(hx = Engine.pHitInfo.hity - pActor.getY(), hy = Engine.pHitInfo.hitx - pActor.getX()) > dist) {
                return -1;
            }
            if (Engine.pHitInfo.hitsprite != -1) {
                BloodSprite pSprite = Main.boardService.getSprite(Engine.pHitInfo.hitsprite);
                if ((pSprite.getHitag() & 8) != 0 && (flags & 1) == 0) {
                    return 3;
                }
                if ((pSprite.getCstat() & 0x30) == 0) {
                    short nTile = pSprite.getPicnum();
                    ArtEntry pic = Main.engine.getTile(nTile);
                    if (pic.getWidth() == 0 || pic.getHeight() == 0) {
                        return 3;
                    }
                    int height = pic.getHeight() * pSprite.getYrepeat() << 2;
                    int zBot = pSprite.getZ();
                    if ((pSprite.getCstat() & 0x80) != 0) {
                        zBot += height / 2;
                    }
                    if (pic.getOffsetY() != 0) {
                        zBot -= pic.getOffsetY() * pSprite.getYrepeat() << 2;
                    }
                    if (height <= 0) {
                        throw new AssertException("height > 0");
                    }
                    int texy = Pragmas.muldiv(zBot - Engine.pHitInfo.hitz, pic.getHeight(), height);
                    if ((pSprite.getCstat() & 8) == 0) {
                        texy = pic.getHeight() - texy;
                    }
                    if (texy >= 0 && texy < pic.getHeight()) {
                        int texel;
                        int width = pSprite.getXrepeat() * pic.getWidth() >> 2;
                        width = width * 3 / 4;
                        int top = dx * (y - pSprite.getY()) - dy * (x - pSprite.getX());
                        int bot = EngineUtils.sqrt(dx * dx + dy * dy);
                        if (width <= 0) {
                            throw new AssertException("width > 0");
                        }
                        int texx = Pragmas.muldiv(top / bot, pic.getWidth(), width);
                        if ((texx += pic.getWidth() / 2 + pic.getOffsetX()) >= 0 && texx < pic.getWidth() && (texel = Gameutils.getTexelCol(nTile, texx * pic.getHeight() + texy)) != 255) {
                            return 3;
                        }
                    }
                    oldcstat = pSprite.getCstat();
                    pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFF);
                    Engine.pHitInfo.hitsect = -1;
                    Engine.pHitInfo.hitwall = -1;
                    Engine.pHitInfo.hitsprite = -1;
                    x = Engine.pHitInfo.hitx;
                    y = Engine.pHitInfo.hity;
                    z = Engine.pHitInfo.hitz;
                    Main.engine.hitscan(x, y, z, pSprite.getSectnum(), dx, dy, dz << 4, Engine.pHitInfo, 0x1000040);
                    pSprite.setCstat(oldcstat);
                    continue;
                }
                return 3;
            }
            if (Engine.pHitInfo.hitwall != -1) {
                boolean ynice;
                Wall pWall = Main.boardService.getWall(Engine.pHitInfo.hitwall);
                short nextSector = pWall.getNextsector();
                if (nextSector == -1) {
                    return 0;
                }
                hitsect = Main.boardService.getSector(Engine.pHitInfo.hitsect);
                nextsect = Main.boardService.getSector(nextSector);
                Main.engine.getzsofslope(nextSector, Engine.pHitInfo.hitx, Engine.pHitInfo.hity, Globals.floorz, Globals.ceilz);
                if (Engine.pHitInfo.hitz <= Globals.ceilz.get()) {
                    return 0;
                }
                if (Engine.pHitInfo.hitz >= Globals.floorz.get()) {
                    if (hitsect != null && (hitsect.getFloorstat() & 1) == 0 || nextsect != null && (nextsect.getFloorstat() & 1) == 0) {
                        return 0;
                    }
                    return 2;
                }
                if ((pWall.getCstat() & 0x30) == 0) {
                    return 0;
                }
                int zOrg = (pWall.getCstat() & 4) != 0 ? Gameutils.ClipHigh(hitsect.getFloorz(), nextsect.getFloorz()) : Gameutils.ClipLow(hitsect.getCeilingz(), nextsect.getCeilingz());
                int zOff = Engine.pHitInfo.hitz - zOrg >> 8;
                if ((pWall.getCstat() & 0x100) != 0) {
                    zOff = -zOff;
                }
                short nTile = pWall.getOverpicnum();
                ArtEntry pic = Main.engine.getTile(nTile);
                int tsizx = pic.getWidth();
                int tsizy = pic.getHeight();
                boolean xnice = 1 << pic.getSizex() == tsizx;
                boolean bl = ynice = 1 << pic.getSizey() == tsizy;
                if (tsizx == 0 || tsizy == 0) {
                    return 0;
                }
                int texy = zOff * pWall.getYrepeat() / 8 + pWall.getYpanning() * tsizy / 256;
                int len = EngineUtils.qdist(pWall.getX() - Main.boardService.getWall(pWall.getPoint2()).getX(), pWall.getY() - Main.boardService.getWall(pWall.getPoint2()).getY());
                int distance = (pWall.getCstat() & 8) != 0 ? EngineUtils.qdist(Engine.pHitInfo.hitx - Main.boardService.getWall(pWall.getPoint2()).getX(), Engine.pHitInfo.hity - Main.boardService.getWall(pWall.getPoint2()).getY()) : EngineUtils.qdist(Engine.pHitInfo.hitx - pWall.getX(), Engine.pHitInfo.hity - pWall.getY());
                int texx = distance * pWall.getXrepeat() * 8 / len + pWall.getXpanning();
                texx = xnice ? (texx &= tsizx - 1) : (texx %= tsizx);
                texy = ynice ? (texy &= tsizy - 1) : (texy %= tsizy);
                int texel = ynice ? Gameutils.getTexelCol(nTile, (texx << pic.getSizey()) + texy) : (texx * pic.getHeight() + texy >= 0 ? Gameutils.getTexelCol(nTile, texx * pic.getHeight() + texy) : 0);
                if (texel == 255) {
                    short oldcstat1 = pWall.getCstat();
                    pWall.setCstat(pWall.getCstat() & 0xFFFFFFBF);
                    short oldcstat2 = Main.boardService.getWall(pWall.getNextwall()).getCstat();
                    Main.boardService.getWall(pWall.getNextwall()).setCstat(Main.boardService.getWall(pWall.getNextwall()).getCstat() & 0xFFFFFFBF);
                    Engine.pHitInfo.hitsect = -1;
                    Engine.pHitInfo.hitwall = -1;
                    Engine.pHitInfo.hitsprite = -1;
                    x = Engine.pHitInfo.hitx;
                    y = Engine.pHitInfo.hity;
                    z = Engine.pHitInfo.hitz;
                    Main.engine.hitscan(x, y, z, pWall.getNextsector(), dx, dy, dz << 4, Engine.pHitInfo, 0x1000040);
                    pWall.setCstat(oldcstat1);
                    Main.boardService.getWall(pWall.getNextwall()).setCstat(oldcstat2);
                    continue;
                }
                return 4;
            }
            if (Engine.pHitInfo.hitsect != -1) {
                if (dz <= 0) {
                    int nLower = Warp.gLowerLink[Engine.pHitInfo.hitsect];
                    if (nLower < 0) {
                        return 1;
                    }
                    short nUpper = Main.boardService.getSprite(nLower).getOwner();
                    if (nUpper < 0) {
                        return 1;
                    }
                    Engine.pHitInfo.hitsect = -1;
                    Engine.pHitInfo.hitwall = -1;
                    Engine.pHitInfo.hitsprite = -1;
                    x = Engine.pHitInfo.hitx + Main.boardService.getSprite(nUpper).getX() - Main.boardService.getSprite(nLower).getX();
                    y = Engine.pHitInfo.hity + Main.boardService.getSprite(nUpper).getY() - Main.boardService.getSprite(nLower).getY();
                    z = Engine.pHitInfo.hitz + Main.boardService.getSprite(nUpper).getZ() - Main.boardService.getSprite(nLower).getZ();
                    Main.engine.hitscan(x, y, z, Main.boardService.getSprite(nUpper).getSectnum(), dx, dy, dz << 4, Engine.pHitInfo, 0x1000040);
                    continue;
                }
                int nUpper = Warp.gUpperLink[Engine.pHitInfo.hitsect];
                if (nUpper < 0) {
                    return 2;
                }
                short nLower = Main.boardService.getSprite(nUpper).getOwner();
                if (nLower < 0) {
                    return 2;
                }
                Engine.pHitInfo.hitsect = -1;
                Engine.pHitInfo.hitwall = -1;
                Engine.pHitInfo.hitsprite = -1;
                x = Engine.pHitInfo.hitx + Main.boardService.getSprite(nLower).getX() - Main.boardService.getSprite(nUpper).getX();
                y = Engine.pHitInfo.hity + Main.boardService.getSprite(nLower).getY() - Main.boardService.getSprite(nUpper).getY();
                z = Engine.pHitInfo.hitz + Main.boardService.getSprite(nLower).getZ() - Main.boardService.getSprite(nUpper).getZ();
                Main.engine.hitscan(x, y, z, Main.boardService.getSprite(nLower).getSectnum(), dx, dy, dz << 4, Engine.pHitInfo, 0x1000040);
                continue;
            }
            return -1;
        }
        return -1;
    }

    private static int getTexelCol(int nTile, int pos) {
        int n;
        block8: {
            ArtEntry art = Main.engine.getTile(nTile);
            InputStream is = art.getInputStream();
            try {
                StreamUtils.skip(is, pos);
                n = is.read();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return 255;
                }
            }
            is.close();
        }
        return n;
    }

    public static boolean FindSector(int x, int y, int z, int nSector) {
        foundSector = nSector;
        if (Main.engine.inside(x, y, nSector) != 0) {
            Main.engine.getzsofslope(nSector, x, y, Globals.floorz, Globals.ceilz);
            if (z >= Globals.ceilz.get() && z <= Globals.floorz.get()) {
                return true;
            }
        }
        int wallid = Main.boardService.getSector(nSector).getWallptr();
        int i = Main.boardService.getSector(nSector).getWallnum();
        while (i > 0) {
            short j = Main.boardService.getWall(wallid).getNextsector();
            if (j >= 0 && Main.engine.inside(x, y, j) != 0) {
                Main.engine.getzsofslope(j, x, y, Globals.floorz, Globals.ceilz);
                if (z >= Globals.ceilz.get() && z <= Globals.floorz.get()) {
                    foundSector = nSector = (int)j;
                    return true;
                }
            }
            --i;
            ++wallid;
        }
        for (i = 0; i < Main.boardService.getSectorCount(); ++i) {
            if (Main.engine.inside(x, y, (short)i) == 0) continue;
            Main.engine.getzsofslope((short)i, x, y, Globals.floorz, Globals.ceilz);
            if (z < Globals.ceilz.get() || z > Globals.floorz.get()) continue;
            foundSector = nSector = (int)((short)i);
            return true;
        }
        return false;
    }

    public static int ClipMove(int px, int py, int pz, int pnSector, long dx, long dy, int wallDist, int ceilDist, int floorDist, int clipType) {
        clipmove_error = false;
        int ccode = Main.engine.clipmove(px, py, pz, pnSector, dx << 14, dy << 14, wallDist, ceilDist, floorDist, clipType);
        clipm_px = Engine.clipmove_x;
        clipm_py = Engine.clipmove_y;
        clipm_pz = Engine.clipmove_z;
        clipm_pnsectnum = Engine.clipmove_sectnum;
        if (Engine.clipmove_sectnum == -1) {
            clipmove_error = true;
            clipm_px = px;
            clipm_py = py;
            clipm_pz = pz;
            clipm_pnsectnum = pnSector;
        }
        return ccode;
    }

    public static void GetZRange(Sprite pSprite, int clipdist, int cliptype) {
        int nUpper;
        int sectnum;
        if (pSprite == null) {
            throw new AssertException("pSprite != null");
        }
        short oldcstat = pSprite.getCstat();
        pSprite.setCstat(pSprite.getCstat() & 0xFFFFFEFE);
        Main.engine.getzrange(pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), clipdist, cliptype);
        gz_ceilZ = Engine.zr_ceilz;
        gz_ceilHit = Engine.zr_ceilhit;
        gz_floorZ = Engine.zr_florz;
        gz_floorHit = Engine.zr_florhit;
        if ((gz_floorHit & 0xE0000000) == 0x40000000) {
            short nLower;
            short nXSector;
            sectnum = gz_floorHit & 0x1FFFFFFF;
            if ((cliptype & 0x2000) == 0 && (Main.boardService.getSector(sectnum).getFloorstat() & 1) != 0) {
                gz_floorZ = Integer.MAX_VALUE;
            }
            if ((nXSector = Main.boardService.getSector(sectnum).getExtra()) > 0) {
                gz_floorZ += DB.xsector[nXSector].Depth << 10;
            }
            if ((nUpper = Warp.gUpperLink[sectnum]) >= 0 && (nLower = Main.boardService.getSprite(nUpper).getOwner()) >= 0) {
                Main.engine.getzrange(pSprite.getX() + Main.boardService.getSprite(nLower).getX() - Main.boardService.getSprite(nUpper).getX(), pSprite.getY() + Main.boardService.getSprite(nLower).getY() - Main.boardService.getSprite(nUpper).getY(), pSprite.getZ() + Main.boardService.getSprite(nLower).getZ() - Main.boardService.getSprite(nUpper).getZ(), Main.boardService.getSprite(nLower).getSectnum(), clipdist, cliptype);
                gz_floorZ = Engine.zr_florz;
                gz_floorHit = Engine.zr_florhit;
                gz_floorZ -= Main.boardService.getSprite(nLower).getZ() - Main.boardService.getSprite(nUpper).getZ();
            }
        }
        if ((gz_ceilHit & 0xE0000000) == 0x40000000) {
            int nLower;
            sectnum = gz_ceilHit & 0x1FFFFFFF;
            if ((cliptype & 0x1000) == 0 && (Main.boardService.getSector(sectnum).getCeilingstat() & 1) != 0) {
                gz_ceilZ = Integer.MIN_VALUE;
            }
            if ((nLower = Warp.gLowerLink[sectnum]) >= 0 && (nUpper = (int)Main.boardService.getSprite(nLower).getOwner()) >= 0) {
                Main.engine.getzrange(pSprite.getX() + Main.boardService.getSprite(nUpper).getX() - Main.boardService.getSprite(nLower).getX(), pSprite.getY() + Main.boardService.getSprite(nUpper).getY() - Main.boardService.getSprite(nLower).getY(), pSprite.getZ() + Main.boardService.getSprite(nUpper).getZ() - Main.boardService.getSprite(nLower).getZ(), Main.boardService.getSprite(nUpper).getSectnum(), clipdist, cliptype);
                gz_ceilZ = Engine.zr_ceilz;
                gz_ceilHit = Engine.zr_ceilhit;
                gz_ceilZ -= Main.boardService.getSprite(nUpper).getZ() - Main.boardService.getSprite(nLower).getZ();
            }
        }
        pSprite.setCstat(oldcstat);
    }

    public static void GetZRange(int x, int y, int z, int nSector, int clipdist, int cliptype) {
        int nUpper;
        int sectnum;
        Main.engine.getzrange(x, y, z, nSector, clipdist, cliptype);
        gz_ceilZ = Engine.zr_ceilz;
        gz_ceilHit = Engine.zr_ceilhit;
        gz_floorZ = Engine.zr_florz;
        gz_floorHit = Engine.zr_florhit;
        if ((gz_floorHit & 0xE0000000) == 0x40000000) {
            short nLower;
            short nXSector;
            sectnum = gz_floorHit & 0x1FFFFFFF;
            if ((cliptype & 0x2000) == 0 && (Main.boardService.getSector(sectnum).getFloorstat() & 1) != 0) {
                gz_floorZ = Integer.MAX_VALUE;
            }
            if ((nXSector = Main.boardService.getSector(sectnum).getExtra()) > 0) {
                gz_floorZ += DB.xsector[nXSector].Depth << 10;
            }
            if ((nUpper = Warp.gUpperLink[sectnum]) >= 0 && (nLower = Main.boardService.getSprite(nUpper).getOwner()) >= 0) {
                Main.engine.getzrange(x + Main.boardService.getSprite(nLower).getX() - Main.boardService.getSprite(nUpper).getX(), y + Main.boardService.getSprite(nLower).getY() - Main.boardService.getSprite(nUpper).getY(), z + Main.boardService.getSprite(nLower).getZ() - Main.boardService.getSprite(nUpper).getZ(), Main.boardService.getSprite(nLower).getSectnum(), clipdist, cliptype);
                gz_floorZ = Engine.zr_florz;
                gz_floorHit = Engine.zr_florhit;
                gz_floorZ -= Main.boardService.getSprite(nLower).getZ() - Main.boardService.getSprite(nUpper).getZ();
            }
        }
        if ((gz_ceilHit & 0xE0000000) == 0x40000000) {
            int nLower;
            sectnum = gz_ceilHit & 0x1FFFFFFF;
            if ((cliptype & 0x1000) == 0 && (Main.boardService.getSector(sectnum).getCeilingstat() & 1) != 0) {
                gz_ceilZ = Integer.MIN_VALUE;
            }
            if ((nLower = Warp.gLowerLink[sectnum]) >= 0 && (nUpper = (int)Main.boardService.getSprite(nLower).getOwner()) >= 0) {
                Main.engine.getzrange(x + Main.boardService.getSprite(nUpper).getX() - Main.boardService.getSprite(nLower).getX(), y + Main.boardService.getSprite(nUpper).getY() - Main.boardService.getSprite(nLower).getY(), z + Main.boardService.getSprite(nUpper).getZ() - Main.boardService.getSprite(nLower).getZ(), Main.boardService.getSprite(nUpper).getSectnum(), clipdist, cliptype);
                gz_ceilZ = Engine.zr_ceilz;
                gz_ceilHit = Engine.zr_ceilhit;
                gz_ceilZ -= Main.boardService.getSprite(nUpper).getZ() - Main.boardService.getSprite(nLower).getZ();
            }
        }
    }

    public static boolean CheckProximity(Sprite pSprite, int x, int y, int z, int nSector, int dist) {
        long dz;
        long dy;
        if (pSprite == null) {
            throw new AssertException("pSprite != null");
        }
        long dx = Pragmas.klabs(x - pSprite.getX()) >> 4;
        if (dx < (long)dist && (dy = (long)(Pragmas.klabs(y - pSprite.getY()) >> 4)) < (long)dist && (dz = (long)(Pragmas.klabs(z - pSprite.getZ()) >> 8)) < (long)dist && EngineUtils.qdist(dx, dy) < dist) {
            Gameutils.GetSpriteExtents(pSprite);
            if (Main.engine.cansee(pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), x, y, z, (short)nSector)) {
                return true;
            }
            if (Main.engine.cansee(pSprite.getX(), pSprite.getY(), extents_zTop, pSprite.getSectnum(), x, y, z, (short)nSector)) {
                return true;
            }
            return Main.engine.cansee(pSprite.getX(), pSprite.getY(), extents_zBot, pSprite.getSectnum(), x, y, z, (short)nSector);
        }
        return false;
    }

    public static int Dist3d(int dx, int dy, int dz) {
        return EngineUtils.sqrt((dx >>= 4) * dx + (dy >>= 4) * dy + (dz >>= 8) * dz);
    }

    public static void sRandom(long set) {
        bseed = (int)set;
    }

    public static int bRandom() {
        bseed = bseed * 1103515245 + 12345;
        return bseed >> 16 & Short.MAX_VALUE;
    }

    public static int vRandom() {
        int var = 2 * vseed;
        if ((byte)vseed > (byte)vseed + (byte)vseed) {
            var = var ^ 0x20000004 | 1;
        }
        vseed = var;
        return var & Short.MAX_VALUE;
    }

    public static int ViRandom(int var) {
        return Pragmas.mulscale(var, Gameutils.vRandom(), 14) - var;
    }

    public static boolean Chance(int var) {
        return Gameutils.bRandom() < var;
    }

    public static int BiRandom(int var) {
        return Pragmas.mulscale(var, Gameutils.bRandom(), 14) - var;
    }

    public static int BiRandom2(int var) {
        return Pragmas.mulscale(var, Gameutils.bRandom() + Gameutils.bRandom(), 15) - var;
    }

    public static int Random(int var) {
        return Pragmas.mulscale(var, Gameutils.bRandom(), 15);
    }

    public static char[] toCharArray(String ... text) {
        Strhandler.buildString(buf, 0, text);
        return buf;
    }

    static {
        normal = new Vector2();
        vseed = 1;
        TMP_POINT = new Point();
    }
}

