/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import java.nio.file.Path;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.ResourceHandler;
import ru.m210projects.Blood.Types.EpisodeInfo;
import ru.m210projects.Blood.Types.MapInfo;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.filehandlers.BloodIniFile;
import ru.m210projects.Blood.filehandlers.EpisodeEntry;
import ru.m210projects.Blood.filehandlers.scripts.BloodDef;
import ru.m210projects.Build.Pattern.Tools.IniFile;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;

public class LEVELS {
    public static final int kMaxEpisode = 6;
    public static final int kMinMap = 1;
    public static final int kMaxMap = 16;
    public static final int kMaxMessages = 128;
    public static int foundSecret = 0;
    public static int totalSecrets = 0;
    public static int autoTotalSecrets = 0;
    public static int superSecrets = 0;
    public static int totalKills = 0;
    public static int kills = 0;
    public static int gNextMap;
    public static int nEpisodeCount;
    public static EpisodeInfo currentEpisode;
    public static EpisodeInfo[] gEpisodeInfo;
    public static EpisodeInfo[] gUserEpisodeInfo;
    public static MapInfo gUserMapInfo;

    public static void levelCalcKills() {
        totalKills = 0;
        for (ListNode<Sprite> node = Main.boardService.getStatNode(6); node != null; node = node.getNext()) {
            Sprite pSprite = node.get();
            if (!Actor.IsDudeSprite(pSprite)) {
                Console.out.println("Warning: pDude.type >= kDudeBase && pDude.type < kDudeMax : " + pSprite.getLotag());
                continue;
            }
            if (pSprite.getStatnum() != 6 || pSprite.getLotag() == 219 || pSprite.getLotag() == 220 || pSprite.getLotag() == 245 || pSprite.getLotag() == 239) continue;
            ++totalKills;
        }
    }

    public static MapInfo getUserMapInfo(FileEntry mLevelEntry) {
        FileEntry def;
        String mLevelName = mLevelEntry.getName();
        LEVELS.gUserMapInfo.MapName = mLevelEntry;
        LEVELS.gUserMapInfo.Title = mLevelName;
        LEVELS.gUserMapInfo.Song = null;
        LEVELS.gUserMapInfo.Track = 0;
        FileEntry defFile = mLevelEntry.getParent().getEntry(mLevelName.substring(0, mLevelName.lastIndexOf(46)) + ".def");
        if (defFile.exists()) {
            String song;
            BloodIniFile defScript = new BloodIniFile(new EpisodeEntry.File(defFile));
            defScript.initDef();
            String title = defScript.getKeyString("Title");
            if (title != null && !title.isEmpty()) {
                LEVELS.gUserMapInfo.Title = title;
            }
            if ((song = defScript.getKeyString("Song")) != null) {
                Path currPath = defFile.getRelativePath();
                song = currPath.resolveSibling(song).toString();
            }
            LEVELS.gUserMapInfo.Song = song;
            LEVELS.gUserMapInfo.Track = defScript.getKeyInt("Track");
        }
        if ((def = mLevelEntry.getParent().getEntry("bloodgdx.def")).exists()) {
            BloodDef addonScript = new BloodDef(Main.game.getBaseDef(), (Entry)def);
            addonScript.loadScript(def);
            Main.game.setDefs(addonScript);
        }
        return gUserMapInfo;
    }

    public static void levelSetupSecret(int command) {
        totalSecrets = Main.cfg.useautosecretcount ? autoTotalSecrets : command;
    }

    public static void initEpisodeInfo(BloodIniFile mainIni) {
        for (int i = 0; i < 6; ++i) {
            LEVELS.gEpisodeInfo[i] = new EpisodeInfo();
            LEVELS.gEpisodeInfo[i].iniFile = mainIni;
            LEVELS.gUserEpisodeInfo[i] = new EpisodeInfo();
        }
        nEpisodeCount = 6;
        ResourceHandler.episodeManager.putEpisode(mainIni);
    }

    private static String handleCutscenePath(String path) {
        if (path != null) {
            return FileUtils.getPath(path, new String[0]).getFileName().toString();
        }
        return path;
    }

    public static int getEpisodeInfo(EpisodeInfo[] pEpisodes, BloodIniFile INI) {
        int nEpisodeCount = 0;
        for (int i = 0; i < 6; ++i) {
            EpisodeInfo pEpisode = pEpisodes[i];
            pEpisode.clear();
            if (!INI.set("Episode" + (i + 1))) continue;
            pEpisode.iniFile = INI;
            String title = INI.getKeyString("Title");
            if (title == null || title.isEmpty()) {
                title = "Episode" + (i + 1);
            }
            pEpisode.Title = title;
            pEpisode.CutSceneA = LEVELS.handleCutscenePath(INI.getKeyString("CutSceneA"));
            pEpisode.CutWavA = LEVELS.handleCutscenePath(INI.getKeyString("CutWavA"));
            pEpisode.CutSceneB = LEVELS.handleCutscenePath(INI.getKeyString("CutSceneB"));
            pEpisode.CutWavB = LEVELS.handleCutscenePath(INI.getKeyString("CutWavB"));
            String BloodBatchOnly = INI.getKeyString("BloodBathOnly");
            pEpisode.BBOnly = !BloodBatchOnly.isEmpty() && BloodBatchOnly.charAt(0) == '1' ? 1 : 0;
            pEpisode.CutSceneALevel = 0;
            int CutSceneALevel = INI.getKeyInt("CutSceneALevel");
            if (CutSceneALevel != -1) {
                pEpisode.CutSceneALevel = CutSceneALevel - 1;
            }
            int nMaps = 0;
            for (int j = 1; j < 16; ++j) {
                INI.set("Episode" + (i + 1));
                String mapName = INI.getKeyString("Map" + j);
                if (mapName.isEmpty()) continue;
                if (pEpisode.gMapInfo[j - 1] == null) {
                    pEpisode.gMapInfo[j - 1] = new MapInfo();
                }
                MapInfo pMap = pEpisode.gMapInfo[j - 1];
                INI.set(mapName);
                mapName = String.format("%s.map", mapName);
                Entry mapEntry = Main.game.getCache().getEntry(mapName, true);
                pMap.MapName = mapEntry.exists() ? mapEntry : new FileEntry(FileUtils.getPath(mapName, new String[0]), mapName, 0L);
                LEVELS.levelLoadDef(pMap, INI);
                ++nMaps;
            }
            if (nMaps == 0) {
                pEpisode.clear();
                continue;
            }
            pEpisode.nMaps = nMaps;
            ++nEpisodeCount;
        }
        return nEpisodeCount;
    }

    public static void levelCountSecret(int command) {
        if (command < 0) {
            System.err.println("Invalid secret type " + command + " triggered");
            return;
        }
        if (command != 0) {
            ++superSecrets;
        } else {
            ++foundSecret;
        }
        if (Globals.pGameInfo.nGameType == 0) {
            if (Gameutils.Random(2) == 1) {
                View.viewSetMessage("You found a secret.", Globals.gPlayer[View.gViewIndex].nPlayer, 9);
            } else {
                View.viewSetMessage("A secret is revealed.", Globals.gPlayer[View.gViewIndex].nPlayer, 9);
            }
        }
    }

    public static void levelResetKills() {
        totalKills = 0;
        kills = 0;
    }

    public static void levelResetSecrets() {
        superSecrets = 0;
        totalSecrets = 0;
        foundSecret = 0;
    }

    public static void levelAddKills(Sprite pSprite) {
        if (pSprite.getStatnum() == 6 && pSprite.getLotag() != 219 && pSprite.getLotag() != 220 && pSprite.getLotag() != 245 && pSprite.getLotag() != 239) {
            ++kills;
        }
    }

    public static void loadMapInfo(int nEp, int nMap) {
        Globals.pGameInfo.nEpisode = nEp;
        Globals.pGameInfo.nLevel = nMap;
        currentEpisode = Main.mUserFlag != Main.UserFlag.Addon ? gEpisodeInfo[Globals.pGameInfo.nEpisode] : gUserEpisodeInfo[Globals.pGameInfo.nEpisode];
        MapInfo mapInfo = currentEpisode.getMapInfo(nMap);
        if (mapInfo != null) {
            Globals.pGameInfo.zLevelSong = mapInfo.Song;
            Globals.pGameInfo.zLevelName = mapInfo.MapName;
            Globals.pGameInfo.nTrackNumber = mapInfo.Track;
        } else if (Main.mUserFlag != Main.UserFlag.UserMap) {
            Globals.pGameInfo.zLevelName = Directory.DUMMY_ENTRY;
            Globals.pGameInfo.nLevel = 0;
        }
    }

    public static void levelLoadDef(MapInfo pMap, IniFile INI) {
        String Song;
        pMap.Title = INI.getKeyString("Title");
        if (pMap.Title.isEmpty()) {
            pMap.Title = pMap.MapName.getName();
        }
        pMap.Author = INI.getKeyString("Author");
        pMap.Song = INI.getKeyString("Song");
        pMap.Song = Song = INI.getKeyString("Song");
        pMap.Track = INI.getKeyInt("Track");
        pMap.EndingA = INI.getKeyInt("EndingA");
        pMap.EndingB = INI.getKeyInt("EndingB");
        pMap.Fog = INI.getKeyInt("Fog") == 1;
        pMap.Weather = INI.getKeyInt("Weather") == 1;
        for (int i = 1; i < 128; ++i) {
            String message = INI.getKeyString("Message" + i);
            if (message.isEmpty()) continue;
            pMap.gMessage[i - 1] = message;
        }
    }

    public static void levelEndLevel(int levType) {
        int pnEndingB;
        int i;
        if (Mmulti.numplayers > 1 && Main.game.pNet.bufferJitter > 1 && Mmulti.myconnectindex == Mmulti.connecthead) {
            for (i = 0; i < Main.game.pNet.bufferJitter; ++i) {
                Main.game.pNet.GetNetworkInput();
            }
        }
        if (!Main.game.pNet.WaitForAllPlayers(5000)) {
            Main.game.pNet.NetDisconnect(Mmulti.myconnectindex);
            return;
        }
        if (Globals.pGameInfo.nGameType == 1 && Globals.pGameInfo.nReviveMode) {
            i = Mmulti.connecthead;
            while (i >= 0) {
                if (Globals.gPlayer[i].deathTime > 0) {
                    PLAYER.resetInventory(Globals.gPlayer[i]);
                    PLAYER.playerReset(i);
                }
                i = Mmulti.connectpoint2[i];
            }
        }
        Globals.pGameInfo.uGameFlags |= 1;
        MapInfo pMap = null;
        if (currentEpisode == null || (pMap = LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel]) == null) {
            Globals.pGameInfo.uGameFlags |= 2;
            Globals.pGameInfo.nLevel = 0;
            return;
        }
        int pnEndingA = pMap.EndingA;
        if (pnEndingA >= 0) {
            --pnEndingA;
        }
        if ((pnEndingB = pMap.EndingB) >= 0) {
            --pnEndingB;
        }
        if (levType == 1) {
            if (pnEndingB == -1) {
                if (Globals.pGameInfo.nEpisode + 1 < nEpisodeCount) {
                    if (LEVELS.currentEpisode.CutSceneB != null) {
                        Globals.pGameInfo.uGameFlags |= 8;
                    }
                    Globals.pGameInfo.nLevel = 0;
                    Globals.pGameInfo.uGameFlags |= 2;
                    return;
                }
                Globals.pGameInfo.uGameFlags |= 1;
                Globals.pGameInfo.nLevel = 0;
                return;
            }
            gNextMap = pnEndingB;
            return;
        }
        if (pnEndingA != -1) {
            gNextMap = pnEndingA;
            return;
        }
        if (LEVELS.currentEpisode.CutSceneB != null) {
            Globals.pGameInfo.uGameFlags |= 8;
        }
        Globals.pGameInfo.uGameFlags |= 2;
        Globals.pGameInfo.nLevel = 0;
    }

    public static void levelEndLevelCustom(int nLevel) {
        if (!Main.game.pNet.WaitForAllPlayers(5000)) {
            Main.game.pNet.NetDisconnect(Mmulti.myconnectindex);
            return;
        }
        if (Globals.pGameInfo.nGameType == 1 && Globals.pGameInfo.nReviveMode) {
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (Globals.gPlayer[i].deathTime > 0) {
                    PLAYER.resetInventory(Globals.gPlayer[i]);
                    PLAYER.playerReset(i);
                }
                i = Mmulti.connectpoint2[i];
            }
        }
        Globals.pGameInfo.uGameFlags |= 1;
        if (Main.mUserFlag == Main.UserFlag.UserMap || nLevel >= 16 || nLevel < 0) {
            Globals.pGameInfo.uGameFlags |= 2;
            Globals.pGameInfo.nLevel = 0;
            return;
        }
        gNextMap = nLevel;
    }

    static {
        gEpisodeInfo = new EpisodeInfo[6];
        gUserEpisodeInfo = new EpisodeInfo[6];
        gUserMapInfo = new MapInfo();
    }
}

