/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.utils.ByteArray;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Config;
import ru.m210projects.Blood.Factory.BloodBoardService;
import ru.m210projects.Blood.Factory.BloodCache;
import ru.m210projects.Blood.Factory.BloodEngine;
import ru.m210projects.Blood.Factory.BloodFactory;
import ru.m210projects.Blood.Factory.BloodGameProcessor;
import ru.m210projects.Blood.Factory.BloodMenuHandler;
import ru.m210projects.Blood.Factory.BloodNetwork;
import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Fire;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.LOADSAVE;
import ru.m210projects.Blood.Menus.BLMenuMultiplayer;
import ru.m210projects.Blood.Menus.MainMenu;
import ru.m210projects.Blood.Menus.MenuCorruptGame;
import ru.m210projects.Blood.Menus.MenuDifficulty;
import ru.m210projects.Blood.Menus.MenuGame;
import ru.m210projects.Blood.Menus.MenuNetwork;
import ru.m210projects.Blood.Menus.MenuNewAddon;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.ResourceHandler;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Screens.BloodMessageScreen;
import ru.m210projects.Blood.Screens.CutsceneScreen;
import ru.m210projects.Blood.Screens.DemoScreen;
import ru.m210projects.Blood.Screens.DisconnectScreen;
import ru.m210projects.Blood.Screens.GameScreen;
import ru.m210projects.Blood.Screens.LoadingScreen;
import ru.m210projects.Blood.Screens.LogoScreen;
import ru.m210projects.Blood.Screens.MenuScreen;
import ru.m210projects.Blood.Screens.NetScreen;
import ru.m210projects.Blood.Screens.PrecacheScreen;
import ru.m210projects.Blood.Screens.StatisticScreen;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.EpisodeInfo;
import ru.m210projects.Blood.Types.PLOCATION;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Blood.filehandlers.BloodIniFile;
import ru.m210projects.Blood.filehandlers.EpisodeEntry;
import ru.m210projects.Blood.filehandlers.scripts.BloodDef;
import ru.m210projects.Build.Architecture.MessageType;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.LogSender;
import ru.m210projects.Build.Pattern.ScreenAdapters.DefaultPrecacheScreen;
import ru.m210projects.Build.Pattern.ScreenAdapters.MessageScreen;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Script.Maphack;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.filehandle.Cache;
import ru.m210projects.Build.filehandle.CacheResourceMap;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.Directory;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.filehandle.grp.GrpFile;
import ru.m210projects.Build.filehandle.rff.RffFile;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.CommandResponse;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;
import ru.m210projects.Build.osd.commands.OsdCallback;
import ru.m210projects.Build.osd.commands.OsdCommand;
import ru.m210projects.Build.settings.GameConfig;

public class Main
extends BuildGame {
    public static final String appdef = "bloodgdx.def";
    public static MenuScreen gMenuScreen;
    public static GameScreen gGameScreen;
    public static DemoScreen gDemoScreen;
    public static LoadingScreen gLoadingScreen;
    public static LogoScreen gLogoScreen;
    public static CutsceneScreen gCutsceneScreen;
    public static NetScreen gNetScreen;
    public static StatisticScreen gStatisticScreen;
    public static DisconnectScreen gDisconnectScreen;
    public static UserFlag mUserFlag;
    public static Main game;
    public static BloodEngine engine;
    public static BloodBoardService boardService;
    public static Config cfg;
    public String sversion;
    public BloodMenuHandler menu;
    public final Runnable rMenu = new Runnable(){

        @Override
        public void run() {
            Main.this.resetState();
            Directory gameDir = Main.this.cache.getGameDirectory();
            if (Main.cfg.gDemoSeq == 0 || !gDemoScreen.showDemo(gameDir)) {
                Main.this.changeScreen(gMenuScreen);
            }
        }
    };
    private final Runnable nextLogo = () -> {
        if (Main.cfg.showCutscenes && gCutsceneScreen.init("gti.smk", "gti.wav")) {
            this.changeScreen(gCutsceneScreen.setCallback(this.rMenu));
        } else {
            this.changeScreen(gLogoScreen.setTile(2052).setCallback(this.rMenu));
        }
    };
    public BloodNetwork net;

    public Main(List<String> args, GameConfig bcfg, String appname, String sversion, boolean isDemo, boolean isRelease) throws IOException {
        super(args, bcfg, appname, sversion, isRelease);
        game = this;
        this.sversion = sversion;
        cfg = (Config)bcfg;
        VERSION.SHAREWARE = isDemo;
        Engine.MAXWALLS = 16384;
        Engine.MAXSECTORS = 4096;
    }

    public Main(List<String> args, GameConfig bcfg, String appname, String sversion, boolean isDemo) throws IOException {
        this(args, bcfg, appname, sversion, isDemo, true);
    }

    @Override
    public BuildFactory getFactory() {
        return new BloodFactory(this);
    }

    @Override
    public Cache createFileCache(Directory gameDirectory) {
        return new BloodCache(gameDirectory);
    }

    @Override
    public BloodCache getCache() {
        return (BloodCache)this.cache;
    }

    @Override
    public boolean init() throws Exception {
        FileEntry filgdx;
        this.net = (BloodNetwork)this.pNet;
        boardService = (BloodBoardService)engine.getBoardService();
        this.ConsoleInit();
        Console.out.println("Initializing sound system");
        SOUND.sndInit();
        Console.out.println("Loading INI file");
        Directory gameDir = this.cache.getGameDirectory();
        Globals.MainINI = new BloodIniFile(new EpisodeEntry.File(gameDir.getEntry("blood.ini")));
        Globals.pGameInfo.copy(Globals.defGameInfo);
        Tile.tileInit();
        Globals.fire = new Fire();
        Console.out.println("Loading cosine table");
        Trig.trigInit();
        Console.out.println("Initializing view subsystem");
        View.viewInit();
        DemoUtils.checkDemoEntry(gameDir);
        this.net.ResetNetwork();
        for (int i = 0; i < 8; ++i) {
            Globals.gPlayer[i] = new PLAYER();
            PLAYER.gPrevView[i] = new PLOCATION();
        }
        Globals.gMe = Globals.gPlayer[Mmulti.myconnectindex];
        View.gViewIndex = Mmulti.myconnectindex;
        SeqHandling.SeqInit();
        LEVELS.initEpisodeInfo(Globals.MainINI);
        LEVELS.getEpisodeInfo(LEVELS.gEpisodeInfo, Globals.MainINI);
        this.InitCutscenes();
        Console.out.println("Initializing def-scripts...");
        this.cache.loadGdxDef(this.baseDef, appdef, "bloodgdx.dat");
        if (cfg.isAutoloadFolder()) {
            Console.out.println("Initializing autoload folder");
            block13: for (Entry file : gameDir.getDirectory(gameDir.getEntry("autoload"))) {
                FileEntry fileEntry = (FileEntry)file;
                switch (file.getExtension()) {
                    case "PK3": 
                    case "ZIP": {
                        Group group = this.cache.newGroup(file);
                        Entry def = group.getEntry(appdef);
                        if (def.exists()) {
                            this.cache.addGroup(group, CacheResourceMap.CachePriority.NORMAL);
                            this.baseDef.loadScript(file.getName(), def);
                            break;
                        }
                        if (group.getSize() <= 0) continue block13;
                        RffFile holder = new RffFile(group.getName());
                        ResourceHandler.searchEpisodeResources(group, holder);
                        this.cache.addGroup(holder, CacheResourceMap.CachePriority.NORMAL);
                        ResourceHandler.InitGroupResources(this.getBaseDef(), group.getEntries());
                        break;
                    }
                    case "RFF": 
                    case "GRP": {
                        if (!this.cache.addGroup(file, CacheResourceMap.CachePriority.NORMAL)) break;
                        Group group = this.cache.getGroup(file.getName());
                        ResourceHandler.InitGroupResources(this.getBaseDef(), group.getEntries());
                        break;
                    }
                    case "DEF": {
                        this.baseDef.loadScript(fileEntry.getRelativePath().toString(), fileEntry);
                    }
                }
            }
        }
        if ((filgdx = gameDir.getEntry(appdef)).exists()) {
            this.baseDef.loadScript(filgdx);
        }
        this.setDefs(this.baseDef);
        View.viewHandInit();
        Console.out.println("Initializing weapon animations");
        Weapon.WeaponInit();
        LOADSAVE.FindSaves(this.getUserDirectory());
        this.menu.mMenus[0] = new MainMenu(this);
        this.menu.mMenus[1] = new MenuGame(this);
        this.menu.mMenus[4] = new MenuDifficulty(this);
        this.menu.mMenus[14] = new MenuNewAddon(this);
        this.menu.mMenus[12] = new BLMenuMultiplayer(this);
        this.menu.mMenus[11] = new MenuNetwork(this);
        this.menu.mMenus[17] = new MenuCorruptGame(this);
        gCutsceneScreen = new CutsceneScreen(this);
        gLoadingScreen = new LoadingScreen(this);
        gLogoScreen = new LogoScreen(this, 2.0f);
        gMenuScreen = new MenuScreen(this);
        gGameScreen = new GameScreen(this);
        gDemoScreen = new DemoScreen(this);
        gNetScreen = new NetScreen(this);
        gStatisticScreen = new StatisticScreen(this, 1.0f);
        gDisconnectScreen = new DisconnectScreen(this, 1.0f);
        return true;
    }

    public BloodDef getBaseDef() {
        return (BloodDef)this.baseDef;
    }

    public BloodDef getCurrentDef() {
        return (BloodDef)this.currentDef;
    }

    @Override
    protected MessageScreen createMessage(String header, String text, MessageType type) {
        return new BloodMessageScreen(this, header, text, type);
    }

    @Override
    public void onDropEntry(FileEntry entry) {
        if (!entry.isExtension("map")) {
            return;
        }
        Console.out.println("Start dropped map: " + entry.getName());
        gGameScreen.newgame(false, entry, Globals.pGameInfo.nEpisode, Globals.pGameInfo.nLevel, Globals.pGameInfo.nDifficulty, Globals.pGameInfo.nDifficulty, Globals.pGameInfo.nDifficulty, false);
    }

    @Override
    @NotNull
    public BloodRenderer getRenderer() {
        Renderer renderer = super.getRenderer();
        if (renderer instanceof BloodRenderer) {
            BloodRenderer bloodRenderer = (BloodRenderer)renderer;
            if (bloodRenderer == null) {
                Main.$$$reportNull$$$0(0);
            }
            return bloodRenderer;
        }
        throw new RuntimeException("Dummy renderer!");
    }

    @Override
    public void initRenderer() {
        super.initRenderer();
        View.PaletteView = 0;
        engine.getPaletteManager().setPalette(View.PaletteView);
    }

    @Override
    public BloodGameProcessor createGameProcessor() {
        return new BloodGameProcessor(this);
    }

    @Override
    public BloodGameProcessor getProcessor() {
        return (BloodGameProcessor)super.getProcessor();
    }

    private void ConsoleInit() {
        Console.out.println("Initializing on-screen display system");
        Console.out.setValue("osdtextpal", 12.0f);
        Console.out.setValue("osdtextshade", 2.0f);
        Console.out.setValue("osdeditpal", 12.0f);
        Console.out.getPrompt().setVersion(this.getTitle(), OsdColor.YELLOW, 10);
        Console.out.registerCommand(new OsdCommand("changeteam", "changeteam to 0 or 1"){

            @Override
            public CommandResponse execute(String[] argv) {
                if (argv.length != 1) {
                    Console.out.println("changeteam: " + Main.this.net.gProfile[Mmulti.myconnectindex].team + " ( 0 - auto, 1 - blue, 2 - red )");
                    return CommandResponse.SILENT_RESPONSE;
                }
                int team = Integer.parseInt(argv[0]);
                if (team >= 0 && team < 3) {
                    if (Main.this.net.gProfile[Mmulti.myconnectindex].team == team) {
                        Console.out.println("Already changed");
                        return CommandResponse.SILENT_RESPONSE;
                    }
                    Main.this.net.ChangeTeam(Mmulti.myconnectindex, team);
                    String message = "Your team will change to ";
                    team = team == 0 ? Mmulti.myconnectindex & 1 : --team;
                    switch (team) {
                        case 0: {
                            message = message + "blue after respawn";
                            break;
                        }
                        case 1: {
                            message = message + "red after respawn";
                        }
                    }
                    Console.out.println(message);
                } else {
                    Console.out.println("changeteam: out of range");
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("noenemies", "show enemies"){

            @Override
            public CommandResponse execute(String[] argv) {
                block12: {
                    if (Main.this.isCurrentScreen(gDemoScreen) || Globals.pGameInfo.nGameType != 0 || Mmulti.numplayers > 1) {
                        Console.out.println("noenemies: Single player only");
                        return CommandResponse.SILENT_RESPONSE;
                    }
                    if (argv.length != 1) {
                        Console.out.println("noenemies: " + Actor.gNoEnemies + " ( 0 - disabled, 1 - ai disable, 2 - enabled )");
                        return CommandResponse.SILENT_RESPONSE;
                    }
                    try {
                        int type = Integer.parseInt(argv[0]);
                        if (type >= 0 && type < 3) {
                            Actor.gNoEnemies = type;
                            switch (type) {
                                case 0: 
                                case 1: {
                                    if (type == 0) {
                                        Console.out.println("noenemies disabled");
                                    } else {
                                        Console.out.println("noenemies: ai disable");
                                    }
                                    for (ListNode<Sprite> node = boardService.getStatNode(6); node != null; node = node.getNext()) {
                                        if (DemoUtils.IsOriginalDemo() || Globals.pGameInfo.nGameType != 0 || Mmulti.numplayers >= 2) continue;
                                        Sprite pSprite = node.get();
                                        pSprite.setCstat(pSprite.getCstat() & 0xFFFF7FFF);
                                        pSprite.setCstat(pSprite.getCstat() | 0x1101);
                                        Ai.aiInit(DemoUtils.IsOriginalDemo());
                                    }
                                    break block12;
                                }
                                case 2: {
                                    Console.out.println("noenemies enabled");
                                }
                            }
                            break block12;
                        }
                        Console.out.println("noenemies: out of range");
                    }
                    catch (Exception e) {
                        Console.out.println("noenemies: out of range");
                    }
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("playback", "playback \"filename.dem\""){

            @Override
            public CommandResponse execute(String[] argv) {
                if (Globals.pGameInfo.nGameType != 0 || Mmulti.numplayers > 1) {
                    Console.out.println("playback: Single player only");
                    return CommandResponse.SILENT_RESPONSE;
                }
                if (argv.length < 1) {
                    Console.out.println("playback \"demoname.dem\" [\"addon.ini\" or \"zipfile.zip:addon.ini\"]");
                    return CommandResponse.SILENT_RESPONSE;
                }
                String name = argv[0];
                Entry entry = Main.this.cache.getEntry(name, true);
                if (entry.exists()) {
                    BloodIniFile ini = null;
                    if (argv.length == 2) {
                        ini = ResourceHandler.levelGetEpisode(entry);
                    }
                    gDemoScreen.showDemo(entry, ini);
                } else {
                    Console.out.println("\"" + name + "\" not found!");
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("quicksave", "quicksave: performs a quick save"){

            @Override
            public CommandResponse execute(String[] argv) {
                if (Globals.pGameInfo.nGameType != 0 || Mmulti.numplayers > 1) {
                    Console.out.println("quicksave: Single player only");
                    return CommandResponse.SILENT_RESPONSE;
                }
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    LOADSAVE.quicksave();
                } else {
                    Console.out.println("quicksave: not in a game");
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("quickload", "quickload: performs a quick load"){

            @Override
            public CommandResponse execute(String[] argv) {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    LOADSAVE.quickload();
                } else {
                    Console.out.println("quickload: not in a game");
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("spawndude", ""){

            @Override
            public CommandResponse execute(String[] argv) {
                block7: {
                    if (Globals.pGameInfo.nGameType != 0 || Mmulti.numplayers > 1) {
                        Console.out.println("spawndude: Single player only");
                        return CommandResponse.SILENT_RESPONSE;
                    }
                    if (argv.length != 1) {
                        Console.out.println("spawndude \"enemy type number\"");
                        return CommandResponse.SILENT_RESPONSE;
                    }
                    if (Main.this.isCurrentScreen(gGameScreen)) {
                        try {
                            int type = Integer.parseInt(argv[0]);
                            if (type > 200 && type < 256) {
                                Actor.actSpawnDude(Globals.gMe.pSprite, type, -1);
                                break block7;
                            }
                            Console.out.println("spawndude: type out of range");
                        }
                        catch (Exception e) {
                            Console.out.println("spawndude: type out of range");
                        }
                    } else {
                        Console.out.println("spawndude: not in a game");
                    }
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCallback("showcoords", "", a -> {
            BloodSprite spr = Globals.gMe.pSprite;
            if (spr != null) {
                Console.out.println("Player x: " + spr.getX());
                Console.out.println("Player y: " + spr.getY());
                Console.out.println("Player z: " + spr.getZ());
                Console.out.println("Player sect: " + spr.getSectnum());
            } else {
                Console.out.println("not in a game");
            }
            return CommandResponse.SILENT_RESPONSE;
        }));
        Console.out.registerCommand(new OsdCommand("maphack_angoff", ""){

            @Override
            public CommandResponse execute(String[] argv) {
                if (argv.length != 1) {
                    Console.out.println("maphack_angoff value");
                    return CommandResponse.SILENT_RESPONSE;
                }
                try {
                    int angoff = Integer.parseInt(argv[0]);
                    int nSprite = Main.this.getSprite();
                    if (nSprite != -1) {
                        if (!Main.this.currentDef.mapInfo.isLoaded()) {
                            Main.this.currentDef.mapInfo.load(new Maphack());
                        }
                        Main.this.currentDef.mapInfo.getSpriteInfo((int)nSprite).angoff = (short)angoff;
                        Console.out.println("sprite " + nSprite + " angoff " + angoff);
                    }
                }
                catch (Exception e) {
                    Console.out.println("type out of range");
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("maphack_notmd", ""){

            @Override
            public CommandResponse execute(String[] argv) {
                if (argv.length != 1) {
                    Console.out.println("maphack_notmd value");
                    return CommandResponse.SILENT_RESPONSE;
                }
                try {
                    int value = Integer.parseInt(argv[0]);
                    int nSprite = Main.this.getSprite();
                    if (nSprite != -1) {
                        if (!Main.this.currentDef.mapInfo.isLoaded()) {
                            Main.this.currentDef.mapInfo.load(new Maphack());
                        }
                        Main.this.currentDef.mapInfo.getSpriteInfo((int)nSprite).flags = value == 1 ? (short)(Main.this.currentDef.mapInfo.getSpriteInfo((int)nSprite).flags | 1) : (short)(Main.this.currentDef.mapInfo.getSpriteInfo((int)nSprite).flags & 0xFFFFFFFE);
                        Console.out.println("sprite " + nSprite + (value == 1 ? " notmd" : " notmd removed"));
                    }
                }
                catch (Exception e) {
                    Console.out.println("type out of range");
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("maphack_mdposxoff", ""){

            @Override
            public CommandResponse execute(String[] argv) {
                if (argv.length != 1) {
                    Console.out.println("maphack_mdposxoff value");
                    return CommandResponse.SILENT_RESPONSE;
                }
                try {
                    int angoff = Integer.parseInt(argv[0]);
                    int nSprite = Main.this.getSprite();
                    if (nSprite != -1) {
                        if (!Main.this.currentDef.mapInfo.isLoaded()) {
                            Main.this.currentDef.mapInfo.load(new Maphack());
                        }
                        Main.this.currentDef.mapInfo.getSpriteInfo((int)nSprite).xoff = angoff;
                        Console.out.println("sprite " + nSprite + " mdposxoff " + angoff);
                    }
                }
                catch (Exception e) {
                    Console.out.println("type out of range");
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("maphack_mdposyoff", ""){

            @Override
            public CommandResponse execute(String[] argv) {
                if (argv.length != 1) {
                    Console.out.println("maphack_mdposyoff value");
                    return CommandResponse.SILENT_RESPONSE;
                }
                try {
                    int angoff = Integer.parseInt(argv[0]);
                    int nSprite = Main.this.getSprite();
                    if (nSprite != -1) {
                        if (!Main.this.currentDef.mapInfo.isLoaded()) {
                            Main.this.currentDef.mapInfo.load(new Maphack());
                        }
                        Main.this.currentDef.mapInfo.getSpriteInfo((int)nSprite).yoff = angoff;
                        Console.out.println("sprite " + nSprite + " mdposyoff " + angoff);
                    }
                }
                catch (Exception e) {
                    Console.out.println("type out of range");
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("maphack_mdposzoff", ""){

            @Override
            public CommandResponse execute(String[] argv) {
                if (argv.length != 1) {
                    Console.out.println("maphack_mdposzoff value");
                    return CommandResponse.SILENT_RESPONSE;
                }
                try {
                    int angoff = Integer.parseInt(argv[0]);
                    int nSprite = Main.this.getSprite();
                    if (nSprite != -1) {
                        if (!Main.this.currentDef.mapInfo.isLoaded()) {
                            Main.this.currentDef.mapInfo.load(new Maphack());
                        }
                        Main.this.currentDef.mapInfo.getSpriteInfo((int)nSprite).zoff = angoff;
                        Console.out.println("sprite " + nSprite + " mdposzoff " + angoff);
                    }
                }
                catch (Exception e) {
                    Console.out.println("type out of range");
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("maphack_save", ""){

            @Override
            public CommandResponse execute(String[] argv) {
                if (!Main.this.currentDef.mapInfo.isLoaded()) {
                    Console.out.println("These is nothing to save");
                    return CommandResponse.SILENT_RESPONSE;
                }
                String name = "unknown";
                if (mUserFlag == UserFlag.UserMap && LEVELS.gUserMapInfo != null) {
                    name = LEVELS.gUserMapInfo.MapName.getName();
                }
                if (mUserFlag != UserFlag.UserMap && LEVELS.currentEpisode != null) {
                    name = "e" + (Globals.pGameInfo.nEpisode + 1) + "m" + (Globals.pGameInfo.nLevel + 1);
                }
                String filename = name + ".mhk";
                Path file = Main.this.getUserDirectory().getPath().resolve(filename);
                try (OutputStream os = Files.newOutputStream(file, new OpenOption[0]);){
                    String checksum = "crc32 " + Globals.pGameInfo.uMapCRC + "\r\n";
                    StreamUtils.writeString(os, checksum);
                    for (int i = 0; i < boardService.getSpriteCount(); ++i) {
                        String msg;
                        if (Main.this.currentDef.mapInfo.getSpriteInfo((int)i).angoff != 0) {
                            msg = "sprite " + i + " angoff " + Main.this.currentDef.mapInfo.getSpriteInfo((int)i).angoff + "\r\n";
                            StreamUtils.writeString(os, msg);
                        }
                        if (Main.this.currentDef.mapInfo.getSpriteInfo((int)i).xoff != 0) {
                            msg = "sprite " + i + " mdposxoff " + Main.this.currentDef.mapInfo.getSpriteInfo((int)i).xoff + "\r\n";
                            StreamUtils.writeString(os, msg);
                        }
                        if (Main.this.currentDef.mapInfo.getSpriteInfo((int)i).yoff != 0) {
                            msg = "sprite " + i + " mdposyoff " + Main.this.currentDef.mapInfo.getSpriteInfo((int)i).yoff + "\r\n";
                            StreamUtils.writeString(os, msg);
                        }
                        if (Main.this.currentDef.mapInfo.getSpriteInfo((int)i).zoff != 0) {
                            msg = "sprite " + i + " mdposzoff " + Main.this.currentDef.mapInfo.getSpriteInfo((int)i).zoff + "\r\n";
                            StreamUtils.writeString(os, msg);
                        }
                        if ((Main.this.currentDef.mapInfo.getSpriteInfo((int)i).flags & 1) == 0) continue;
                        msg = "sprite " + i + " notmd\r\n";
                        StreamUtils.writeString(os, msg);
                    }
                    Console.out.println("Saved to " + file);
                }
                catch (IOException e) {
                    Console.out.println(filename + " is not saved. " + e, OsdColor.RED);
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCommand("maphack_load", ""){

            @Override
            public CommandResponse execute(String[] argv) {
                if (argv.length != 1) {
                    Console.out.println("maphack_load filename");
                    return CommandResponse.SILENT_RESPONSE;
                }
                String filename = argv[0];
                Entry entry = Main.this.cache.getEntry(filename, true);
                if (entry.exists()) {
                    Maphack map = new Maphack(entry);
                    if (map.getMapCRC() == Globals.pGameInfo.uMapCRC) {
                        Main.this.currentDef.mapInfo.load(map);
                        Console.out.println("Maphack is loaded");
                    } else {
                        Console.out.println("Maphack isn't loaded. Wrong checksum");
                    }
                } else {
                    Console.out.println("maphack_load: file not found");
                }
                return CommandResponse.SILENT_RESPONSE;
            }
        });
        Console.out.registerCommand(new OsdCallback("maphack_highlight", "", a -> {
            Globals.maphack_highlight = !Globals.maphack_highlight;
            Console.out.println("Maphack highlight is " + (Globals.maphack_highlight ? "on" : "off"));
            return CommandResponse.SILENT_RESPONSE;
        }));
    }

    private void InitCutscenes() {
        Entry entry;
        Console.out.println("Initializing cutscenes");
        GrpFile group = new GrpFile("Cutscenes");
        String[] smknames = new String[]{"CutSceneA", "CutWavA", "CutSceneB", "CutWavB"};
        for (int i = 0; i < 6; ++i) {
            if (!Globals.MainINI.set("Episode" + (i + 1))) continue;
            for (String smkname : smknames) {
                String smkPath = Globals.MainINI.getKeyString(smkname);
                if (smkPath.isEmpty()) continue;
                try {
                    int index = smkPath.indexOf(":" + File.separator);
                    if (index != -1) {
                        smkPath = smkPath.substring(index + 2);
                    }
                    if (!(entry = this.cache.getEntry(FileUtils.getPath(smkPath, new String[0]), true)).exists()) continue;
                    group.addEntry(entry);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        LinkedHashSet<Group> groupList = new LinkedHashSet<Group>();
        if (!group.isEmpty()) {
            for (Entry fil : group.getEntries()) {
                groupList.add(fil.getParent());
            }
        }
        groupList.add(this.cache.getGameDirectory());
        block5: for (String smkname : smknames = new String[]{"logo.smk", "logo811m.wav", "gti.smk", "gti.wav"}) {
            for (Group gr : groupList) {
                entry = gr.getEntry(smkname);
                if (!entry.exists()) continue;
                group.addEntry(entry);
                continue block5;
            }
        }
        if (!group.isEmpty()) {
            this.cache.addGroup(group, CacheResourceMap.CachePriority.NORMAL);
        } else {
            Console.out.println("Cutscenes were not found", OsdColor.YELLOW);
        }
    }

    public int getSprite() {
        int dx = Trig.Cos(Globals.gMe.pSprite.getAng()) >> 16;
        int dy = Trig.Sin(Globals.gMe.pSprite.getAng()) >> 16;
        int dz = (int)Globals.gMe.horizOff;
        Gameutils.HitScan(Globals.gMe.pSprite, Globals.gMe.viewOffZ, dx, dy, dz, Engine.pHitInfo, -65488, 0);
        return Engine.pHitInfo.hitsprite;
    }

    public void resetState() {
        mUserFlag = UserFlag.None;
        LEVELS.currentEpisode = null;
        LOADSAVE.lastload = null;
        Globals.kFakeMultiplayer = false;
        if (ResourceHandler.usecustomarts || ResourceHandler.usecustomqavs) {
            ResourceHandler.resetEpisodeResources();
        }
        this.menu.mClose();
        this.menu.mOpen(this.menu.mMenus[0], -1);
    }

    public void EndGame() {
        this.changeScreen(gLogoScreen.setTile(2050).setCallback(this.rMenu));
    }

    public void Disconnect() {
        Actor.gPost.reset();
        this.changeScreen(gDisconnectScreen.setSkipping(this.rMenu));
    }

    @Override
    public void GameMessage(String errorText) {
        Globals.pGameInfo.uGameFlags = 2;
        Globals.pGameInfo.nLevel = 0;
        super.GameMessage(errorText);
    }

    @Override
    public void show() {
        if (!this.args.isEmpty()) {
            this.parseArgumentsCommon();
            String netmode = this.args.getOrDefault("-netmode", "");
            String players = this.args.getOrDefault("-players", "");
            this.args.clear();
            if (!netmode.isEmpty()) {
                Console.out.println("Starting multiplayer as " + netmode, OsdColor.YELLOW);
                if (netmode.equalsIgnoreCase("master")) {
                    String[] param = new String[]{"-n0:" + (players.isEmpty() ? Integer.valueOf(2) : players), "-p " + cfg.getPort()};
                    ((BLMenuMultiplayer)this.menu.mMenus[12]).getMenuCreate(this).createGame(0, false, param);
                    return;
                }
                if (netmode.equalsIgnoreCase("slave")) {
                    String[] param = new String[]{"-n0", cfg.getmAddress(), "-p " + cfg.getPort()};
                    ((BLMenuMultiplayer)this.menu.mMenus[12]).getMenuJoin(this).joinGame(param);
                    return;
                }
            }
        }
        this.gPaused = false;
        gLogoScreen.setTile(2050).setCallback(this.nextLogo).setSkipping(this.rMenu);
        gCutsceneScreen.setCallback(this.nextLogo).setSkipping(this.rMenu).escSkipping(false);
        if (Main.cfg.showCutscenes && gCutsceneScreen.init("logo.smk", "logo811m.wav")) {
            this.changeScreen(gCutsceneScreen);
        } else {
            this.changeScreen(gLogoScreen);
        }
    }

    @Override
    public DefaultPrecacheScreen getPrecacheScreen(Runnable readyCallback, PrecacheListener listener) {
        return new PrecacheScreen(readyCallback, listener);
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        View.viewResizeView(Main.cfg.gViewSize);
    }

    @Override
    public LogSender getLogSender() {
        return new LogSender(this){

            @Override
            public byte[] reportData() {
                byte[] out;
                String text = "Mapname: " + Globals.boardfilename + "\r\n";
                text = text + "MapEntry: " + Globals.pGameInfo.getMapName() + "\r\n";
                text = text + "UserFlag: " + (Object)((Object)mUserFlag) + "\r\n";
                if (mUserFlag != UserFlag.UserMap && LEVELS.currentEpisode != null) {
                    EpisodeInfo currentEpisode = LEVELS.currentEpisode;
                    text = text + "Episode filename: " + currentEpisode.iniFile;
                    text = text + "\r\n";
                    text = text + "Episode title: " + currentEpisode.Title;
                    text = text + "\r\n";
                }
                text = text + "nDifficulty: " + Globals.pGameInfo.nDifficulty;
                text = text + "\r\n";
                if (Globals.gMe != null && Globals.gMe.pSprite != null) {
                    text = text + "PlayerX: " + Globals.gMe.pSprite.getX();
                    text = text + "\r\n";
                    text = text + "PlayerY: " + Globals.gMe.pSprite.getY();
                    text = text + "\r\n";
                    text = text + "PlayerZ: " + Globals.gMe.pSprite.getZ();
                    text = text + "\r\n";
                    text = text + "PlayerAng: " + Globals.gMe.pSprite.getAng();
                    text = text + "\r\n";
                    text = text + "PlayerHoriz: " + Globals.gMe.horiz;
                    text = text + "\r\n";
                    text = text + "PlayerSect: " + Globals.gMe.pSprite.getSectnum();
                    text = text + "\r\n";
                }
                if (mUserFlag == UserFlag.UserMap && LEVELS.gUserMapInfo != null && LEVELS.gUserMapInfo.MapName != null) {
                    ByteArray array = new ByteArray();
                    byte[] data = LEVELS.gUserMapInfo.MapName.getBytes();
                    text = text + "\r\n<------Start Map data------->\r\n";
                    array.addAll(text.getBytes());
                    array.addAll(data);
                    array.addAll("\r\n<------End Map data------->\r\n".getBytes());
                    out = Arrays.copyOf(array.items, array.size);
                } else {
                    out = text.getBytes();
                }
                return out;
            }
        };
    }

    public String getFilename(String path) {
        if (path != null) {
            path = FileUtils.getPath(path, new String[0]).getFileName().toString();
        }
        return path;
    }

    static {
        mUserFlag = UserFlag.None;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ru/m210projects/Blood/Main", "getRenderer"));
    }

    public static enum UserFlag {
        None,
        UserMap,
        Addon;

    }
}

