/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Menus;

import java.io.ByteArrayOutputStream;
import java.util.Objects;
import java.util.StringJoiner;
import ru.m210projects.Blood.Factory.BloodMenuHandler;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Menus.BLUserContent;
import ru.m210projects.Blood.Types.EpisodeInfo;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.filehandlers.BloodIniFile;
import ru.m210projects.Blood.filehandlers.EpisodeEntry;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.MenuSwitch;
import ru.m210projects.Build.Pattern.MenuItems.MenuTextField;
import ru.m210projects.Build.Pattern.MenuItems.MenuTitle;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class MenuNetwork
extends BuildMenu {
    private final short[] mFfireShift = new short[]{0, 32, 64, 128, 256};
    private final EpisodeInfo[] netEpisodeInfo = new EpisodeInfo[6];
    private final Main app;
    private final MenuProc mLevelsUpdate;
    private final MenuConteiner mMenuLevel;
    private final MenuConteiner mMenuEpisode;
    private int mGameType = 1;
    private int mEpisodeId = 0;
    private int mLevelId = 0;
    private int mDifficulty = 2;
    private int mMonsters = 0;
    private int mWeapons = 1;
    private int mItems = 1;
    private short mFFire = 0;
    private boolean mRevive = true;
    private int mFragLimit = 0;
    private Object currentFile;
    private int mTeam = 0;
    private String mContent = "";

    public MenuNetwork(final Main app) {
        super(app.menu);
        this.app = app;
        BloodMenuHandler menu = app.menu;
        this.addItem(new MenuTitle(app.pEngine, "NETWORK GAME", app.getFont(1), 160, 20, 2038), false);
        MenuConteiner mMenuGame = new MenuConteiner("GAME", app.getFont(1), 20, 35, 280, null, 0, (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            this.mGameType = item.num;
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[3][];
                    this.list[0] = "Cooperative".toCharArray();
                    this.list[1] = "Bloodbath".toCharArray();
                    this.list[2] = "Teams".toCharArray();
                }
                this.num = MenuNetwork.this.mGameType = Globals.pNetInfo.nGameType - 1;
            }
        };
        for (int i = 0; i < 6; ++i) {
            this.netEpisodeInfo[i] = new EpisodeInfo();
        }
        this.mLevelsUpdate = (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            EpisodeInfo pEpisode = this.netEpisodeInfo[this.mEpisodeId];
            if (item.list == null || item.list.length != pEpisode.nMaps) {
                item.list = new char[pEpisode.nMaps][];
            }
            for (int i = 0; i < pEpisode.nMaps; ++i) {
                if (pEpisode.gMapInfo[i].Title == null) continue;
                item.list[i] = pEpisode.gMapInfo[i].Title.toCharArray();
            }
            item.num = 0;
            this.mLevelId = 0;
        };
        this.mMenuLevel = new MenuConteiner("LEVEL", app.getFont(3), 20, 80, 280, null, 0, (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            this.mLevelId = item.num;
        }){

            @Override
            public void open() {
                this.num = MenuNetwork.this.mLevelId;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.currentFile instanceof BloodIniFile);
                this.text = ("LEVEL " + (MenuNetwork.this.mLevelId + 1)).toCharArray();
                super.draw(handler);
            }
        };
        this.mMenuEpisode = new MenuConteiner("EPISODE", app.getFont(3), 20, 70, 280, null, 0, (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            this.mEpisodeId = item.num;
            this.mLevelsUpdate.run(menu, this.mMenuLevel);
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[LEVELS.nEpisodeCount][];
                    for (int i = 0; i < LEVELS.nEpisodeCount; ++i) {
                        EpisodeInfo pEpisode = MenuNetwork.this.netEpisodeInfo[i];
                        if (pEpisode.Title == null) continue;
                        this.list[i] = pEpisode.Title.toCharArray();
                    }
                }
                this.num = MenuNetwork.this.mEpisodeId;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.currentFile instanceof BloodIniFile);
                this.text = ("EPISODE " + (MenuNetwork.this.mEpisodeId + 1)).toCharArray();
                super.draw(handler);
            }
        };
        MenuConteiner mContentItem = new MenuConteiner(this, "Content", app.getFont(1), 20, 50, 280, new String[]{""}, 0, (handler, pItem) -> {
            BLUserContent usercont = (BLUserContent)menu.mMenus[16];
            if (!usercont.showmain) {
                usercont.setShowMain(true);
            }
            handler.mOpen(usercont, -1);
        }){
            final /* synthetic */ MenuNetwork this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
            }

            @Override
            public void open() {
                if (!app.isCurrentScreen(Main.gGameScreen)) {
                    this.this$0.setEpisode(Globals.MainINI);
                }
            }

            @Override
            public void draw(MenuHandler handler) {
                this.list[0] = this.this$0.mContent.toCharArray();
                super.draw(handler);
            }
        };
        int pos = 80;
        MenuConteiner mMenuDifficulty = new MenuConteiner("DIFFICULTY", app.getFont(3), 20, pos += 10, 280, null, 0, (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            this.mDifficulty = item.num;
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[5][];
                    this.list[0] = "STILL KICKING".toCharArray();
                    this.list[1] = "PINK ON THE INSIDE".toCharArray();
                    this.list[2] = "LIGHTLY BROILED".toCharArray();
                    this.list[3] = "WELL DONE".toCharArray();
                    this.list[4] = "EXTRA CRISPY".toCharArray();
                }
                this.num = MenuNetwork.this.mDifficulty;
            }
        };
        MenuConteiner mMenuMonsters = new MenuConteiner("MONSTERS", app.getFont(3), 20, pos += 10, 280, null, 0, (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            this.mMonsters = item.num;
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[3][];
                    this.list[0] = "None".toCharArray();
                    this.list[1] = "Bring'em on".toCharArray();
                    this.list[2] = "Respawn".toCharArray();
                }
                this.num = MenuNetwork.this.mMonsters;
            }
        };
        MenuConteiner mMenuWeapons = new MenuConteiner("WEAPONS", app.getFont(3), 20, pos += 10, 280, null, 0, (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            this.mWeapons = item.num;
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[4][];
                    this.list[0] = "Do not respawn".toCharArray();
                    this.list[1] = "Are permanent".toCharArray();
                    this.list[2] = "Respawn".toCharArray();
                    this.list[3] = "Respawn with markers".toCharArray();
                }
                this.num = MenuNetwork.this.mWeapons;
            }
        };
        MenuConteiner mMenuItems = new MenuConteiner("Items", app.getFont(3), 20, pos += 10, 280, null, 0, (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            this.mItems = item.num;
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[3][];
                    this.list[0] = "Do not respawn".toCharArray();
                    this.list[1] = "Respawn".toCharArray();
                    this.list[2] = "Respawn with markers".toCharArray();
                }
                this.num = MenuNetwork.this.mItems;
            }
        };
        MenuConteiner mMenuFFire = new MenuConteiner("Friendly Fire", app.getFont(3), 20, pos += 10, 280, null, 0, (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            this.mFFire = (short)item.num;
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[5][];
                    this.list[0] = "No damage".toCharArray();
                    this.list[1] = "1/8 damage".toCharArray();
                    this.list[2] = "1/4 damage".toCharArray();
                    this.list[3] = "1/2 damage".toCharArray();
                    this.list[4] = "Full damage".toCharArray();
                }
                this.num = MenuNetwork.this.mFFire;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.mGameType + 1 == 1 || MenuNetwork.this.mGameType + 1 == 3);
                super.draw(handler);
            }
        };
        MenuSwitch mMenuRevive = new MenuSwitch("Revive mode:", app.getFont(3), 20, pos += 10, 280, this.mRevive, (handler, pItem) -> {
            MenuSwitch sw = (MenuSwitch)pItem;
            this.mRevive = sw.value;
        }, "Yes", "No"){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.mGameType + 1 == 1);
                super.draw(handler);
            }
        };
        MenuConteiner mMenuTeam = new MenuConteiner("Team:", app.getFont(3), 20, pos += 10, 280, null, 0, (handler, pItem) -> {
            MenuConteiner item = (MenuConteiner)pItem;
            this.mTeam = (short)item.num;
            app.net.ChangeTeam(Mmulti.myconnectindex, this.mTeam);
        }){

            @Override
            public void open() {
                if (this.list == null) {
                    this.list = new char[3][];
                    this.list[0] = "Auto".toCharArray();
                    this.list[1] = "Blue".toCharArray();
                    this.list[2] = "Red".toCharArray();
                }
                this.num = MenuNetwork.this.mTeam;
            }

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.mGameType + 1 == 3);
                super.draw(handler);
            }
        };
        MenuTextField mLimit = new MenuTextField("Frag limit:", "" + this.mFragLimit, app.getFont(3), 20, pos += 10, 280, 2, (handler, pItem) -> {
            MenuTextField item = (MenuTextField)pItem;
            if (item.getText().length() < 8) {
                this.mFragLimit = Integer.parseInt(item.getText());
            } else {
                item.onCancel();
            }
        }){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(MenuNetwork.this.mGameType + 1 >= 2);
                super.draw(handler);
            }
        };
        MenuProc mNetStart = (handler, pItem) -> {
            Globals.pNetInfo.nGameType = this.mGameType + 1;
            Globals.pNetInfo.nEpisode = this.mEpisodeId;
            Globals.pNetInfo.nLevel = this.mLevelId;
            Globals.pNetInfo.nDifficulty = this.mDifficulty;
            Globals.pNetInfo.nMonsterSettings = this.mMonsters;
            Globals.pNetInfo.nWeaponSettings = this.mWeapons;
            Globals.pNetInfo.nItemSettings = this.mItems;
            Globals.pNetInfo.nFriendlyFire = this.mFfireShift[this.mFFire];
            Globals.pNetInfo.nReviveMode = this.mRevive;
            Globals.pNetInfo.nFragLimit = this.mFragLimit;
            System.err.println("nNetType " + Globals.pNetInfo.nGameType);
            System.err.println("nNetDifficulty " + Globals.pNetInfo.nDifficulty);
            System.err.println("nNetMonsters " + Globals.pNetInfo.nMonsterSettings);
            System.err.println("nNetWeapons " + Globals.pNetInfo.nWeaponSettings);
            System.err.println("nNetItems " + Globals.pNetInfo.nItemSettings);
            System.err.println("nNetFFire " + Globals.pNetInfo.nFriendlyFire);
            System.err.println("nNetRevive " + Globals.pNetInfo.nReviveMode);
            System.err.println("nNetFragLimit " + Globals.pNetInfo.nFragLimit);
            if (Mmulti.numplayers >= 2) {
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    StreamUtils.writeByte(os, -4);
                    StreamUtils.writeInt(os, Mmulti.myconnectindex);
                    Objects.requireNonNull(app.net);
                    StreamUtils.writeInt(os, 534L);
                    StreamUtils.writeByte(os, VERSION.GAMEVER);
                    Globals.pNetInfo.writeObject(os);
                    short i = Mmulti.connecthead;
                    while (i >= 0) {
                        if (i != Mmulti.myconnectindex) {
                            byte[] packet = os.toByteArray();
                            Mmulti.sendpacket(i, packet, packet.length);
                        }
                        if (Mmulti.myconnectindex != Mmulti.connecthead) {
                            break;
                        }
                        i = Mmulti.connectpoint2[i];
                    }
                }
                catch (Exception e) {
                    Console.out.println(e.toString(), OsdColor.RED);
                }
            }
            if (app.net.WaitForAllPlayers(0)) {
                Main.gGameScreen.newgame(true, this.currentFile, this.mEpisodeId, this.mLevelId, this.mDifficulty, this.mDifficulty, this.mDifficulty, false);
            }
        };
        MenuButton mStart = new MenuButton("START GAME", app.getFont(1), 20, pos + 15, 280, 0, 0, null, -1, mNetStart, 0){

            @Override
            public void draw(MenuHandler handler) {
                this.mCheckEnableItem(Mmulti.myconnectindex == Mmulti.connecthead && MenuNetwork.this.currentFile != null);
                super.draw(handler);
            }
        };
        mStart.fontShadow = true;
        this.addItem(mMenuGame, true);
        this.addItem(mContentItem, false);
        this.addItem(this.mMenuEpisode, false);
        this.addItem(this.mMenuLevel, false);
        this.addItem(mMenuDifficulty, false);
        this.addItem(mMenuMonsters, false);
        this.addItem(mMenuWeapons, false);
        this.addItem(mMenuItems, false);
        this.addItem(mMenuFFire, false);
        this.addItem(mMenuRevive, false);
        this.addItem(mMenuTeam, false);
        this.addItem(mLimit, false);
        this.addItem(mStart, false);
        this.addItem(menu.addMenuBlood(), false);
    }

    public Object getFile() {
        return this.currentFile;
    }

    public void setEpisode(BloodIniFile ini) {
        if (ini == null || this.currentFile == ini) {
            return;
        }
        if (Mmulti.myconnectindex == Mmulti.connecthead && !this.app.net.WaitForContentCheck(this.getEpisodeContentData(ini.getEpisodeEntry()), 0)) {
            StringJoiner players = new StringJoiner(", ");
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.app.net.gContentFound[i] == 0) {
                    players.add(this.app.net.getPlayerName(i));
                }
                i = Mmulti.connectpoint2[i];
            }
            Console.out.println(players + " haven't " + ini.getName(), OsdColor.RED);
            if (!Console.out.isShowing()) {
                Console.out.onToggle();
            }
            this.currentFile = null;
            return;
        }
        this.currentFile = ini;
        this.mContent = ini.getName();
        this.mEpisodeId = 0;
        this.mMenuEpisode.num = 0;
        int nEpisodes = LEVELS.getEpisodeInfo(this.netEpisodeInfo, ini);
        this.mLevelsUpdate.run(this.app.pMenu, this.mMenuLevel);
        if (this.mMenuEpisode.list == null || this.mMenuEpisode.list.length != nEpisodes) {
            this.mMenuEpisode.list = new char[nEpisodes][];
        }
        for (int i = 0; i < nEpisodes; ++i) {
            EpisodeInfo pEpisode = this.netEpisodeInfo[i];
            if (pEpisode.Title == null) continue;
            this.mMenuEpisode.list[i] = pEpisode.Title.toCharArray();
        }
    }

    public void setMap(FileEntry map) {
        if (map == null || this.currentFile == map) {
            return;
        }
        if (Mmulti.myconnectindex == Mmulti.connecthead && !this.app.net.WaitForContentCheck(this.getUserMapContentData(map), 0)) {
            StringBuilder msg = new StringBuilder();
            short i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.app.net.gContentFound[i] == 0) {
                    msg.append(this.app.net.getPlayerName(i)).append(", ");
                }
                i = Mmulti.connectpoint2[i];
            }
            msg = new StringBuilder(msg.substring(0, msg.length() - 2));
            msg.append(" haven't ").append(map.getName());
            Console.out.println(msg.toString(), OsdColor.RED);
            if (!Console.out.isShowing()) {
                Console.out.onToggle();
            }
            this.currentFile = null;
            return;
        }
        this.currentFile = map;
        this.mContent = map.getName();
        if (this.mMenuEpisode.list != null) {
            this.mMenuEpisode.list[0] = "None".toCharArray();
        }
        this.mMenuEpisode.num = 0;
        this.mEpisodeId = 0;
        if (this.mMenuLevel.list != null) {
            this.mMenuLevel.list[0] = "Usermap".toCharArray();
        }
        this.mMenuLevel.num = 0;
        this.mLevelId = 0;
    }

    private byte[] getEpisodeContentData(EpisodeEntry episodeEntry) {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            StreamUtils.writeBoolean(os, true);
            StreamUtils.writeDataString(os, episodeEntry.getFileEntry().getRelativePath().toString());
            StreamUtils.writeLong(os, Mmulti.numplayers > 1 ? episodeEntry.getFileEntry().getChecksum() : 0L);
            boolean isPacked = episodeEntry.isPackageEpisode();
            StreamUtils.writeBoolean(os, isPacked);
            if (isPacked) {
                StreamUtils.writeDataString(os, episodeEntry.getIniFile().getName());
            }
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
                return new byte[0];
            }
        }
        os.close();
        return byArray;
    }

    private byte[] getUserMapContentData(FileEntry entry) {
        byte[] byArray;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            StreamUtils.writeBoolean(os, false);
            StreamUtils.writeDataString(os, entry.getRelativePath().toString());
            StreamUtils.writeLong(os, Mmulti.numplayers > 1 ? entry.getChecksum() : 0L);
            byArray = os.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Console.out.println(e.toString(), OsdColor.RED);
                return new byte[0];
            }
        }
        os.close();
        return byArray;
    }
}

