/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Menus;

import java.io.InputStream;
import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.QAV;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.filehandle.Entry;

public class MenuQav
extends MenuItem {
    public String qFileName;
    public int qFileId;
    public QAV pQAV;
    public int duration;
    public int qGameClock;
    public boolean clearScreen;

    public MenuQav(int x, int y, int qFileId) {
        super(null, null);
        this.flags = 1;
        this.m_pMenu = null;
        this.width = 0;
        this.x = x;
        this.y = y;
        this.qFileId = qFileId;
        this.qFileName = null;
        this.clearScreen = false;
    }

    public MenuQav(int x, int y, String qFileName) {
        super(null, null);
        this.flags = 1;
        this.m_pMenu = null;
        this.width = 0;
        this.x = x;
        this.y = y;
        this.qFileName = qFileName;
        this.qFileId = -1;
        this.clearScreen = false;
    }

    @Override
    public void draw(MenuHandler handler) {
        if (this.pQAV != null) {
            BloodRenderer renderer = Main.game.getRenderer();
            if (this.clearScreen) {
                renderer.clearview(0);
            }
            int oldFrameClock = Globals.gFrameClock;
            Globals.gFrameClock = Main.engine.getTotalClock();
            int ticks = Main.engine.getTotalClock() - this.qGameClock;
            this.qGameClock = Main.engine.getTotalClock();
            this.duration -= ticks;
            if (this.duration <= 0 || this.duration > this.pQAV.duration) {
                this.duration = this.pQAV.duration;
            }
            int t = this.pQAV.duration - this.duration;
            this.pQAV.Play(t - ticks, t, -1, null);
            this.pQAV.Draw(t, 0, 10, 0, 65536);
            Globals.gFrameClock = oldFrameClock;
        }
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case LEFT: 
            case BSPACE: {
                this.m_pMenu.mNavUp();
                return false;
            }
            case RIGHT: 
            case ENTER: 
            case SPACE: {
                this.m_pMenu.mNavDown();
                return false;
            }
            case UP: 
            case DW: 
            case ESC: {
                return this.m_pMenu.mNavigation(opt);
            }
        }
        return false;
    }

    @Override
    public void open() {
        if (this.qFileName == null && this.qFileId == -1) {
            return;
        }
        if (this.pQAV != null) {
            this.duration = this.pQAV.duration;
            this.qGameClock = Main.engine.getTotalClock();
            return;
        }
        Entry hQAV = this.qFileName != null ? Main.game.getCache().getEntry(this.qFileName, true) : Main.game.getCache().getEntry(this.qFileId, "qav");
        if (!hQAV.exists()) {
            System.err.println("Could not load QAV " + this.qFileName);
            return;
        }
        try (InputStream is = hQAV.getInputStream();){
            this.pQAV = new QAV(is);
            this.pQAV.origin.x = this.x;
            this.pQAV.origin.y = this.y;
            this.duration = this.pQAV.duration;
            this.qGameClock = Main.engine.getTotalClock();
        }
        catch (Exception e) {
            System.err.println("Could not load QAV " + this.qFileName + ": " + e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public boolean mouseAction(int x, int y) {
        return false;
    }
}

