/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.math.Vector3;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Factory.BloodNetwork;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Gib;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LOADSAVE;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.QAV;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.AMMOINFO;
import ru.m210projects.Blood.Types.AMMOITEMDATA;
import ru.m210projects.Blood.Types.ARMORITEMDATA;
import ru.m210projects.Blood.Types.CALLPROC;
import ru.m210projects.Blood.Types.DAMAGEINFO;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.FragInfo;
import ru.m210projects.Blood.Types.INPUT;
import ru.m210projects.Blood.Types.INVITEM;
import ru.m210projects.Blood.Types.PLOCATION;
import ru.m210projects.Blood.Types.POSTURE;
import ru.m210projects.Blood.Types.QUOTE;
import ru.m210projects.Blood.Types.ScreenEffect;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.Types.Seq.SeqInst;
import ru.m210projects.Blood.Types.WEAPONITEMDATA;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Blood.Types.ZONE;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Warp;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Serializable;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Wall;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.net.Mmulti;

public class PLAYER
implements Serializable<PLAYER> {
    public static final String deathMessage = "Press \"USE\" to load last saved game or press \"ENTER\" to restart level";
    public static final int kInventoryDoctorBag = 0;
    public static final int kInventoryDivingSuit = 1;
    public static final int kInventoryCrystalBall = 2;
    public static final int kInventoryBeastVision = 3;
    public static final int kInventoryJumpBoots = 4;
    public static final int kInventoryJetpack = 5;
    public static final int BLUEARMOR = 0;
    public static final int REDARMOR = 1;
    public static final int GREENARMOR = 2;
    public static final int kOrderMax = 2;
    public static final int kWeaponNone = 0;
    public static final int kWeaponPitchfork = 1;
    public static final int kWeaponFlare = 2;
    public static final int kWeaponShotgun = 3;
    public static final int kWeaponTommy = 4;
    public static final int kWeaponNapalm = 5;
    public static final int kWeaponTNT = 6;
    public static final int kWeaponSprayCan = 7;
    public static final int kWeaponTesla = 8;
    public static final int kWeaponVoodoo = 10;
    public static final int kWeaponLifeLeach = 9;
    public static final int kWeaponProxyTNT = 11;
    public static final int kWeaponRemoteTNT = 12;
    public static final int kWeaponBeast = 13;
    public static final int kWeaponMax = 14;
    public static final int kAmmoNone = -1;
    public static final int kLookMax = 60;
    public static final int kHorizUpMax = 120;
    public static final int kHorizDownMax = 180;
    public static final int kHorizDefault = 90;
    public static final int newHorizDefault = 100;
    public static final int kMoveWalk = 0;
    public static final int kMoveSwim = 1;
    public static final int kMoveCrouch = 2;
    public static final int kMoveFly = 3;
    public static final int kModeHuman = 0;
    public static final int kModeBeast = 1;
    public static final int kModeHumanShrink = 2;
    public static final int kModeHumanGrown = 3;
    public static final int kTouchXYDist = 48;
    public static final int kTouchZDist = 32;
    public static final int kPushXYDist = 64;
    public static final int[] gLaughs = new int[]{734, 735, 736, 737, 738, 739, 740, 741, 3038, 3049};
    public static final int kInventoryMax = 6;
    public static final int kWaneTime = 512;
    public static final FragInfo[] deathAphorisms1 = new FragInfo[]{new FragInfo(4202, " is excrement", null), new FragInfo(4203, " is hamburger", null), new FragInfo(4204, " suffered scrotum separation", null), new FragInfo(4206, " volunteered for population control", null), new FragInfo(4207, " has suicided", null)};
    public static final FragInfo[] deathAphorisms2 = new FragInfo[]{new FragInfo(4100, " boned ", " like a fish"), new FragInfo(4101, " castrated ", null), new FragInfo(4102, " creamed ", null), new FragInfo(4103, " destroyed ", null), new FragInfo(4104, " diced ", null), new FragInfo(4105, " disemboweled ", null), new FragInfo(4106, " flattened ", null), new FragInfo(4107, " gave ", " Anal Justice"), new FragInfo(4108, " gave AnAl MaDnEsS to ", null), new FragInfo(4109, " hurt ", " real bad"), new FragInfo(4110, " killed ", null), new FragInfo(4111, " made mincemeat out of ", null), new FragInfo(4112, " massacred ", null), new FragInfo(4113, " mutilated ", null), new FragInfo(4114, " reamed ", null), new FragInfo(4115, " ripped ", " a new orifice"), new FragInfo(4116, " slaughtered ", null), new FragInfo(4117, " sliced ", null), new FragInfo(4118, " smashed ", null), new FragInfo(4119, " sodomized ", null), new FragInfo(4120, " splattered ", null), new FragInfo(4121, " squashed ", null), new FragInfo(4122, " throttled ", null), new FragInfo(4123, " wasted ", null), new FragInfo(4124, " body bagged ", null)};
    private static final boolean gInventorySwap = true;
    public static PLOCATION[] gPrevView = new PLOCATION[8];
    public static boolean newHoriz = true;
    public static QAV[] weaponQAVs = new QAV[126];
    public static AMMOINFO[] gAmmoInfo = new AMMOINFO[]{new AMMOINFO(0, 0, 255), new AMMOINFO(100, 0, 255), new AMMOINFO(100, 0, 4), new AMMOINFO(500, 0, 5), new AMMOINFO(100, 0, 255), new AMMOINFO(50, 0, 255), new AMMOINFO(2880, 0, 255), new AMMOINFO(250, 0, 255), new AMMOINFO(100, 0, 255), new AMMOINFO(100, 0, 255), new AMMOINFO(50, 0, 255), new AMMOINFO(50, 0, 255)};
    public static DAMAGEINFO[] gDamageInfo = new DAMAGEINFO[]{new DAMAGEINFO(-1, new int[]{731, 732, 733, 710, 710, 710}), new DAMAGEINFO(1, new int[]{742, 743, 744, 711, 711, 711}), new DAMAGEINFO(0, new int[]{731, 732, 733, 712, 712, 712}), new DAMAGEINFO(1, new int[]{731, 732, 733, 713, 713, 713}), new DAMAGEINFO(-1, new int[]{724, 724, 724, 714, 714, 714}), new DAMAGEINFO(2, new int[]{731, 732, 733, 715, 715, 715}), new DAMAGEINFO(0, new int[]{0, 0, 0, 0, 0, 0})};
    public static int timer = 0;
    private static int Action_nIndex = 0;
    private static int Action_nXIndex = -1;
    public BloodSprite pSprite;
    public XSPRITE pXsprite;
    public DudeInfo pDudeInfo;
    public INPUT pInput;
    public int NPSTART;
    public int pWeaponQAV;
    public int weaponCallback;
    public boolean Run;
    public int moveState;
    public int moveDist;
    public int bobPhase;
    public int bobAmp;
    public int bobHeight;
    public int bobWidth;
    public int swayPhase;
    public int swayAmp;
    public int swayHeight;
    public int swayWidth;
    public int nPlayer;
    public int nSprite;
    public int nLifeMode;
    public int bloodlust;
    public int weapOffdZ;
    public int viewOffdZ;
    public int weaponAboveZ;
    public int viewOffZ;
    public float look;
    public float horiz;
    public int slope;
    public float horizOff;
    public boolean Underwater;
    public boolean[] hasKey = new boolean[8];
    public int hasFlag;
    public short nBlueTeam;
    public short nRedTeam;
    public int[] damageShift = new int[7];
    public int CrouchMode;
    public int LastWeapon;
    public int currentWeapon;
    public int updateWeapon;
    public int weaponTimer;
    public int weaponState;
    public int weaponAmmo;
    public boolean[] hasWeapon = new boolean[14];
    public int[] weaponMode = new int[14];
    public int[][] weaponOrder = new int[2][14];
    public int[] ammoCount = new int[12];
    public boolean fLoopQAV;
    public int fuseTime;
    public int fireClock;
    public int throwTime;
    public Vector3 aim;
    public Vector3 relAim;
    public int nAimSprite;
    public int aimCount;
    public int[] aimSprites = new int[16];
    public int deathTime;
    public int[] powerUpTimer = new int[49];
    public int fragCount;
    public int[] fragInfo = new int[8];
    public int teamID;
    public int fraggerID;
    public int airTime;
    public int bloodTime;
    public int gooTime;
    public int wetTime;
    public int bubbleTime;
    public int kickTime;
    public int stayTime;
    public int pLaughsCount;
    public int TurnAround;
    public boolean godMode;
    public boolean fScreamed;
    public boolean pJump;
    public int showInventory;
    public int choosedInven;
    public INVITEM[] Inventory = new INVITEM[6];
    public int[] ArmorAmount = new int[3];
    public int explosion;
    public int tilt;
    public int visibility;
    public int fireEffect;
    public int hitEffect;
    public int blindEffect;
    public int drownEffect;
    public int handCount;
    public boolean handDamage;
    public int pickupEffect;
    public int quakeTime;
    public int lookang;
    public int rotscrnang;
    public float ang;
    int voodooTarget;
    int voodooCount;
    int voodooAng;
    int voodooUnk;
    private int nVersion = 277;

    public PLAYER() {
        this.aim = new Vector3();
        this.relAim = new Vector3();
        this.pInput = new INPUT();
        for (int i = 0; i < 6; ++i) {
            this.Inventory[i] = new INVITEM();
        }
    }

    public PLAYER setVersion(int nVersion) {
        this.nVersion = nVersion;
        return this;
    }

    public static boolean checkPlayerSeq(PLAYER pPlayer, int nSeqID) {
        short nXSprite = pPlayer.pSprite.getExtra();
        SeqInst pInst = SeqHandling.GetInstance(3, nXSprite);
        return pInst.getSeqIndex() == pPlayer.pDudeInfo.seqStartID + nSeqID && SeqHandling.seqFrame(3, nXSprite) >= 0;
    }

    public static void resetInventory(PLAYER pPlayer) {
        int i;
        if (pPlayer == null) {
            throw new AssertException("pPlayer != NULL");
        }
        for (i = 0; i < 14; ++i) {
            pPlayer.hasWeapon[i] = Globals.gInfiniteAmmo;
            pPlayer.weaponMode[i] = 0;
        }
        pPlayer.hasWeapon[1] = true;
        pPlayer.LastWeapon = 0;
        pPlayer.currentWeapon = 0;
        pPlayer.weaponCallback = -1;
        pPlayer.pInput.newWeapon = 1;
        for (i = 0; i < 14; ++i) {
            pPlayer.weaponOrder[0][i] = Weapon.defaultOrder[i];
            pPlayer.weaponOrder[1][i] = Weapon.defaultOrder[i];
        }
        for (i = 0; i < 12; ++i) {
            pPlayer.ammoCount[i] = Globals.gInfiniteAmmo ? PLAYER.gAmmoInfo[i].max : 0;
        }
        for (i = 0; i < 3; ++i) {
            pPlayer.ArmorAmount[i] = 0;
        }
        pPlayer.weaponTimer = 0;
        pPlayer.weaponState = 0;
        pPlayer.pWeaponQAV = -1;
        pPlayer.fLoopQAV = false;
        pPlayer.choosedInven = -1;
        for (i = 0; i < 6; ++i) {
            pPlayer.Inventory[i].activated = false;
            pPlayer.Inventory[i].amount = 0;
        }
        Globals.gInfiniteAmmo = false;
    }

    public static void playerInit(int nPlayer, boolean nInited) {
        PLAYER pPlayer = Globals.gPlayer[nPlayer];
        if (!nInited) {
            System.out.println("Initializing player " + nPlayer);
            pPlayer.reset();
        }
        pPlayer.nPlayer = nPlayer;
        pPlayer.teamID = nPlayer;
        pPlayer.CrouchMode = 0;
        if (Globals.pGameInfo.nGameType == 3) {
            pPlayer.teamID = Main.game.net.gProfile[nPlayer].team == 0 ? nPlayer & 1 : Main.game.net.gProfile[nPlayer].team - 1;
        }
        pPlayer.fragCount = 0;
        Arrays.fill(Globals.nTeamCount, 0);
        Arrays.fill(Globals.nTeamClock, 0);
        Arrays.fill(pPlayer.fragInfo, 0);
        if (!nInited) {
            PLAYER.resetInventory(pPlayer);
        }
    }

    public static void playerGodMode(PLAYER pPlayer, int mode) {
        if (mode == 1) {
            int i = 0;
            while (i < 7) {
                int n = i++;
                pPlayer.damageShift[n] = pPlayer.damageShift[n] + 1;
            }
        } else {
            int i = 0;
            while (i < 7) {
                int n = i++;
                pPlayer.damageShift[n] = pPlayer.damageShift[n] - 1;
            }
        }
        pPlayer.godMode = mode == 1;
    }

    public static void playerReset(int nPlayer) throws WarningException {
        int i;
        PLAYER pPlayer = Globals.gPlayer[nPlayer];
        ZONE pZone = null;
        if (Globals.pGameInfo.nGameType == 0 || Globals.pGameInfo.nGameType == 1) {
            pZone = Warp.gStartZone[nPlayer];
        } else if (Globals.pGameInfo.nGameType == 3 && Warp.gTeamsSpawnUsed) {
            int maxRetries = 5;
            while (maxRetries-- > 0) {
                pZone = pPlayer.teamID == 0 ? Warp.gStartZoneTeam1[Gameutils.Random(4)] : Warp.gStartZoneTeam2[Gameutils.Random(4)];
                if (maxRetries != 0) {
                    for (ListNode<Sprite> node = Main.boardService.getSectNode(pZone.sector); node != null; node = node.getNext()) {
                        Sprite pSprite = node.get();
                        if (pZone.x != pSprite.getX() || pZone.y != pSprite.getY() || !Gameutils.IsPlayerSprite(pSprite)) continue;
                        pZone = null;
                        break;
                    }
                }
                if (pZone == null) continue;
                break;
            }
        } else {
            pZone = Warp.gStartZone[Gameutils.Random(8)];
        }
        if (pZone.sector == -1) {
            throw new WarningException("The player should be inside a map sector");
        }
        int nSprite = Actor.actSpawnSprite(pZone.sector, pZone.x, pZone.y, pZone.z, 6, true);
        if (nSprite == -1) {
            throw new AssertException("The player should be inside a map");
        }
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        if (pXSprite == null) {
            throw new AssertException("pXSprite != null");
        }
        pPlayer.pSprite = pSprite;
        pPlayer.pXsprite = pXSprite;
        pPlayer.nSprite = nSprite;
        pPlayer.pDudeInfo = DudeInfo.dudeInfo[nPlayer + 31];
        PLAYER.playerSetRace(pPlayer, 0);
        SeqHandling.seqSpawn(pPlayer.pDudeInfo.seqStartID + 0, 3, pSprite.getExtra(), null);
        if (pPlayer == Globals.gMe) {
            Engine.show2dsprite.setBit(pSprite.getXvel());
        }
        Gameutils.GetSpriteExtents(pSprite);
        pPlayer.CrouchMode = 0;
        pPlayer.LastWeapon = 0;
        if (Globals.pGameInfo.nGameType == 3) {
            pPlayer.teamID = Main.game.net.gProfile[nPlayer].team == 0 ? nPlayer & 1 : Main.game.net.gProfile[nPlayer].team - 1;
        }
        pPlayer.pXsprite.setData1(0);
        pSprite.setZ(pSprite.getZ() - (Gameutils.extents_zBot - pSprite.getZ()));
        pSprite.setPal((byte)((pPlayer.teamID & 3) + 11));
        pSprite.setAng((short)(pZone.angle & 0x7FF));
        pPlayer.ang = pSprite.getAng();
        pSprite.setLotag((short)(nPlayer + 231));
        pSprite.setClipdist(pPlayer.pDudeInfo.clipdist);
        pSprite.setHitag(15);
        pXSprite.setBurnTime(0);
        pXSprite.setBurnSource(-1);
        pXSprite.setHealth(pPlayer.pDudeInfo.startHealth << 4);
        pPlayer.pSprite.setCstat(pPlayer.pSprite.getCstat() & Short.MAX_VALUE);
        pPlayer.bloodlust = 0;
        pPlayer.horiz = 0.0f;
        pPlayer.slope = 0;
        pPlayer.look = 0.0f;
        pPlayer.horizOff = 0.0f;
        pPlayer.fraggerID = -1;
        pPlayer.airTime = 1200;
        pPlayer.bloodTime = 0;
        pPlayer.gooTime = 0;
        pPlayer.wetTime = 0;
        pPlayer.bubbleTime = 0;
        pPlayer.stayTime = 0;
        pPlayer.kickTime = 0;
        pPlayer.pLaughsCount = 0;
        pPlayer.TurnAround = 0;
        pPlayer.moveState = 0;
        pPlayer.voodooTarget = -1;
        pPlayer.voodooCount = 0;
        pPlayer.voodooAng = 0;
        pPlayer.voodooUnk = 0;
        View.viewUpdatePlayerLoc(pPlayer);
        pPlayer.weapOffdZ = 0;
        pPlayer.relAim.x = 16384.0f;
        pPlayer.relAim.y = 0.0f;
        pPlayer.relAim.z = 0.0f;
        pPlayer.nAimSprite = -1;
        pPlayer.viewOffdZ = pPlayer.weapOffdZ;
        if (Globals.pGameInfo.nGameType != 1) {
            for (i = 0; i < 8; ++i) {
                pPlayer.hasKey[i] = Globals.pGameInfo.nGameType >= 2;
            }
        }
        pPlayer.hasFlag = 0;
        pPlayer.nBlueTeam = 0;
        pPlayer.nRedTeam = 0;
        for (i = 0; i < 7; ++i) {
            pPlayer.damageShift[i] = 0;
        }
        if (pPlayer.godMode) {
            PLAYER.playerGodMode(pPlayer, 1);
        }
        for (i = 0; i < 6; ++i) {
            pPlayer.Inventory[i].activated = false;
        }
        Globals.gFullMap = false;
        pPlayer.throwTime = 0;
        pPlayer.deathTime = 0;
        pPlayer.updateWeapon = 0;
        pSprite.setVelocity(0L, 0L, 0L);
        pPlayer.pInput.Turn = 0.0f;
        pPlayer.pInput.Jump = false;
        pPlayer.pInput.Crouch = false;
        pPlayer.pInput.Shoot = false;
        pPlayer.pInput.AltShoot = false;
        pPlayer.pInput.Lookup = false;
        pPlayer.pInput.Lookdown = false;
        pPlayer.pInput.TurnAround = false;
        pPlayer.pInput.Use = false;
        pPlayer.pInput.InventoryLeft = false;
        pPlayer.pInput.InventoryRight = false;
        pPlayer.pInput.InventoryUse = false;
        pPlayer.pInput.PrevWeapon = false;
        pPlayer.pInput.NextWeapon = false;
        pPlayer.pInput.HolsterWeapon = false;
        pPlayer.pInput.LookCenter = false;
        pPlayer.pInput.Pause = false;
        pPlayer.pInput.Quit = false;
        pPlayer.pInput.Restart = false;
        pPlayer.pInput.Forward = 0;
        pPlayer.pInput.Strafe = 0;
        pPlayer.pInput.mlook = 0.0f;
        pPlayer.explosion = 0;
        pPlayer.quakeTime = 0;
        pPlayer.tilt = 0;
        pPlayer.visibility = 0;
        pPlayer.hitEffect = 0;
        pPlayer.blindEffect = 0;
        pPlayer.drownEffect = 0;
        pPlayer.handCount = 0;
        pPlayer.weaponTimer = 0;
        pPlayer.weaponState = 0;
        pPlayer.pWeaponQAV = -1;
        pPlayer.handDamage = false;
        ScreenEffect.resetDacEffects();
        pPlayer.lookang = 0;
        pPlayer.rotscrnang = 0;
        Arrays.fill(pPlayer.powerUpTimer, 0);
        PLAYER.resetPlayerSize(pPlayer);
        if (pPlayer == Globals.gMe) {
            ((BloodNetwork)Main.game.pNet).PredictReset();
        }
        if (Actor.IsUnderwaterSector(pSprite.getSectnum())) {
            pPlayer.moveState = 1;
            pPlayer.pXsprite.setPalette(1);
        }
    }

    public static void playerSetRace(PLAYER pPlayer, int nLifeMode) {
        if (nLifeMode < 0 || nLifeMode > 3) {
            throw new AssertException("nLifeMode >= kModeHuman && nLifeMode <= kModeHumanGrown");
        }
        pPlayer.nLifeMode = nLifeMode;
        pPlayer.pDudeInfo.copy(DudeInfo.gPlayerTemplate[nLifeMode]);
        for (int i = 0; i < 7; ++i) {
            pPlayer.pDudeInfo.damageShift[i] = Pragmas.mulscale(pPlayer.pDudeInfo.startDamage[i], Actor.pPlayerShift[Globals.pGameInfo.nDifficulty], 8);
        }
    }

    public static boolean PickupLeech(PLAYER pPlayer, Sprite pSprite) {
        for (ListNode<Sprite> node = Main.boardService.getStatNode(4); node != null; node = node.getNext()) {
            Sprite pThing;
            if (pSprite != null && pSprite.getXvel() == node.getIndex() || (pThing = node.get()).getLotag() != 431 || Actor.actGetBurnSource(pThing.getOwner()) != pPlayer.nSprite) continue;
            return true;
        }
        return false;
    }

    public static int ActionScan(PLAYER pPlayer) {
        BloodSprite pPlayerSprite = pPlayer.pSprite;
        Action_nIndex = 0;
        Action_nXIndex = -1;
        int dx = Trig.Cos(pPlayerSprite.getAng()) >> 16;
        int dy = Trig.Sin(pPlayerSprite.getAng()) >> 16;
        int dz = (int)pPlayer.horizOff;
        int hitType = Gameutils.HitScan(pPlayerSprite, pPlayer.viewOffZ, dx, dy, dz, Engine.pHitInfo, 0x10000040, 128);
        int hitDist = EngineUtils.qdist(pPlayerSprite.getX() - Engine.pHitInfo.hitx, pPlayerSprite.getY() - Engine.pHitInfo.hity) >> 4;
        if (hitDist < 64) {
            switch (hitType) {
                case 3: {
                    int mass;
                    Action_nIndex = Engine.pHitInfo.hitsprite;
                    BloodSprite pSprite = Main.boardService.getSprite(Action_nIndex);
                    Action_nXIndex = pSprite.getExtra();
                    XSPRITE pXSprite = Main.boardService.getXSprite(Action_nXIndex);
                    if (pXSprite != null && pSprite.getStatnum() == 4 && pSprite.getLotag() == 431) {
                        if (Globals.pGameInfo.nGameType > 1 && PLAYER.PickupLeech(pPlayer, pSprite)) {
                            return -1;
                        }
                        pXSprite.setData4(pPlayer.nPlayer);
                        pXSprite.setTriggered(false);
                    }
                    if (pXSprite != null && pXSprite.isPush()) {
                        return 3;
                    }
                    if (pSprite.getStatnum() != 6) break;
                    if (Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1 && Gameutils.IsPlayerSprite(pSprite)) {
                        PLAYER pReviving = Globals.gPlayer[pSprite.getLotag() - 231];
                        if (pReviving.deathTime > 0) {
                            SeqHandling.seqSpawn(pReviving.pDudeInfo.seqStartID + VERSION.getPlayerSeq(9), 3, pReviving.pSprite.getExtra(), SeqHandling.callbacks[1]);
                            break;
                        }
                    }
                    if ((mass = DudeInfo.dudeInfo[pSprite.getLotag() - 200].mass) > 0) {
                        int impulse = 0xCCCCC00 / mass;
                        pSprite.addVelocity(Pragmas.mulscale(impulse, dx, 16), Pragmas.mulscale(impulse, dy, 16), Pragmas.mulscale(impulse, dz, 16));
                    }
                    if (pXSprite == null || !pXSprite.isPush() || pXSprite.getState() != 0 || pXSprite.isTriggered()) break;
                    Trigger.trTriggerSprite(Action_nIndex, pXSprite, 30);
                    break;
                }
                case 0: 
                case 4: {
                    Action_nIndex = Engine.pHitInfo.hitwall;
                    Wall pWall = Main.boardService.getWall(Action_nIndex);
                    Action_nXIndex = pWall.getExtra();
                    if (Action_nXIndex >= 0 && DB.xwall[PLAYER.Action_nXIndex].triggerPush) {
                        return 0;
                    }
                    if (pWall.getNextsector() < 0 || (Action_nXIndex = (int)Main.boardService.getSector(Action_nIndex = (int)pWall.getNextsector()).getExtra()) < 0 || !DB.xsector[PLAYER.Action_nXIndex].Wallpush) break;
                    return 6;
                }
                case 1: 
                case 2: {
                    Action_nIndex = Engine.pHitInfo.hitsect;
                    Action_nXIndex = Main.boardService.getSector(Action_nIndex).getExtra();
                    if (Action_nXIndex < 0 || !DB.xsector[PLAYER.Action_nXIndex].Push) break;
                    return 6;
                }
            }
        }
        if ((Action_nXIndex = (int)Main.boardService.getSector(Action_nIndex = (int)pPlayerSprite.getSectnum()).getExtra()) >= 0 && DB.xsector[PLAYER.Action_nXIndex].Push) {
            return 6;
        }
        return -1;
    }

    public static void ProcessInput(PLAYER pPlayer) {
        BloodSprite pSprite = pPlayer.pSprite;
        POSTURE cp = Globals.gPosture[pPlayer.nLifeMode][pPlayer.moveState];
        short nXSprite = pPlayer.pSprite.getExtra();
        if (nXSprite == -1) {
            return;
        }
        XSPRITE pXSprite = pPlayer.pXsprite;
        pPlayer.Run = pPlayer.pInput.Run;
        if (!Globals.gNoClip && !DemoUtils.IsOriginalDemo()) {
            short nSector = pSprite.getSectnum();
            Gameutils.GetSpriteExtents(pSprite);
            int floorDist = (Gameutils.extents_zBot - pSprite.getZ()) / 4;
            int ceilDist = (pSprite.getZ() - Gameutils.extents_zTop) / 4;
            int clipDist = pSprite.getClipdist() << 2;
            int push = Main.engine.pushmove(pSprite.getX(), pSprite.getY(), pSprite.getZ(), nSector, clipDist, ceilDist, floorDist, 65537);
            pSprite.setX(Engine.pushmove_x);
            pSprite.setY(Engine.pushmove_y);
            pSprite.setZ(Engine.pushmove_z);
            nSector = Engine.pushmove_sectnum;
            if (push == -1) {
                Actor.actDamageSprite(pPlayer.nSprite, pSprite, 0, 8000);
            }
            if (nSector != pSprite.getSectnum()) {
                if (nSector == -1) {
                    nSector = pSprite.getSectnum();
                    Actor.actDamageSprite(pSprite.getXvel(), pSprite, 0, 8000);
                }
                if (!Main.boardService.isValidSector(nSector)) {
                    throw new AssertException("boardService.isValidSector(nSector)");
                }
                Main.engine.changespritesect((short)pPlayer.nSprite, nSector);
            }
        }
        if (pPlayer.pInput.Forward != 0 || pPlayer.pInput.Turn != 0.0f || pPlayer.pInput.Strafe != 0 || pPlayer.pInput.Jump || pPlayer.pInput.Crouch || pPlayer.pInput.Lookup || pPlayer.pInput.Lookdown || pPlayer.pInput.AltShoot || pPlayer.pInput.Shoot) {
            pPlayer.stayTime = 0;
        } else if (pPlayer.stayTime >= 0) {
            pPlayer.stayTime += Globals.kFrameTicks;
        }
        Weapon.WeaponProcess(pPlayer);
        if (pXSprite.getHealth() == 0) {
            boolean noLastLoad = false;
            if (Globals.pGameInfo.nGameType == 0 && Main.game.isCurrentScreen(Main.gGameScreen) && LOADSAVE.lastload != null && LOADSAVE.lastload.exists()) {
                QUOTE quote;
                if (pPlayer.deathTime == 0) {
                    QUOTE quote2 = View.viewSetMessage(deathMessage, -1, 7);
                    if (quote2 != null) {
                        quote2.messageTime = 0x780000 + Globals.gFrameClock;
                    }
                } else if (View.numQuotes == 0 && (quote = View.viewSetMessage(deathMessage, -1, 7)) != null) {
                    quote.messageTime = 0x780000 + Globals.gFrameClock;
                }
                if (pPlayer.pInput.Use) {
                    Main.game.changeScreen(Main.gLoadingScreen.setTitle(LOADSAVE.lastload.getName()));
                    Main.gLoadingScreen.init(() -> {
                        if (!LOADSAVE.loadgame(LOADSAVE.lastload)) {
                            Main.game.GameMessage("Can't load game!");
                        }
                    });
                    pPlayer.pInput.Use = false;
                    return;
                }
                if (Main.game.getProcessor().isKeyPressed(66)) {
                    noLastLoad = true;
                }
            }
            boolean deathType = PLAYER.checkPlayerSeq(pPlayer, VERSION.getPlayerSeq(12));
            if (pPlayer.fraggerID != -1 && pPlayer.fraggerID != pPlayer.nSprite) {
                pSprite.setAng(EngineUtils.getAngle(Main.boardService.getSprite(pPlayer.fraggerID).getX() - pSprite.getX(), Main.boardService.getSprite(pPlayer.fraggerID).getY() - pSprite.getY()));
                pPlayer.ang = pSprite.getAng();
            }
            pPlayer.deathTime += Globals.kFrameTicks;
            if (!(deathType || Globals.pGameInfo.nGameType == 1 && Globals.pGameInfo.nReviveMode)) {
                pPlayer.horiz = Pragmas.mulscale(32768 - (Trig.Cos(Gameutils.ClipHigh(pPlayer.deathTime << 3, 1024)) >> 15), 120L, 16);
            }
            SOUND.setReverb(false, 0.0f);
            pPlayer.LastWeapon = 0;
            pPlayer.CrouchMode = 0;
            if (pPlayer.currentWeapon != 0) {
                pPlayer.pInput.newWeapon = pPlayer.currentWeapon;
            }
            if (pPlayer.pInput.Use || noLastLoad) {
                if (deathType && Globals.pGameInfo.nGameType != 1 && pPlayer.deathTime > 360) {
                    SeqHandling.seqSpawn(pPlayer.pDudeInfo.seqStartID + VERSION.getPlayerSeq(9), 3, nXSprite, SeqHandling.callbacks[1]);
                    pPlayer.pInput.Use = false;
                    return;
                }
                if (!Main.game.isCurrentScreen(Main.gDemoScreen) && (SeqHandling.seqFrame(3, nXSprite) < 0 || Globals.pGameInfo.nGameType == 1 && Globals.pGameInfo.nReviveMode && pPlayer.deathTime > 100)) {
                    SOUND.sfxKillAll3DSounds();
                    if (pPlayer.pSprite != null) {
                        pPlayer.pSprite.setLotag(426);
                    }
                    Actor.actPostSprite(pPlayer.nSprite, 4);
                    SeqHandling.seqSpawn(pPlayer.pDudeInfo.seqStartID + VERSION.getPlayerSeq(10), 3, nXSprite, null);
                    PLAYER.resetInventory(pPlayer);
                    if (Globals.pGameInfo.nGameType == 0 && Mmulti.numplayers == 1) {
                        pPlayer.pInput.Restart = true;
                        pPlayer.pInput.Use = false;
                        pPlayer.hitEffect = 0;
                        return;
                    }
                    PLAYER.playerReset(pPlayer.nPlayer);
                }
                pPlayer.pInput.Use = false;
            }
            return;
        }
        if (pPlayer.moveState == 1) {
            if (pPlayer.pInput.Forward != 0) {
                pSprite.addVelocityX(Pragmas.mulscale(Trig.Cos(pSprite.getAng()), (long)pPlayer.pInput.Forward * (long)cp.frontAccel, 30));
                pSprite.addVelocityY(Pragmas.mulscale(Trig.Sin(pSprite.getAng()), (long)pPlayer.pInput.Forward * (long)cp.frontAccel, 30));
            }
            if (pPlayer.pInput.Strafe != 0) {
                pSprite.addVelocityX(Pragmas.mulscale(Trig.Sin(pSprite.getAng()), (long)pPlayer.pInput.Strafe * (long)cp.sideAccel, 30));
                pSprite.addVelocityY(-Pragmas.mulscale(Trig.Cos(pSprite.getAng()), (long)pPlayer.pInput.Strafe * (long)cp.sideAccel, 30));
            }
        } else if (pXSprite.getHeight() < 256) {
            long vel;
            int zvel = 65536;
            if (pXSprite.getHeight() != 0) {
                zvel -= (pXSprite.getHeight() << 16) / 256;
            }
            if (pPlayer.pInput.Forward != 0) {
                vel = pPlayer.pInput.Forward > 0 ? (long)pPlayer.pInput.Forward * (long)cp.frontAccel : (long)pPlayer.pInput.Forward * (long)cp.backAccel;
                if (pXSprite.getHeight() != 0) {
                    vel = Pragmas.mulscale(zvel, vel, 16);
                }
                pSprite.addVelocityX(Pragmas.mulscale(Trig.Cos(pSprite.getAng()), vel, 30));
                pSprite.addVelocityY(Pragmas.mulscale(Trig.Sin(pSprite.getAng()), vel, 30));
            }
            if (pPlayer.pInput.Strafe != 0) {
                vel = (long)pPlayer.pInput.Strafe * (long)cp.sideAccel;
                if (pXSprite.getHeight() != 0) {
                    vel = Pragmas.mulscale(zvel, vel, 16);
                }
                pSprite.addVelocityX(Pragmas.mulscale(Trig.Sin(pSprite.getAng()), vel, 30));
                pSprite.addVelocityY(-Pragmas.mulscale(Trig.Cos(pSprite.getAng()), vel, 30));
            }
        }
        if (DemoUtils.IsOriginalDemo()) {
            if (pPlayer.pInput.Turn != 0.0f) {
                pSprite.setAng((short)(pSprite.getAng() + (Globals.kFrameTicks * (int)pPlayer.pInput.Turn >> 4) & 0x7FF));
                pPlayer.ang = pSprite.getAng();
            }
        } else {
            if (pPlayer.pInput.Turn != 0.0f) {
                pPlayer.ang = ru.m210projects.Build.Gameutils.BClampAngle(pPlayer.ang + (float)Globals.kFrameTicks * pPlayer.pInput.Turn / 16.0f);
            }
            pSprite.setAng((short)pPlayer.ang);
        }
        if (pPlayer.pInput.TurnAround) {
            if (pPlayer.TurnAround == 0) {
                pPlayer.TurnAround = -1024;
            }
            pPlayer.pInput.TurnAround = false;
        }
        if (pPlayer.TurnAround < 0) {
            int angSpeed = pPlayer.moveState == 1 ? 64 : 128;
            pPlayer.TurnAround = Gameutils.ClipHigh(pPlayer.TurnAround + angSpeed, 0);
            pPlayer.ang = ru.m210projects.Build.Gameutils.BClampAngle(pPlayer.ang + (float)angSpeed);
            if (DemoUtils.IsOriginalDemo()) {
                pSprite.setAng((short)pPlayer.ang);
            }
        }
        pPlayer.lookang -= pPlayer.lookang >> 2;
        if (pPlayer.lookang != 0 && pPlayer.lookang >> 2 == 0) {
            pPlayer.lookang -= Pragmas.ksgn(pPlayer.lookang);
        }
        if (pPlayer.pInput.LookLeft) {
            pPlayer.lookang -= 152;
        }
        if (pPlayer.pInput.LookRight) {
            pPlayer.lookang += 152;
        }
        if (!pPlayer.pInput.Jump) {
            pPlayer.pJump = false;
        } else {
            pPlayer.CrouchMode = 0;
        }
        if (pPlayer.pInput.Crouch) {
            pPlayer.CrouchMode = 0;
        }
        if (pPlayer.moveState == 1) {
            pPlayer.CrouchMode = pPlayer.pInput.CrouchMode ? 1 : 0;
        } else if (pPlayer.pInput.CrouchMode) {
            pPlayer.CrouchMode ^= 1;
        }
        if (pPlayer.CrouchMode == 1) {
            pPlayer.pInput.Crouch = true;
        }
        if (pPlayer.pInput.LastWeapon) {
            pPlayer.pInput.newWeapon = pPlayer.LastWeapon;
        }
        switch (pPlayer.moveState) {
            case 0: {
                if (!pPlayer.pJump && pPlayer.pInput.Jump && pXSprite.getHeight() == 0) {
                    SOUND.sfxStart3DSound(pPlayer.pSprite, 700, -1, 0);
                    if (PLAYER.inventoryCheck(pPlayer, 4)) {
                        pSprite.setVelocityZ(-1529173L);
                    } else {
                        pSprite.setVelocityZ(-764586L);
                    }
                    pPlayer.pJump = true;
                }
                if (!pPlayer.pInput.Crouch) break;
                pPlayer.moveState = 2;
                break;
            }
            case 1: {
                if (pPlayer.pInput.Jump) {
                    pSprite.addVelocityZ(-23301L);
                }
                if (!pPlayer.pInput.Crouch) break;
                pSprite.addVelocityZ(23301L);
                break;
            }
            case 3: {
                if (pPlayer.pInput.Jump) {
                    pSprite.setVelocityZ(-400000L);
                    break;
                }
                if (pPlayer.pInput.Crouch) {
                    pSprite.setVelocityZ(400000L);
                    break;
                }
                pSprite.setVelocityZ(0L);
                break;
            }
            case 2: {
                if (pPlayer.pInput.Crouch) break;
                pPlayer.moveState = 0;
            }
        }
        if (pPlayer.pInput.Use) {
            switch (PLAYER.ActionScan(pPlayer)) {
                case 6: {
                    XSECTOR pXSector = DB.xsector[Action_nXIndex];
                    int keyId = pXSector.Key;
                    if (pXSector.locked != 0 && pPlayer == Globals.gMe) {
                        View.viewSetMessage("It's locked", pPlayer.nPlayer, 8);
                        SOUND.sndStartSample(3062, -1, 1, false);
                    }
                    if (keyId == 0 || pPlayer.hasKey[keyId]) {
                        Trigger.trTriggerSector(Action_nIndex, pXSector, 30);
                        break;
                    }
                    if (pPlayer != Globals.gMe) break;
                    View.viewSetMessage("That requires a key.", pPlayer.nPlayer, 8);
                    SOUND.sndStartSample(3063, -1, 1, false);
                    break;
                }
                case 0: {
                    XWALL pXWall = DB.xwall[Action_nXIndex];
                    int keyId = pXWall.key;
                    if (pXWall.locked != 0 && pPlayer == Globals.gMe) {
                        View.viewSetMessage("It's locked", pPlayer.nPlayer, 8);
                        SOUND.sndStartSample(3062, -1, 1, false);
                    }
                    if (keyId == 0 || pPlayer.hasKey[keyId]) {
                        Trigger.trTriggerWall(Action_nIndex, pXWall, 50);
                        break;
                    }
                    if (pPlayer != Globals.gMe) break;
                    View.viewSetMessage("That requires a key.", pPlayer.nPlayer, 8);
                    SOUND.sndStartSample(3063, -1, 1, false);
                    break;
                }
                case 3: {
                    XSPRITE pXSpr = Main.boardService.getXSprite(Action_nXIndex);
                    if (pXSpr == null) break;
                    int keyId = pXSpr.getKey();
                    if (pXSpr.getLocked() != 0 && pPlayer == Globals.gMe && pXSpr.getLockMsg() != 0) {
                        Trigger.trTextOver(pXSpr.getLockMsg());
                    }
                    if (keyId != 0 && !pPlayer.hasKey[keyId]) {
                        if (pPlayer != Globals.gMe) break;
                        View.viewSetMessage("That requires a key.", pPlayer.nPlayer, 8);
                        SOUND.sndStartSample(3063, -1, 1, false);
                        break;
                    }
                    Trigger.trTriggerSprite(Action_nIndex, pXSpr, 30);
                    break;
                }
            }
            if (pPlayer.handCount > 0) {
                pPlayer.handCount = DemoUtils.IsOriginalDemo() ? Gameutils.ClipLow(pPlayer.handCount - Globals.kFrameTicks * (6 - Globals.pGameInfo.nDifficulty), 0) : Gameutils.ClipLow(pPlayer.handCount - Globals.kFrameTicks * (7 - Globals.pGameInfo.nDifficulty), 0);
            }
            if (pPlayer.handDamage && pPlayer.handCount == 0) {
                BloodSprite pHand = Actor.actSpawnDude(pSprite, 212, pSprite.getClipdist() << 1);
                pHand.setAng((short)(pSprite.getAng() + 1024 & 0x7FF));
                pHand.setVelocity(pSprite.getVelocityX() + (long)Pragmas.mulscale(Trig.Cos(pSprite.getAng()) >> 16, 0x155555L, 14), pSprite.getVelocityY() + (long)Pragmas.mulscale(Trig.Sin(pSprite.getAng()) >> 16, 0x155555L, 14), pSprite.getVelocityZ());
                pPlayer.handDamage = false;
            }
            pPlayer.pInput.Use = false;
        }
        pPlayer.look = ru.m210projects.Build.Gameutils.BClipRange(pPlayer.look + pPlayer.pInput.mlook, -60.0f, 60.0f);
        if (pPlayer.pInput.InventoryLeft) {
            PLAYER.InventoryLeft(pPlayer);
            pPlayer.pInput.InventoryLeft = false;
        }
        if (pPlayer.pInput.InventoryRight) {
            PLAYER.InventoryRight(pPlayer);
            pPlayer.pInput.InventoryRight = false;
        }
        if (pPlayer.pInput.InventoryUse) {
            if (pPlayer.choosedInven != -1 && pPlayer.Inventory[pPlayer.choosedInven].amount > 0) {
                PLAYER.processInventory(pPlayer, pPlayer.choosedInven);
            }
            pPlayer.pInput.InventoryUse = false;
        }
        if (pPlayer.pInput.UseBeastVision) {
            if (pPlayer.Inventory[3].amount > 0) {
                PLAYER.processInventory(pPlayer, 3);
            }
            pPlayer.pInput.UseBeastVision = false;
        }
        if (pPlayer.pInput.UseCrystalBall) {
            if (pPlayer.Inventory[2].amount > 0) {
                PLAYER.processInventory(pPlayer, 2);
            }
            pPlayer.pInput.UseCrystalBall = false;
        }
        if (pPlayer.pInput.UseJumpBoots) {
            if (pPlayer.Inventory[4].amount > 0) {
                PLAYER.processInventory(pPlayer, 4);
            }
            pPlayer.pInput.UseJumpBoots = false;
        }
        if (pPlayer.pInput.UseMedKit) {
            if (pPlayer.Inventory[0].amount > 0) {
                PLAYER.processInventory(pPlayer, 0);
            }
            pPlayer.pInput.UseMedKit = false;
        }
        if (pPlayer.pInput.HolsterWeapon) {
            pPlayer.pInput.HolsterWeapon = false;
            if (pPlayer.currentWeapon != 0) {
                pPlayer.LastWeapon = pPlayer.currentWeapon;
                Weapon.WeaponLower(pPlayer);
                View.viewSetMessage("Holstering weapon", pPlayer.nPlayer, 10);
            }
        }
        if (pPlayer.pInput.LookCenter && !pPlayer.pInput.Lookup && !pPlayer.pInput.Lookdown) {
            if (pPlayer.look < 0.0f) {
                pPlayer.look = Gameutils.ClipHigh(pPlayer.look + (float)Globals.kFrameTicks, 0);
            }
            if (pPlayer.look > 0.0f) {
                pPlayer.look = Gameutils.ClipLow(pPlayer.look - (float)Globals.kFrameTicks, 0);
            }
            if (pPlayer.look == 0.0f) {
                pPlayer.pInput.LookCenter = false;
            }
        } else {
            if (pPlayer.pInput.Lookup) {
                pPlayer.look = Gameutils.ClipHigh(pPlayer.look + (float)Globals.kFrameTicks, 60);
            }
            if (pPlayer.pInput.Lookdown) {
                pPlayer.look = Gameutils.ClipLow(pPlayer.look - (float)Globals.kFrameTicks, -60);
            }
        }
        pPlayer.horiz = DemoUtils.IsOriginalDemo() ? (pPlayer.look > 0.0f ? (float)Pragmas.mulscale(120L, Trig.Sin((int)(pPlayer.look * 8.0f)), 30) : (pPlayer.look < 0.0f ? (float)Pragmas.mulscale(180L, Trig.Sin((int)(pPlayer.look * 8.0f)), 30) : 0.0f)) : (pPlayer.look > 0.0f ? (float)(ru.m210projects.Build.Gameutils.BSinAngle(pPlayer.look * 8.533334f) * 120.0 / 16384.0) : (pPlayer.look < 0.0f ? (float)(ru.m210projects.Build.Gameutils.BSinAngle(pPlayer.look * 8.533334f) * 180.0 / 16384.0) : 0.0f));
        int floorhit = pXSprite.getSpriteHit().floorHit & 0xE0000000;
        if (pXSprite.getHeight() < 16 && (floorhit == 0x40000000 || floorhit == 0) && (Main.boardService.getSector(pSprite.getSectnum()).getFloorstat() & 2) != 0) {
            int dy;
            int oldslope = Main.engine.getflorzofslope(pSprite.getSectnum(), pSprite.getX(), pSprite.getY());
            int dx = Pragmas.mulscale(64L, Trig.Cos(pSprite.getAng()), 30) + pSprite.getX();
            int nSector = Main.engine.updatesector(dx, dy = Pragmas.mulscale(64L, Trig.Sin(pSprite.getAng()), 30) + pSprite.getY(), pSprite.getSectnum());
            if (nSector == pSprite.getSectnum()) {
                int newslope = Main.engine.getflorzofslope(nSector, dx, dy);
                int slope = (oldslope - newslope >> 3) - pPlayer.slope << 14;
                pPlayer.slope += slope >> 16;
            }
        } else {
            int slope = pPlayer.slope;
            int newslope = -slope << 14;
            pPlayer.slope = newslope = slope + (newslope >> 16);
            if (newslope < 0) {
                newslope = -(slope + (-slope << 14 >> 16));
            }
            if (newslope < 4) {
                pPlayer.slope = 0;
            }
        }
        pPlayer.horizOff = -128.0f * pPlayer.horiz;
        PLAYER.PickUp(pPlayer);
    }

    public static int CheckTouchSprite(Sprite pSprite) {
        for (ListNode<Sprite> node = Main.boardService.getStatNode(3); node != null; node = node.getNext()) {
            int dy;
            int dx;
            int i = node.getIndex();
            Sprite pItem = node.get();
            if ((pItem.getHitag() & 0x20) != 0 || (dx = Pragmas.klabs(pSprite.getX() - pItem.getX()) >> 4) >= 48 || (dy = Pragmas.klabs(pSprite.getY() - pItem.getY()) >> 4) >= 48) continue;
            Gameutils.GetSpriteExtents(pSprite);
            int dz = 0;
            if (Main.boardService.getSprite(i).getZ() < Gameutils.extents_zTop) {
                dz = Gameutils.extents_zTop - pItem.getZ() >> 8;
            } else if (pItem.getZ() > Gameutils.extents_zBot) {
                dz = pItem.getZ() - Gameutils.extents_zBot >> 8;
            }
            if (dz >= 32 || EngineUtils.qdist(dx, dy) >= 48) continue;
            Gameutils.GetSpriteExtents(pItem);
            if (!Main.engine.cansee(pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), pItem.getX(), pItem.getY(), pItem.getZ(), pItem.getSectnum()) && !Main.engine.cansee(pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), pItem.getX(), pItem.getY(), Gameutils.extents_zTop, pItem.getSectnum()) && !Main.engine.cansee(pSprite.getX(), pSprite.getY(), pSprite.getZ(), pSprite.getSectnum(), pItem.getX(), pItem.getY(), Gameutils.extents_zBot, pItem.getSectnum())) continue;
            return i;
        }
        return -1;
    }

    public static void PickUp(PLAYER pPlayer) {
        BloodSprite pSprite = pPlayer.pSprite;
        String buffer = "";
        for (ListNode<Sprite> node = Main.boardService.getStatNode(3); node != null; node = node.getNext()) {
            int dy;
            int i = node.getIndex();
            Sprite pItem = node.get();
            if ((pItem.getHitag() & 0x20) != 0) continue;
            int x = pSprite.getX();
            int y = pSprite.getY();
            int z = pSprite.getZ();
            short sectnum = pSprite.getSectnum();
            int ix = pItem.getX();
            int iy = pItem.getY();
            int iz = pItem.getZ();
            short isectnum = pItem.getSectnum();
            int dx = Pragmas.klabs(x - ix) >> 4;
            if (dx > 48 || (dy = Pragmas.klabs(y - iy) >> 4) > 48) continue;
            Gameutils.GetSpriteExtents(pSprite);
            int dz = 0;
            if (iz < Gameutils.extents_zTop) {
                dz = Gameutils.extents_zTop - iz >> 8;
            } else if (iz > Gameutils.extents_zBot) {
                dz = iz - Gameutils.extents_zBot >> 8;
            }
            if (dz > 32 || EngineUtils.qdist(dx, dy) > 48) continue;
            Gameutils.GetSpriteExtents(pItem);
            if (!Main.engine.cansee(x, y, z, sectnum, ix, iy, iz, isectnum) && !Main.engine.cansee(x, y, z, sectnum, ix, iy, Gameutils.extents_zTop, isectnum) && !Main.engine.cansee(x, y, z, sectnum, ix, iy, Gameutils.extents_zBot, isectnum)) continue;
            boolean bPickedUp = false;
            int customMsg = -1;
            short nType = pItem.getLotag();
            if (nType != 80 && nType != 40) {
                XSPRITE pXSprite = Main.boardService.getXSprite(pItem.getExtra());
                if (pXSprite != null && pXSprite.getTxID() != 3 && pXSprite.getLockMsg() > 0) {
                    customMsg = pXSprite.getLockMsg();
                }
                if (nType >= 100 && nType <= 149) {
                    bPickedUp = PLAYER.PickupItem(pPlayer, i, nType);
                    if (bPickedUp && customMsg == -1) {
                        buffer = "Picked up " + DB.gItemText[nType - 100];
                    }
                } else if (nType >= 60 && nType < 81) {
                    bPickedUp = PLAYER.PickupAmmo(pPlayer, i, nType);
                    if (bPickedUp && customMsg == -1) {
                        buffer = "Picked up " + DB.gAmmoText[nType - 60];
                    }
                } else if (nType >= 40 && nType < 51 && (bPickedUp = PLAYER.PickupWeapon(pPlayer, i, nType)) && customMsg == -1) {
                    buffer = "Picked up " + DB.gWeaponText[nType - 40];
                }
            }
            if (!bPickedUp) continue;
            XSPRITE pXItem = Main.boardService.getXSprite(pItem.getExtra());
            if (pXItem != null && pXItem.isPickup()) {
                Trigger.trTriggerSprite(i, pXItem, 32);
            }
            if (!Actor.actCheckRespawn(pItem)) {
                Actor.actPostSprite(i, 1024);
            }
            pPlayer.pickupEffect = 30;
            if (pPlayer != Globals.gMe) continue;
            if (customMsg > 0) {
                Trigger.trTextOver(customMsg - 1);
                continue;
            }
            View.viewSetMessage(buffer, pPlayer.nPlayer);
        }
    }

    public static boolean PickupItem(PLAYER pPlayer, int nSprite, int nItemType) {
        int soundId = 775;
        BloodSprite pSprite = pPlayer.pSprite;
        XSPRITE pXSprite = pPlayer.pXsprite;
        int nPowerUp = nItemType - 100;
        switch (nItemType) {
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                if (pPlayer.hasKey[nItemType - 100 + 1]) {
                    return false;
                }
                pPlayer.hasKey[nItemType - 100 + 1] = true;
                soundId = 781;
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                int addPower = Actor.gPowerUpInfo[nPowerUp].addPower;
                XSPRITE pXPower = Main.boardService.getXSprite(Main.boardService.getSprite(nSprite).getExtra());
                if (pXPower != null && pXPower.getData1() > 0 && !DemoUtils.IsOriginalDemo()) {
                    addPower = pXPower.getData1();
                }
                return Actor.actHealDude(pXSprite, addPower, Actor.gPowerUpInfo[nPowerUp].maxPower);
            }
            case 121: {
                if (Globals.pGameInfo.nGameType != 0 && PLAYER.PickupInventryItem(pPlayer, Actor.gItemInfo[nPowerUp].nInventory)) break;
                return false;
            }
            case 107: 
            case 115: 
            case 118: 
            case 125: {
                if (PLAYER.PickupInventryItem(pPlayer, Actor.gItemInfo[nPowerUp].nInventory)) break;
                return false;
            }
            case 117: {
                if (PLAYER.powerupActivate(pPlayer, nPowerUp)) break;
                return false;
            }
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                boolean ret = false;
                ARMORITEMDATA pArmorData = Actor.gArmorItemData[nItemType - 140];
                if (pPlayer.ArmorAmount[0] < pArmorData.max[0]) {
                    pPlayer.ArmorAmount[0] = Gameutils.ClipHigh(pPlayer.ArmorAmount[0] + pArmorData.count[0], pArmorData.max[0]);
                    ret = true;
                }
                if (pPlayer.ArmorAmount[1] < pArmorData.max[1]) {
                    pPlayer.ArmorAmount[1] = Gameutils.ClipHigh(pPlayer.ArmorAmount[1] + pArmorData.count[1], pArmorData.max[1]);
                    ret = true;
                }
                if (pPlayer.ArmorAmount[2] < pArmorData.max[2]) {
                    pPlayer.ArmorAmount[2] = Gameutils.ClipHigh(pPlayer.ArmorAmount[2] + pArmorData.count[2], pArmorData.max[2]);
                    ret = true;
                }
                if (ret) {
                    SOUND.sfxCreate3DSound(pSprite.getX(), pSprite.getY(), pSprite.getZ(), 779, pSprite.getSectnum());
                }
                return ret;
            }
            case 145: 
            case 146: {
                if (Globals.pGameInfo.nGameType != 3) {
                    return false;
                }
                XSPRITE pXBase = Main.boardService.getXSprite(Main.boardService.getSprite(nSprite).getExtra());
                if (pXBase != null) {
                    if (nItemType == 145) {
                        if (pPlayer.teamID == 1) {
                            if ((pPlayer.hasFlag & 1) == 0 && pXBase.getState() != 0) {
                                pPlayer.hasFlag |= 1;
                                pPlayer.nBlueTeam = Main.boardService.getSprite(nSprite).getXvel();
                                Trigger.trTriggerSprite(pSprite.getXvel(), pXBase, 0);
                                SOUND.sndStartSample(8007, 255, 2, false);
                                View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " stole Blue Flag", -1, 10);
                            }
                        } else {
                            if ((pPlayer.hasFlag & 1) != 0 && pXBase.getState() == 0) {
                                pPlayer.nBlueTeam = (short)-1;
                                pPlayer.hasFlag &= 0xFFFFFFFE;
                                Trigger.trTriggerSprite(pSprite.getXvel(), pXBase, 1);
                                SOUND.sndStartSample(8003, 255, 2, false);
                                View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " returned Blue Flag", -1, 10);
                            }
                            if ((pPlayer.hasFlag & 2) != 0 && pXBase.getState() != 0) {
                                pPlayer.nRedTeam = (short)-1;
                                pPlayer.hasFlag &= 0xFFFFFFFD;
                                int n = pPlayer.teamID;
                                Globals.nTeamCount[n] = Globals.nTeamCount[n] + 10;
                                int n2 = pPlayer.teamID;
                                Globals.nTeamClock[n2] = Globals.nTeamClock[n2] + 240;
                                PLAYER.checkFragLimit();
                                EVENT.evSend(0, 0, 81, 1);
                                SOUND.sndStartSample(8001, 255, 2, false);
                                View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " captured Red Flag!", -1, 7);
                            }
                        }
                    } else if (pPlayer.teamID == 0) {
                        if ((pPlayer.hasFlag & 2) == 0 && pXBase.getState() != 0) {
                            pPlayer.hasFlag |= 2;
                            pPlayer.nRedTeam = Main.boardService.getSprite(nSprite).getXvel();
                            Trigger.trTriggerSprite(pSprite.getXvel(), pXBase, 0);
                            SOUND.sndStartSample(8006, 255, 2, false);
                            View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " stole Red Flag", -1, 7);
                        }
                    } else {
                        if ((pPlayer.hasFlag & 2) != 0 && pXBase.getState() == 0) {
                            pPlayer.nRedTeam = (short)-1;
                            pPlayer.hasFlag &= 0xFFFFFFFD;
                            Trigger.trTriggerSprite(pSprite.getXvel(), pXBase, 1);
                            SOUND.sndStartSample(8002, 255, 2, false);
                            View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " returned Red Flag", -1, 7);
                        }
                        if ((pPlayer.hasFlag & 1) != 0 && pXBase.getState() != 0) {
                            pPlayer.nBlueTeam = (short)-1;
                            pPlayer.hasFlag &= 0xFFFFFFFE;
                            int n = pPlayer.teamID;
                            Globals.nTeamCount[n] = Globals.nTeamCount[n] + 10;
                            int n3 = pPlayer.teamID;
                            Globals.nTeamClock[n3] = Globals.nTeamClock[n3] + 240;
                            PLAYER.checkFragLimit();
                            EVENT.evSend(0, 0, 80, 1);
                            SOUND.sndStartSample(8000, 255, 2, false);
                            View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " captured Blue Flag!", -1, 10);
                        }
                    }
                    return false;
                }
                return false;
            }
            case 147: {
                if (Globals.pGameInfo.nGameType != 3) {
                    return false;
                }
                pPlayer.hasFlag |= 1;
                pPlayer.nBlueTeam = Main.boardService.getSprite(nSprite).getOwner();
                EVENT.checkEventList(pSprite.getXvel(), 3, 17);
                break;
            }
            case 148: {
                if (Globals.pGameInfo.nGameType != 3) {
                    return false;
                }
                pPlayer.hasFlag |= 2;
                pPlayer.nRedTeam = Main.boardService.getSprite(nSprite).getOwner();
                EVENT.checkEventList(pSprite.getXvel(), 3, 17);
                break;
            }
            default: {
                if (PLAYER.powerupActivate(pPlayer, nPowerUp)) break;
                return false;
            }
        }
        if (nItemType != 117) {
            SOUND.sfxCreate3DSound(pSprite.getX(), pSprite.getY(), pSprite.getZ(), soundId, pSprite.getSectnum());
        }
        return true;
    }

    public static void DeliriumProcess() {
        int nDelirium = PLAYER.powerupCheck(Globals.gPlayer[View.gViewIndex], 28);
        if (nDelirium != 0) {
            timer += Globals.kFrameTicks;
            int maxTilt = 170;
            int maxTurn = 170;
            int maxPitch = 20;
            if (nDelirium < 512) {
                int scale = (nDelirium << 16) / 512;
                maxTilt = Pragmas.mulscale(maxTilt, scale, 16);
                maxTurn = Pragmas.mulscale(maxTurn, scale, 16);
                maxPitch = Pragmas.mulscale(maxPitch, scale, 16);
            }
            View.deliriumTilt = Pragmas.mulscale(Trig.Sin(timer * 2) / 2 + Trig.Sin(timer * 3) / 2, maxTilt, 30);
            View.deliriumTurn = Pragmas.mulscale(Trig.Sin(timer * 3) / 2 + Trig.Sin(timer * 4) / 2, maxTurn, 30);
            View.deliriumPitch = Pragmas.mulscale(Trig.Sin(timer * 4) / 2 + Trig.Sin(timer * 5) / 2, maxPitch, 30);
        } else {
            View.deliriumTilt = 0;
            View.deliriumTurn = 0;
            View.deliriumPitch = 0;
        }
    }

    public static boolean shrinkPlayerSize(PLAYER pPlayer, int divider) {
        pPlayer.pXsprite.setData1((short)(-divider));
        PLAYER.playerSetRace(pPlayer, 2);
        return true;
    }

    public static boolean growPlayerSize(PLAYER pPlayer, int multiplier) {
        pPlayer.pXsprite.setData1((short)multiplier);
        PLAYER.playerSetRace(pPlayer, 3);
        return true;
    }

    public static boolean resetPlayerSize(PLAYER pPlayer) {
        PLAYER.playerSetRace(pPlayer, 0);
        pPlayer.pXsprite.setData1(0);
        return true;
    }

    public static boolean powerupActivate(PLAYER pPlayer, int nPowerUp) {
        if (PLAYER.powerupCheck(pPlayer, nPowerUp) > 0 && Actor.gPowerUpInfo[nPowerUp].isUnique) {
            return false;
        }
        int nInventory = PLAYER.getInventoryNum(nPowerUp + 100);
        if (nInventory >= 0) {
            pPlayer.Inventory[nInventory].activated = true;
        }
        if (!DemoUtils.IsOriginalDemo() && nInventory == -1 || pPlayer.powerUpTimer[nPowerUp] == 0) {
            pPlayer.powerUpTimer[nPowerUp] = Actor.gPowerUpInfo[nPowerUp].addPower;
        }
        switch (nPowerUp + 100) {
            case 117: {
                if (!DemoUtils.IsOriginalDemo() && pPlayer.currentWeapon != 2 && pPlayer.currentWeapon != 3 && pPlayer.currentWeapon != 4 && pPlayer.currentWeapon != 5 && pPlayer.currentWeapon != 8) break;
                pPlayer.pInput.newWeapon = pPlayer.currentWeapon;
                Weapon.WeaponRaise(pPlayer);
                break;
            }
            case 118: {
                if (!pPlayer.godMode) {
                    pPlayer.damageShift[4] = pPlayer.damageShift[4] + 1;
                }
                if (pPlayer != Globals.gMe) break;
                SOUND.setReverb(true, 0.2f);
                break;
            }
            case 119: {
                if (pPlayer.godMode) break;
                pPlayer.damageShift[4] = pPlayer.damageShift[4] + 1;
                break;
            }
            case 124: {
                if (pPlayer != Globals.gMe) break;
                SOUND.setReverb(true, 0.4f);
                break;
            }
            case 139: {
                if (pPlayer.godMode) break;
                pPlayer.damageShift[1] = pPlayer.damageShift[1] + 1;
                break;
            }
            case 114: {
                if (pPlayer.godMode) break;
                int i = 0;
                while (i < 7) {
                    int n = i++;
                    pPlayer.damageShift[n] = pPlayer.damageShift[n] + 1;
                }
                break;
            }
            case 112: 
            case 115: {
                if (pPlayer.godMode) break;
                pPlayer.damageShift[0] = pPlayer.damageShift[0] + 1;
                break;
            }
            case 149: {
                pPlayer.moveState = 3;
                pPlayer.pSprite.setHitag(pPlayer.pSprite.getHitag() & 0xFFFFFFFD);
                break;
            }
        }
        SOUND.sfxStart3DSound(pPlayer.pSprite, 776, -1, 0);
        return true;
    }

    public static void powerupDeactivate(PLAYER pPlayer, int nPowerUp) {
        int nInventory = PLAYER.getInventoryNum(nPowerUp + 100);
        if (nInventory >= 0) {
            pPlayer.Inventory[nInventory].activated = false;
        }
        switch (nPowerUp + 100) {
            case 117: {
                if (!DemoUtils.IsOriginalDemo() && pPlayer.currentWeapon != 2 && pPlayer.currentWeapon != 3 && pPlayer.currentWeapon != 4 && pPlayer.currentWeapon != 5 && pPlayer.currentWeapon != 8) break;
                pPlayer.pInput.newWeapon = pPlayer.currentWeapon;
                Weapon.WeaponRaise(pPlayer);
                break;
            }
            case 118: {
                if (!pPlayer.godMode) {
                    pPlayer.damageShift[4] = pPlayer.damageShift[4] - 1;
                }
                if (pPlayer != Globals.gMe) break;
                SOUND.setReverb(false, 0.0f);
                break;
            }
            case 119: {
                if (pPlayer.godMode) break;
                pPlayer.damageShift[4] = pPlayer.damageShift[4] - 1;
                break;
            }
            case 124: {
                if (pPlayer != Globals.gMe) break;
                SOUND.setReverb(false, 0.0f);
                break;
            }
            case 139: {
                if (pPlayer.godMode) break;
                pPlayer.damageShift[1] = pPlayer.damageShift[1] - 1;
                break;
            }
            case 114: {
                if (pPlayer.godMode) break;
                int i = 0;
                while (i < 7) {
                    int n = i++;
                    pPlayer.damageShift[n] = pPlayer.damageShift[n] - 1;
                }
                break;
            }
            case 112: 
            case 115: {
                if (pPlayer.godMode) break;
                pPlayer.damageShift[0] = pPlayer.damageShift[0] - 1;
                break;
            }
            case 149: {
                pPlayer.moveState = 0;
                pPlayer.pSprite.setHitag(pPlayer.pSprite.getHitag() | 2);
                pPlayer.pSprite.setVelocityZ(58254L);
            }
        }
    }

    public static void powerupProcess(PLAYER pPlayer) {
        pPlayer.showInventory = Gameutils.ClipLow(pPlayer.showInventory - Globals.kFrameTicks, 0);
        for (int i = 48; i >= 0; --i) {
            int nInventory = PLAYER.getInventoryNum(i + 100);
            if (nInventory < 0) {
                if (pPlayer.powerUpTimer[i] <= 0) continue;
                pPlayer.powerUpTimer[i] = Gameutils.ClipLow(pPlayer.powerUpTimer[i] - Globals.kFrameTicks, 0);
                if (pPlayer.powerUpTimer[i] != 0) continue;
                PLAYER.powerupDeactivate(pPlayer, i);
                continue;
            }
            if (!pPlayer.Inventory[nInventory].activated) continue;
            pPlayer.powerUpTimer[i] = Gameutils.ClipLow(pPlayer.powerUpTimer[i] - Globals.kFrameTicks, 0);
            if (i == 47) continue;
            if (pPlayer.powerUpTimer[i] > 0) {
                pPlayer.Inventory[nInventory].amount = 100 * pPlayer.powerUpTimer[i] / Actor.gPowerUpInfo[i].addPower;
                continue;
            }
            PLAYER.powerupDeactivate(pPlayer, i);
            if (nInventory != pPlayer.choosedInven) continue;
            pPlayer.choosedInven = 0;
        }
        PLAYER.DeliriumProcess();
    }

    public static void powerupClear(PLAYER pPlayer) {
        for (int i = 0; i < 49; ++i) {
            pPlayer.powerUpTimer[i] = 0;
        }
    }

    public static boolean PickupInventryItem(PLAYER pPlayer, int nInventory) {
        if (nInventory >= 6) {
            System.err.println("Unhandled pack item " + nInventory);
            System.exit(1);
        }
        if (pPlayer.Inventory[nInventory].amount >= 100) {
            return false;
        }
        pPlayer.Inventory[nInventory].amount = 100;
        int type = -1;
        switch (nInventory) {
            case 1: {
                type = 118;
                break;
            }
            case 2: {
                type = 121;
                break;
            }
            case 3: {
                type = 125;
                break;
            }
            case 4: {
                type = 115;
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                type = 149;
                break;
            }
            default: {
                System.err.println("Unhandled pack item " + nInventory);
                System.exit(1);
            }
        }
        if ((type -= 100) == 17) {
            PLAYER.powerupActivate(pPlayer, type);
        }
        if (type >= 0) {
            pPlayer.powerUpTimer[type] = Actor.gPowerUpInfo[type].addPower;
        }
        if (pPlayer.choosedInven == -1) {
            pPlayer.choosedInven = nInventory;
        }
        if (pPlayer.Inventory[pPlayer.choosedInven].amount == 0) {
            pPlayer.choosedInven = nInventory;
        }
        return true;
    }

    public static int powerupCheck(PLAYER pPlayer, int nPowerUp) {
        if (pPlayer == null) {
            throw new AssertException("pPlayer != null");
        }
        if (nPowerUp < 0 || nPowerUp >= 49) {
            throw new AssertException("nPowerUp >= 0 && nPowerUp < kMaxPowerUps");
        }
        int nInventory = PLAYER.getInventoryNum(nPowerUp + 100);
        if (nInventory < 0 || PLAYER.inventoryCheck(pPlayer, nInventory)) {
            return pPlayer.powerUpTimer[nPowerUp];
        }
        return 0;
    }

    public static void processInventory(PLAYER pPlayer, int nInventory) {
        int nPowerUp = -1;
        boolean activated = false;
        if (pPlayer.Inventory[nInventory].amount > 0) {
            switch (nInventory) {
                case 0: {
                    int healValue;
                    XSPRITE pXDude = pPlayer.pXsprite;
                    int health = pXDude.getHealth() >> 4;
                    if (health >= 100) break;
                    if (100 - health >= pPlayer.Inventory[0].amount) {
                        healValue = pPlayer.Inventory[0].amount;
                        Actor.actHealDude(pXDude, healValue, 100);
                    } else {
                        healValue = 100 - health;
                        Actor.actHealDude(pXDude, 100 - health, 100);
                    }
                    pPlayer.Inventory[0].amount -= healValue;
                    break;
                }
                case 1: {
                    nPowerUp = 118;
                    activated = true;
                    break;
                }
                case 2: {
                    nPowerUp = 121;
                    activated = true;
                    break;
                }
                case 3: {
                    nPowerUp = 125;
                    activated = true;
                    break;
                }
                case 4: {
                    nPowerUp = 115;
                    activated = true;
                    break;
                }
                case 5: {
                    nPowerUp = 149;
                    activated = true;
                    break;
                }
                default: {
                    System.err.println("Unhandled pack item " + nInventory);
                    System.exit(1);
                }
            }
        }
        nPowerUp -= 100;
        pPlayer.showInventory = 0;
        if (activated) {
            if (pPlayer.Inventory[nInventory].activated) {
                PLAYER.powerupDeactivate(pPlayer, nPowerUp);
            } else {
                PLAYER.powerupActivate(pPlayer, nPowerUp);
            }
        }
    }

    public static int getInventoryNum(int item) {
        switch (item) {
            case 118: {
                return 1;
            }
            case 121: {
                return 2;
            }
            case 125: {
                return 3;
            }
            case 115: {
                return 4;
            }
            case 149: {
                return 5;
            }
        }
        return -1;
    }

    public static boolean inventoryCheck(PLAYER pPlayer, int nInventory) {
        return pPlayer.Inventory[nInventory].activated;
    }

    public static int getInventoryAmount(PLAYER pPlayer, int nInventory) {
        return pPlayer.Inventory[nInventory].amount;
    }

    public static void InventoryRight(PLAYER pPlayer) {
        if (pPlayer.showInventory > 0) {
            int nextInv = pPlayer.choosedInven + 1;
            int i = 0;
            while (i < 6) {
                if (nextInv == 6) {
                    nextInv = 0;
                }
                if (pPlayer.Inventory[nextInv].amount != 0) {
                    pPlayer.choosedInven = nextInv;
                    break;
                }
                ++i;
                ++nextInv;
            }
        }
        pPlayer.showInventory = 600;
    }

    public static void InventoryLeft(PLAYER pPlayer) {
        if (pPlayer.showInventory > 0) {
            int prevInv = pPlayer.choosedInven - 1;
            int i = 6;
            while (i >= 0) {
                if (prevInv <= -1) {
                    prevInv = 5;
                }
                if (pPlayer.Inventory[prevInv].amount != 0) {
                    pPlayer.choosedInven = prevInv;
                    break;
                }
                --i;
                --prevInv;
            }
        }
        pPlayer.showInventory = 600;
    }

    public static boolean PickupAmmo(PLAYER pPlayer, int nSprite, int nAmmoItemType) {
        AMMOITEMDATA pAmmoData = Actor.gAmmoItemData[nAmmoItemType - 60];
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        int nAmmoType = pAmmoData.ammoType;
        if (nAmmoType == 255) {
            return true;
        }
        if (pPlayer.ammoCount[nAmmoType] >= PLAYER.gAmmoInfo[nAmmoType].max && !Globals.gInfiniteAmmo) {
            return false;
        }
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        pPlayer.ammoCount[nAmmoType] = pXSprite == null || pXSprite.getData1() <= 0 ? Gameutils.ClipHigh(pPlayer.ammoCount[nAmmoType] + pAmmoData.count, PLAYER.gAmmoInfo[nAmmoType].max) : Gameutils.ClipHigh(pPlayer.ammoCount[nAmmoType] + pXSprite.getData1(), PLAYER.gAmmoInfo[nAmmoType].max);
        if (pAmmoData.weaponType != 0) {
            pPlayer.hasWeapon[pAmmoData.weaponType] = true;
        }
        SOUND.sfxStart3DSound(pPlayer.pSprite, 782, -1, 0);
        return true;
    }

    public static boolean PickupWeapon(PLAYER pPlayer, int nSprite, int nWeaponItem) {
        WEAPONITEMDATA pWeaponData = Actor.gWeaponItemData[nWeaponItem - 40];
        int nWeapon = pWeaponData.weaponType;
        int nAmmo = pWeaponData.ammoType;
        BloodSprite pSprite = Main.boardService.getSprite(nSprite);
        XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
        if (pPlayer.hasWeapon[nWeapon] && Globals.pGameInfo.nWeaponSettings != 2 && Globals.pGameInfo.nWeaponSettings != 3) {
            if (Actor.actGetRespawnTime(Main.boardService.getSprite(nSprite)) != 0) {
                if (nAmmo == -1 || !Globals.gInfiniteAmmo && pPlayer.ammoCount[nAmmo] >= PLAYER.gAmmoInfo[nAmmo].max) {
                    return false;
                }
                pPlayer.ammoCount[nAmmo] = pXSprite == null || pXSprite.getData1() <= 0 ? Gameutils.ClipHigh(pPlayer.ammoCount[nAmmo] + pWeaponData.count, PLAYER.gAmmoInfo[nAmmo].max) : Gameutils.ClipHigh(pPlayer.ammoCount[nAmmo] + pXSprite.getData1(), PLAYER.gAmmoInfo[nAmmo].max);
                SOUND.sfxStart3DSound(pPlayer.pSprite, 777, -1, 0);
                return true;
            }
            return false;
        }
        if (Main.boardService.getSprite(nSprite).getLotag() != 50 || Globals.pGameInfo.nGameType <= 1 || !PLAYER.PickupLeech(pPlayer, null)) {
            int weap;
            pPlayer.hasWeapon[nWeapon] = true;
            if (nAmmo != -1) {
                pPlayer.ammoCount[nAmmo] = pXSprite == null || pXSprite.getData1() <= 0 ? Gameutils.ClipHigh(pPlayer.ammoCount[nAmmo] + pWeaponData.count, PLAYER.gAmmoInfo[nAmmo].max) : Gameutils.ClipHigh(pPlayer.ammoCount[nAmmo] + pXSprite.getData1(), PLAYER.gAmmoInfo[nAmmo].max);
            }
            if ((weap = Weapon.WeaponUpgrade(pPlayer, nWeapon)) != pPlayer.currentWeapon) {
                pPlayer.weaponState = 0;
                pPlayer.updateWeapon = weap;
            }
            SOUND.sfxStart3DSound(pPlayer.pSprite, 777, -1, 0);
            return true;
        }
        return false;
    }

    public static void HandEffectProcess(PLAYER gPlayer) {
        if (gPlayer.pSprite.getStatnum() == 6 && gPlayer.handDamage && Pragmas.mulscale(4L, Gameutils.vRandom(), 15) != 0) {
            gPlayer.handCount = Gameutils.ClipHigh(gPlayer.handCount + Globals.kFrameTicks, 64);
            gPlayer.blindEffect = Gameutils.ClipHigh(gPlayer.blindEffect + 2 * Globals.kFrameTicks, 128);
        }
    }

    public static void playerMove(PLAYER pPlayer) {
        int nSprite = pPlayer.nSprite;
        BloodSprite pSprite = pPlayer.pSprite;
        XSPRITE pXSprite = pPlayer.pXsprite;
        POSTURE cp = Globals.gPosture[pPlayer.nLifeMode][pPlayer.moveState];
        PLAYER.powerupProcess(pPlayer);
        PLAYER.HandEffectProcess(pPlayer);
        Gameutils.GetSpriteExtents(pSprite);
        int clipDist = pSprite.getClipdist() << 2;
        int floorDist = (Gameutils.extents_zBot - pSprite.getZ()) / 4;
        int ceilDist = (pSprite.getZ() - Gameutils.extents_zTop) / 4;
        if (!Globals.gNoClip) {
            short nSector = pSprite.getSectnum();
            int push = Main.engine.pushmove(pSprite.getX(), pSprite.getY(), pSprite.getZ(), nSector, clipDist, ceilDist, floorDist, 65537);
            pSprite.setX(Engine.pushmove_x);
            pSprite.setY(Engine.pushmove_y);
            pSprite.setZ(Engine.pushmove_z);
            nSector = Engine.pushmove_sectnum;
            if (push == -1) {
                Actor.actDamageSprite(nSprite, pSprite, 0, 8000);
            }
            if (nSector != pSprite.getSectnum()) {
                if (nSector == -1) {
                    nSector = pSprite.getSectnum();
                    Actor.actDamageSprite(pSprite.getXvel(), pSprite, 0, 8000);
                }
                if (!Main.boardService.isValidSector(nSector)) {
                    throw new AssertException("boardService.isValidSector(nSector)");
                }
                Main.engine.changespritesect((short)nSprite, nSector);
            }
        }
        PLAYER.ProcessInput(pPlayer);
        int moveDist = EngineUtils.qdist(pSprite.getVelocityX(), pSprite.getVelocityY()) >> 16;
        pPlayer.viewOffdZ += Pragmas.mulscale(28672L, pSprite.getVelocityZ() - (long)pPlayer.viewOffdZ, 16);
        int dZv = pSprite.getZ() - cp.viewSpeed - pPlayer.viewOffZ;
        pPlayer.viewOffdZ = dZv > 0 ? (pPlayer.viewOffdZ += Pragmas.mulscale(40960L, (long)dZv << 8, 16)) : (pPlayer.viewOffdZ += Pragmas.mulscale(6144L, (long)dZv << 8, 16));
        pPlayer.viewOffZ += pPlayer.viewOffdZ >> 8;
        pPlayer.weapOffdZ += Pragmas.mulscale(20480L, pSprite.getVelocityZ() - (long)pPlayer.weapOffdZ, 16);
        int dZw = pSprite.getZ() - cp.weapSpeed - pPlayer.weaponAboveZ;
        pPlayer.weapOffdZ = dZw > 0 ? (pPlayer.weapOffdZ += Pragmas.mulscale(32768L, (long)dZw << 8, 16)) : (pPlayer.weapOffdZ += Pragmas.mulscale(3072L, (long)dZw << 8, 16));
        pPlayer.weaponAboveZ += pPlayer.weapOffdZ >> 8;
        pPlayer.bobAmp = Gameutils.ClipLow(pPlayer.bobAmp - Globals.kFrameTicks, 0);
        if (pPlayer.moveState == 1) {
            pPlayer.bobPhase = pPlayer.bobPhase + Globals.kFrameTicks * 2048 / 120 / 4 & 0x7FF;
            pPlayer.swayPhase = pPlayer.swayPhase + Globals.kFrameTicks * 2048 / 120 / 4 & 0x7FF;
            pPlayer.bobHeight = Pragmas.mulscale((long)cp.bobV * 10L, Trig.Sin(pPlayer.bobPhase * 2), 30);
            pPlayer.bobWidth = Pragmas.mulscale((long)cp.bobH * (long)pPlayer.bobAmp, Trig.Sin(pPlayer.bobPhase - 256), 30);
            pPlayer.swayHeight = Pragmas.mulscale((long)cp.swayV * (long)pPlayer.bobAmp, Trig.Sin(pPlayer.swayPhase * 2), 30);
            pPlayer.swayWidth = Pragmas.mulscale((long)cp.swayH * (long)pPlayer.bobAmp, Trig.Sin(pPlayer.swayPhase - 341), 30);
        } else if (pXSprite.getHeight() < 256) {
            boolean Run = false;
            pPlayer.bobPhase = pPlayer.bobPhase + Globals.kFrameTicks * cp.pace[Run ? 1 : 0] & 0x7FF;
            pPlayer.swayPhase = pPlayer.swayPhase + Globals.kFrameTicks * cp.pace[Run ? 1 : 0] / 2 & 0x7FF;
            if (Run) {
                if (pPlayer.bobAmp < 60) {
                    pPlayer.bobAmp = Gameutils.ClipHigh(pPlayer.bobAmp + moveDist, 60);
                }
            } else if (pPlayer.bobAmp < 30) {
                pPlayer.bobAmp = Gameutils.ClipHigh(pPlayer.bobAmp + moveDist, 30);
            }
            pPlayer.bobHeight = Pragmas.mulscale((long)cp.bobV * (long)pPlayer.bobAmp, Trig.Sin(pPlayer.bobPhase * 2), 30);
            pPlayer.bobWidth = Pragmas.mulscale((long)cp.bobH * (long)pPlayer.bobAmp, Trig.Sin(pPlayer.bobPhase - 256), 30);
            pPlayer.swayHeight = Pragmas.mulscale((long)cp.swayV * (long)pPlayer.bobAmp, Trig.Sin(pPlayer.swayPhase * 2), 30);
            pPlayer.swayWidth = Pragmas.mulscale((long)cp.swayH * (long)pPlayer.bobAmp, Trig.Sin(pPlayer.swayPhase - 341), 30);
        }
        pPlayer.explosion = 0;
        pPlayer.quakeTime = Gameutils.ClipLow(pPlayer.quakeTime - Globals.kFrameTicks, 0);
        pPlayer.tilt = Gameutils.ClipLow(pPlayer.tilt - Globals.kFrameTicks, 0);
        pPlayer.visibility = Gameutils.ClipLow(pPlayer.visibility - Globals.kFrameTicks, 0);
        pPlayer.hitEffect = Gameutils.ClipLow(pPlayer.hitEffect - Globals.kFrameTicks, 0);
        pPlayer.blindEffect = Gameutils.ClipLow(pPlayer.blindEffect - Globals.kFrameTicks, 0);
        pPlayer.pickupEffect = Gameutils.ClipLow(pPlayer.pickupEffect - Globals.kFrameTicks, 0);
        if (pXSprite.getHealth() == 0) {
            if (pPlayer == Globals.gMe) {
                Globals.gMe.handDamage = false;
            }
            return;
        }
        pPlayer.Underwater = false;
        if (pPlayer.moveState == 1) {
            short type;
            pPlayer.Underwater = true;
            if (Warp.gLowerLink[pSprite.getSectnum()] > 0 && ((type = Main.boardService.getSprite(Warp.gLowerLink[pSprite.getSectnum()]).getLotag()) == 14 || type == 10) && Main.engine.getceilzofslope(pSprite.getSectnum(), pSprite.getX(), pSprite.getY()) > pPlayer.viewOffZ) {
                pPlayer.Underwater = false;
            }
        }
        if (!pPlayer.Underwater) {
            pPlayer.airTime = 1200;
            pPlayer.drownEffect = 0;
            if (PLAYER.inventoryCheck(pPlayer, 1)) {
                PLAYER.processInventory(pPlayer, 1);
            }
        }
        int dudeIndex = 31;
        short nXSprite = pSprite.getExtra();
        if (nXSprite == -1) {
            return;
        }
        switch (pPlayer.moveState) {
            case 0: {
                if (moveDist == 0) {
                    SeqHandling.seqSpawn(DudeInfo.dudeInfo[dudeIndex].seqStartID + VERSION.getPlayerSeq(0), 3, nXSprite, null);
                    break;
                }
                SeqHandling.seqSpawn(DudeInfo.dudeInfo[dudeIndex].seqStartID + VERSION.getPlayerSeq(6), 3, nXSprite, null);
                break;
            }
            case 1: {
                SeqHandling.seqSpawn(DudeInfo.dudeInfo[dudeIndex].seqStartID + VERSION.getPlayerSeq(7), 3, nXSprite, null);
                break;
            }
            case 2: 
            case 3: {
                SeqHandling.seqSpawn(DudeInfo.dudeInfo[dudeIndex].seqStartID + VERSION.getPlayerSeq(8), 3, nXSprite, null);
            }
        }
    }

    public static Sprite playerFireThing(PLAYER pPlayer, int xoffset, int relSlope, int thingType, int velocity) {
        if (thingType < 400 || thingType >= 436) {
            throw new AssertException("thingType >= kThingBase && thingType < kThingMax");
        }
        int z = pPlayer.weaponAboveZ - pPlayer.pSprite.getZ();
        if (newHoriz && !DemoUtils.IsOriginalDemo()) {
            z = (int)((float)z + 10.0f * pPlayer.horiz);
        }
        return Actor.actFireThing(pPlayer.nSprite, xoffset, z, (int)pPlayer.horizOff + relSlope, thingType, velocity);
    }

    public static Sprite playerFireMissile(PLAYER pPlayer, int xoffset, int dx, int dy, int dz, int missileType) {
        int z = pPlayer.weaponAboveZ - pPlayer.pSprite.getZ();
        if (newHoriz && !DemoUtils.IsOriginalDemo()) {
            z -= (int)(20.0f * pPlayer.horiz);
        }
        return Actor.actFireMissile(pPlayer.pSprite, xoffset, z, dx, dy, dz, missileType);
    }

    public static int playerCalcDamage(PLAYER pPlayer, int nDamageType, int nDamage) {
        int nArmorType = PLAYER.gDamageInfo[nDamageType].nArmorType;
        if (nArmorType >= 0 && pPlayer.ArmorAmount[nArmorType] != 0) {
            int tmp = nDamage / 4;
            int damage = tmp + Pragmas.muldiv(pPlayer.ArmorAmount[nArmorType], 7L * (long)nDamage / 8L - (long)tmp, 3200L);
            nDamage -= damage;
            pPlayer.ArmorAmount[nArmorType] = Gameutils.ClipLow(pPlayer.ArmorAmount[nArmorType] - damage, 0);
        }
        return nDamage;
    }

    public static void playerDamageSprite(PLAYER pPlayer, int nSource, int nDamageType, int nDamage) {
        if (!Main.boardService.isValidSprite(nSource)) {
            throw new AssertException("isValidSprite(nSource)");
        }
        if (pPlayer == null) {
            throw new AssertException("pPlayer != NULL");
        }
        if (nDamageType < 0 || nDamageType >= 7) {
            throw new AssertException("nDamageType >= 0 && nDamageType < kDamageMax");
        }
        if (pPlayer.damageShift[nDamageType] == 0) {
            int nDeathSeqID = -1;
            nDamage = PLAYER.playerCalcDamage(pPlayer, nDamageType, nDamage);
            pPlayer.hitEffect = Gameutils.ClipHigh(pPlayer.hitEffect + (nDamage >> 3), 600);
            BloodSprite pSprite = pPlayer.pSprite;
            XSPRITE pXSprite = pPlayer.pXsprite;
            if (pSprite == null || !Actor.IsDudeSprite(pSprite)) {
                return;
            }
            DudeInfo pDudeInfo = DudeInfo.dudeInfo[pSprite.getLotag() - 200];
            CALLPROC nCallback = null;
            if (pXSprite.getHealth() == 0) {
                if (PLAYER.checkPlayerSeq(pPlayer, VERSION.getPlayerSeq(12))) {
                    if (Globals.pGameInfo.nGameType == 1 && Globals.pGameInfo.nReviveMode) {
                        return;
                    }
                    switch (nDamageType) {
                        case 3: {
                            Gib.actGenerateGibs(pSprite, 7, null, null);
                            Gib.actGenerateGibs(pSprite, 15, null, null);
                            pSprite.setCstat(pSprite.getCstat() | 0x8000);
                            nDeathSeqID = VERSION.getPlayerSeq(13);
                            break;
                        }
                        case 5: {
                            nDeathSeqID = VERSION.getPlayerSeq(14);
                            SOUND.sfxStart3DSound(pSprite, 716, 0, 0);
                            break;
                        }
                        default: {
                            Gameutils.GetSpriteExtents(pSprite);
                            Gib.startPos.set(pSprite.getX(), pSprite.getY(), Gameutils.extents_zTop);
                            Gib.startVel.set(pSprite.getVelocityX() >> 1, pSprite.getVelocityY() >> 1, -838860.0f);
                            Gib.actGenerateGibs(pSprite, 27, Gib.startPos, Gib.startVel);
                            Gib.actGenerateGibs(pSprite, 7, null, null);
                            Actor.actSpawnBlood(pSprite);
                            Actor.actSpawnBlood(pSprite);
                            nDeathSeqID = VERSION.getPlayerSeq(13);
                            break;
                        }
                    }
                }
            } else {
                int dHealth = pXSprite.getHealth() - nDamage;
                pXSprite.setHealth(Gameutils.ClipLow(dHealth, 0));
                if (pXSprite.getHealth() != 0 && pXSprite.getHealth() < 16) {
                    pXSprite.setHealth(0);
                    dHealth = -25;
                    nDamageType = 2;
                }
                if (pXSprite.getHealth() == 0) {
                    if (Globals.pGameInfo.nGameType == 3 && pPlayer.hasFlag != 0) {
                        Sprite nFlag;
                        if ((pPlayer.hasFlag & 1) != 0) {
                            pPlayer.hasFlag &= 0xFFFFFFFE;
                            nFlag = Actor.DropPickupObject(pPlayer.pSprite, 147);
                            if (nFlag != null) {
                                nFlag.setOwner(pPlayer.nBlueTeam);
                            }
                            SOUND.sndStartSample(8005, 255, 2, false);
                            View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " dropped Blue Flag", -1, 10);
                        }
                        if ((pPlayer.hasFlag & 2) != 0) {
                            pPlayer.hasFlag &= 0xFFFFFFFD;
                            nFlag = Actor.DropPickupObject(pPlayer.pSprite, 148);
                            if (nFlag != null) {
                                nFlag.setOwner(pPlayer.nRedTeam);
                            }
                            SOUND.sndStartSample(8004, 255, 2, false);
                            View.viewSetMessage(Main.game.net.gProfile[pPlayer.nPlayer].name + " dropped Red Flag", -1, 7);
                        }
                    }
                    SOUND.sfxKill3DSound(pPlayer.pSprite, -1, 441);
                    pPlayer.deathTime = 0;
                    if (Globals.pGameInfo.nGameType == 0 || pPlayer.currentWeapon != 6 && pPlayer.currentWeapon != 7 || pPlayer.weaponTimer == 0) {
                        pPlayer.fLoopQAV = false;
                        pPlayer.currentWeapon = 0;
                        pPlayer.LastWeapon = 0;
                    }
                    pPlayer.CrouchMode = 0;
                    pPlayer.fraggerID = nSource;
                    pPlayer.voodooCount = 0;
                    if (nDamageType == 3 && nDamage < 144) {
                        nDamageType = 0;
                    }
                    if (Globals.pGameInfo.nGameType == 1 && Globals.pGameInfo.nReviveMode) {
                        SOUND.sfxStart3DSound(pSprite, PLAYER.gDamageInfo[nDamageType].nSoundID[3], 0, 2);
                        nDeathSeqID = VERSION.getPlayerSeq(12);
                        pXSprite.setTarget(nSource);
                    } else {
                        switch (nDamageType) {
                            case 1: {
                                SOUND.sfxStart3DSound(pSprite, 718, 0, 0);
                                nDeathSeqID = VERSION.getPlayerSeq(3);
                                break;
                            }
                            case 3: {
                                SOUND.sfxStart3DSound(pSprite, 717, 0, 0);
                                Gib.actGenerateGibs(pSprite, 7, null, null);
                                Gib.actGenerateGibs(pSprite, 15, null, null);
                                nDeathSeqID = VERSION.getPlayerSeq(2);
                                pSprite.setCstat(pSprite.getCstat() | 0x8000);
                                break;
                            }
                            case 4: {
                                nDeathSeqID = VERSION.getPlayerSeq(1);
                                break;
                            }
                            default: {
                                if (dHealth < -20 && Globals.pGameInfo.nGameType >= 2 && Gameutils.Chance(8192)) {
                                    nCallback = SeqHandling.callbacks[12];
                                    SOUND.sfxStart3DSound(pSprite, PLAYER.gDamageInfo[nDamageType].nSoundID[3], 0, 2);
                                    nDeathSeqID = VERSION.getPlayerSeq(12);
                                    PLAYER.powerupActivate(pPlayer, 28);
                                    pXSprite.setTarget(nSource);
                                    EVENT.evPostCallback(pSprite.getXvel(), 3, 15L, 13);
                                    break;
                                }
                                SOUND.sfxStart3DSound(pSprite, 716, 0, 0);
                                nDeathSeqID = VERSION.getPlayerSeq(1);
                                break;
                            }
                        }
                    }
                } else {
                    DAMAGEINFO pDamageInfo = gDamageInfo[nDamageType];
                    int nSoundID = nDamage < 160 ? pDamageInfo.nSoundID[Gameutils.Random(3)] : pDamageInfo.nSoundID[0];
                    if (nDamageType == 4 && Globals.gPlayer[View.gViewIndex].pXsprite.getPalette() == 1 && !pPlayer.handDamage) {
                        nSoundID = 714;
                    }
                    SOUND.sfxStart3DSound(pSprite, nSoundID, 0, 6);
                    return;
                }
            }
            if (nDeathSeqID >= 0) {
                if (nDeathSeqID != VERSION.getPlayerSeq(12) || Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1) {
                    short nXSector = Main.boardService.getSector(pSprite.getSectnum()).getExtra();
                    PLAYER.powerupClear(pPlayer);
                    if (nXSector > 0 && DB.xsector[nXSector].Exit) {
                        Trigger.trTriggerSector(pSprite.getSectnum(), DB.xsector[nXSector], 43);
                    }
                    pSprite.setHitag(pSprite.getHitag() | 7);
                    short i = Mmulti.connecthead;
                    while (i >= 0) {
                        if (pSprite.getXvel() == Globals.gPlayer[i].fraggerID && Globals.gPlayer[i].deathTime > 0) {
                            Globals.gPlayer[i].fraggerID = -1;
                        }
                        i = Mmulti.connectpoint2[i];
                    }
                    PLAYER.playerFrag(pPlayer, nSource);
                    Trigger.trTriggerSprite(pSprite.getXvel(), pXSprite, 0);
                }
                if (!Main.game.getCache().getEntry(pDudeInfo.seqStartID + nDeathSeqID, "SEQ").exists()) {
                    throw new AssertException("gSysRes.Lookup(pDudeInfo.seqStartID + nDeathSeqID, \"SEQ\") != null");
                }
                SeqHandling.seqSpawn(pDudeInfo.seqStartID + nDeathSeqID, 3, pSprite.getExtra(), nCallback);
            }
        }
    }

    public static void playerFrag(PLAYER pKiller, PLAYER pVictim) {
        if (pKiller == null) {
            throw new AssertException("pKiller != NULL");
        }
        if (pVictim == null) {
            throw new AssertException("pVictim != NULL");
        }
        int nKiller = pKiller.pSprite.getLotag() - 231;
        if (nKiller < 0 || nKiller >= 8) {
            throw new AssertException("nKiller >= 0 && nKiller < kMaxPlayers");
        }
        int nVictim = pVictim.pSprite.getLotag() - 231;
        if (nVictim < 0 || nVictim >= 8) {
            throw new AssertException("nVictim >= 0 && nVictim < kMaxPlayers");
        }
        if (Mmulti.myconnectindex == Mmulti.connecthead) {
            // empty if block
        }
        if (nKiller == nVictim) {
            pVictim.fraggerID = -1;
            --pVictim.fragCount;
            int n = nKiller;
            pVictim.fragInfo[n] = pVictim.fragInfo[n] - 1;
            if (Globals.pGameInfo.nGameType == 3) {
                int n2 = pVictim.teamID;
                Globals.nTeamCount[n2] = Globals.nTeamCount[n2] - 1;
            }
            int n3 = Gameutils.Random(deathAphorisms1.length);
            if (pVictim.handCount <= 0) {
                String message;
                if (pVictim != Globals.gMe && Globals.pGameInfo.nGameType > 0 && PLAYER.deathAphorisms1[n3].nSound >= 0) {
                    if (Globals.pGameInfo.nGameType != 1) {
                        SOUND.sndStartSample(PLAYER.deathAphorisms1[n3].nSound, 255, 2, false);
                    }
                    message = Main.game.net.gProfile[nVictim].name + PLAYER.deathAphorisms1[n3].text;
                } else {
                    message = "You killed yourself!";
                }
                View.viewSetMessage(message, -1, 7);
            }
        } else {
            ++pKiller.fragCount;
            int n = nVictim;
            pKiller.fragInfo[n] = pKiller.fragInfo[n] + 1;
            if (Globals.pGameInfo.nGameType == 3) {
                if (pKiller.teamID == pVictim.teamID) {
                    int n4 = pKiller.teamID;
                    Globals.nTeamCount[n4] = Globals.nTeamCount[n4] - 1;
                } else {
                    int n5 = pKiller.teamID;
                    Globals.nTeamCount[n5] = Globals.nTeamCount[n5] + 1;
                    int n6 = pKiller.teamID;
                    Globals.nTeamClock[n6] = Globals.nTeamClock[n6] + 120;
                }
            }
            if (Globals.pGameInfo.nGameType > 0) {
                int n7 = Gameutils.Random(deathAphorisms2.length);
                if (Globals.pGameInfo.nGameType > 0 && pKiller == Globals.gMe && PLAYER.deathAphorisms2[n7].nSound >= 0 && Globals.pGameInfo.nGameType != 1) {
                    SOUND.sndStartSample(PLAYER.deathAphorisms2[n7].nSound, 255, 2, false);
                }
                String message = Main.game.net.gProfile[nKiller].name + PLAYER.deathAphorisms2[n7].text + Main.game.net.gProfile[nVictim].name;
                if (PLAYER.deathAphorisms2[n7].text2 != null) {
                    message = message + PLAYER.deathAphorisms2[n7].text2;
                }
                View.viewSetMessage(message, -1, 7);
            }
        }
    }

    public static void playerFrag(PLAYER pVictim, int nKiller) {
        BloodSprite pKiller;
        if (nKiller >= 0 && Actor.IsDudeSprite(pKiller = Main.boardService.getSprite(nKiller))) {
            if (Gameutils.IsPlayerSprite(pKiller)) {
                PLAYER.playerFrag(Globals.gPlayer[pKiller.getLotag() - 231], pVictim);
                int nVictimTeam = pVictim.teamID & 1;
                int nKillerTeam = Globals.gPlayer[pKiller.getLotag() - 231].teamID & 1;
                if (nKillerTeam == 0 && nVictimTeam == 0) {
                    EVENT.evSend(0, 0, 15, 3);
                } else {
                    EVENT.evSend(0, 0, 16, 3);
                }
            } else if (Globals.pGameInfo.nGameType > 0) {
                int n = Gameutils.Random(deathAphorisms2.length);
                String message = DB.kDudeName[pKiller.getLotag() - 200] + PLAYER.deathAphorisms2[n].text + Main.game.net.gProfile[pVictim.nPlayer].name;
                if (PLAYER.deathAphorisms2[n].text2 != null) {
                    message = message + PLAYER.deathAphorisms2[n].text2;
                }
                View.viewSetMessage(message, -1, 7);
            }
        }
        PLAYER.checkFragLimit();
    }

    public static void checkFragLimit() {
        if (Globals.pGameInfo.nFragLimit != 0) {
            int i;
            int nFrags;
            if (Globals.pGameInfo.nGameType == 2) {
                nFrags = 0;
                i = Mmulti.connecthead;
                while (i >= 0) {
                    nFrags = Math.max(nFrags, Globals.gPlayer[i].fragCount);
                    i = Mmulti.connectpoint2[i];
                }
                if (nFrags >= Globals.pGameInfo.nFragLimit) {
                    EVENT.evPostCallback(Globals.gMe.nSprite, 3, 300L, 22);
                }
            }
            if (Globals.pGameInfo.nGameType == 3) {
                nFrags = 0;
                for (i = 0; i < 2; ++i) {
                    nFrags = Math.max(nFrags, Globals.nTeamCount[i]);
                }
                if (nFrags >= Globals.pGameInfo.nFragLimit) {
                    EVENT.evPostCallback(Globals.gMe.nSprite, 3, 300L, 22);
                }
            }
        }
    }

    public static void FReviveCallback(int nXIndex) {
        XSPRITE pXSprite = Main.boardService.getXSprite(nXIndex);
        BloodSprite pSprite = Main.boardService.getSprite(pXSprite.getReference());
        if (Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1) {
            Actor.actHealDude(pXSprite, 30, 30);
        } else {
            Actor.actHealDude(pXSprite, 1, 2);
        }
        if (Globals.pGameInfo.nGameType > 0 && Mmulti.numplayers > 1) {
            SOUND.sfxStart3DSound(pSprite, 3009, 0, 0);
            if (Gameutils.IsPlayerSprite(pSprite)) {
                PLAYER pPlayer = Globals.gPlayer[pSprite.getLotag() - 231];
                String message = pPlayer == Globals.gMe ? "I LIVE...AGAIN!!" : Main.game.net.gProfile[pPlayer.nPlayer].name + " lives again!";
                View.viewSetMessage(message, -1, 10);
                pPlayer.pInput.newWeapon = 1;
            }
        }
    }

    public static void FatalityDeadCallback(int nXIndex) {
        short i = Mmulti.connecthead;
        while (i >= 0) {
            if (Main.boardService.getXSprite(nXIndex) == Globals.gPlayer[i].pXsprite) {
                PLAYER.playerDamageSprite(Globals.gPlayer[i], Globals.gPlayer[i].fraggerID, 5, 8000);
                break;
            }
            i = Mmulti.connectpoint2[i];
        }
    }

    public void copy(PLAYER pPlayer) {
        int i;
        this.pSprite = pPlayer.pSprite;
        this.pXsprite = pPlayer.pXsprite;
        this.pDudeInfo = pPlayer.pDudeInfo;
        this.pInput = pPlayer.pInput;
        this.ang = pPlayer.ang;
        this.pWeaponQAV = pPlayer.pWeaponQAV;
        this.weaponCallback = pPlayer.weaponCallback;
        this.Run = pPlayer.Run;
        this.moveState = pPlayer.moveState;
        this.bobPhase = pPlayer.bobPhase;
        this.bobAmp = pPlayer.bobAmp;
        this.bobHeight = pPlayer.bobHeight;
        this.bobWidth = pPlayer.bobWidth;
        this.swayPhase = pPlayer.swayPhase;
        this.swayAmp = pPlayer.swayAmp;
        this.swayHeight = pPlayer.swayHeight;
        this.swayWidth = pPlayer.swayWidth;
        this.nPlayer = pPlayer.nPlayer;
        this.nSprite = pPlayer.nSprite;
        this.nLifeMode = pPlayer.nLifeMode;
        this.bloodlust = pPlayer.bloodlust;
        this.weapOffdZ = pPlayer.weapOffdZ;
        this.viewOffdZ = pPlayer.viewOffdZ;
        this.weaponAboveZ = pPlayer.weaponAboveZ;
        this.viewOffZ = pPlayer.viewOffZ;
        this.look = pPlayer.look;
        this.horiz = pPlayer.horiz;
        this.slope = pPlayer.slope;
        this.horizOff = pPlayer.horizOff;
        this.Underwater = pPlayer.Underwater;
        this.hasFlag = pPlayer.hasFlag;
        this.nBlueTeam = pPlayer.nBlueTeam;
        this.nRedTeam = pPlayer.nRedTeam;
        System.arraycopy(pPlayer.hasKey, 0, this.hasKey, 0, 8);
        System.arraycopy(pPlayer.damageShift, 0, this.damageShift, 0, 7);
        this.CrouchMode = pPlayer.CrouchMode;
        this.LastWeapon = pPlayer.LastWeapon;
        this.currentWeapon = pPlayer.currentWeapon;
        this.updateWeapon = pPlayer.updateWeapon;
        this.weaponTimer = pPlayer.weaponTimer;
        this.weaponState = pPlayer.weaponState;
        this.weaponAmmo = pPlayer.weaponAmmo;
        for (i = 0; i < 14; ++i) {
            this.weaponMode[i] = pPlayer.weaponMode[i];
            this.hasWeapon[i] = pPlayer.hasWeapon[i];
            this.weaponOrder[0][i] = pPlayer.weaponOrder[0][i];
            this.weaponOrder[1][i] = pPlayer.weaponOrder[1][i];
        }
        System.arraycopy(pPlayer.ammoCount, 0, this.ammoCount, 0, 12);
        this.fLoopQAV = pPlayer.fLoopQAV;
        this.fuseTime = pPlayer.fuseTime;
        this.fireClock = pPlayer.fireClock;
        this.throwTime = pPlayer.throwTime;
        this.aim = pPlayer.aim;
        this.relAim = pPlayer.relAim;
        this.nAimSprite = pPlayer.nAimSprite;
        this.aimCount = pPlayer.aimCount;
        System.arraycopy(pPlayer.aimSprites, 0, this.aimSprites, 0, 16);
        this.deathTime = pPlayer.deathTime;
        System.arraycopy(pPlayer.powerUpTimer, 0, this.powerUpTimer, 0, 49);
        this.fragCount = pPlayer.fragCount;
        System.arraycopy(pPlayer.fragInfo, 0, this.fragInfo, 0, 8);
        this.teamID = pPlayer.teamID;
        this.fraggerID = pPlayer.fraggerID;
        this.airTime = pPlayer.airTime;
        this.bloodTime = pPlayer.bloodTime;
        this.gooTime = pPlayer.gooTime;
        this.wetTime = pPlayer.wetTime;
        this.bubbleTime = pPlayer.bubbleTime;
        this.stayTime = pPlayer.stayTime;
        this.kickTime = pPlayer.kickTime;
        this.pLaughsCount = pPlayer.pLaughsCount;
        this.TurnAround = pPlayer.TurnAround;
        this.godMode = pPlayer.godMode;
        this.fScreamed = pPlayer.fScreamed;
        this.pJump = pPlayer.pJump;
        this.showInventory = pPlayer.showInventory;
        this.choosedInven = pPlayer.choosedInven;
        for (i = 0; i < 6; ++i) {
            this.Inventory[i].activated = pPlayer.Inventory[i].activated;
            this.Inventory[i].amount = pPlayer.Inventory[i].amount;
        }
        System.arraycopy(pPlayer.ArmorAmount, 0, this.ArmorAmount, 0, 3);
        this.voodooTarget = pPlayer.voodooTarget;
        this.voodooCount = pPlayer.voodooCount;
        this.voodooAng = pPlayer.voodooAng;
        this.voodooUnk = pPlayer.voodooUnk;
        this.explosion = pPlayer.explosion;
        this.tilt = pPlayer.tilt;
        this.visibility = pPlayer.visibility;
        this.fireEffect = pPlayer.fireEffect;
        this.hitEffect = pPlayer.hitEffect;
        this.blindEffect = pPlayer.blindEffect;
        this.drownEffect = pPlayer.drownEffect;
        this.handCount = pPlayer.handCount;
        this.handDamage = pPlayer.handDamage;
        this.pickupEffect = pPlayer.pickupEffect;
        this.quakeTime = pPlayer.quakeTime;
        this.lookang = pPlayer.lookang;
        this.rotscrnang = pPlayer.rotscrnang;
    }

    public void reset() {
        int i;
        this.pSprite = null;
        this.pXsprite = null;
        this.pDudeInfo = null;
        this.pInput.reset();
        this.ang = 0.0f;
        this.pWeaponQAV = 0;
        this.weaponCallback = 0;
        this.Run = false;
        this.moveState = 0;
        this.bobPhase = 0;
        this.bobAmp = 0;
        this.bobHeight = 0;
        this.bobWidth = 0;
        this.swayPhase = 0;
        this.swayAmp = 0;
        this.swayHeight = 0;
        this.swayWidth = 0;
        this.nPlayer = 0;
        this.nSprite = 0;
        this.nLifeMode = 0;
        this.bloodlust = 0;
        this.weapOffdZ = 0;
        this.viewOffdZ = 0;
        this.weaponAboveZ = 0;
        this.viewOffZ = 0;
        this.look = 0.0f;
        this.horiz = 0.0f;
        this.slope = 0;
        this.horizOff = 0.0f;
        this.Underwater = false;
        for (i = 0; i < 8; ++i) {
            this.hasKey[i] = false;
        }
        for (i = 0; i < 7; ++i) {
            this.damageShift[i] = 0;
        }
        this.CrouchMode = 0;
        this.LastWeapon = 0;
        this.currentWeapon = 0;
        this.updateWeapon = 0;
        this.weaponTimer = 0;
        this.weaponState = 0;
        this.weaponAmmo = 0;
        for (i = 0; i < 14; ++i) {
            this.weaponMode[i] = 0;
            this.hasWeapon[i] = false;
            this.weaponOrder[0][i] = 0;
            this.weaponOrder[1][i] = 0;
        }
        for (i = 0; i < 12; ++i) {
            this.ammoCount[i] = 0;
        }
        this.fLoopQAV = false;
        this.fuseTime = 0;
        this.fireClock = 0;
        this.throwTime = 0;
        this.aim.set(0.0f, 0.0f, 0.0f);
        this.relAim.set(0.0f, 0.0f, 0.0f);
        this.nAimSprite = 0;
        this.aimCount = 0;
        for (i = 0; i < 16; ++i) {
            this.aimSprites[i] = 0;
        }
        this.deathTime = 0;
        for (i = 0; i < 49; ++i) {
            this.powerUpTimer[i] = 0;
        }
        this.fragCount = 0;
        for (i = 0; i < 8; ++i) {
            this.fragInfo[i] = 0;
        }
        this.teamID = 0;
        this.fraggerID = 0;
        this.airTime = 0;
        this.bloodTime = 0;
        this.gooTime = 0;
        this.wetTime = 0;
        this.bubbleTime = 0;
        this.kickTime = 0;
        this.stayTime = 0;
        this.pLaughsCount = 0;
        this.TurnAround = 0;
        this.godMode = false;
        this.fScreamed = false;
        this.pJump = false;
        this.showInventory = 0;
        this.choosedInven = 0;
        for (i = 0; i < 6; ++i) {
            this.Inventory[i].activated = false;
            this.Inventory[i].amount = 0;
        }
        for (i = 0; i < 3; ++i) {
            this.ArmorAmount[i] = 0;
        }
        this.voodooTarget = 0;
        this.voodooCount = 0;
        this.voodooAng = 0;
        this.voodooUnk = 0;
        this.explosion = 0;
        this.tilt = 0;
        this.visibility = 0;
        this.fireEffect = 0;
        this.hitEffect = 0;
        this.blindEffect = 0;
        this.drownEffect = 0;
        this.handCount = 0;
        this.handDamage = false;
        this.pickupEffect = 0;
        this.quakeTime = 0;
        this.lookang = 0;
        this.rotscrnang = 0;
    }

    public String toString() {
        int j;
        StringBuilder out = new StringBuilder("NPSTART " + this.NPSTART + " \r\n");
        out.append("pWeaponQAV ").append(this.pWeaponQAV).append(" \r\n");
        out.append("weaponCallback ").append(this.weaponCallback).append(" \r\n");
        out.append("Run ").append(this.Run).append(" \r\n");
        out.append("moveState ").append(this.moveState).append(" \r\n");
        out.append("moveDist ").append(this.moveDist).append(" \r\n");
        out.append("bobAmp ").append(this.bobAmp).append(" \r\n");
        out.append("bobPhase ").append(this.bobPhase).append(" \r\n");
        out.append("bobHeight ").append(this.bobHeight).append(" \r\n");
        out.append("bobWidth ").append(this.bobWidth).append(" \r\n");
        out.append("swayAmp ").append(this.swayAmp).append(" \r\n");
        out.append("swayPhase ").append(this.swayPhase).append(" \r\n");
        out.append("swayHeight ").append(this.swayHeight).append(" \r\n");
        out.append("swayWidth ").append(this.swayWidth).append(" \r\n");
        out.append("nPlayer ").append(this.nPlayer).append(" \r\n");
        out.append("nSprite ").append(this.nSprite).append(" \r\n");
        out.append("nLifeMode ").append(this.nLifeMode).append(" \r\n");
        out.append("bloodlust ").append(this.bloodlust).append(" \r\n");
        out.append("viewOffZ ").append(this.viewOffZ).append(" \r\n");
        out.append("viewOffdZ ").append(this.viewOffdZ).append(" \r\n");
        out.append("weaponAboveZ ").append(this.weaponAboveZ).append(" \r\n");
        out.append("weapOffdZ ").append(this.weapOffdZ).append(" \r\n");
        out.append("look ").append(this.look).append(" \r\n");
        out.append("horiz ").append(this.horiz).append(" \r\n");
        out.append("slope ").append(this.slope).append(" \r\n");
        out.append("horizOff ").append(this.horizOff).append(" \r\n");
        out.append("Underwater ").append(this.Underwater).append(" \r\n");
        for (j = 0; j < 8; ++j) {
            out.append("hasKey[").append(j).append("] ").append(this.hasKey[j]).append(" \r\n");
        }
        out.append("hasFlag ").append(this.hasFlag).append(" \r\n");
        out.append("nBlueTeam ").append(this.nBlueTeam).append(" \r\n");
        out.append("nRedTeam ").append(this.nRedTeam).append(" \r\n");
        for (j = 0; j < 7; ++j) {
            out.append("damageShift[").append(j).append("] ").append(this.damageShift[j]).append(" \r\n");
        }
        out.append("currentWeapon ").append(this.currentWeapon).append(" \r\n");
        out.append("updateWeapon ").append(this.updateWeapon).append(" \r\n");
        out.append("weaponTimer ").append(this.weaponTimer).append(" \r\n");
        out.append("weaponState ").append(this.weaponState).append(" \r\n");
        out.append("weaponAmmo ").append(this.weaponAmmo).append(" \r\n");
        for (j = 0; j < 14; ++j) {
            out.append("hasWeapon[").append(j).append("] ").append(this.hasWeapon[j]).append(" \r\n");
        }
        for (j = 0; j < 14; ++j) {
            out.append("weaponMode[").append(j).append("] ").append(this.weaponMode[j]).append(" \r\n");
        }
        for (j = 0; j < 14; ++j) {
            out.append("weaponOrder[0][").append(j).append("] ").append(this.weaponOrder[0][j]).append(" \r\n");
        }
        for (j = 0; j < 14; ++j) {
            out.append("weaponOrder[1][").append(j).append("] ").append(this.weaponOrder[1][j]).append(" \r\n");
        }
        for (j = 0; j < 12; ++j) {
            out.append("ammoCount[").append(j).append("] ").append(this.ammoCount[j]).append(" \r\n");
        }
        out.append("fLoopQAV ").append(this.fLoopQAV).append(" \r\n");
        out.append("fuseTime ").append(this.fuseTime).append(" \r\n");
        out.append("fireClock ").append(this.fireClock).append(" \r\n");
        out.append("throwTime ").append(this.throwTime).append(" \r\n");
        out.append("aim[").append(this.aim.x).append(", ").append(this.aim.y).append(", ").append(this.aim.z).append("] \r\n");
        out.append("relAim[").append(this.relAim.x).append(", ").append(this.relAim.y).append(", ").append(this.relAim.z).append("] \r\n");
        out.append("nAimSprite ").append(this.nAimSprite).append(" \r\n");
        out.append("aimCount ").append(this.aimCount).append(" \r\n");
        for (j = 0; j < 16; ++j) {
            out.append("aimSprites[").append(j).append("] ").append(this.aimSprites[j]).append(" \r\n");
        }
        out.append("deathTime ").append(this.deathTime).append(" \r\n");
        for (j = 0; j < 49; ++j) {
            out.append("powerUpTimer[").append(j).append("] ").append(this.powerUpTimer[j]).append(" \r\n");
        }
        out.append("fragCount ").append(this.fragCount).append(" \r\n");
        for (j = 0; j < 8; ++j) {
            out.append("fragInfo[").append(j).append("] ").append(this.fragInfo[j]).append(" \r\n");
        }
        out.append("teamID ").append(this.teamID).append(" \r\n");
        out.append("fraggerID ").append(this.fraggerID).append(" \r\n");
        out.append("airTime ").append(this.airTime).append(" \r\n");
        out.append("bloodTime ").append(this.bloodTime).append(" \r\n");
        out.append("gooTime ").append(this.gooTime).append(" \r\n");
        out.append("wetTime ").append(this.wetTime).append(" \r\n");
        out.append("bubbleTime ").append(this.bubbleTime).append(" \r\n");
        out.append("stayTime ").append(this.stayTime).append(" \r\n");
        out.append("kickTime ").append(this.kickTime).append(" \r\n");
        out.append("pLaughsCount ").append(this.pLaughsCount).append(" \r\n");
        out.append("TurnAround ").append(this.TurnAround).append(" \r\n");
        out.append("godMode ").append(this.godMode).append(" \r\n");
        out.append("fScreamed ").append(this.fScreamed).append(" \r\n");
        out.append("pJump ").append(this.pJump).append(" \r\n");
        out.append("showInventory ").append(this.showInventory).append(" \r\n");
        out.append("choosedInven ").append(this.choosedInven).append(" \r\n");
        for (j = 0; j < 5; ++j) {
            out.append("Inventory[").append(j).append("].activated ").append(this.Inventory[j].activated).append(" \r\n");
            out.append("Inventory[").append(j).append("].amount ").append(this.Inventory[j].amount).append(" \r\n");
        }
        for (j = 0; j < 3; ++j) {
            out.append("ArmorAmount[").append(j).append("] ").append(this.ArmorAmount[j]).append(" \r\n");
        }
        out.append("voodooTarget ").append(this.voodooTarget).append(" \r\n");
        out.append("voodooCount ").append(this.voodooCount).append(" \r\n");
        out.append("voodooAng ").append(this.voodooAng).append(" \r\n");
        out.append("voodooUnk ").append(this.voodooUnk).append(" \r\n");
        out.append("explosion ").append(this.explosion).append(" \r\n");
        out.append("tilt ").append(this.tilt).append(" \r\n");
        out.append("visibility ").append(this.visibility).append(" \r\n");
        out.append("hitEffect ").append(this.hitEffect).append(" \r\n");
        out.append("blindEffect ").append(this.blindEffect).append(" \r\n");
        out.append("drownEffect ").append(this.drownEffect).append(" \r\n");
        out.append("handCount ").append(this.handCount).append(" \r\n");
        out.append("handDamage ").append(this.handDamage).append(" \r\n");
        out.append("pickupEffect ").append(this.pickupEffect).append(" \r\n");
        out.append("fireEffect ").append(this.fireEffect).append(" \r\n");
        out.append("quakeTime ").append(this.quakeTime).append(" \r\n");
        return out.toString();
    }

    @Override
    public PLAYER readObject(InputStream is) throws IOException {
        int j;
        this.NPSTART = StreamUtils.readInt(is);
        this.pWeaponQAV = StreamUtils.readInt(is);
        this.weaponCallback = StreamUtils.readInt(is);
        this.Run = StreamUtils.readBoolean(is);
        this.moveState = StreamUtils.readInt(is);
        this.moveDist = StreamUtils.readInt(is);
        this.bobAmp = StreamUtils.readInt(is);
        this.bobPhase = StreamUtils.readInt(is);
        this.bobHeight = StreamUtils.readInt(is);
        this.bobWidth = StreamUtils.readInt(is);
        this.swayAmp = StreamUtils.readInt(is);
        this.swayPhase = StreamUtils.readInt(is);
        this.swayHeight = StreamUtils.readInt(is);
        this.swayWidth = StreamUtils.readInt(is);
        this.nPlayer = StreamUtils.readInt(is);
        this.nSprite = StreamUtils.readInt(is);
        this.nLifeMode = StreamUtils.readInt(is);
        this.bloodlust = StreamUtils.readInt(is);
        this.viewOffZ = StreamUtils.readInt(is);
        this.viewOffdZ = StreamUtils.readInt(is);
        this.weaponAboveZ = StreamUtils.readInt(is);
        this.weapOffdZ = StreamUtils.readInt(is);
        if (this.nVersion < 300) {
            this.look = StreamUtils.readInt(is);
            this.horiz = StreamUtils.readInt(is);
        } else {
            this.look = StreamUtils.readFloat(is);
            this.horiz = StreamUtils.readFloat(is);
        }
        this.slope = StreamUtils.readInt(is);
        this.horizOff = this.nVersion < 300 ? (float)StreamUtils.readInt(is) : StreamUtils.readFloat(is);
        this.Underwater = StreamUtils.readBoolean(is);
        for (j = 0; j < 8; ++j) {
            this.hasKey[j] = StreamUtils.readBoolean(is);
        }
        this.hasFlag = StreamUtils.readUnsignedByte(is);
        if (this.nVersion >= 277) {
            this.nBlueTeam = StreamUtils.readShort(is);
            this.nRedTeam = StreamUtils.readShort(is);
            for (j = 0; j < 12; ++j) {
                StreamUtils.readUnsignedByte(is);
            }
        }
        for (j = 0; j < 7; ++j) {
            this.damageShift[j] = StreamUtils.readInt(is);
        }
        this.currentWeapon = StreamUtils.readByte(is);
        this.updateWeapon = StreamUtils.readByte(is);
        this.weaponTimer = StreamUtils.readInt(is);
        this.weaponState = StreamUtils.readInt(is);
        this.weaponAmmo = StreamUtils.readInt(is);
        for (j = 0; j < 14; ++j) {
            this.hasWeapon[j] = StreamUtils.readBoolean(is);
        }
        for (j = 0; j < 14; ++j) {
            this.weaponMode[j] = StreamUtils.readInt(is);
        }
        for (j = 0; j < 14; ++j) {
            this.weaponOrder[0][j] = StreamUtils.readInt(is);
        }
        for (j = 0; j < 14; ++j) {
            this.weaponOrder[1][j] = StreamUtils.readInt(is);
        }
        for (j = 0; j < 12; ++j) {
            this.ammoCount[j] = StreamUtils.readInt(is);
        }
        this.fLoopQAV = StreamUtils.readBoolean(is);
        this.fuseTime = StreamUtils.readInt(is);
        this.fireClock = StreamUtils.readInt(is);
        this.throwTime = StreamUtils.readInt(is);
        this.aim.set(StreamUtils.readInt(is), StreamUtils.readInt(is), StreamUtils.readInt(is));
        this.relAim.set(StreamUtils.readInt(is), StreamUtils.readInt(is), StreamUtils.readInt(is));
        this.nAimSprite = StreamUtils.readInt(is);
        this.aimCount = StreamUtils.readInt(is);
        for (j = 0; j < 16; ++j) {
            this.aimSprites[j] = StreamUtils.readShort(is);
        }
        this.deathTime = StreamUtils.readInt(is);
        for (j = 0; j < 49; ++j) {
            this.powerUpTimer[j] = StreamUtils.readInt(is);
        }
        this.fragCount = StreamUtils.readInt(is);
        for (j = 0; j < 8; ++j) {
            this.fragInfo[j] = StreamUtils.readInt(is);
        }
        this.teamID = StreamUtils.readInt(is);
        this.fraggerID = StreamUtils.readInt(is);
        this.airTime = StreamUtils.readInt(is);
        this.bloodTime = StreamUtils.readInt(is);
        this.gooTime = StreamUtils.readInt(is);
        this.wetTime = StreamUtils.readInt(is);
        this.bubbleTime = StreamUtils.readInt(is);
        StreamUtils.readInt(is);
        this.stayTime = StreamUtils.readInt(is);
        this.kickTime = StreamUtils.readInt(is);
        this.pLaughsCount = StreamUtils.readInt(is);
        this.TurnAround = StreamUtils.readInt(is);
        this.godMode = StreamUtils.readBoolean(is);
        this.fScreamed = StreamUtils.readBoolean(is);
        this.pJump = StreamUtils.readBoolean(is);
        this.showInventory = StreamUtils.readInt(is);
        this.choosedInven = StreamUtils.readInt(is);
        for (j = 0; j < 5; ++j) {
            this.Inventory[j].activated = StreamUtils.readBoolean(is);
            this.Inventory[j].amount = StreamUtils.readInt(is);
        }
        for (j = 0; j < 3; ++j) {
            this.ArmorAmount[j] = StreamUtils.readInt(is);
        }
        this.voodooTarget = StreamUtils.readInt(is);
        this.voodooCount = StreamUtils.readInt(is);
        this.voodooAng = StreamUtils.readInt(is);
        this.voodooUnk = StreamUtils.readInt(is);
        this.explosion = StreamUtils.readInt(is);
        this.tilt = StreamUtils.readInt(is);
        this.visibility = StreamUtils.readInt(is);
        this.hitEffect = StreamUtils.readInt(is);
        this.blindEffect = StreamUtils.readInt(is);
        this.drownEffect = StreamUtils.readInt(is);
        this.handCount = StreamUtils.readInt(is);
        this.handDamage = StreamUtils.readBoolean(is);
        this.pickupEffect = StreamUtils.readInt(is);
        this.fireEffect = StreamUtils.readInt(is);
        this.quakeTime = StreamUtils.readInt(is);
        return this;
    }

    @Override
    public PLAYER writeObject(OutputStream os) throws IOException {
        int j;
        StreamUtils.writeInt(os, this.NPSTART);
        StreamUtils.writeInt(os, this.pWeaponQAV);
        StreamUtils.writeInt(os, this.weaponCallback);
        StreamUtils.writeByte(os, this.Run ? 1 : 0);
        StreamUtils.writeInt(os, this.moveState);
        StreamUtils.writeInt(os, this.moveDist);
        StreamUtils.writeInt(os, this.bobAmp);
        StreamUtils.writeInt(os, this.bobPhase);
        StreamUtils.writeInt(os, this.bobHeight);
        StreamUtils.writeInt(os, this.bobWidth);
        StreamUtils.writeInt(os, this.swayAmp);
        StreamUtils.writeInt(os, this.swayPhase);
        StreamUtils.writeInt(os, this.swayHeight);
        StreamUtils.writeInt(os, this.swayWidth);
        StreamUtils.writeInt(os, this.nPlayer);
        StreamUtils.writeInt(os, this.nSprite);
        StreamUtils.writeInt(os, this.nLifeMode);
        StreamUtils.writeInt(os, this.bloodlust);
        StreamUtils.writeInt(os, this.viewOffZ);
        StreamUtils.writeInt(os, this.viewOffdZ);
        StreamUtils.writeInt(os, this.weaponAboveZ);
        StreamUtils.writeInt(os, this.weapOffdZ);
        if (this.nVersion < 300) {
            StreamUtils.writeInt(os, (int)this.look);
            StreamUtils.writeInt(os, (int)this.horiz);
        } else {
            StreamUtils.writeFloat(os, this.look);
            StreamUtils.writeFloat(os, this.horiz);
        }
        StreamUtils.writeInt(os, this.slope);
        if (this.nVersion < 300) {
            StreamUtils.writeInt(os, (int)this.horizOff);
        } else {
            StreamUtils.writeFloat(os, this.horizOff);
        }
        StreamUtils.writeByte(os, this.Underwater ? 1 : 0);
        for (j = 0; j < 8; ++j) {
            StreamUtils.writeByte(os, this.hasKey[j] ? 1 : 0);
        }
        StreamUtils.writeByte(os, (byte)this.hasFlag);
        if (this.nVersion >= 277) {
            StreamUtils.writeShort(os, this.nBlueTeam);
            StreamUtils.writeShort(os, this.nRedTeam);
            for (j = 0; j < 12; ++j) {
                StreamUtils.writeByte(os, 0);
            }
        }
        for (j = 0; j < 7; ++j) {
            StreamUtils.writeInt(os, this.damageShift[j]);
        }
        StreamUtils.writeByte(os, (byte)this.currentWeapon);
        StreamUtils.writeByte(os, (byte)this.updateWeapon);
        StreamUtils.writeInt(os, this.weaponTimer);
        StreamUtils.writeInt(os, this.weaponState);
        StreamUtils.writeInt(os, this.weaponAmmo);
        for (j = 0; j < 14; ++j) {
            StreamUtils.writeByte(os, this.hasWeapon[j] ? 1 : 0);
        }
        for (j = 0; j < 14; ++j) {
            StreamUtils.writeInt(os, this.weaponMode[j]);
        }
        for (j = 0; j < 14; ++j) {
            StreamUtils.writeInt(os, this.weaponOrder[0][j]);
        }
        for (j = 0; j < 14; ++j) {
            StreamUtils.writeInt(os, this.weaponOrder[1][j]);
        }
        for (j = 0; j < 12; ++j) {
            StreamUtils.writeInt(os, this.ammoCount[j]);
        }
        StreamUtils.writeByte(os, this.fLoopQAV ? 1 : 0);
        StreamUtils.writeInt(os, this.fuseTime);
        StreamUtils.writeInt(os, this.fireClock);
        StreamUtils.writeInt(os, this.throwTime);
        StreamUtils.writeInt(os, (int)this.aim.x);
        StreamUtils.writeInt(os, (int)this.aim.y);
        StreamUtils.writeInt(os, (int)this.aim.z);
        StreamUtils.writeInt(os, (int)this.relAim.x);
        StreamUtils.writeInt(os, (int)this.relAim.y);
        StreamUtils.writeInt(os, (int)this.relAim.z);
        StreamUtils.writeInt(os, this.nAimSprite);
        StreamUtils.writeInt(os, this.aimCount);
        for (j = 0; j < 16; ++j) {
            StreamUtils.writeShort(os, (short)this.aimSprites[j]);
        }
        StreamUtils.writeInt(os, this.deathTime);
        for (j = 0; j < 49; ++j) {
            StreamUtils.writeInt(os, this.powerUpTimer[j]);
        }
        StreamUtils.writeInt(os, this.fragCount);
        for (j = 0; j < 8; ++j) {
            StreamUtils.writeInt(os, this.fragInfo[j]);
        }
        StreamUtils.writeInt(os, this.teamID);
        StreamUtils.writeInt(os, this.fraggerID);
        StreamUtils.writeInt(os, this.airTime);
        StreamUtils.writeInt(os, this.bloodTime);
        StreamUtils.writeInt(os, this.gooTime);
        StreamUtils.writeInt(os, this.wetTime);
        StreamUtils.writeInt(os, this.bubbleTime);
        StreamUtils.writeInt(os, 0L);
        StreamUtils.writeInt(os, this.stayTime);
        StreamUtils.writeInt(os, this.kickTime);
        StreamUtils.writeInt(os, this.pLaughsCount);
        StreamUtils.writeInt(os, this.TurnAround);
        StreamUtils.writeByte(os, this.godMode ? 1 : 0);
        StreamUtils.writeByte(os, this.fScreamed ? 1 : 0);
        StreamUtils.writeByte(os, this.pJump ? 1 : 0);
        StreamUtils.writeInt(os, this.showInventory);
        StreamUtils.writeInt(os, this.choosedInven);
        for (j = 0; j < 5; ++j) {
            StreamUtils.writeByte(os, this.Inventory[j].activated ? 1 : 0);
            StreamUtils.writeInt(os, this.Inventory[j].amount);
        }
        for (j = 0; j < 3; ++j) {
            StreamUtils.writeInt(os, this.ArmorAmount[j]);
        }
        StreamUtils.writeInt(os, this.voodooTarget);
        StreamUtils.writeInt(os, this.voodooCount);
        StreamUtils.writeInt(os, this.voodooAng);
        StreamUtils.writeInt(os, this.voodooUnk);
        StreamUtils.writeInt(os, this.explosion);
        StreamUtils.writeInt(os, this.tilt);
        StreamUtils.writeInt(os, this.visibility);
        StreamUtils.writeInt(os, this.hitEffect);
        StreamUtils.writeInt(os, this.blindEffect);
        StreamUtils.writeInt(os, this.drownEffect);
        StreamUtils.writeInt(os, this.handCount);
        StreamUtils.writeByte(os, this.handDamage ? 1 : 0);
        StreamUtils.writeInt(os, this.pickupEffect);
        StreamUtils.writeInt(os, this.fireEffect);
        StreamUtils.writeInt(os, this.quakeTime);
        return this;
    }
}

