/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.PriorityQueue;

import java.io.IOException;
import java.io.OutputStream;
import java.util.PriorityQueue;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.PriorityQueue.IPriorityQueue;
import ru.m210projects.Blood.PriorityQueue.PriorityItem;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.StreamUtils;

public class JPriorityQueue
extends PriorityQueue<PriorityItem>
implements IPriorityQueue {
    private static final long serialVersionUID = 1L;
    private final int kPQueueSize;
    private final PriorityItem[] qList;
    private final PriorityItem[] queueArray;

    public JPriorityQueue(int size) {
        super(size);
        this.kPQueueSize = size;
        this.qList = new PriorityItem[size];
        this.queueArray = new PriorityItem[size];
        for (int i = 0; i < size; ++i) {
            this.qList[i] = new PriorityItem(0L, 0);
        }
    }

    @Override
    public void flush() {
        this.clear();
        for (int i = 0; i < this.qList.length; ++i) {
            this.qList[i].isFree = true;
        }
    }

    @Override
    public void Insert(long time, int event) {
        if (this.size() >= this.kPQueueSize) {
            throw new AssertException("fNodeCount < kPQueueSize");
        }
        int fNodeCount = 0;
        while (!this.qList[fNodeCount].isFree) {
            ++fNodeCount;
        }
        this.qList[fNodeCount].priority = time;
        this.qList[fNodeCount].event = event;
        this.qList[fNodeCount].isFree = false;
        this.add(this.qList[fNodeCount]);
    }

    @Override
    public int Remove() {
        PriorityItem item = (PriorityItem)this.remove();
        item.isFree = true;
        return item.event;
    }

    @Override
    public void checkList(int nIndex, int nType) {
        int i = 0;
        PriorityItem[] priorityList = this.toArray(this.queueArray);
        while (i < this.size()) {
            PriorityItem item = priorityList[i];
            if (nIndex == EVENT.getIndex(item.event) && nType == EVENT.getType(item.event)) {
                item.isFree = true;
                this.remove(item);
                priorityList = this.toArray(this.queueArray);
                continue;
            }
            ++i;
        }
    }

    @Override
    public void checkList(int nIndex, int nType, int funcId) {
        int i = 0;
        PriorityItem[] priorityList = this.toArray(this.queueArray);
        while (i < this.size()) {
            PriorityItem item = priorityList[i];
            if (nIndex == EVENT.getIndex(item.event) && nType == EVENT.getType(item.event) && funcId == EVENT.getFuncID(item.event)) {
                item.isFree = true;
                this.remove(item);
                priorityList = this.toArray(this.queueArray);
                continue;
            }
            ++i;
        }
    }

    @Override
    public boolean Check(long time) {
        return this.size() > 0 && time >= ((PriorityItem)this.element()).priority;
    }

    @Override
    public PriorityItem getItem(int i) {
        return this.toArray(this.queueArray)[i];
    }

    @Override
    public void writeObject(OutputStream os) throws IOException {
        int size = this.getSize();
        PriorityItem[] priorityList = this.toArray(this.queueArray);
        StreamUtils.writeInt(os, size + 1);
        StreamUtils.writeInt(os, 0L);
        StreamUtils.writeInt(os, 0L);
        for (int i = 0; i < size; ++i) {
            PriorityItem item = priorityList[i];
            StreamUtils.writeInt(os, (int)item.priority);
            StreamUtils.writeInt(os, item.event);
        }
    }

    @Override
    public int getSize() {
        return this.size();
    }
}

