/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.XSECTOR;
import ru.m210projects.Blood.Types.XWALL;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sector;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.art.ArtEntry;

public class SECTORFX {
    public static final int kPanScale = 10;
    public static final int kWaveNone = 0;
    public static final int kWaveSquare = 1;
    public static final int kWaveSaw = 2;
    public static final int kWaveRampup = 3;
    public static final int kWaveRampdown = 4;
    public static final int kWaveSine = 5;
    public static final int kWaveFlicker1 = 6;
    public static final int kWaveFlicker2 = 7;
    public static final int kWaveFlicker3 = 8;
    public static final int kWaveFlicker4 = 9;
    public static final int kWaveStrobe = 10;
    public static final int kWaveSearch = 11;
    public static final int[] flicker1 = new int[]{0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1};
    public static final int[] flicker2 = new int[]{1, 2, 4, 2, 3, 4, 3, 2, 0, 0, 1, 2, 4, 3, 2, 0, 2, 1, 0, 1, 0, 2, 3, 4, 3, 2, 1, 1, 2, 0, 0, 1, 1, 2, 3, 4, 4, 3, 2, 1, 2, 3, 4, 4, 2, 1, 0, 1, 0, 0, 0, 0, 1, 2, 3, 4, 3, 2, 1, 2, 3, 4, 3, 2};
    public static final int[] flicker3 = new int[]{4, 4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 2, 4, 3, 4, 4, 4, 4, 2, 1, 3, 3, 3, 4, 3, 4, 4, 4, 4, 4, 2, 4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 2, 1, 0, 1, 0, 1, 0, 1, 0, 2, 3, 4, 4, 4, 4, 4, 4, 4, 3, 4};
    public static final int[] flicker4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 3, 0, 1, 0, 1, 0, 4, 4, 4, 4, 4, 2, 0, 0, 0, 0, 4, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 2, 1, 2, 1, 2, 1, 2, 1, 4, 3, 2};
    public static final int[] strobe = new int[]{64, 64, 64, 48, 36, 27, 20, 15, 11, 9, 6, 5, 4, 3, 2, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static short[] shadeList = new short[512];
    public static short[] panList = new short[512];
    public static int shadeCount = 0;
    public static int panCount = 0;
    public static short[] wallPanList = new short[512];
    public static int wallPanCount = 0;

    public static void InitSectorFX() {
        int i;
        shadeCount = 0;
        panCount = 0;
        wallPanCount = 0;
        for (i = 0; i < Main.boardService.getSectorCount(); ++i) {
            short nXSector = Main.boardService.getSector(i).getExtra();
            if (nXSector <= 0) continue;
            XSECTOR pXSector = DB.xsector[nXSector];
            if (pXSector.amplitude != 0) {
                SECTORFX.shadeList[SECTORFX.shadeCount++] = nXSector;
            }
            if (pXSector.panVel == 0) continue;
            SECTORFX.panList[SECTORFX.panCount++] = nXSector;
        }
        for (i = 0; i < Main.boardService.getWallCount(); ++i) {
            short nXWall = Main.boardService.getWall(i).getExtra();
            if (nXWall <= 0) continue;
            XWALL pXWall = DB.xwall[nXWall];
            if (pXWall.panXVel == 0 && pXWall.panYVel == 0) continue;
            SECTORFX.wallPanList[SECTORFX.wallPanCount++] = nXWall;
        }
    }

    public static void DoSectorPanning() {
        int i;
        for (i = 0; i < panCount; ++i) {
            int panY;
            int panX;
            ArtEntry art;
            short nTile;
            short nXSector = panList[i];
            XSECTOR pXSector = DB.xsector[nXSector];
            int nSector = pXSector.reference;
            if (!Main.boardService.isValidSector(nSector)) {
                throw new AssertException("boardService.isValidSector(nSector)");
            }
            Sector pSector = Main.boardService.getSector(nSector);
            if (pSector.getExtra() != nXSector) {
                throw new AssertException("pSector.extra == nXSector");
            }
            if (!pXSector.panAlways && pXSector.busy == 0) continue;
            int panAngle = pXSector.panAngle + 1024;
            int panVel = (pXSector.panVel & 0xFF) << 10;
            if (!pXSector.panAlways && (pXSector.busy & 0xFFFF) != 0) {
                panVel = Pragmas.mulscale(panVel, pXSector.busy, 16);
            }
            if (pXSector.panFloor) {
                nTile = pSector.getFloorpicnum();
                art = Main.engine.getTile(nTile);
                if ((pSector.getFloorstat() & 0x40) != 0) {
                    panAngle -= 512;
                }
                panX = (pSector.getFloorxpanning() << 8) + pXSector.floorxpanFrac;
                panY = (pSector.getFloorypanning() << 8) + pXSector.floorypanFrac;
                int n = Pragmas.mulscale((long)Globals.kFrameTicks * (long)panVel, Trig.Sin(panAngle), 30);
                int n2 = art.getSizey();
                int n3 = (pSector.getFloorstat() & 8) != 0 ? 1 : 0;
                pSector.setFloorxpanning((byte)((panX += Pragmas.mulscale((long)Globals.kFrameTicks * (long)panVel, Trig.Cos(panAngle), 30) >> art.getSizex() - ((pSector.getFloorstat() & 8) != 0 ? 1 : 0)) >> 8));
                pSector.setFloorypanning((byte)((panY -= n >> n2 - n3) >> 8));
                pXSector.floorxpanFrac = panX & 0xFF;
                pXSector.floorypanFrac = panY & 0xFF;
            }
            if (!pXSector.panCeiling) continue;
            nTile = pSector.getCeilingpicnum();
            art = Main.engine.getTile(nTile);
            if ((pSector.getCeilingstat() & 0x40) != 0) {
                panAngle -= 512;
            }
            panX = (pSector.getCeilingxpanning() << 8) + pXSector.ceilxpanFrac;
            panY = (pSector.getCeilingypanning() << 8) + pXSector.ceilypanFrac;
            int n = Pragmas.mulscale((long)Globals.kFrameTicks * (long)panVel, Trig.Sin(panAngle), 30);
            int n4 = art.getSizey();
            int n5 = (pSector.getCeilingstat() & 8) != 0 ? 1 : 0;
            pSector.setCeilingxpanning((byte)((panX += Pragmas.mulscale((long)Globals.kFrameTicks * (long)panVel, Trig.Cos(panAngle), 30) >> art.getSizex() - ((pSector.getCeilingstat() & 8) != 0 ? 1 : 0)) >> 8));
            pSector.setCeilingypanning((byte)((panY += n >> n4 - n5) >> 8));
            pXSector.ceilxpanFrac = panX & 0xFF;
            pXSector.ceilypanFrac = panY & 0xFF;
        }
        for (i = 0; i < wallPanCount; ++i) {
            short nXWall = wallPanList[i];
            XWALL pXWall = DB.xwall[nXWall];
            int nWall = pXWall.reference;
            if (Main.boardService.getWall(nWall).getExtra() != nXWall) {
                throw new AssertException("boardService.getWall(nWall).extra == nXWall");
            }
            if (!pXWall.panAlways && pXWall.busy == 0) continue;
            int panXVel = pXWall.panXVel << 10;
            int panYVel = pXWall.panYVel << 10;
            if (!pXWall.panAlways && (pXWall.busy & 0xFFFF) != 0) {
                panXVel = Pragmas.mulscale(panXVel, pXWall.busy, 16);
                panYVel = Pragmas.mulscale(panYVel, pXWall.busy, 16);
            }
            short nTile = Main.boardService.getWall(nWall).getPicnum();
            ArtEntry art = Main.engine.getTile(nTile);
            int panX = (Main.boardService.getWall(nWall).getXpanning() << 8) + pXWall.xpanFrac;
            int panY = (Main.boardService.getWall(nWall).getYpanning() << 8) + pXWall.ypanFrac;
            Main.boardService.getWall(nWall).setXpanning((byte)((panX += Globals.kFrameTicks * panXVel >> art.getSizex()) >> 8));
            Main.boardService.getWall(nWall).setYpanning((byte)((panY += Globals.kFrameTicks * panYVel >> art.getSizey()) >> 8));
            pXWall.xpanFrac = panX & 0xFF;
            pXWall.ypanFrac = panY & 0xFF;
        }
    }

    public static int GetWaveValue(int nWave, long time, int freq, int amplitude) {
        switch (nWave) {
            case 0: {
                return amplitude;
            }
            case 1: {
                return (int)((time * (long)freq >> 10 & 1L) * (long)amplitude);
            }
            case 2: {
                return (int)(Pragmas.klabs(128L - (time * (long)freq >> 3 & 0xFFL)) * (long)amplitude >> 7);
            }
            case 3: {
                return (int)((time * (long)freq >> 3 & 0xFFL) * (long)amplitude >> 8);
            }
            case 4: {
                return (int)((255L - (time * (long)freq >> 3 & 0xFFL)) * (long)amplitude >> 8);
            }
            case 5: {
                return amplitude + Pragmas.mulscale(amplitude, Trig.Sin((int)(time * (long)freq)), 30) >> 1;
            }
            case 6: {
                return flicker1[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude;
            }
            case 7: {
                return flicker2[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude >> 2;
            }
            case 8: {
                return flicker3[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude >> 2;
            }
            case 9: {
                return flicker4[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude >> 2;
            }
            case 10: {
                return strobe[(int)(time * (long)freq >> 5 & 0x3FL)] * amplitude >> 6;
            }
            case 11: {
                int phi = (int)((time * (long)freq & 0x7FFL) << 2);
                if (phi > 2048) {
                    return 0;
                }
                return amplitude - Pragmas.mulscale(amplitude, Trig.Cos(phi), 30) >> 1;
            }
        }
        return 0;
    }

    public static void DoSectorLighting() {
        for (int i = 0; i < shadeCount; ++i) {
            int nWall;
            int endwall;
            int startwall;
            short ceilingpal;
            short pal;
            short floorpal;
            int value;
            short nXSector = shadeList[i];
            XSECTOR pXSector = DB.xsector[nXSector];
            int nSector = pXSector.reference;
            if (Main.boardService.getSector(nSector).getExtra() != nXSector) {
                throw new AssertException("boardService.getSector(nSector).extra == nXSector");
            }
            if (pXSector.shade != 0) {
                value = pXSector.shade;
                if (pXSector.shadeFloor) {
                    Main.boardService.getSector(nSector).setFloorshade(Main.boardService.getSector(nSector).getFloorshade() - value);
                    if (pXSector.color) {
                        floorpal = pXSector.floorpal;
                        pXSector.floorpal = pal = Main.boardService.getSector(nSector).getFloorpal();
                        Main.boardService.getSector(nSector).setFloorpal(floorpal);
                    }
                }
                if (pXSector.shadeCeiling) {
                    Main.boardService.getSector(nSector).setCeilingshade(Main.boardService.getSector(nSector).getCeilingshade() - value);
                    if (pXSector.color) {
                        ceilingpal = pXSector.ceilpal;
                        pXSector.ceilpal = pal = Main.boardService.getSector(nSector).getCeilingpal();
                        Main.boardService.getSector(nSector).setCeilingpal(ceilingpal);
                    }
                }
                if (pXSector.shadeWalls) {
                    startwall = Main.boardService.getSector(nSector).getWallptr();
                    endwall = startwall + Main.boardService.getSector(nSector).getWallnum() - 1;
                    for (nWall = startwall; nWall <= endwall; ++nWall) {
                        Main.boardService.getWall(nWall).setShade(Main.boardService.getWall(nWall).getShade() - value);
                        if (!pXSector.color) continue;
                        Main.boardService.getWall(nWall).setPal(Main.boardService.getSector(nSector).getFloorpal());
                    }
                }
                pXSector.shade = 0;
            }
            if (!pXSector.shadeAlways && pXSector.busy == 0) continue;
            short freq = pXSector.freq;
            short nWave = pXSector.wave;
            int amplitude = pXSector.amplitude;
            if (!pXSector.shadeAlways && pXSector.busy != 0) {
                amplitude = Pragmas.mulscale(amplitude, pXSector.busy, 16);
            }
            value = SECTORFX.GetWaveValue(nWave, Main.engine.getTotalClock() + pXSector.phase, freq, amplitude);
            if (pXSector.shadeFloor) {
                Main.boardService.getSector(nSector).setFloorshade((byte)Gameutils.ClipRange(Main.boardService.getSector(nSector).getFloorshade() + value, -128, 127));
                if (pXSector.color && value != 0) {
                    floorpal = pXSector.floorpal;
                    pXSector.floorpal = pal = Main.boardService.getSector(nSector).getFloorpal();
                    Main.boardService.getSector(nSector).setFloorpal(floorpal);
                }
            }
            if (pXSector.shadeCeiling) {
                Main.boardService.getSector(nSector).setCeilingshade((byte)Gameutils.ClipRange(Main.boardService.getSector(nSector).getCeilingshade() + value, -128, 127));
                if (pXSector.color && value != 0) {
                    ceilingpal = pXSector.ceilpal;
                    pXSector.ceilpal = pal = Main.boardService.getSector(nSector).getCeilingpal();
                    Main.boardService.getSector(nSector).setCeilingpal(ceilingpal);
                }
            }
            if (pXSector.shadeWalls) {
                startwall = Main.boardService.getSector(nSector).getWallptr();
                endwall = startwall + Main.boardService.getSector(nSector).getWallnum() - 1;
                for (nWall = startwall; nWall <= endwall; ++nWall) {
                    Main.boardService.getWall(nWall).setShade((byte)Gameutils.ClipRange(Main.boardService.getWall(nWall).getShade() + value, -128, 127));
                    if (!pXSector.color || value == 0) continue;
                    Main.boardService.getWall(nWall).setPal(Main.boardService.getSector(nSector).getFloorpal());
                }
            }
            pXSector.shade = value;
        }
    }
}

