/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.utils.BufferUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.AMBIENT;
import ru.m210projects.Blood.Types.SAMPLE2D;
import ru.m210projects.Blood.Types.SFX;
import ru.m210projects.Blood.Types.SOUNDEFFECT;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.filehandlers.BloodIniFile;
import ru.m210projects.Build.Architecture.common.audio.AudioChannel;
import ru.m210projects.Build.Architecture.common.audio.BuildAudio;
import ru.m210projects.Build.Architecture.common.audio.SoundData;
import ru.m210projects.Build.Architecture.common.audio.Source;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.collections.ListNode;
import ru.m210projects.Build.exceptions.AssertException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.Group;
import ru.m210projects.Build.filehandle.StreamUtils;
import ru.m210projects.Build.filehandle.rff.RffEntry;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.osd.OsdColor;

public class SOUND {
    public static final int BLUDSPLT = 385;
    private static final String TRACK = "blood%02d.ogg";
    public static final int MAXUSERTRACKS = 64;
    public static final int kSoundVel = Gameutils.M2X(280.0);
    public static final float kIntraAuralTime = 6.0E-4f;
    public static final int kIntraAuralDist = (int)(3.0E-4f * (float)kSoundVel);
    public static final int kBackFilter = 16384;
    public static final int kVolScale = 80;
    public static final int kMaxAmbients = 16;
    public static final int kMaxChannels = 32;
    public static final int kMaxSources = 256;
    public static final int[] sndRate = new int[]{11025, 11025, 11025, 11025, 11025, 22050, 22050, 22050, 22050, 44100, 44100, 44100, 44100};
    public static String[] usertrack = new String[64];
    public static SFX[] pSFXs = new SFX[65536];
    public static int nSndEffect;
    public static SOUNDEFFECT[] soundEffect;
    public static SAMPLE2D[] Channel;
    public static int earX0;
    public static int earX;
    public static int earY0;
    public static int earY;
    public static int earZ0;
    public static int earZ;
    public static int earVX;
    public static int earVY;
    public static int earVZ;
    public static int earVolume;
    public static int earVelocity;
    public static AMBIENT[] ambient;
    public static int numambients;
    public static int currTrack;
    public static BloodIniFile currEpisode;
    public static String currSong;
    public static Music currMusic;
    private static BuildAudio audio;

    public static void sndHandlePause(boolean gPaused) {
        if (gPaused) {
            if (currMusic != null) {
                currMusic.pause();
            }
            SOUND.stopAllSounds();
        } else if (!Main.cfg.isMuteMusic() && currMusic != null) {
            currMusic.play();
        }
    }

    public static SoundData.Decoder getSoundDecoder(String extension) {
        return audio.getSoundDecoder(extension);
    }

    public static boolean sndLoadSound(int soundId) {
        if (soundId < 0) {
            return false;
        }
        if (pSFXs[soundId] == null) {
            Entry dat = Main.game.getCache().getEntry(soundId, "SFX");
            if (dat.exists()) {
                try {
                    SOUND.pSFXs[soundId] = new SFX(dat);
                }
                catch (IOException e) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (SOUND.pSFXs[soundId].hResource == null) {
            String rawName = SOUND.pSFXs[soundId].rawName + "." + "RAW";
            Entry fp = Main.game.getCache().getEntry(rawName, true);
            if (fp.exists()) {
                int size = (int)fp.getSize();
                SOUND.pSFXs[soundId].hResource = ByteBuffer.allocateDirect(size);
                SOUND.pSFXs[soundId].hResource.put(fp.getBytes());
                SOUND.pSFXs[soundId].hResource.rewind();
                SOUND.pSFXs[soundId].size = size;
            } else {
                return false;
            }
        }
        return true;
    }

    public static void sfxStart3DSound(Sprite pSprite, int soundId, int nChannel, int flags) {
        if (Main.cfg.isNoSound()) {
            return;
        }
        if (pSprite != null && soundId >= 0) {
            if (!SOUND.sndLoadSound(soundId)) {
                return;
            }
            SFX pEffect = pSFXs[soundId];
            if (pEffect.size <= 0) {
                return;
            }
            int nPitch = Pragmas.mulscale(SOUND.sndGetSampleRate(pEffect.format), pEffect.pitch, 16);
            SOUNDEFFECT pSource = null;
            if (nChannel < 0) {
                if (nSndEffect >= 256) {
                    return;
                }
                pSource = soundEffect[nSndEffect++];
                pSource.pSprite = null;
            } else {
                int i;
                for (i = 0; i < nSndEffect; ++i) {
                    pSource = soundEffect[i];
                    if (nChannel != pSource.channel || pSprite != pSource.pSprite && (flags & 1) == 0) continue;
                    if (pSource.hVoice != null && ((flags & 4) != 0 && nChannel == pSource.channel || (flags & 2) != 0 && soundId == pSource.soundId)) {
                        return;
                    }
                    if (pSource.hVoice == null) break;
                    pSource.hVoice.stop();
                    break;
                }
                if (i == nSndEffect) {
                    if (nSndEffect >= 256) {
                        return;
                    }
                    pSource = soundEffect[nSndEffect++];
                }
                pSource.pSprite = pSprite;
                pSource.channel = nChannel;
            }
            pSource.x = pSprite.getX();
            pSource.y = pSprite.getY();
            pSource.z = pSprite.getZ();
            pSource.nSector = pSprite.getSectnum();
            pSource.oldX = pSource.x;
            pSource.oldY = pSource.y;
            pSource.oldZ = pSource.z;
            pSource.soundId = soundId;
            pSource.relVol = pEffect.relVol;
            pSource.nPitch = nPitch;
            SOUND.Calc3DValues(pSource);
            int nPriority = 1;
            if (nPriority < earVolume) {
                nPriority = earVolume;
            }
            int loopStart = pEffect.loopStart;
            if (nChannel < 0) {
                loopStart = -1;
            }
            ByteBuffer pRaw = pEffect.hResource;
            pRaw.rewind();
            boolean global = pSprite == Globals.gPlayer[View.gViewIndex].pSprite;
            pSource.hVoice = SOUND.newSound(pRaw, global ? pSource.nPitch : earVelocity, 8, nPriority);
            if (pSource.hVoice != null) {
                pSource.hVoice.setListener(pSource);
                if (global) {
                    pSource.pSprite = Globals.gPlayer[View.gViewIndex].pSprite;
                } else {
                    SOUND.setPosition(pSource);
                }
                if (loopStart >= 0) {
                    pSource.hVoice.loop((float)earVolume / 255.0f, loopStart, Gameutils.ClipLow(pEffect.size - 1, 0));
                } else {
                    pSource.hVoice.play((float)earVolume / 255.0f);
                }
            }
        }
    }

    public static void sfxStart3DSoundCP(Sprite pSprite, int soundId, int nChannel, int flags, long pitch, int volume) {
        if (Main.cfg.isNoSound()) {
            return;
        }
        if (pSprite != null && soundId >= 0) {
            if (!SOUND.sndLoadSound(soundId)) {
                return;
            }
            SFX pEffect = pSFXs[soundId];
            pitch = pitch <= 0L ? (long)pEffect.pitch : (pitch -= (long)Gameutils.BiRandom(pEffect.pitchrange));
            if (pEffect.size <= 0) {
                return;
            }
            int nPitch = Pragmas.mulscale(SOUND.sndGetSampleRate(pEffect.format), pitch, 16);
            SOUNDEFFECT pSource = null;
            if (nChannel < 0) {
                if (nSndEffect >= 256) {
                    return;
                }
                pSource = soundEffect[nSndEffect++];
                pSource.pSprite = null;
            } else {
                int i;
                for (i = 0; i < nSndEffect; ++i) {
                    pSource = soundEffect[i];
                    if (nChannel != pSource.channel || pSprite != pSource.pSprite && (flags & 1) == 0) continue;
                    if (pSource.hVoice != null && ((flags & 4) != 0 && nChannel == pSource.channel || (flags & 2) != 0 && soundId == pSource.soundId)) {
                        return;
                    }
                    if (pSource.hVoice == null) break;
                    pSource.hVoice.stop();
                    break;
                }
                if (i == nSndEffect) {
                    if (nSndEffect >= 256) {
                        return;
                    }
                    pSource = soundEffect[nSndEffect++];
                }
                pSource.pSprite = pSprite;
                pSource.channel = nChannel;
            }
            pSource.x = pSprite.getX();
            pSource.y = pSprite.getY();
            pSource.z = pSprite.getZ();
            pSource.nSector = pSprite.getSectnum();
            pSource.oldX = pSource.x;
            pSource.oldY = pSource.y;
            pSource.oldZ = pSource.z;
            pSource.soundId = soundId;
            pSource.relVol = volume == 0 ? pEffect.relVol : (volume == -1 ? 0 : Math.min(volume, 255));
            pSource.nPitch = nPitch;
            SOUND.Calc3DValues(pSource);
            int nPriority = 1;
            if (nPriority < earVolume) {
                nPriority = earVolume;
            }
            int loopStart = pEffect.loopStart;
            if (nChannel < 0) {
                loopStart = -1;
            }
            ByteBuffer pRaw = pEffect.hResource;
            pRaw.rewind();
            boolean global = pSprite == Globals.gPlayer[View.gViewIndex].pSprite;
            pSource.hVoice = SOUND.newSound(pRaw, global ? pSource.nPitch : earVelocity, 8, nPriority);
            if (pSource.hVoice != null) {
                pSource.hVoice.setListener(pSource);
                if (global) {
                    pSource.pSprite = Globals.gPlayer[View.gViewIndex].pSprite;
                } else {
                    SOUND.setPosition(pSource);
                }
                if (loopStart >= 0) {
                    pSource.hVoice.loop((float)earVolume / 255.0f, loopStart, Gameutils.ClipLow(pEffect.size - 1, 0));
                } else {
                    pSource.hVoice.play((float)earVolume / 255.0f);
                }
            }
        }
    }

    public static void sfxCreate3DSound(int x, int y, int z, int soundId, int nSector) {
        if (Main.cfg.isNoSound()) {
            return;
        }
        if (!Main.boardService.isValidSector(nSector)) {
            return;
        }
        if (soundId < 0) {
            throw new AssertException("Invalid sound ID: " + soundId);
        }
        if (!SOUND.sndLoadSound(soundId)) {
            return;
        }
        SFX pEffect = pSFXs[soundId];
        if (pEffect.size <= 0) {
            return;
        }
        int nPitch = Pragmas.mulscale(SOUND.sndGetSampleRate(pEffect.format), pEffect.pitch, 16);
        if (nSndEffect < 256) {
            SOUNDEFFECT pSoundEffect = soundEffect[nSndEffect++];
            pSoundEffect.pSprite = null;
            pSoundEffect.x = x;
            pSoundEffect.y = y;
            pSoundEffect.z = z;
            pSoundEffect.nSector = nSector;
            Gameutils.FindSector(x, y, z, (short)pSoundEffect.nSector);
            pSoundEffect.nSector = Gameutils.foundSector;
            pSoundEffect.oldX = pSoundEffect.x;
            pSoundEffect.oldY = pSoundEffect.y;
            pSoundEffect.oldZ = pSoundEffect.z;
            pSoundEffect.soundId = soundId;
            pSoundEffect.relVol = pEffect.relVol;
            pSoundEffect.nPitch = nPitch;
            pSoundEffect.format = pEffect.format;
            ByteBuffer pRaw = pEffect.hResource;
            pRaw.rewind();
            SOUND.Calc3DValues(pSoundEffect);
            int nPriority = 1;
            if (nPriority < earVolume) {
                nPriority = earVolume;
            }
            pSoundEffect.hVoice = SOUND.newSound(pRaw, earVelocity, 8, nPriority);
            if (pSoundEffect.hVoice != null) {
                SOUND.setPosition(pSoundEffect);
                pSoundEffect.hVoice.setListener(pSoundEffect);
                pSoundEffect.hVoice.play((float)earVolume / 255.0f);
            }
        }
    }

    public static void setPosition(SOUNDEFFECT pSoundEffect) {
        pSoundEffect.hVoice.setPosition(pSoundEffect.x, pSoundEffect.z >> 4, pSoundEffect.y);
    }

    public static void Calc3DValues(SOUNDEFFECT pSource) {
        if (Main.cfg.isNoSound()) {
            return;
        }
        int dx = pSource.x - Globals.gPlayer[View.gViewIndex].pSprite.getX();
        int dy = pSource.y - Globals.gPlayer[View.gViewIndex].pSprite.getY();
        int dz = pSource.z - Globals.gPlayer[View.gViewIndex].pSprite.getZ();
        int nAngle = EngineUtils.getAngle(dx, dy);
        int dist = Gameutils.Dist3d(dx, dy, dz);
        dist = Gameutils.ClipLow((dist >> 3) + (dist >> 2), 64);
        int monoVol = Pragmas.muldiv(pSource.relVol, 80L, dist);
        dx = Trig.Cos(nAngle);
        dy = Trig.Sin(nAngle);
        earVolume = SOUND.Vol3d(nAngle - Globals.gPlayer[View.gViewIndex].pSprite.getAng(), monoVol);
        earVelocity = pSource.nPitch;
        int div = Pragmas.dmulscaler(dx, pSource.x - pSource.oldX, dy, pSource.y - pSource.oldY, 30) + 5853;
        int kVel = Pragmas.klabs(Pragmas.dmulscaler(dx, earVX, dy, earVY, 30) + 5853);
        if (div != 0) {
            earVelocity = Pragmas.muldiv(kVel, pSource.nPitch, div);
        }
    }

    public static int Vol3d(int nAngle, int vol) {
        return vol - Pragmas.mulscale(vol, 8192 - Pragmas.mulscale(8192L, Trig.Cos(nAngle), 30), 16);
    }

    public static void sfxResetListener() {
        earX0 = earX = Globals.gPlayer[View.gViewIndex].pSprite.getX();
        earY0 = earY = Globals.gPlayer[View.gViewIndex].pSprite.getY();
        earZ0 = earZ = Globals.gPlayer[View.gViewIndex].pSprite.getZ();
    }

    public static void sfxUpdate3DSounds() {
        if (Main.cfg.isNoSound() || nSndEffect >= 256) {
            return;
        }
        earX0 = earX;
        earY0 = earY;
        earZ0 = earZ;
        earX = Globals.gPlayer[View.gViewIndex].pSprite.getX();
        earY = Globals.gPlayer[View.gViewIndex].pSprite.getY();
        earZ = Globals.gPlayer[View.gViewIndex].pSprite.getZ();
        earVX = earX - earX0;
        earVY = earY - earY0;
        earVZ = earZ - earZ0;
        audio.setListener(earX0, earZ0 >> 4, earY0, Globals.gPlayer[View.gViewIndex].pSprite.getAng());
        for (int i = nSndEffect - 1; i >= 0; --i) {
            SOUNDEFFECT pSoundEffect = soundEffect[i];
            if (pSoundEffect.hVoice == null) {
                SOUND.SoundCallback(i);
                continue;
            }
            Sprite pSprite = pSoundEffect.pSprite;
            if (pSprite != null) {
                pSoundEffect.oldX = pSoundEffect.x;
                pSoundEffect.oldY = pSoundEffect.y;
                pSoundEffect.oldZ = pSoundEffect.z;
                pSoundEffect.x = pSprite.getX();
                pSoundEffect.y = pSprite.getY();
                pSoundEffect.z = pSprite.getZ();
                pSoundEffect.nSector = pSprite.getSectnum();
            }
            SOUND.Calc3DValues(pSoundEffect);
            if (pSoundEffect.hVoice == null || pSoundEffect.pSprite == Globals.gPlayer[View.gViewIndex].pSprite) continue;
            pSoundEffect.hVoice.setVolume((float)earVolume / 255.0f);
            float pitch = 0.0f;
            if (pSoundEffect.nPitch > 0) {
                pitch = (float)earVelocity / (float)pSoundEffect.nPitch;
            }
            pSoundEffect.hVoice.setPitch(pitch);
            SOUND.setPosition(pSoundEffect);
        }
    }

    public static void SoundCallback(int num) {
        SOUNDEFFECT pSoundEffect = soundEffect[num];
        pSoundEffect.clear();
        int tmp = nSndEffect - 1;
        SOUND.soundEffect[num] = soundEffect[tmp];
        SOUND.soundEffect[tmp] = pSoundEffect;
        nSndEffect = tmp;
    }

    public static void sfxKill3DSound(Sprite pSprite, int nChannel, int nSoundId) {
        int i = nSndEffect;
        while (--i >= 0) {
            SOUNDEFFECT pSoundEffect = soundEffect[i];
            if (pSprite != pSoundEffect.pSprite || nChannel >= 0 && nChannel != pSoundEffect.channel || nSoundId >= 0 && nSoundId != pSoundEffect.soundId || pSoundEffect.hVoice == null) continue;
            pSoundEffect.hVoice.stop();
        }
    }

    public static void sfxKillAll3DSounds() {
        int i = nSndEffect;
        while (--i >= 0) {
            SOUNDEFFECT pSoundEffect = soundEffect[i];
            if (pSoundEffect.hVoice == null) continue;
            pSoundEffect.hVoice.stop();
        }
    }

    public static void varsInit() {
        int i;
        nSndEffect = 0;
        Channel = new SAMPLE2D[32];
        for (i = 0; i < 32; ++i) {
            SOUND.Channel[i] = new SAMPLE2D();
        }
        soundEffect = new SOUNDEFFECT[256];
        for (i = 0; i < 256; ++i) {
            SOUND.soundEffect[i] = new SOUNDEFFECT();
        }
        ambient = new AMBIENT[16];
        for (i = 0; i < 16; ++i) {
            SOUND.ambient[i] = new AMBIENT();
        }
        numambients = 0;
    }

    public static void sndInit() {
        Main.cfg.setAudioDriver(Main.cfg.getAudioDriver());
        Main.cfg.setMidiDevice(Main.cfg.getMidiDevice());
        audio = Main.cfg.getAudio();
        SOUND.varsInit();
    }

    public static int sndGetSampleRate(int SND_FMT) {
        if (SND_FMT >= 13) {
            return 11025;
        }
        return sndRate[SND_FMT];
    }

    public static SAMPLE2D FindChannel() {
        for (int i = 31; i >= 0; --i) {
            if (SOUND.Channel[i].hResource != null) continue;
            return Channel[i];
        }
        return null;
    }

    public static void sndStopSound(SAMPLE2D pChannel) {
        if ((pChannel.loop & 1) != 0) {
            pChannel.loop &= 0xFFFFFFFE;
        }
        pChannel.hVoice.stop();
        pChannel.hVoice = null;
    }

    public static void sndStopAllSounds() {
        SOUND.sndStopAllSamples();
        SOUND.sndStopMusic();
        SOUND.sfxKillAll3DSounds();
        SOUND.ambStopAll();
        SOUND.stopAllSounds();
    }

    public static void sndStopAllSamples() {
        for (int i = 0; i < 32; ++i) {
            SAMPLE2D pChannel = Channel[i];
            if (pChannel.hVoice != null) {
                SOUND.sndStopSound(pChannel);
            }
            if (pChannel.hResource == null) continue;
            pChannel.hResource = null;
        }
    }

    public static void sndStartSample(int soundId, int nVol, int nChannel, boolean loop) {
        int sampleSize;
        if (Main.cfg.isNoSound()) {
            return;
        }
        if (nChannel < -1 || nChannel >= 32) {
            throw new AssertException("nChannel >= -1 && nChannel < kMaxChannels");
        }
        if (!SOUND.sndLoadSound(soundId)) {
            Console.out.println("Could not load sample" + (pSFXs[soundId] != null ? SOUND.pSFXs[soundId].rawName : Integer.valueOf(soundId)), OsdColor.RED);
            return;
        }
        SFX pEffect = pSFXs[soundId];
        if (pEffect.size <= 0) {
            return;
        }
        SAMPLE2D pChannel = nChannel == -1 ? SOUND.FindChannel() : Channel[nChannel];
        if (pChannel == null) {
            return;
        }
        if (pChannel.hVoice != null) {
            SOUND.sndStopSound(pChannel);
        }
        pChannel.hResource = pEffect.hResource;
        if (nVol < 0) {
            nVol = pEffect.relVol;
        }
        if ((sampleSize = pEffect.size) > 0) {
            ByteBuffer pRaw = pChannel.hResource;
            pRaw.rewind();
            if (nChannel < 0) {
                loop = false;
            }
            pChannel.hVoice = SOUND.newSound(pRaw, SOUND.sndGetSampleRate(pEffect.format), 8, 80 * nVol);
            if (pChannel.hVoice != null) {
                pChannel.loop &= 0xFFFFFFFE;
                pChannel.hVoice.setListener(pChannel);
                if (loop) {
                    int loopStart = pEffect.loopStart;
                    int loopEnd = Gameutils.ClipLow(sampleSize - 1, 0);
                    pChannel.loop |= 1;
                    pChannel.hVoice.loop((float)(80 * nVol) / 255.0f, loopStart, loopEnd);
                } else {
                    pChannel.hVoice.play((float)(80 * nVol) / 255.0f);
                }
            }
        }
    }

    public static void sndPreloadSounds() {
        Group sounds = Main.game.getCache().getGroup("sounds.rff");
        for (Entry res : sounds.getEntries()) {
            if (!(res instanceof RffEntry) || !res.isExtension("sfx")) continue;
            SOUND.sndLoadSound(((RffEntry)res).getId());
        }
    }

    public static void sndProcess() {
        if (Main.cfg.isNoSound()) {
            return;
        }
        for (SAMPLE2D sample2D : Channel) {
            if (sample2D.hVoice != null && sample2D.hVoice.isPlaying() || sample2D.hResource == null) continue;
            sample2D.hResource = null;
        }
    }

    public static void ambProcess() {
        if (Main.cfg.isNoSound() || !Main.game.isCurrentScreen(Main.gGameScreen) && !Main.game.isCurrentScreen(Main.gDemoScreen)) {
            return;
        }
        for (ListNode<Sprite> node = Main.boardService.getStatNode(12); node != null; node = node.getNext()) {
            int i = node.getIndex();
            BloodSprite pSprite = Main.boardService.getSprite(i);
            XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
            if (pXSprite == null || pXSprite.getState() == 0 || pSprite.getOwner() == -1) continue;
            int dx = pSprite.getX() - Globals.gPlayer[View.gViewIndex].pSprite.getX() >> 4;
            int dy = pSprite.getY() - Globals.gPlayer[View.gViewIndex].pSprite.getY() >> 4;
            int dz = pSprite.getZ() - Globals.gPlayer[View.gViewIndex].pSprite.getZ() >> 8;
            int dist = EngineUtils.sqrt(dx * dx + dy * dy + dz * dz);
            int volume = Pragmas.mulscale(pXSprite.getBusy(), pXSprite.getData4(), 16);
            int radius = Gameutils.ClipRange(volume + -volume * (dist - pXSprite.getData1()) / (pXSprite.getData2() - pXSprite.getData1()), 0, volume);
            SOUND.ambient[pSprite.getOwner()].volume += radius;
        }
        for (int nAmbient = 0; nAmbient < numambients; ++nAmbient) {
            AMBIENT pAmbient = ambient[nAmbient];
            int volume = pAmbient.volume;
            if (pAmbient.hVoice == null || !pAmbient.hVoice.isPlaying()) {
                if (volume > 0) {
                    pAmbient.hVoice = SOUND.newSound(pAmbient.pRaw, SOUND.sndGetSampleRate(pAmbient.format), 8, volume);
                    if (pAmbient.hVoice != null) {
                        pAmbient.hVoice.setListener(pAmbient);
                        pAmbient.hVoice.loop((float)volume / 255.0f, 0, pAmbient.nSize);
                    }
                }
            } else {
                pAmbient.hVoice.setVolume((float)volume / 255.0f);
                pAmbient.hVoice.setPriority(volume);
            }
            pAmbient.volume = 0;
        }
    }

    public static void ambStopAll() {
        for (int nAmbient = 0; nAmbient < numambients; ++nAmbient) {
            AMBIENT pAmbient = ambient[nAmbient];
            if (pAmbient.hVoice != null) {
                pAmbient.hVoice.stop();
            }
            pAmbient.clear();
        }
        numambients = 0;
    }

    public static void ambPrepare() {
        SOUND.ambStopAll();
        if (Main.cfg.isNoSound()) {
            return;
        }
        for (ListNode<Sprite> node = Main.boardService.getStatNode(12); node != null; node = node.getNext()) {
            int nAmbient;
            int i = node.getIndex();
            BloodSprite pSprite = Main.boardService.getSprite(i);
            XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
            if (pXSprite == null || pXSprite.getData2() <= pXSprite.getData1()) continue;
            for (nAmbient = 0; nAmbient < numambients && pXSprite.getData3() != SOUND.ambient[nAmbient].nSoundId; ++nAmbient) {
            }
            if (nAmbient != numambients) {
                pSprite.setOwner((short)nAmbient);
                continue;
            }
            if (numambients >= 16) continue;
            short soundId = pXSprite.getData3();
            if (!SOUND.sndLoadSound(soundId)) {
                Console.out.println("Missing sound #" + soundId + " used in ambient sound generator " + nAmbient, OsdColor.RED);
                continue;
            }
            SFX pEffect = pSFXs[soundId];
            if (pEffect.size <= 0) continue;
            int nSize = pEffect.size;
            pEffect.hResource.rewind();
            AMBIENT pAmbient = ambient[nAmbient];
            pAmbient.nSoundId = soundId;
            pAmbient.nSize = nSize;
            pAmbient.pRaw = pEffect.hResource;
            pAmbient.format = pEffect.format;
            pSprite.setOwner((short)nAmbient);
            ++numambients;
        }
    }

    public static void sndPlayMenu() {
        String himus;
        SOUND.sndStopMusic();
        if (Main.game.currentDef != null && (himus = Main.game.currentDef.audInfo.getDigitalInfo("mainmenu")) != null) {
            Music hisource;
            Entry entry = Main.game.getCache().getEntry(himus, true);
            if (!entry.exists()) {
                return;
            }
            int sign = 0;
            try (InputStream is = entry.getInputStream();){
                sign = StreamUtils.readInt(is);
            }
            catch (IOException e) {
                return;
            }
            if (sign == 1684558925 && (hisource = SOUND.newMusic(entry)) != null) {
                currMusic = hisource;
                currMusic.setLooping(true);
                currMusic.play();
            } else if (Main.cfg.getMusicType() != 0 && (hisource = SOUND.newMusic(entry)) != null) {
                currMusic = hisource;
                currMusic.setLooping(true);
                currMusic.play();
            }
        }
    }

    public static boolean sndPlayTrack(int nTrack) {
        if (Main.cfg.getMusicType() != 2) {
            return false;
        }
        if (currMusic != null && currMusic.isPlaying() && currTrack == Globals.pGameInfo.nTrackNumber && (Main.mUserFlag == Main.UserFlag.UserMap || Main.mUserFlag != Main.UserFlag.UserMap && LEVELS.currentEpisode.iniFile.equals(currEpisode))) {
            return true;
        }
        SOUND.sndStopMusic();
        if (nTrack > 0 && nTrack <= 64 && usertrack[nTrack - 1] != null && (currMusic = SOUND.newMusic(usertrack[nTrack - 1])) != null) {
            currTrack = nTrack;
            currEpisode = LEVELS.currentEpisode.iniFile;
            currMusic.setLooping(true);
            currMusic.play();
            return true;
        }
        currMusic = SOUND.newMusic(String.format(TRACK, nTrack));
        if (currMusic != null) {
            currTrack = nTrack;
            if (Main.mUserFlag != Main.UserFlag.UserMap) {
                currEpisode = LEVELS.currentEpisode.iniFile;
            }
            currMusic.setLooping(true);
            currMusic.play();
            return true;
        }
        return false;
    }

    public static void sndPlaySong(String name) {
        if (name == null || name.isEmpty()) {
            SOUND.sndStopMusic();
            return;
        }
        if (currMusic != null && currMusic.isPlaying() && currSong != null && currSong.equals(Globals.pGameInfo.zLevelSong)) {
            return;
        }
        SOUND.sndStopMusic();
        Entry entry = Main.game.getCache().getEntry(name + "." + "MID", true);
        if (!entry.exists()) {
            return;
        }
        currSong = name;
        currMusic = SOUND.newMusic(entry);
        if (currMusic != null) {
            currMusic.setLooping(true);
            currMusic.play();
        }
    }

    public static void sndPlayMusic() {
        String himus;
        if (Main.cfg.isMuteMusic()) {
            return;
        }
        if (Main.cfg.getMusicType() == 1 && Main.game.currentDef != null && (himus = Main.game.currentDef.audInfo.getDigitalInfo(Globals.pGameInfo.zLevelSong)) != null) {
            if (currMusic != null && currMusic.isPlaying() && currSong.equals(himus)) {
                return;
            }
            SOUND.sndStopMusic();
            currMusic = SOUND.newMusic(himus);
            if (currMusic != null) {
                currSong = himus;
                currMusic.setLooping(true);
                currMusic.play();
                return;
            }
        }
        if (!SOUND.sndPlayTrack(Globals.pGameInfo.nTrackNumber)) {
            SOUND.sndPlaySong(Globals.pGameInfo.zLevelSong);
        }
    }

    public static void sndStopMusic() {
        if (currMusic != null && currMusic.isPlaying()) {
            currMusic.stop();
        }
        currSong = null;
        currTrack = -1;
        currEpisode = null;
        currMusic = null;
    }

    private static ByteBuffer loadSample(String sampleName) {
        ByteBuffer buf = null;
        Entry res = Main.game.getCache().getEntry(sampleName, true);
        if (res.exists()) {
            try (InputStream is = res.getInputStream();){
                buf = ByteBuffer.allocateDirect((int)res.getSize());
                StreamUtils.readBuffer(is, buf);
            }
            catch (Exception e) {
                buf = ByteBuffer.allocateDirect(1);
            }
        }
        return buf;
    }

    public static void sndStartSample(String sampleName, int nVol, int nChannel) {
        ByteBuffer buf;
        if (Main.cfg.isNoSound()) {
            return;
        }
        if (sampleName.length() == 0) {
            return;
        }
        if (nChannel < -1 || nChannel >= 32) {
            throw new AssertException("nChannel >= -1 && nChannel < kMaxChannels");
        }
        SAMPLE2D pChannel = nChannel == -1 ? SOUND.FindChannel() : Channel[nChannel];
        if (pChannel == null) {
            return;
        }
        if (pChannel.hVoice != null) {
            SOUND.sndStopSound(pChannel);
        }
        if (!sampleName.contains(".")) {
            sampleName = sampleName + ".raw";
        }
        if ((buf = SOUND.loadSample(sampleName)) == null || buf.capacity() <= 0) {
            System.err.println("Could not load sample " + sampleName);
            return;
        }
        pChannel.hResource = buf;
        pChannel.hVoice = SOUND.newSound(buf, SOUND.sndGetSampleRate(1), 8, nVol);
        if (pChannel.hVoice != null) {
            pChannel.loop &= 0xFFFFFFFE;
            pChannel.hVoice.setListener(pChannel);
            pChannel.hVoice.play((float)nVol / 255.0f);
        }
    }

    public static void sndStartWAV(String sampleName, int nVol, int nChannel) {
        Entry entry;
        if (Main.cfg.isNoSound()) {
            return;
        }
        if (sampleName.length() == 0) {
            return;
        }
        if (nChannel < -1 || nChannel >= 32) {
            throw new AssertException("nChannel >= -1 && nChannel < kMaxChannels");
        }
        SAMPLE2D pChannel = nChannel == -1 ? SOUND.FindChannel() : Channel[nChannel];
        if (pChannel == null) {
            return;
        }
        if (pChannel.hVoice != null) {
            SOUND.sndStopSound(pChannel);
        }
        if (!(entry = Main.game.getCache().getEntry(sampleName, true)).exists()) {
            Console.out.println("Could not load wav file: " + sampleName, OsdColor.RED);
            return;
        }
        try (InputStream is = entry.getInputStream();){
            ByteBuffer pRaw = BufferUtils.newByteBuffer((int)entry.getSize());
            StreamUtils.readBuffer(is, pRaw);
            pChannel.hVoice = SOUND.newSound(pRaw, SOUND.sndGetSampleRate(8), 8, nVol);
            if (pChannel.hVoice != null) {
                pChannel.loop &= 0xFFFFFFFE;
                pChannel.hVoice.setListener(pChannel);
                pChannel.hVoice.play((float)nVol / 255.0f);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Source newSound(ByteBuffer buffer, int rate, int bits, int priority) {
        return (Source)audio.newSound(buffer, rate, bits, priority);
    }

    public static Source newSound(ByteBuffer buffer, int rate, int bits, int channel, int priority) {
        return (Source)audio.newSound(buffer, rate, bits, AudioChannel.parseChannel(channel), priority);
    }

    public static Music newMusic(Entry entry) {
        return audio.newMusic(entry);
    }

    public static Music newMusic(String filePath) {
        Entry entry = Main.game.cache.getEntry(filePath, true);
        return audio.newMusic(entry);
    }

    public static void stopAllSounds() {
        audio.stopAllSounds();
    }

    public static void setReverb(boolean enable, float delay) {
        audio.setReverb(enable, delay);
    }

    static {
        currTrack = -1;
        currEpisode = null;
        currSong = null;
        currMusic = null;
    }
}

