/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Screens;

import java.nio.file.Path;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Cheats;
import ru.m210projects.Blood.Config;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.EVENT;
import ru.m210projects.Blood.Factory.BloodMenuHandler;
import ru.m210projects.Blood.Factory.BloodRenderer;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.LOADSAVE;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Menus.MenuInterfaceSet;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.QAV;
import ru.m210projects.Blood.ResourceHandler;
import ru.m210projects.Blood.SECTORFX;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Screens.DemoScreen;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.Trigger;
import ru.m210projects.Blood.Types.DemoUtils;
import ru.m210projects.Blood.Types.INPUT;
import ru.m210projects.Blood.Types.MapInfo;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Blood.filehandlers.BloodIniFile;
import ru.m210projects.Build.EngineUtils;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.exceptions.WarningException;
import ru.m210projects.Build.filehandle.Entry;
import ru.m210projects.Build.filehandle.FileUtils;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.filehandle.art.DynamicArtEntry;
import ru.m210projects.Build.filehandle.fs.FileEntry;
import ru.m210projects.Build.input.GameKey;
import ru.m210projects.Build.input.GameProcessor;
import ru.m210projects.Build.net.Mmulti;
import ru.m210projects.Build.osd.Console;
import ru.m210projects.Build.settings.GameKeys;

public class GameScreen
extends GameAdapter {
    private final Main game;
    public int gNameShowTime;
    private int nonsharedtimer;

    public GameScreen(Main game) {
        super(game, Main.gLoadingScreen);
        this.game = game;
    }

    @Override
    public void ProcessFrame(BuildNet net) {
        this.nonsharedtimer = Main.engine.getTotalClock();
        short i = Mmulti.connecthead;
        while (i >= 0) {
            INPUT src = (INPUT)net.gFifoInput[net.gNetFifoTail & 0xFF][i];
            Globals.gPlayer[i].pInput.syncFlags = src.syncFlags;
            Globals.gPlayer[i].pInput.Forward = src.Forward;
            Globals.gPlayer[i].pInput.Turn = src.Turn;
            Globals.gPlayer[i].pInput.Strafe = src.Strafe;
            Globals.gPlayer[i].pInput.mlook = src.mlook;
            Globals.gPlayer[i].pInput.Run = src.Run;
            Globals.gPlayer[i].pInput.Jump = src.Jump;
            Globals.gPlayer[i].pInput.Crouch = src.Crouch;
            Globals.gPlayer[i].pInput.Shoot = src.Shoot;
            Globals.gPlayer[i].pInput.AltShoot = src.AltShoot;
            Globals.gPlayer[i].pInput.Lookup = src.Lookup;
            Globals.gPlayer[i].pInput.Lookdown = src.Lookdown;
            Globals.gPlayer[i].pInput.TurnAround = src.TurnAround;
            Globals.gPlayer[i].pInput.Use |= src.Use;
            Globals.gPlayer[i].pInput.InventoryLeft |= src.InventoryLeft;
            Globals.gPlayer[i].pInput.InventoryRight |= src.InventoryRight;
            Globals.gPlayer[i].pInput.InventoryUse |= src.InventoryUse;
            Globals.gPlayer[i].pInput.PrevWeapon |= src.PrevWeapon;
            Globals.gPlayer[i].pInput.NextWeapon |= src.NextWeapon;
            Globals.gPlayer[i].pInput.HolsterWeapon |= src.HolsterWeapon;
            Globals.gPlayer[i].pInput.LookCenter |= src.LookCenter;
            Globals.gPlayer[i].pInput.LookLeft = src.LookLeft;
            Globals.gPlayer[i].pInput.LookRight = src.LookRight;
            Globals.gPlayer[i].pInput.Pause |= src.Pause;
            Globals.gPlayer[i].pInput.Quit |= src.Quit;
            Globals.gPlayer[i].pInput.Restart |= src.Restart;
            Globals.gPlayer[i].pInput.CrouchMode = src.CrouchMode;
            Globals.gPlayer[i].pInput.LastWeapon = src.LastWeapon;
            Globals.gPlayer[i].pInput.UseBeastVision |= src.UseBeastVision;
            Globals.gPlayer[i].pInput.UseCrystalBall |= src.UseCrystalBall;
            Globals.gPlayer[i].pInput.UseJumpBoots |= src.UseJumpBoots;
            Globals.gPlayer[i].pInput.UseMedKit |= src.UseMedKit;
            if (src.newWeapon != 0) {
                Globals.gPlayer[i].pInput.newWeapon = src.newWeapon;
            }
            i = Mmulti.connectpoint2[i];
        }
        ++net.gNetFifoTail;
        net.CalcChecksum();
        i = Mmulti.connecthead;
        while (i >= 0) {
            if (Globals.gPlayer[i].pInput.Quit) {
                Globals.gPlayer[i].pInput.Quit = false;
                this.game.pNet.NetDisconnect(i);
                return;
            }
            if (Globals.gPlayer[i].pInput.Restart) {
                Globals.gPlayer[i].pInput.Restart = false;
                Main.gGameScreen.loadboard(Globals.pGameInfo.zLevelName, null);
                return;
            }
            if (Globals.gPlayer[i].pInput.Pause) {
                this.game.gPaused = !this.game.gPaused;
                this.sndHandlePause(this.game.gPaused);
                if (this.game.gPaused && Globals.pGameInfo.nGameType > 0 && Mmulti.numplayers > 1) {
                    View.viewSetMessage(this.game.net.gProfile[i].name + " paused the game", -1);
                }
                Globals.gPlayer[i].pInput.Pause = false;
            }
            i = Mmulti.connectpoint2[i];
        }
        if (this.game.gPaused || !this.game.isCurrentScreen(Main.gGameScreen) && !this.game.isCurrentScreen(Main.gDemoScreen)) {
            return;
        }
        if (this.game.isCurrentScreen(Main.gGameScreen) && Globals.pGameInfo.nGameType == 0 && (this.game.menu.gShowMenu || Console.out.isShowing())) {
            return;
        }
        i = Mmulti.connecthead;
        while (i >= 0) {
            View.viewBackupView(i);
            PLAYER.playerMove(Globals.gPlayer[i]);
            i = Mmulti.connectpoint2[i];
        }
        Trigger.trProcessBusy();
        EVENT.evProcess(Globals.gFrameClock);
        SeqHandling.seqProcess(Globals.kFrameTicks);
        SECTORFX.DoSectorPanning();
        Actor.actProcessSprites();
        Actor.actPostProcess();
        net.CorrectPrediction();
        SOUND.sndProcess();
        SOUND.ambProcess();
        SOUND.sfxUpdate3DSounds();
        ++Globals.gFrame;
        Globals.gFrameClock += Globals.kFrameTicks;
        if ((Globals.pGameInfo.uGameFlags & 1) != 0) {
            this.game.pNet.ready2send = false;
            SeqHandling.seqKillAll();
            if (this.game.isCurrentScreen(Main.gDemoScreen)) {
                return;
            }
            if ((Globals.pGameInfo.uGameFlags & 2) != 0) {
                if (Globals.pGameInfo.nGameType == 0) {
                    Runnable rEndGame = () -> {
                        this.game.resetState();
                        this.game.changeScreen(Main.gMenuScreen);
                        this.game.menu.mOpen(this.game.menu.mMenus[5], -1);
                    };
                    if (this.checkCutsceneB()) {
                        this.game.changeScreen(Main.gCutsceneScreen.setCallback(rEndGame).escSkipping(true));
                    } else {
                        rEndGame.run();
                    }
                } else {
                    this.game.Disconnect();
                }
                Globals.pGameInfo.uGameFlags &= 0xFFFFFFFC;
            } else {
                this.game.changeScreen(Main.gStatisticScreen);
            }
        }
    }

    @Override
    public void DrawWorld(float smooth) {
        View.viewDrawScreen(View.gViewIndex, (int)smooth);
    }

    @Override
    public void DrawHud(float smooth) {
        PLAYER gView = Globals.gPlayer[View.gViewIndex];
        if (gView == null || gView.pSprite == null) {
            return;
        }
        BloodRenderer renderer = this.game.getRenderer();
        int xdim = renderer.getWidth();
        int ydim = renderer.getHeight();
        if (View.gViewMode == 3 || View.gViewMode == 2) {
            short nSector = gView.pSprite.getSectnum();
            if (View.gViewPos == 0) {
                ArtEntry pic = Main.engine.getTile(2319);
                if ((!this.game.menu.gShowMenu || this.game.menu.getCurrentMenu() instanceof MenuInterfaceSet) && Main.cfg.gCrosshair) {
                    renderer.rotatesprite((int)((float)(View.viewCrossX - pic.getWidth() * 320 / xdim) * 65536.0f), (int)((float)(View.viewCrossY + pic.getHeight() * 240 / ydim) * 65536.0f), View.viewCrossZoom, 0, 2319, 0, 0, 8);
                }
                byte nShade = 0;
                int nPLU = 0;
                if (nSector != -1) {
                    nShade = Main.boardService.getSector(nSector).getFloorshade();
                    if (Main.boardService.getSector(nSector).getExtra() > 0 && DB.xsector[Main.boardService.getSector((int)nSector).getExtra()].color) {
                        nPLU = Main.boardService.getSector(nSector).getFloorpal();
                    }
                }
                int nZoom = 65536;
                if (Globals.SplitScreen) {
                    nZoom = 32768;
                }
                Weapon.WeaponDraw(gView, nShade, View.viewWeaponX, View.viewWeaponY, nPLU, nZoom);
                if (gView.pXsprite.getBurnTime() > 60) {
                    View.viewDrawBurn(gView.pXsprite.getBurnTime());
                }
            }
            if (PLAYER.inventoryCheck(gView, 1)) {
                renderer.rotatesprite(0, 0, 65536, 0, 2344, 0, 0, 282, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                renderer.rotatesprite(0x1400000, 0, 65536, 1024, 2344, 0, 0, 542, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                renderer.rotatesprite(0, 0xC80000, 65536, 0, 2344, 0, 0, 286, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                renderer.rotatesprite(0x1400000, 0xC80000, 65536, 1024, 2344, 0, 0, 538, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                if (Main.cfg.gDetail >= 4) {
                    renderer.rotatesprite(983040, 196608, 65536, 0, 2346, 32, 0, 283, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                    renderer.rotatesprite(0xD40000, 0x4D0000, 65536, 0, 2347, 32, 0, 539, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                }
            }
            if (PLAYER.powerupCheck(gView, 39) > 0) {
                renderer.rotatesprite(0, 0xC80000, 65536, 0, 2358, 0, 0, 286, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                renderer.rotatesprite(0x1400000, 0xC80000, 65536, 1024, 2358, 0, 0, 538, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
            }
            if (PLAYER.powerupCheck(gView, 21) > 0 && (Mmulti.numplayers > 1 || this.game.isCurrentScreen(Main.gGameScreen) && Globals.kFakeMultiplayer && Globals.nFakePlayers > 1)) {
                View.DoLensEffect((DynamicArtEntry)Main.engine.getTile(4077));
                renderer.setaspect(65536, 54613);
                int crysX = 280;
                int crysY = 35;
                int nLensPLU = 0;
                if (nSector != -1 && Actor.IsUnderwaterSector(nSector)) {
                    nLensPLU = 10;
                }
                renderer.rotatesprite(crysX << 16, crysY << 16, 53248, renderer.getType() == Renderer.RenderType.Software ? 512 : -1024, 4077, 0, nLensPLU, 6, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                renderer.rotatesprite(crysX - 1 << 16, crysY - 1 << 16, 53248, 0, 1683, 0, 0, 35, View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
                renderer.setview(View.gViewX0, View.gViewY0, View.gViewX1, View.gViewY1);
            }
        }
        if (View.gViewMode == 4 || View.gViewMode == 2) {
            char[] mode;
            if (View.gViewMode == 4) {
                renderer.clearview(0);
            }
            View.updateviewmap();
            int x = gView.pSprite.getX();
            int y = gView.pSprite.getY();
            float ang = gView.ang;
            if (Globals.gMapScrollMode) {
                x = View.scrollOX + Pragmas.mulscale(View.scrollX - View.scrollOX, View.smoothratio, 16);
                y = View.scrollOY + Pragmas.mulscale(View.scrollY - View.scrollOY, View.smoothratio, 16);
                ang = (float)View.scrollOAng + (ru.m210projects.Build.Gameutils.BClampAngle(View.scrollAng - View.scrollOAng + 1024) - 1024.0f) * (float)View.smoothratio / 65536.0f;
                mode = Strings.scrollmode;
            } else {
                x = PLAYER.gPrevView[View.gViewIndex].x + Pragmas.mulscale(x - PLAYER.gPrevView[View.gViewIndex].x, View.smoothratio, 16);
                y = PLAYER.gPrevView[View.gViewIndex].y + Pragmas.mulscale(y - PLAYER.gPrevView[View.gViewIndex].y, View.smoothratio, 16);
                ang = PLAYER.gPrevView[View.gViewIndex].ang + (ru.m210projects.Build.Gameutils.BClampAngle(ang - PLAYER.gPrevView[View.gViewIndex].ang + 1024.0f) - 1024.0f) * (float)View.smoothratio / 65536.0f;
                mode = Strings.followmode;
            }
            int oldSize = Main.cfg.gViewSize;
            View.viewResizeView(0);
            if (View.gViewMode == 4) {
                renderer.drawmapview(x, y, View.kMapZoom >> 1, (short)ang);
            }
            renderer.drawoverheadmap(x, y, View.kMapZoom >> 1, (short)ang);
            int tx = 315;
            int ty = 16;
            String mapname = Globals.boardfilename;
            if (Main.mUserFlag == Main.UserFlag.UserMap && LEVELS.gUserMapInfo.Title != null) {
                mapname = LEVELS.gUserMapInfo.Title;
            }
            String info = "E" + (Globals.pGameInfo.nEpisode + 1) + "M" + (Globals.pGameInfo.nLevel + 1) + ": " + mapname;
            this.game.getFont(3).drawTextScaled((Renderer)renderer, tx, ty, info, 1.0f, 0, 0, TextAlign.Right, Transparent.None, ConvertType.AlignRight, false);
            this.game.getFont(3).drawTextScaled((Renderer)renderer, tx, ty + 10, mode, 1.0f, 0, 0, TextAlign.Right, Transparent.None, ConvertType.AlignRight, false);
            View.viewResizeView(oldSize);
        }
        if (!this.game.menu.gShowMenu || this.game.menu.getCurrentMenu() instanceof MenuInterfaceSet) {
            if (!Globals.SplitScreen) {
                View.viewDrawHUD(gView);
            } else {
                View.viewDrawSplitHUD(gView);
            }
        }
        if (this.game.getProcessor().getBloodMessage().isCaptured()) {
            this.game.getProcessor().getBloodMessage().draw();
        }
        View.viewDisplayMessage(0);
        if (View.gPlayerIndex != -1 && View.gPlayerIndex != View.gViewIndex) {
            int hitDist;
            PLAYER pPlayer = Globals.gPlayer[View.gPlayerIndex];
            int plu = pPlayer.pSprite.getPal();
            if (plu == 13) {
                plu = 4;
            }
            this.game.getFont(4).drawTextScaled((Renderer)renderer, 160, 120, Gameutils.toCharArray(this.game.net.gProfile[View.gPlayerIndex].name), 1.0f, 0, plu, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
            if (Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1 && pPlayer.deathTime > 0 && pPlayer.pXsprite.getHealth() <= 0 && (hitDist = EngineUtils.qdist(gView.pSprite.getX() - pPlayer.pSprite.getX(), gView.pSprite.getY() - pPlayer.pSprite.getY()) >> 4) < 64) {
                int shade = 32 - (Main.engine.getTotalClock() & 0x3F);
                this.game.getFont(4).drawTextScaled((Renderer)renderer, 160, 130, Gameutils.toCharArray("Press \"USE\" to revive player"), 1.0f, 0, shade, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
            }
        }
        if (Globals.pGameInfo.nReviveMode && Globals.pGameInfo.nGameType == 1 && gView.deathTime > 0 && gView.pXsprite.getHealth() <= 0) {
            int shade = 32 - (Main.engine.getTotalClock() & 0x3F);
            this.game.getFont(4).drawTextScaled((Renderer)renderer, 160, 130, Gameutils.toCharArray("Wait for revive or press \"USE\" to respawn"), 1.0f, 0, shade, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
        }
        if (this.game.gPaused) {
            this.game.getFont(1).drawTextScaled((Renderer)renderer, 160, 10, Strings.paused, 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
        }
        if (this.game.isCurrentScreen(Main.gGameScreen) && Globals.gFrameClock < this.gNameShowTime) {
            Transparent transp = Transparent.None;
            if (Main.engine.getTotalClock() > this.gNameShowTime - 20) {
                transp = Transparent.Bit2;
            }
            if (Main.engine.getTotalClock() > this.gNameShowTime - 10) {
                transp = Transparent.Bit1;
            }
            if (Main.cfg.showMapInfo != 0 && !this.game.menu.gShowMenu) {
                switch (Main.cfg.showMapInfo) {
                    case 1: {
                        if (Globals.boardfilename == null) break;
                        this.game.getFont(1).drawTextScaled((Renderer)renderer, 160, 60, Globals.boardfilename, 1.0f, -128, 0, TextAlign.Center, transp, ConvertType.Normal, true);
                        break;
                    }
                    case 2: {
                        if (Globals.boardfilename != null) {
                            this.game.getFont(3).drawTextScaled((Renderer)renderer, 160, 20, Globals.boardfilename, 1.0f, 0, 0, TextAlign.Center, transp, ConvertType.Normal, false);
                        }
                        if (LEVELS.currentEpisode == null || LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel] == null || LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel].Author == null) break;
                        this.game.getFont(3).drawTextScaled((Renderer)renderer, 160, 30, "by " + LEVELS.currentEpisode.gMapInfo[Globals.pGameInfo.nLevel].Author, 1.0f, 0, 0, TextAlign.Center, transp, ConvertType.Normal, false);
                    }
                }
            }
        }
        if (this.game.net.bOutOfSync) {
            this.game.getFont(3).drawTextScaled((Renderer)renderer, 160, 20, "Out of sync!", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
            switch (this.game.net.bOutOfSyncByte / 4) {
                case 0: {
                    this.game.getFont(3).drawTextScaled((Renderer)renderer, 160, 30, "bseed checksum error", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                    break;
                }
                case 1: {
                    this.game.getFont(3).drawTextScaled((Renderer)renderer, 160, 30, "player struct checksum error", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                    break;
                }
                case 2: {
                    this.game.getFont(3).drawTextScaled((Renderer)renderer, 160, 30, "player sprite checksum error", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                    break;
                }
                case 3: {
                    this.game.getFont(3).drawTextScaled((Renderer)renderer, 160, 30, "player xsprite checksum error", 1.0f, 0, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
                }
            }
        }
        if (gView.pSprite.getStatnum() == 6 && gView.handDamage) {
            int x = 160;
            int y = (gView.weaponAboveZ - gView.viewOffZ - 3072 >> 7) + 220;
            if (View.viewHandAnim.pQAV != null) {
                int oldFrameClock = Globals.gFrameClock;
                Globals.gFrameClock = Main.engine.getTotalClock();
                QAV pQAV = View.viewHandAnim.pQAV;
                pQAV.origin.x = x;
                pQAV.origin.y = y;
                int ticks = Main.engine.getTotalClock() - View.viewHandAnim.clock;
                View.viewHandAnim.clock = Main.engine.getTotalClock();
                View.viewHandAnim.duration -= ticks;
                if (View.viewHandAnim.duration <= 0 || View.viewHandAnim.duration > pQAV.duration) {
                    View.viewHandAnim.duration = pQAV.duration;
                }
                int t = pQAV.duration - View.viewHandAnim.duration;
                pQAV.Play(t - ticks, t, -1, null);
                pQAV.Draw(t, 0, 10, 0, 65536);
                Globals.gFrameClock = oldFrameClock;
            }
        }
    }

    @Override
    public void PostFrame(BuildNet net) {
        if (LOADSAVE.gQuickSaving) {
            if (this.captBuffer != null) {
                LOADSAVE.savegame(this.game.getUserDirectory(), "[quicksave_" + LOADSAVE.quickslot + "]", "quicksav" + LOADSAVE.quickslot + ".sav");
                LOADSAVE.quickslot ^= 1;
                LOADSAVE.gQuickSaving = false;
            } else {
                Main.gGameScreen.capture(320, 200);
            }
        }
        if (LOADSAVE.gAutosaveRequest) {
            if (this.captBuffer != null) {
                LOADSAVE.savegame(this.game.getUserDirectory(), "[autosave]", "autosave.sav");
                LOADSAVE.gAutosaveRequest = false;
            } else {
                Main.gGameScreen.capture(320, 200);
            }
        }
        Globals.fire.process();
        View.viewPaletteHandler(Globals.gPlayer[View.gViewIndex]);
    }

    protected boolean gameKeyDownCommon(GameKey gameKey, boolean inGame) {
        if (super.gameKeyDown(gameKey)) {
            return true;
        }
        BloodMenuHandler menu = this.game.menu;
        if (GameKeys.Menu_Toggle.equals(gameKey)) {
            if (inGame) {
                menu.mOpen(menu.mMenus[1], -1);
            } else {
                menu.mOpen(menu.mMenus[0], -1);
            }
            return true;
        }
        if (Config.BloodKeys.Show_LoadMenu.equals(gameKey)) {
            if (Mmulti.numplayers > 1) {
                return false;
            }
            menu.mOpen(menu.mMenus[7], -1);
            return true;
        }
        if (Config.BloodKeys.Show_SoundSetup.equals(gameKey)) {
            menu.mOpen(menu.mMenus[3], -1);
            return true;
        }
        if (Config.BloodKeys.Show_Options.equals(gameKey)) {
            menu.mOpen(menu.mMenus[15], -1);
            return true;
        }
        if (Config.BloodKeys.Toggle_messages.equals(gameKey)) {
            boolean bl = Main.cfg.MessageState = !Main.cfg.MessageState;
            if (Main.cfg.MessageState) {
                View.viewSetMessage("Messages on", View.gViewIndex, 2);
            }
            return true;
        }
        if (Config.BloodKeys.Quit.equals(gameKey)) {
            menu.mOpen(menu.mMenus[9], -1);
            return true;
        }
        if (Config.BloodKeys.Gamma.equals(gameKey)) {
            this.openGamma(menu);
            return true;
        }
        if (Config.BloodKeys.Make_Screenshot.equals(gameKey)) {
            this.makeScreenshot();
            return true;
        }
        return false;
    }

    @Override
    public void processInput(GameProcessor processor) {
        if (View.gViewMode != 3) {
            int j = Main.engine.getTotalClock() - this.nonsharedtimer;
            this.nonsharedtimer += j;
            if (processor.isGameKeyPressed(GameKeys.Shrink_Screen)) {
                View.kMapZoom = Gameutils.ClipLow(View.kMapZoom - Pragmas.mulscale(j, Math.max(View.kMapZoom, 256), 6), 16);
            }
            if (processor.isGameKeyPressed(GameKeys.Enlarge_Screen)) {
                View.kMapZoom = Gameutils.ClipHigh(View.kMapZoom + Pragmas.mulscale(j, Math.max(View.kMapZoom, 256), 6), 4096);
            }
        }
    }

    @Override
    public boolean gameKeyDown(GameKey gameKey) {
        if (this.gameKeyDownCommon(gameKey, true)) {
            return true;
        }
        BloodMenuHandler menu = this.game.menu;
        if (Config.BloodKeys.Show_SaveMenu.equals(gameKey)) {
            if (Mmulti.numplayers > 1) {
                return false;
            }
            if (Globals.gMe.pXsprite.getHealth() != 0) {
                Main.gGameScreen.capture(320, 200);
                menu.mOpen(menu.mMenus[8], -1);
            }
        }
        if (Config.BloodKeys.Quicksave.equals(gameKey)) {
            LOADSAVE.quicksave();
        }
        if (Config.BloodKeys.Quickload.equals(gameKey)) {
            LOADSAVE.quickload();
        }
        if (View.gViewMode == 3) {
            if (GameKeys.Shrink_Screen.equals(gameKey)) {
                View.viewResizeView(Main.cfg.gViewSize + 1);
            }
            if (GameKeys.Enlarge_Screen.equals(gameKey)) {
                View.viewResizeView(Main.cfg.gViewSize - 1);
            }
        }
        return false;
    }

    protected void makeScreenshot() {
        BloodRenderer renderer;
        String filename;
        String name = "scrxxxx.png";
        if (Main.mUserFlag == Main.UserFlag.UserMap && LEVELS.gUserMapInfo != null) {
            name = "scr-" + this.game.getFilename(LEVELS.gUserMapInfo.getName()) + "-xxxx.png";
        }
        if (Main.mUserFlag != Main.UserFlag.UserMap && LEVELS.currentEpisode != null) {
            name = "scr-e" + (Globals.pGameInfo.nEpisode + 1) + "m" + (Globals.pGameInfo.nLevel + 1) + "[" + LEVELS.currentEpisode.getIniName() + "]-xxxx.png";
        }
        if ((filename = (renderer = this.game.getRenderer()).screencapture(this.game.getUserDirectory(), name)) != null) {
            View.viewSetMessage(filename + " saved", View.gViewIndex, 10);
        } else {
            View.viewSetMessage("Screenshot not saved. Access denied!", View.gViewIndex, 7);
        }
    }

    protected void openGamma(BloodMenuHandler menu) {
        menu.mOpen(menu.mMenus[13], -1);
    }

    @Override
    public void sndHandlePause(boolean pause) {
        SOUND.sndHandlePause(pause);
    }

    @Override
    protected boolean prepareboard(Entry map) {
        this.gNameShowTime = 500;
        if (!(this instanceof DemoScreen)) {
            Main.gDemoScreen.onStopPlaying();
        }
        return DB.prepareboard(this);
    }

    public void newgame(boolean isMultiplayer, Object item, int episodeNum, int nLevel, int nGlobalDifficulty, int nEnemyQuantity, int nEnemyDamage, boolean nPitchforkOnly) {
        this.pNet.ready2send = false;
        this.game.changeScreen(this.load);
        this.load.init(() -> {
            Entry demoMapEntry;
            if (!isMultiplayer) {
                Globals.kFakeMultiplayer = false;
                if (Mmulti.numplayers > 1) {
                    this.pNet.NetDisconnect(Mmulti.myconnectindex);
                }
                Globals.pGameInfo.copy(Globals.defGameInfo);
                this.game.nNetMode = BuildGame.NetMode.Single;
            } else {
                Globals.pGameInfo.nGameType = Globals.pNetInfo.nGameType;
                Globals.pGameInfo.nEpisode = Globals.pNetInfo.nEpisode;
                Globals.pGameInfo.nLevel = Globals.pNetInfo.nLevel;
                Globals.pGameInfo.nDifficulty = Globals.pNetInfo.nDifficulty;
                Globals.pGameInfo.nMonsterSettings = Globals.pNetInfo.nMonsterSettings;
                Globals.pGameInfo.nWeaponSettings = Globals.pNetInfo.nWeaponSettings;
                Globals.pGameInfo.nItemSettings = Globals.pNetInfo.nItemSettings;
                Globals.pGameInfo.nFriendlyFire = Globals.pNetInfo.nFriendlyFire;
                Globals.pGameInfo.nReviveMode = Globals.pNetInfo.nReviveMode;
                Globals.pGameInfo.nEnemyQuantity = Globals.pNetInfo.nDifficulty;
                Globals.pGameInfo.nEnemyDamage = Globals.pNetInfo.nDifficulty;
                Globals.pGameInfo.nPitchforkOnly = false;
                Globals.pGameInfo.nFragLimit = Globals.pNetInfo.nFragLimit;
                this.game.nNetMode = BuildGame.NetMode.Multiplayer;
            }
            Main.UserFlag flag = Main.UserFlag.None;
            if (item instanceof BloodIniFile && !item.equals(Globals.MainINI)) {
                flag = Main.UserFlag.Addon;
                BloodIniFile ini = (BloodIniFile)item;
                ResourceHandler.checkEpisodeResources(ini);
                LEVELS.getEpisodeInfo(LEVELS.gUserEpisodeInfo, ini);
                Console.out.println("Start user episode: " + episodeNum);
            } else {
                ResourceHandler.resetEpisodeResources();
            }
            if (item instanceof FileEntry) {
                flag = Main.UserFlag.UserMap;
            }
            Main.mUserFlag = flag;
            if (flag == Main.UserFlag.UserMap) {
                FileEntry mLevelEntry = (FileEntry)item;
                if (!mLevelEntry.isExtension("map")) {
                    throw new WarningException("Not a map!");
                }
                MapInfo userMapInfo = LEVELS.getUserMapInfo(mLevelEntry);
                Globals.pGameInfo.nEpisode = 0;
                Globals.pGameInfo.nLevel = 16;
                Globals.pGameInfo.zLevelSong = userMapInfo.Song;
                Globals.pGameInfo.nTrackNumber = userMapInfo.Track;
                Globals.pGameInfo.zLevelName = mLevelEntry;
                LEVELS.currentEpisode = null;
                Console.out.println("Start user map: " + userMapInfo.Title);
            } else {
                LEVELS.loadMapInfo(episodeNum, nLevel);
            }
            if (DemoScreen.isDemoPlaying() && !Globals.pGameInfo.zLevelName.exists() && (demoMapEntry = DemoUtils.demfile.getGameInfo().zLevelName).getExtension().isEmpty()) {
                Path newPath = FileUtils.getPath(demoMapEntry.getName() + ".map", new String[0]);
                Globals.pGameInfo.zLevelName = this.game.getCache().getEntry(newPath, true);
            }
            Globals.pGameInfo.nDifficulty = nGlobalDifficulty;
            Globals.pGameInfo.nEnemyQuantity = nEnemyQuantity;
            Globals.pGameInfo.nEnemyDamage = nEnemyDamage;
            Globals.pGameInfo.nPitchforkOnly = nPitchforkOnly;
            Globals.pGameInfo.uGameFlags = 0;
            Globals.cheatsOn = false;
            PLAYER.playerGodMode(Globals.gMe, 0);
            Globals.gInfiniteAmmo = false;
            Globals.gFullMap = false;
            Cheats.cheatSubInventory(Globals.gMe);
            Globals.gNoClip = false;
            String title = this.getTitle();
            if (!this.hasCutsceneA(title)) {
                this.loadboard(Globals.pGameInfo.zLevelName, null).setTitle(title);
            }
        });
    }

    public void nextmap() {
        LEVELS.loadMapInfo(Globals.pGameInfo.nEpisode, LEVELS.gNextMap);
        String title = this.getTitle();
        if (!this.hasCutsceneA(title)) {
            this.loadboard(Globals.pGameInfo.zLevelName, null).setTitle(title);
        }
        if (Globals.pGameInfo.nGameType == 0) {
            LOADSAVE.gAutosaveRequest = true;
        }
    }

    @Override
    public GameAdapter setTitle(String title) {
        Globals.boardfilename = title;
        return super.setTitle(title);
    }

    private boolean hasCutsceneA(String loadTitle) {
        if (Globals.pGameInfo.nGameType != 0 || Globals.kFakeMultiplayer || Main.mUserFlag == Main.UserFlag.UserMap || !LEVELS.currentEpisode.hasCutsceneA(Globals.pGameInfo.nLevel) || this == Main.gDemoScreen) {
            return false;
        }
        if (Main.gCutsceneScreen.init(LEVELS.currentEpisode.CutSceneA, LEVELS.currentEpisode.CutWavA)) {
            Globals.pGameInfo.uGameFlags |= 4;
            Main.gCutsceneScreen.setCallback(() -> {
                Globals.pGameInfo.uGameFlags &= 0xFFFFFFFB;
                this.loadboard(Globals.pGameInfo.zLevelName, null).setTitle(loadTitle);
            }).escSkipping(true);
            this.game.changeScreen(Main.gCutsceneScreen);
            return true;
        }
        return false;
    }

    private boolean checkCutsceneB() {
        if (Globals.pGameInfo.nGameType != 0 || Globals.kFakeMultiplayer || Main.mUserFlag == Main.UserFlag.UserMap || !LEVELS.currentEpisode.hasCutsceneB(Globals.pGameInfo.nLevel) || this == Main.gDemoScreen) {
            return false;
        }
        return (Globals.pGameInfo.uGameFlags & 8) != 0 && Main.gCutsceneScreen.init(LEVELS.currentEpisode.CutSceneB, LEVELS.currentEpisode.CutWavB);
    }

    public String getTitle() {
        String title = "null";
        if (Main.mUserFlag != Main.UserFlag.UserMap) {
            if (Main.mUserFlag == Main.UserFlag.None) {
                title = this.getEpisodeTitle();
            } else if (Main.mUserFlag == Main.UserFlag.Addon && (title = this.getUserEpisodeTitle()) == null) {
                return "null";
            }
        } else {
            title = this.getMapTitle();
        }
        return title;
    }

    public String getUserEpisodeTitle() {
        if (LEVELS.gUserEpisodeInfo[Globals.pGameInfo.nEpisode] != null && LEVELS.gUserEpisodeInfo[Globals.pGameInfo.nEpisode].gMapInfo[Globals.pGameInfo.nLevel] != null) {
            return LEVELS.gUserEpisodeInfo[Globals.pGameInfo.nEpisode].gMapInfo[Globals.pGameInfo.nLevel].Title;
        }
        return null;
    }

    public String getEpisodeTitle() {
        if (LEVELS.gEpisodeInfo[Globals.pGameInfo.nEpisode].gMapInfo[Globals.pGameInfo.nLevel] != null) {
            return LEVELS.gEpisodeInfo[Globals.pGameInfo.nEpisode].gMapInfo[Globals.pGameInfo.nLevel].Title;
        }
        return null;
    }

    public String getMapTitle() {
        if (LEVELS.gUserMapInfo != null) {
            return LEVELS.gUserMapInfo.Title;
        }
        return null;
    }
}

