/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Screens;

import com.badlogic.gdx.Gdx;
import ru.m210projects.Blood.Factory.BloodEngine;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.SkippableAdapter;
import ru.m210projects.Build.Render.Renderer;

public class LogoScreen
extends SkippableAdapter {
    private final float gShowTime;
    private int nTile;
    private float gTicks;
    private Runnable callback;
    private final BloodEngine engine;

    public LogoScreen(BuildGame game, float gShowTime) {
        super(game);
        this.gShowTime = gShowTime;
        this.engine = Main.engine;
    }

    public LogoScreen setTile(int nTile) {
        this.nTile = nTile;
        return this;
    }

    public LogoScreen setCallback(Runnable callback) {
        this.callback = callback;
        this.setSkipping(callback);
        return this;
    }

    @Override
    public void show() {
        this.gTicks = 0.0f;
        SOUND.sndStopAllSounds();
        SOUND.sndStartSample(255, 128, 0, false);
        this.engine.getPaletteManager().setPalette(0);
        Screen.scrReset();
    }

    @Override
    public void draw(float delta) {
        float f;
        this.gTicks += delta;
        if (f >= this.gShowTime && this.callback != null && this.skipCallback != null) {
            Gdx.app.postRunnable(this.callback);
            this.callback = null;
        }
        Renderer renderer = this.game.getRenderer();
        renderer.clearview(0);
        renderer.rotatesprite(0xA00000, 0x640000, 65536, 0, this.nTile, 0, 0, 74);
    }
}

