/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Screens;

import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Factory.BloodSprite;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Types.DudeInfo;
import ru.m210projects.Blood.Types.Seq.SeqType;
import ru.m210projects.Blood.Types.XSPRITE;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.filehandlers.art.BloodArtEntry;
import ru.m210projects.Build.BoardService;
import ru.m210projects.Build.Pattern.ScreenAdapters.DefaultPrecacheScreen;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.listeners.PrecacheListener;
import ru.m210projects.Build.Types.AnimType;
import ru.m210projects.Build.Types.ConvertType;
import ru.m210projects.Build.Types.Sprite;
import ru.m210projects.Build.Types.Transparent;
import ru.m210projects.Build.Types.font.TextAlign;
import ru.m210projects.Build.filehandle.art.ArtEntry;
import ru.m210projects.Build.osd.Console;

public class PrecacheScreen
extends DefaultPrecacheScreen {
    public PrecacheScreen(Runnable toLoad, PrecacheListener listener) {
        super(Main.game, toLoad, listener);
        BoardService service = Main.engine.getBoardService();
        this.addQueue("Preload sounds...", SOUND::sndPreloadSounds);
        this.addQueue("Preload hud fonts...", () -> {
            for (int i = 0; i < 10; ++i) {
                this.tilePreloadTile(2190 + i);
                this.tilePreloadTile(2240 + i);
                this.tilePreloadTile(2230 + i);
                this.tilePreloadTile(2250 + i);
            }
        });
        this.addQueue("Preload floor and ceiling tiles...", () -> {
            int nSkyTile = -1;
            for (int i = 0; i < service.getSectorCount(); ++i) {
                this.tilePreloadTile(Main.boardService.getSector(i).getFloorpicnum());
                this.tilePreloadTile(Main.boardService.getSector(i).getCeilingpicnum());
                if ((Main.boardService.getSector(i).getCeilingstat() & 1) == 0 || nSkyTile != -1) continue;
                nSkyTile = Main.boardService.getSector(i).getCeilingpicnum();
            }
            this.doprecache(0);
            if (nSkyTile > -1 && nSkyTile < Globals.kMaxTiles) {
                for (int j = 1; j < DB.gSkyCount; ++j) {
                    this.tilePreloadTile(nSkyTile + j);
                }
            }
            this.doprecache(1);
        });
        this.addQueue("Preload wall tiles...", () -> {
            for (int i = 0; i < service.getWallCount(); ++i) {
                this.tilePreloadTile(Main.boardService.getWall(i).getPicnum());
                if (Main.boardService.getWall(i).getOverpicnum() < 0) continue;
                this.tilePreloadTile(Main.boardService.getWall(i).getOverpicnum());
            }
            this.doprecache(0);
        });
        this.addQueue("Preload sprite tiles...", () -> {
            int i;
            for (i = DudeInfo.dudeInfo[31].seqStartID; i <= DudeInfo.dudeInfo[31].seqStartID + 18; ++i) {
                this.SeqPreload(i);
            }
            for (i = 0; i < Main.boardService.getSpriteCount(); ++i) {
                int weap;
                int nTile;
                BloodSprite pSprite = Main.boardService.getSprite(i);
                if (pSprite == null) continue;
                if (pSprite.getStatnum() < 1024) {
                    if (pSprite.getStatnum() == 6) {
                        this.DudePrecache(pSprite);
                    } else if (pSprite.getStatnum() == 4) {
                        this.ThingPrecache(pSprite);
                    }
                    this.tilePreloadTile(pSprite.getPicnum());
                }
                XSPRITE pXSprite = Main.boardService.getXSprite(pSprite.getExtra());
                if (pSprite.getStatnum() == 1024 || pXSprite == null) continue;
                short nObject = pXSprite.getDropMsg();
                if (nObject >= 100 && nObject < 149) {
                    int item = pXSprite.getDropMsg() - 100;
                    if (item >= 0 && item < Actor.gItemInfo.length) {
                        nTile = Actor.gItemInfo[item].picnum;
                        this.tilePreloadTile(nTile);
                    }
                } else if (nObject >= 60 && nObject < 81) {
                    int ammo = pXSprite.getDropMsg() - 60;
                    if (ammo >= 0 && ammo < Actor.gAmmoItemData.length) {
                        nTile = Actor.gAmmoItemData[ammo].picnum;
                        this.tilePreloadTile(nTile);
                    }
                } else if (nObject >= 40 && nObject < 51 && (weap = pXSprite.getDropMsg() - 40) >= 0 && weap < Actor.gWeaponItemData.length) {
                    nTile = Actor.gWeaponItemData[weap].picnum;
                    this.tilePreloadTile(nTile);
                }
                if (pXSprite.getKey() <= 0 || pXSprite.getKey() >= 7) continue;
                int nTile2 = Actor.gItemInfo[pXSprite.getKey() - 1].picnum;
                this.tilePreloadTile(nTile2);
            }
            this.tilePreloadTile(Actor.gWeaponItemData[1].picnum);
            this.tilePreloadTile(Actor.gWeaponItemData[2].picnum);
            this.tilePreloadTile(Actor.gAmmoItemData[7].picnum);
            this.tilePreloadTile(Actor.gAmmoItemData[9].picnum);
            this.doprecache(1);
        });
        this.addQueue("Preload qav animation...", () -> {
            int kEnd = 126;
            if (VERSION.GAMEVER == 0) {
                kEnd = 118;
            }
            for (int i = 0; i < kEnd; ++i) {
                if (PLAYER.weaponQAVs[i] == null) continue;
                PLAYER.weaponQAVs[i].Preload(this);
            }
            if (!VERSION.SHAREWARE) {
                View.viewHandAnim.pQAV.Preload(this);
            }
            this.doprecache(1);
        });
        this.addQueue("Preload effects...", () -> {
            this.SeqPreload(3);
            this.SeqPreload(4);
            this.SeqPreload(5);
            this.SeqPreload(9);
            this.SeqPreload(55);
            this.SeqPreload(56);
            this.SeqPreload(11);
            this.SeqPreload(30);
            this.SeqPreload(0);
            this.SeqPreload(1);
            this.SeqPreload(60);
            this.SeqPreload(61);
            this.SeqPreload(62);
            this.SeqPreload(63);
            this.SeqPreload(64);
            this.SeqPreload(65);
            this.SeqPreload(66);
            this.SeqPreload(67);
            this.SeqPreload(44);
            this.SeqPreload(45);
            this.SeqPreload(46);
            this.SeqPreload(49);
            this.SeqPreload(50);
            this.SeqPreload(51);
            this.SeqPreload(52);
            this.SeqPreload(57);
            this.SeqPreload(58);
            this.SeqPreload(59);
            this.SeqPreload(7);
            this.SeqPreload(8);
            Console.out.println("Preload effects");
            for (int i = 0; i < 57; ++i) {
                this.tilePreloadTile(Actor.gEffectInfo[i].picnum);
            }
            this.doprecache(1);
        });
        this.addQueue("Preload projectiles...", () -> {
            this.tilePreloadTile(Actor.thingInfo[27].picnum);
            this.tilePreloadTile(Actor.thingInfo[28].picnum);
            this.tilePreloadTile(Actor.thingInfo[18].picnum);
            this.tilePreloadTile(Actor.thingInfo[19].picnum);
            this.tilePreloadTile(Actor.thingInfo[20].picnum);
            this.tilePreloadTile(Actor.thingInfo[1].picnum);
            this.tilePreloadTile(Actor.thingInfo[2].picnum);
            this.tilePreloadTile(Actor.gMissileData[1].picnum);
            this.tilePreloadTile(Actor.gMissileData[2].picnum);
            this.tilePreloadTile(Actor.gMissileData[6].picnum);
            this.doprecache(1);
        });
    }

    @Override
    public void draw(String title, int index) {
        View.viewShowLoadingTile();
        Renderer renderer = this.game.getRenderer();
        renderer.rotatesprite(0xA00000, 0x140000, 65536, 0, 2038, -128, 0, 78);
        this.game.getFont(1).drawTextScaled(renderer, 160, 13, Strings.loading, 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
        this.game.getFont(3).drawTextScaled(renderer, 160, 134, Strings.wait, 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
        String mapname = Main.gGameScreen.getTitle();
        if (mapname != null) {
            this.game.getFont(1).drawTextScaled(renderer, 160, 60, mapname, 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, true);
        }
        this.game.getFont(3).drawTextScaled(renderer, 160, 92, title, 1.0f, -128, 0, TextAlign.Center, Transparent.None, ConvertType.Normal, false);
    }

    private void SeqPreload(int nSeqID) {
        SeqType pSeq = SeqType.getInstance(nSeqID);
        if (pSeq != null && pSeq.getFrames() > 0) {
            for (int i = 0; i < pSeq.getFrames(); ++i) {
                this.tilePreloadTile(pSeq.getFrame((int)i).nTile);
            }
        }
    }

    private void DudePrecache(Sprite pSprite) {
        int type = pSprite.getLotag() - 200;
        this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID);
        this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 1);
        this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 2);
        this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 3);
        this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 5);
        switch (pSprite.getLotag()) {
            case 218: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 7);
                break;
            }
            case 250: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 4);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 8);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 10);
                break;
            }
            case 206: 
            case 207: 
            case 212: 
            case 219: 
            case 220: 
            case 227: 
            case 228: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 7);
                break;
            }
            case 201: 
            case 202: 
            case 247: 
            case 248: 
            case 249: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 3);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 4);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 7);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 8);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 9);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 13);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 14);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 15);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 17);
                this.SeqPreload(4099);
                this.SeqPreload(4111);
                this.SeqPreload(4112);
                break;
            }
            case 245: {
                this.SeqPreload(12551);
            }
            case 210: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 4);
            }
            case 208: 
            case 209: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                break;
            }
            case 217: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 7);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 9);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 10);
                break;
            }
            case 251: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 9);
                this.SeqPreload(2576);
            }
            case 211: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 4);
            }
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 229: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 7);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 8);
                break;
            }
            case 204: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 4);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 8);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 9);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 10);
                break;
            }
            case 203: 
            case 205: 
            case 244: {
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 4);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 6);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 7);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 8);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 11);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 13);
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 14);
                if (pSprite.getLotag() == 205) {
                    this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 9);
                    this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 12);
                }
                if (pSprite.getLotag() != 244) break;
                this.SeqPreload(DudeInfo.dudeInfo[type].seqStartID + 10);
            }
        }
    }

    private void ThingPrecache(Sprite pSprite) {
        switch (pSprite.getLotag()) {
            case 406: 
            case 407: {
                this.SeqPreload(12);
                break;
            }
            case 410: {
                this.SeqPreload(15);
                break;
            }
            case 411: {
                this.SeqPreload(21);
                break;
            }
            case 412: {
                this.SeqPreload(25);
                this.SeqPreload(26);
                break;
            }
            case 413: {
                this.SeqPreload(38);
                this.SeqPreload(40);
                this.SeqPreload(28);
                break;
            }
        }
    }

    public void tilePreloadTile(int nTile) {
        if (nTile < 0 || nTile >= Globals.kMaxTiles) {
            return;
        }
        ArtEntry art = Main.engine.getTile(nTile);
        if (art instanceof BloodArtEntry) {
            int view = 0;
            switch (((BloodArtEntry)art).getView()) {
                case kSpriteViewSingle: {
                    view = 1;
                    break;
                }
                case kSpriteView5Full: {
                    view = 5;
                    break;
                }
                case kSpriteView8Full: {
                    view = 8;
                    break;
                }
                case kSpriteView5Half: {
                    view = 2;
                    break;
                }
                case kSpriteViewVoxel: 
                case kSpriteViewSpinVoxel: {
                    Tile.tileLoadVoxel(nTile);
                    view = 1;
                    break;
                }
            }
            while (view > 0) {
                ArtEntry pic = Main.engine.getTile(nTile);
                if (pic.getType() != AnimType.NONE) {
                    for (int i = pic.getAnimFrames(); i >= 0; --i) {
                        if (pic.getType() == AnimType.BACKWARD) {
                            this.addTile(nTile - i);
                            continue;
                        }
                        this.addTile(nTile + i);
                    }
                } else {
                    this.addTile(nTile);
                }
                nTile += pic.getAnimFrames() + 1;
                --view;
            }
        }
    }
}

